/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.text.Normalizer;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class StringBuilders
extends Static {
    private static final String ASCII = "AAAAAA\u00c6CEEEEIIIIDNOOOOO*OUUUUY\u00desaaaaaa\u00e6ceeeeiiiionooooo/ouuuuy\u00fey";

    private StringBuilders() {
    }

    public static void replace(StringBuilder stringBuilder, char c, char c2) {
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        if (c != c2) {
            int n = stringBuilder.length();
            while (--n >= 0) {
                if (stringBuilder.charAt(n) != c) continue;
                stringBuilder.setCharAt(n, c2);
            }
        }
    }

    public static void replace(StringBuilder stringBuilder, String string, String string2) {
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        ArgumentChecks.ensureNonEmpty("toSearch", string);
        ArgumentChecks.ensureNonNull("replaceBy", string2);
        if (!string.equals(string2)) {
            int n = string.length();
            int n2 = stringBuilder.length();
            while ((n2 = stringBuilder.lastIndexOf(string, n2)) >= 0) {
                stringBuilder.replace(n2, n2 + n, string2);
                n2 -= n;
            }
        }
    }

    public static void replace(StringBuilder stringBuilder, int n, int n2, char[] cArray) {
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        ArgumentChecks.ensureNonNull("chars", cArray);
        int n3 = n2 - n;
        if (n < 0 || n3 < 0) {
            throw new StringIndexOutOfBoundsException(Errors.format((short)60, n, n2));
        }
        int n4 = cArray.length - n3;
        if (n4 < 0) {
            stringBuilder.delete(n2 + n4, n2);
            n3 = cArray.length;
        }
        for (int i = 0; i < n3; ++i) {
            stringBuilder.setCharAt(n++, cArray[i]);
        }
        if (n4 > 0) {
            stringBuilder.insert(n, cArray, n3, n4);
        }
    }

    public static void remove(StringBuilder stringBuilder, String string) {
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        ArgumentChecks.ensureNonEmpty("toSearch", string);
        int n = string.length();
        int n2 = stringBuilder.lastIndexOf(string);
        while (n2 >= 0) {
            stringBuilder.delete(n2, n2 + n);
            n2 = stringBuilder.lastIndexOf(string, n2);
        }
    }

    public static void repeat(StringBuilder stringBuilder, int n, char c, int n2) {
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                stringBuilder.insert(n, c);
                break;
            }
            default: {
                CharSequence charSequence;
                ArgumentChecks.ensurePositive("count", n2);
                switch (c) {
                    case ' ': {
                        charSequence = CharSequences.spaces(n2);
                        break;
                    }
                    case '0': {
                        charSequence = Repeat.ZERO;
                        break;
                    }
                    default: {
                        charSequence = new Repeat(c, n2);
                    }
                }
                stringBuilder.insert(n, charSequence, 0, n2);
                break;
            }
        }
    }

    public static void trimFractionalPart(StringBuilder stringBuilder) {
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        int n = stringBuilder.length();
        block4: while (n > 0) {
            switch (stringBuilder.charAt(--n)) {
                case '0': {
                    continue block4;
                }
                case '.': {
                    stringBuilder.setLength(n);
                }
            }
            return;
        }
    }

    public static void toASCII(StringBuilder stringBuilder) {
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        StringBuilders.toASCII(stringBuilder, stringBuilder);
    }

    static CharSequence toASCII(CharSequence charSequence, StringBuilder stringBuilder) {
        if (charSequence != null) {
            boolean bl = false;
            int n = charSequence.length();
            block14: while (n > 0) {
                char c;
                int n2 = Character.codePointBefore(charSequence, n);
                int n3 = Character.charCount(n2);
                int n4 = n2 - 192;
                n -= n3;
                if (n4 < 0) continue;
                if (n4 < ASCII.length()) {
                    c = ASCII.charAt(n4);
                } else {
                    block0 : switch (Character.getType(n2)) {
                        case 6: 
                        case 15: 
                        case 16: {
                            c = '\u0000';
                            break;
                        }
                        case 13: 
                        case 14: {
                            c = '\n';
                            break;
                        }
                        case 12: {
                            c = ' ';
                            break;
                        }
                        case 29: {
                            c = n2 == 8216 ? (char)'\'' : '\"';
                            break;
                        }
                        case 30: {
                            c = n2 == 8217 ? (char)'\'' : '\"';
                            break;
                        }
                        case 24: 
                        case 25: {
                            switch (n2) {
                                case 8901: {
                                    c = '*';
                                    break block0;
                                }
                                case 8725: {
                                    c = '/';
                                    break block0;
                                }
                                case 8242: {
                                    c = '\'';
                                    break block0;
                                }
                                case 8243: {
                                    c = '\"';
                                    break block0;
                                }
                            }
                            continue block14;
                        }
                        default: {
                            if (bl) continue block14;
                            bl = true;
                            String string = Normalizer.normalize(charSequence, Normalizer.Form.NFKD);
                            if (string.contentEquals(charSequence)) continue block14;
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder(string.length());
                                charSequence = stringBuilder;
                            } else {
                                stringBuilder.setLength(0);
                            }
                            n = stringBuilder.append(string).length();
                            continue block14;
                        }
                    }
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(charSequence.length()).append(charSequence);
                    charSequence = stringBuilder;
                }
                if (c == '\u0000') {
                    stringBuilder.delete(n, n + n3);
                    continue;
                }
                if (n3 == 2) {
                    stringBuilder.deleteCharAt(n + 1);
                }
                stringBuilder.setCharAt(n, c);
            }
        }
        return charSequence;
    }

    private static final class Repeat
    implements CharSequence {
        static final Repeat ZERO = new Repeat('0', Integer.MAX_VALUE);
        private final char c;
        private final int n;

        Repeat(char c, int n) {
            this.c = c;
            this.n = n;
        }

        @Override
        public int length() {
            return this.n;
        }

        @Override
        public char charAt(int n) {
            return this.c;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return new Repeat(this.c, n2 - n);
        }
    }
}

