/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk8;

import java.text.ParseException;
import java.util.Date;
import org.apache.sis.internal.jdk8.DateTimeException;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.jdk8.Temporal;
import org.apache.sis.internal.util.StandardDateFormat;

public final class Instant
extends Temporal {
    private static final StandardDateFormat parser = new StandardDateFormat();

    private Instant(long l) {
        super(l);
    }

    public static Instant create(Date date) {
        return date != null ? new Instant(date.getTime()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Instant parse(CharSequence charSequence) {
        Date date;
        try {
            StandardDateFormat standardDateFormat = parser;
            synchronized (standardDateFormat) {
                date = parser.parse(charSequence.toString());
            }
        }
        catch (ParseException parseException) {
            throw new DateTimeException(parseException.getMessage());
        }
        return new Instant(date.getTime());
    }

    public static Instant ofEpochMilli(long l) {
        return new Instant(l);
    }

    public long toEpochMilli() {
        return this.millis;
    }

    public Date toDate() {
        return new Date(this.millis);
    }

    public Instant plusNanos(long l) {
        return l == 0L ? this : new Instant(JDK8.addExact(this.millis, l / 1000000L));
    }

    public String toString() {
        return JDK8.printDateTime(this.toDate());
    }
}

