use utf8;
use strict;
use warnings;
use open qw( :encoding(UTF-8) :std );
use Test::More tests => 42;
use Lingua::Stem::UniNE::FA qw( stem );

note 'no test for: ',           'remove kasra';
is stem('فيروزآباد'), 'فيروز',  'remove suffix: ﺂﺑﺍﺩ';
is stem('رادرباره'),  'رادر',   'remove suffix: ﺏﺍﺮﻫ';
is stem('زمانبندی'),  'زمان',   'remove suffix: ﺐﻧﺩی';
is stem('زمانبندي'),  'زمان',   'remove suffix: ﺐﻧﺪﻳ';
is stem('بزرگترین'),  'بزرگ',   'remove suffix: ﺕﺭیﻥ';
is stem('بزرگترين'),  'بزرگ',   'remove suffix: ﺕﺮﻴﻧ';
is stem('آبروریزی'),  'آبرو',   'remove suffix: ﺭیﺯی';
note 'no test for: ',           'remove suffix: ﺮﻳﺰﻳ';
is stem('آزادسازی'),  'آزاد',   'remove suffix: ﺱﺍﺯی';
is stem('آزادسازي'),  'آزاد',   'remove suffix: ﺱﺍﺰﻳ';
is stem('بکارگیری'),  'بکار',   'remove suffix: گیﺭی';
is stem('بكارگيري'),  'بكار',   'remove suffix: گﻱﺮﻳ';
is stem('کشورهایی'),  'کشور',   'remove suffix: ﻩﺍیی';
is stem('كشورهايي'),  'كشور',   'remove suffix: ﻩﺎﻴﻳ';
is stem('فراخواند'),  'فراخو',  'remove suffix: ﺎﻧﺩ';
is stem('کارهایم'),   'کاره',   'remove suffix: ﺍیﻡ';
is stem('پارادايم'),  'پاراد',  'remove suffix: ﺎﻴﻣ';
is stem('برایشان'),   'برای',   'remove suffix: ﺵﺎﻧ';
is stem('کشورهای'),   'کشور',   'remove suffix: ﻩﺍی';
is stem('كشورهاي'),   'كشور',   'remove suffix: ﻩﺎﻳ';
is stem('سازمان'),    'ساز',    'remove suffix: ان';
is stem('انتخابات'),  'انتخاب', 'remove suffix: ات';
is stem('پرتلاش'),     'پرتل',   'remove suffix: اش';
is stem('الاسلام'),     'الاسل',   'remove suffix: ام';
is stem('بالاتر'),     'بالا',    'remove suffix: تر';
is stem('عاشورا'),    'عاشو',   'remove suffix: را';
is stem('میلیون'),    'میلی',   'remove suffix: ون';
is stem('کشورها'),    'کشور',   'remove suffix: ها';
note 'no test for: ',           'remove suffix: هء';
is stem('همچنین'),    'همچن',   'remove suffix: ین';
is stem('همچنين'),    'همچن',   'remove suffix: ين';
is stem('دولت'),      'دول',    'remove suffix: ت';
is stem('گزارش'),     'گزار',   'remove suffix: ش';
is stem('مردم'),      'مرد',    'remove suffix: م';
is stem('برنامه'),    'برنام',  'remove suffix: ه';
is stem('برای'),      'برا',    'remove suffix: ی';
is stem('براي'),      'برا',    'remove suffix: ي';
is stem('شهرستان'),   'شهرس',   'normalize: remove ت';
is stem('خبرنگاران'), 'خبرنگا', 'normalize: remove ر';
is stem('خودشان'),    'خود',    'normalize: remove ش';
is stem('نمایندگان'), 'نمایند', 'normalize: remove گ';
is stem('ساختمان'),   'ساخت',   'normalize: remove م';
note 'no test for: ',           'normalize: remove ى';
is stem('همسایگان'),  'همسا',   'normalize: remove ی';
is stem('همسايگان'),  'همسا',   'normalize: remove ي';
