/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

public class WebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    private static final Logger LOG = LogUtils.getL7dLogger(WebApplicationExceptionMapper.class);
    private static final String ERROR_MESSAGE_START = "WebApplicationException has been caught, status: ";
    private boolean printStackTrace = true;
    private boolean addMessageToResponse;

    @Override
    public Response toResponse(WebApplicationException ex) {
        String errorMessage;
        Response r = ex.getResponse();
        if (r == null) {
            r = Response.serverError().build();
        }
        boolean doAddMessage = r.getEntity() != null ? false : this.addMessageToResponse;
        Message msg = PhaseInterceptorChain.getCurrentMessage();
        FaultListener flogger = null;
        if (msg != null) {
            flogger = (FaultListener)PhaseInterceptorChain.getCurrentMessage().getContextualProperty(FaultListener.class.getName());
        }
        String string = errorMessage = doAddMessage || flogger != null ? this.buildErrorMessage(r, ex) : null;
        if (flogger == null || !flogger.faultOccurred(ex, errorMessage, msg)) {
            Level level = this.printStackTrace ? this.getStackTraceLogLevel(msg, r) : Level.FINE;
            LOG.log(level, ExceptionUtils.getStackTrace(ex));
        }
        if (doAddMessage) {
            r = JAXRSUtils.copyResponseIfNeeded(r);
            r = this.buildResponse(r, errorMessage);
        }
        return r;
    }

    protected Level getStackTraceLogLevel(Message msg, Response r) {
        if (r.getStatus() == 404) {
            Level logLevel = JAXRSUtils.getExceptionLogLevel(msg, NotFoundException.class);
            return logLevel == null ? Level.FINE : logLevel;
        }
        return Level.WARNING;
    }

    protected String buildErrorMessage(Response r, WebApplicationException ex) {
        String message;
        StringBuilder sb = new StringBuilder();
        sb.append(ERROR_MESSAGE_START).append(r.getStatus());
        Throwable cause = ex.getCause();
        String string = message = cause == null ? ex.getMessage() : cause.getMessage();
        if (message == null && cause != null) {
            message = "exception cause class: " + cause.getClass().getName();
        }
        if (message != null) {
            sb.append(", message: ").append(message);
        }
        return sb.toString();
    }

    protected Response buildResponse(Response response, String responseText) {
        Response.ResponseBuilder rb = JAXRSUtils.fromResponse(response);
        if (responseText != null) {
            rb.type("text/plain").entity(responseText);
        }
        return rb.build();
    }

    public void setPrintStackTrace(boolean printStackTrace) {
        this.printStackTrace = printStackTrace;
    }

    public void setAddMessageToResponse(boolean addMessageToResponse) {
        this.addMessageToResponse = addMessageToResponse;
    }
}

