/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.impl;

import com.epam.parso.CSVDataWriter;
import com.epam.parso.Column;
import com.epam.parso.DataWriterUtil;
import com.epam.parso.impl.AbstractCSVWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;

public class CSVDataWriterImpl
extends AbstractCSVWriter
implements CSVDataWriter {
    public CSVDataWriterImpl(Writer writer) {
        super(writer);
    }

    public CSVDataWriterImpl(Writer writer, String delimiter) {
        super(writer, delimiter);
    }

    public CSVDataWriterImpl(Writer writer, String delimiter, String endline) {
        super(writer, delimiter, endline);
    }

    public CSVDataWriterImpl(Writer writer, String delimiter, String endline, Locale locale) {
        super(writer, delimiter, endline, locale);
    }

    @Override
    public void writeRow(List<Column> columns, Object[] row) throws IOException {
        if (row == null) {
            return;
        }
        Writer writer = this.getWriter();
        List<String> valuesToPrint = DataWriterUtil.getRowValues(columns, row, this.getLocale());
        for (int currentColumnIndex = 0; currentColumnIndex < columns.size(); ++currentColumnIndex) {
            writer.write(CSVDataWriterImpl.checkSurroundByQuotes(this.getDelimiter(), valuesToPrint.get(currentColumnIndex)));
            if (currentColumnIndex == columns.size() - 1) continue;
            writer.write(this.getDelimiter());
        }
        writer.write(this.getEndline());
        writer.flush();
    }

    @Override
    public void writeRowsArray(List<Column> columns, Object[][] rows) throws IOException {
        for (Object[] currentRow : rows) {
            if (currentRow == null) break;
            this.writeRow(columns, currentRow);
        }
    }

    @Override
    public void writeColumnNames(List<Column> columns) throws IOException {
        Writer writer = this.getWriter();
        for (int i = 0; i < columns.size(); ++i) {
            CSVDataWriterImpl.checkSurroundByQuotesAndWrite(writer, this.getDelimiter(), columns.get(i).getName());
            if (i == columns.size() - 1) continue;
            writer.write(this.getDelimiter());
        }
        writer.write(this.getEndline());
        writer.flush();
    }
}

