package GCC::Builtins;

use 5.006;
use strict;
use warnings;

our $VERSION = '0.05';

our @ISA = (qw/Exporter DynaLoader/);
our %EXPORT_TAGS = ( 'all' => [qw( bswap16 bswap32 bswap64 clrsb clrsbl clrsbll clz clzl clzll ctz ctzl ctzll ffs ffsl ffsll huge_val huge_valf huge_vall inf infd128 infd32 infd64 inff infl nan nanf nanl parity parityl parityll popcount popcountl popcountll powi powif powil )] );
our @EXPORT_OK   = ( @{ $EXPORT_TAGS{'all'} } );

require DynaLoader;
__PACKAGE__->bootstrap($VERSION);

#########################################################################
#### WARNING: do not edit GCC/Buildins.pm or GCC/Buildins.xs
####          or typemap or t/6*.t files
####          they are auto-generated by me and all changes will be lost
#### EDIT all these here, they are in string vars
#### and then run sbin/build-gcc-builtins-package.pl
#### to update these files
#########################################################################

=pod

=encoding UTF-8

=head1 NAME

GCC::Builtins - access GCC compiler builtin functions via XS

=head1 VERSION

Version 0.05

=head1 SYNOPSIS

This module provides Perl access to GCC C compiler
builtin functions.

    use GCC::Builtins qw/:all/;
    # or use GCC::Builtins qw/ ... clz ... /;
    my $leading_zeros = GCC::Builtins::clz(10);
    # 28

=head1 EXPORT

=over 2

=item * C<uint16_t bswap16(uint16_t)>

=item * C<uint32_t bswap32(uint32_t)>

=item * C<uint64_t bswap64(uint64_t)>

=item * C<int clrsb(int)>

=item * C<int clrsbl(long)>

=item * C<int clrsbll(long long)>

=item * C<int clz(unsigned int)>

=item * C<int clzl(unsigned long)>

=item * C<int clzll(unsigned long long)>

=item * C<int ctz(unsigned int)>

=item * C<int ctzl(unsigned long)>

=item * C<int ctzll(unsigned long long)>

=item * C<int ffs(int)>

=item * C<int ffsl(long)>

=item * C<int ffsll(long long)>

=item * C<double huge_val()>

=item * C<float huge_valf()>

=item * C<long double huge_vall()>

=item * C<double inf()>

=item * C<_Decimal128 infd128()>

=item * C<_Decimal32 infd32()>

=item * C<_Decimal64 infd64()>

=item * C<float inff()>

=item * C<long double infl()>

=item * C<double nan(const char)>

=item * C<float nanf(const char)>

=item * C<long double nanl(const char)>

=item * C<int parity(unsigned int)>

=item * C<int parityl(unsigned long)>

=item * C<int parityll(unsigned long long)>

=item * C<int popcount(unsigned int)>

=item * C<int popcountl(unsigned long)>

=item * C<int popcountll(unsigned long long)>

=item * C<double powi(double,int)>

=item * C<float powif(float,int)>

=item * C<long double powil(long double,int)>



=back

Export tag C<:all> imports B<all> exportable functions, like:

  use GCC::Builtins qw/:all/;


=head1 SUBROUTINES

=head2 C<uint16_t bswap16(uint16_t)>

Returns x with the order of the bytes reversed; for example,
0xaabb becomes 0xbbaa.  Byte here always means
exactly 8 bits.


=head2 C<uint32_t bswap32(uint32_t)>

Similar to __builtin_bswap16, except the argument and return types
are 32-bit.


=head2 C<uint64_t bswap64(uint64_t)>

Similar to __builtin_bswap32, except the argument and return types
are 64-bit.


=head2 C<int clrsb(int)>

Returns the number of leading redundant sign bits in x, i.e. the
number of bits following the most significant bit that are identical
to it.  There are no special cases for 0 or other values. 


=head2 C<int clrsbl(long)>

Similar to __builtin_clrsb, except the argument type is
long.


=head2 C<int clrsbll(long long)>

Similar to __builtin_clrsb, except the argument type is
long long.


=head2 C<int clz(unsigned int)>

Returns the number of leading 0-bits in x, starting at the most
significant bit position.  If x is 0, the result is undefined.


=head2 C<int clzl(unsigned long)>

Similar to __builtin_clz, except the argument type is
unsigned long.


=head2 C<int clzll(unsigned long long)>

Similar to __builtin_clz, except the argument type is
unsigned long long.


=head2 C<int ctz(unsigned int)>

Returns the number of trailing 0-bits in x, starting at the least
significant bit position.  If x is 0, the result is undefined.


=head2 C<int ctzl(unsigned long)>

Similar to __builtin_ctz, except the argument type is
unsigned long.


=head2 C<int ctzll(unsigned long long)>

Similar to __builtin_ctz, except the argument type is
unsigned long long.


=head2 C<int ffs(int)>

Returns one plus the index of the least significant 1-bit of x, or
if x is zero, returns zero.


=head2 C<int ffsl(long)>

Similar to __builtin_ffs, except the argument type is
long.


=head2 C<int ffsll(long long)>

Similar to __builtin_ffs, except the argument type is
long long.


=head2 C<double huge_val()>

Returns a positive infinity, if supported by the floating-point format,
else DBL_MAX.  This function is suitable for implementing the
ISO C macro HUGE_VAL.


=head2 C<float huge_valf()>

Similar to __builtin_huge_val, except the return type is float.


=head2 C<long double huge_vall()>

Similar to __builtin_huge_val, except the return
type is long double.


=head2 C<double inf()>

Similar to __builtin_huge_val, except a warning is generated
if the target floating-point format does not support infinities.


=head2 C<_Decimal128 infd128()>

Similar to __builtin_inf, except the return type is _Decimal128.


=head2 C<_Decimal32 infd32()>

Similar to __builtin_inf, except the return type is _Decimal32.


=head2 C<_Decimal64 infd64()>

Similar to __builtin_inf, except the return type is _Decimal64.


=head2 C<float inff()>

Similar to __builtin_inf, except the return type is float.
This function is suitable for implementing the ISO C99 macro INFINITY.


=head2 C<long double infl()>

Similar to __builtin_inf, except the return
type is long double.


=head2 C<double nan(const char)>

This is an implementation of the ISO C99 function nan.


=head2 C<float nanf(const char)>

Similar to __builtin_nan, except the return type is float.


=head2 C<long double nanl(const char)>

Similar to __builtin_nan, except the return type is long double.


=head2 C<int parity(unsigned int)>

Returns the parity of x, i.e. the number of 1-bits in x
modulo 2.


=head2 C<int parityl(unsigned long)>

Similar to __builtin_parity, except the argument type is
unsigned long.


=head2 C<int parityll(unsigned long long)>

Similar to __builtin_parity, except the argument type is
unsigned long long.


=head2 C<int popcount(unsigned int)>

Returns the number of 1-bits in x.


=head2 C<int popcountl(unsigned long)>

Similar to __builtin_popcount, except the argument type is
unsigned long.


=head2 C<int popcountll(unsigned long long)>

Similar to __builtin_popcount, except the argument type is
unsigned long long.


=head2 C<double powi(double,int)>

Returns the first argument raised to the power of the second.  Unlike the
pow function no guarantees about precision and rounding are made.


=head2 C<float powif(float,int)>

Returns the first argument raised to the power of the second.  Unlike the
pow function no guarantees about precision and rounding are made.


=head2 C<long double powil(long double,int)>

Returns the first argument raised to the power of the second.  Unlike the
pow function no guarantees about precision and rounding are made.




=head1 UPDATING THE LIST OF FUNCTIONS

The list of functions was extracted from L<https://gcc.gnu.org/onlinedocs/gcc/Other-Builtins.html>
using the script C<sbin/build-gcc-builtins-package.pl> This script is
part of the distribution but it is not installed in the host system.
This file is HTML documenting these functions. I found it easier to parse
this file than to parse GCC header files, mainly because the latter
contain macros and typedef which I could not parse without the help of
the C pre-processor.

And so the list of provided files may not be perfect. Certainly there are some functions
missing. Simply because some functions do not make sense when called from Perl.
For example C<FUNCTION()>,
C<LINE()> etc. Some others are missing because they
have exotic data types for function arguments and/or return
which I did not know how to implement that in Perl. Others
have reported missing symbols, perhaps they
need a higher C standard (adjusted via the C<CFLAGS> in C<Makefile.PL>).

If you need another builtin function to be supported please raise
an L<issue|https://rt.cpan.org/NoAuth/ReportBug.html?Queue=GCC-Builtins>.
Please make sure you provide me with a way to include this function.
What C<CFLAGS>, how to C<typemap> its return type and arguments. And
also provide a test script to test it (similar to those found in C<t/> directory).

=head1 TESTING

For each exported sub there is a corresponding auto-generated
test file. The test goes as far as loading the library and
calling the function from Perl.

However, there may be errors in the expected results
because that was done without verifying with a C test program.

=head1 BENCHMARKS

Counting leading zeros (clz) will be used to
benchmark the GCC builtin C<__builtin_clz()>
and a pure Perl implementation as suggested
by Perl Monk L<coldr3ality|https://perlmonks.org/?node_id=1232041>
in this L<discussion|https://perlmonks.org/?node_id=11158279>

C<clz()> operating on the binary representation of a number
counts the zeros starting from the most significant end until
it finds the first bit set (to 1). Which essentially gives the
zero-based index of the MSB set to 1.

The benchmarks favour the GCC builtin C<__builtin_clz()>
which is about twice as fast as the pure Perl implementation.

The benchmarks can be run with C<make benchmarks>
An easy way to let Perl fetch and unpack the distribution
for you is to use C<cpanm> to open a shell

   cpanm --look GCC::Builtins

and then

   perl Makefile.PL && make all && make test && make benchmarks

=head1 CAVEATS

If you observe weird return results or core-dumps it is very likely that
the fault is mine while compiling the C<XS typemap>. The file in the distribution
C<typemap> was compiled by me to translate C's data types into Perls.
And for some of this I am not sure what the right type is. For example,
is C's C<uint_fast16_t> equivalent to Perl's C<T_UV>? How about
C's C<long double> mapping to Perl's C<T_DOUBLE> and C<unsigned long long>
to C<T_U_LONG>?

Please L<report|https://rt.cpan.org/NoAuth/ReportBug.html?Queue=GCC-Builtins> any corrections.

Also note that most parts (pod of subs, list of exported subs) of
the package file, XS code (e.g. XS functions) and test files
were automatically generated
by the procedure mentioned in L</UPDATING THE LIST OF FUNCTIONS>. It is
possible to contain mistakes.

=head1 AUTHOR

Andreas Hadjiprocopis, C<< <bliako ta cpan.org / andreashad2 ta gmail.com> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-gcc-builtins at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=GCC-Builtins>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc GCC::Builtins


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<https://rt.cpan.org/NoAuth/Bugs.html?Dist=GCC-Builtins>


=item * Review this module at PerlMonks

L<https://www.perlmonks.org/?node_id=21144>

=item * Search CPAN

L<https://metacpan.org/release/GCC-Builtins>

=back


=head1 ACKNOWLEDGEMENTS

=over 2

=item * This module started by this discussion at PerlMonks:

L<Most Significant Set Bit|https://perlmonks.org/?node_id=11158279>

=item * Hackers of Free Software.

=item * GNU and the Free Software Foundation, providers of GNU Compiler Collection.

=back

=head1 HUGS

!Almaz!


=head1 LICENSE AND COPYRIGHT

This software is Copyright (c) 2024 by Andreas Hadjiprocopis.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)


=cut

1; # End of GCC::Builtins
