## NAME

Curlie -- A simple HTTP client built on top of libcurl

## DESCRIPTION

An HTTP Client built on libcurl, that provides an OO interface, logging and error handling.

## SYNOPSIS

Create a new object manually:

    use Curlie;
    my \c = Curlie.new;

Any options sent in the constructor will be sent to libcurl's setopt.

    my $username = 'alice';
    my $password = 's3cret';
    my \c = Curlie.new(:$username, :$password);

or create a new object automatically:

    use Curlie :c;

Send a request, and print the full response headers and body:

    say c.get('https://httpbin.org/get').res;

or

    c.get: 'https://httpbin.org/get';
    say c.res;
    say c.res.content;

The response object has the following methods: status, statusline, success, content, raw-headers, headers, json.

Non-success responses return soft failures:

    say c.get('https://httpbin.org/status/500').res;
    # Fails with:
    # HTTP/2 500
    # and a stack trace

Which means to see the entire response, use it in a boolean context:

    c.get('https://httpbin.org/status/500') or say c.res;
    # Does not fail, prints:
    # HTTP/2 500
    # [ headers, response...]

If you also want to see the request, start a logger using Log::Async, and call c.debug beforehand:

    use Log::Async;
    logger.send-to($*ERR);
    c.debug;
    c.get('https://httpbin.org/status/500');

Add `curl` or `ssl` options to see extra libcurl or ssl messages:

    c.debug(:curl, :ssl);

Getting json, posting json, posting forms work like this:

    c.get: 'https://httpbin.org/status/200', :json;
    c.post: 'https://httpbin.org/post', :json(:hello<world>);
    c.post: 'https://httpbin.org/post', :form(:hello<world>);

The response object also has a `json` method which will decode
the body:

    say c.get('https://httpbin.org/get').res.json<url>
    # https://httpbin.org/get

Also other headers can be sent in a `headers` argument

    say c.get('https://httpbin.org/get', :headers(:X-Hello<world>)).res.json<headers><X-Hello>
    # world

That's it! (so far!)

## SEE ALSO

https://github.com/CurtTilmes/raku-libcurl

## BUGS

Probably!  Send me patches!

## AUTHOR

Brian Duggan (bduggan @ matatu.org)

