/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.osgish;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.aries.jmx.Activator;
import org.jmx4perl.osgi.J4pActivator;
import org.jmx4perl.osgish.OsgishService;
import org.jmx4perl.osgish.upload.UploadServlet;
import org.jmx4perl.osgish.upload.UploadStore;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OsgishActivator
implements BundleActivator {
    private J4pActivator j4pActivator = new J4pActivator();
    private Activator ariesActivator = new Activator();
    private ObjectName serviceMBeanName;
    private ObjectName uploadStoreMBeanName;
    private MBeanServer mBeanServer;
    private ServiceTracker httpServiceTracker;
    private ServiceTracker logTracker;
    private ServiceRegistration mBeanServerRegistration;
    private File uploadDir;

    public void start(BundleContext pContext) throws Exception {
        this.uploadDir = this.getUploadDirectory(pContext);
        this.openLogTracker(pContext);
        this.j4pActivator.start(pContext);
        this.registerMBeanServer(pContext);
        this.registerMBeans(pContext);
        this.registerUploadServlet(pContext);
        this.ariesActivator.start(pContext);
    }

    public void stop(BundleContext pContext) throws Exception {
        this.ariesActivator.stop(pContext);
        this.unregisterUploadServlet();
        this.unregisterMBeans();
        this.unregisterMBeanServer();
        this.j4pActivator.stop(pContext);
        this.closeLogTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMBeanServer(BundleContext pContext) {
        ServiceReference mBeanServerRef = pContext.getServiceReference(MBeanServer.class.getCanonicalName());
        if (mBeanServerRef == null) {
            this.mBeanServer = this.getMBeanServer();
            this.mBeanServerRegistration = pContext.registerService(MBeanServer.class.getCanonicalName(), (Object)this.mBeanServer, null);
        } else {
            boolean serviceFound = true;
            try {
                this.mBeanServer = (MBeanServer)pContext.getService(mBeanServerRef);
                if (this.mBeanServer == null) {
                    this.mBeanServer = this.getMBeanServer();
                    pContext.registerService(MBeanServer.class.getCanonicalName(), (Object)this.mBeanServer, null);
                    serviceFound = false;
                }
            }
            finally {
                if (mBeanServerRef != null && serviceFound) {
                    pContext.ungetService(mBeanServerRef);
                }
                this.mBeanServerRegistration = null;
            }
        }
    }

    private void unregisterMBeanServer() {
        if (this.mBeanServerRegistration != null) {
            this.mBeanServerRegistration.unregister();
            this.mBeanServerRegistration = null;
        }
        this.mBeanServer = null;
    }

    private void registerMBeans(BundleContext pBundleContext) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        OsgishService service = new OsgishService(pBundleContext);
        this.serviceMBeanName = this.mBeanServer.registerMBean(service, null).getObjectName();
        UploadStore uploadStore = new UploadStore(this.uploadDir);
        this.uploadStoreMBeanName = this.mBeanServer.registerMBean(uploadStore, null).getObjectName();
    }

    private void unregisterMBeans() throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.mBeanServer != null) {
            this.mBeanServer.unregisterMBean(this.serviceMBeanName);
            this.mBeanServer.unregisterMBean(this.uploadStoreMBeanName);
        }
    }

    private MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private void registerUploadServlet(BundleContext pContext) {
        UploadServlet uploadServlet = new UploadServlet(this.logTracker, this.uploadDir);
        this.httpServiceTracker = new ServiceTracker(pContext, HttpService.class.getName(), this.getRegistrationCustomizer(pContext, uploadServlet));
        this.httpServiceTracker.open();
    }

    private void unregisterUploadServlet() {
        this.httpServiceTracker.close();
        this.httpServiceTracker = null;
    }

    private ServiceTrackerCustomizer getRegistrationCustomizer(final BundleContext pContext, final UploadServlet pUploadServlet) {
        final String alias = pUploadServlet.getServletAlias(this.j4pActivator.getServletAlias());
        return new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                HttpService httpService = (HttpService)pContext.getService(reference);
                try {
                    httpService.registerServlet(alias, (Servlet)pUploadServlet, null, OsgishActivator.this.j4pActivator.getHttpContext());
                }
                catch (ServletException e) {
                    OsgishActivator.this.log(1, "ServletException during registration of " + alias, new Exception[]{e});
                }
                catch (NamespaceException e) {
                    OsgishActivator.this.log(1, "NamespaceException during registration of " + alias, new Exception[]{e});
                }
                return httpService;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                HttpService httpService = (HttpService)service;
                httpService.unregister(alias);
            }
        };
    }

    private void openLogTracker(BundleContext pContext) {
        this.logTracker = new ServiceTracker(pContext, LogService.class.getName(), null);
        this.logTracker.open();
    }

    private void closeLogTracker() {
        this.logTracker.close();
        this.logTracker = null;
    }

    private void log(int level, String message, Exception ... exp) {
        LogService logService = (LogService)this.logTracker.getService();
        if (logService != null) {
            if (exp != null && exp.length > 0) {
                logService.log(level, message, (Throwable)exp[0]);
            } else {
                logService.log(level, message);
            }
        } else {
            System.err.println((level == 1 ? "ERROR: " : "") + message);
            if (exp != null && exp.length > 0) {
                exp[0].printStackTrace(System.err);
            }
        }
    }

    private File getUploadDirectory(BundleContext pContext) {
        File dir = pContext.getDataFile("");
        if (dir == null) {
            try {
                dir = File.createTempFile("osgish-upload", ".dir");
                if (!dir.delete() || !dir.mkdir()) {
                    throw new IllegalStateException("Cannot create temporary directory " + dir.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot get a upload directory: " + e, e);
            }
        }
        return dir;
    }
}

