# Generated by default/object.tt
package Paws::LexModelsV2::SlotPriority;
  use Moose;
  has Priority => (is => 'ro', isa => 'Int', request_name => 'priority', traits => ['NameInRequest'], required => 1);
  has SlotId => (is => 'ro', isa => 'Str', request_name => 'slotId', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::SlotPriority

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::SlotPriority object:

  $service_obj->Method(Att1 => { Priority => $value, ..., SlotId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::SlotPriority object:

  $result = $service_obj->Method(...);
  $result->Att1->Priority

=head1 DESCRIPTION

Sets the priority that Amazon Lex should use when eliciting slot values
from a user.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Priority => Int

The priority that a slot should be elicited.


=head2 B<REQUIRED> SlotId => Str

The unique identifier of the slot.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

