package App::lcpan::Bootstrap;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-01-08'; # DATE
our $DIST = 'App-lcpan-Bootstrap'; # DIST
our $VERSION = '20230108.0.0'; # VERSION

1;
# ABSTRACT: Bootstrap database for lcpan

__END__

=pod

=encoding UTF-8

=head1 NAME

App::lcpan::Bootstrap - Bootstrap database for lcpan

=head1 VERSION

This document describes version 20230108.0.0 of App::lcpan::Bootstrap (from Perl distribution App-lcpan-Bootstrap), released on 2023-01-08.

=head1 SYNOPSIS

=head1 DESCRIPTION

This distribution contains the database for L<lcpan> (updated periodically), so
you can save time when setting up your local CPAN mirror the first time. Without
a boostrap database, indexing the mirror for the first time can take several
hours. With a fairly recent bootstrap database, indexing time can be reduced to
an hour or much less.

Note however, that this particular bootstrap is produced with this lcpan
configuration:

 max_file_size=209715200

 ; these are skipped because they are very large (contains thousands+ of
 ; autogenerated modules) and increase the indexing time by several times.
 skip_index_file_patterns = ^eBay-API-\d
 skip_index_file_patterns = ^Google-Ads-GoogleAds-Client-\d
 skip_index_file_patterns = ^Google-Ads-AdWords-Client-\d
 skip_index_file_patterns = ^GOOGLE-ADWORDS-PERL-CLIENT-\d
 skip_index_file_patterns = ^Microsoft-AdCenter-\d
 skip_index_file_patterns = ^Paws-\d
 skip_index_file_patterns = ^VMOMI-\d

which means release files over 200MB as well as those matching the above
patterns are not processed (their distribution metadata are not extracted and
parsed, their PODs are also not parsed). This should be fine for many use-cases,
but if you do not want the above configuration, you'll not be able to use this
bootstrap.

The compressed bootstrap database is stored in the distribution's share
directory. lcpan will search for this bootstrap database the first time it is
run.

If you run lcpan before installing this distribution, your empty database will
already be created. To use the bootstrap database, install this distribution,
remove the empty created F<index.db>, then run lcpan again.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-lcpan-Bootstrap>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-lcpan-Bootstrap>.

=head1 SEE ALSO

L<App::lcpan>, L<lcpan>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-lcpan-Bootstrap>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
