/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public final class TextUtil {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";

    private TextUtil() {
    }

    public static InputStream toInputStream(String content) {
        try {
            return TextUtil.toInputStream(content, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("ISO-8859-1 is an unsupported encoding!  You may have a corrupted installation of java.");
        }
    }

    public static InputStream toInputStream(String content, String encoding) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(content.length() * 2);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, encoding);
            writer.write(content);
            writer.flush();
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            return new ByteArrayInputStream(byteArray);
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception when converting a string to an input stream: '" + e + "'", e);
        }
    }

    public static byte[] stringToByteArray(String content) {
        return content != null ? TextUtil.stringToByteArray(content, DEFAULT_CHARSET) : null;
    }

    public static byte[] stringToByteArray(String content, String charset) {
        byte[] contentBytes;
        try {
            contentBytes = content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            contentBytes = new byte[]{};
        }
        return contentBytes;
    }
}

