#============================================================= -*-Perl-*-
#
# Template::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Andy Wardley   <abw@wardley.org>
#
# COPYRIGHT
#   Copyright (C) 1996-2014 Andy Wardley.  All Rights Reserved.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
# IMPORTANT NOTE
#   This module is constructed from the parser/Grammar.pm.skel file by
#   running the parser/yc script.  You only need to do this if # you
#   have modified the grammar in the parser/Parser.yp file and need #
#   to-recompile it.  See the README in the 'parser' directory for
#   more information (sub-directory of the Template distribution).
#
#========================================================================

package Template::Grammar;

use strict;
use warnings;

our $VERSION  = 2.26;

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================

# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw(
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE PLUGIN FILTER MACRO PERL RAWPERL TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform
# stringwise comparison (mainly because it doesn't generate "non-numerical
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al,
# briefly for v2.04d and then took them out again in 2.04e.


%CMPOP = qw(
    != ne
    == eq
    <  <
    >  >
    >= >=
    <= <=
);

#    eq eq  # add these lines to the above to
#    lt lt  # enable the eq, lt and gt operators
#    gt gt

#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case,
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens }
			= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
		LEXTABLE => $LEXTABLE,
		STATES   => $STATES,
		RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'WHILE' => 7,
			'CALL' => 47,
			'VIEW' => 2,
			'FILTER' => 46,
			'MACRO' => 45,
			"(" => 42,
			'NEXT' => 44,
			'BLOCK' => 41,
			'TEXT' => 60,
			";" => -18,
			'NUMBER' => 59,
			"[" => 54,
			'IDENT' => 55,
			"\${" => 50,
			'META' => 48,
			'DEFAULT' => 11,
			'SET' => 65,
			'UNLESS' => 67,
			'NOT' => 66,
			'REF' => 28,
			'RETURN' => 64,
			'DEBUG' => 26,
			'USE' => 24,
			'SWITCH' => 22,
			'INSERT' => 63,
			'LITERAL' => 62,
			'PERL' => 21,
			'PROCESS' => 18,
			"{" => 40,
			'TRY' => 36,
			'THROW' => 37,
			'GET' => 38,
			'IF' => 33,
			'STOP' => 34,
			'FOR' => 71,
			"\$" => 73,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			'LAST' => 70,
			'INCLUDE' => 30,
			'RAWPERL' => 29,
			"\"" => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'try' => 52,
			'item' => 51,
			'node' => 49,
			'perl' => 12,
			'expr' => 61,
			'defblockname' => 17,
			'chunks' => 16,
			'setlist' => 14,
			'term' => 15,
			'loop' => 58,
			'view' => 56,
			'ident' => 13,
			'sterm' => 57,
			'atomexpr' => 53,
			'lterm' => 4,
			'switch' => 3,
			'rawperl' => 43,
			'condition' => 1,
			'wrapper' => 10,
			'anonblock' => 9,
			'template' => 8,
			'atomdir' => 5,
			'macro' => 6,
			'chunk' => 31,
			'block' => 69,
			'filter' => 39,
			'use' => 35,
			'assign' => 20,
			'capture' => 19,
			'directive' => 27,
			'statement' => 25,
			'defblock' => 23
		}
	},
	{#State 1
		DEFAULT => -21
	},
	{#State 2
		ACTIONS => {
			'FILENAME' => 74,
			'NUMBER' => 79,
			"\$" => 84,
			'LITERAL' => 80,
			"\"" => 83,
			'IDENT' => 78
		},
		GOTOS => {
			'names' => 75,
			'filepart' => 82,
			'nameargs' => 81,
			'name' => 77,
			'filename' => 76
		}
	},
	{#State 3
		DEFAULT => -22
	},
	{#State 4
		DEFAULT => -103
	},
	{#State 5
		ACTIONS => {
			";" => -20
		},
		DEFAULT => -27
	},
	{#State 6
		DEFAULT => -12
	},
	{#State 7
		ACTIONS => {
			'REF' => 28,
			"{" => 40,
			'NOT' => 66,
			'NUMBER' => 59,
			'IDENT' => 55,
			"[" => 54,
			'LITERAL' => 85,
			"\$" => 73,
			"\${" => 50,
			"(" => 42,
			"\"" => 68
		},
		GOTOS => {
			'ident' => 87,
			'sterm' => 57,
			'lterm' => 4,
			'expr' => 86,
			'item' => 51,
			'term' => 15,
			'node' => 49
		}
	},
	{#State 8
		ACTIONS => {
			'' => 88
		}
	},
	{#State 9
		DEFAULT => -10
	},
	{#State 10
		DEFAULT => -42
	},
	{#State 11
		ACTIONS => {
			"\$" => 73,
			"\${" => 50,
			'IDENT' => 55,
			'LITERAL' => 89
		},
		GOTOS => {
			'assign' => 20,
			'node' => 49,
			'setlist' => 90,
			'item' => 51,
			'ident' => 91
		}
	},
	{#State 12
		DEFAULT => -25
	},
	{#State 13
		ACTIONS => {
			'ASSIGN' => 92,
			'DOT' => 93
		},
		DEFAULT => -109
	},
	{#State 14
		ACTIONS => {
			"\$" => 73,
			'COMMA' => 94,
			"\${" => 50,
			'IDENT' => 55,
			'LITERAL' => 89
		},
		DEFAULT => -19,
		GOTOS => {
			'item' => 51,
			'assign' => 95,
			'node' => 49,
			'ident' => 91
		}
	},
	{#State 15
		DEFAULT => -146
	},
	{#State 16
		ACTIONS => {
			'IF' => 33,
			'STOP' => 34,
			'TRY' => 36,
			'GET' => 38,
			'THROW' => 37,
			"{" => 40,
			"\"" => 68,
			'RAWPERL' => 29,
			'INCLUDE' => 30,
			'LAST' => 70,
			'FOR' => 71,
			'WRAPPER' => 32,
			"\$" => 73,
			'CLEAR' => 72,
			'SWITCH' => 22,
			'INSERT' => 63,
			'LITERAL' => 62,
			'USE' => 24,
			'RETURN' => 64,
			'DEBUG' => 26,
			'SET' => 65,
			'REF' => 28,
			'NOT' => 66,
			'UNLESS' => 67,
			'PROCESS' => 18,
			'PERL' => 21,
			'IDENT' => 55,
			"[" => 54,
			";" => -18,
			'TEXT' => 60,
			'NUMBER' => 59,
			'DEFAULT' => 11,
			'META' => 48,
			"\${" => 50,
			'WHILE' => 7,
			'BLOCK' => 41,
			"(" => 42,
			'NEXT' => 44,
			'VIEW' => 2,
			'FILTER' => 46,
			'MACRO' => 45,
			'CALL' => 47
		},
		DEFAULT => -2,
		GOTOS => {
			'wrapper' => 10,
			'statement' => 25,
			'directive' => 27,
			'anonblock' => 9,
			'atomdir' => 5,
			'defblock' => 23,
			'macro' => 6,
			'lterm' => 4,
			'switch' => 3,
			'capture' => 19,
			'assign' => 20,
			'rawperl' => 43,
			'condition' => 1,
			'expr' => 61,
			'defblockname' => 17,
			'filter' => 39,
			'loop' => 58,
			'term' => 15,
			'setlist' => 14,
			'use' => 35,
			'ident' => 13,
			'sterm' => 57,
			'view' => 56,
			'atomexpr' => 53,
			'try' => 52,
			'node' => 49,
			'chunk' => 96,
			'item' => 51,
			'perl' => 12
		}
	},
	{#State 17
		ACTIONS => {
			'IDENT' => 97
		},
		DEFAULT => -87,
		GOTOS => {
			'meta' => 98,
			'metadata' => 100,
			'blockargs' => 99
		}
	},
	{#State 18
		ACTIONS => {
			"\"" => 83,
			'LITERAL' => 80,
			'IDENT' => 78,
			'NUMBER' => 79,
			'FILENAME' => 74,
			"\$" => 84
		},
		GOTOS => {
			'filepart' => 82,
			'names' => 75,
			'filename' => 76,
			'name' => 77,
			'nameargs' => 101
		}
	},
	{#State 19
		DEFAULT => -11
	},
	{#State 20
		DEFAULT => -149
	},
	{#State 21
		ACTIONS => {
			";" => 102
		}
	},
	{#State 22
		ACTIONS => {
			"[" => 54,
			'IDENT' => 55,
			'LITERAL' => 85,
			"{" => 40,
			'NOT' => 66,
			'REF' => 28,
			'NUMBER' => 59,
			"(" => 42,
			"\"" => 68,
			"\$" => 73,
			"\${" => 50
		},
		GOTOS => {
			'expr' => 103,
			'lterm' => 4,
			'node' => 49,
			'term' => 15,
			'item' => 51,
			'sterm' => 57,
			'ident' => 87
		}
	},
	{#State 23
		DEFAULT => -9
	},
	{#State 24
		ACTIONS => {
			'NUMBER' => 79,
			'FILENAME' => 74,
			"\${" => 50,
			"\$" => 109,
			"\"" => 110,
			'LITERAL' => 107,
			'IDENT' => 106
		},
		GOTOS => {
			'lvalue' => 105,
			'lnameargs' => 111,
			'nameargs' => 108,
			'name' => 77,
			'filename' => 76,
			'filepart' => 82,
			'names' => 75,
			'item' => 104
		}
	},
	{#State 25
		ACTIONS => {
			";" => 112
		}
	},
	{#State 26
		ACTIONS => {
			"\$" => 84,
			'NUMBER' => 79,
			'FILENAME' => 74,
			'IDENT' => 78,
			"\"" => 83,
			'LITERAL' => 80
		},
		GOTOS => {
			'filepart' => 82,
			'names' => 75,
			'nameargs' => 113,
			'filename' => 76,
			'name' => 77
		}
	},
	{#State 27
		DEFAULT => -8
	},
	{#State 28
		ACTIONS => {
			'IDENT' => 55,
			"\$" => 73,
			"\${" => 50
		},
		GOTOS => {
			'node' => 49,
			'item' => 51,
			'ident' => 114
		}
	},
	{#State 29
		DEFAULT => -78,
		GOTOS => {
			'@5-1' => 115
		}
	},
	{#State 30
		ACTIONS => {
			'LITERAL' => 80,
			"\"" => 83,
			'IDENT' => 78,
			'FILENAME' => 74,
			'NUMBER' => 79,
			"\$" => 84
		},
		GOTOS => {
			'names' => 75,
			'filepart' => 82,
			'filename' => 76,
			'name' => 77,
			'nameargs' => 116
		}
	},
	{#State 31
		DEFAULT => -5
	},
	{#State 32
		ACTIONS => {
			'NUMBER' => 79,
			'FILENAME' => 74,
			"\$" => 84,
			'LITERAL' => 80,
			"\"" => 83,
			'IDENT' => 78
		},
		GOTOS => {
			'filepart' => 82,
			'names' => 75,
			'nameargs' => 117,
			'name' => 77,
			'filename' => 76
		}
	},
	{#State 33
		ACTIONS => {
			'LITERAL' => 85,
			'IDENT' => 55,
			"[" => 54,
			'NUMBER' => 59,
			'REF' => 28,
			'NOT' => 66,
			"{" => 40,
			"\"" => 68,
			"(" => 42,
			"\${" => 50,
			"\$" => 73
		},
		GOTOS => {
			'node' => 49,
			'item' => 51,
			'term' => 15,
			'expr' => 118,
			'lterm' => 4,
			'ident' => 87,
			'sterm' => 57
		}
	},
	{#State 34
		DEFAULT => -37
	},
	{#State 35
		DEFAULT => -13
	},
	{#State 36
		ACTIONS => {
			";" => 119
		}
	},
	{#State 37
		ACTIONS => {
			'LITERAL' => 80,
			"\"" => 83,
			'IDENT' => 78,
			'NUMBER' => 79,
			'FILENAME' => 74,
			"\$" => 84
		},
		GOTOS => {
			'nameargs' => 120,
			'name' => 77,
			'filename' => 76,
			'filepart' => 82,
			'names' => 75
		}
	},
	{#State 38
		ACTIONS => {
			'LITERAL' => 85,
			'IDENT' => 55,
			"[" => 54,
			'NUMBER' => 59,
			'NOT' => 66,
			'REF' => 28,
			"{" => 40,
			"\"" => 68,
			"(" => 42,
			"\${" => 50,
			"\$" => 73
		},
		GOTOS => {
			'ident' => 87,
			'sterm' => 57,
			'node' => 49,
			'term' => 15,
			'item' => 51,
			'expr' => 121,
			'lterm' => 4
		}
	},
	{#State 39
		DEFAULT => -43
	},
	{#State 40
		ACTIONS => {
			"\${" => 50,
			"\$" => 73,
			'LITERAL' => 122,
			'IDENT' => 55
		},
		DEFAULT => -119,
		GOTOS => {
			'item' => 124,
			'params' => 123,
			'param' => 126,
			'hash' => 125
		}
	},
	{#State 41
		ACTIONS => {
			'FILENAME' => 74,
			'NUMBER' => 79,
			'LITERAL' => 129,
			'IDENT' => 131
		},
		DEFAULT => -87,
		GOTOS => {
			'filepart' => 82,
			'meta' => 98,
			'metadata' => 100,
			'blockargs' => 130,
			'blockname' => 127,
			'filename' => 128
		}
	},
	{#State 42
		ACTIONS => {
			"[" => 54,
			'IDENT' => 55,
			'LITERAL' => 62,
			'REF' => 28,
			'NOT' => 66,
			"{" => 40,
			'NUMBER' => 59,
			"(" => 42,
			"\"" => 68,
			"\$" => 73,
			"\${" => 50
		},
		GOTOS => {
			'ident' => 132,
			'sterm' => 57,
			'term' => 15,
			'expr' => 134,
			'item' => 51,
			'node' => 49,
			'assign' => 133,
			'lterm' => 4
		}
	},
	{#State 43
		DEFAULT => -15
	},
	{#State 44
		DEFAULT => -40
	},
	{#State 45
		ACTIONS => {
			'IDENT' => 135
		}
	},
	{#State 46
		ACTIONS => {
			"\$" => 109,
			'NUMBER' => 79,
			'FILENAME' => 74,
			"\${" => 50,
			'IDENT' => 106,
			'LITERAL' => 107,
			"\"" => 110
		},
		GOTOS => {
			'filepart' => 82,
			'name' => 77,
			'filename' => 76,
			'nameargs' => 108,
			'lnameargs' => 136,
			'lvalue' => 105,
			'item' => 104,
			'names' => 75
		}
	},
	{#State 47
		ACTIONS => {
			'NUMBER' => 59,
			'NOT' => 66,
			"{" => 40,
			'REF' => 28,
			'LITERAL' => 85,
			"[" => 54,
			'IDENT' => 55,
			"\${" => 50,
			"\$" => 73,
			"\"" => 68,
			"(" => 42
		},
		GOTOS => {
			'node' => 49,
			'item' => 51,
			'term' => 15,
			'lterm' => 4,
			'expr' => 137,
			'sterm' => 57,
			'ident' => 87
		}
	},
	{#State 48
		ACTIONS => {
			'IDENT' => 97
		},
		GOTOS => {
			'metadata' => 138,
			'meta' => 98
		}
	},
	{#State 49
		DEFAULT => -127
	},
	{#State 50
		ACTIONS => {
			"\"" => 68,
			'LITERAL' => 85,
			'IDENT' => 55,
			"\${" => 50,
			'NUMBER' => 59,
			"\$" => 73,
			'REF' => 28
		},
		GOTOS => {
			'node' => 49,
			'item' => 51,
			'sterm' => 139,
			'ident' => 87
		}
	},
	{#State 51
		ACTIONS => {
			"(" => 140
		},
		DEFAULT => -128
	},
	{#State 52
		DEFAULT => -24
	},
	{#State 53
		ACTIONS => {
			'FILTER' => 141,
			'FOR' => 143,
			'WRAPPER' => 146,
			'UNLESS' => 142,
			'IF' => 145,
			'WHILE' => 144
		}
	},
	{#State 54
		ACTIONS => {
			'REF' => 28,
			"{" => 40,
			'NUMBER' => 59,
			"[" => 54,
			'IDENT' => 55,
			'LITERAL' => 85,
			"]" => 148,
			"\$" => 73,
			"\${" => 50,
			"\"" => 68
		},
		GOTOS => {
			'sterm' => 147,
			'ident' => 87,
			'list' => 150,
			'range' => 151,
			'term' => 149,
			'lterm' => 4,
			'node' => 49,
			'item' => 51
		}
	},
	{#State 55
		DEFAULT => -130
	},
	{#State 56
		DEFAULT => -14
	},
	{#State 57
		DEFAULT => -104
	},
	{#State 58
		DEFAULT => -23
	},
	{#State 59
		DEFAULT => -113
	},
	{#State 60
		DEFAULT => -6
	},
	{#State 61
		ACTIONS => {
			'CMPOP' => 155,
			'MOD' => 154,
			'DIV' => 161,
			"?" => 156,
			'CAT' => 153,
			'AND' => 152,
			"+" => 160,
			'OR' => 158,
			'BINOP' => 159,
			";" => -16,
			"/" => 157
		},
		DEFAULT => -26
	},
	{#State 62
		ACTIONS => {
			'ASSIGN' => 162
		},
		DEFAULT => -112
	},
	{#State 63
		ACTIONS => {
			"\$" => 84,
			'FILENAME' => 74,
			'NUMBER' => 79,
			'IDENT' => 78,
			"\"" => 83,
			'LITERAL' => 80
		},
		GOTOS => {
			'filename' => 76,
			'name' => 77,
			'nameargs' => 163,
			'filepart' => 82,
			'names' => 75
		}
	},
	{#State 64
		DEFAULT => -36
	},
	{#State 65
		ACTIONS => {
			"\$" => 73,
			"\${" => 50,
			'IDENT' => 55,
			'LITERAL' => 89
		},
		GOTOS => {
			'ident' => 91,
			'assign' => 20,
			'node' => 49,
			'setlist' => 164,
			'item' => 51
		}
	},
	{#State 66
		ACTIONS => {
			'NUMBER' => 59,
			"{" => 40,
			'REF' => 28,
			'NOT' => 66,
			'LITERAL' => 85,
			"[" => 54,
			'IDENT' => 55,
			"\${" => 50,
			"\$" => 73,
			"\"" => 68,
			"(" => 42
		},
		GOTOS => {
			'lterm' => 4,
			'expr' => 165,
			'item' => 51,
			'term' => 15,
			'node' => 49,
			'ident' => 87,
			'sterm' => 57
		}
	},
	{#State 67
		ACTIONS => {
			'LITERAL' => 85,
			"[" => 54,
			'IDENT' => 55,
			'NUMBER' => 59,
			"{" => 40,
			'REF' => 28,
			'NOT' => 66,
			"\"" => 68,
			"(" => 42,
			"\${" => 50,
			"\$" => 73
		},
		GOTOS => {
			'expr' => 166,
			'lterm' => 4,
			'term' => 15,
			'item' => 51,
			'node' => 49,
			'sterm' => 57,
			'ident' => 87
		}
	},
	{#State 68
		DEFAULT => -176,
		GOTOS => {
			'quoted' => 167
		}
	},
	{#State 69
		DEFAULT => -1
	},
	{#State 70
		DEFAULT => -39
	},
	{#State 71
		ACTIONS => {
			"\$" => 73,
			"\${" => 50,
			"\"" => 68,
			'REF' => 28,
			"{" => 40,
			'NUMBER' => 59,
			"[" => 54,
			'IDENT' => 168,
			'LITERAL' => 85
		},
		GOTOS => {
			'loopvar' => 170,
			'sterm' => 57,
			'ident' => 87,
			'lterm' => 4,
			'term' => 169,
			'item' => 51,
			'node' => 49
		}
	},
	{#State 72
		DEFAULT => -38
	},
	{#State 73
		ACTIONS => {
			'IDENT' => 171
		}
	},
	{#State 74
		DEFAULT => -172
	},
	{#State 75
		ACTIONS => {
			"+" => 174,
			"(" => 172
		},
		DEFAULT => -156,
		GOTOS => {
			'args' => 173
		}
	},
	{#State 76
		ACTIONS => {
			'DOT' => 175
		},
		DEFAULT => -168
	},
	{#State 77
		DEFAULT => -166
	},
	{#State 78
		DEFAULT => -173
	},
	{#State 79
		DEFAULT => -174
	},
	{#State 80
		DEFAULT => -169
	},
	{#State 81
		ACTIONS => {
			";" => 176
		}
	},
	{#State 82
		DEFAULT => -171
	},
	{#State 83
		DEFAULT => -176,
		GOTOS => {
			'quoted' => 177
		}
	},
	{#State 84
		ACTIONS => {
			"\${" => 50,
			"\$" => 73,
			'IDENT' => 55
		},
		GOTOS => {
			'item' => 51,
			'node' => 49,
			'ident' => 178
		}
	},
	{#State 85
		DEFAULT => -112
	},
	{#State 86
		ACTIONS => {
			'DIV' => 161,
			'CAT' => 153,
			"?" => 156,
			"/" => 157,
			"+" => 160,
			'AND' => 152,
			'OR' => 158,
			'BINOP' => 159,
			'CMPOP' => 155,
			";" => 179,
			'MOD' => 154
		}
	},
	{#State 87
		ACTIONS => {
			'DOT' => 93
		},
		DEFAULT => -109
	},
	{#State 88
		DEFAULT => 0
	},
	{#State 89
		ACTIONS => {
			'ASSIGN' => 162
		}
	},
	{#State 90
		ACTIONS => {
			'LITERAL' => 89,
			'IDENT' => 55,
			"\${" => 50,
			'COMMA' => 94,
			"\$" => 73
		},
		DEFAULT => -31,
		GOTOS => {
			'ident' => 91,
			'node' => 49,
			'assign' => 95,
			'item' => 51
		}
	},
	{#State 91
		ACTIONS => {
			'DOT' => 93,
			'ASSIGN' => 180
		}
	},
	{#State 92
		ACTIONS => {
			'WHILE' => 7,
			'FILTER' => 46,
			'CALL' => 47,
			'BLOCK' => 181,
			'NEXT' => 44,
			"(" => 42,
			'NUMBER' => 59,
			'IDENT' => 55,
			"[" => 54,
			"\${" => 50,
			'DEFAULT' => 11,
			'DEBUG' => 26,
			'RETURN' => 64,
			'UNLESS' => 67,
			'REF' => 28,
			'NOT' => 66,
			'SET' => 65,
			'LITERAL' => 62,
			'SWITCH' => 22,
			'INSERT' => 63,
			'PERL' => 21,
			'PROCESS' => 18,
			"{" => 40,
			'STOP' => 34,
			'IF' => 33,
			'GET' => 38,
			'THROW' => 37,
			'TRY' => 36,
			'LAST' => 70,
			'INCLUDE' => 30,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			"\$" => 73,
			'FOR' => 71,
			"\"" => 68
		},
		GOTOS => {
			'sterm' => 57,
			'ident' => 132,
			'atomexpr' => 53,
			'mdir' => 183,
			'expr' => 182,
			'loop' => 58,
			'filter' => 39,
			'term' => 15,
			'setlist' => 14,
			'perl' => 12,
			'try' => 52,
			'node' => 49,
			'item' => 51,
			'atomdir' => 5,
			'wrapper' => 10,
			'directive' => 184,
			'condition' => 1,
			'switch' => 3,
			'lterm' => 4,
			'assign' => 20
		}
	},
	{#State 93
		ACTIONS => {
			'IDENT' => 55,
			"\${" => 50,
			'NUMBER' => 185,
			"\$" => 73
		},
		GOTOS => {
			'node' => 186,
			'item' => 51
		}
	},
	{#State 94
		DEFAULT => -148
	},
	{#State 95
		DEFAULT => -147
	},
	{#State 96
		DEFAULT => -4
	},
	{#State 97
		ACTIONS => {
			'ASSIGN' => 187
		}
	},
	{#State 98
		DEFAULT => -99
	},
	{#State 99
		ACTIONS => {
			";" => 188
		}
	},
	{#State 100
		ACTIONS => {
			'COMMA' => 189,
			'IDENT' => 97
		},
		DEFAULT => -86,
		GOTOS => {
			'meta' => 190
		}
	},
	{#State 101
		DEFAULT => -34
	},
	{#State 102
		DEFAULT => -76,
		GOTOS => {
			'@4-2' => 191
		}
	},
	{#State 103
		ACTIONS => {
			"/" => 157,
			'CAT' => 153,
			'DIV' => 161,
			"?" => 156,
			'AND' => 152,
			"+" => 160,
			'OR' => 158,
			'BINOP' => 159,
			";" => 192,
			'MOD' => 154,
			'CMPOP' => 155
		}
	},
	{#State 104
		DEFAULT => -159
	},
	{#State 105
		ACTIONS => {
			'ASSIGN' => 193
		}
	},
	{#State 106
		ACTIONS => {
			'ASSIGN' => -130
		},
		DEFAULT => -173
	},
	{#State 107
		ACTIONS => {
			'ASSIGN' => -161
		},
		DEFAULT => -169
	},
	{#State 108
		DEFAULT => -158
	},
	{#State 109
		ACTIONS => {
			"\${" => 50,
			"\$" => 73,
			'IDENT' => 194
		},
		GOTOS => {
			'item' => 51,
			'node' => 49,
			'ident' => 178
		}
	},
	{#State 110
		DEFAULT => -176,
		GOTOS => {
			'quoted' => 195
		}
	},
	{#State 111
		DEFAULT => -73
	},
	{#State 112
		DEFAULT => -7
	},
	{#State 113
		DEFAULT => -41
	},
	{#State 114
		ACTIONS => {
			'DOT' => 93
		},
		DEFAULT => -110
	},
	{#State 115
		ACTIONS => {
			";" => 196
		}
	},
	{#State 116
		DEFAULT => -33
	},
	{#State 117
		ACTIONS => {
			";" => 197
		}
	},
	{#State 118
		ACTIONS => {
			'CAT' => 153,
			'DIV' => 161,
			"?" => 156,
			"/" => 157,
			"+" => 160,
			'AND' => 152,
			'BINOP' => 159,
			'OR' => 158,
			'CMPOP' => 155,
			'MOD' => 154,
			";" => 198
		}
	},
	{#State 119
		ACTIONS => {
			"{" => 40,
			'THROW' => 37,
			'GET' => 38,
			'TRY' => 36,
			'STOP' => 34,
			'IF' => 33,
			'WRAPPER' => 32,
			"\$" => 73,
			'CLEAR' => 72,
			'FOR' => 71,
			'INCLUDE' => 30,
			'LAST' => 70,
			'RAWPERL' => 29,
			"\"" => 68,
			'REF' => 28,
			'UNLESS' => 67,
			'NOT' => 66,
			'SET' => 65,
			'DEBUG' => 26,
			'RETURN' => 64,
			'USE' => 24,
			'INSERT' => 63,
			'SWITCH' => 22,
			'LITERAL' => 62,
			'PERL' => 21,
			'PROCESS' => 18,
			'NUMBER' => 59,
			";" => -18,
			'TEXT' => 60,
			"[" => 54,
			'IDENT' => 55,
			"\${" => 50,
			'META' => 48,
			'DEFAULT' => 11,
			'WHILE' => 7,
			'CALL' => 47,
			'MACRO' => 45,
			'FILTER' => 46,
			'VIEW' => 2,
			'NEXT' => 44,
			"(" => 42,
			'BLOCK' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'perl' => 12,
			'try' => 52,
			'node' => 49,
			'block' => 199,
			'chunk' => 31,
			'item' => 51,
			'ident' => 13,
			'view' => 56,
			'sterm' => 57,
			'use' => 35,
			'atomexpr' => 53,
			'chunks' => 16,
			'defblockname' => 17,
			'expr' => 61,
			'filter' => 39,
			'loop' => 58,
			'term' => 15,
			'setlist' => 14,
			'rawperl' => 43,
			'condition' => 1,
			'switch' => 3,
			'lterm' => 4,
			'assign' => 20,
			'capture' => 19,
			'defblock' => 23,
			'macro' => 6,
			'atomdir' => 5,
			'wrapper' => 10,
			'statement' => 25,
			'anonblock' => 9,
			'directive' => 27
		}
	},
	{#State 120
		DEFAULT => -35
	},
	{#State 121
		ACTIONS => {
			"/" => 157,
			'BINOP' => 159,
			'OR' => 158,
			'AND' => 152,
			"+" => 160,
			'DIV' => 161,
			'CAT' => 153,
			"?" => 156,
			'CMPOP' => 155,
			'MOD' => 154
		},
		DEFAULT => -28
	},
	{#State 122
		ACTIONS => {
			'ASSIGN' => 200
		}
	},
	{#State 123
		ACTIONS => {
			"\$" => 73,
			"\${" => 50,
			'COMMA' => 202,
			'IDENT' => 55,
			'LITERAL' => 122
		},
		DEFAULT => -118,
		GOTOS => {
			'item' => 124,
			'param' => 201
		}
	},
	{#State 124
		ACTIONS => {
			'ASSIGN' => 203
		}
	},
	{#State 125
		ACTIONS => {
			"}" => 204
		}
	},
	{#State 126
		DEFAULT => -122
	},
	{#State 127
		DEFAULT => -83
	},
	{#State 128
		ACTIONS => {
			'DOT' => 175
		},
		DEFAULT => -84
	},
	{#State 129
		DEFAULT => -85
	},
	{#State 130
		ACTIONS => {
			";" => 205
		}
	},
	{#State 131
		ACTIONS => {
			'ASSIGN' => 187
		},
		DEFAULT => -173
	},
	{#State 132
		ACTIONS => {
			'DOT' => 93,
			'ASSIGN' => 180
		},
		DEFAULT => -109
	},
	{#State 133
		ACTIONS => {
			")" => 206
		}
	},
	{#State 134
		ACTIONS => {
			'BINOP' => 159,
			'OR' => 158,
			'CMPOP' => 155,
			'MOD' => 154,
			"?" => 156,
			'DIV' => 161,
			"/" => 157,
			'CAT' => 153,
			'AND' => 152,
			"+" => 160,
			")" => 207
		}
	},
	{#State 135
		ACTIONS => {
			"{" => 40,
			'THROW' => 37,
			'GET' => 38,
			'TRY' => 36,
			'STOP' => 34,
			'IF' => 33,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			"\$" => 73,
			'FOR' => 71,
			'INCLUDE' => 30,
			'LAST' => 70,
			"\"" => 68,
			'NOT' => 66,
			'UNLESS' => 67,
			'REF' => 28,
			'SET' => 65,
			'DEBUG' => 26,
			'RETURN' => 64,
			'INSERT' => 63,
			'LITERAL' => 62,
			'SWITCH' => 22,
			'PERL' => 21,
			'PROCESS' => 18,
			'NUMBER' => 59,
			"[" => 54,
			'IDENT' => 55,
			"\${" => 50,
			'DEFAULT' => 11,
			'WHILE' => 7,
			'CALL' => 47,
			'FILTER' => 46,
			'NEXT' => 44,
			"(" => 210,
			'BLOCK' => 181
		},
		GOTOS => {
			'perl' => 12,
			'try' => 52,
			'node' => 49,
			'item' => 51,
			'sterm' => 57,
			'ident' => 132,
			'atomexpr' => 53,
			'mdir' => 209,
			'expr' => 208,
			'filter' => 39,
			'loop' => 58,
			'setlist' => 14,
			'term' => 15,
			'condition' => 1,
			'switch' => 3,
			'lterm' => 4,
			'assign' => 20,
			'atomdir' => 5,
			'wrapper' => 10,
			'directive' => 184
		}
	},
	{#State 136
		ACTIONS => {
			";" => 211
		}
	},
	{#State 137
		ACTIONS => {
			'CMPOP' => 155,
			'MOD' => 154,
			'DIV' => 161,
			"?" => 156,
			'CAT' => 153,
			"+" => 160,
			'AND' => 152,
			'BINOP' => 159,
			'OR' => 158,
			"/" => 157
		},
		DEFAULT => -29
	},
	{#State 138
		ACTIONS => {
			'IDENT' => 97,
			'COMMA' => 189
		},
		DEFAULT => -17,
		GOTOS => {
			'meta' => 190
		}
	},
	{#State 139
		ACTIONS => {
			"}" => 212
		}
	},
	{#State 140
		DEFAULT => -156,
		GOTOS => {
			'args' => 213
		}
	},
	{#State 141
		ACTIONS => {
			'IDENT' => 106,
			'LITERAL' => 107,
			"\"" => 110,
			"\$" => 109,
			'NUMBER' => 79,
			'FILENAME' => 74,
			"\${" => 50
		},
		GOTOS => {
			'item' => 104,
			'names' => 75,
			'filepart' => 82,
			'nameargs' => 108,
			'filename' => 76,
			'name' => 77,
			'lnameargs' => 214,
			'lvalue' => 105
		}
	},
	{#State 142
		ACTIONS => {
			"(" => 42,
			"\"" => 68,
			"\$" => 73,
			"\${" => 50,
			'IDENT' => 55,
			"[" => 54,
			'LITERAL' => 85,
			'REF' => 28,
			'NOT' => 66,
			"{" => 40,
			'NUMBER' => 59
		},
		GOTOS => {
			'item' => 51,
			'term' => 15,
			'node' => 49,
			'expr' => 215,
			'lterm' => 4,
			'ident' => 87,
			'sterm' => 57
		}
	},
	{#State 143
		ACTIONS => {
			"\"" => 68,
			"\$" => 73,
			"\${" => 50,
			"[" => 54,
			'IDENT' => 168,
			'LITERAL' => 85,
			'REF' => 28,
			"{" => 40,
			'NUMBER' => 59
		},
		GOTOS => {
			'lterm' => 4,
			'node' => 49,
			'item' => 51,
			'term' => 169,
			'sterm' => 57,
			'ident' => 87,
			'loopvar' => 216
		}
	},
	{#State 144
		ACTIONS => {
			'NOT' => 66,
			"{" => 40,
			'REF' => 28,
			'NUMBER' => 59,
			"[" => 54,
			'IDENT' => 55,
			'LITERAL' => 85,
			"\$" => 73,
			"\${" => 50,
			"(" => 42,
			"\"" => 68
		},
		GOTOS => {
			'expr' => 217,
			'lterm' => 4,
			'term' => 15,
			'item' => 51,
			'node' => 49,
			'sterm' => 57,
			'ident' => 87
		}
	},
	{#State 145
		ACTIONS => {
			"\${" => 50,
			"\$" => 73,
			"\"" => 68,
			"(" => 42,
			'NUMBER' => 59,
			"{" => 40,
			'NOT' => 66,
			'REF' => 28,
			'LITERAL' => 85,
			"[" => 54,
			'IDENT' => 55
		},
		GOTOS => {
			'lterm' => 4,
			'expr' => 218,
			'term' => 15,
			'item' => 51,
			'node' => 49,
			'sterm' => 57,
			'ident' => 87
		}
	},
	{#State 146
		ACTIONS => {
			'IDENT' => 78,
			'LITERAL' => 80,
			"\"" => 83,
			"\$" => 84,
			'NUMBER' => 79,
			'FILENAME' => 74
		},
		GOTOS => {
			'filepart' => 82,
			'names' => 75,
			'nameargs' => 219,
			'filename' => 76,
			'name' => 77
		}
	},
	{#State 147
		ACTIONS => {
			'TO' => 220
		},
		DEFAULT => -104
	},
	{#State 148
		DEFAULT => -107
	},
	{#State 149
		DEFAULT => -116
	},
	{#State 150
		ACTIONS => {
			'NUMBER' => 59,
			"{" => 40,
			'REF' => 28,
			'LITERAL' => 85,
			"]" => 223,
			'IDENT' => 55,
			"[" => 54,
			"\${" => 50,
			'COMMA' => 222,
			"\$" => 73,
			"\"" => 68
		},
		GOTOS => {
			'lterm' => 4,
			'term' => 221,
			'item' => 51,
			'node' => 49,
			'ident' => 87,
			'sterm' => 57
		}
	},
	{#State 151
		ACTIONS => {
			"]" => 224
		}
	},
	{#State 152
		ACTIONS => {
			"\"" => 68,
			"(" => 42,
			"\${" => 50,
			"\$" => 73,
			'LITERAL' => 85,
			'IDENT' => 55,
			"[" => 54,
			'NUMBER' => 59,
			'NOT' => 66,
			'REF' => 28,
			"{" => 40
		},
		GOTOS => {
			'ident' => 87,
			'sterm' => 57,
			'node' => 49,
			'item' => 51,
			'term' => 15,
			'lterm' => 4,
			'expr' => 225
		}
	},
	{#State 153
		ACTIONS => {
			"\${" => 50,
			"\$" => 73,
			"\"" => 68,
			"(" => 42,
			'NUMBER' => 59,
			"{" => 40,
			'NOT' => 66,
			'REF' => 28,
			'LITERAL' => 85,
			"[" => 54,
			'IDENT' => 55
		},
		GOTOS => {
			'node' => 49,
			'term' => 15,
			'item' => 51,
			'expr' => 226,
			'lterm' => 4,
			'sterm' => 57,
			'ident' => 87
		}
	},
	{#State 154
		ACTIONS => {
			'NUMBER' => 59,
			'NOT' => 66,
			"{" => 40,
			'REF' => 28,
			'LITERAL' => 85,
			"[" => 54,
			'IDENT' => 55,
			"\${" => 50,
			"\$" => 73,
			"\"" => 68,
			"(" => 42
		},
		GOTOS => {
			'sterm' => 57,
			'ident' => 87,
			'lterm' => 4,
			'expr' => 227,
			'item' => 51,
			'term' => 15,
			'node' => 49
		}
	},
	{#State 155
		ACTIONS => {
			"(" => 42,
			"\"" => 68,
			"\$" => 73,
			"\${" => 50,
			'IDENT' => 55,
			"[" => 54,
			'LITERAL' => 85,
			'NOT' => 66,
			'REF' => 28,
			"{" => 40,
			'NUMBER' => 59
		},
		GOTOS => {
			'item' => 51,
			'term' => 15,
			'node' => 49,
			'lterm' => 4,
			'expr' => 228,
			'sterm' => 57,
			'ident' => 87
		}
	},
	{#State 156
		ACTIONS => {
			"\${" => 50,
			"\$" => 73,
			"\"" => 68,
			"(" => 42,
			'NUMBER' => 59,
			'NOT' => 66,
			'REF' => 28,
			"{" => 40,
			'LITERAL' => 85,
			"[" => 54,
			'IDENT' => 55
		},
		GOTOS => {
			'sterm' => 57,
			'ident' => 87,
			'node' => 49,
			'term' => 15,
			'item' => 51,
			'lterm' => 4,
			'expr' => 229
		}
	},
	{#State 157
		ACTIONS => {
			"[" => 54,
			'IDENT' => 55,
			'LITERAL' => 85,
			"{" => 40,
			'REF' => 28,
			'NOT' => 66,
			'NUMBER' => 59,
			"(" => 42,
			"\"" => 68,
			"\$" => 73,
			"\${" => 50
		},
		GOTOS => {
			'ident' => 87,
			'sterm' => 57,
			'node' => 49,
			'term' => 15,
			'item' => 51,
			'lterm' => 4,
			'expr' => 230
		}
	},
	{#State 158
		ACTIONS => {
			'NUMBER' => 59,
			'REF' => 28,
			'NOT' => 66,
			"{" => 40,
			'LITERAL' => 85,
			"[" => 54,
			'IDENT' => 55,
			"\${" => 50,
			"\$" => 73,
			"\"" => 68,
			"(" => 42
		},
		GOTOS => {
			'node' => 49,
			'term' => 15,
			'item' => 51,
			'expr' => 231,
			'lterm' => 4,
			'ident' => 87,
			'sterm' => 57
		}
	},
	{#State 159
		ACTIONS => {
			"[" => 54,
			'IDENT' => 55,
			'LITERAL' => 85,
			"{" => 40,
			'NOT' => 66,
			'REF' => 28,
			'NUMBER' => 59,
			"(" => 42,
			"\"" => 68,
			"\$" => 73,
			"\${" => 50
		},
		GOTOS => {
			'sterm' => 57,
			'ident' => 87,
			'expr' => 232,
			'lterm' => 4,
			'term' => 15,
			'item' => 51,
			'node' => 49
		}
	},
	{#State 160
		ACTIONS => {
			"\$" => 73,
			"\${" => 50,
			"(" => 42,
			"\"" => 68,
			'REF' => 28,
			"{" => 40,
			'NOT' => 66,
			'NUMBER' => 59,
			"[" => 54,
			'IDENT' => 55,
			'LITERAL' => 85
		},
		GOTOS => {
			'sterm' => 57,
			'ident' => 87,
			'lterm' => 4,
			'expr' => 233,
			'item' => 51,
			'term' => 15,
			'node' => 49
		}
	},
	{#State 161
		ACTIONS => {
			'LITERAL' => 85,
			"[" => 54,
			'IDENT' => 55,
			'NUMBER' => 59,
			'NOT' => 66,
			'REF' => 28,
			"{" => 40,
			"\"" => 68,
			"(" => 42,
			"\${" => 50,
			"\$" => 73
		},
		GOTOS => {
			'ident' => 87,
			'sterm' => 57,
			'node' => 49,
			'term' => 15,
			'item' => 51,
			'expr' => 234,
			'lterm' => 4
		}
	},
	{#State 162
		ACTIONS => {
			"\"" => 68,
			"(" => 42,
			"\${" => 50,
			"\$" => 73,
			'LITERAL' => 85,
			"[" => 54,
			'IDENT' => 55,
			'NUMBER' => 59,
			'NOT' => 66,
			"{" => 40,
			'REF' => 28
		},
		GOTOS => {
			'node' => 49,
			'term' => 15,
			'item' => 51,
			'expr' => 235,
			'lterm' => 4,
			'sterm' => 57,
			'ident' => 87
		}
	},
	{#State 163
		DEFAULT => -32
	},
	{#State 164
		ACTIONS => {
			"\$" => 73,
			"\${" => 50,
			'COMMA' => 94,
			'IDENT' => 55,
			'LITERAL' => 89
		},
		DEFAULT => -30,
		GOTOS => {
			'item' => 51,
			'assign' => 95,
			'node' => 49,
			'ident' => 91
		}
	},
	{#State 165
		ACTIONS => {
			"/" => 157,
			"+" => 160,
			'DIV' => 161,
			'BINOP' => 159,
			'MOD' => 154,
			'CMPOP' => 155,
			'CAT' => 153
		},
		DEFAULT => -142
	},
	{#State 166
		ACTIONS => {
			'MOD' => 154,
			";" => 236,
			'CMPOP' => 155,
			'OR' => 158,
			'BINOP' => 159,
			"+" => 160,
			'AND' => 152,
			"?" => 156,
			'DIV' => 161,
			'CAT' => 153,
			"/" => 157
		}
	},
	{#State 167
		ACTIONS => {
			'IDENT' => 55,
			"\"" => 237,
			"\$" => 73,
			";" => 240,
			'TEXT' => 238,
			"\${" => 50
		},
		GOTOS => {
			'quotable' => 239,
			'ident' => 241,
			'node' => 49,
			'item' => 51
		}
	},
	{#State 168
		ACTIONS => {
			'IN' => 243,
			'ASSIGN' => 242
		},
		DEFAULT => -130
	},
	{#State 169
		DEFAULT => -156,
		GOTOS => {
			'args' => 244
		}
	},
	{#State 170
		ACTIONS => {
			";" => 245
		}
	},
	{#State 171
		DEFAULT => -132
	},
	{#State 172
		DEFAULT => -156,
		GOTOS => {
			'args' => 246
		}
	},
	{#State 173
		ACTIONS => {
			'REF' => 28,
			'NOT' => 66,
			'LITERAL' => 248,
			'COMMA' => 247,
			"(" => 42,
			"{" => 40,
			'NUMBER' => 59,
			"[" => 54,
			'IDENT' => 55,
			"\$" => 73,
			"\${" => 50,
			"\"" => 68
		},
		DEFAULT => -163,
		GOTOS => {
			'param' => 251,
			'item' => 249,
			'node' => 49,
			'lterm' => 4,
			'ident' => 252,
			'sterm' => 57,
			'term' => 15,
			'expr' => 250
		}
	},
	{#State 174
		ACTIONS => {
			'NUMBER' => 79,
			'FILENAME' => 74,
			'IDENT' => 78,
			"\"" => 83,
			'LITERAL' => 80
		},
		GOTOS => {
			'filename' => 76,
			'name' => 253,
			'filepart' => 82
		}
	},
	{#State 175
		ACTIONS => {
			'IDENT' => 78,
			'NUMBER' => 79,
			'FILENAME' => 74
		},
		GOTOS => {
			'filepart' => 254
		}
	},
	{#State 176
		DEFAULT => -74,
		GOTOS => {
			'@3-3' => 255
		}
	},
	{#State 177
		ACTIONS => {
			"\"" => 256,
			'IDENT' => 55,
			";" => 240,
			'TEXT' => 238,
			"\${" => 50,
			"\$" => 73
		},
		GOTOS => {
			'node' => 49,
			'item' => 51,
			'ident' => 241,
			'quotable' => 239
		}
	},
	{#State 178
		ACTIONS => {
			'DOT' => 93
		},
		DEFAULT => -156,
		GOTOS => {
			'args' => 257
		}
	},
	{#State 179
		DEFAULT => -59,
		GOTOS => {
			'@2-3' => 258
		}
	},
	{#State 180
		ACTIONS => {
			'IDENT' => 55,
			"[" => 54,
			'LITERAL' => 85,
			'REF' => 28,
			"{" => 40,
			'NOT' => 66,
			'NUMBER' => 59,
			"(" => 42,
			"\"" => 68,
			"\$" => 73,
			"\${" => 50
		},
		GOTOS => {
			'term' => 15,
			'item' => 51,
			'node' => 49,
			'expr' => 259,
			'lterm' => 4,
			'sterm' => 57,
			'ident' => 87
		}
	},
	{#State 181
		ACTIONS => {
			";" => 260
		}
	},
	{#State 182
		ACTIONS => {
			'CMPOP' => 155,
			'MOD' => 154,
			'LITERAL' => -150,
			'AND' => 152,
			"+" => 160,
			'COMMA' => -150,
			"?" => 156,
			'CAT' => 153,
			'DIV' => 161,
			";" => -150,
			'IDENT' => -150,
			'OR' => 158,
			'BINOP' => 159,
			"\$" => -150,
			"\${" => -150,
			"/" => 157
		},
		DEFAULT => -26
	},
	{#State 183
		DEFAULT => -89
	},
	{#State 184
		DEFAULT => -92
	},
	{#State 185
		DEFAULT => -126
	},
	{#State 186
		DEFAULT => -125
	},
	{#State 187
		ACTIONS => {
			'NUMBER' => 261,
			'LITERAL' => 262,
			"\"" => 263
		}
	},
	{#State 188
		ACTIONS => {
			'RETURN' => 64,
			'DEBUG' => 26,
			'SET' => 65,
			'UNLESS' => 67,
			'REF' => 28,
			'NOT' => 66,
			'SWITCH' => 22,
			'LITERAL' => 62,
			'INSERT' => 63,
			'USE' => 24,
			'PERL' => 21,
			'PROCESS' => 18,
			"{" => 40,
			'IF' => 33,
			'STOP' => 34,
			'TRY' => 36,
			'THROW' => 37,
			'GET' => 38,
			'INCLUDE' => 30,
			'LAST' => 70,
			'FOR' => 71,
			'WRAPPER' => 32,
			'CLEAR' => 72,
			"\$" => 73,
			"\"" => 68,
			'RAWPERL' => 29,
			'WHILE' => 7,
			'VIEW' => 2,
			'FILTER' => 46,
			'MACRO' => 45,
			'CALL' => 47,
			'BLOCK' => 41,
			"(" => 42,
			'NEXT' => 44,
			'TEXT' => 60,
			";" => -18,
			'NUMBER' => 59,
			"[" => 54,
			'IDENT' => 55,
			"\${" => 50,
			'DEFAULT' => 11,
			'META' => 48
		},
		DEFAULT => -3,
		GOTOS => {
			'chunk' => 31,
			'block' => 69,
			'filter' => 39,
			'use' => 35,
			'assign' => 20,
			'capture' => 19,
			'directive' => 27,
			'statement' => 25,
			'defblock' => 23,
			'item' => 51,
			'node' => 49,
			'try' => 52,
			'perl' => 12,
			'term' => 15,
			'setlist' => 14,
			'loop' => 58,
			'defblockname' => 17,
			'expr' => 61,
			'chunks' => 16,
			'atomexpr' => 53,
			'view' => 56,
			'sterm' => 57,
			'ident' => 13,
			'lterm' => 4,
			'switch' => 3,
			'condition' => 1,
			'rawperl' => 43,
			'anonblock' => 9,
			'template' => 264,
			'wrapper' => 10,
			'macro' => 6,
			'atomdir' => 5
		}
	},
	{#State 189
		DEFAULT => -98
	},
	{#State 190
		DEFAULT => -97
	},
	{#State 191
		ACTIONS => {
			'IDENT' => 55,
			"[" => 54,
			";" => -18,
			'NUMBER' => 59,
			'TEXT' => 60,
			'DEFAULT' => 11,
			'META' => 48,
			"\${" => 50,
			'WHILE' => 7,
			'BLOCK' => 41,
			'NEXT' => 44,
			"(" => 42,
			'FILTER' => 46,
			'MACRO' => 45,
			'VIEW' => 2,
			'CALL' => 47,
			'STOP' => 34,
			'IF' => 33,
			'THROW' => 37,
			'GET' => 38,
			'TRY' => 36,
			"{" => 40,
			"\"" => 68,
			'RAWPERL' => 29,
			'LAST' => 70,
			'INCLUDE' => 30,
			"\$" => 73,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			'FOR' => 71,
			'LITERAL' => 62,
			'INSERT' => 63,
			'SWITCH' => 22,
			'USE' => 24,
			'DEBUG' => 26,
			'RETURN' => 64,
			'REF' => 28,
			'NOT' => 66,
			'UNLESS' => 67,
			'SET' => 65,
			'PROCESS' => 18,
			'PERL' => 21
		},
		DEFAULT => -3,
		GOTOS => {
			'chunk' => 31,
			'item' => 51,
			'block' => 265,
			'node' => 49,
			'try' => 52,
			'perl' => 12,
			'setlist' => 14,
			'term' => 15,
			'loop' => 58,
			'filter' => 39,
			'defblockname' => 17,
			'expr' => 61,
			'chunks' => 16,
			'atomexpr' => 53,
			'sterm' => 57,
			'view' => 56,
			'use' => 35,
			'ident' => 13,
			'assign' => 20,
			'capture' => 19,
			'switch' => 3,
			'lterm' => 4,
			'condition' => 1,
			'rawperl' => 43,
			'anonblock' => 9,
			'directive' => 27,
			'statement' => 25,
			'wrapper' => 10,
			'defblock' => 23,
			'macro' => 6,
			'atomdir' => 5
		}
	},
	{#State 192
		ACTIONS => {
			'VIEW' => 2,
			'MACRO' => 45,
			'FILTER' => 46,
			'CALL' => 47,
			'BLOCK' => 41,
			"(" => 42,
			'NEXT' => 44,
			'WHILE' => 7,
			"\${" => 50,
			'DEFAULT' => 11,
			'META' => 48,
			'TEXT' => 60,
			";" => -18,
			'NUMBER' => 59,
			'IDENT' => 55,
			"[" => 54,
			'PERL' => 21,
			'PROCESS' => 18,
			'RETURN' => 64,
			'DEBUG' => 26,
			'SET' => 65,
			'UNLESS' => 67,
			'REF' => 28,
			'NOT' => 66,
			'INSERT' => 63,
			'LITERAL' => 62,
			'SWITCH' => 22,
			'USE' => 24,
			'INCLUDE' => 30,
			'LAST' => 70,
			'FOR' => 71,
			'CLEAR' => 72,
			"\$" => 73,
			'WRAPPER' => 32,
			"\"" => 68,
			'RAWPERL' => 29,
			"{" => 40,
			'IF' => 33,
			'STOP' => 34,
			'TRY' => 36,
			'GET' => 38,
			'THROW' => 37
		},
		DEFAULT => -3,
		GOTOS => {
			'atomdir' => 5,
			'macro' => 6,
			'defblock' => 23,
			'statement' => 25,
			'anonblock' => 9,
			'directive' => 27,
			'wrapper' => 10,
			'condition' => 1,
			'rawperl' => 43,
			'assign' => 20,
			'capture' => 19,
			'lterm' => 4,
			'switch' => 3,
			'atomexpr' => 53,
			'view' => 56,
			'sterm' => 57,
			'ident' => 13,
			'use' => 35,
			'loop' => 58,
			'filter' => 39,
			'term' => 15,
			'setlist' => 14,
			'chunks' => 16,
			'defblockname' => 17,
			'expr' => 61,
			'perl' => 12,
			'block' => 266,
			'node' => 49,
			'item' => 51,
			'chunk' => 31,
			'try' => 52
		}
	},
	{#State 193
		ACTIONS => {
			"\$" => 84,
			'NUMBER' => 79,
			'FILENAME' => 74,
			'IDENT' => 78,
			'LITERAL' => 80,
			"\"" => 83
		},
		GOTOS => {
			'names' => 75,
			'filepart' => 82,
			'filename' => 76,
			'name' => 77,
			'nameargs' => 267
		}
	},
	{#State 194
		ACTIONS => {
			'ASSIGN' => -132
		},
		DEFAULT => -130
	},
	{#State 195
		ACTIONS => {
			"\"" => 268,
			'IDENT' => 55,
			'TEXT' => 238,
			";" => 240,
			"\${" => 50,
			"\$" => 73
		},
		GOTOS => {
			'item' => 51,
			'node' => 49,
			'quotable' => 239,
			'ident' => 241
		}
	},
	{#State 196
		ACTIONS => {
			'TEXT' => 269
		}
	},
	{#State 197
		ACTIONS => {
			"{" => 40,
			'STOP' => 34,
			'IF' => 33,
			'THROW' => 37,
			'GET' => 38,
			'TRY' => 36,
			'LAST' => 70,
			'INCLUDE' => 30,
			'WRAPPER' => 32,
			'CLEAR' => 72,
			"\$" => 73,
			'FOR' => 71,
			"\"" => 68,
			'RAWPERL' => 29,
			'DEBUG' => 26,
			'RETURN' => 64,
			'NOT' => 66,
			'REF' => 28,
			'UNLESS' => 67,
			'SET' => 65,
			'INSERT' => 63,
			'SWITCH' => 22,
			'LITERAL' => 62,
			'USE' => 24,
			'PERL' => 21,
			'PROCESS' => 18,
			'TEXT' => 60,
			";" => -18,
			'NUMBER' => 59,
			"[" => 54,
			'IDENT' => 55,
			"\${" => 50,
			'DEFAULT' => 11,
			'META' => 48,
			'WHILE' => 7,
			'MACRO' => 45,
			'FILTER' => 46,
			'VIEW' => 2,
			'CALL' => 47,
			'BLOCK' => 41,
			'NEXT' => 44,
			"(" => 42
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 9,
			'directive' => 27,
			'statement' => 25,
			'wrapper' => 10,
			'macro' => 6,
			'atomdir' => 5,
			'defblock' => 23,
			'assign' => 20,
			'capture' => 19,
			'switch' => 3,
			'lterm' => 4,
			'condition' => 1,
			'rawperl' => 43,
			'term' => 15,
			'setlist' => 14,
			'filter' => 39,
			'loop' => 58,
			'expr' => 61,
			'defblockname' => 17,
			'chunks' => 16,
			'atomexpr' => 53,
			'use' => 35,
			'ident' => 13,
			'sterm' => 57,
			'view' => 56,
			'item' => 51,
			'chunk' => 31,
			'block' => 270,
			'node' => 49,
			'try' => 52,
			'perl' => 12
		}
	},
	{#State 198
		ACTIONS => {
			"\${" => 50,
			'DEFAULT' => 11,
			'META' => 48,
			";" => -18,
			'NUMBER' => 59,
			'TEXT' => 60,
			"[" => 54,
			'IDENT' => 55,
			'VIEW' => 2,
			'FILTER' => 46,
			'MACRO' => 45,
			'CALL' => 47,
			'BLOCK' => 41,
			"(" => 42,
			'NEXT' => 44,
			'WHILE' => 7,
			'LAST' => 70,
			'INCLUDE' => 30,
			'FOR' => 71,
			'CLEAR' => 72,
			"\$" => 73,
			'WRAPPER' => 32,
			"\"" => 68,
			'RAWPERL' => 29,
			"{" => 40,
			'IF' => 33,
			'STOP' => 34,
			'TRY' => 36,
			'GET' => 38,
			'THROW' => 37,
			'PERL' => 21,
			'PROCESS' => 18,
			'RETURN' => 64,
			'DEBUG' => 26,
			'SET' => 65,
			'REF' => 28,
			'UNLESS' => 67,
			'NOT' => 66,
			'INSERT' => 63,
			'SWITCH' => 22,
			'LITERAL' => 62,
			'USE' => 24
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 10,
			'statement' => 25,
			'directive' => 27,
			'anonblock' => 9,
			'macro' => 6,
			'defblock' => 23,
			'atomdir' => 5,
			'switch' => 3,
			'lterm' => 4,
			'assign' => 20,
			'capture' => 19,
			'rawperl' => 43,
			'condition' => 1,
			'chunks' => 16,
			'expr' => 61,
			'defblockname' => 17,
			'loop' => 58,
			'filter' => 39,
			'term' => 15,
			'setlist' => 14,
			'view' => 56,
			'ident' => 13,
			'sterm' => 57,
			'use' => 35,
			'atomexpr' => 53,
			'try' => 52,
			'node' => 49,
			'block' => 271,
			'chunk' => 31,
			'item' => 51,
			'perl' => 12
		}
	},
	{#State 199
		ACTIONS => {
			'FINAL' => 272,
			'CATCH' => 273
		},
		DEFAULT => -72,
		GOTOS => {
			'final' => 274
		}
	},
	{#State 200
		ACTIONS => {
			'REF' => 28,
			"{" => 40,
			'NOT' => 66,
			'NUMBER' => 59,
			'IDENT' => 55,
			"[" => 54,
			'LITERAL' => 85,
			"\$" => 73,
			"\${" => 50,
			"(" => 42,
			"\"" => 68
		},
		GOTOS => {
			'term' => 15,
			'item' => 51,
			'node' => 49,
			'lterm' => 4,
			'expr' => 275,
			'ident' => 87,
			'sterm' => 57
		}
	},
	{#State 201
		DEFAULT => -120
	},
	{#State 202
		DEFAULT => -121
	},
	{#State 203
		ACTIONS => {
			"\${" => 50,
			"\$" => 73,
			"\"" => 68,
			"(" => 42,
			'NUMBER' => 59,
			'REF' => 28,
			"{" => 40,
			'NOT' => 66,
			'LITERAL' => 85,
			"[" => 54,
			'IDENT' => 55
		},
		GOTOS => {
			'expr' => 276,
			'lterm' => 4,
			'node' => 49,
			'item' => 51,
			'term' => 15,
			'ident' => 87,
			'sterm' => 57
		}
	},
	{#State 204
		DEFAULT => -108
	},
	{#State 205
		ACTIONS => {
			'WHILE' => 7,
			'NEXT' => 44,
			"(" => 42,
			'BLOCK' => 41,
			'CALL' => 47,
			'FILTER' => 46,
			'MACRO' => 45,
			'VIEW' => 2,
			'IDENT' => 55,
			"[" => 54,
			";" => -18,
			'NUMBER' => 59,
			'TEXT' => 60,
			'META' => 48,
			'DEFAULT' => 11,
			"\${" => 50,
			'USE' => 24,
			'SWITCH' => 22,
			'LITERAL' => 62,
			'INSERT' => 63,
			'UNLESS' => 67,
			'REF' => 28,
			'NOT' => 66,
			'SET' => 65,
			'DEBUG' => 26,
			'RETURN' => 64,
			'PROCESS' => 18,
			'PERL' => 21,
			'GET' => 38,
			'THROW' => 37,
			'TRY' => 36,
			'STOP' => 34,
			'IF' => 33,
			"{" => 40,
			'RAWPERL' => 29,
			"\"" => 68,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			"\$" => 73,
			'FOR' => 71,
			'INCLUDE' => 30,
			'LAST' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'node' => 49,
			'block' => 277,
			'item' => 51,
			'chunk' => 31,
			'try' => 52,
			'perl' => 12,
			'filter' => 39,
			'loop' => 58,
			'setlist' => 14,
			'term' => 15,
			'chunks' => 16,
			'expr' => 61,
			'defblockname' => 17,
			'atomexpr' => 53,
			'ident' => 13,
			'use' => 35,
			'sterm' => 57,
			'view' => 56,
			'capture' => 19,
			'assign' => 20,
			'switch' => 3,
			'lterm' => 4,
			'condition' => 1,
			'rawperl' => 43,
			'statement' => 25,
			'directive' => 27,
			'anonblock' => 9,
			'wrapper' => 10,
			'atomdir' => 5,
			'defblock' => 23,
			'macro' => 6
		}
	},
	{#State 206
		DEFAULT => -144
	},
	{#State 207
		DEFAULT => -145
	},
	{#State 208
		ACTIONS => {
			'CMPOP' => 155,
			'MOD' => 154,
			'DIV' => 161,
			'CAT' => 153,
			"?" => 156,
			"+" => 160,
			'AND' => 152,
			'OR' => 158,
			'BINOP' => 159,
			"/" => 157
		},
		DEFAULT => -26
	},
	{#State 209
		DEFAULT => -91
	},
	{#State 210
		ACTIONS => {
			"\$" => 73,
			"\${" => 50,
			"(" => 42,
			"\"" => 68,
			'NOT' => 66,
			"{" => 40,
			'REF' => 28,
			'NUMBER' => 59,
			'IDENT' => 278,
			"[" => 54,
			'LITERAL' => 62
		},
		GOTOS => {
			'lterm' => 4,
			'assign' => 133,
			'node' => 49,
			'item' => 51,
			'expr' => 134,
			'margs' => 279,
			'term' => 15,
			'ident' => 132,
			'sterm' => 57
		}
	},
	{#State 211
		ACTIONS => {
			'FOR' => 71,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			"\$" => 73,
			'INCLUDE' => 30,
			'LAST' => 70,
			'RAWPERL' => 29,
			"\"" => 68,
			"{" => 40,
			'TRY' => 36,
			'THROW' => 37,
			'GET' => 38,
			'IF' => 33,
			'STOP' => 34,
			'PERL' => 21,
			'PROCESS' => 18,
			'SET' => 65,
			'UNLESS' => 67,
			'NOT' => 66,
			'REF' => 28,
			'RETURN' => 64,
			'DEBUG' => 26,
			'USE' => 24,
			'INSERT' => 63,
			'LITERAL' => 62,
			'SWITCH' => 22,
			"\${" => 50,
			'META' => 48,
			'DEFAULT' => 11,
			";" => -18,
			'NUMBER' => 59,
			'TEXT' => 60,
			"[" => 54,
			'IDENT' => 55,
			'CALL' => 47,
			'VIEW' => 2,
			'FILTER' => 46,
			'MACRO' => 45,
			"(" => 42,
			'NEXT' => 44,
			'BLOCK' => 41,
			'WHILE' => 7
		},
		DEFAULT => -3,
		GOTOS => {
			'assign' => 20,
			'capture' => 19,
			'lterm' => 4,
			'switch' => 3,
			'condition' => 1,
			'rawperl' => 43,
			'directive' => 27,
			'anonblock' => 9,
			'statement' => 25,
			'wrapper' => 10,
			'defblock' => 23,
			'atomdir' => 5,
			'macro' => 6,
			'chunk' => 31,
			'item' => 51,
			'node' => 49,
			'block' => 280,
			'try' => 52,
			'perl' => 12,
			'term' => 15,
			'setlist' => 14,
			'filter' => 39,
			'loop' => 58,
			'defblockname' => 17,
			'expr' => 61,
			'chunks' => 16,
			'atomexpr' => 53,
			'view' => 56,
			'sterm' => 57,
			'use' => 35,
			'ident' => 13
		}
	},
	{#State 212
		DEFAULT => -131
	},
	{#State 213
		ACTIONS => {
			"[" => 54,
			'IDENT' => 55,
			'LITERAL' => 248,
			'REF' => 28,
			'NOT' => 66,
			"{" => 40,
			'NUMBER' => 59,
			"(" => 42,
			"\"" => 68,
			"\$" => 73,
			'COMMA' => 247,
			")" => 281,
			"\${" => 50
		},
		GOTOS => {
			'expr' => 250,
			'term' => 15,
			'ident' => 252,
			'sterm' => 57,
			'lterm' => 4,
			'item' => 249,
			'node' => 49,
			'param' => 251
		}
	},
	{#State 214
		DEFAULT => -81
	},
	{#State 215
		ACTIONS => {
			'AND' => 152,
			"+" => 160,
			'DIV' => 161,
			"/" => 157,
			'CAT' => 153,
			"?" => 156,
			'CMPOP' => 155,
			'MOD' => 154,
			'BINOP' => 159,
			'OR' => 158
		},
		DEFAULT => -47
	},
	{#State 216
		DEFAULT => -58
	},
	{#State 217
		ACTIONS => {
			'BINOP' => 159,
			'OR' => 158,
			'MOD' => 154,
			'CMPOP' => 155,
			'CAT' => 153,
			"?" => 156,
			"/" => 157,
			'DIV' => 161,
			'AND' => 152,
			"+" => 160
		},
		DEFAULT => -61
	},
	{#State 218
		ACTIONS => {
			'AND' => 152,
			"+" => 160,
			'DIV' => 161,
			"/" => 157,
			"?" => 156,
			'CAT' => 153,
			'MOD' => 154,
			'CMPOP' => 155,
			'BINOP' => 159,
			'OR' => 158
		},
		DEFAULT => -45
	},
	{#State 219
		DEFAULT => -66
	},
	{#State 220
		ACTIONS => {
			'NUMBER' => 59,
			"\${" => 50,
			"\$" => 73,
			'REF' => 28,
			'LITERAL' => 85,
			"\"" => 68,
			'IDENT' => 55
		},
		GOTOS => {
			'node' => 49,
			'item' => 51,
			'sterm' => 282,
			'ident' => 87
		}
	},
	{#State 221
		DEFAULT => -114
	},
	{#State 222
		DEFAULT => -115
	},
	{#State 223
		DEFAULT => -105
	},
	{#State 224
		DEFAULT => -106
	},
	{#State 225
		ACTIONS => {
			"+" => 160,
			'DIV' => 161,
			"/" => 157,
			'CMPOP' => 155,
			'MOD' => 154,
			'CAT' => 153,
			'BINOP' => 159
		},
		DEFAULT => -140
	},
	{#State 226
		ACTIONS => {
			'BINOP' => 159,
			'MOD' => 154,
			'CMPOP' => 155,
			"/" => 157,
			'DIV' => 161,
			"+" => 160
		},
		DEFAULT => -139
	},
	{#State 227
		DEFAULT => -137
	},
	{#State 228
		ACTIONS => {
			'MOD' => 154,
			'BINOP' => 159,
			'DIV' => 161,
			"+" => 160,
			"/" => 157
		},
		DEFAULT => -138
	},
	{#State 229
		ACTIONS => {
			'BINOP' => 159,
			'OR' => 158,
			'MOD' => 154,
			'CMPOP' => 155,
			'DIV' => 161,
			"/" => 157,
			"?" => 156,
			'CAT' => 153,
			":" => 283,
			"+" => 160,
			'AND' => 152
		}
	},
	{#State 230
		ACTIONS => {
			'DIV' => 161,
			'MOD' => 154
		},
		DEFAULT => -134
	},
	{#State 231
		ACTIONS => {
			"+" => 160,
			'DIV' => 161,
			"/" => 157,
			'CMPOP' => 155,
			'MOD' => 154,
			'CAT' => 153,
			'BINOP' => 159
		},
		DEFAULT => -141
	},
	{#State 232
		ACTIONS => {
			"/" => 157,
			'DIV' => 161,
			"+" => 160,
			'MOD' => 154
		},
		DEFAULT => -133
	},
	{#State 233
		ACTIONS => {
			'MOD' => 154,
			"/" => 157,
			'DIV' => 161
		},
		DEFAULT => -135
	},
	{#State 234
		ACTIONS => {
			'MOD' => 154
		},
		DEFAULT => -136
	},
	{#State 235
		ACTIONS => {
			'BINOP' => 159,
			'OR' => 158,
			"/" => 157,
			'MOD' => 154,
			'CMPOP' => 155,
			"+" => 160,
			'AND' => 152,
			'DIV' => 161,
			'CAT' => 153,
			"?" => 156
		},
		DEFAULT => -151
	},
	{#State 236
		ACTIONS => {
			'WHILE' => 7,
			'NEXT' => 44,
			"(" => 42,
			'BLOCK' => 41,
			'CALL' => 47,
			'MACRO' => 45,
			'FILTER' => 46,
			'VIEW' => 2,
			"[" => 54,
			'IDENT' => 55,
			'TEXT' => 60,
			";" => -18,
			'NUMBER' => 59,
			'META' => 48,
			'DEFAULT' => 11,
			"\${" => 50,
			'USE' => 24,
			'LITERAL' => 62,
			'SWITCH' => 22,
			'INSERT' => 63,
			'NOT' => 66,
			'REF' => 28,
			'UNLESS' => 67,
			'SET' => 65,
			'DEBUG' => 26,
			'RETURN' => 64,
			'PROCESS' => 18,
			'PERL' => 21,
			'THROW' => 37,
			'GET' => 38,
			'TRY' => 36,
			'STOP' => 34,
			'IF' => 33,
			"{" => 40,
			'RAWPERL' => 29,
			"\"" => 68,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			"\$" => 73,
			'FOR' => 71,
			'INCLUDE' => 30,
			'LAST' => 70
		},
		DEFAULT => -3,
		GOTOS => {
			'condition' => 1,
			'rawperl' => 43,
			'capture' => 19,
			'assign' => 20,
			'switch' => 3,
			'lterm' => 4,
			'defblock' => 23,
			'atomdir' => 5,
			'macro' => 6,
			'statement' => 25,
			'anonblock' => 9,
			'directive' => 27,
			'wrapper' => 10,
			'perl' => 12,
			'node' => 49,
			'block' => 284,
			'item' => 51,
			'chunk' => 31,
			'try' => 52,
			'atomexpr' => 53,
			'ident' => 13,
			'use' => 35,
			'view' => 56,
			'sterm' => 57,
			'filter' => 39,
			'loop' => 58,
			'term' => 15,
			'setlist' => 14,
			'chunks' => 16,
			'defblockname' => 17,
			'expr' => 61
		}
	},
	{#State 237
		DEFAULT => -111
	},
	{#State 238
		DEFAULT => -178
	},
	{#State 239
		DEFAULT => -175
	},
	{#State 240
		DEFAULT => -179
	},
	{#State 241
		ACTIONS => {
			'DOT' => 93
		},
		DEFAULT => -177
	},
	{#State 242
		ACTIONS => {
			'IDENT' => 55,
			"[" => 54,
			'LITERAL' => 85,
			'REF' => 28,
			"{" => 40,
			'NUMBER' => 59,
			"\"" => 68,
			"\$" => 73,
			"\${" => 50
		},
		GOTOS => {
			'sterm' => 57,
			'ident' => 87,
			'term' => 285,
			'item' => 51,
			'node' => 49,
			'lterm' => 4
		}
	},
	{#State 243
		ACTIONS => {
			'REF' => 28,
			"{" => 40,
			'NUMBER' => 59,
			'IDENT' => 55,
			"[" => 54,
			'LITERAL' => 85,
			"\$" => 73,
			"\${" => 50,
			"\"" => 68
		},
		GOTOS => {
			'ident' => 87,
			'sterm' => 57,
			'lterm' => 4,
			'item' => 51,
			'term' => 286,
			'node' => 49
		}
	},
	{#State 244
		ACTIONS => {
			'NUMBER' => 59,
			'NOT' => 66,
			"{" => 40,
			'REF' => 28,
			'LITERAL' => 248,
			'IDENT' => 55,
			"[" => 54,
			"\${" => 50,
			'COMMA' => 247,
			"\$" => 73,
			"\"" => 68,
			"(" => 42
		},
		DEFAULT => -64,
		GOTOS => {
			'lterm' => 4,
			'item' => 249,
			'node' => 49,
			'param' => 251,
			'expr' => 250,
			'term' => 15,
			'ident' => 252,
			'sterm' => 57
		}
	},
	{#State 245
		DEFAULT => -56,
		GOTOS => {
			'@1-3' => 287
		}
	},
	{#State 246
		ACTIONS => {
			"(" => 42,
			"\"" => 68,
			"\$" => 73,
			"\${" => 50,
			")" => 288,
			'COMMA' => 247,
			"[" => 54,
			'IDENT' => 55,
			'LITERAL' => 248,
			"{" => 40,
			'NOT' => 66,
			'REF' => 28,
			'NUMBER' => 59
		},
		GOTOS => {
			'ident' => 252,
			'sterm' => 57,
			'term' => 15,
			'expr' => 250,
			'param' => 251,
			'node' => 49,
			'item' => 249,
			'lterm' => 4
		}
	},
	{#State 247
		DEFAULT => -155
	},
	{#State 248
		ACTIONS => {
			'ASSIGN' => 200
		},
		DEFAULT => -112
	},
	{#State 249
		ACTIONS => {
			"(" => 140,
			'ASSIGN' => 203
		},
		DEFAULT => -128
	},
	{#State 250
		ACTIONS => {
			"/" => 157,
			'BINOP' => 159,
			'OR' => 158,
			'DIV' => 161,
			"?" => 156,
			'CAT' => 153,
			'AND' => 152,
			"+" => 160,
			'MOD' => 154,
			'CMPOP' => 155
		},
		DEFAULT => -152
	},
	{#State 251
		DEFAULT => -153
	},
	{#State 252
		ACTIONS => {
			'DOT' => 93,
			'ASSIGN' => 289
		},
		DEFAULT => -109
	},
	{#State 253
		DEFAULT => -165
	},
	{#State 254
		DEFAULT => -170
	},
	{#State 255
		ACTIONS => {
			'STOP' => 34,
			'IF' => 33,
			'THROW' => 37,
			'GET' => 38,
			'TRY' => 36,
			"{" => 40,
			"\"" => 68,
			'RAWPERL' => 29,
			'LAST' => 70,
			'INCLUDE' => 30,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			"\$" => 73,
			'FOR' => 71,
			'SWITCH' => 22,
			'INSERT' => 63,
			'LITERAL' => 62,
			'USE' => 24,
			'DEBUG' => 26,
			'RETURN' => 64,
			'UNLESS' => 67,
			'NOT' => 66,
			'REF' => 28,
			'SET' => 65,
			'PROCESS' => 18,
			'PERL' => 21,
			"[" => 54,
			'IDENT' => 55,
			";" => -18,
			'TEXT' => 60,
			'NUMBER' => 59,
			'DEFAULT' => 11,
			'META' => 48,
			"\${" => 50,
			'WHILE' => 7,
			'BLOCK' => 41,
			'NEXT' => 44,
			"(" => 42,
			'MACRO' => 45,
			'FILTER' => 46,
			'VIEW' => 2,
			'CALL' => 47
		},
		DEFAULT => -3,
		GOTOS => {
			'item' => 51,
			'chunk' => 31,
			'node' => 49,
			'block' => 290,
			'try' => 52,
			'perl' => 12,
			'term' => 15,
			'setlist' => 14,
			'loop' => 58,
			'filter' => 39,
			'expr' => 61,
			'defblockname' => 17,
			'chunks' => 16,
			'atomexpr' => 53,
			'view' => 56,
			'ident' => 13,
			'sterm' => 57,
			'use' => 35,
			'assign' => 20,
			'capture' => 19,
			'switch' => 3,
			'lterm' => 4,
			'condition' => 1,
			'rawperl' => 43,
			'directive' => 27,
			'anonblock' => 9,
			'statement' => 25,
			'wrapper' => 10,
			'macro' => 6,
			'defblock' => 23,
			'atomdir' => 5
		}
	},
	{#State 256
		DEFAULT => -167
	},
	{#State 257
		ACTIONS => {
			'REF' => 28,
			'NOT' => 66,
			'LITERAL' => 248,
			'COMMA' => 247,
			"(" => 42,
			"{" => 40,
			'NUMBER' => 59,
			'IDENT' => 55,
			"[" => 54,
			"\$" => 73,
			"\${" => 50,
			"\"" => 68
		},
		DEFAULT => -162,
		GOTOS => {
			'sterm' => 57,
			'ident' => 252,
			'term' => 15,
			'expr' => 250,
			'param' => 251,
			'item' => 249,
			'node' => 49,
			'lterm' => 4
		}
	},
	{#State 258
		ACTIONS => {
			'RETURN' => 64,
			'DEBUG' => 26,
			'SET' => 65,
			'UNLESS' => 67,
			'REF' => 28,
			'NOT' => 66,
			'SWITCH' => 22,
			'LITERAL' => 62,
			'INSERT' => 63,
			'USE' => 24,
			'PERL' => 21,
			'PROCESS' => 18,
			"{" => 40,
			'IF' => 33,
			'STOP' => 34,
			'TRY' => 36,
			'THROW' => 37,
			'GET' => 38,
			'INCLUDE' => 30,
			'LAST' => 70,
			'FOR' => 71,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			"\$" => 73,
			"\"" => 68,
			'RAWPERL' => 29,
			'WHILE' => 7,
			'VIEW' => 2,
			'MACRO' => 45,
			'FILTER' => 46,
			'CALL' => 47,
			'BLOCK' => 41,
			"(" => 42,
			'NEXT' => 44,
			";" => -18,
			'TEXT' => 60,
			'NUMBER' => 59,
			'IDENT' => 55,
			"[" => 54,
			"\${" => 50,
			'DEFAULT' => 11,
			'META' => 48
		},
		DEFAULT => -3,
		GOTOS => {
			'macro' => 6,
			'defblock' => 23,
			'atomdir' => 5,
			'statement' => 25,
			'directive' => 27,
			'anonblock' => 9,
			'wrapper' => 10,
			'condition' => 1,
			'rawperl' => 43,
			'assign' => 20,
			'capture' => 19,
			'lterm' => 4,
			'switch' => 3,
			'atomexpr' => 53,
			'view' => 56,
			'ident' => 13,
			'use' => 35,
			'sterm' => 57,
			'loop' => 58,
			'filter' => 39,
			'setlist' => 14,
			'term' => 15,
			'chunks' => 16,
			'expr' => 61,
			'defblockname' => 17,
			'perl' => 12,
			'block' => 291,
			'node' => 49,
			'item' => 51,
			'chunk' => 31,
			'try' => 52
		}
	},
	{#State 259
		ACTIONS => {
			"/" => 157,
			'BINOP' => 159,
			'OR' => 158,
			"+" => 160,
			'AND' => 152,
			'DIV' => 161,
			'CAT' => 153,
			"?" => 156,
			'MOD' => 154,
			'CMPOP' => 155
		},
		DEFAULT => -150
	},
	{#State 260
		ACTIONS => {
			'LAST' => 70,
			'INCLUDE' => 30,
			'WRAPPER' => 32,
			'CLEAR' => 72,
			"\$" => 73,
			'FOR' => 71,
			"\"" => 68,
			'RAWPERL' => 29,
			"{" => 40,
			'STOP' => 34,
			'IF' => 33,
			'THROW' => 37,
			'GET' => 38,
			'TRY' => 36,
			'PERL' => 21,
			'PROCESS' => 18,
			'DEBUG' => 26,
			'RETURN' => 64,
			'REF' => 28,
			'UNLESS' => 67,
			'NOT' => 66,
			'SET' => 65,
			'SWITCH' => 22,
			'INSERT' => 63,
			'LITERAL' => 62,
			'USE' => 24,
			"\${" => 50,
			'DEFAULT' => 11,
			'META' => 48,
			";" => -18,
			'NUMBER' => 59,
			'TEXT' => 60,
			'IDENT' => 55,
			"[" => 54,
			'MACRO' => 45,
			'FILTER' => 46,
			'VIEW' => 2,
			'CALL' => 47,
			'BLOCK' => 41,
			'NEXT' => 44,
			"(" => 42,
			'WHILE' => 7
		},
		DEFAULT => -3,
		GOTOS => {
			'perl' => 12,
			'try' => 52,
			'chunk' => 31,
			'item' => 51,
			'node' => 49,
			'block' => 292,
			'view' => 56,
			'sterm' => 57,
			'use' => 35,
			'ident' => 13,
			'atomexpr' => 53,
			'expr' => 61,
			'defblockname' => 17,
			'chunks' => 16,
			'term' => 15,
			'setlist' => 14,
			'filter' => 39,
			'loop' => 58,
			'rawperl' => 43,
			'condition' => 1,
			'switch' => 3,
			'lterm' => 4,
			'capture' => 19,
			'assign' => 20,
			'defblock' => 23,
			'macro' => 6,
			'atomdir' => 5,
			'wrapper' => 10,
			'anonblock' => 9,
			'directive' => 27,
			'statement' => 25
		}
	},
	{#State 261
		DEFAULT => -102
	},
	{#State 262
		DEFAULT => -100
	},
	{#State 263
		ACTIONS => {
			'TEXT' => 293
		}
	},
	{#State 264
		ACTIONS => {
			'END' => 294
		}
	},
	{#State 265
		ACTIONS => {
			'END' => 295
		}
	},
	{#State 266
		ACTIONS => {
			'CASE' => 297
		},
		DEFAULT => -55,
		GOTOS => {
			'case' => 296
		}
	},
	{#State 267
		DEFAULT => -157
	},
	{#State 268
		ACTIONS => {
			'ASSIGN' => -160
		},
		DEFAULT => -167
	},
	{#State 269
		ACTIONS => {
			'END' => 298
		}
	},
	{#State 270
		ACTIONS => {
			'END' => 299
		}
	},
	{#State 271
		ACTIONS => {
			'ELSE' => 301,
			'ELSIF' => 302
		},
		DEFAULT => -50,
		GOTOS => {
			'else' => 300
		}
	},
	{#State 272
		ACTIONS => {
			";" => 303
		}
	},
	{#State 273
		ACTIONS => {
			'IDENT' => 78,
			'DEFAULT' => 305,
			'NUMBER' => 79,
			";" => 304,
			'FILENAME' => 74
		},
		GOTOS => {
			'filepart' => 82,
			'filename' => 306
		}
	},
	{#State 274
		ACTIONS => {
			'END' => 307
		}
	},
	{#State 275
		ACTIONS => {
			'AND' => 152,
			'CAT' => 153,
			'MOD' => 154,
			'CMPOP' => 155,
			'BINOP' => 159,
			"+" => 160,
			'DIV' => 161,
			"?" => 156,
			"/" => 157,
			'OR' => 158
		},
		DEFAULT => -123
	},
	{#State 276
		ACTIONS => {
			'AND' => 152,
			'CAT' => 153,
			'CMPOP' => 155,
			'MOD' => 154,
			'BINOP' => 159,
			"+" => 160,
			'DIV' => 161,
			"?" => 156,
			"/" => 157,
			'OR' => 158
		},
		DEFAULT => -124
	},
	{#State 277
		ACTIONS => {
			'END' => 308
		}
	},
	{#State 278
		ACTIONS => {
			'IDENT' => -96,
			'COMMA' => -96,
			")" => -96
		},
		DEFAULT => -130
	},
	{#State 279
		ACTIONS => {
			'COMMA' => 310,
			")" => 309,
			'IDENT' => 311
		}
	},
	{#State 280
		ACTIONS => {
			'END' => 312
		}
	},
	{#State 281
		DEFAULT => -129
	},
	{#State 282
		DEFAULT => -117
	},
	{#State 283
		ACTIONS => {
			"(" => 42,
			"\"" => 68,
			"\$" => 73,
			"\${" => 50,
			"[" => 54,
			'IDENT' => 55,
			'LITERAL' => 85,
			'NOT' => 66,
			'REF' => 28,
			"{" => 40,
			'NUMBER' => 59
		},
		GOTOS => {
			'sterm' => 57,
			'ident' => 87,
			'expr' => 313,
			'lterm' => 4,
			'node' => 49,
			'term' => 15,
			'item' => 51
		}
	},
	{#State 284
		ACTIONS => {
			'ELSE' => 301,
			'ELSIF' => 302
		},
		DEFAULT => -50,
		GOTOS => {
			'else' => 314
		}
	},
	{#State 285
		DEFAULT => -156,
		GOTOS => {
			'args' => 315
		}
	},
	{#State 286
		DEFAULT => -156,
		GOTOS => {
			'args' => 316
		}
	},
	{#State 287
		ACTIONS => {
			'META' => 48,
			'DEFAULT' => 11,
			"\${" => 50,
			"[" => 54,
			'IDENT' => 55,
			'NUMBER' => 59,
			";" => -18,
			'TEXT' => 60,
			'NEXT' => 44,
			"(" => 42,
			'BLOCK' => 41,
			'CALL' => 47,
			'FILTER' => 46,
			'MACRO' => 45,
			'VIEW' => 2,
			'WHILE' => 7,
			'RAWPERL' => 29,
			"\"" => 68,
			'WRAPPER' => 32,
			"\$" => 73,
			'CLEAR' => 72,
			'FOR' => 71,
			'INCLUDE' => 30,
			'LAST' => 70,
			'THROW' => 37,
			'GET' => 38,
			'TRY' => 36,
			'STOP' => 34,
			'IF' => 33,
			"{" => 40,
			'PROCESS' => 18,
			'PERL' => 21,
			'USE' => 24,
			'SWITCH' => 22,
			'LITERAL' => 62,
			'INSERT' => 63,
			'UNLESS' => 67,
			'NOT' => 66,
			'REF' => 28,
			'SET' => 65,
			'DEBUG' => 26,
			'RETURN' => 64
		},
		DEFAULT => -3,
		GOTOS => {
			'perl' => 12,
			'item' => 51,
			'chunk' => 31,
			'block' => 317,
			'node' => 49,
			'try' => 52,
			'atomexpr' => 53,
			'sterm' => 57,
			'view' => 56,
			'use' => 35,
			'ident' => 13,
			'term' => 15,
			'setlist' => 14,
			'loop' => 58,
			'filter' => 39,
			'defblockname' => 17,
			'expr' => 61,
			'chunks' => 16,
			'condition' => 1,
			'rawperl' => 43,
			'assign' => 20,
			'capture' => 19,
			'switch' => 3,
			'lterm' => 4,
			'atomdir' => 5,
			'defblock' => 23,
			'macro' => 6,
			'directive' => 27,
			'anonblock' => 9,
			'statement' => 25,
			'wrapper' => 10
		}
	},
	{#State 288
		DEFAULT => -164
	},
	{#State 289
		ACTIONS => {
			'REF' => 28,
			"{" => 40,
			'NOT' => 66,
			'NUMBER' => 59,
			'IDENT' => 55,
			"[" => 54,
			'LITERAL' => 85,
			"\$" => 73,
			"\${" => 50,
			"(" => 42,
			"\"" => 68
		},
		GOTOS => {
			'expr' => 318,
			'lterm' => 4,
			'node' => 49,
			'item' => 51,
			'term' => 15,
			'ident' => 87,
			'sterm' => 57
		}
	},
	{#State 290
		ACTIONS => {
			'END' => 319
		}
	},
	{#State 291
		ACTIONS => {
			'END' => 320
		}
	},
	{#State 292
		ACTIONS => {
			'END' => 321
		}
	},
	{#State 293
		ACTIONS => {
			"\"" => 322
		}
	},
	{#State 294
		DEFAULT => -82
	},
	{#State 295
		DEFAULT => -77
	},
	{#State 296
		ACTIONS => {
			'END' => 323
		}
	},
	{#State 297
		ACTIONS => {
			"{" => 40,
			'REF' => 28,
			'NUMBER' => 59,
			";" => 325,
			"[" => 54,
			'IDENT' => 55,
			'LITERAL' => 85,
			"\$" => 73,
			"\${" => 50,
			'DEFAULT' => 326,
			"\"" => 68
		},
		GOTOS => {
			'lterm' => 4,
			'node' => 49,
			'item' => 51,
			'term' => 324,
			'sterm' => 57,
			'ident' => 87
		}
	},
	{#State 298
		DEFAULT => -79
	},
	{#State 299
		DEFAULT => -65
	},
	{#State 300
		ACTIONS => {
			'END' => 327
		}
	},
	{#State 301
		ACTIONS => {
			";" => 328
		}
	},
	{#State 302
		ACTIONS => {
			'LITERAL' => 85,
			"[" => 54,
			'IDENT' => 55,
			'NUMBER' => 59,
			'NOT' => 66,
			"{" => 40,
			'REF' => 28,
			"\"" => 68,
			"(" => 42,
			"\${" => 50,
			"\$" => 73
		},
		GOTOS => {
			'term' => 15,
			'item' => 51,
			'node' => 49,
			'lterm' => 4,
			'expr' => 329,
			'sterm' => 57,
			'ident' => 87
		}
	},
	{#State 303
		ACTIONS => {
			'PERL' => 21,
			'PROCESS' => 18,
			'RETURN' => 64,
			'DEBUG' => 26,
			'SET' => 65,
			'NOT' => 66,
			'REF' => 28,
			'UNLESS' => 67,
			'INSERT' => 63,
			'LITERAL' => 62,
			'SWITCH' => 22,
			'USE' => 24,
			'LAST' => 70,
			'INCLUDE' => 30,
			'FOR' => 71,
			"\$" => 73,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			"\"" => 68,
			'RAWPERL' => 29,
			"{" => 40,
			'IF' => 33,
			'STOP' => 34,
			'TRY' => 36,
			'GET' => 38,
			'THROW' => 37,
			'VIEW' => 2,
			'FILTER' => 46,
			'MACRO' => 45,
			'CALL' => 47,
			'BLOCK' => 41,
			"(" => 42,
			'NEXT' => 44,
			'WHILE' => 7,
			"\${" => 50,
			'DEFAULT' => 11,
			'META' => 48,
			";" => -18,
			'TEXT' => 60,
			'NUMBER' => 59,
			"[" => 54,
			'IDENT' => 55
		},
		DEFAULT => -3,
		GOTOS => {
			'rawperl' => 43,
			'condition' => 1,
			'switch' => 3,
			'lterm' => 4,
			'capture' => 19,
			'assign' => 20,
			'defblock' => 23,
			'atomdir' => 5,
			'macro' => 6,
			'wrapper' => 10,
			'statement' => 25,
			'directive' => 27,
			'anonblock' => 9,
			'perl' => 12,
			'try' => 52,
			'block' => 330,
			'node' => 49,
			'item' => 51,
			'chunk' => 31,
			'view' => 56,
			'sterm' => 57,
			'ident' => 13,
			'use' => 35,
			'atomexpr' => 53,
			'chunks' => 16,
			'expr' => 61,
			'defblockname' => 17,
			'loop' => 58,
			'filter' => 39,
			'setlist' => 14,
			'term' => 15
		}
	},
	{#State 304
		ACTIONS => {
			'SWITCH' => 22,
			'LITERAL' => 62,
			'INSERT' => 63,
			'USE' => 24,
			'RETURN' => 64,
			'DEBUG' => 26,
			'SET' => 65,
			'NOT' => 66,
			'REF' => 28,
			'UNLESS' => 67,
			'PROCESS' => 18,
			'PERL' => 21,
			'IF' => 33,
			'STOP' => 34,
			'TRY' => 36,
			'THROW' => 37,
			'GET' => 38,
			"{" => 40,
			"\"" => 68,
			'RAWPERL' => 29,
			'LAST' => 70,
			'INCLUDE' => 30,
			'FOR' => 71,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			"\$" => 73,
			'WHILE' => 7,
			'BLOCK' => 41,
			"(" => 42,
			'NEXT' => 44,
			'VIEW' => 2,
			'FILTER' => 46,
			'MACRO' => 45,
			'CALL' => 47,
			"[" => 54,
			'IDENT' => 55,
			";" => -18,
			'NUMBER' => 59,
			'TEXT' => 60,
			'DEFAULT' => 11,
			'META' => 48,
			"\${" => 50
		},
		DEFAULT => -3,
		GOTOS => {
			'atomexpr' => 53,
			'sterm' => 57,
			'view' => 56,
			'use' => 35,
			'ident' => 13,
			'setlist' => 14,
			'term' => 15,
			'filter' => 39,
			'loop' => 58,
			'defblockname' => 17,
			'expr' => 61,
			'chunks' => 16,
			'perl' => 12,
			'chunk' => 31,
			'item' => 51,
			'node' => 49,
			'block' => 331,
			'try' => 52,
			'atomdir' => 5,
			'macro' => 6,
			'defblock' => 23,
			'anonblock' => 9,
			'directive' => 27,
			'statement' => 25,
			'wrapper' => 10,
			'condition' => 1,
			'rawperl' => 43,
			'capture' => 19,
			'assign' => 20,
			'switch' => 3,
			'lterm' => 4
		}
	},
	{#State 305
		ACTIONS => {
			";" => 332
		}
	},
	{#State 306
		ACTIONS => {
			";" => 333,
			'DOT' => 175
		}
	},
	{#State 307
		DEFAULT => -67
	},
	{#State 308
		DEFAULT => -88
	},
	{#State 309
		ACTIONS => {
			"\"" => 68,
			"\$" => 73,
			'WRAPPER' => 32,
			'CLEAR' => 72,
			'FOR' => 71,
			'INCLUDE' => 30,
			'LAST' => 70,
			'GET' => 38,
			'THROW' => 37,
			'TRY' => 36,
			'STOP' => 34,
			'IF' => 33,
			"{" => 40,
			'PROCESS' => 18,
			'PERL' => 21,
			'SWITCH' => 22,
			'LITERAL' => 62,
			'INSERT' => 63,
			'UNLESS' => 67,
			'REF' => 28,
			'NOT' => 66,
			'SET' => 65,
			'DEBUG' => 26,
			'RETURN' => 64,
			'DEFAULT' => 11,
			"\${" => 50,
			"[" => 54,
			'IDENT' => 55,
			'NUMBER' => 59,
			'NEXT' => 44,
			"(" => 42,
			'BLOCK' => 181,
			'CALL' => 47,
			'FILTER' => 46,
			'WHILE' => 7
		},
		GOTOS => {
			'atomdir' => 5,
			'wrapper' => 10,
			'directive' => 184,
			'condition' => 1,
			'switch' => 3,
			'lterm' => 4,
			'assign' => 20,
			'ident' => 132,
			'sterm' => 57,
			'atomexpr' => 53,
			'mdir' => 334,
			'expr' => 208,
			'loop' => 58,
			'filter' => 39,
			'term' => 15,
			'setlist' => 14,
			'perl' => 12,
			'try' => 52,
			'node' => 49,
			'item' => 51
		}
	},
	{#State 310
		DEFAULT => -95
	},
	{#State 311
		DEFAULT => -94
	},
	{#State 312
		DEFAULT => -80
	},
	{#State 313
		ACTIONS => {
			"/" => 157,
			'OR' => 158,
			"+" => 160,
			"?" => 156,
			'DIV' => 161,
			'BINOP' => 159,
			'AND' => 152,
			'CAT' => 153,
			'MOD' => 154,
			'CMPOP' => 155
		},
		DEFAULT => -143
	},
	{#State 314
		ACTIONS => {
			'END' => 335
		}
	},
	{#State 315
		ACTIONS => {
			"\"" => 68,
			"(" => 42,
			"\${" => 50,
			'COMMA' => 247,
			"\$" => 73,
			'LITERAL' => 248,
			'IDENT' => 55,
			"[" => 54,
			'NUMBER' => 59,
			'NOT' => 66,
			"{" => 40,
			'REF' => 28
		},
		DEFAULT => -62,
		GOTOS => {
			'param' => 251,
			'node' => 49,
			'item' => 249,
			'lterm' => 4,
			'sterm' => 57,
			'ident' => 252,
			'term' => 15,
			'expr' => 250
		}
	},
	{#State 316
		ACTIONS => {
			"\${" => 50,
			'COMMA' => 247,
			"\$" => 73,
			"\"" => 68,
			"(" => 42,
			'NUMBER' => 59,
			"{" => 40,
			'NOT' => 66,
			'REF' => 28,
			'LITERAL' => 248,
			'IDENT' => 55,
			"[" => 54
		},
		DEFAULT => -63,
		GOTOS => {
			'node' => 49,
			'item' => 249,
			'lterm' => 4,
			'param' => 251,
			'term' => 15,
			'expr' => 250,
			'ident' => 252,
			'sterm' => 57
		}
	},
	{#State 317
		ACTIONS => {
			'END' => 336
		}
	},
	{#State 318
		ACTIONS => {
			"/" => 157,
			'OR' => 158,
			'BINOP' => 159,
			'AND' => 152,
			"+" => 160,
			"?" => 156,
			'DIV' => 161,
			'CAT' => 153,
			'MOD' => 154,
			'CMPOP' => 155
		},
		DEFAULT => -154
	},
	{#State 319
		DEFAULT => -75
	},
	{#State 320
		DEFAULT => -60
	},
	{#State 321
		DEFAULT => -93
	},
	{#State 322
		DEFAULT => -101
	},
	{#State 323
		DEFAULT => -51
	},
	{#State 324
		ACTIONS => {
			";" => 337
		}
	},
	{#State 325
		ACTIONS => {
			'WHILE' => 7,
			'VIEW' => 2,
			'FILTER' => 46,
			'MACRO' => 45,
			'CALL' => 47,
			'BLOCK' => 41,
			"(" => 42,
			'NEXT' => 44,
			'NUMBER' => 59,
			";" => -18,
			'TEXT' => 60,
			"[" => 54,
			'IDENT' => 55,
			"\${" => 50,
			'DEFAULT' => 11,
			'META' => 48,
			'RETURN' => 64,
			'DEBUG' => 26,
			'SET' => 65,
			'NOT' => 66,
			'REF' => 28,
			'UNLESS' => 67,
			'SWITCH' => 22,
			'LITERAL' => 62,
			'INSERT' => 63,
			'USE' => 24,
			'PERL' => 21,
			'PROCESS' => 18,
			"{" => 40,
			'IF' => 33,
			'STOP' => 34,
			'TRY' => 36,
			'GET' => 38,
			'THROW' => 37,
			'INCLUDE' => 30,
			'LAST' => 70,
			'FOR' => 71,
			"\$" => 73,
			'WRAPPER' => 32,
			'CLEAR' => 72,
			"\"" => 68,
			'RAWPERL' => 29
		},
		DEFAULT => -3,
		GOTOS => {
			'defblock' => 23,
			'macro' => 6,
			'atomdir' => 5,
			'statement' => 25,
			'anonblock' => 9,
			'directive' => 27,
			'wrapper' => 10,
			'condition' => 1,
			'rawperl' => 43,
			'assign' => 20,
			'capture' => 19,
			'lterm' => 4,
			'switch' => 3,
			'atomexpr' => 53,
			'view' => 56,
			'use' => 35,
			'ident' => 13,
			'sterm' => 57,
			'loop' => 58,
			'filter' => 39,
			'term' => 15,
			'setlist' => 14,
			'chunks' => 16,
			'defblockname' => 17,
			'expr' => 61,
			'perl' => 12,
			'node' => 49,
			'block' => 338,
			'item' => 51,
			'chunk' => 31,
			'try' => 52
		}
	},
	{#State 326
		ACTIONS => {
			";" => 339
		}
	},
	{#State 327
		DEFAULT => -44
	},
	{#State 328
		ACTIONS => {
			'FILTER' => 46,
			'MACRO' => 45,
			'VIEW' => 2,
			'CALL' => 47,
			'BLOCK' => 41,
			'NEXT' => 44,
			"(" => 42,
			'WHILE' => 7,
			"\${" => 50,
			'DEFAULT' => 11,
			'META' => 48,
			'NUMBER' => 59,
			";" => -18,
			'TEXT' => 60,
			'IDENT' => 55,
			"[" => 54,
			'PERL' => 21,
			'PROCESS' => 18,
			'DEBUG' => 26,
			'RETURN' => 64,
			'UNLESS' => 67,
			'NOT' => 66,
			'REF' => 28,
			'SET' => 65,
			'SWITCH' => 22,
			'LITERAL' => 62,
			'INSERT' => 63,
			'USE' => 24,
			'LAST' => 70,
			'INCLUDE' => 30,
			"\$" => 73,
			'WRAPPER' => 32,
			'CLEAR' => 72,
			'FOR' => 71,
			"\"" => 68,
			'RAWPERL' => 29,
			"{" => 40,
			'STOP' => 34,
			'IF' => 33,
			'GET' => 38,
			'THROW' => 37,
			'TRY' => 36
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 10,
			'statement' => 25,
			'anonblock' => 9,
			'directive' => 27,
			'defblock' => 23,
			'atomdir' => 5,
			'macro' => 6,
			'switch' => 3,
			'lterm' => 4,
			'assign' => 20,
			'capture' => 19,
			'rawperl' => 43,
			'condition' => 1,
			'chunks' => 16,
			'expr' => 61,
			'defblockname' => 17,
			'filter' => 39,
			'loop' => 58,
			'setlist' => 14,
			'term' => 15,
			'use' => 35,
			'view' => 56,
			'sterm' => 57,
			'ident' => 13,
			'atomexpr' => 53,
			'try' => 52,
			'node' => 49,
			'block' => 340,
			'item' => 51,
			'chunk' => 31,
			'perl' => 12
		}
	},
	{#State 329
		ACTIONS => {
			";" => 341,
			'MOD' => 154,
			'CMPOP' => 155,
			'OR' => 158,
			'BINOP' => 159,
			"+" => 160,
			'AND' => 152,
			'DIV' => 161,
			"?" => 156,
			"/" => 157,
			'CAT' => 153
		}
	},
	{#State 330
		DEFAULT => -71
	},
	{#State 331
		ACTIONS => {
			'CATCH' => 273,
			'FINAL' => 272
		},
		DEFAULT => -72,
		GOTOS => {
			'final' => 342
		}
	},
	{#State 332
		ACTIONS => {
			'TRY' => 36,
			'GET' => 38,
			'THROW' => 37,
			'IF' => 33,
			'STOP' => 34,
			"{" => 40,
			'RAWPERL' => 29,
			"\"" => 68,
			'FOR' => 71,
			'CLEAR' => 72,
			"\$" => 73,
			'WRAPPER' => 32,
			'INCLUDE' => 30,
			'LAST' => 70,
			'USE' => 24,
			'INSERT' => 63,
			'LITERAL' => 62,
			'SWITCH' => 22,
			'SET' => 65,
			'UNLESS' => 67,
			'NOT' => 66,
			'REF' => 28,
			'RETURN' => 64,
			'DEBUG' => 26,
			'PROCESS' => 18,
			'PERL' => 21,
			'IDENT' => 55,
			"[" => 54,
			'TEXT' => 60,
			";" => -18,
			'NUMBER' => 59,
			'META' => 48,
			'DEFAULT' => 11,
			"\${" => 50,
			'WHILE' => 7,
			"(" => 42,
			'NEXT' => 44,
			'BLOCK' => 41,
			'CALL' => 47,
			'VIEW' => 2,
			'MACRO' => 45,
			'FILTER' => 46
		},
		DEFAULT => -3,
		GOTOS => {
			'lterm' => 4,
			'switch' => 3,
			'assign' => 20,
			'capture' => 19,
			'rawperl' => 43,
			'condition' => 1,
			'wrapper' => 10,
			'statement' => 25,
			'anonblock' => 9,
			'directive' => 27,
			'macro' => 6,
			'defblock' => 23,
			'atomdir' => 5,
			'try' => 52,
			'block' => 343,
			'node' => 49,
			'item' => 51,
			'chunk' => 31,
			'perl' => 12,
			'chunks' => 16,
			'expr' => 61,
			'defblockname' => 17,
			'loop' => 58,
			'filter' => 39,
			'term' => 15,
			'setlist' => 14,
			'use' => 35,
			'view' => 56,
			'sterm' => 57,
			'ident' => 13,
			'atomexpr' => 53
		}
	},
	{#State 333
		ACTIONS => {
			'CALL' => 47,
			'VIEW' => 2,
			'MACRO' => 45,
			'FILTER' => 46,
			"(" => 42,
			'NEXT' => 44,
			'BLOCK' => 41,
			'WHILE' => 7,
			"\${" => 50,
			'META' => 48,
			'DEFAULT' => 11,
			";" => -18,
			'NUMBER' => 59,
			'TEXT' => 60,
			"[" => 54,
			'IDENT' => 55,
			'PERL' => 21,
			'PROCESS' => 18,
			'SET' => 65,
			'NOT' => 66,
			'REF' => 28,
			'UNLESS' => 67,
			'RETURN' => 64,
			'DEBUG' => 26,
			'USE' => 24,
			'LITERAL' => 62,
			'SWITCH' => 22,
			'INSERT' => 63,
			'FOR' => 71,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			"\$" => 73,
			'INCLUDE' => 30,
			'LAST' => 70,
			'RAWPERL' => 29,
			"\"" => 68,
			"{" => 40,
			'TRY' => 36,
			'THROW' => 37,
			'GET' => 38,
			'IF' => 33,
			'STOP' => 34
		},
		DEFAULT => -3,
		GOTOS => {
			'condition' => 1,
			'rawperl' => 43,
			'assign' => 20,
			'capture' => 19,
			'lterm' => 4,
			'switch' => 3,
			'defblock' => 23,
			'atomdir' => 5,
			'macro' => 6,
			'anonblock' => 9,
			'directive' => 27,
			'statement' => 25,
			'wrapper' => 10,
			'perl' => 12,
			'item' => 51,
			'chunk' => 31,
			'block' => 344,
			'node' => 49,
			'try' => 52,
			'atomexpr' => 53,
			'sterm' => 57,
			'ident' => 13,
			'view' => 56,
			'use' => 35,
			'term' => 15,
			'setlist' => 14,
			'loop' => 58,
			'filter' => 39,
			'defblockname' => 17,
			'expr' => 61,
			'chunks' => 16
		}
	},
	{#State 334
		DEFAULT => -90
	},
	{#State 335
		DEFAULT => -46
	},
	{#State 336
		DEFAULT => -57
	},
	{#State 337
		ACTIONS => {
			'TEXT' => 60,
			";" => -18,
			'NUMBER' => 59,
			'IDENT' => 55,
			"[" => 54,
			"\${" => 50,
			'DEFAULT' => 11,
			'META' => 48,
			'WHILE' => 7,
			'FILTER' => 46,
			'MACRO' => 45,
			'VIEW' => 2,
			'CALL' => 47,
			'BLOCK' => 41,
			'NEXT' => 44,
			"(" => 42,
			"{" => 40,
			'STOP' => 34,
			'IF' => 33,
			'THROW' => 37,
			'GET' => 38,
			'TRY' => 36,
			'INCLUDE' => 30,
			'LAST' => 70,
			'WRAPPER' => 32,
			'CLEAR' => 72,
			"\$" => 73,
			'FOR' => 71,
			"\"" => 68,
			'RAWPERL' => 29,
			'DEBUG' => 26,
			'RETURN' => 64,
			'REF' => 28,
			'UNLESS' => 67,
			'NOT' => 66,
			'SET' => 65,
			'LITERAL' => 62,
			'SWITCH' => 22,
			'INSERT' => 63,
			'USE' => 24,
			'PERL' => 21,
			'PROCESS' => 18
		},
		DEFAULT => -3,
		GOTOS => {
			'atomexpr' => 53,
			'ident' => 13,
			'use' => 35,
			'sterm' => 57,
			'view' => 56,
			'setlist' => 14,
			'term' => 15,
			'filter' => 39,
			'loop' => 58,
			'expr' => 61,
			'defblockname' => 17,
			'chunks' => 16,
			'perl' => 12,
			'item' => 51,
			'chunk' => 31,
			'node' => 49,
			'block' => 345,
			'try' => 52,
			'macro' => 6,
			'defblock' => 23,
			'atomdir' => 5,
			'directive' => 27,
			'anonblock' => 9,
			'statement' => 25,
			'wrapper' => 10,
			'condition' => 1,
			'rawperl' => 43,
			'capture' => 19,
			'assign' => 20,
			'switch' => 3,
			'lterm' => 4
		}
	},
	{#State 338
		DEFAULT => -54
	},
	{#State 339
		ACTIONS => {
			"[" => 54,
			'IDENT' => 55,
			'NUMBER' => 59,
			";" => -18,
			'TEXT' => 60,
			'META' => 48,
			'DEFAULT' => 11,
			"\${" => 50,
			'WHILE' => 7,
			'NEXT' => 44,
			"(" => 42,
			'BLOCK' => 41,
			'CALL' => 47,
			'FILTER' => 46,
			'MACRO' => 45,
			'VIEW' => 2,
			'GET' => 38,
			'THROW' => 37,
			'TRY' => 36,
			'STOP' => 34,
			'IF' => 33,
			"{" => 40,
			'RAWPERL' => 29,
			"\"" => 68,
			"\$" => 73,
			'CLEAR' => 72,
			'WRAPPER' => 32,
			'FOR' => 71,
			'INCLUDE' => 30,
			'LAST' => 70,
			'USE' => 24,
			'LITERAL' => 62,
			'INSERT' => 63,
			'SWITCH' => 22,
			'NOT' => 66,
			'UNLESS' => 67,
			'REF' => 28,
			'SET' => 65,
			'DEBUG' => 26,
			'RETURN' => 64,
			'PROCESS' => 18,
			'PERL' => 21
		},
		DEFAULT => -3,
		GOTOS => {
			'use' => 35,
			'view' => 56,
			'sterm' => 57,
			'ident' => 13,
			'atomexpr' => 53,
			'chunks' => 16,
			'expr' => 61,
			'defblockname' => 17,
			'filter' => 39,
			'loop' => 58,
			'term' => 15,
			'setlist' => 14,
			'perl' => 12,
			'try' => 52,
			'block' => 346,
			'node' => 49,
			'item' => 51,
			'chunk' => 31,
			'atomdir' => 5,
			'defblock' => 23,
			'macro' => 6,
			'wrapper' => 10,
			'statement' => 25,
			'directive' => 27,
			'anonblock' => 9,
			'rawperl' => 43,
			'condition' => 1,
			'lterm' => 4,
			'switch' => 3,
			'capture' => 19,
			'assign' => 20
		}
	},
	{#State 340
		DEFAULT => -49
	},
	{#State 341
		ACTIONS => {
			'IDENT' => 55,
			"[" => 54,
			";" => -18,
			'NUMBER' => 59,
			'TEXT' => 60,
			'META' => 48,
			'DEFAULT' => 11,
			"\${" => 50,
			'WHILE' => 7,
			'NEXT' => 44,
			"(" => 42,
			'BLOCK' => 41,
			'CALL' => 47,
			'MACRO' => 45,
			'FILTER' => 46,
			'VIEW' => 2,
			'GET' => 38,
			'THROW' => 37,
			'TRY' => 36,
			'STOP' => 34,
			'IF' => 33,
			"{" => 40,
			'RAWPERL' => 29,
			"\"" => 68,
			"\$" => 73,
			'WRAPPER' => 32,
			'CLEAR' => 72,
			'FOR' => 71,
			'INCLUDE' => 30,
			'LAST' => 70,
			'USE' => 24,
			'SWITCH' => 22,
			'INSERT' => 63,
			'LITERAL' => 62,
			'NOT' => 66,
			'REF' => 28,
			'UNLESS' => 67,
			'SET' => 65,
			'DEBUG' => 26,
			'RETURN' => 64,
			'PROCESS' => 18,
			'PERL' => 21
		},
		DEFAULT => -3,
		GOTOS => {
			'rawperl' => 43,
			'condition' => 1,
			'switch' => 3,
			'lterm' => 4,
			'assign' => 20,
			'capture' => 19,
			'macro' => 6,
			'defblock' => 23,
			'atomdir' => 5,
			'wrapper' => 10,
			'anonblock' => 9,
			'directive' => 27,
			'statement' => 25,
			'perl' => 12,
			'try' => 52,
			'item' => 51,
			'chunk' => 31,
			'block' => 347,
			'node' => 49,
			'sterm' => 57,
			'view' => 56,
			'use' => 35,
			'ident' => 13,
			'atomexpr' => 53,
			'expr' => 61,
			'defblockname' => 17,
			'chunks' => 16,
			'setlist' => 14,
			'term' => 15,
			'filter' => 39,
			'loop' => 58
		}
	},
	{#State 342
		DEFAULT => -70
	},
	{#State 343
		ACTIONS => {
			'CATCH' => 273,
			'FINAL' => 272
		},
		DEFAULT => -72,
		GOTOS => {
			'final' => 348
		}
	},
	{#State 344
		ACTIONS => {
			'FINAL' => 272,
			'CATCH' => 273
		},
		DEFAULT => -72,
		GOTOS => {
			'final' => 349
		}
	},
	{#State 345
		ACTIONS => {
			'CASE' => 297
		},
		DEFAULT => -55,
		GOTOS => {
			'case' => 350
		}
	},
	{#State 346
		DEFAULT => -53
	},
	{#State 347
		ACTIONS => {
			'ELSE' => 301,
			'ELSIF' => 302
		},
		DEFAULT => -50,
		GOTOS => {
			'else' => 351
		}
	},
	{#State 348
		DEFAULT => -69
	},
	{#State 349
		DEFAULT => -68
	},
	{#State 350
		DEFAULT => -52
	},
	{#State 351
		DEFAULT => -48
	}
];


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 64 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 67 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 68 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 71 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
                                        if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 73 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 76 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 77 "Parser.yp"
{ return '' unless $_[1];
                                      $_[0]->location() . $_[1];
                                    }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1,
sub
#line 90 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 17
		 'statement', 2,
sub
#line 91 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 18
		 'statement', 0, undef
	],
	[#Rule 19
		 'directive', 1,
sub
#line 95 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 20
		 'directive', 1, undef
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'atomexpr', 1,
sub
#line 109 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 27
		 'atomexpr', 1, undef
	],
	[#Rule 28
		 'atomdir', 2,
sub
#line 113 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 29
		 'atomdir', 2,
sub
#line 114 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 115 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 116 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 117 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 118 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 36
		 'atomdir', 1,
sub
#line 121 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 37
		 'atomdir', 1,
sub
#line 122 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 123 "Parser.yp"
{ "\$output = '';";                   }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 124 "Parser.yp"
{ $_[0]->block_label('last ', ';')    }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 125 "Parser.yp"
{ $_[0]->in_block('FOR')
                                        ? $factory->next($_[0]->block_label)
                                        : $_[0]->block_label('next ', ';') }
	],
	[#Rule 41
		 'atomdir', 2,
sub
#line 128 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
                                          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
                                          $factory->debug($_[2]);
                                      }
                                      else {
                                          $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
                                      }
                                    }
	],
	[#Rule 42
		 'atomdir', 1, undef
	],
	[#Rule 43
		 'atomdir', 1, undef
	],
	[#Rule 44
		 'condition', 6,
sub
#line 141 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 45
		 'condition', 3,
sub
#line 142 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 46
		 'condition', 6,
sub
#line 144 "Parser.yp"
{ $factory->if("!($_[2])", @_[4, 5])  }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 145 "Parser.yp"
{ $factory->if("!($_[3])", $_[1])     }
	],
	[#Rule 48
		 'else', 5,
sub
#line 149 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
                                      $_[5];                              }
	],
	[#Rule 49
		 'else', 3,
sub
#line 151 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 50
		 'else', 0,
sub
#line 152 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 51
		 'switch', 6,
sub
#line 156 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 52
		 'case', 5,
sub
#line 160 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
                                      $_[5];                              }
	],
	[#Rule 53
		 'case', 4,
sub
#line 162 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 54
		 'case', 3,
sub
#line 163 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 55
		 'case', 0,
sub
#line 164 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 56
		 '@1-3', 0,
sub
#line 167 "Parser.yp"
{ $_[0]->enter_block('FOR')           }
	],
	[#Rule 57
		 'loop', 6,
sub
#line 168 "Parser.yp"
{ $factory->foreach(@{$_[2]}, $_[5], $_[0]->leave_block)  }
	],
	[#Rule 58
		 'loop', 3,
sub
#line 169 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 59
		 '@2-3', 0,
sub
#line 170 "Parser.yp"
{ $_[0]->enter_block('WHILE')         }
	],
	[#Rule 60
		 'loop', 6,
sub
#line 171 "Parser.yp"
{ $factory->while(@_[2, 5], $_[0]->leave_block) }
	],
	[#Rule 61
		 'loop', 3,
sub
#line 172 "Parser.yp"
{ $factory->while(@_[3, 1]) }
	],
	[#Rule 62
		 'loopvar', 4,
sub
#line 175 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 63
		 'loopvar', 4,
sub
#line 176 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 64
		 'loopvar', 2,
sub
#line 177 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 65
		 'wrapper', 5,
sub
#line 181 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 66
		 'wrapper', 3,
sub
#line 183 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 67
		 'try', 5,
sub
#line 187 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 68
		 'final', 5,
sub
#line 191 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
                                      $_[5];                              }
	],
	[#Rule 69
		 'final', 5,
sub
#line 194 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
                                      $_[5];                              }
	],
	[#Rule 70
		 'final', 4,
sub
#line 197 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
                                      $_[4];                              }
	],
	[#Rule 71
		 'final', 3,
sub
#line 199 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 72
		 'final', 0,
sub
#line 200 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 73
		 'use', 2,
sub
#line 203 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 74
		 '@3-3', 0,
sub
#line 206 "Parser.yp"
{ $_[0]->push_defblock();             }
	],
	[#Rule 75
		 'view', 6,
sub
#line 207 "Parser.yp"
{ $factory->view(@_[2,5], 
                                                     $_[0]->pop_defblock) }
	],
	[#Rule 76
		 '@4-2', 0,
sub
#line 211 "Parser.yp"
{ ${$_[0]->{ INPERL }}++;             }
	],
	[#Rule 77
		 'perl', 5,
sub
#line 212 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
                                      $_[0]->{ EVAL_PERL } 
                                      ? $factory->perl($_[4])             
                                      : $factory->no_perl();              }
	],
	[#Rule 78
		 '@5-1', 0,
sub
#line 218 "Parser.yp"
{ ${$_[0]->{ INPERL }}++; 
                                      $rawstart = ${$_[0]->{'LINE'}};     }
	],
	[#Rule 79
		 'rawperl', 5,
sub
#line 220 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
                                      $_[0]->{ EVAL_PERL } 
                                      ? $factory->rawperl($_[4], $rawstart)
                                      : $factory->no_perl();              }
	],
	[#Rule 80
		 'filter', 5,
sub
#line 227 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 81
		 'filter', 3,
sub
#line 229 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 82
		 'defblock', 5,
sub
#line 234 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
                                      pop(@{ $_[0]->{ DEFBLOCKS } });
                                      $_[0]->define_block($name, $_[4]); 
                                      undef
                                    }
	],
	[#Rule 83
		 'defblockname', 2,
sub
#line 241 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
                                      $_[2];
                                    }
	],
	[#Rule 84
		 'blockname', 1, undef
	],
	[#Rule 85
		 'blockname', 1,
sub
#line 247 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 86
		 'blockargs', 1, undef
	],
	[#Rule 87
		 'blockargs', 0, undef
	],
	[#Rule 88
		 'anonblock', 5,
sub
#line 255 "Parser.yp"
{ local $" = ', ';
                                      print STDERR "experimental block args: [@{ $_[2] }]\n"
                                          if $_[2];
                                      $factory->anon_block($_[4])         }
	],
	[#Rule 89
		 'capture', 3,
sub
#line 261 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 90
		 'macro', 6,
sub
#line 265 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 91
		 'macro', 3,
sub
#line 266 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 92
		 'mdir', 1, undef
	],
	[#Rule 93
		 'mdir', 4,
sub
#line 270 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 94
		 'margs', 2,
sub
#line 273 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 95
		 'margs', 2,
sub
#line 274 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 96
		 'margs', 1,
sub
#line 275 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 97
		 'metadata', 2,
sub
#line 278 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 98
		 'metadata', 2, undef
	],
	[#Rule 99
		 'metadata', 1, undef
	],
	[#Rule 100
		 'meta', 3,
sub
#line 283 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
                                                       s/\\'/'/g  }; 
                                         [ @_[1,3] ] }
	],
	[#Rule 101
		 'meta', 5,
sub
#line 286 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 102
		 'meta', 3,
sub
#line 287 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 103
		 'term', 1, undef
	],
	[#Rule 104
		 'term', 1, undef
	],
	[#Rule 105
		 'lterm', 3,
sub
#line 299 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 106
		 'lterm', 3,
sub
#line 300 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 107
		 'lterm', 2,
sub
#line 301 "Parser.yp"
{ "[ ]"                               }
	],
	[#Rule 108
		 'lterm', 3,
sub
#line 302 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 109
		 'sterm', 1,
sub
#line 305 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 110
		 'sterm', 2,
sub
#line 306 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 111
		 'sterm', 3,
sub
#line 307 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 112
		 'sterm', 1, undef
	],
	[#Rule 113
		 'sterm', 1, undef
	],
	[#Rule 114
		 'list', 2,
sub
#line 312 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 115
		 'list', 2, undef
	],
	[#Rule 116
		 'list', 1, undef
	],
	[#Rule 117
		 'range', 3,
sub
#line 317 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 118
		 'hash', 1, undef
	],
	[#Rule 119
		 'hash', 0,
sub
#line 322 "Parser.yp"
{ "" }
	],
	[#Rule 120
		 'params', 2,
sub
#line 325 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 121
		 'params', 2, undef
	],
	[#Rule 122
		 'params', 1, undef
	],
	[#Rule 123
		 'param', 3,
sub
#line 330 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 124
		 'param', 3,
sub
#line 331 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 125
		 'ident', 3,
sub
#line 334 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 126
		 'ident', 3,
sub
#line 335 "Parser.yp"
{ push(@{$_[1]}, 
                                           map {($_, 0)} split(/\./, $_[3]));
                                      $_[1];                              }
	],
	[#Rule 127
		 'ident', 1, undef
	],
	[#Rule 128
		 'node', 1,
sub
#line 341 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 129
		 'node', 4,
sub
#line 342 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 130
		 'item', 1,
sub
#line 345 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 131
		 'item', 3,
sub
#line 346 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 132
		 'item', 2,
sub
#line 347 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
                                       ? "'$_[2]'" 
                                       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 133
		 'expr', 3,
sub
#line 352 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 353 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 354 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "int($_[1] / $_[3])"                }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "$_[1]  . $_[3]"                    }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1] && $_[3]"                    }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] || $_[3]"                    }
	],
	[#Rule 142
		 'expr', 2,
sub
#line 361 "Parser.yp"
{ "! $_[2]"                           }
	],
	[#Rule 143
		 'expr', 5,
sub
#line 362 "Parser.yp"
{ "$_[1] ? $_[3] : $_[5]"             }
	],
	[#Rule 144
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 145
		 'expr', 3,
sub
#line 364 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 146
		 'expr', 1, undef
	],
	[#Rule 147
		 'setlist', 2,
sub
#line 368 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 148
		 'setlist', 2, undef
	],
	[#Rule 149
		 'setlist', 1, undef
	],
	[#Rule 150
		 'assign', 3,
sub
#line 374 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 151
		 'assign', 3,
sub
#line 375 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 152
		 'args', 2,
sub
#line 382 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 153
		 'args', 2,
sub
#line 383 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 154
		 'args', 4,
sub
#line 384 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
                                      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 155
		 'args', 2,
sub
#line 386 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 156
		 'args', 0,
sub
#line 387 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 157
		 'lnameargs', 3,
sub
#line 397 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 158
		 'lnameargs', 1, undef
	],
	[#Rule 159
		 'lvalue', 1, undef
	],
	[#Rule 160
		 'lvalue', 3,
sub
#line 402 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 161
		 'lvalue', 1, undef
	],
	[#Rule 162
		 'nameargs', 3,
sub
#line 406 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 163
		 'nameargs', 2,
sub
#line 407 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 164
		 'nameargs', 4,
sub
#line 408 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 165
		 'names', 3,
sub
#line 411 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 166
		 'names', 1,
sub
#line 412 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 167
		 'name', 3,
sub
#line 415 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 168
		 'name', 1,
sub
#line 416 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 169
		 'name', 1, undef
	],
	[#Rule 170
		 'filename', 3,
sub
#line 420 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 171
		 'filename', 1, undef
	],
	[#Rule 172
		 'filepart', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'filepart', 1, undef
	],
	[#Rule 175
		 'quoted', 2,
sub
#line 434 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
                                          if defined $_[2]; $_[1]         }
	],
	[#Rule 176
		 'quoted', 0,
sub
#line 436 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 177
		 'quotable', 1,
sub
#line 439 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 440 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 179
		 'quotable', 1,
sub
#line 441 "Parser.yp"
{ undef                               }
	]
];



1;

__END__

=head1 NAME

Template::Grammar - Parser state/rule tables for the TT grammar

=head1 SYNOPSIS

    # no user serviceable parts inside

=head1 DESCRIPTION

This module defines the state and rule tables that the L<Template::Parser>
module uses to parse templates.  It is generated from a YACC-like grammar
using the C<Parse::Yapp> module.  The F<parser> sub-directory of the
Template Toolkit source distribution contains the grammar and other
files required to generate this module.

But you don't need to worry about any of that unless you're planning to
modify the Template Toolkit language.

=head1 AUTHOR

Andy Wardley E<lt>abw@wardley.orgE<gt>

L<http://wardley.org/>

=head1 COPYRIGHT

Copyright (C) 1996-2014 Andy Wardley.  All Rights Reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

L<Template::Parser>

=cut

# Local Variables:
# mode: perl
# perl-indent-level: 4
# indent-tabs-mode: nil
# End:
#
# vim: expandtab shiftwidth=4:
