#!perl

use strict;
use warnings;
use Test::More tests => 3;

BEGIN {
    use_ok( 'Parse::AccessLog' ) || print "Bail out!\n";
}

my $p = new_ok('Parse::AccessLog');
chomp(my @lines = <DATA>);

# parse as a list
my @recs = $p->parse(@lines);
is( @recs, 1593, 'Parsed 1593 entries (lines) from file' );

__END__
208.115.113.86 - - [13/Jan/2013:00:29:20 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
24.229.44.237 - - [13/Jan/2013:01:04:32 -0600] "GET /favicon.ico HTTP/1.1" 302 467 "-" "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; Win64; x64; Trident/6.0)"
24.229.44.237 - - [13/Jan/2013:01:04:33 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; Win64; x64; Trident/6.0)"
24.229.44.237 - - [13/Jan/2013:01:04:53 -0600] "-" 408 0 "-" "-"
119.63.193.196 - - [13/Jan/2013:01:14:42 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
68.47.129.55 - - [13/Jan/2013:01:27:32 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; CompSpyBot/1.0; +http://www.compspy.com/spider.html)"
78.129.149.17 - - [13/Jan/2013:01:31:04 -0600] "GET http://37.28.156.211/sprawdza.php HTTP/1.1" 404 434 "-" "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)"
208.80.194.29 - - [13/Jan/2013:01:46:50 -0600] "GET /blog HTTP/1.0" 301 465 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
208.80.194.29 - - [13/Jan/2013:01:54:38 -0600] "GET /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/5.0 (X11; U; Linux x86_64; en-US) AppleWebKit/533.4 (KHTML, like Gecko) Chrome/5.0.375.53 Safari/533.4"
119.247.227.238 - - [13/Jan/2013:02:01:15 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
119.247.227.238 - - [13/Jan/2013:02:05:53 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
91.223.75.118 - - [13/Jan/2013:02:08:04 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://confused-peter-mck.ru/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.2; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)"
91.223.75.118 - - [13/Jan/2013:02:08:04 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://cheapdrugsshop.webstarts.com/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.2; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)"
91.223.75.118 - - [13/Jan/2013:02:08:06 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://confused-peter-mck.ru/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.2; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)"
91.223.75.118 - - [13/Jan/2013:02:08:06 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://cheapdrugsshop.webstarts.com/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.2; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)"
178.154.163.29 - - [13/Jan/2013:02:12:13 -0600] "GET /scripts/twitter-who2follow.user.js HTTP/1.1" 302 467 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
178.154.163.29 - - [13/Jan/2013:02:12:15 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
208.115.111.70 - - [13/Jan/2013:02:30:54 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
123.125.71.78 - - [13/Jan/2013:02:37:54 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.163 - - [13/Jan/2013:02:38:45 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
119.63.193.132 - - [13/Jan/2013:02:39:16 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
61.135.248.202 - - [13/Jan/2013:02:43:35 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.202 - - [13/Jan/2013:02:43:35 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.202 - - [13/Jan/2013:02:43:36 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
66.249.74.38 - - [13/Jan/2013:02:45:14 -0600] "GET /blog/life-list HTTP/1.1" 301 317 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
5.9.140.209 - - [13/Jan/2013:03:11:35 -0600] "GET / HTTP/1.1" 403 389 "-" "Python-urllib/2.7"
208.115.111.70 - - [13/Jan/2013:03:28:30 -0600] "GET /blog/tag/cpan/ HTTP/1.1" 200 20268 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
123.125.71.81 - - [13/Jan/2013:03:44:06 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.140 - - [13/Jan/2013:03:45:00 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
123.151.148.207 - - [13/Jan/2013:03:57:56 -0600] "GET / HTTP/1.1" 302 467 "-" "Sosospider+(+http://help.soso.com/webspider.htm)"
123.151.148.207 - - [13/Jan/2013:03:57:56 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Sosospider+(+http://help.soso.com/webspider.htm)"
106.187.97.211 - - [13/Jan/2013:03:58:06 -0600] "POST /blog/wp-cron.php?doing_wp_cron=1358071086.2621769905090332031250 HTTP/1.0" 200 203 "-" "WordPress/3.5; http://mysite.com/blog"
123.151.148.207 - - [13/Jan/2013:03:58:06 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/" "Sosospider+(+http://help.soso.com/webspider.htm)"
173.199.117.235 - - [13/Jan/2013:04:04:00 -0600] "GET /blog/category/tech/linux/ HTTP/1.1" 200 5121 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
76.73.3.18 - - [13/Jan/2013:04:04:04 -0600] "GET /blog/ HTTP/1.1" 200 40487 "-" "Mozilla/5.0 (compatible; CompSpyBot/1.0; +http://www.compspy.com/spider.html)"
217.69.133.67 - - [13/Jan/2013:04:10:40 -0600] "GET /blog/sailing/ HTTP/1.0" 200 10612 "-" "Mozilla/5.0 (compatible; Mail.RU_Bot/2.0; +http://go.mail.ru/help/robots)"
217.69.133.67 - - [13/Jan/2013:04:10:44 -0600] "GET /blog/about/ HTTP/1.0" 200 6884 "-" "Mozilla/5.0 (compatible; Mail.RU_Bot/2.0; +http://go.mail.ru/help/robots)"
217.69.133.67 - - [13/Jan/2013:04:10:46 -0600] "GET /blog/life-list/ HTTP/1.0" 200 6172 "-" "Mozilla/5.0 (compatible; Mail.RU_Bot/2.0; +http://go.mail.ru/help/robots)"
217.69.133.67 - - [13/Jan/2013:04:10:49 -0600] "GET /blog/black-carrots/ HTTP/1.0" 200 8873 "-" "Mozilla/5.0 (compatible; Mail.RU_Bot/2.0; +http://go.mail.ru/help/robots)"
217.69.133.67 - - [13/Jan/2013:04:10:52 -0600] "GET /blog/category/travel/ HTTP/1.0" 200 44205 "-" "Mozilla/5.0 (compatible; Mail.RU_Bot/2.0; +http://go.mail.ru/help/robots)"
217.69.133.67 - - [13/Jan/2013:04:10:55 -0600] "GET /blog/page/2/ HTTP/1.0" 200 72797 "-" "Mozilla/5.0 (compatible; Mail.RU_Bot/2.0; +http://go.mail.ru/help/robots)"
217.69.133.67 - - [13/Jan/2013:04:10:58 -0600] "GET /blog/purple-carrot/ HTTP/1.0" 200 10294 "-" "Mozilla/5.0 (compatible; Mail.RU_Bot/2.0; +http://go.mail.ru/help/robots)"
173.199.117.235 - - [13/Jan/2013:04:24:30 -0600] "GET /blog/tag/new-zealand/ HTTP/1.1" 200 4527 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
66.249.74.38 - - [13/Jan/2013:04:30:33 -0600] "GET /blog/category/warriorism/parkour/ HTTP/1.1" 200 3921 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:05:02:24 -0600] "GET /blog/tag/purple-potatoes/ HTTP/1.1" 200 2671 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:05:10:09 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4123 "http://mysite.com/blog/tag/purple-potatoes/" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:05:10:10 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/tag/purple-potatoes/" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
119.63.193.195 - - [13/Jan/2013:05:14:06 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
173.199.117.235 - - [13/Jan/2013:05:33:12 -0600] "GET /blog/analysis-chinese-phishing-scam/ HTTP/1.1" 200 4077 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
173.199.117.235 - - [13/Jan/2013:05:33:39 -0600] "GET /blog/category/uncategorized/ HTTP/1.1" 200 3573 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
123.125.71.71 - - [13/Jan/2013:05:37:28 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.169 - - [13/Jan/2013:05:38:17 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
61.135.249.233 - - [13/Jan/2013:05:41:08 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.233 - - [13/Jan/2013:05:41:08 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.233 - - [13/Jan/2013:05:41:08 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
5.135.182.148 - - [13/Jan/2013:05:44:55 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
180.76.5.56 - - [13/Jan/2013:06:11:44 -0600] "GET /blog/added-life-list/ HTTP/1.1" 200 3349 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
124.115.6.15 - - [13/Jan/2013:06:33:09 -0600] "GET /robots.txt HTTP/1.1" 200 372 "-" "Mozilla/5.0(compatible; Sosospider/2.0; +http://help.soso.com/webspider.htm)"
123.125.71.108 - - [13/Jan/2013:06:38:28 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.170 - - [13/Jan/2013:06:39:18 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
119.63.193.195 - - [13/Jan/2013:06:40:38 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
5.39.86.195 - - [13/Jan/2013:06:42:22 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
65.55.213.67 - - [13/Jan/2013:06:58:14 -0600] "GET / HTTP/1.1" 302 430 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:06:58:16 -0600] "GET /blog/ HTTP/1.1" 200 11656 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
66.249.74.38 - - [13/Jan/2013:07:02:22 -0600] "GET /blog/thailand-september-2012/ HTTP/1.1" 200 4567 "-" "SAMSUNG-SGH-E250/1.0 Profile/MIDP-2.0 Configuration/CLDC-1.1 UP.Browser/6.2.3.3.c.1.101 (GUI) MMP/2.0 (compatible; Googlebot-Mobile/2.1; +http://www.google.com/bot.html)"
219.234.82.61 - - [13/Jan/2013:07:10:21 -0600] "GET /blog/convert-m4a-files-to-mp3-format-with-tags/ HTTP/1.0" 200 4283 "http://mysite.com/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; MRA 5.8 (build 4157); .NET CLR 2.0.50727; AskTbPTV/5.11.3.15590)"
219.234.82.61 - - [13/Jan/2013:07:10:25 -0600] "GET /blog/spicnspan/ HTTP/1.0" 200 4758 "http://mysite.com/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; MRA 5.8 (build 4157); .NET CLR 2.0.50727; AskTbPTV/5.11.3.15590)"
66.249.74.38 - - [13/Jan/2013:07:24:01 -0600] "GET /blog/tag/osx-2/ HTTP/1.1" 200 6287 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
37.1.207.22 - - [13/Jan/2013:07:27:56 -0600] "GET /blog/wp-content/themes/boldnews/timthumb.php HTTP/1.1" 404 40644 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.77 Safari/535.7"
61.135.248.219 - - [13/Jan/2013:07:40:26 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.219 - - [13/Jan/2013:07:40:26 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.219 - - [13/Jan/2013:07:40:26 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
91.229.78.16 - - [13/Jan/2013:07:51:10 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:07:51:11 -0600] "POST /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:07:51:13 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:07:51:14 -0600] "POST /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:07:51:16 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:07:51:18 -0600] "POST /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:07:51:21 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:07:51:22 -0600] "POST /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:07:51:25 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:07:51:26 -0600] "POST /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:07:51:28 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:07:51:30 -0600] "POST /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/3.0 (compatible; Indy Library)"
173.45.104.226 - - [13/Jan/2013:08:01:37 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (Windows NT 6.1; rv:16.0) Gecko/20100101 Firefox/16.0"
173.45.104.226 - - [13/Jan/2013:08:01:37 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (Windows NT 6.1; rv:16.0) Gecko/20100101 Firefox/16.0"
91.229.78.16 - - [13/Jan/2013:08:20:36 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:08:20:37 -0600] "POST /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:08:20:40 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:08:20:42 -0600] "POST /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:08:20:45 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:08:20:47 -0600] "POST /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:08:20:50 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:08:20:52 -0600] "POST /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:08:20:54 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:08:20:56 -0600] "POST /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:08:20:58 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "-" "Mozilla/3.0 (compatible; Indy Library)"
91.229.78.16 - - [13/Jan/2013:08:20:59 -0600] "POST /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/3.0 (compatible; Indy Library)"
119.247.227.238 - - [13/Jan/2013:08:27:24 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
208.115.113.86 - - [13/Jan/2013:08:30:17 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
173.199.117.235 - - [13/Jan/2013:08:30:45 -0600] "GET /blog/tag/no-tabs/ HTTP/1.1" 200 4043 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
199.19.111.34 - - [13/Jan/2013:08:30:53 -0600] "GET http://myproxylists.com/my-http-headers HTTP/1.1" 404 376 "-" "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.2.28) Gecko/20120306 Firefox/3.6.28 (.NET CLR 3.5.30729)"
46.22.211.11 - - [13/Jan/2013:08:31:39 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
123.125.71.76 - - [13/Jan/2013:08:39:25 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.177 - - [13/Jan/2013:08:40:18 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
209.85.238.38 - - [13/Jan/2013:08:41:32 -0600] "GET / HTTP/1.1" 302 467 "-" "DoCoMo/2.0 N905i(c100;TB;W24H16) (compatible; Googlebot-Mobile/2.1; +http://www.google.com/bot.html)"
209.85.238.38 - - [13/Jan/2013:08:41:33 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "DoCoMo/2.0 N905i(c100;TB;W24H16) (compatible; Googlebot-Mobile/2.1; +http://www.google.com/bot.html)"
173.199.117.235 - - [13/Jan/2013:08:55:59 -0600] "GET /blog/medellin-colombia/ HTTP/1.1" 200 3056 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
202.46.61.108 - - [13/Jan/2013:09:11:38 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
119.63.193.131 - - [13/Jan/2013:09:12:53 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
180.76.5.99 - - [13/Jan/2013:09:15:37 -0600] "GET /blog/category/horticulture/ HTTP/1.1" 200 6302 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
173.199.117.235 - - [13/Jan/2013:09:18:26 -0600] "GET /blog/category/warriorism/parkour/ HTTP/1.1" 200 3865 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
208.115.113.86 - - [13/Jan/2013:09:30:19 -0600] "GET /blog/tag/command-line/feed/ HTTP/1.1" 200 11985 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
123.125.71.41 - - [13/Jan/2013:09:34:04 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
123.125.71.43 - - [13/Jan/2013:09:34:04 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
213.174.154.106 - - [13/Jan/2013:09:42:13 -0600] "GET / HTTP/1.1" 302 410 "http://www.google.com" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:2.0b7) Gecko/20101111 Firefox/4.0b7"
213.174.154.106 - - [13/Jan/2013:09:42:14 -0600] "GET /blog/ HTTP/1.1" 200 40487 "http://www.google.com" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:2.0b7) Gecko/20101111 Firefox/4.0b7"
66.249.74.38 - - [13/Jan/2013:09:52:36 -0600] "GET /robots.txt HTTP/1.1" 200 372 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:09:52:36 -0600] "GET /blog/tag/carrot-soup/ HTTP/1.1" 200 2781 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
180.96.16.70 - - [13/Jan/2013:10:04:50 -0600] "GET /blog/ HTTP/1.0" 200 11656 "http://mysite.com/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; FunWebProducts; .NET CLR 1.1.4322; PeoplePal 6.2)"
180.96.16.70 - - [13/Jan/2013:10:04:52 -0600] "GET /blog/spicnspan/ HTTP/1.0" 200 4758 "http://mysite.com/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; FunWebProducts; .NET CLR 1.1.4322; PeoplePal 6.2)"
178.154.163.29 - - [13/Jan/2013:10:13:42 -0600] "GET /robots.txt HTTP/1.1" 200 328 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
216.244.78.146 - - [13/Jan/2013:10:20:53 -0600] "GET /blog/almost-christmas/ HTTP/1.1" 200 14916 "-" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; TencentTraveler)"
106.187.97.211 - - [13/Jan/2013:10:20:53 -0600] "POST /blog/wp-cron.php?doing_wp_cron=1358094053.4931340217590332031250 HTTP/1.0" 200 203 "-" "WordPress/3.5; http://mysite.com/blog"
208.115.111.70 - - [13/Jan/2013:10:31:29 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
61.135.249.155 - - [13/Jan/2013:10:37:40 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.155 - - [13/Jan/2013:10:37:40 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.155 - - [13/Jan/2013:10:37:40 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
119.63.193.132 - - [13/Jan/2013:10:40:43 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
65.52.111.39 - - [13/Jan/2013:11:11:48 -0600] "GET / HTTP/1.1" 302 467 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2;  SV1;  .NET CLR 1.1.4325;  .NET CLR 2.0.40607;  .NET CLR 3.0.30729;  .NET CLR 3.5.30729)"
65.111.177.188 - - [13/Jan/2013:11:11:54 -0600] "GET / HTTP/1.1" 403 426 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [13/Jan/2013:11:11:54 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [13/Jan/2013:11:11:54 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [13/Jan/2013:11:11:54 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.52.111.39 - - [13/Jan/2013:11:11:56 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2;  SV1;  .NET CLR 1.1.4325;  .NET CLR 2.0.40607;  .NET CLR 3.0.30729;  .NET CLR 3.5.30729)"
65.52.111.39 - - [13/Jan/2013:11:12:00 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2;  SV1;  .NET CLR 1.1.4325;  .NET CLR 2.0.40607;  .NET CLR 3.0.30729;  .NET CLR 3.5.30729)"
65.52.111.39 - - [13/Jan/2013:11:12:08 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2;  SV1;  .NET CLR 1.1.4325;  .NET CLR 2.0.40607;  .NET CLR 3.0.30729;  .NET CLR 3.5.30729)"
65.52.111.39 - - [13/Jan/2013:11:12:11 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2;  SV1;  .NET CLR 1.1.4325;  .NET CLR 2.0.40607;  .NET CLR 3.0.30729;  .NET CLR 3.5.30729)"
178.154.163.29 - - [13/Jan/2013:11:23:04 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
208.115.111.70 - - [13/Jan/2013:11:27:49 -0600] "GET /blog/os-x-madplay/ HTTP/1.1" 200 14000 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.111.70 - - [13/Jan/2013:11:27:52 -0600] "GET /blog/tag/japan/feed/ HTTP/1.1" 200 4101 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.111.70 - - [13/Jan/2013:11:27:57 -0600] "GET /blog/tag/terminal/ HTTP/1.1" 200 8373 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
178.137.129.249 - - [13/Jan/2013:11:35:06 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://www.forexbusinessman.net/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)"
178.137.129.249 - - [13/Jan/2013:11:35:08 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://www.forexbusinessman.net/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322; .NET CLR 2.0.50727)"
108.4.184.231 - - [13/Jan/2013:11:42:38 -0600] "GET /blog/osx-change-root-shell/ HTTP/1.1" 200 3490 "http://www.google.com/url?sa=t&rct=j&q=osx%20change%20user%20shell&source=web&cd=7&ved=0CFkQFjAG&url=http%3A%2F%2Fmysite.com%2Fblog%2Fosx-change-root-shell%2F&ei=4_HyUKmGHuzK0AHcsYCoAQ&usg=AFQjCNEtdT_TK4aA_LgmaTsGgaFHKRsDlg&bvm=bv.1357700187,d.dmQ" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:39 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:39 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:39 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:39 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:39 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11836 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:40 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:40 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:40 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:40 -0600] "GET /blog/wp-content/themes/koi-improved/img/submit-btn.png HTTP/1.1" 200 1388 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:40 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:40 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:40 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:41 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:41 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:41 -0600] "GET /blog/disable-speed-dial-feature-in-firefox-13/ HTTP/1.1" 200 3791 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:42 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
108.4.184.231 - - [13/Jan/2013:11:42:42 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
91.135.244.15 - - [13/Jan/2013:12:07:49 -0600] "GET /user/soapCaller.bs HTTP/1.1" 404 397 "-" "Morfeus Fucking Scanner"
217.69.133.67 - - [13/Jan/2013:12:09:37 -0600] "GET /sitemap.xml HTTP/1.0" 302 429 "-" "Mozilla/5.0 (compatible; Mail.RU_Bot/2.0; +http://go.mail.ru/help/robots)"
1.202.218.21 - - [13/Jan/2013:12:32:50 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "Mozilla/5.0 (compatible; JikeSpider; +http://shoulu.jike.com/spider.html)"
86.174.170.191 - - [13/Jan/2013:12:36:34 -0600] "GET /blog/almost-christmas/ HTTP/1.1" 200 5670 "http://www.google.co.uk/search?hl=en&safe=strict&tbo=d&site=webhp&q=inurl%3AALMOST++EVERYONE++SPEAKS++ENGLISH+iin+malaysia&oq=inurl%3AALMOST++EVERYONE++SPEAKS++ENGLISH+iin+malaysia&gs_l=serp.3...17038.22338.0.22874.13.13.0.0.0.0.801.4365.2j2j0j1j0j5j1.11.0.les%3B..0.0...1c.1.hIcneduDGOY" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:36 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:36 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:36 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 746 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:36 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:36 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:37 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:37 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:37 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:37 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73678 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:37 -0600] "GET /blog/wp-content/themes/koi-improved/img/cancel-reply.png HTTP/1.1" 200 588 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:37 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:37 -0600] "GET /blog/wp-content/themes/koi-improved/img/submit-btn.png HTTP/1.1" 200 1388 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
86.174.170.191 - - [13/Jan/2013:12:36:37 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/almost-christmas/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
180.76.5.148 - - [13/Jan/2013:12:37:39 -0600] "GET /blog/?p=1250 HTTP/1.1" 301 284 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
180.76.5.164 - - [13/Jan/2013:12:37:40 -0600] "GET /blog/purple-carrot/ HTTP/1.1" 200 3032 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
61.135.249.159 - - [13/Jan/2013:12:43:58 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.159 - - [13/Jan/2013:12:43:58 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.159 - - [13/Jan/2013:12:43:58 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
124.115.6.13 - - [13/Jan/2013:13:04:43 -0600] "GET /robots.txt HTTP/1.1" 200 372 "-" "Mozilla/5.0(compatible; Sosospider/2.0; +http://help.soso.com/webspider.htm)"
173.199.117.235 - - [13/Jan/2013:13:07:54 -0600] "GET /blog/traveling-vs-living/ HTTP/1.1" 200 5756 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
202.46.62.145 - - [13/Jan/2013:13:13:24 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
119.63.193.131 - - [13/Jan/2013:13:14:43 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
209.250.21.129 - - [13/Jan/2013:13:15:16 -0600] "GET /blog/page/2/?view=month&cal_d=1&cal_m=2&cal_y=2029&course=1 HTTP/1.0" 200 15314 "http://mysite.com/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; FunWebProducts; .NET CLR 1.1.4322; PeoplePal 6.2)"
209.250.21.129 - - [13/Jan/2013:13:15:17 -0600] "GET /blog/spicnspan/ HTTP/1.0" 200 4758 "http://mysite.com/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; FunWebProducts; .NET CLR 1.1.4322; PeoplePal 6.2)"
180.76.5.99 - - [13/Jan/2013:13:25:18 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
180.76.5.63 - - [13/Jan/2013:13:25:18 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
180.76.6.222 - - [13/Jan/2013:13:25:18 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
180.76.6.20 - - [13/Jan/2013:13:25:18 -0600] "GET /robots.txt HTTP/1.1" 302 430 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
180.76.5.141 - - [13/Jan/2013:13:25:19 -0600] "GET /blog/ HTTP/1.1" 200 11656 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
119.247.227.238 - - [13/Jan/2013:13:27:18 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
96.254.171.2 - - [13/Jan/2013:13:30:41 -0600] "GET http://gameframe.net/headers HTTP/1.1" 404 369 "-" "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.2.28) Gecko/20120306 Firefox/3.6.28 (.NET CLR 3.5.30729)"
123.151.148.207 - - [13/Jan/2013:13:44:06 -0600] "GET / HTTP/1.1" 302 467 "-" "Sosospider+(+http://help.soso.com/webspider.htm)"
123.151.148.207 - - [13/Jan/2013:13:44:06 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Sosospider+(+http://help.soso.com/webspider.htm)"
123.151.148.207 - - [13/Jan/2013:13:44:16 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/" "Sosospider+(+http://help.soso.com/webspider.htm)"
178.154.163.29 - - [13/Jan/2013:13:46:29 -0600] "GET /blog/linux-shared-library-error/ HTTP/1.1" 200 3717 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
173.199.117.235 - - [13/Jan/2013:14:00:15 -0600] "GET /blog/osx-universal-binary/ HTTP/1.1" 200 3504 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
157.55.17.77 - - [13/Jan/2013:14:02:04 -0600] "GET /blog/analysis-chinese-phishing-scam/ HTTP/1.1" 200 4133 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2;  SLCC1;  .NET CLR 1.1.4325;  .NET CLR 2.0.50727;  .NET CLR 3.0.30729;  .NET CLR 3.5.30729)"
157.55.17.77 - - [13/Jan/2013:14:02:13 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4123 "http://mysite.com/blog/analysis-chinese-phishing-scam/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2;  SLCC1;  .NET CLR 1.1.4325;  .NET CLR 2.0.50727;  .NET CLR 3.0.30729;  .NET CLR 3.5.30729)"
157.55.17.77 - - [13/Jan/2013:14:02:13 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/analysis-chinese-phishing-scam/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2;  SLCC1;  .NET CLR 1.1.4325;  .NET CLR 2.0.50727;  .NET CLR 3.0.30729;  .NET CLR 3.5.30729)"
157.55.17.77 - - [13/Jan/2013:14:02:14 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 746 "http://mysite.com/blog/analysis-chinese-phishing-scam/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2;  SLCC1;  .NET CLR 1.1.4325;  .NET CLR 2.0.50727;  .NET CLR 3.0.30729;  .NET CLR 3.5.30729)"
157.55.17.77 - - [13/Jan/2013:14:02:17 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11836 "http://mysite.com/blog/analysis-chinese-phishing-scam/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2;  SLCC1;  .NET CLR 1.1.4325;  .NET CLR 2.0.50727;  .NET CLR 3.0.30729;  .NET CLR 3.5.30729)"
70.75.177.99 - - [13/Jan/2013:14:24:44 -0600] "GET /scripts/twitter-who2follow.user.js HTTP/1.1" 302 467 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0"
70.75.177.99 - - [13/Jan/2013:14:24:44 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0"
123.125.71.116 - - [13/Jan/2013:14:38:36 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
202.46.52.129 - - [13/Jan/2013:14:39:28 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
220.181.108.154 - - [13/Jan/2013:14:39:29 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
119.63.193.195 - - [13/Jan/2013:14:39:33 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
66.249.74.92 - - [13/Jan/2013:14:51:25 -0600] "GET /robots.txt HTTP/1.1" 200 372 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.92 - - [13/Jan/2013:14:51:25 -0600] "GET / HTTP/1.1" 302 466 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
95.108.150.235 - - [13/Jan/2013:14:55:45 -0600] "GET /robots.txt HTTP/1.1" 200 328 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
95.108.150.235 - - [13/Jan/2013:14:55:46 -0600] "GET / HTTP/1.1" 302 466 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
95.108.150.235 - - [13/Jan/2013:14:55:47 -0600] "GET /robots.txt HTTP/1.1" 200 328 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
95.108.150.235 - - [13/Jan/2013:14:55:47 -0600] "GET / HTTP/1.1" 302 466 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
95.108.150.235 - - [13/Jan/2013:14:55:47 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
95.108.150.235 - - [13/Jan/2013:14:55:48 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
89.43.142.149 - - [13/Jan/2013:15:32:16 -0600] "GET /blog/linux-shared-library-error/ HTTP/1.1" 200 3717 "http://www.google.ro/url?sa=t&rct=j&q=error+while+loading+shared+libraries%3A+libcrypto.so.1.0.0%3A+cannot+open+shared+object+file%3A+No+such+file+or+directory&source=web&cd=3&ved=0CEcQFjAC&url=http%3A%2F%2Fmysite.com%2Fblog%2Flinux-shared-library-error%2F&ei=zCfzUJ2kJ4HL4AS1tICgAg&usg=AFQjCNEqOGaw6N0t-o1fgvyTViwCNRQQzA&bvm=bv.1357700187,d.bGE" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:16 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:17 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:17 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:17 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:17 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:17 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:17 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:17 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:18 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:18 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 531 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:18 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:19 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
89.43.142.149 - - [13/Jan/2013:15:32:19 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
66.249.74.38 - - [13/Jan/2013:15:36:25 -0600] "GET /blog/thailand-september-2012/ HTTP/1.1" 200 4567 "-" "Mozilla/5.0 (iPhone; U; CPU iPhone OS 4_1 like Mac OS X; en-us) AppleWebKit/532.9 (KHTML, like Gecko) Version/4.0.5 Mobile/8B117 Safari/6531.22.7 (compatible; Googlebot-Mobile/2.1; +http://www.google.com/bot.html)"
123.125.71.103 - - [13/Jan/2013:15:39:05 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.152 - - [13/Jan/2013:15:39:59 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
66.249.74.38 - - [13/Jan/2013:15:45:57 -0600] "GET /blog/wp-content/themes/thesis_185/custom/custom.css HTTP/1.1" 200 1057 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:15:45:58 -0600] "GET /blog/wp-content/themes/thesis_185/custom/layout.css HTTP/1.1" 200 7009 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:15:53:53 -0600] "GET /blog/tag/osx-lion/ HTTP/1.1" 200 2721 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:15:54:59 -0600] "GET /blog/category/uncategorized/ HTTP/1.1" 200 3629 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
119.247.227.238 - - [13/Jan/2013:15:57:15 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
180.76.5.93 - - [13/Jan/2013:15:58:04 -0600] "GET /blog/tag/cpan/ HTTP/1.1" 200 4036 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
66.249.74.38 - - [13/Jan/2013:15:58:32 -0600] "GET /blog/page/2/?view=month&course=1&cal_d=1&cal_m=3&cal_y=2136 HTTP/1.1" 200 15349 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:09:02 -0600] "GET /blog/tag/japan/ HTTP/1.1" 200 3284 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:09:18 -0600] "GET /blog/tag/tokyo/ HTTP/1.1" 200 3285 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:09:24 -0600] "GET /blog/tag/travel/ HTTP/1.1" 200 11856 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:09:31 -0600] "GET /blog/tag/spanish/ HTTP/1.1" 200 4319 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:09:42 -0600] "GET /blog/tag/firefox/ HTTP/1.1" 200 2794 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:09:55 -0600] "GET /blog/tag/language/ HTTP/1.1" 200 4802 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:10:09 -0600] "GET /blog/tag/japanese/ HTTP/1.1" 200 3287 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:10:22 -0600] "GET /blog/tag/krav-maga/ HTTP/1.1" 200 3500 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:10:35 -0600] "GET /blog/tag/date-trees/ HTTP/1.1" 200 3239 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:10:49 -0600] "GET /blog/tag/date-palms/ HTTP/1.1" 200 3235 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:11:02 -0600] "GET /blog/tag/annoyances/ HTTP/1.1" 200 2794 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:11:16 -0600] "GET /blog/tag/exit-popups/ HTTP/1.1" 200 2798 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:11:29 -0600] "GET /blog/tag/goal-setting/ HTTP/1.1" 200 4809 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:11:42 -0600] "GET /blog/tag/horticulture/ HTTP/1.1" 200 3237 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:11:56 -0600] "GET /blog/tag/sweet-skills/ HTTP/1.1" 200 4802 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:12:09 -0600] "GET /blog/tag/learn-spanish/ HTTP/1.1" 200 3411 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:12:23 -0600] "GET /blog/tag/spanish-resources/ HTTP/1.1" 200 3411 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:12:37 -0600] "GET /blog/tag/personal-development/ HTTP/1.1" 200 3502 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:12:51 -0600] "GET /blog/tag/grow-dates-from-seed/ HTTP/1.1" 200 3238 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:13:07 -0600] "GET /blog/tag/grow-plants-from-seeds/ HTTP/1.1" 200 3241 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:18:45 -0600] "GET /blog/tag/texas/ HTTP/1.1" 200 4580 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:18:53 -0600] "GET /blog/tag/life/ HTTP/1.1" 200 4579 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:19:03 -0600] "GET /blog/tag/belief/ HTTP/1.1" 200 3545 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:19:11 -0600] "GET /blog/tag/panama/ HTTP/1.1" 200 3003 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:19:20 -0600] "GET /blog/tag/castle/ HTTP/1.1" 200 3546 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:19:28 -0600] "GET /blog/tag/bicycle/ HTTP/1.1" 200 4579 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:19:36 -0600] "GET /blog/tag/belgium/ HTTP/1.1" 200 3542 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:19:45 -0600] "GET /blog/tag/medellin/ HTTP/1.1" 200 3617 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:19:53 -0600] "GET /blog/tag/colombia/ HTTP/1.1" 200 3614 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:20:01 -0600] "GET /blog/tag/wandering/ HTTP/1.1" 200 4584 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:20:03 -0600] "GET / HTTP/1.1" 302 467 "-" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:04 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
66.249.74.38 - - [13/Jan/2013:16:20:09 -0600] "GET /blog/tag/costa-rica/ HTTP/1.1" 200 3498 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:20:15 -0600] "GET /blog/ HTTP/1.1" 200 11693 "http://www.mysite.com/" "Mozilla/5.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:20:18 -0600] "GET /blog/tag/new-zealand/ HTTP/1.1" 200 4583 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:20:24 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4123 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:24 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:24 -0600] "GET /blog HTTP/1.1" 301 485 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:24 -0600] "GET /blog/about/ HTTP/1.1" 200 2678 "http://mysite.com/blog/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:24 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:24 -0600] "GET /blog/life-list/ HTTP/1.1" 200 2211 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:24 -0600] "GET /blog/remove-ubuntudebian-version-from-sshd-server-string/ HTTP/1.1" 200 3344 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:24 -0600] "GET /blog/feed/ HTTP/1.1" 200 10927 "http://mysite.com/blog/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:24 -0600] "GET /blog/category/tech/linux/ HTTP/1.1" 200 5177 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:24 -0600] "GET /blog/tag/ubuntu-sshd/ HTTP/1.1" 200 2633 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:24 -0600] "GET /blog/ HTTP/1.1" 200 11637 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:24 -0600] "GET /blog/category/tech/ HTTP/1.1" 200 27505 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:25 -0600] "GET /blog/almost-christmas/ HTTP/1.1" 200 5670 "http://mysite.com/blog/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:25 -0600] "GET /blog/category/food/ HTTP/1.1" 200 5921 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:25 -0600] "GET /blog/category/travel/ HTTP/1.1" 200 14866 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:26 -0600] "GET /blog/sailing/ HTTP/1.1" 200 3764 "http://mysite.com/blog/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:26 -0600] "GET /blog/thailand-september-2012/ HTTP/1.1" 200 4567 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:26 -0600] "GET /blog/category/horticulture/ HTTP/1.1" 200 6339 "http://mysite.com/blog/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:26 -0600] "GET /blog/category/adventuring/ HTTP/1.1" 200 7670 "http://mysite.com/blog/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:27 -0600] "GET /blog/category/freedom/ HTTP/1.1" 200 21391 "http://mysite.com/blog/" "Mozilla/5.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:20:27 -0600] "GET /blog/tag/buenos-aires/ HTTP/1.1" 200 3407 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/tag/purple-potatoes/ HTTP/1.1" 200 2615 "http://mysite.com/blog/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/tag/osx-lion/ HTTP/1.1" 200 2721 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/tag/purple-carrots/ HTTP/1.1" 200 2788 "http://mysite.com/blog/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/tag/yellow-carrots/ HTTP/1.1" 200 2790 "http://mysite.com/blog/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/tag/beet-soup/ HTTP/1.1" 200 2667 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:36 -0600] "GET /blog/tag/terminal/ HTTP/1.1" 200 2720 "http://mysite.com/blog/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/rare-ish-foods/ HTTP/1.1" 200 2970 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/tag/carrot-soup/ HTTP/1.1" 200 2781 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/tag/osx-terminal/ HTTP/1.1" 200 2720 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/purple-carrot/ HTTP/1.1" 200 3043 "http://mysite.com/blog/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:34 -0600] "GET /blog/tag/disable-firefox-speed-dial/ HTTP/1.1" 200 2602 "http://mysite.com/blog/" "Mozilla/5.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:20:34 -0600] "GET /blog/tag/cheap-airfare/ HTTP/1.1" 200 3526 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:20:34 -0600] "GET /blog/disable-speed-dial-feature-in-firefox-13/ HTTP/1.1" 200 3736 "http://mysite.com/blog/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/tag/firefox-13-speed-dial/ HTTP/1.1" 200 2607 "http://mysite.com/blog/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/category/tech/osx/ HTTP/1.1" 200 7287 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/osx-change-root-shell/ HTTP/1.1" 200 3490 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/tag/firefox-speed-dial/ HTTP/1.1" 200 2546 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/tag/osx-command-line/ HTTP/1.1" 200 2719 "http://mysite.com/blog/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/tag/firefox-13/ HTTP/1.1" 200 2604 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/wp-content/uploads/2010/06/code5.jpg HTTP/1.1" 200 31149 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:51 -0600] "GET /blog/wp-content/uploads/2011/01/exitpop2.png HTTP/1.1" 200 46720 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:51 -0600] "GET /blog/wp-content/uploads/2011/01/prefs31.png HTTP/1.1" 200 46720 "http://mysite.com/blog/category/tech/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
66.249.74.38 - - [13/Jan/2013:16:20:42 -0600] "GET /blog/tag/internet-cafe/ HTTP/1.1" 200 3409 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:20:52 -0600] "GET /blog/category/tech/page/2/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/tech/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:48 -0600] "GET /blog/category/tech/perl/ HTTP/1.1" 302 263 "http://mysite.com/blog/category/tech/linux/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:55 -0600] "GET /blog/tag/tokyo/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:55 -0600] "GET /blog/the-skills/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:56 -0600] "GET /blog/category/language/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:55 -0600] "GET /blog/tag/travel/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/convert-m4a-files-to-mp3-format-with-tags/ HTTP/1.1" 302 342 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/tag/file-permissions/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/tech/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:55 -0600] "GET /blog/tag/japanese/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:52 -0600] "GET /blog/hdcp-master-key/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/tech/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:35 -0600] "GET /blog/tag/osx-2/ HTTP/1.1" 200 6287 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:56 -0600] "GET /blog/tag/language/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:51 -0600] "GET /blog/tag/firefox/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:21:05 -0600] "GET /blog/category/tech/perl/wp-admin/install.php HTTP/1.1" 500 529 "http://mysite.com/blog/category/tech/linux/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:53 -0600] "GET /blog/tag/japan/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:21:06 -0600] "GET /blog/convert-m4a-files-to-mp3-format-with-tags/wp-admin/install.php HTTP/1.1" 500 529 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:21:02 -0600] "GET /blog/things-every-internet-cafe-should-do-to-improve-service/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:20:59 -0600] "GET /blog/tag/japan/feed/ HTTP/1.1" 500 529 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:20:58 -0600] "GET /blog/tag/sweet-skills/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:59 -0600] "GET /blog/inexpensive-airfare/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:58 -0600] "GET /blog/arrival-at-quebec-city/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:21:04 -0600] "GET /blog/tag/buenos-aires/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:50 -0600] "GET /blog/how-to-break-out-of-an-exit-popup-in-firefox/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:21:02 -0600] "GET /blog/tag/cheap-airfare/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:46 -0600] "GET /blog/black-carrots/ HTTP/1.1" 404 1393 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:21:04 -0600] "GET /blog/tag/internet-cafe/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:21:18 -0600] "GET /blog/tag/the-most-beautiful-women-in-the-world/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:21:18 -0600] "GET /blog/tag/spanish/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/tag/cpan/ HTTP/1.1" 302 309 "http://mysite.com/blog/category/tech/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:21:18 -0600] "GET /blog/como-me-le-va/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:21:18 -0600] "GET /blog/tag/costa-rica/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/tag/amazon-s3-perl-module/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:21:18 -0600] "GET /blog/medellin-colombia/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:21:18 -0600] "GET /blog/panama/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:21:18 -0600] "GET /blog/tag/colombia/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:21:30 -0600] "GET /blog/tag/tokyo/feed/ HTTP/1.1" 500 529 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:20:53 -0600] "GET /blog/japan-initial-experiences/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:46 -0600] "GET /blog/analysis-chinese-phishing-scam/ HTTP/1.1" 404 1393 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/basic-perl-log-function/ HTTP/1.1" 404 1449 "http://mysite.com/blog/category/tech/linux/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/category/portfolio/ HTTP/1.1" 404 1449 "http://mysite.com/blog/category/tech/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/tag/superfluous-whitespace/ HTTP/1.1" 200 3549 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/linux-shared-library-error/ HTTP/1.1" 404 1449 "http://mysite.com/blog/category/tech/linux/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/cpan-changing-permissions-on-osx/ HTTP/1.1" 404 1449 "http://mysite.com/blog/category/tech/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/tag/free-your-music/ HTTP/1.1" 404 1449 "http://mysite.com/blog/category/tech/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:50 -0600] "GET /blog/tag/annoyances/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/tech/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:46 -0600] "GET /blog/category/tech/information-security/ HTTP/1.1" 404 1449 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:45 -0600] "GET /blog/page/2/ HTTP/1.1" 200 14736 "http://mysite.com/blog/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/tag/perl-2/ HTTP/1.1" 404 1449 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:21:18 -0600] "GET /blog/tag/medellin/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:34 -0600] "GET /blog/tag/ff13/ HTTP/1.1" 200 2117 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:21:41 -0600] "GET /blog/category/travel/page/2/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:21:41 -0600] "GET /blog/date-palms-p1/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/horticulture/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:46 -0600] "GET /blog/spicnspan/ HTTP/1.1" 404 1393 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/facebook-account-deletion-link/ HTTP/1.1" 404 1449 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:21:41 -0600] "GET /blog/tag/panama/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/travel/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/category/rants/ HTTP/1.1" 404 1449 "http://mysite.com/blog/category/tech/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:21:41 -0600] "GET /blog/tag/date-palms/ HTTP/1.1" 500 529 "http://mysite.com/blog/category/horticulture/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:20:49 -0600] "GET /blog/tag/no-tabs/ HTTP/1.1" 404 1449 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:20:51 -0600] "GET /blog/tag/exit-popups/ HTTP/1.1" 404 1449 "http://mysite.com/blog/category/tech/" "Mozilla/6.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:21:44 -0600] "GET /blog/tag/travel/feed/ HTTP/1.1" 200 10981 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:21:46 -0600] "GET /blog/tag/the-most-beautiful-women-in-the-world/ HTTP/1.1" 200 2893 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:21:46 -0600] "GET /blog/tag/spanish/feed/ HTTP/1.1" 200 3221 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:21:50 -0600] "GET /blog/tag/firefox/feed/ HTTP/1.1" 200 1698 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:21:51 -0600] "GET /blog/tag/horticulture/ HTTP/1.1" 200 3181 "http://mysite.com/blog/category/horticulture/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:21:51 -0600] "GET /blog/tag/date-trees/ HTTP/1.1" 200 3183 "http://mysite.com/blog/category/horticulture/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:21:52 -0600] "GET /blog/tag/grow-dates-from-seed/ HTTP/1.1" 200 3238 "http://mysite.com/blog/category/horticulture/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:21:52 -0600] "GET /blog/tag/grow-plants-from-seeds/ HTTP/1.1" 200 3241 "http://mysite.com/blog/category/horticulture/" "Mozilla/6.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:21:53 -0600] "GET /blog/tag/japanese/feed/ HTTP/1.1" 200 2141 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:21:57 -0600] "GET /blog/tag/language/feed/ HTTP/1.1" 200 3672 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:22:01 -0600] "GET /blog/tag/krav-maga/feed/ HTTP/1.1" 200 2418 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:22:03 -0600] "GET /blog/tag/belgium/ HTTP/1.1" 200 3542 "http://mysite.com/blog/category/adventuring/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:22:03 -0600] "GET /blog/life-update-castles-belgium/ HTTP/1.1" 200 3831 "http://mysite.com/blog/category/adventuring/" "Mozilla/5.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:22:06 -0600] "GET /blog/tag/date-palms/feed/ HTTP/1.1" 200 2135 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:22:13 -0600] "GET /blog/tag/date-trees/feed/ HTTP/1.1" 200 2137 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:22:15 -0600] "GET /blog/tag/belief/ HTTP/1.1" 200 3489 "http://mysite.com/blog/category/adventuring/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:22:15 -0600] "GET /blog/tag/goal-setting/ HTTP/1.1" 200 4809 "http://mysite.com/blog/category/adventuring/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:15 -0600] "GET /blog/tag/castle/ HTTP/1.1" 200 3490 "http://mysite.com/blog/category/adventuring/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:15 -0600] "GET /blog/traveling-vs-living/ HTTP/1.1" 200 5812 "http://mysite.com/blog/category/adventuring/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:22:15 -0600] "GET /blog/tag/bicycle/ HTTP/1.1" 200 4579 "http://mysite.com/blog/category/adventuring/" "Mozilla/6.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:22:22 -0600] "GET /blog/tag/annoyances/feed/ HTTP/1.1" 200 1700 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:22:25 -0600] "GET /blog/tag/life/ HTTP/1.1" 200 4579 "http://mysite.com/blog/category/adventuring/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:25 -0600] "GET /blog/tag/wandering/ HTTP/1.1" 200 4584 "http://mysite.com/blog/category/adventuring/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:22:25 -0600] "GET /blog/tag/new-zealand/ HTTP/1.1" 200 4583 "http://mysite.com/blog/category/adventuring/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:22:25 -0600] "GET /blog/tag/texas/ HTTP/1.1" 200 4580 "http://mysite.com/blog/category/adventuring/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:25 -0600] "GET /blog/change-is-good/ HTTP/1.1" 200 3579 "http://mysite.com/blog/category/freedom/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:25 -0600] "GET /blog/category/health/ HTTP/1.1" 200 5304 "http://mysite.com/blog/category/freedom/" "Mozilla/6.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:22:30 -0600] "GET /blog/tag/exit-popups/feed/ HTTP/1.1" 200 1701 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:22:36 -0600] "GET /blog/category/warriorism/parkour/ HTTP/1.1" 200 3921 "http://mysite.com/blog/category/freedom/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:22:36 -0600] "GET /blog/disable-speed-dial-feature-in-firefox-13/?replytocom=8741 HTTP/1.1" 200 3811 "http://mysite.com/blog/disable-speed-dial-feature-in-firefox-13/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:22:36 -0600] "GET /blog/os-x-madplay/ HTTP/1.1" 200 4329 "http://mysite.com/blog/category/tech/osx/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:22:36 -0600] "GET /blog/tag/itunes/ HTTP/1.1" 200 4084 "http://mysite.com/blog/category/tech/osx/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:22:36 -0600] "GET /blog/disable-speed-dial-feature-in-firefox-13/?replytocom=8742 HTTP/1.1" 200 3753 "http://mysite.com/blog/disable-speed-dial-feature-in-firefox-13/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:22:36 -0600] "GET /blog/tag/command-line/ HTTP/1.1" 200 4083 "http://mysite.com/blog/category/tech/osx/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:22:36 -0600] "GET /blog/category/warriorism/ HTTP/1.1" 200 6259 "http://mysite.com/blog/category/freedom/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
66.249.74.38 - - [13/Jan/2013:16:22:38 -0600] "GET /blog/tag/horticulture/feed/ HTTP/1.1" 200 2136 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:22:46 -0600] "GET /blog/tag/ff13/ HTTP/1.1" 200 2603 "http://mysite.com/blog/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:46 -0600] "GET /blog/category/tech/information-security/ HTTP/1.1" 200 3848 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:22:46 -0600] "GET /blog/black-carrots/ HTTP/1.1" 200 3205 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:22:46 -0600] "GET /blog/analysis-chinese-phishing-scam/ HTTP/1.1" 200 4133 "http://mysite.com/blog/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:46 -0600] "GET /blog/tag/madplay/ HTTP/1.1" 200 4085 "http://mysite.com/blog/category/tech/osx/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:46 -0600] "GET /blog/tag/osx-2/ HTTP/1.1" 200 6287 "http://mysite.com/blog/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:46 -0600] "GET /blog/osx-universal-binary/ HTTP/1.1" 200 3560 "http://mysite.com/blog/category/tech/osx/" "Mozilla/5.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:22:47 -0600] "GET /blog/tag/sweet-skills/feed/ HTTP/1.1" 200 3670 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:22:46 -0600] "GET /blog/page/2/ HTTP/1.1" 200 15257 "http://mysite.com/blog/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
66.249.74.38 - - [13/Jan/2013:16:22:55 -0600] "GET /blog/tag/goal-setting/feed/ HTTP/1.1" 200 3731 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:22:57 -0600] "GET /blog/basic-perl-log-function/ HTTP/1.1" 200 3733 "http://mysite.com/blog/category/tech/linux/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:57 -0600] "GET /blog/spicnspan/ HTTP/1.1" 200 4795 "http://mysite.com/blog/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:57 -0600] "GET /blog/linux-shared-library-error/ HTTP/1.1" 200 3661 "http://mysite.com/blog/category/tech/linux/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:22:57 -0600] "GET /blog/tag/free-your-music/ HTTP/1.1" 200 3975 "http://mysite.com/blog/category/tech/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:22:57 -0600] "GET /blog/facebook-account-deletion-link/ HTTP/1.1" 200 2743 "http://mysite.com/blog/category/tech/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:57 -0600] "GET /blog/tag/no-tabs/ HTTP/1.1" 200 4099 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:57 -0600] "GET /blog/category/portfolio/ HTTP/1.1" 200 5600 "http://mysite.com/blog/category/tech/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:57 -0600] "GET /blog/tag/amazon-s3-perl-module/ HTTP/1.1" 200 4072 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:22:57 -0600] "GET /blog/tag/perl-2/ HTTP/1.1" 200 7408 "http://mysite.com/blog/category/tech/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:22:57 -0600] "GET /blog/category/rants/ HTTP/1.1" 200 5409 "http://mysite.com/blog/category/tech/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
66.249.74.38 - - [13/Jan/2013:16:23:03 -0600] "GET /blog/tag/learn-spanish/feed/ HTTP/1.1" 200 2265 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:23:08 -0600] "GET /blog/how-to-break-out-of-an-exit-popup-in-firefox/ HTTP/1.1" 200 3046 "http://mysite.com/blog/category/tech/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:09 -0600] "GET /blog/tag/annoyances/ HTTP/1.1" 200 2794 "http://mysite.com/blog/category/tech/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:08 -0600] "GET /blog/tag/cpan/ HTTP/1.1" 200 4073 "http://mysite.com/blog/category/tech/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:08 -0600] "GET /blog/tag/exit-popups/ HTTP/1.1" 200 2742 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:09 -0600] "GET /blog/japan-initial-experiences/ HTTP/1.1" 200 4163 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:08 -0600] "GET /blog/cpan-changing-permissions-on-osx/ HTTP/1.1" 200 4252 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:09 -0600] "GET /blog/take-action-now/ HTTP/1.1" 200 3775 "http://mysite.com/blog/tag/goal-setting/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:09 -0600] "GET /blog/tag/personal-development/ HTTP/1.1" 200 3502 "http://mysite.com/blog/tag/goal-setting/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:08 -0600] "GET /blog/tag/superfluous-whitespace/ HTTP/1.1" 200 4103 "http://mysite.com/blog/category/tech/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:09 -0600] "GET /blog/tag/medellin/ HTTP/1.1" 200 3617 "http://mysite.com/blog/category/travel/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:09 -0600] "GET /blog/tag/krav-maga/ HTTP/1.1" 200 3500 "http://mysite.com/blog/tag/goal-setting/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:09 -0600] "GET /blog/how-to-be-physically-healthy/ HTTP/1.1" 200 3650 "http://mysite.com/blog/category/health/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:09 -0600] "GET /blog/command-line-gmail/ HTTP/1.1" 200 4135 "http://mysite.com/blog/traveling-vs-living/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
66.249.74.38 - - [13/Jan/2013:16:23:12 -0600] "GET /blog/tag/spanish-resources/feed/ HTTP/1.1" 200 2262 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /scripts/php_fixxer.pl HTTP/1.1" 302 467 "http://mysite.com/blog/category/rants/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/added-life-list/ HTTP/1.1" 200 3330 "http://mysite.com/blog/osx-universal-binary/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/spanish-resources/ HTTP/1.1" 200 3732 "http://mysite.com/blog/page/2/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/tag/learn-spanish/ HTTP/1.1" 200 3355 "http://mysite.com/blog/page/2/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/dreaming-of-andalusia-oklahoma/ HTTP/1.1" 200 3247 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/tag/spanish-resources/ HTTP/1.1" 200 3411 "http://mysite.com/blog/page/2/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/american-rendezvous-2k10/ HTTP/1.1" 200 3037 "http://mysite.com/blog/category/warriorism/parkour/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/fireflies/ HTTP/1.1" 200 2755 "http://mysite.com/blog/osx-universal-binary/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/category/language/spanish-language/ HTTP/1.1" 200 3414 "http://mysite.com/blog/page/2/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/costa-rica/ HTTP/1.1" 200 3122 "http://mysite.com/blog/os-x-madplay/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/under-construction/ HTTP/1.1" 200 2600 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/tag/snes9x/ HTTP/1.1" 200 4546 "http://mysite.com/blog/category/rants/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/tag/short-tags/ HTTP/1.1" 200 4487 "http://mysite.com/blog/category/rants/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/tag/fixyourdamnwebsite/ HTTP/1.1" 200 4543 "http://mysite.com/blog/category/rants/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/ HTTP/1.1" 200 11637 "http://mysite.com/blog/category/health/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/ HTTP/1.1" 200 11637 "http://mysite.com/blog/category/rants/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/page/3/ HTTP/1.1" 200 28313 "http://mysite.com/blog/page/2/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:19 -0600] "GET /blog/tag/php/ HTTP/1.1" 200 4543 "http://mysite.com/blog/category/rants/" "Mozilla/5.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:23:20 -0600] "GET /blog/tag/personal-development/feed/ HTTP/1.1" 200 2420 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:23:30 -0600] "GET /scripts/twitter-who2follow.user.js HTTP/1.1" 302 411 "http://mysite.com/blog/category/rants/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:31 -0600] "GET /blog/wp-content/uploads/2010/10/goog-xlate3.png HTTP/1.1" 200 29281 "http://mysite.com/blog/page/3/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:31 -0600] "GET /blog/wp-content/uploads/2010/10/mate_art1.png HTTP/1.1" 200 31728 "http://mysite.com/blog/page/3/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:30 -0600] "GET /blog/life-list HTTP/1.1" 301 317 "http://mysite.com/blog/added-life-list/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:30 -0600] "GET /blog/tag/twitter/ HTTP/1.1" 200 2757 "http://mysite.com/blog/category/rants/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:30 -0600] "GET /blog/tag/greasemonkey/ HTTP/1.1" 200 2811 "http://mysite.com/blog/category/rants/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:30 -0600] "GET /blog/remove-who-to-follow/ HTTP/1.1" 200 3074 "http://mysite.com/blog/category/rants/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:30 -0600] "GET /blog/new-word/ HTTP/1.1" 200 3491 "http://mysite.com/blog/command-line-gmail/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:30 -0600] "GET /blog/for-better-or-for-awesome/ HTTP/1.1" 200 3964 "http://mysite.com/blog/dreaming-of-andalusia-oklahoma/" "Mozilla/5.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:30 -0600] "GET /blog/tag/jquery/ HTTP/1.1" 200 2812 "http://mysite.com/blog/category/rants/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:30 -0600] "GET /blog/day-in-the-life/ HTTP/1.1" 200 3153 "http://mysite.com/blog/american-rendezvous-2k10/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:30 -0600] "GET /blog/category/uncategorized/ HTTP/1.1" 200 3573 "http://mysite.com/blog/added-life-list/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:30 -0600] "GET /blog/category/randomness/ HTTP/1.1" 200 6704 "http://mysite.com/blog/dreaming-of-andalusia-oklahoma/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:31 -0600] "GET /blog/tag/mate/ HTTP/1.1" 200 2937 "http://mysite.com/blog/page/3/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:31 -0600] "GET /blog/tag/machine-translation/ HTTP/1.1" 200 2939 "http://mysite.com/blog/page/3/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:31 -0600] "GET /blog/tag/rioplatense-spanish/ HTTP/1.1" 200 2885 "http://mysite.com/blog/page/3/" "Mozilla/5.0 (Windows NT 6.0; WOW64) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
192.114.71.13 - - [13/Jan/2013:16:23:31 -0600] "GET /blog/simple-blogging-tips/ HTTP/1.1" 200 3163 "http://mysite.com/blog/page/3/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:31 -0600] "GET /blog/tag/blogging/ HTTP/1.1" 200 2838 "http://mysite.com/blog/page/3/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:31 -0600] "GET /blog/life-list/ HTTP/1.1" 200 2155 "http://mysite.com/blog/added-life-list/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:31 -0600] "GET /blog/ HTTP/1.1" 200 11637 "http://mysite.com/blog/category/rants/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:31 -0600] "GET /blog/page/4/ HTTP/1.1" 200 11356 "http://mysite.com/blog/page/3/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:41 -0600] "GET /blog/wp-content/uploads/2010/07/grruelkananth1.mp3 HTTP/1.1" 200 28029 "http://mysite.com/blog/new-word/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)"
192.114.71.13 - - [13/Jan/2013:16:23:42 -0600] "GET /blog/page/5/ HTTP/1.1" 200 10576 "http://mysite.com/blog/page/4/" "Mozilla/6.0 (compatible)"
192.114.71.13 - - [13/Jan/2013:16:23:55 -0600] "GET /blog/page/6/ HTTP/1.1" 200 2376 "http://mysite.com/blog/page/5/" "Mozilla/5.0 (compatible)"
66.249.74.38 - - [13/Jan/2013:16:28:15 -0600] "GET /blog/tag/grow-dates-from-seed/feed/ HTTP/1.1" 200 2138 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:28:46 -0600] "GET /blog/tag/grow-plants-from-seeds/feed/ HTTP/1.1" 200 2141 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:28:55 -0600] "GET /blog/tag/life/feed/ HTTP/1.1" 200 3425 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:29:05 -0600] "GET /blog/tag/texas/feed/ HTTP/1.1" 200 3425 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:29:14 -0600] "GET /blog/tag/panama/feed/ HTTP/1.1" 200 1885 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:29:24 -0600] "GET /blog/tag/castle/feed/ HTTP/1.1" 200 2403 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:29:34 -0600] "GET /blog/tag/belief/feed/ HTTP/1.1" 200 2404 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:29:44 -0600] "GET /blog/tag/belgium/feed/ HTTP/1.1" 200 2401 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:29:55 -0600] "GET /blog/tag/bicycle/feed/ HTTP/1.1" 200 3427 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:30:16 -0600] "GET /blog/tag/medellin/feed/ HTTP/1.1" 200 2594 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:30:37 -0600] "GET /blog/tag/colombia/feed/ HTTP/1.1" 200 2596 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:30:59 -0600] "GET /blog/tag/wandering/feed/ HTTP/1.1" 200 3427 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:31:20 -0600] "GET /blog/tag/costa-rica/feed/ HTTP/1.1" 200 2436 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:31:41 -0600] "GET /blog/tag/new-zealand/feed/ HTTP/1.1" 200 3430 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:32:03 -0600] "GET /blog/tag/buenos-aires/feed/ HTTP/1.1" 200 2302 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:32:25 -0600] "GET /blog/tag/cheap-airfare/feed/ HTTP/1.1" 200 2411 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:32:47 -0600] "GET /blog/tag/internet-cafe/feed/ HTTP/1.1" 200 2297 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:16:33:13 -0600] "GET /blog/tag/the-most-beautiful-women-in-the-world/feed/ HTTP/1.1" 200 1802 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
192.114.71.13 - - [13/Jan/2013:16:37:26 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:32 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15312 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:33 -0600] "GET /blog/wp-content/themes/koi-improved/img/dropdown-bg.png HTTP/1.1" 200 7269 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:32 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61486 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:32 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73678 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:33 -0600] "GET /blog/wp-content/themes/koi-improved/img/more.png HTTP/1.1" 200 1254 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:33 -0600] "GET /blog/wp-content/themes/koi-improved/img/nav-rss.png HTTP/1.1" 200 902 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:34 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 531 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:35 -0600] "GET /blog/wp-content/themes/koi-improved/img/reply.png HTTP/1.1" 200 822 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:36 -0600] "GET /blog/wp-content/themes/koi-improved/img/cancel-reply.png HTTP/1.1" 200 588 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:36 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:36 -0600] "GET /blog/wp-content/themes/koi-improved/img/submit-btn.png HTTP/1.1" 200 1388 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:36 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:37 -0600] "GET /blog/wp-content/uploads/2010/10/sbux1.2010oct03.jpg HTTP/1.1" 200 103164 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:37 -0600] "GET /blog/wp-content/uploads/2010/10/morn-crescent1.jpg HTTP/1.1" 200 110350 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:50 -0600] "GET /blog/wp-content/uploads/2010/06/code5.jpg HTTP/1.1" 200 31149 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:51 -0600] "GET /blog/wp-content/uploads/2011/01/prefs31.png HTTP/1.1" 200 85768 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:53 -0600] "GET /blog/wp-content/uploads/2011/01/exitpop2.png HTTP/1.1" 200 48818 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:55 -0600] "GET /blog/wp-includes/images/smilies/icon_smile.gif HTTP/1.1" 200 448 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:56 -0600] "GET /blog/wp-includes/images/smilies/icon_wink.gif HTTP/1.1" 200 444 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:57 -0600] "GET /blog/wp-content/uploads/2010/10/goog-xlate3.png HTTP/1.1" 200 29281 "-" "-"
192.114.71.13 - - [13/Jan/2013:16:37:58 -0600] "GET /blog/wp-content/uploads/2010/10/mate_art1.png HTTP/1.1" 200 31728 "-" "-"
123.125.71.74 - - [13/Jan/2013:16:38:44 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.165 - - [13/Jan/2013:16:39:35 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
65.55.213.243 - - [13/Jan/2013:16:41:22 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.243 - - [13/Jan/2013:16:41:22 -0600] "GET /raw/sitemap.xml.gz HTTP/1.1" 404 399 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
173.212.212.2 - - [13/Jan/2013:16:56:06 -0600] "GET /blog/ HTTP/1.0" 200 40441 "http://mysite.com/blog/" "Mozilla/3.01 (compatible; AmigaVoyager/2.95; AmigaOS/MC680x0)"
65.55.213.67 - - [13/Jan/2013:17:04:14 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:17:04:14 -0600] "GET /blog HTTP/1.1" 301 448 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:17:04:16 -0600] "GET /blog/ HTTP/1.1" 200 11656 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:17:04:18 -0600] "GET /blog/about/ HTTP/1.1" 200 2641 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:17:04:23 -0600] "GET /blog/category/tech/ HTTP/1.1" 200 27468 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:17:04:27 -0600] "GET /blog/category/freedom/ HTTP/1.1" 200 21354 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:28 -0600] "GET /blog/tag/purple-carrots/ HTTP/1.1" 200 2751 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:30 -0600] "GET /blog/spicnspan/ HTTP/1.1" 200 4758 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:33 -0600] "GET /blog/page/2/ HTTP/1.1" 200 15276 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:36 -0600] "GET /blog/black-carrots/ HTTP/1.1" 200 3194 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:41 -0600] "GET /blog/category/tech/information-security/ HTTP/1.1" 200 3867 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:44 -0600] "GET /blog/analysis-chinese-phishing-scam/ HTTP/1.1" 200 4122 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:47 -0600] "GET /blog/tag/purple-potatoes/ HTTP/1.1" 200 2634 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:48 -0600] "GET /blog/tag/beet-soup/ HTTP/1.1" 200 2630 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:50 -0600] "GET /blog/rare-ish-foods/ HTTP/1.1" 200 2959 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:52 -0600] "GET /blog/tag/carrot-soup/ HTTP/1.1" 200 2744 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:54 -0600] "GET /blog/tag/yellow-carrots/ HTTP/1.1" 200 2753 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:56 -0600] "GET /blog/purple-carrot/ HTTP/1.1" 200 3032 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:04:58 -0600] "GET /blog/tag/terminal/ HTTP/1.1" 200 2683 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:00 -0600] "GET /blog/tag/osx-terminal/ HTTP/1.1" 200 2683 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:02 -0600] "GET /blog/tag/osx-lion/ HTTP/1.1" 200 2684 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:04 -0600] "GET /blog/tag/osx-command-line/ HTTP/1.1" 200 2682 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:07 -0600] "GET /blog/tag/osx-2/ HTTP/1.1" 200 6250 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:09 -0600] "GET /blog/category/tech/osx/ HTTP/1.1" 200 7250 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:12 -0600] "GET /blog/osx-change-root-shell/ HTTP/1.1" 200 3479 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:14 -0600] "GET /blog/tag/firefox-speed-dial/ HTTP/1.1" 200 2565 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:17:05:15 -0600] "GET /blog/tag/firefox-13-speed-dial/ HTTP/1.1" 200 2570 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:17:05:17 -0600] "GET /blog/tag/firefox-13/ HTTP/1.1" 200 2567 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:17:05:19 -0600] "GET /blog/tag/ff13/ HTTP/1.1" 200 2566 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:17:05:21 -0600] "GET /blog/tag/disable-firefox-speed-dial/ HTTP/1.1" 200 2565 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:17:05:23 -0600] "GET /blog/category/adventuring/ HTTP/1.1" 200 7633 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:17:05:25 -0600] "GET /blog/disable-speed-dial-feature-in-firefox-13/ HTTP/1.1" 200 3781 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.67 - - [13/Jan/2013:17:05:27 -0600] "GET /blog/sailing/ HTTP/1.1" 200 3753 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:29 -0600] "GET /blog/thailand-september-2012/ HTTP/1.1" 200 4556 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:31 -0600] "GET /blog/category/travel/ HTTP/1.1" 200 14829 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:33 -0600] "GET /blog/category/horticulture/ HTTP/1.1" 200 6302 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:35 -0600] "GET /blog/category/food/ HTTP/1.1" 200 5884 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:36 -0600] "GET /blog/category/tech/linux/ HTTP/1.1" 200 5140 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:38 -0600] "GET /blog/almost-christmas/ HTTP/1.1" 200 5659 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:41 -0600] "GET /blog/remove-ubuntudebian-version-from-sshd-server-string/ HTTP/1.1" 200 3333 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:42 -0600] "GET /blog/feed/ HTTP/1.1" 200 10890 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [13/Jan/2013:17:05:44 -0600] "GET /blog/life-list/ HTTP/1.1" 200 2174 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
202.46.52.88 - - [13/Jan/2013:17:12:45 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
119.63.193.132 - - [13/Jan/2013:17:14:02 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
91.121.243.254 - - [13/Jan/2013:17:38:45 -0600] "GET / HTTP/1.0" 302 429 "http://mysite.com/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Win 9x 4.90)"
91.121.243.254 - - [13/Jan/2013:17:38:47 -0600] "GET / HTTP/1.1" 302 410 "-" "start.exe"
91.121.243.254 - - [13/Jan/2013:17:38:47 -0600] "GET /blog/ HTTP/1.1" 200 40542 "-" "start.exe"
91.121.243.254 - - [13/Jan/2013:17:38:49 -0600] "GET /index.php HTTP/1.0" 302 429 "http://mysite.com/index.php" "Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Win 9x 4.90)"
91.121.243.254 - - [13/Jan/2013:17:38:50 -0600] "GET /blog/ HTTP/1.0" 200 40441 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Win 9x 4.90)"
61.135.249.46 - - [13/Jan/2013:17:47:57 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.46 - - [13/Jan/2013:17:47:57 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.46 - - [13/Jan/2013:17:47:58 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
66.249.74.38 - - [13/Jan/2013:18:07:09 -0600] "GET /blog/sailing/ HTTP/1.1" 200 3764 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:18:21:45 -0600] "GET /blog/wp-content/themes/thesis_184/lib/images/submit-bg.gif HTTP/1.1" 404 11848 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
183.250.10.148 - - [13/Jan/2013:18:24:16 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1;)"
208.115.111.70 - - [13/Jan/2013:18:32:11 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
173.199.117.235 - - [13/Jan/2013:18:33:45 -0600] "GET /blog/spicnspan/ HTTP/1.1" 200 4739 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
91.223.75.117 - - [13/Jan/2013:18:35:58 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://soft-d1z.ru/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.2; Win64; AMD64)"
91.223.75.117 - - [13/Jan/2013:18:35:59 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://soft-d1z.ru/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.2; Win64; AMD64)"
119.63.193.194 - - [13/Jan/2013:18:40:09 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
50.56.187.112 - - [13/Jan/2013:18:40:14 -0600] "GET / HTTP/1.1" 403 427 "-" "Mozilla/5.0 (Windows NT 6.1; rv:10.0) Gecko/20100101 Firefox/10.0"
83.143.140.227 - - [13/Jan/2013:18:46:21 -0600] "GET / HTTP/1.1" 302 467 "-" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.34 (KHTML, like Gecko) Qt/4.8.1 Safari/534.34"
83.143.140.227 - - [13/Jan/2013:18:46:21 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.34 (KHTML, like Gecko) Qt/4.8.1 Safari/534.34"
83.143.140.227 - - [13/Jan/2013:18:46:22 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.34 (KHTML, like Gecko) Qt/4.8.1 Safari/534.34"
83.143.140.227 - - [13/Jan/2013:18:46:22 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.34 (KHTML, like Gecko) Qt/4.8.1 Safari/534.34"
83.143.140.227 - - [13/Jan/2013:18:46:22 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.34 (KHTML, like Gecko) Qt/4.8.1 Safari/534.34"
83.143.140.227 - - [13/Jan/2013:18:46:22 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.34 (KHTML, like Gecko) Qt/4.8.1 Safari/534.34"
83.143.140.227 - - [13/Jan/2013:18:46:23 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.34 (KHTML, like Gecko) Qt/4.8.1 Safari/534.34"
83.143.140.227 - - [13/Jan/2013:18:46:23 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.34 (KHTML, like Gecko) Qt/4.8.1 Safari/534.34"
83.143.140.227 - - [13/Jan/2013:18:46:23 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.34 (KHTML, like Gecko) Qt/4.8.1 Safari/534.34"
83.143.140.227 - - [13/Jan/2013:18:46:23 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.34 (KHTML, like Gecko) Qt/4.8.1 Safari/534.34"
83.143.140.227 - - [13/Jan/2013:18:46:23 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.34 (KHTML, like Gecko) Qt/4.8.1 Safari/534.34"
83.143.140.227 - - [13/Jan/2013:18:46:23 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.34 (KHTML, like Gecko) Qt/4.8.1 Safari/534.34"
178.154.163.29 - - [13/Jan/2013:18:49:58 -0600] "GET /blog/remove-ubuntudebian-version-from-sshd-server-string/ HTTP/1.1" 200 3344 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
173.199.117.235 - - [13/Jan/2013:19:20:36 -0600] "GET /blog/tag/osx-2/ HTTP/1.1" 200 6231 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
180.76.5.197 - - [13/Jan/2013:19:22:02 -0600] "GET /blog/tag/panama/ HTTP/1.1" 200 2966 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
208.115.111.70 - - [13/Jan/2013:19:27:12 -0600] "GET /blog/tag/wandering/ HTTP/1.1" 200 11993 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.111.70 - - [13/Jan/2013:19:27:15 -0600] "GET /blog/tag/personal-development/feed/ HTTP/1.1" 200 4887 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.111.70 - - [13/Jan/2013:19:27:17 -0600] "GET /blog/category/health/ HTTP/1.1" 200 14656 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
220.181.108.176 - - [13/Jan/2013:19:44:07 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
94.23.250.149 - - [13/Jan/2013:19:53:44 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
5.135.182.150 - - [13/Jan/2013:19:53:44 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
66.249.82.233 - - [13/Jan/2013:19:55:49 -0600] "GET /blog/tag/purple-potatoes/ HTTP/1.1" 200 2671 "http://www.google.com/search" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.4 (KHTML, like Gecko; Google Web Preview) Chrome/22.0.1229 Safari/537.4"
66.249.82.233 - - [13/Jan/2013:19:55:50 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/tag/purple-potatoes/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.4 (KHTML, like Gecko; Google Web Preview) Chrome/22.0.1229 Safari/537.4"
66.249.82.233 - - [13/Jan/2013:19:55:50 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/tag/purple-potatoes/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.4 (KHTML, like Gecko; Google Web Preview) Chrome/22.0.1229 Safari/537.4"
66.249.82.233 - - [13/Jan/2013:19:55:50 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/tag/purple-potatoes/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.4 (KHTML, like Gecko; Google Web Preview) Chrome/22.0.1229 Safari/537.4"
66.249.82.233 - - [13/Jan/2013:19:55:50 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/tag/purple-potatoes/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.4 (KHTML, like Gecko; Google Web Preview) Chrome/22.0.1229 Safari/537.4"
66.249.82.233 - - [13/Jan/2013:19:55:50 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/tag/purple-potatoes/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.4 (KHTML, like Gecko; Google Web Preview) Chrome/22.0.1229 Safari/537.4"
66.249.82.233 - - [13/Jan/2013:19:55:50 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/tag/purple-potatoes/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.4 (KHTML, like Gecko; Google Web Preview) Chrome/22.0.1229 Safari/537.4"
66.249.82.233 - - [13/Jan/2013:19:55:50 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/tag/purple-potatoes/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.4 (KHTML, like Gecko; Google Web Preview) Chrome/22.0.1229 Safari/537.4"
66.249.82.233 - - [13/Jan/2013:19:55:51 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15312 "http://mysite.com/blog/tag/purple-potatoes/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.4 (KHTML, like Gecko; Google Web Preview) Chrome/22.0.1229 Safari/537.4"
66.249.82.233 - - [13/Jan/2013:19:55:50 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/tag/purple-potatoes/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.4 (KHTML, like Gecko; Google Web Preview) Chrome/22.0.1229 Safari/537.4"
173.199.117.235 - - [13/Jan/2013:19:58:28 -0600] "GET /blog/osx-change-root-shell/ HTTP/1.1" 200 3434 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
66.249.74.38 - - [13/Jan/2013:20:10:25 -0600] "GET /blog/remove-who-to-follow/ HTTP/1.1" 200 3074 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
207.241.229.237 - - [13/Jan/2013:20:12:24 -0600] "GET /robots.txt HTTP/1.1" 200 291 "-" "ia_archiver(OS-Wayback)"
207.241.226.101 - - [13/Jan/2013:20:12:25 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "ia_archiver(OS-Wayback)"
209.85.238.38 - - [13/Jan/2013:20:16:46 -0600] "GET /blog/life-list/ HTTP/1.1" 200 2211 "-" "DoCoMo/2.0 N905i(c100;TB;W24H16) (compatible; Googlebot-Mobile/2.1; +http://www.google.com/bot.html)"
96.54.106.56 - - [13/Jan/2013:20:28:13 -0600] "GET / HTTP/1.1" 302 467 "http://www.google.com.au/imgres?q=purple+carrot+seeds+for+sale&hl=en&tbo=d&biw=965&bih=650&tbm=isch&tbnid=ZqmRcqqpERFNYM:&imgrefurl=http://mysite.com/&docid=m6D6Q7kwINn5CM&imgurl=http://media.mysite.com/blog/wp-content/uploads/2012/01/purple_carrot1.jpg&w=747&h=500&ei=x2zzUPqbN5CxigLdw4Bo&zoom=1&iact=hc&vpx=4&vpy=255&dur=2403&hovh=184&hovw=275&tx=118&ty=115&sig=106593249701650091896&page=3&tbnh=137&tbnw=219&start=40&ndsp=22&ved=1t:429,r:45,s:0,i:219" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2"
96.54.106.56 - - [13/Jan/2013:20:28:14 -0600] "GET /blog/ HTTP/1.1" 200 11692 "http://www.google.com.au/imgres?q=purple+carrot+seeds+for+sale&hl=en&tbo=d&biw=965&bih=650&tbm=isch&tbnid=ZqmRcqqpERFNYM:&imgrefurl=http://mysite.com/&docid=m6D6Q7kwINn5CM&imgurl=http://media.mysite.com/blog/wp-content/uploads/2012/01/purple_carrot1.jpg&w=747&h=500&ei=x2zzUPqbN5CxigLdw4Bo&zoom=1&iact=hc&vpx=4&vpy=255&dur=2403&hovh=184&hovw=275&tx=118&ty=115&sig=106593249701650091896&page=3&tbnh=137&tbnw=219&start=40&ndsp=22&ved=1t:429,r:45,s:0,i:219" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2"
96.54.106.56 - - [13/Jan/2013:20:28:14 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2"
96.54.106.56 - - [13/Jan/2013:20:28:14 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4123 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2"
96.54.106.56 - - [13/Jan/2013:20:28:14 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2"
96.54.106.56 - - [13/Jan/2013:20:28:14 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2"
96.54.106.56 - - [13/Jan/2013:20:28:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2"
96.54.106.56 - - [13/Jan/2013:20:28:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2"
96.54.106.56 - - [13/Jan/2013:20:28:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2"
96.54.106.56 - - [13/Jan/2013:20:28:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2"
96.54.106.56 - - [13/Jan/2013:20:28:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2"
96.54.106.56 - - [13/Jan/2013:20:28:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2"
173.199.117.235 - - [13/Jan/2013:20:29:08 -0600] "GET /blog/tag/snes9x/ HTTP/1.1" 200 4490 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
176.61.139.128 - - [13/Jan/2013:20:39:51 -0600] "GET http://www.yahoo.com/ HTTP/1.1" 403 370 "-" "Mozilla/4.06 [en] (WinNT; I)"
123.125.71.99 - - [13/Jan/2013:20:40:07 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.165 - - [13/Jan/2013:20:41:01 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
173.199.117.235 - - [13/Jan/2013:20:43:21 -0600] "GET /blog/tag/madplay/ HTTP/1.1" 200 4029 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
123.30.175.93 - - [13/Jan/2013:20:53:16 -0600] "GET /robots.txt HTTP/1.0" 200 335 "-" "coccoc/1.0 (http://help.coccoc.vn/)"
123.30.175.92 - - [13/Jan/2013:20:53:17 -0600] "GET / HTTP/1.0" 302 430 "-" "coccoc/1.0 (http://help.coccoc.vn/)"
123.30.175.91 - - [13/Jan/2013:20:58:36 -0600] "GET /blog/ HTTP/1.0" 200 11656 "-" "coccoc/1.0 (http://help.coccoc.vn/)"
216.96.86.26 - - [13/Jan/2013:21:05:45 -0600] "-" 408 0 "-" "-"
123.125.71.106 - - [13/Jan/2013:21:11:16 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
203.84.155.22 - - [13/Jan/2013:21:39:45 -0600] "GET /blog/cpan-changing-permissions-on-osx/ HTTP/1.1" 200 4308 "http://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=3&ved=0CEIQFjAC&url=http%3A%2F%2Fmysite.com%2Fblog%2Fcpan-changing-permissions-on-osx%2F&ei=5X3zUK_9GsSHlAXkqIDABQ&usg=AFQjCNE06zD3u0X0IbpLUs0dTCCnv34RXQ&sig2=aE6qE8ZyS5jz3okLXQ-Sjg&bvm=bv.1357700187,d.dGI&cad=rja" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:46 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:46 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:46 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:46 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 746 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:46 -0600] "GET /blog/wp-content/uploads/2010/06/code5.jpg HTTP/1.1" 200 31149 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:46 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:47 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:47 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:47 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:47 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:47 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:47 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:47 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:47 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:47 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
203.84.155.22 - - [13/Jan/2013:21:39:48 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
123.125.71.101 - - [13/Jan/2013:21:40:11 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.158 - - [13/Jan/2013:21:41:06 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
123.125.71.101 - - [13/Jan/2013:21:56:06 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
66.249.74.38 - - [13/Jan/2013:22:03:33 -0600] "GET /blog/tag/tokyo/feed/ HTTP/1.1" 200 2138 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [13/Jan/2013:22:03:34 -0600] "GET /blog/tag/japan/feed/ HTTP/1.1" 200 2136 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
106.187.97.211 - - [13/Jan/2013:22:15:30 -0600] "POST /blog/wp-cron.php?doing_wp_cron=1358136930.1687750816345214843750 HTTP/1.0" 200 203 "-" "WordPress/3.5; http://mysite.com/blog"
66.249.74.38 - - [13/Jan/2013:22:15:30 -0600] "GET /blog/tag/beet-soup/ HTTP/1.1" 200 2667 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
108.166.87.63 - - [13/Jan/2013:22:17:06 -0600] "GET /blog/feed/ HTTP/1.1" 304 166 "-" "Opera/7.60 (Windows NT 5.2; U) [en] (IBM EVV/3.0/EAK01AG9/LE)"
61.135.248.191 - - [13/Jan/2013:22:18:09 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.191 - - [13/Jan/2013:22:18:10 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.191 - - [13/Jan/2013:22:18:10 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
173.199.117.235 - - [13/Jan/2013:22:28:33 -0600] "GET /blog/about/ HTTP/1.1" 200 2622 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
208.115.111.70 - - [13/Jan/2013:22:34:25 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
123.125.71.86 - - [13/Jan/2013:22:39:31 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.141 - - [13/Jan/2013:22:40:26 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
202.46.54.110 - - [13/Jan/2013:22:41:02 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
173.199.117.235 - - [13/Jan/2013:22:41:04 -0600] "GET /blog/category/portfolio/ HTTP/1.1" 200 5544 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
119.63.193.194 - - [13/Jan/2013:22:41:08 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
119.247.227.238 - - [13/Jan/2013:22:44:16 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
109.120.157.179 - - [13/Jan/2013:22:47:13 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://www.plasticsurgeon.com.ua/" "Mozilla/5.0 (compatible; Add Catalog/2.1;)"
109.120.157.179 - - [13/Jan/2013:22:47:14 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://www.plasticsurgeon.com.ua/" "Mozilla/5.0 (compatible; Add Catalog/2.1;)"
180.76.5.162 - - [13/Jan/2013:22:56:54 -0600] "GET /blog/tag/goal-setting/ HTTP/1.1" 200 4772 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
24.113.221.2 - - [13/Jan/2013:23:05:16 -0600] "GET /blog/wp-content/uploads/2011/01/prefs31.png HTTP/1.1" 200 85768 "http://speichsoledad.github.com/close-firefox-popup-box.html" "Mozilla/5.0 (Windows NT 6.0; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0"
176.61.139.128 - - [13/Jan/2013:23:11:01 -0600] "GET http://37.28.156.211/sprawdza.php HTTP/1.1" 404 434 "-" "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)"
70.45.211.154 - - [13/Jan/2013:23:18:43 -0600] "GET /scripts/twitter-who2follow.user.js HTTP/1.1" 302 467 "-" "Mozilla/5.0 (Windows NT 6.1; rv:18.0) Gecko/20100101 Firefox/18.0"
70.45.211.154 - - [13/Jan/2013:23:18:43 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Windows NT 6.1; rv:18.0) Gecko/20100101 Firefox/18.0"
208.115.111.70 - - [13/Jan/2013:23:27:55 -0600] "GET /blog/category/rants/ HTTP/1.1" 200 18127 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
173.199.117.235 - - [13/Jan/2013:23:36:28 -0600] "GET /blog/category/language/ HTTP/1.1" 200 5922 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
119.247.227.238 - - [13/Jan/2013:23:37:05 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
123.125.71.104 - - [13/Jan/2013:23:38:51 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.79 - - [13/Jan/2013:23:39:43 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
189.74.166.130 - - [13/Jan/2013:23:44:12 -0600] "GET /blog/disable-speed-dial-feature-in-firefox-13/ HTTP/1.1" 200 11844 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
189.74.166.130 - - [13/Jan/2013:23:44:13 -0600] "POST /blog/wp-comments-post.php HTTP/1.0" 500 4437 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
178.154.163.29 - - [13/Jan/2013:23:44:59 -0600] "GET /robots.txt HTTP/1.1" 200 328 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
178.137.129.249 - - [13/Jan/2013:23:47:30 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://pr-cy.org/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows XP)"
178.137.129.249 - - [13/Jan/2013:23:47:31 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://pr-cy.org/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows XP)"
123.151.148.207 - - [14/Jan/2013:00:19:02 -0600] "GET / HTTP/1.1" 302 467 "-" "Sosospider+(+http://help.soso.com/webspider.htm)"
123.151.148.207 - - [14/Jan/2013:00:19:03 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Sosospider+(+http://help.soso.com/webspider.htm)"
123.151.148.207 - - [14/Jan/2013:00:19:12 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/" "Sosospider+(+http://help.soso.com/webspider.htm)"
37.1.207.22 - - [14/Jan/2013:00:24:41 -0600] "GET /blog/wp-content/themes/metamorphosis/timthumb.php HTTP/1.1" 404 40649 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.77 Safari/535.7"
208.115.113.86 - - [14/Jan/2013:00:38:13 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
123.125.71.103 - - [14/Jan/2013:00:38:36 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.142 - - [14/Jan/2013:00:39:27 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
61.135.248.185 - - [14/Jan/2013:00:45:39 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.185 - - [14/Jan/2013:00:45:40 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.185 - - [14/Jan/2013:00:45:40 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
119.63.193.196 - - [14/Jan/2013:00:51:30 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
65.111.177.188 - - [14/Jan/2013:00:54:37 -0600] "GET / HTTP/1.1" 403 426 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [14/Jan/2013:00:54:38 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [14/Jan/2013:00:54:40 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [14/Jan/2013:00:54:40 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
178.255.215.67 - - [14/Jan/2013:00:55:16 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "Mozilla/5.0 (compatible; Exabot/3.0; +http://www.exabot.com/go/robot)"
178.255.215.67 - - [14/Jan/2013:00:55:17 -0600] "GET /blog/xmlrpc.php?rsd HTTP/1.1" 200 486 "-" "Mozilla/5.0 (compatible; Exabot/3.0; +http://www.exabot.com/go/robot)"
173.199.117.235 - - [14/Jan/2013:01:11:16 -0600] "GET /blog/category/tech/ HTTP/1.1" 200 27449 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
66.249.74.38 - - [14/Jan/2013:01:18:12 -0600] "GET /blog/tag/osx-terminal/ HTTP/1.1" 200 2720 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
208.115.113.86 - - [14/Jan/2013:01:34:00 -0600] "GET /blog/tag/firefox/feed/ HTTP/1.1" 200 3423 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
5.135.186.48 - - [14/Jan/2013:01:44:49 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
94.23.14.147 - - [14/Jan/2013:01:44:49 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
5.135.186.47 - - [14/Jan/2013:01:44:49 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
94.23.62.47 - - [14/Jan/2013:01:44:50 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
91.121.204.98 - - [14/Jan/2013:01:44:50 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
94.23.4.106 - - [14/Jan/2013:01:44:50 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
91.121.198.168 - - [14/Jan/2013:01:44:50 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
119.247.227.238 - - [14/Jan/2013:01:45:31 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
180.153.236.195 - - [14/Jan/2013:02:06:30 -0600] "GET / HTTP/1.1" 302 467 "http://mysite.com/" "Mozilla/5.0 (Windows; U; Windows NT 5.1; zh-CN; rv:1.8.0.11) Gecko/20070312 Firefox/1.5.0.11; 360Spider"
180.153.236.190 - - [14/Jan/2013:02:06:31 -0600] "GET /blog/ HTTP/1.1" 200 11693 "http://mysite.com/blog/" "Mozilla/5.0 (Windows; U; Windows NT 5.1; zh-CN; rv:1.8.0.11) Gecko/20070312 Firefox/1.5.0.11; 360Spider"
173.199.120.155 - - [14/Jan/2013:02:09:23 -0600] "GET /blog/category/travel/ HTTP/1.1" 200 14810 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
180.76.5.59 - - [14/Jan/2013:02:17:52 -0600] "GET /blog/tag/belief/feed/ HTTP/1.1" 200 2367 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
208.115.111.70 - - [14/Jan/2013:02:32:07 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
216.244.78.146 - - [14/Jan/2013:02:35:33 -0600] "GET /blog/almost-christmas/ HTTP/1.1" 200 14916 "-" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) )"
119.247.227.238 - - [14/Jan/2013:02:35:45 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
113.91.66.22 - - [14/Jan/2013:02:35:47 -0600] "POST /blog/wp-comments-post.php HTTP/1.1" 500 4462 "http://mysite.com/blog/almost-christmas/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; TencentTraveler ; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 2.0.50727 ; .NET CLR 4.0.30319)"
123.125.71.88 - - [14/Jan/2013:02:38:41 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.152 - - [14/Jan/2013:02:39:34 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
66.249.74.38 - - [14/Jan/2013:02:46:34 -0600] "GET /blog/?cal_d=yjstbkmzxrzlkbun HTTP/1.1" 200 11714 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [14/Jan/2013:02:54:47 -0600] "GET /blog/osx-change-root-shell/ HTTP/1.1" 200 3490 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [14/Jan/2013:02:58:35 -0600] "GET /blog/remove-ubuntudebian-version-from-sshd-server-string/ HTTP/1.1" 200 3344 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
61.135.249.78 - - [14/Jan/2013:03:02:40 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.78 - - [14/Jan/2013:03:02:40 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.78 - - [14/Jan/2013:03:02:40 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
217.140.96.21 - - [14/Jan/2013:03:14:27 -0600] "GET /blog/osx-universal-binary/ HTTP/1.1" 200 3560 "http://www.google.co.uk/url?sa=t&rct=j&q=makefile%20universal%20mac&source=web&cd=1&ved=0CDIQFjAA&url=http%3A%2F%2Fmysite.com%2Fblog%2Fosx-universal-binary%2F&ei=rJ3tUMi2AZSp0AXZk4G4Aw&usg=AFQjCNEmxEwV7XEmWu2upHivYoSgEKgAeA&bvm=bv.1357316858,d.d2k" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_5) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
217.140.96.21 - - [14/Jan/2013:03:14:29 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 304 194 "http://mysite.com/blog/osx-universal-binary/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_5) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
217.140.96.21 - - [14/Jan/2013:03:14:29 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/osx-universal-binary/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_5) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
217.140.96.21 - - [14/Jan/2013:03:14:33 -0600] "GET /favicon.ico HTTP/1.1" 302 467 "http://mysite.com/blog/osx-universal-binary/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_5) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
217.140.96.21 - - [14/Jan/2013:03:14:33 -0600] "GET /blog/ HTTP/1.1" 200 11692 "http://mysite.com/blog/osx-universal-binary/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_5) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
202.46.55.180 - - [14/Jan/2013:03:15:51 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
119.63.193.194 - - [14/Jan/2013:03:17:10 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
65.55.24.220 - - [14/Jan/2013:03:48:51 -0600] "GET /robots.txt HTTP/1.1" 200 328 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
65.55.24.220 - - [14/Jan/2013:03:50:35 -0600] "GET /blog/how-to-break-out-of-an-exit-popup-in-firefox/ HTTP/1.1" 200 3046 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
119.247.227.238 - - [14/Jan/2013:03:53:21 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
123.125.71.78 - - [14/Jan/2013:03:54:33 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.160 - - [14/Jan/2013:03:55:27 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
106.187.97.211 - - [14/Jan/2013:03:59:05 -0600] "POST /blog/wp-cron.php?doing_wp_cron=1358157545.8849580287933349609375 HTTP/1.0" 200 203 "-" "WordPress/3.5; http://mysite.com/blog"
66.249.74.38 - - [14/Jan/2013:03:59:05 -0600] "GET /blog/remove-ubuntudebian-version-from-sshd-server-string/ HTTP/1.1" 200 3344 "-" "SAMSUNG-SGH-E250/1.0 Profile/MIDP-2.0 Configuration/CLDC-1.1 UP.Browser/6.2.3.3.c.1.101 (GUI) MMP/2.0 (compatible; Googlebot-Mobile/2.1; +http://www.google.com/bot.html)"
65.55.24.245 - - [14/Jan/2013:04:10:28 -0600] "GET /blog/category/tech/osx/ HTTP/1.1" 200 7287 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
65.55.24.245 - - [14/Jan/2013:04:10:31 -0600] "GET /blog/disable-speed-dial-feature-in-firefox-13/ HTTP/1.1" 200 3792 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
65.55.24.245 - - [14/Jan/2013:04:10:34 -0600] "GET /blog/osx-change-root-shell/ HTTP/1.1" 200 3490 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.35.91 - - [14/Jan/2013:04:10:34 -0600] "GET /blog/category/food/ HTTP/1.1" 200 5921 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
65.55.24.245 - - [14/Jan/2013:04:10:35 -0600] "GET /blog/osx-change-root-shell HTTP/1.1" 301 329 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
208.80.194.29 - - [14/Jan/2013:04:10:44 -0600] "GET /blog HTTP/1.0" 301 465 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.91 Safari/534.30"
157.55.35.91 - - [14/Jan/2013:04:10:46 -0600] "GET /blog/category/travel/ HTTP/1.1" 200 14866 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
65.55.24.220 - - [14/Jan/2013:04:11:34 -0600] "GET /blog/almost-christmas/ HTTP/1.1" 200 5670 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
65.55.24.220 - - [14/Jan/2013:04:11:44 -0600] "GET /blog/black-carrots/ HTTP/1.1" 200 3205 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
65.55.24.220 - - [14/Jan/2013:04:12:32 -0600] "GET /blog/facebook-account-deletion-link/ HTTP/1.1" 200 2743 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
65.55.24.220 - - [14/Jan/2013:04:12:47 -0600] "GET /blog/how-to-break-out-of-an-exit-popup-in-firefox/ HTTP/1.1" 200 3046 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.35.91 - - [14/Jan/2013:04:14:33 -0600] "GET /blog/lost-in-translation/ HTTP/1.1" 200 3218 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.35.91 - - [14/Jan/2013:04:14:47 -0600] "GET /blog/spicnspan/ HTTP/1.1" 200 4795 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
66.249.74.38 - - [14/Jan/2013:04:15:18 -0600] "GET /blog/page/2/?view=month&cal_d=1&cal_m=8&cal_y=1983&course=1 HTTP/1.1" 200 15352 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
208.80.194.29 - - [14/Jan/2013:04:17:18 -0600] "GET /blog/ HTTP/1.0" 200 40441 "-" "Mozilla/5.0 (Windows NT 5.1) Gecko/20100101 Firefox/5.0"
119.247.227.238 - - [14/Jan/2013:04:18:20 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
173.199.120.155 - - [14/Jan/2013:04:18:31 -0600] "GET /blog/tag/life/ HTTP/1.1" 200 4523 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
157.55.35.91 - - [14/Jan/2013:04:18:39 -0600] "GET /blog/tag/perl-2/ HTTP/1.1" 200 7408 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.35.91 - - [14/Jan/2013:04:21:41 -0600] "GET /blog/medellin-colombia HTTP/1.1" 301 325 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.33.29 - - [14/Jan/2013:04:26:24 -0600] "GET /blog/fireflies HTTP/1.1" 301 317 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.33.29 - - [14/Jan/2013:04:26:31 -0600] "GET /blog/fireflies/ HTTP/1.1" 200 2755 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.33.111 - - [14/Jan/2013:04:27:37 -0600] "GET /blog/analysis-chinese-phishing-scam/ HTTP/1.1" 200 4133 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.34.35 - - [14/Jan/2013:04:35:38 -0600] "GET /blog/category/tech/linux/ HTTP/1.1" 200 5177 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.34.35 - - [14/Jan/2013:04:39:30 -0600] "GET /blog/convert-m4a-files-to-mp3-format-with-tags/ HTTP/1.1" 200 4294 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.34.35 - - [14/Jan/2013:04:39:38 -0600] "GET /blog/cpan-changing-permissions-on-osx/ HTTP/1.1" 200 4308 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.34.35 - - [14/Jan/2013:04:39:44 -0600] "GET /blog/feed/ HTTP/1.1" 200 10927 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
119.63.193.195 - - [14/Jan/2013:04:40:04 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
157.55.33.248 - - [14/Jan/2013:04:40:36 -0600] "GET /blog/category/adventuring/ HTTP/1.1" 200 7670 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
123.125.71.108 - - [14/Jan/2013:04:41:05 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
157.55.34.35 - - [14/Jan/2013:04:41:31 -0600] "GET /blog/tag/osx-2/ HTTP/1.1" 200 6287 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.34.35 - - [14/Jan/2013:04:41:38 -0600] "GET /blog/thailand-september-2012/ HTTP/1.1" 200 4567 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.34.35 - - [14/Jan/2013:04:41:44 -0600] "GET /blog/feed HTTP/1.1" 301 385 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
220.181.108.148 - - [14/Jan/2013:04:42:00 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
157.55.33.248 - - [14/Jan/2013:04:42:41 -0600] "GET /blog/purple-carrot/ HTTP/1.1" 200 3043 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.33.248 - - [14/Jan/2013:04:49:36 -0600] "GET /blog/remove-ubuntudebian-version-from-sshd-server-string/ HTTP/1.1" 200 3344 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.33.248 - - [14/Jan/2013:04:59:23 -0600] "GET /blog/sailing/ HTTP/1.1" 200 3764 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
178.154.163.29 - - [14/Jan/2013:05:01:22 -0600] "GET /blog/remove-ubuntudebian-version-from-sshd-server-string/ HTTP/1.1" 200 3344 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
187.6.113.125 - - [14/Jan/2013:05:06:16 -0600] "GET /blog/panama/ HTTP/1.1" 200 8692 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
176.34.138.250 - - [14/Jan/2013:05:10:14 -0600] "GET / HTTP/1.1" 302 492 "-" "-"
176.34.138.250 - - [14/Jan/2013:05:11:02 -0600] "GET / HTTP/1.1" 302 467 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)"
176.34.138.250 - - [14/Jan/2013:05:11:02 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)"
176.34.138.250 - - [14/Jan/2013:05:11:03 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)"
176.34.138.250 - - [14/Jan/2013:05:11:03 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)"
176.34.138.250 - - [14/Jan/2013:05:11:03 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)"
176.34.138.250 - - [14/Jan/2013:05:11:03 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)"
176.34.138.250 - - [14/Jan/2013:05:11:04 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)"
176.34.138.250 - - [14/Jan/2013:05:11:04 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)"
176.34.138.250 - - [14/Jan/2013:05:11:04 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)"
176.34.138.250 - - [14/Jan/2013:05:11:04 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)"
176.34.138.250 - - [14/Jan/2013:05:11:05 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)"
176.34.138.250 - - [14/Jan/2013:05:11:05 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64; Trident/5.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E)"
123.125.71.86 - - [14/Jan/2013:05:38:09 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
66.249.74.38 - - [14/Jan/2013:05:38:54 -0600] "GET /blog/page/2/?view=month&cal_d=1&cal_m=3&cal_y=1987&course=1 HTTP/1.1" 200 15352 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
220.181.108.180 - - [14/Jan/2013:05:38:59 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
180.76.6.29 - - [14/Jan/2013:05:39:25 -0600] "GET /blog/lost-in-translation/ HTTP/1.1" 200 3181 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
61.135.248.187 - - [14/Jan/2013:05:44:56 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.187 - - [14/Jan/2013:05:44:56 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.187 - - [14/Jan/2013:05:44:57 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
119.247.227.238 - - [14/Jan/2013:05:47:57 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
82.136.233.171 - - [14/Jan/2013:06:07:10 -0600] "GET /blog/black-carrots/ HTTP/1.1" 200 3205 "http://www.google.nl/url?sa=t&rct=j&q=&esrc=s&source=web&cd=3&sqi=2&ved=0CEEQFjAC&url=http%3A%2F%2Fmysite.com%2Fblog%2Fblack-carrots%2F&ei=xvTzUL2FDIGp0QWBsYCwCw&usg=AFQjCNEEQOLEy6aLgJ-dYTCVydcr0EeNkQ&sig2=xHhTvTmvCLPZVTjLCy1m0w&bvm=bv.1357700187,d.d2k" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:11 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:11 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:11 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:11 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:11 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:12 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:12 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:12 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:12 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:12 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:12 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:14 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:14 -0600] "GET /blog/analysis-chinese-phishing-scam/ HTTP/1.1" 200 4132 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
82.136.233.171 - - [14/Jan/2013:06:07:14 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:18.0) Gecko/20100101 Firefox/18.0"
173.199.120.155 - - [14/Jan/2013:06:13:40 -0600] "GET /blog/hello-world/ HTTP/1.1" 200 2538 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
80.112.172.240 - - [14/Jan/2013:06:15:17 -0600] "GET /blog/how-to-break-out-of-an-exit-popup-in-firefox/ HTTP/1.1" 200 3046 "http://www.google.nl/url?sa=t&rct=j&q=&esrc=s&source=web&cd=3&ved=0CEMQFjAC&url=http%3A%2F%2Fmysite.com%2Fblog%2Fhow-to-break-out-of-an-exit-popup-in-firefox%2F&ei=B_bzUKi9K-nD0QXKqYGgDA&usg=AFQjCNHCkIZCsLpLJ9BgnQxRhUqZ7GlqZQ" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:17 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/how-to-break-out-of-an-exit-popup-in-firefox/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:17 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/how-to-break-out-of-an-exit-popup-in-firefox/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:17 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/how-to-break-out-of-an-exit-popup-in-firefox/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:17 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/how-to-break-out-of-an-exit-popup-in-firefox/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:18 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/how-to-break-out-of-an-exit-popup-in-firefox/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:18 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:18 -0600] "GET /blog/wp-content/uploads/2011/01/exitpop2.png HTTP/1.1" 200 48817 "http://mysite.com/blog/how-to-break-out-of-an-exit-popup-in-firefox/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:19 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 531 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:19 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:19 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:19 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61486 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:18 -0600] "GET /blog/wp-content/uploads/2011/01/prefs31.png HTTP/1.1" 200 85767 "http://mysite.com/blog/how-to-break-out-of-an-exit-popup-in-firefox/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:19 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:20 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:20 -0600] "GET /blog/the-skills/ HTTP/1.1" 200 6364 "http://mysite.com/blog/how-to-break-out-of-an-exit-popup-in-firefox/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
80.112.172.240 - - [14/Jan/2013:06:15:20 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20130113 Firefox/20.0"
178.154.163.29 - - [14/Jan/2013:06:30:56 -0600] "GET /blog/linux-shared-library-error/ HTTP/1.1" 200 3717 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
208.115.111.70 - - [14/Jan/2013:06:33:00 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
65.111.177.188 - - [14/Jan/2013:06:34:58 -0600] "GET / HTTP/1.1" 403 426 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [14/Jan/2013:06:34:58 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [14/Jan/2013:06:34:59 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [14/Jan/2013:06:34:59 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
119.63.193.132 - - [14/Jan/2013:06:51:04 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
173.199.120.155 - - [14/Jan/2013:06:53:46 -0600] "GET /blog/category/adventuring/ HTTP/1.1" 200 7614 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
173.199.120.155 - - [14/Jan/2013:07:00:49 -0600] "GET /blog/tag/krav-maga/ HTTP/1.1" 200 3444 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
66.249.74.38 - - [14/Jan/2013:07:02:28 -0600] "GET /blog/page/2/?cal_m=9&cal_y=1999 HTTP/1.1" 200 15332 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
208.115.111.70 - - [14/Jan/2013:07:30:20 -0600] "GET /blog/tag/exit-popups/feed/ HTTP/1.1" 200 3431 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
173.199.120.155 - - [14/Jan/2013:07:42:11 -0600] "GET /blog/thailand-september-2012/ HTTP/1.1" 200 4511 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
173.199.120.155 - - [14/Jan/2013:07:50:18 -0600] "GET /blog/dreaming-of-andalusia-oklahoma/ HTTP/1.1" 200 3191 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
74.106.233.83 - - [14/Jan/2013:08:01:15 -0600] "GET /blog/analysis-chinese-phishing-scam/ HTTP/1.1" 200 4133 "http://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=6&cad=rja&ved=0CFUQFjAF&url=http%3A%2F%2Fmysite.com%2Fblog%2Fanalysis-chinese-phishing-scam%2F&ei=iQ_0ULfdD4bp0gHQ7YHQCA&usg=AFQjCNFYCLz7-ayPaAOcmhY0gblatVsLWQ&bvm=bv.1357700187,d.dmQ" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:16 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/analysis-chinese-phishing-scam/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:16 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2392 "http://mysite.com/blog/analysis-chinese-phishing-scam/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:16 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/analysis-chinese-phishing-scam/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:16 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/analysis-chinese-phishing-scam/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:16 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/analysis-chinese-phishing-scam/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:17 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:17 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:17 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:17 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:17 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:17 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:18 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
74.106.233.83 - - [14/Jan/2013:08:01:18 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:17.0) Gecko/20100101 Firefox/17.0"
173.199.120.155 - - [14/Jan/2013:08:19:01 -0600] "GET /blog/command-line-gmail/ HTTP/1.1" 200 4079 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
178.154.163.29 - - [14/Jan/2013:08:19:10 -0600] "GET /robots.txt HTTP/1.1" 302 492 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
66.249.74.38 - - [14/Jan/2013:08:25:30 -0600] "GET /robots.txt HTTP/1.1" 200 372 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [14/Jan/2013:08:27:10 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4123 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [14/Jan/2013:08:27:10 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
61.135.248.221 - - [14/Jan/2013:08:28:43 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.221 - - [14/Jan/2013:08:28:44 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.221 - - [14/Jan/2013:08:28:44 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
208.115.113.86 - - [14/Jan/2013:08:33:38 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.54.39.186 - - [14/Jan/2013:08:49:03 -0600] "GET /blog/tag/grow-dates-from-seed/ HTTP/1.1" 200 3238 "http://www.google.com/search?hl=en&tbo=d&site=&source=hp&q=germination+of+date+seed&oq=&gs_l=mobile-gws-hp.1.0.41l3.0.0.0.16870.1.0.0.1.1.0.0.0..0.0.les%3B..0.0...1ac.#miuv=2" "Mozilla/5.0 (iPhone; CPU iPhone OS 6_0_1 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A523 Safari/8536.25"
208.54.39.186 - - [14/Jan/2013:08:49:05 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4123 "http://mysite.com/blog/tag/grow-dates-from-seed/" "Mozilla/5.0 (iPhone; CPU iPhone OS 6_0_1 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A523 Safari/8536.25"
208.54.39.186 - - [14/Jan/2013:08:49:05 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/tag/grow-dates-from-seed/" "Mozilla/5.0 (iPhone; CPU iPhone OS 6_0_1 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A523 Safari/8536.25"
208.54.39.186 - - [14/Jan/2013:08:49:05 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/tag/grow-dates-from-seed/" "Mozilla/5.0 (iPhone; CPU iPhone OS 6_0_1 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A523 Safari/8536.25"
208.54.39.186 - - [14/Jan/2013:08:49:07 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/tag/grow-dates-from-seed/" "Mozilla/5.0 (iPhone; CPU iPhone OS 6_0_1 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A523 Safari/8536.25"
208.54.39.186 - - [14/Jan/2013:08:49:07 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/tag/grow-dates-from-seed/" "Mozilla/5.0 (iPhone; CPU iPhone OS 6_0_1 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A523 Safari/8536.25"
208.54.39.186 - - [14/Jan/2013:08:49:07 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/tag/grow-dates-from-seed/" "Mozilla/5.0 (iPhone; CPU iPhone OS 6_0_1 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A523 Safari/8536.25"
208.54.39.186 - - [14/Jan/2013:08:49:10 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/tag/grow-dates-from-seed/" "Mozilla/5.0 (iPhone; CPU iPhone OS 6_0_1 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A523 Safari/8536.25"
208.54.39.186 - - [14/Jan/2013:08:49:31 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 531 "http://mysite.com/blog/tag/grow-dates-from-seed/" "Mozilla/5.0 (iPhone; CPU iPhone OS 6_0_1 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A523 Safari/8536.25"
208.54.39.186 - - [14/Jan/2013:08:49:31 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61486 "http://mysite.com/blog/tag/grow-dates-from-seed/" "Mozilla/5.0 (iPhone; CPU iPhone OS 6_0_1 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A523 Safari/8536.25"
92.249.127.111 - - [14/Jan/2013:08:52:27 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://medselect.ru/" "Mozilla/5.0 (compatible; news bot /2.1)"
92.249.127.111 - - [14/Jan/2013:08:52:28 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://medselect.ru/" "Mozilla/5.0 (compatible; news bot /2.1)"
148.87.19.214 - - [14/Jan/2013:08:52:43 -0600] "GET /blog/osx-change-root-shell/ HTTP/1.1" 200 3490 "https://www.google.com/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:43 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:43 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:43 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:44 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:44 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:43 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:44 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 531 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:44 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:44 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:44 -0600] "GET /blog/wp-content/themes/koi-improved/img/cancel-reply.png HTTP/1.1" 200 587 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:44 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61486 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:44 -0600] "GET /blog/wp-content/themes/koi-improved/img/submit-btn.png HTTP/1.1" 200 1387 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:44 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:45 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
148.87.19.214 - - [14/Jan/2013:08:52:45 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
202.46.59.142 - - [14/Jan/2013:09:15:07 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
119.63.193.131 - - [14/Jan/2013:09:16:27 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
123.125.71.102 - - [14/Jan/2013:09:26:37 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
123.125.71.80 - - [14/Jan/2013:09:26:37 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
208.115.113.86 - - [14/Jan/2013:09:29:42 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.113.86 - - [14/Jan/2013:09:29:47 -0600] "GET /blog/tag/belief/feed/ HTTP/1.1" 200 4735 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.113.86 - - [14/Jan/2013:09:29:49 -0600] "GET /blog/tag/costa-rica/feed/ HTTP/1.1" 200 5586 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.113.86 - - [14/Jan/2013:09:29:55 -0600] "GET /blog/tag/ff13/feed/ HTTP/1.1" 200 3254 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
66.249.74.38 - - [14/Jan/2013:09:48:35 -0600] "GET /blog/command-line-gmail/ HTTP/1.1" 200 4135 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
173.199.120.155 - - [14/Jan/2013:09:57:59 -0600] "GET /blog/facebook-account-deletion-link/ HTTP/1.1" 200 2687 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
208.115.111.70 - - [14/Jan/2013:10:29:22 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
106.187.97.211 - - [14/Jan/2013:10:35:11 -0600] "POST /blog/wp-cron.php?doing_wp_cron=1358181311.2724490165710449218750 HTTP/1.0" 200 203 "-" "WordPress/3.5; http://mysite.com/blog"
173.199.120.155 - - [14/Jan/2013:10:35:11 -0600] "GET /blog/category/rants/ HTTP/1.1" 200 5353 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
91.121.156.62 - - [14/Jan/2013:10:37:25 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
119.63.193.131 - - [14/Jan/2013:10:40:42 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
123.125.71.105 - - [14/Jan/2013:10:54:45 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
31.202.231.5 - - [14/Jan/2013:10:55:39 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http:///wp-login.php" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; EmbeddedWB 14.52 from: http://www.bsalsa.com/ EmbeddedWB 14,52; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022)"
31.202.231.5 - - [14/Jan/2013:10:55:39 -0600] "GET /blog/ HTTP/1.0" 200 40441 "http:///wp-login.php" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; EmbeddedWB 14.52 from: http://www.bsalsa.com/ EmbeddedWB 14,52; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022)"
220.181.108.163 - - [14/Jan/2013:10:55:56 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
61.135.248.191 - - [14/Jan/2013:10:59:37 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.191 - - [14/Jan/2013:10:59:38 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.191 - - [14/Jan/2013:10:59:38 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
119.247.227.238 - - [14/Jan/2013:11:06:31 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
157.55.33.50 - - [14/Jan/2013:11:10:22 -0600] "GET /robots.txt HTTP/1.1" 200 328 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
66.249.74.38 - - [14/Jan/2013:11:11:55 -0600] "GET /blog/tag/purple-carrots/ HTTP/1.1" 200 2788 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
157.55.33.50 - - [14/Jan/2013:11:12:06 -0600] "GET / HTTP/1.1" 302 467 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
157.55.33.50 - - [14/Jan/2013:11:12:10 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)"
208.115.111.70 - - [14/Jan/2013:11:28:24 -0600] "GET /blog/tag/purple-potatoes/feed/ HTTP/1.1" 200 4081 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
5.135.185.89 - - [14/Jan/2013:11:29:17 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
5.135.182.147 - - [14/Jan/2013:11:29:17 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
5.39.86.162 - - [14/Jan/2013:11:29:18 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
91.121.9.21 - - [14/Jan/2013:11:29:20 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
66.249.74.38 - - [14/Jan/2013:11:36:01 -0600] "GET /blog/tag/jquery/ HTTP/1.1" 200 2812 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
178.238.235.184 - - [14/Jan/2013:11:56:17 -0600] "GET /blog/page/3/ HTTP/1.1" 200 64442 "-" "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.1.3) Gecko/20090824 Firefox/3.5.3 GTB5"
178.238.235.184 - - [14/Jan/2013:11:56:19 -0600] "GET /blog/page/3/ HTTP/1.1" 200 64442 "-" "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.7) Gecko/2009021910 Firefox/3.0.7"
178.238.235.184 - - [14/Jan/2013:11:56:21 -0600] "GET /blog/disable-speed-dial-feature-in-firefox-13/ HTTP/1.1" 200 11807 "-" "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.1.3) Gecko/20090824 Firefox/3.5.3 GTB5"
78.160.185.42 - - [14/Jan/2013:11:59:59 -0600] "GET /blog/black-carrots/ HTTP/1.1" 200 3205 "http://www.google.com.tr/url?sa=t&rct=j&q=black%20carrot%20seed%20turkey&source=web&cd=1&cad=rja&ved=0CCoQFjAA&url=http%3A%2F%2Fmysite.com%2Fblog%2Fblack-carrots%2F&ei=mUf0UK6tG8mB4gT_loCICw&usg=AFQjCNEEQOLEy6aLgJ-dYTCVydcr0EeNkQ&bvm=bv.1357700187,d.d2k" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:00 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:00 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:00 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:00 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:05 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
78.160.185.42 - - [14/Jan/2013:12:00:06 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
202.46.129.15 - - [14/Jan/2013:12:12:16 -0600] "GET /blog/linux-shared-library-error/ HTTP/1.0" 200 3680 "http://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=10&cad=rja&ved=0CJoBEBYwCQ&url=http%3A%2F%2Fmysite.com%2Fblog%2Flinux-shared-library-error%2F&ei=bkr0UJGwLKSAiwL-woDoAQ&usg=AFQjCNEqOGaw6N0t-o1fgvyTViwCNRQQzA&sig2=nW0ab3dpyIwJa9Z5pUxvQQ&bvm=bv.1357700187,d.cGE" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:17 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.0" 200 4123 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:17 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.0" 200 2393 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:17 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.0" 200 1760 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:17 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.0" 200 747 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:17 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.0" 404 11800 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:18 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.0" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:18 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.0" 200 530 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:18 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.0" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:18 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.0" 200 2232 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:18 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.0" 200 61485 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:18 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.0" 200 44308 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:19 -0600] "GET /favicon.ico HTTP/1.0" 302 466 "-" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:19 -0600] "GET /favicon.ico HTTP/1.0" 302 466 "-" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:19 -0600] "GET /blog/dreaming-of-andalusia-oklahoma/ HTTP/1.0" 200 3210 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:19 -0600] "GET /blog/ HTTP/1.0" 200 11656 "-" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
202.46.129.15 - - [14/Jan/2013:12:12:19 -0600] "GET /blog/ HTTP/1.0" 200 11656 "-" "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0"
178.154.163.29 - - [14/Jan/2013:12:13:49 -0600] "GET / HTTP/1.1" 302 467 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
180.76.5.141 - - [14/Jan/2013:12:18:54 -0600] "GET / HTTP/1.1" 302 430 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
180.76.5.190 - - [14/Jan/2013:12:18:54 -0600] "GET /blog/ HTTP/1.1" 200 11656 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
173.199.120.155 - - [14/Jan/2013:12:19:33 -0600] "GET /blog/cpan-changing-permissions-on-osx/ HTTP/1.1" 200 4252 "-" "Mozilla/5.0 (compatible; AhrefsBot/4.0; +http://ahrefs.com/robot/)"
180.76.5.148 - - [14/Jan/2013:12:21:33 -0600] "GET /blog/tag/learn-spanish/ HTTP/1.1" 200 3374 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
208.115.113.86 - - [14/Jan/2013:12:30:02 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
66.249.74.38 - - [14/Jan/2013:12:36:06 -0600] "GET /blog/tag/disable-firefox-speed-dial/ HTTP/1.1" 200 2602 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
202.46.51.53 - - [14/Jan/2013:13:00:38 -0600] "GET / HTTP/1.1" 403 389 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
119.63.193.196 - - [14/Jan/2013:13:01:25 -0600] "GET / HTTP/1.1" 403 389 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
178.154.163.29 - - [14/Jan/2013:13:02:53 -0600] "GET /robots.txt HTTP/1.1" 200 328 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
8.28.16.254 - - [14/Jan/2013:13:08:13 -0600] "GET /blog/basic-perl-log-function HTTP/1.1" 301 286 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 1.1.4322; MS-RTC LM 8; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)"
8.28.16.254 - - [14/Jan/2013:13:08:13 -0600] "GET /blog/basic-perl-log-function/ HTTP/1.1" 200 10073 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 1.1.4322; MS-RTC LM 8; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)"
199.2.205.141 - - [14/Jan/2013:13:08:14 -0600] "GET /blog/basic-perl-log-function/ HTTP/1.1" 200 3733 "http://www.google.com/url?sa=t&rct=j&q=log%20command%20in%20perl&source=web&cd=6&ved=0CF8QFjAF&url=http%3A%2F%2Fmysite.com%2Fblog%2Fbasic-perl-log-function%2F&ei=bVf0UOPZA6rS2AWlvIDwCw&usg=AFQjCNFkYI8hjM3wM93rVUHTKc3Uk-8bSw" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
199.2.205.141 - - [14/Jan/2013:13:08:14 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
199.2.205.141 - - [14/Jan/2013:13:08:15 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
199.2.205.141 - - [14/Jan/2013:13:08:15 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
199.2.205.141 - - [14/Jan/2013:13:08:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
199.2.205.141 - - [14/Jan/2013:13:08:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
199.2.205.141 - - [14/Jan/2013:13:08:15 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
199.2.205.141 - - [14/Jan/2013:13:08:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
199.2.205.141 - - [14/Jan/2013:13:08:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
199.2.205.141 - - [14/Jan/2013:13:08:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
199.2.205.141 - - [14/Jan/2013:13:08:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
199.2.205.141 - - [14/Jan/2013:13:08:15 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
199.2.205.141 - - [14/Jan/2013:13:08:16 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
8.28.16.254 - - [14/Jan/2013:13:08:16 -0600] "GET /blog HTTP/1.1" 301 502 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 1.1.4322; MS-RTC LM 8; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)"
8.28.16.254 - - [14/Jan/2013:13:08:17 -0600] "GET /blog/ HTTP/1.1" 200 40543 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 1.1.4322; MS-RTC LM 8; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)"
199.2.205.141 - - [14/Jan/2013:13:08:17 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; MS-RTC LM 8; SFIEAUTH1)"
46.195.153.175 - - [14/Jan/2013:13:25:25 -0600] "GET /blog/remove-ubuntudebian-version-from-sshd-server-string/ HTTP/1.1" 200 3344 "http://www.google.se/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&ved=0CC4QFjAA&url=http%3A%2F%2Fmysite.com%2Fblog%2Fremove-ubuntudebian-version-from-sshd-server-string%2F&ei=mFv0UK_VLYeL4gSQ7YDQDA&usg=AFQjCNFVLqs2M9KTRAUzfsZT7VRQ5IaaFA&sig2=GKXEca6G1-d162k1Tj6nDA&bvm=bv.1357700187,d.bGE" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:26 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:26 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:26 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:26 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 746 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:26 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:27 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:27 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:27 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:27 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:27 -0600] "GET /blog/wp-content/themes/koi-improved/img/submit-btn.png HTTP/1.1" 200 1388 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:27 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:27 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:29 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:29 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:29 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:25:30 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
208.115.113.86 - - [14/Jan/2013:13:28:10 -0600] "GET /blog/category/travel/ HTTP/1.1" 200 44258 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.113.86 - - [14/Jan/2013:13:28:14 -0600] "GET /blog/tag/machine-translation/ HTTP/1.1" 200 8377 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
206.253.226.23 - - [14/Jan/2013:13:35:46 -0600] "GET / HTTP/1.1" 302 410 "-" "Mozilla/5.0 (compatible; oBot/2.3.1; +http://filterdb.iss.net/crawler/)"
206.253.226.23 - - [14/Jan/2013:13:35:46 -0600] "GET /blog/ HTTP/1.1" 200 40542 "-" "Mozilla/5.0 (compatible; oBot/2.3.1; +http://filterdb.iss.net/crawler/)"
206.253.226.23 - - [14/Jan/2013:13:35:50 -0600] "HEAD / HTTP/1.1" 403 147 "-" "Mozilla/5.0 (compatible; oBot/2.3.1; +http://filterdb.iss.net/crawler/)"
180.76.5.56 - - [14/Jan/2013:13:36:18 -0600] "GET /blog/?p=1436 HTTP/1.1" 301 322 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
180.76.5.99 - - [14/Jan/2013:13:36:19 -0600] "GET /blog/remove-ubuntudebian-version-from-sshd-server-string/ HTTP/1.1" 200 3333 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
46.195.153.175 - - [14/Jan/2013:13:36:36 -0600] "GET /blog/remove-ubuntudebian-version-from-sshd-server-string/ HTTP/1.1" 200 3344 "http://www.google.se/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&ved=0CC4QFjAA&url=http%3A%2F%2Fmysite.com%2Fblog%2Fremove-ubuntudebian-version-from-sshd-server-string%2F&ei=mFv0UK_VLYeL4gSQ7YDQDA&usg=AFQjCNFVLqs2M9KTRAUzfsZT7VRQ5IaaFA&sig2=GKXEca6G1-d162k1Tj6nDA&bvm=bv.1357700187,d.bGE" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:36:36 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 304 195 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:36:36 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 304 193 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
46.195.153.175 - - [14/Jan/2013:13:36:37 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11836 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (X11; FreeBSD amd64; rv:7.0) Gecko/20100101 Firefox/7.0"
61.135.248.172 - - [14/Jan/2013:13:43:06 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.172 - - [14/Jan/2013:13:43:06 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.172 - - [14/Jan/2013:13:43:06 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
66.249.74.38 - - [14/Jan/2013:14:00:38 -0600] "GET /blog/tag/firefox-13/ HTTP/1.1" 200 2604 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
193.106.136.33 - - [14/Jan/2013:14:05:29 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://taxitoday.ru/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Win 9x 4.90)"
193.106.136.33 - - [14/Jan/2013:14:05:30 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://taxitoday.ru/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows 98; Win 9x 4.90)"
124.115.6.15 - - [14/Jan/2013:14:12:09 -0600] "GET /robots.txt HTTP/1.1" 200 372 "-" "Mozilla/5.0(compatible; Sosospider/2.0; +http://help.soso.com/webspider.htm)"
66.249.74.38 - - [14/Jan/2013:14:15:11 -0600] "GET /blog/page/2/?view=month&cal_d=1&cal_m=3&cal_y=1980&course=1 HTTP/1.1" 200 15350 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
178.154.163.29 - - [14/Jan/2013:14:24:38 -0600] "GET /blog/tag/ubuntu-sshd/ HTTP/1.1" 200 2633 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
70.75.177.99 - - [14/Jan/2013:14:24:45 -0600] "GET /scripts/twitter-who2follow.user.js HTTP/1.1" 302 467 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0"
70.75.177.99 - - [14/Jan/2013:14:24:45 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0"
124.115.6.13 - - [14/Jan/2013:14:28:07 -0600] "GET /robots.txt HTTP/1.1" 200 372 "-" "Mozilla/5.0(compatible; Sosospider/2.0; +http://help.soso.com/webspider.htm)"
208.115.111.70 - - [14/Jan/2013:14:30:25 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
187.5.177.142 - - [14/Jan/2013:14:31:31 -0600] "GET /blog/disable-speed-dial-feature-in-firefox-13/ HTTP/1.1" 200 11844 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
187.5.177.142 - - [14/Jan/2013:14:31:34 -0600] "POST /blog/wp-comments-post.php HTTP/1.0" 500 4437 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
128.68.197.137 - - [14/Jan/2013:14:34:31 -0600] "GET /blog/remove-ubuntudebian-version-from-sshd-server-string/ HTTP/1.1" 200 3344 "http://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=4&ved=0CFUQFjAD&url=http%3A%2F%2Fmysite.com%2Fblog%2Fremove-ubuntudebian-version-from-sshd-server-string%2F&ei=tGv0UJKsJYqm0AWi6ICABg&usg=AFQjCNFVLqs2M9KTRAUzfsZT7VRQ5IaaFA&bvm=bv.1357700187,d.ZG4&cad=rja" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
128.68.197.137 - - [14/Jan/2013:14:34:32 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
128.68.197.137 - - [14/Jan/2013:14:34:32 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
128.68.197.137 - - [14/Jan/2013:14:34:32 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 746 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
128.68.197.137 - - [14/Jan/2013:14:34:32 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
128.68.197.137 - - [14/Jan/2013:14:34:32 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11836 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
128.68.197.137 - - [14/Jan/2013:14:34:33 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
128.68.197.137 - - [14/Jan/2013:14:34:33 -0600] "GET /blog/wp-content/themes/koi-improved/img/submit-btn.png HTTP/1.1" 200 1388 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
128.68.197.137 - - [14/Jan/2013:14:34:33 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
128.68.197.137 - - [14/Jan/2013:14:34:33 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
128.68.197.137 - - [14/Jan/2013:14:34:33 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 531 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
128.68.197.137 - - [14/Jan/2013:14:34:33 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
128.68.197.137 - - [14/Jan/2013:14:34:33 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
123.125.71.97 - - [14/Jan/2013:14:38:30 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.159 - - [14/Jan/2013:14:39:20 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
157.82.156.165 - - [14/Jan/2013:14:41:42 -0600] "GET /robots.txt HTTP/1.1" 200 335 "-" "Mozilla/5.0 (compatible; Steeler/3.5; http://www.tkl.iis.u-tokyo.ac.jp/~crawler/)"
157.82.156.165 - - [14/Jan/2013:14:41:47 -0600] "GET /blog/ HTTP/1.1" 200 11656 "http://mysite.com/blog" "Mozilla/5.0 (compatible; Steeler/3.5; http://www.tkl.iis.u-tokyo.ac.jp/~crawler/)"
71.176.66.73 - - [14/Jan/2013:14:45:43 -0600] "GET /robots.txt HTTP/1.0" 200 291 "-" "Mozilla/5.0 (compatible; MJ12bot/v1.4.3; http://www.majestic12.co.uk/bot.php?+)"
71.176.66.73 - - [14/Jan/2013:14:45:47 -0600] "GET / HTTP/1.1" 302 410 "-" "Mozilla/5.0 (compatible; MJ12bot/v1.4.3; http://www.majestic12.co.uk/bot.php?+)"
71.176.66.73 - - [14/Jan/2013:14:45:49 -0600] "GET /blog/ HTTP/1.1" 200 40487 "-" "Mozilla/5.0 (compatible; MJ12bot/v1.4.3; http://www.majestic12.co.uk/bot.php?+)"
178.154.163.29 - - [14/Jan/2013:14:46:26 -0600] "GET /blog/for-better-or-for-awesome/ HTTP/1.1" 200 3964 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
201.78.113.155 - - [14/Jan/2013:15:04:31 -0600] "GET /blog/arrival-at-quebec-city/ HTTP/1.1" 200 9329 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
178.154.163.29 - - [14/Jan/2013:15:11:20 -0600] "GET /blog/dreaming-of-andalusia-oklahoma/ HTTP/1.1" 200 3247 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
119.63.193.195 - - [14/Jan/2013:15:16:40 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
208.115.111.70 - - [14/Jan/2013:15:28:57 -0600] "GET /blog/day-in-the-life/ HTTP/1.1" 200 8766 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
66.249.74.38 - - [14/Jan/2013:15:38:00 -0600] "GET /blog/os-x-madplay/ HTTP/1.1" 200 4329 "-" "Mozilla/5.0 (iPhone; U; CPU iPhone OS 4_1 like Mac OS X; en-us) AppleWebKit/532.9 (KHTML, like Gecko) Version/4.0.5 Mobile/8B117 Safari/6531.22.7 (compatible; Googlebot-Mobile/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [14/Jan/2013:15:44:18 -0600] "GET /blog/page/2/?view=month&course=1&cal_d=1&cal_m=3&cal_y=1964 HTTP/1.1" 200 15349 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [14/Jan/2013:15:46:10 -0600] "GET /blog/wp-content/uploads/2010/07/network_m.jpg HTTP/1.1" 200 16126 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
61.135.248.194 - - [14/Jan/2013:16:26:43 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.194 - - [14/Jan/2013:16:26:43 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.194 - - [14/Jan/2013:16:26:43 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
180.76.6.35 - - [14/Jan/2013:16:27:54 -0600] "GET /blog/change-is-good/ HTTP/1.1" 200 3542 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
208.115.113.86 - - [14/Jan/2013:16:34:01 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
123.125.71.95 - - [14/Jan/2013:16:38:52 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
202.46.61.23 - - [14/Jan/2013:16:39:39 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
119.63.193.196 - - [14/Jan/2013:16:39:43 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
220.181.108.144 - - [14/Jan/2013:16:39:44 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
66.249.74.38 - - [14/Jan/2013:17:10:54 -0600] "GET /blog/disable-speed-dial-feature-in-firefox-13/ HTTP/1.1" 200 3792 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
208.115.113.86 - - [14/Jan/2013:17:23:41 -0600] "GET /blog/medellin-colombia/ HTTP/1.1" 200 8448 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.113.86 - - [14/Jan/2013:17:23:47 -0600] "GET /blog/osx-change-root-shell/feed/ HTTP/1.1" 200 1106 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
96.254.171.2 - - [14/Jan/2013:17:33:10 -0600] "GET http://gameframe.net/headers HTTP/1.1" 404 369 "-" "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.2.28) Gecko/20120306 Firefox/3.6.28 (.NET CLR 3.5.30729)"
37.1.207.22 - - [14/Jan/2013:17:37:07 -0600] "GET /blog/wp-content/themes/kaboodle/timthumb.php HTTP/1.1" 404 40644 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/535.7 (KHTML, like Gecko) Chrome/16.0.912.77 Safari/535.7"
180.76.5.194 - - [14/Jan/2013:17:39:16 -0600] "GET /blog/tag/file-permissions/feed/ HTTP/1.1" 200 3092 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
123.125.71.102 - - [14/Jan/2013:17:40:25 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.161 - - [14/Jan/2013:17:40:54 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
92.66.127.86 - - [14/Jan/2013:18:08:38 -0600] "GET /blog/ HTTP/1.1" 200 40487 "-" "curl/7.21.4 (universal-apple-darwin11.0) libcurl/7.21.4 OpenSSL/0.9.8r zlib/1.2.5"
83.84.118.205 - - [14/Jan/2013:18:08:47 -0600] "GET /blog/linux-shared-library-error/ HTTP/1.1" 200 3717 "https://www.google.nl/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
83.84.118.205 - - [14/Jan/2013:18:08:48 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
83.84.118.205 - - [14/Jan/2013:18:08:48 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
83.84.118.205 - - [14/Jan/2013:18:08:48 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 746 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
83.84.118.205 - - [14/Jan/2013:18:08:48 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15312 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
83.84.118.205 - - [14/Jan/2013:18:08:48 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
83.84.118.205 - - [14/Jan/2013:18:08:48 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11836 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
83.84.118.205 - - [14/Jan/2013:18:08:49 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
83.84.118.205 - - [14/Jan/2013:18:08:49 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
92.66.127.86 - - [14/Jan/2013:18:08:48 -0600] "GET /blog/ HTTP/1.1" 200 40487 "-" "curl/7.21.4 (universal-apple-darwin11.0) libcurl/7.21.4 OpenSSL/0.9.8r zlib/1.2.5"
83.84.118.205 - - [14/Jan/2013:18:08:49 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
83.84.118.205 - - [14/Jan/2013:18:08:49 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
83.84.118.205 - - [14/Jan/2013:18:08:49 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
83.84.118.205 - - [14/Jan/2013:18:08:50 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
83.84.118.205 - - [14/Jan/2013:18:08:50 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
92.66.127.86 - - [14/Jan/2013:18:08:53 -0600] "GET /blog/ HTTP/1.1" 200 40487 "-" "curl/7.21.4 (universal-apple-darwin11.0) libcurl/7.21.4 OpenSSL/0.9.8r zlib/1.2.5"
69.58.178.59 - - [14/Jan/2013:18:12:59 -0600] "GET /robots.txt HTTP/1.1" 200 272 "-" "BlackBerry9000/4.6.0.167 Profile/MIDP-2.0 Configuration/CLDC-1.1 VendorID/102 ips-agent"
69.58.178.59 - - [14/Jan/2013:18:13:00 -0600] "GET / HTTP/1.1" 403 370 "-" "BlackBerry9000/4.6.0.167 Profile/MIDP-2.0 Configuration/CLDC-1.1 VendorID/102 ips-agent"
69.58.178.59 - - [14/Jan/2013:18:13:01 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:14.0; ips-agent) Gecko/20100101 Firefox/14.0.1"
173.255.106.146 - - [14/Jan/2013:18:19:07 -0600] "GET /blog/cpan-changing-permissions-on-osx/ HTTP/1.1" 200 4308 "http://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=1&ved=0CDIQFjAA&url=http%3A%2F%2Fmysite.com%2Fblog%2Fcpan-changing-permissions-on-osx%2F&ei=eKD0UJnIHKr8igKVuYDYDQ&usg=AFQjCNE06zD3u0X0IbpLUs0dTCCnv34RXQ&bvm=bv.41018144,d.cGE" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:08 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:08 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:08 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:08 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:08 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:09 -0600] "GET /blog/wp-content/uploads/2010/06/code5.jpg HTTP/1.1" 200 31149 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:09 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:09 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:09 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:09 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:09 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:09 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:10 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:10 -0600] "GET /blog/take-action-now/ HTTP/1.1" 200 3774 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
173.255.106.146 - - [14/Jan/2013:18:19:10 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:46 -0600] "GET /BoggleGame-Dancer HTTP/1.1" 301 507 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:46 -0600] "GET /BoggleGame-Dancer/ HTTP/1.1" 403 439 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:47 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:47 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:53 -0600] "GET / HTTP/1.1" 302 467 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:54 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:55 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:55 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:55 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:55 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11836 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:56 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:56 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:56 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61486 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:56 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:56 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 531 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [14/Jan/2013:18:30:56 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
81.64.42.154 - - [14/Jan/2013:18:34:28 -0600] "GET /blog/wp-content/uploads/2010/06/code5.jpg HTTP/1.1" 200 31149 "http://www.google.co.uk/imgres?q=perl+code&um=1&hl=en&sa=N&tbo=d&rlz=1C1DVCL_enFR429FR429&biw=1280&bih=863&tbm=isch&tbnid=SRrsAJ-qab5SDM:&imgrefurl=http://mysite.com/blog/cpan-changing-permissions-on-osx/&docid=8n0nmbfryz2oMM&imgurl=http://mysite.com/blog/wp-content/uploads/2010/06/code5.jpg&w=240&h=180&ei=46P0UJKQHpKzhAeUmoH4DQ&zoom=1&iact=rc&dur=6&sig=114759389314555926759&page=1&tbnh=144&tbnw=192&start=0&ndsp=31&ved=1t:429,r:18,s:0,i:136&tx=135&ty=109" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
81.64.42.154 - - [14/Jan/2013:18:34:28 -0600] "GET /blog/cpan-changing-permissions-on-osx/ HTTP/1.1" 200 4308 "http://www.google.co.uk/imgres?q=perl+code&um=1&hl=en&sa=N&tbo=d&rlz=1C1DVCL_enFR429FR429&biw=1280&bih=863&tbm=isch&tbnid=SRrsAJ-qab5SDM:&imgrefurl=http://mysite.com/blog/cpan-changing-permissions-on-osx/&docid=8n0nmbfryz2oMM&imgurl=http://mysite.com/blog/wp-content/uploads/2010/06/code5.jpg&w=240&h=180&ei=46P0UJKQHpKzhAeUmoH4DQ&zoom=1&iact=rc&dur=6&sig=114759389314555926759&page=1&tbnh=144&tbnw=192&start=0&ndsp=31&ved=1t:429,r:18,s:0,i:136&tx=135&ty=109" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
81.64.42.154 - - [14/Jan/2013:18:34:29 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
81.64.42.154 - - [14/Jan/2013:18:34:29 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2392 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
92.66.127.86 - - [14/Jan/2013:18:34:29 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
81.64.42.154 - - [14/Jan/2013:18:34:29 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 746 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
81.64.42.154 - - [14/Jan/2013:18:34:29 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15312 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
92.66.127.86 - - [14/Jan/2013:18:34:29 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 304 194 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
81.64.42.154 - - [14/Jan/2013:18:34:29 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11836 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
81.64.42.154 - - [14/Jan/2013:18:34:30 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
92.66.127.86 - - [14/Jan/2013:18:34:29 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
81.64.42.154 - - [14/Jan/2013:18:34:30 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
81.64.42.154 - - [14/Jan/2013:18:34:30 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
81.64.42.154 - - [14/Jan/2013:18:34:30 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
81.64.42.154 - - [14/Jan/2013:18:34:30 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
81.64.42.154 - - [14/Jan/2013:18:34:31 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/cpan-changing-permissions-on-osx/" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
123.125.71.117 - - [14/Jan/2013:18:38:32 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.170 - - [14/Jan/2013:18:39:23 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
66.249.74.38 - - [14/Jan/2013:18:42:45 -0600] "GET /robots.txt HTTP/1.1" 200 355 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [14/Jan/2013:18:42:46 -0600] "GET /blog/basic-perl-log-function/ HTTP/1.1" 200 3733 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
108.174.194.111 - - [14/Jan/2013:18:43:10 -0600] "GET /blog/spanish-resources/ HTTP/1.1" 200 3721 "http://mysite.com/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/13.0.782.112 Safari/535.1"
108.174.194.111 - - [14/Jan/2013:18:43:11 -0600] "GET /blog/remove-ubuntudebian-version-from-sshd-server-string/ HTTP/1.1" 200 3333 "http://mysite.com/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/13.0.782.112 Safari/535.1"
108.174.194.111 - - [14/Jan/2013:18:43:11 -0600] "POST /blog/wp-comments-post.php HTTP/1.1" 500 4437 "http://mysite.com/blog/remove-ubuntudebian-version-from-sshd-server-string/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/13.0.782.112 Safari/535.1"
119.63.193.131 - - [14/Jan/2013:18:51:20 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
180.76.5.64 - - [14/Jan/2013:19:06:51 -0600] "GET /blog/tag/belgium/feed/ HTTP/1.1" 200 2364 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
61.135.249.131 - - [14/Jan/2013:19:20:13 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.131 - - [14/Jan/2013:19:20:13 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.131 - - [14/Jan/2013:19:20:13 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
123.151.148.207 - - [14/Jan/2013:19:37:54 -0600] "GET / HTTP/1.1" 302 467 "-" "Sosospider+(+http://help.soso.com/webspider.htm)"
123.151.148.207 - - [14/Jan/2013:19:37:54 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Sosospider+(+http://help.soso.com/webspider.htm)"
123.151.148.207 - - [14/Jan/2013:19:38:04 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/" "Sosospider+(+http://help.soso.com/webspider.htm)"
119.247.227.238 - - [14/Jan/2013:19:39:16 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
66.249.74.38 - - [14/Jan/2013:20:15:37 -0600] "GET /robots.txt HTTP/1.1" 200 355 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [14/Jan/2013:20:15:37 -0600] "GET /blog/page/3/ HTTP/1.1" 200 28368 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
180.76.5.110 - - [14/Jan/2013:20:29:46 -0600] "GET /blog/tag/carrot-soup/ HTTP/1.1" 200 2744 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
66.249.74.38 - - [14/Jan/2013:20:39:36 -0600] "GET /blog/wp-includes/images/smilies/icon_wink.gif HTTP/1.1" 200 444 "http://mysite.com/blog/page/3/" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
123.125.71.85 - - [14/Jan/2013:20:40:48 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.146 - - [14/Jan/2013:20:41:17 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
172.10.181.105 - - [14/Jan/2013:20:47:22 -0600] "GET /blog/linux-shared-library-error/ HTTP/1.1" 200 3717 "http://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=4&ved=0CEkQFjAD&url=http%3A%2F%2Fmysite.com%2Fblog%2Flinux-shared-library-error%2F&ei=-pv0ULjPIojE2gW1_YDADQ&usg=AFQjCNEqOGaw6N0t-o1fgvyTViwCNRQQzA&bvm=bv.1357700187,d.b2I&kb=1" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
172.10.181.105 - - [14/Jan/2013:20:47:22 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
172.10.181.105 - - [14/Jan/2013:20:47:23 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
172.10.181.105 - - [14/Jan/2013:20:47:23 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
172.10.181.105 - - [14/Jan/2013:20:47:23 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
172.10.181.105 - - [14/Jan/2013:20:47:23 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
172.10.181.105 - - [14/Jan/2013:20:47:24 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
172.10.181.105 - - [14/Jan/2013:20:47:24 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
172.10.181.105 - - [14/Jan/2013:20:47:24 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
172.10.181.105 - - [14/Jan/2013:20:47:24 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
172.10.181.105 - - [14/Jan/2013:20:47:24 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
172.10.181.105 - - [14/Jan/2013:20:47:24 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
172.10.181.105 - - [14/Jan/2013:20:47:24 -0600] "GET /blog/dreaming-of-andalusia-oklahoma/ HTTP/1.1" 200 3246 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux i686; rv:17.0) Gecko/20100101 Firefox/17.0 SeaMonkey/2.14.1"
66.249.74.38 - - [14/Jan/2013:20:53:21 -0600] "GET /blog/tag/firefox-speed-dial/ HTTP/1.1" 200 2602 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
202.46.52.149 - - [14/Jan/2013:21:15:02 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
119.63.193.131 - - [14/Jan/2013:21:16:21 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
123.125.71.75 - - [14/Jan/2013:21:16:36 -0600] "GET /robots.txt HTTP/1.1" 200 318 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
65.55.212.174 - - [14/Jan/2013:21:30:21 -0600] "GET /robots.txt HTTP/1.1" 200 318 "-" "msnbot-media/1.1 (+http://search.msn.com/msnbot.htm)"
65.55.212.174 - - [14/Jan/2013:21:30:22 -0600] "GET /blog/wp-includes/images/smilies/icon_smile.gif HTTP/1.1" 200 411 "-" "msnbot-media/1.1 (+http://search.msn.com/msnbot.htm)"
61.135.249.64 - - [14/Jan/2013:21:39:09 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.64 - - [14/Jan/2013:21:39:09 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.64 - - [14/Jan/2013:21:39:10 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
5.34.242.184 - - [14/Jan/2013:21:41:02 -0600] "GET http://www.yahoo.com/ HTTP/1.1" 403 370 "-" "Internet Explorer 4.01"
180.76.5.62 - - [14/Jan/2013:21:45:26 -0600] "GET /blog/facebook-account-deletion-link/ HTTP/1.1" 200 2732 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
123.125.71.26 - - [14/Jan/2013:22:00:48 -0600] "GET /robots.txt HTTP/1.1" 200 318 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
5.104.241.175 - - [14/Jan/2013:22:18:57 -0600] "GET /blog/feed/ HTTP/1.1" 304 203 "-" "Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en) AppleWebKit/162 (KHTML, like Gecko) Safari/162"
106.187.97.211 - - [14/Jan/2013:22:18:58 -0600] "POST /blog/wp-cron.php?doing_wp_cron=1358223537.8330841064453125000000 HTTP/1.0" 200 203 "-" "WordPress/3.5; http://mysite.com/blog"
108.174.194.111 - - [14/Jan/2013:22:28:14 -0600] "GET /blog/page/2/?cal_m=9&cal_y=1999 HTTP/1.1" 200 15295 "http://mysite.com/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 3.5.30729)"
108.174.194.111 - - [14/Jan/2013:22:28:15 -0600] "GET /blog/spicnspan/ HTTP/1.1" 200 4758 "http://mysite.com/" "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 3.5.30729)"
123.125.71.80 - - [14/Jan/2013:22:39:34 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
119.63.193.196 - - [14/Jan/2013:22:40:26 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
220.181.108.157 - - [14/Jan/2013:22:40:29 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
66.249.74.38 - - [14/Jan/2013:22:41:25 -0600] "GET /blog/tag/firefox-13-speed-dial/ HTTP/1.1" 200 2607 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
65.111.177.188 - - [14/Jan/2013:23:04:58 -0600] "GET / HTTP/1.1" 403 426 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [14/Jan/2013:23:04:58 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [14/Jan/2013:23:04:59 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [14/Jan/2013:23:05:00 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
180.76.5.137 - - [14/Jan/2013:23:12:36 -0600] "GET /blog/tag/short-tags/ HTTP/1.1" 200 4506 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
195.242.218.133 - - [14/Jan/2013:23:17:54 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://www.aviabilety.travel/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)"
195.242.218.133 - - [14/Jan/2013:23:17:56 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://www.aviabilety.travel/" "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)"
123.125.71.114 - - [14/Jan/2013:23:43:38 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.156 - - [14/Jan/2013:23:44:33 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
192.74.228.9 - - [15/Jan/2013:00:06:19 -0600] "GET /blog/como-me-le-va/ HTTP/1.0" 200 9148 "http://mysite.com/blog/como-me-le-va/" "Opera/9.80 (Windows NT 5.1; U; ru) Presto/2.10.289 Version/12.00"
61.135.249.75 - - [15/Jan/2013:00:30:32 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.75 - - [15/Jan/2013:00:30:32 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.75 - - [15/Jan/2013:00:30:33 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
208.115.113.86 - - [15/Jan/2013:00:31:59 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
66.249.74.118 - - [15/Jan/2013:00:32:17 -0600] "GET /robots.txt HTTP/1.1" 200 355 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.118 - - [15/Jan/2013:00:32:17 -0600] "GET / HTTP/1.1" 403 427 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
178.154.163.29 - - [15/Jan/2013:00:35:42 -0600] "GET /robots.txt HTTP/1.1" 302 492 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
180.76.5.58 - - [15/Jan/2013:00:37:02 -0600] "GET /blog/tag/snes9x/ HTTP/1.1" 200 4509 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
218.93.127.118 - - [15/Jan/2013:00:43:43 -0600] "GET /blog/analysis-chinese-phishing-scam/ HTTP/1.0" 200 11452 "http://mysite.com/blog/analysis-chinese-phishing-scam/" "Mozilla/5.0 (Windows NT 6.1; rv:15.0) Gecko/20100101 Firefox/15.0.1"
59.120.140.76 - - [15/Jan/2013:00:49:33 -0600] "OPTIONS * HTTP/1.1" 200 91 "-" "-"
119.63.193.196 - - [15/Jan/2013:00:50:44 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
65.111.177.188 - - [15/Jan/2013:00:50:46 -0600] "GET / HTTP/1.1" 403 426 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [15/Jan/2013:00:50:47 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [15/Jan/2013:00:50:47 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
65.111.177.188 - - [15/Jan/2013:00:50:48 -0600] "GET / HTTP/1.1" 403 370 "-" "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11"
66.249.74.38 - - [15/Jan/2013:00:58:42 -0600] "GET /blog/linux-shared-library-error/ HTTP/1.1" 200 3717 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [15/Jan/2013:01:11:38 -0600] "GET /blog/page/2/?view=month&course=1&cal_d=1&cal_m=1&cal_y=1901 HTTP/1.1" 200 15346 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
186.10.11.68 - - [15/Jan/2013:01:26:53 -0600] "GET /favicon.ico?position=6&query=perl+log+function HTTP/1.1" 302 535 "-" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
186.10.11.68 - - [15/Jan/2013:01:26:54 -0600] "GET /blog/?position=6&query=perl+log+function HTTP/1.1" 200 11721 "-" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
208.115.113.86 - - [15/Jan/2013:01:28:51 -0600] "GET /blog/tag/spanish-resources/ HTTP/1.1" 200 8978 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
65.55.213.243 - - [15/Jan/2013:01:34:58 -0600] "GET /robots.txt HTTP/1.1" 200 318 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.243 - - [15/Jan/2013:01:34:58 -0600] "GET /raw/sitemap.xml.gz HTTP/1.1" 404 399 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
41.82.143.183 - - [15/Jan/2013:01:45:25 -0600] "GET /blog HTTP/1.1" 301 465 "-" "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt; DTS Agent"
180.76.5.163 - - [15/Jan/2013:01:52:16 -0600] "GET /blog/tag/purple-potatoes/ HTTP/1.1" 200 2634 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
178.154.163.29 - - [15/Jan/2013:01:53:44 -0600] "GET / HTTP/1.1" 302 467 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
69.181.161.149 - - [15/Jan/2013:02:00:59 -0600] "GET /blog/disable-speed-dial-feature-in-firefox-13/ HTTP/1.1" 200 3792 "http://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=4&ved=0CEMQFjAD&url=http%3A%2F%2Fmysite.com%2Fblog%2Fdisable-speed-dial-feature-in-firefox-13%2F&ei=mgz1UODUJY3MigLd_4GYDg&usg=AFQjCNGyD7hyD_i8tCVpXkU76IoLLH8AJg&bvm=bv.41018144,d.cGE" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:00 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/disable-speed-dial-feature-in-firefox-13/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:00 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/disable-speed-dial-feature-in-firefox-13/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:00 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/disable-speed-dial-feature-in-firefox-13/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:00 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/disable-speed-dial-feature-in-firefox-13/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:00 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/disable-speed-dial-feature-in-firefox-13/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/submit-btn.png HTTP/1.1" 200 1387 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/reply.png HTTP/1.1" 200 822 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:01 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:02 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:02 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:02 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
69.181.161.149 - - [15/Jan/2013:02:01:03 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:18.0) Gecko/20100101 Firefox/18.0"
88.190.43.198 - - [15/Jan/2013:02:20:13 -0600] "GET /blog/ HTTP/1.1" 200 11656 "http://mysite.com/" "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/13.0.782.112 Safari/535.1"
123.125.71.25 - - [15/Jan/2013:02:31:11 -0600] "GET /robots.txt HTTP/1.1" 200 318 "-" "Mozilla/5.0 (Windows NT 5.1; rv:6.0.2) Gecko/20100101 Firefox/6.0.2"
208.115.111.70 - - [15/Jan/2013:02:32:54 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
119.247.227.238 - - [15/Jan/2013:02:38:41 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
61.135.248.186 - - [15/Jan/2013:02:57:22 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.186 - - [15/Jan/2013:02:57:22 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.186 - - [15/Jan/2013:02:57:22 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
178.154.163.29 - - [15/Jan/2013:03:02:02 -0600] "GET /robots.txt HTTP/1.1" 200 311 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
91.121.26.97 - - [15/Jan/2013:03:11:09 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
91.121.97.145 - - [15/Jan/2013:03:11:09 -0600] "POST /wp-login.php HTTP/1.0" 302 492 "http://ninjavegan.com/wp-login.php" "Opera/9.80 (Windows NT 6.1; U; ru) Presto/2.8.131 Version/11.10"
180.76.5.189 - - [15/Jan/2013:03:14:57 -0600] "GET /blog/page/3/?cal_m=10&cal_y=2012 HTTP/1.1" 200 28350 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
209.171.42.71 - - [15/Jan/2013:03:15:12 -0600] "GET /blog/feed HTTP/1.1" 301 385 "-" "Mozilla/5.0 (compatible; BlogScope/1.0; +http://www.blogscope.net/; U of Toronto)"
209.171.42.71 - - [15/Jan/2013:03:15:13 -0600] "GET /blog/feed/ HTTP/1.1" 200 10927 "-" "Mozilla/5.0 (compatible; BlogScope/1.0; +http://www.blogscope.net/; U of Toronto)"
178.154.163.29 - - [15/Jan/2013:03:16:29 -0600] "GET / HTTP/1.1" 302 467 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
76.166.183.27 - - [15/Jan/2013:03:17:01 -0600] "GET /blog/linux-shared-library-error/ HTTP/1.1" 200 3717 "https://www.google.com/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:02 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:02 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:02 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:02 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:02 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:02 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:03 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:03 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:03 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:03 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:03 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:03 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
76.166.183.27 - - [15/Jan/2013:03:17:03 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
208.115.111.70 - - [15/Jan/2013:03:28:07 -0600] "GET /blog/inexpensive-airfare/ HTTP/1.1" 200 9787 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
66.249.74.38 - - [15/Jan/2013:03:37:29 -0600] "GET /blog/page/2/?view=month&cal_d=1&cal_m=6&cal_y=2132&course=1 HTTP/1.1" 200 15351 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
74.125.186.33 - - [15/Jan/2013:03:43:26 -0600] "GET /favicon.ico HTTP/1.1" 302 411 "-" "-"
74.125.186.33 - - [15/Jan/2013:03:43:26 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "-"
123.125.71.77 - - [15/Jan/2013:03:44:11 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.148 - - [15/Jan/2013:03:45:05 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
5.34.242.184 - - [15/Jan/2013:03:48:45 -0600] "GET http://37.28.156.211/sprawdza.php HTTP/1.1" 404 434 "-" "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)"
106.187.97.211 - - [15/Jan/2013:04:02:11 -0600] "POST /blog/wp-cron.php?doing_wp_cron=1358244131.0151801109313964843750 HTTP/1.0" 200 203 "-" "WordPress/3.5; http://mysite.com/blog"
106.187.97.211 - - [15/Jan/2013:04:02:11 -0600] "POST /blog/wp-cron.php?doing_wp_cron=1358244131.0499610900878906250000 HTTP/1.0" 200 203 "-" "WordPress/3.5; http://mysite.com/blog"
91.223.75.118 - - [15/Jan/2013:04:02:10 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://wmcash-change.com/" "Opera/7.54 (Windows NT 5.1; U)  [pl]"
91.223.75.118 - - [15/Jan/2013:04:02:10 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://porno-photo.org/" "Opera/7.54 (Windows NT 5.1; U)  [pl]"
91.223.75.118 - - [15/Jan/2013:04:02:12 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://wmcash-change.com/" "Opera/7.54 (Windows NT 5.1; U)  [pl]"
91.223.75.118 - - [15/Jan/2013:04:02:12 -0600] "GET /blog/about/ HTTP/1.1" 200 6865 "http://porno-photo.org/" "Opera/7.54 (Windows NT 5.1; U)  [pl]"
220.181.89.153 - - [15/Jan/2013:04:06:39 -0600] "GET / HTTP/1.1" 302 430 "-" "Sogou web spider/4.0(+http://www.sogou.com/docs/help/webmasters.htm#07)"
220.181.89.153 - - [15/Jan/2013:04:06:49 -0600] "GET /blog/ HTTP/1.1" 200 11656 "-" "Sogou web spider/4.0(+http://www.sogou.com/docs/help/webmasters.htm#07)"
178.154.163.29 - - [15/Jan/2013:04:22:43 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
208.115.113.86 - - [15/Jan/2013:04:29:00 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
92.66.127.86 - - [15/Jan/2013:04:37:11 -0600] "GET / HTTP/1.1" 302 467 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:12 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:13 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 304 194 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:13 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:20 -0600] "GET /blog/wp-admin HTTP/1.1" 301 500 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:20 -0600] "GET /blog/wp-admin/ HTTP/1.1" 302 470 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:21 -0600] "GET /blog/wp-login.php?redirect_to=http%3A%2F%2Fmysite.com%2Fblog%2Fwp-admin%2F&reauth=1 HTTP/1.1" 200 3040 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:21 -0600] "GET /blog/wp-includes/css/buttons.min.css?ver=3.5 HTTP/1.1" 200 1610 "http://mysite.com/blog/wp-login.php?redirect_to=http%3A%2F%2Fmysite.com%2Fblog%2Fwp-admin%2F&reauth=1" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:21 -0600] "GET /blog/wp-admin/css/wp-admin.min.css?ver=3.5 HTTP/1.1" 200 24175 "http://mysite.com/blog/wp-login.php?redirect_to=http%3A%2F%2Fmysite.com%2Fblog%2Fwp-admin%2F&reauth=1" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:22 -0600] "GET /blog/wp-admin/css/colors-fresh.min.css?ver=3.5 HTTP/1.1" 200 6949 "http://mysite.com/blog/wp-login.php?redirect_to=http%3A%2F%2Fmysite.com%2Fblog%2Fwp-admin%2F&reauth=1" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:22 -0600] "GET /blog/wp-admin/images/wordpress-logo.png?ver=20120216 HTTP/1.1" 200 2755 "http://mysite.com/blog/wp-admin/css/wp-admin.min.css?ver=3.5" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:30 -0600] "POST /blog/wp-login.php HTTP/1.1" 302 1066 "http://mysite.com/blog/wp-login.php?redirect_to=http%3A%2F%2Fmysite.com%2Fblog%2Fwp-admin%2F&reauth=1" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:31 -0600] "GET /blog/wp-admin/ HTTP/1.1" 200 16622 "http://mysite.com/blog/wp-login.php?redirect_to=http%3A%2F%2Fmysite.com%2Fblog%2Fwp-admin%2F&reauth=1" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:33 -0600] "GET /blog/wp-admin/load-styles.php?c=0&dir=ltr&load=admin-bar,wp-admin,buttons&ver=3.5 HTTP/1.1" 200 27126 "http://mysite.com/blog/wp-admin/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:33 -0600] "GET /blog/wp-includes/js/thickbox/thickbox.css?ver=20121105 HTTP/1.1" 200 1488 "http://mysite.com/blog/wp-admin/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:33 -0600] "GET /blog/wp-admin/css/colors-fresh.min.css?ver=3.5 HTTP/1.1" 304 195 "http://mysite.com/blog/wp-admin/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:34 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 304 195 "http://mysite.com/blog/wp-admin/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:34 -0600] "GET /blog/wp-includes/css/editor.min.css?ver=3.5 HTTP/1.1" 200 8063 "http://mysite.com/blog/wp-admin/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:33 -0600] "GET /blog/wp-admin/load-scripts.php?c=0&load[]=jquery,utils,json2&ver=3.5 HTTP/1.1" 200 35654 "http://mysite.com/blog/wp-admin/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:34 -0600] "GET /blog/wp-admin/load-styles.php?c=0&dir=ltr&load=media-views,wp-jquery-ui-dialog&ver=3.5 HTTP/1.1" 200 5804 "http://mysite.com/blog/wp-admin/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:34 -0600] "GET /blog/wp-content/plugins/tantan-s3/wordpress-s3/database.png HTTP/1.1" 200 665 "http://mysite.com/blog/wp-admin/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:34 -0600] "GET /blog/wp-content/plugins/codecolorer/js/quicktags.js?ver=0.9.9 HTTP/1.1" 200 788 "http://mysite.com/blog/wp-admin/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:34 -0600] "GET /blog/wp-admin/load-scripts.php?c=0&load[]=admin-bar,hoverIntent,common,wp-ajax-response,jquery-color,wp-lists,quicktags,jquery-query,admin-comments,jquery-ui-core,jquery-&load[]=ui-widget,jquery-ui-mouse,jquery-ui-sortable,postbox,dashboard,customize-base,customize-loader,thickbox,plugin-install,underscor&load[]=e,shortcode,media-upload,backbone,media-models,plupload,plupload-html5,plupload-flash,plupload-silverlight,plupload-html4,wp-plu&load[]=pload,media-views,media-editor,word-count,jquery-ui-resizable,jquery-ui-draggable,jquery-ui-button,jquery-ui-position,jquery-ui-&load[]=dialog,wpdialogs,wplink,wpdialogs-popup&ver=3.5 HTTP/1.1" 200 106562 "http://mysite.com/blog/wp-admin/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:35 -0600] "GET /blog/wp-admin/images/menu-shadow.png HTTP/1.1" 200 361 "http://mysite.com/blog/wp-admin/css/colors-fresh.min.css?ver=3.5" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:35 -0600] "GET /blog/wp-admin/images/menu.png?ver=20121105 HTTP/1.1" 200 9441 "http://mysite.com/blog/wp-admin/css/colors-fresh.min.css?ver=3.5" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:35 -0600] "GET /blog/wp-admin/images/arrows.png HTTP/1.1" 200 516 "http://mysite.com/blog/wp-admin/css/colors-fresh.min.css?ver=3.5" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:35 -0600] "GET /blog/wp-admin/images/icons32.png?ver=20121105 HTTP/1.1" 200 13266 "http://mysite.com/blog/wp-admin/css/colors-fresh.min.css?ver=3.5" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:35 -0600] "GET /blog/wp-includes/images/admin-bar-sprite.png?d=20120830 HTTP/1.1" 200 2745 "http://mysite.com/blog/wp-admin/load-styles.php?c=0&dir=ltr&load=admin-bar,wp-admin,buttons&ver=3.5" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:35 -0600] "GET /blog/wp-includes/js/thickbox/loadingAnimation.gif HTTP/1.1" 200 15515 "http://mysite.com/blog/wp-admin/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:38 -0600] "GET /blog/wp-admin/themes.php HTTP/1.1" 200 7817 "http://mysite.com/blog/wp-admin/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:39 -0600] "GET /blog/wp-includes/js/thickbox/thickbox.css?ver=20121105 HTTP/1.1" 304 194 "http://mysite.com/blog/wp-admin/themes.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:39 -0600] "GET /blog/wp-admin/css/colors-fresh.min.css?ver=3.5 HTTP/1.1" 304 194 "http://mysite.com/blog/wp-admin/themes.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:39 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 304 194 "http://mysite.com/blog/wp-admin/themes.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:39 -0600] "GET /blog/wp-content/themes/koi-improved/screenshot.png HTTP/1.1" 200 46197 "http://mysite.com/blog/wp-admin/themes.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:39 -0600] "GET /blog/wp-content/themes/thesis_185/screenshot.png HTTP/1.1" 200 77787 "http://mysite.com/blog/wp-admin/themes.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:39 -0600] "GET /blog/wp-admin/load-scripts.php?c=0&load[]=admin-bar,hoverIntent,common,thickbox,theme,customize-base,customize-loader&ver=3.5 HTTP/1.1" 200 12542 "http://mysite.com/blog/wp-admin/themes.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:37:39 -0600] "GET /blog/wp-content/plugins/codecolorer/js/quicktags.js?ver=0.9.9 HTTP/1.1" 304 193 "http://mysite.com/blog/wp-admin/themes.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:20 -0600] "GET /blog/wp-admin/images/wpspin_light.gif HTTP/1.1" 200 2469 "http://mysite.com/blog/wp-admin/load-styles.php?c=0&dir=ltr&load=admin-bar,wp-admin,buttons&ver=3.5" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:20 -0600] "GET /blog/wp-admin/customize.php HTTP/1.1" 200 2561 "http://mysite.com/blog/wp-admin/themes.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:21 -0600] "GET /blog/wp-admin/load-styles.php?c=0&dir=ltr&load=wp-admin,buttons,customize-controls&ver=3.5 HTTP/1.1" 200 26600 "http://mysite.com/blog/wp-admin/customize.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:21 -0600] "GET /blog/wp-admin/css/colors-fresh.min.css?ver=3.5 HTTP/1.1" 304 194 "http://mysite.com/blog/wp-admin/customize.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:21 -0600] "GET /blog/wp-admin/load-scripts.php?c=0&load[]=jquery,json2&ver=3.5 HTTP/1.1" 200 34984 "http://mysite.com/blog/wp-admin/customize.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:21 -0600] "GET /blog/wp-content/plugins/codecolorer/js/quicktags.js?ver=0.9.9 HTTP/1.1" 304 194 "http://mysite.com/blog/wp-admin/customize.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:21 -0600] "GET /blog/wp-admin/load-scripts.php?c=0&load[]=customize-base,customize-controls&ver=3.5 HTTP/1.1" 200 6755 "http://mysite.com/blog/wp-admin/customize.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:30 -0600] "POST /blog/ HTTP/1.1" 200 12486 "http://mysite.com/blog/wp-admin/customize.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:31 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 304 194 "http://mysite.com/blog/wp-admin/customize.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:31 -0600] "GET /blog/wp-includes/js/jquery/jquery.js?ver=1.8.3 HTTP/1.1" 200 33783 "http://mysite.com/blog/wp-admin/customize.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:31 -0600] "GET /blog/wp-includes/js/json2.min.js?ver=2011-02-23 HTTP/1.1" 200 1668 "http://mysite.com/blog/wp-admin/customize.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:31 -0600] "GET /blog/wp-includes/js/customize-base.min.js?ver=3.5 HTTP/1.1" 200 2452 "http://mysite.com/blog/wp-admin/customize.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:31 -0600] "GET /blog/wp-includes/js/customize-preview.min.js?ver=3.5 HTTP/1.1" 200 1209 "http://mysite.com/blog/wp-admin/customize.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:38:31 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 13438 "http://mysite.com/blog/wp-admin/customize.php" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:04:39:03 -0600] "GET / HTTP/1.1" 302 410 "-" "curl/7.21.4 (universal-apple-darwin11.0) libcurl/7.21.4 OpenSSL/0.9.8r zlib/1.2.5"
119.63.193.131 - - [15/Jan/2013:04:39:32 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
180.76.5.53 - - [15/Jan/2013:04:42:42 -0600] "GET /blog/tag/buenos-aires/ HTTP/1.1" 200 3370 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
178.189.105.18 - - [15/Jan/2013:04:48:09 -0600] "GET /blog/linux-shared-library-error/ HTTP/1.1" 200 3717 "http://www.google.at/url?sa=t&rct=j&q=error%20while%20loading%20shared%20libraries%20libcap.so.2&source=web&cd=4&ved=0CEMQFjAD&url=http%3A%2F%2Fmysite.com%2Fblog%2Flinux-shared-library-error%2F&ei=1DP1UOy2EI2q0AXXjYCgDg&usg=AFQjCNEqOGaw6N0t-o1fgvyTViwCNRQQzA&cad=rja" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:10 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:10 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:11 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:11 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:11 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:11 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:12 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:12 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:12 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:12 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:12 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:13 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
178.189.105.18 - - [15/Jan/2013:04:48:13 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.52 Safari/537.17"
218.213.130.168 - - [15/Jan/2013:04:50:32 -0600] "GET /robots.txt HTTP/1.1" 200 300 "-" "DoCoMo/2.0 P900i(c100;TB;W24H11) (compatible; ichiro/mobile goo; +http://search.goo.ne.jp/option/use/sub4/sub4-1/)"
189.34.211.228 - - [15/Jan/2013:05:27:36 -0600] "GET /blog/spicnspan/ HTTP/1.1" 200 19503 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
208.115.113.86 - - [15/Jan/2013:05:28:34 -0600] "GET /blog/date-palms-p1/ HTTP/1.1" 200 9969 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.113.86 - - [15/Jan/2013:05:28:37 -0600] "GET /blog/tag/spanish-resources/feed/ HTTP/1.1" 200 4654 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
66.249.74.38 - - [15/Jan/2013:05:34:48 -0600] "GET /blog/tag/osx-command-line/ HTTP/1.1" 200 2719 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
61.135.249.233 - - [15/Jan/2013:05:42:26 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.233 - - [15/Jan/2013:05:42:26 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.233 - - [15/Jan/2013:05:42:26 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
94.197.127.22 - - [15/Jan/2013:05:51:00 -0600] "GET /blog/osx-change-root-shell/ HTTP/1.1" 200 3490 "http://www.google.co.uk/url?sa=t&rct=j&q=&esrc=s&source=web&cd=5&ved=0CFIQFjAE&url=http%3A%2F%2Fmysite.com%2Fblog%2Fosx-change-root-shell%2F&ei=mUL1UI-rLc3N0AXh64D4Ag&usg=AFQjCNEtdT_TK4aA_LgmaTsGgaFHKRsDlg&bvm=bv.41018144,d.d2k" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:01 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:01 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:01 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:01 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:02 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:02 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:02 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:03 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:03 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 531 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:03 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:03 -0600] "GET /blog/wp-content/themes/koi-improved/img/cancel-reply.png HTTP/1.1" 200 587 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:04 -0600] "GET /blog/wp-content/themes/koi-improved/img/submit-btn.png HTTP/1.1" 200 1387 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:04 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:06 -0600] "GET /favicon.ico HTTP/1.1" 302 467 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
94.197.127.22 - - [15/Jan/2013:05:51:07 -0600] "GET /blog/ HTTP/1.1" 200 11692 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.14 (KHTML, like Gecko) Version/6.0.1 Safari/536.26.14"
123.151.148.207 - - [15/Jan/2013:05:53:49 -0600] "GET / HTTP/1.1" 302 467 "-" "Sosospider+(+http://help.soso.com/webspider.htm)"
123.151.148.207 - - [15/Jan/2013:05:53:50 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Sosospider+(+http://help.soso.com/webspider.htm)"
123.151.148.207 - - [15/Jan/2013:05:53:59 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/" "Sosospider+(+http://help.soso.com/webspider.htm)"
178.154.163.29 - - [15/Jan/2013:06:14:00 -0600] "GET /blog/tag/osx-lion/ HTTP/1.1" 200 2721 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
119.247.227.238 - - [15/Jan/2013:06:18:05 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
208.115.111.70 - - [15/Jan/2013:06:30:50 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
123.125.71.113 - - [15/Jan/2013:06:39:35 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.153 - - [15/Jan/2013:06:40:28 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
119.63.193.132 - - [15/Jan/2013:06:52:15 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
66.249.74.38 - - [15/Jan/2013:07:02:19 -0600] "GET / HTTP/1.1" 302 467 "-" "SAMSUNG-SGH-E250/1.0 Profile/MIDP-2.0 Configuration/CLDC-1.1 UP.Browser/6.2.3.3.c.1.101 (GUI) MMP/2.0 (compatible; Googlebot-Mobile/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [15/Jan/2013:07:02:20 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "SAMSUNG-SGH-E250/1.0 Profile/MIDP-2.0 Configuration/CLDC-1.1 UP.Browser/6.2.3.3.c.1.101 (GUI) MMP/2.0 (compatible; Googlebot-Mobile/2.1; +http://www.google.com/bot.html)"
178.154.163.29 - - [15/Jan/2013:07:11:13 -0600] "GET /blog/tag/carrot-soup/ HTTP/1.1" 200 2781 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
208.115.111.70 - - [15/Jan/2013:07:23:44 -0600] "GET /blog/tag/fixyourdamnwebsite/feed/ HTTP/1.1" 200 10668 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.111.70 - - [15/Jan/2013:07:23:47 -0600] "GET /blog/tag/osx-terminal/feed/ HTTP/1.1" 200 4588 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
65.55.213.66 - - [15/Jan/2013:07:42:33 -0600] "GET /robots.txt HTTP/1.1" 200 318 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [15/Jan/2013:07:42:33 -0600] "GET / HTTP/1.1" 302 430 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
65.55.213.66 - - [15/Jan/2013:07:42:35 -0600] "GET /blog/ HTTP/1.1" 200 11656 "-" "msnbot/2.0b (+http://search.msn.com/msnbot.htm)"
61.135.249.6 - - [15/Jan/2013:07:53:59 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.6 - - [15/Jan/2013:07:53:59 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.6 - - [15/Jan/2013:07:53:59 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
178.154.163.29 - - [15/Jan/2013:08:08:26 -0600] "GET /blog/tag/firefox-13-speed-dial/ HTTP/1.1" 200 2607 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
66.249.74.38 - - [15/Jan/2013:08:10:18 -0600] "GET /blog/tag/yellow-carrots/ HTTP/1.1" 200 2790 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
200.170.196.186 - - [15/Jan/2013:08:25:17 -0600] "GET /blog/linux-shared-library-error/ HTTP/1.1" 200 3717 "https://www.google.com.br/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:18 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:18 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:19 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:19 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:19 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11836 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:21 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 531 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:21 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:22 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:21 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:21 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:22 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/linux-shared-library-error/" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:23 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
200.170.196.186 - - [15/Jan/2013:08:25:23 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11"
208.115.113.86 - - [15/Jan/2013:08:29:46 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.113.86 - - [15/Jan/2013:08:29:46 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
209.85.238.38 - - [15/Jan/2013:08:30:07 -0600] "GET /blog/osx-change-root-shell/ HTTP/1.1" 200 3490 "-" "DoCoMo/2.0 N905i(c100;TB;W24H16) (compatible; Googlebot-Mobile/2.1; +http://www.google.com/bot.html)"
123.125.71.108 - - [15/Jan/2013:08:41:21 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.172 - - [15/Jan/2013:08:42:19 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
178.154.163.29 - - [15/Jan/2013:09:05:38 -0600] "GET /blog/tag/disable-firefox-speed-dial/ HTTP/1.1" 200 2602 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
202.46.58.169 - - [15/Jan/2013:09:14:58 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
119.63.193.194 - - [15/Jan/2013:09:16:14 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
180.76.5.154 - - [15/Jan/2013:09:25:42 -0600] "GET /blog/tag/beet-soup/ HTTP/1.1" 200 2630 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
195.36.64.80 - - [15/Jan/2013:09:28:08 -0600] "GET /blog/osx-change-root-shell/ HTTP/1.1" 200 3490 "http://www.google.de/url?sa=t&rct=j&q=&esrc=s&source=web&cd=3&ved=0CEUQFjAC&url=http%3A%2F%2Fmysite.com%2Fblog%2Fosx-change-root-shell%2F&ei=fnX1UMmNDIiphAedx4HwCw&usg=AFQjCNEtdT_TK4aA_LgmaTsGgaFHKRsDlg&bvm=bv.41018144,d.ZG4&cad=rja" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:08 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:09 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:09 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:09 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:09 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:09 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:09 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:10 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15312 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:10 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73678 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:10 -0600] "GET /blog/wp-content/themes/koi-improved/img/cancel-reply.png HTTP/1.1" 200 587 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:10 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:10 -0600] "GET /blog/wp-content/themes/koi-improved/img/submit-btn.png HTTP/1.1" 200 1387 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:10 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:12 -0600] "GET /favicon.ico HTTP/1.1" 302 467 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
195.36.64.80 - - [15/Jan/2013:09:28:12 -0600] "GET /blog/ HTTP/1.1" 200 11692 "http://mysite.com/blog/osx-change-root-shell/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:55 -0600] "GET /blog/basic-perl-log-function/ HTTP/1.1" 200 3733 "http://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=5&ved=0CFIQFjAE&url=http%3A%2F%2Fmysite.com%2Fblog%2Fbasic-perl-log-function%2F&ei=23X1UOGOLIWD0QGCrYCgCA&usg=AFQjCNFkYI8hjM3wM93rVUHTKc3Uk-8bSw&bvm=bv.41018144,d.dmQ" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:56 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2392 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:56 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4123 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:56 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:56 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:56 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:57 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:57 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
208.115.113.86 - - [15/Jan/2013:09:29:56 -0600] "GET /blog/category/freedom/ HTTP/1.1" 200 42512 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
173.161.213.235 - - [15/Jan/2013:09:29:57 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73678 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:57 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 531 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:56 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:57 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:58 -0600] "GET /favicon.ico HTTP/1.1" 302 467 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
173.161.213.235 - - [15/Jan/2013:09:29:58 -0600] "GET /blog/ HTTP/1.1" 200 11692 "http://mysite.com/blog/basic-perl-log-function/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
208.115.113.86 - - [15/Jan/2013:09:30:00 -0600] "GET /blog/tag/no-tabs/feed/ HTTP/1.1" 200 16125 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
208.115.113.86 - - [15/Jan/2013:09:30:03 -0600] "GET / HTTP/1.1" 302 410 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
66.170.193.118 - - [15/Jan/2013:09:40:52 -0600] "GET /blog/black-carrots/ HTTP/1.1" 200 3205 "http://www.swagbucks.com/?t=i&p=1&b=0&f=0&sef=1&q=black+carrots" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:53 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2392 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:53 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:53 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4123 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:53 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:53 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1759 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:53 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:53 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2231 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:53 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73678 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:53 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 531 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:53 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:53 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:54 -0600] "GET /favicon.ico HTTP/1.1" 302 467 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
66.170.193.118 - - [15/Jan/2013:09:40:54 -0600] "GET /blog/ HTTP/1.1" 200 11692 "http://mysite.com/blog/black-carrots/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/536.26.17 (KHTML, like Gecko) Version/6.0.2 Safari/536.26.17"
123.125.71.115 - - [15/Jan/2013:09:41:39 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.160 - - [15/Jan/2013:09:42:37 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
66.249.74.103 - - [15/Jan/2013:09:43:40 -0600] "GET /robots.txt HTTP/1.1" 302 467 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [15/Jan/2013:09:43:40 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.103 - - [15/Jan/2013:09:43:41 -0600] "GET / HTTP/1.1" 302 467 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [15/Jan/2013:09:43:41 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
106.187.97.211 - - [15/Jan/2013:10:09:42 -0600] "POST /blog/wp-cron.php?doing_wp_cron=1358266182.3757660388946533203125 HTTP/1.0" 200 203 "-" "WordPress/3.5; http://mysite.com/blog"
178.154.163.29 - - [15/Jan/2013:10:09:42 -0600] "GET /blog/dreaming-of-andalusia-oklahoma/ HTTP/1.1" 200 3247 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
178.154.163.29 - - [15/Jan/2013:10:34:47 -0600] "GET /blog/for-better-or-for-awesome/ HTTP/1.1" 200 3964 "-" "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)"
202.46.55.202 - - [15/Jan/2013:10:40:56 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
119.63.193.131 - - [15/Jan/2013:10:41:02 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
121.204.244.223 - - [15/Jan/2013:10:44:26 -0600] "GET /blog/analysis-chinese-phishing-scam/ HTTP/1.0" 200 11452 "http://mysite.com/blog/analysis-chinese-phishing-scam/" "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/535.19 (KHTML, like Gecko) Chrome/18.0.1025.1634 Safari/535.19 YI"
66.249.74.38 - - [15/Jan/2013:10:48:43 -0600] "GET /blog/ HTTP/1.1" 200 11693 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
61.135.248.189 - - [15/Jan/2013:10:54:49 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.189 - - [15/Jan/2013:10:54:50 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.248.189 - - [15/Jan/2013:10:54:50 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
123.125.71.90 - - [15/Jan/2013:10:58:38 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.174 - - [15/Jan/2013:11:00:58 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
1.202.218.21 - - [15/Jan/2013:11:03:50 -0600] "GET /robots.txt HTTP/1.1" 200 318 "-" "Mozilla/5.0 (compatible; JikeSpider; +http://shoulu.jike.com/spider.html)"
41.220.16.237 - - [15/Jan/2013:11:04:53 -0600] "GET /blog/things-every-internet-cafe-should-do-to-improve-service/ HTTP/1.1" 200 3658 "http://search.mywebsearch.com/mywebsearch/GGmain.jhtml?st=sb&ptb=6DC8F338-CE58-4A89-84F8-8D872CD0F6C7&n=77ee39f2&ind=2012101106&id=Z3xdm007YYzw&ptnrS=Z3xdm007YYzw&si=CODEu4ug97ICFQ1Z3godEA0AJA&searchfor=things+to+improve+at+the+internet+cafe" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:04:55 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/things-every-internet-cafe-should-do-to-improve-service/" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:04:55 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4123 "http://mysite.com/blog/things-every-internet-cafe-should-do-to-improve-service/" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:04:55 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 747 "http://mysite.com/blog/things-every-internet-cafe-should-do-to-improve-service/" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:04:55 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/things-every-internet-cafe-should-do-to-improve-service/" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:04:55 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/things-every-internet-cafe-should-do-to-improve-service/" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:04:59 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:04:59 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:05:00 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:04:59 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:04:59 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44307 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:04:59 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:05:12 -0600] "GET /favicon.ico HTTP/1.1" 302 467 "-" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
41.220.16.237 - - [15/Jan/2013:11:05:12 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Windows NT 5.1; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:39 -0600] "GET /blog/disable-speed-dial-feature-in-firefox-13/ HTTP/1.1" 200 3792 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:40 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4122 "http://mysite.com/blog/disable-speed-dial-feature-in-firefox-13/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:40 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "http://mysite.com/blog/disable-speed-dial-feature-in-firefox-13/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:40 -0600] "GET /blog/wp-includes/js/comment-reply.min.js?ver=3.5 HTTP/1.1" 200 746 "http://mysite.com/blog/disable-speed-dial-feature-in-firefox-13/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:40 -0600] "GET /blog/wp-content/themes/koi-improved/img/socialmedia/rss.png HTTP/1.1" 200 1760 "http://mysite.com/blog/disable-speed-dial-feature-in-firefox-13/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:40 -0600] "GET /blog/wp-content/themes/koi-improved/yellow.css HTTP/1.1" 404 11837 "http://mysite.com/blog/disable-speed-dial-feature-in-firefox-13/" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:42 -0600] "GET /blog/wp-content/themes/koi-improved/img/paper-bg.jpg HTTP/1.1" 200 15311 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:42 -0600] "GET /blog/wp-content/themes/koi-improved/img/top-illustration.gif HTTP/1.1" 200 73677 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:42 -0600] "GET /blog/wp-content/themes/koi-improved/img/header.gif HTTP/1.1" 200 61485 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:42 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-rule.png HTTP/1.1" 200 530 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:42 -0600] "GET /blog/wp-content/themes/koi-improved/img/post-nav-bg.png HTTP/1.1" 200 2232 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:42 -0600] "GET /blog/wp-content/themes/koi-improved/img/reply.png HTTP/1.1" 200 822 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:42 -0600] "GET /blog/wp-content/themes/koi-improved/img/submit-btn.png HTTP/1.1" 200 1388 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:42 -0600] "GET /blog/wp-content/themes/koi-improved/img/footer.gif HTTP/1.1" 200 44308 "http://mysite.com/blog/wp-content/themes/koi-improved/style.css" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:44 -0600] "GET /favicon.ico HTTP/1.1" 302 466 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
180.149.0.250 - - [15/Jan/2013:11:28:45 -0600] "GET /blog/ HTTP/1.1" 200 11692 "-" "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:18.0) Gecko/20100101 Firefox/18.0"
92.66.127.86 - - [15/Jan/2013:11:36:21 -0600] "HEAD / HTTP/1.1" 302 180 "-" "curl/7.21.4 (universal-apple-darwin11.0) libcurl/7.21.4 OpenSSL/0.9.8r zlib/1.2.5"
123.125.71.72 - - [15/Jan/2013:11:45:25 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.165 - - [15/Jan/2013:11:46:18 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
66.249.74.38 - - [15/Jan/2013:12:00:16 -0600] "GET /blog/date-palms-p1/ HTTP/1.1" 200 3520 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.76.189 - - [15/Jan/2013:12:04:50 -0600] "GET /blog/wp-content/plugins/codecolorer/codecolorer.css?ver=0.9.9 HTTP/1.1" 200 2393 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [15/Jan/2013:12:04:51 -0600] "GET /blog/wp-content/themes/thesis_185/custom/layout.css HTTP/1.1" 200 7009 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [15/Jan/2013:12:06:58 -0600] "GET /blog/wp-content/themes/koi-improved/style.css HTTP/1.1" 200 4123 "http://mysite.com/blog/date-palms-p1/" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
66.249.74.38 - - [15/Jan/2013:12:12:39 -0600] "GET /blog/page/2/ HTTP/1.1" 200 15313 "-" "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)"
188.165.230.147 - - [15/Jan/2013:12:24:32 -0600] "GET /robots.txt HTTP/1.1" 200 311 "http://www.finddotcom.com/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)"
188.165.230.147 - - [15/Jan/2013:12:24:33 -0600] "GET / HTTP/1.1" 403 426 "http://www.finddotcom.com/" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)"
208.115.113.86 - - [15/Jan/2013:12:27:41 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
123.125.71.112 - - [15/Jan/2013:12:39:05 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
220.181.108.173 - - [15/Jan/2013:12:39:55 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
119.63.193.194 - - [15/Jan/2013:12:51:12 -0600] "GET / HTTP/1.1" 302 429 "-" "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
180.76.5.192 - - [15/Jan/2013:13:15:13 -0600] "GET /blog/tag/japan/ HTTP/1.1" 200 3247 "-" "Mozilla/5.0 (compatible; Baiduspider/2.0; +http://www.baidu.com/search/spider.html)"
119.247.227.238 - - [15/Jan/2013:13:28:06 -0600] "GET /blog/ HTTP/1.1" 200 40506 "-" "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)"
92.66.127.86 - - [15/Jan/2013:13:31:06 -0600] "HEAD / HTTP/1.1" 302 180 "-" "curl/7.21.4 (universal-apple-darwin11.0) libcurl/7.21.4 OpenSSL/0.9.8r zlib/1.2.5"
92.66.127.86 - - [15/Jan/2013:13:31:10 -0600] "HEAD / HTTP/1.1" 302 180 "-" "curl/7.21.4 (universal-apple-darwin11.0) libcurl/7.21.4 OpenSSL/0.9.8r zlib/1.2.5"
92.66.127.86 - - [15/Jan/2013:13:31:16 -0600] "HEAD /blog HTTP/1.1" 301 192 "-" "curl/7.21.4 (universal-apple-darwin11.0) libcurl/7.21.4 OpenSSL/0.9.8r zlib/1.2.5"
92.66.127.86 - - [15/Jan/2013:13:31:19 -0600] "HEAD /blog/ HTTP/1.1" 200 135 "-" "curl/7.21.4 (universal-apple-darwin11.0) libcurl/7.21.4 OpenSSL/0.9.8r zlib/1.2.5"
208.115.113.86 - - [15/Jan/2013:13:31:23 -0600] "GET /blog/life-list/ HTTP/1.1" 200 6153 "-" "Mozilla/5.0 (compatible; Ezooms/1.0; ezooms.bot@gmail.com)"
92.66.127.86 - - [15/Jan/2013:13:31:49 -0600] "HEAD /blog/ HTTP/1.1" 200 135 "-" "curl/7.21.4 (universal-apple-darwin11.0) libcurl/7.21.4 OpenSSL/0.9.8r zlib/1.2.5"
92.66.127.86 - - [15/Jan/2013:13:33:03 -0600] "HEAD /files/ HTTP/1.1" 200 134 "-" "curl/7.21.4 (universal-apple-darwin11.0) libcurl/7.21.4 OpenSSL/0.9.8r zlib/1.2.5"
92.66.127.86 - - [15/Jan/2013:13:33:06 -0600] "GET /files/ HTTP/1.1" 200 978 "-" "curl/7.21.4 (universal-apple-darwin11.0) libcurl/7.21.4 OpenSSL/0.9.8r zlib/1.2.5"
187.163.90.68 - - [15/Jan/2013:13:40:12 -0600] "GET /blog/feed/ HTTP/1.1" 304 203 "-" "Windows-RSS-Platform/2.0 (MSIE 9.0; Windows NT 6.1)"
61.135.249.113 - - [15/Jan/2013:13:41:47 -0600] "GET / HTTP/1.1" 302 411 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.113 - - [15/Jan/2013:13:41:47 -0600] "GET /robots.txt HTTP/1.1" 200 255 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
61.135.249.113 - - [15/Jan/2013:13:41:47 -0600] "GET /blog/ HTTP/1.1" 200 11637 "-" "Mozilla/5.0 (compatible; YodaoBot/1.0; http://www.yodao.com/help/webmaster/spider/; )"
