use PkgConfig;
my $nss_config = PkgConfig->find('nss');
if ($nss_config->errmsg) {
    die "To build this module you need NSS installed!";
}
# This Makefile.PL for Panda-NSS was generated by
# inc::DistMakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.22.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.006;

use ExtUtils::MakeMaker;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Perl bindings to NSS Mozilla security library",
  "AUTHOR" => "Vladimir Timofeev <vovkasm\@gmail.com>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "PkgConfig" => "0.08320"
  },
  "DISTNAME" => "Panda-NSS",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Panda::NSS",
  "PREREQ_PM" => {
    "XSLoader" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "File::Spec::Functions" => 0,
    "File::Temp" => 0,
    "List::Util" => 0,
    "Scalar::Util" => 0,
    "Test::More" => 0,
    "Test::SharedFork" => 0
  },
  "VERSION" => "0.001",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    CCFLAGS => join(' ',$nss_config->get_cflags),
    LIBS => [ join(' ',$nss_config->get_ldflags) ],
);

my %FallbackPrereqs = (
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "File::Spec::Functions" => 0,
  "File::Temp" => 0,
  "List::Util" => 0,
  "Scalar::Util" => 0,
  "Test::More" => 0,
  "Test::SharedFork" => 0,
  "XSLoader" => 0,
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



