use strict;
use warnings;
use Test::More;
use utf8;
use DateTime;
use JSON qw(decode_json);
# Test bed for unary operators.
use_ok("WWW::Shopify::Liquid");
use_ok("WWW::Shopify::Liquid::Operator");
use_ok("WWW::Shopify::Liquid::Lexer");
use_ok("WWW::Shopify::Liquid::Parser");
use_ok("WWW::Shopify::Liquid::Optimizer");
use_ok("WWW::Shopify::Liquid::Renderer");
my $liquid = WWW::Shopify::Liquid->new;
use Time::HiRes qw(time);

my $initial = time;
my $ast = $liquid->parse_text('{% capture countries %}{"Åland Islands":"Aland Islands","Albania":"Albania","Algeria":"Algeria","Andorra":"Andorra","Angola":"Angola","Anguilla":"Anguilla","Antigua &amp; Barbuda":"Antigua And Barbuda","Argentina":"Argentina","Armenia":"Armenia","Aruba":"Aruba","Australia":"Australia","Austria":"Austria","Azerbaijan":"Azerbaijan","Bahamas":"Bahamas","Bahrain":"Bahrain","Bangladesh":"Bangladesh","Barbados":"Barbados","Belarus":"Belarus","Belgium":"Belgium","Belize":"Belize","Benin":"Benin","Bermuda":"Bermuda","Bhutan":"Bhutan","Bolivia":"Bolivia","Bosnia &amp; Herzegovina":"Bosnia And Herzegovina","Botswana":"Botswana","Bouvet Island":"Bouvet Island","Brazil":"Brazil","British Indian Ocean Territory":"British Indian Ocean Territory","British Virgin Islands":"Virgin Islands, British","Brunei":"Brunei","Bulgaria":"Bulgaria","Burkina Faso":"Burkina Faso","Burundi":"Burundi","Cambodia":"Cambodia","Cameroon":"Republic of Cameroon","Canada":"Canada","Cape Verde":"Cape Verde","Cayman Islands":"Cayman Islands","Central African Republic":"Central African Republic","Chad":"Chad","Chile":"Chile","China":"China","Christmas Island":"Christmas Island","Cocos (Keeling) Islands":"Cocos (Keeling) Islands","Colombia":"Colombia","Comoros":"Comoros","Congo - Brazzaville":"Congo","Congo - Kinshasa":"Congo, The Democratic Republic Of The","Cook Islands":"Cook Islands","Costa Rica":"Costa Rica","Croatia":"Croatia","Cuba":"Cuba","Curaçao":"Curaçao","Cyprus":"Cyprus","Czech Republic":"Czech Republic","Côte d’Ivoire":"Côte d\'Ivoire","Denmark":"Denmark","Djibouti":"Djibouti","Dominica":"Dominica","Dominican Republic":"Dominican Republic","Ecuador":"Ecuador","Egypt":"Egypt","El Salvador":"El Salvador","Equatorial Guinea":"Equatorial Guinea","Eritrea":"Eritrea","Estonia":"Estonia","Ethiopia":"Ethiopia","Falkland Islands":"Falkland Islands (Malvinas)","Faroe Islands":"Faroe Islands","Fiji":"Fiji","Finland":"Finland","France":"France","French Guiana":"French Guiana","French Polynesia":"French Polynesia","French Southern Territories":"French Southern Territories","Gabon":"Gabon","Gambia":"Gambia","Georgia":"Georgia","Germany":"Germany","Ghana":"Ghana","Gibraltar":"Gibraltar","Greece":"Greece","Greenland":"Greenland","Grenada":"Grenada","Guadeloupe":"Guadeloupe","Guatemala":"Guatemala","Guernsey":"Guernsey","Guinea":"Guinea","Guinea-Bissau":"Guinea Bissau","Guyana":"Guyana","Haiti":"Haiti","Heard &amp; McDonald Islands":"Heard Island And Mcdonald Islands","Honduras":"Honduras","Hong Kong SAR China":"Hong Kong","Hungary":"Hungary","Iceland":"Iceland","India":"India","Indonesia":"Indonesia","Iran":"Iran, Islamic Republic Of","Iraq":"Iraq","Ireland":"Ireland","Isle of Man":"Isle Of Man","Israel":"Israel","Italy":"Italy","Jamaica":"Jamaica","Japan":"Japan","Jersey":"Jersey","Jordan":"Jordan","Kazakhstan":"Kazakhstan","Kenya":"Kenya","Kiribati":"Kiribati","Kosovo":"Kosovo","Kuwait":"Kuwait","Kyrgyzstan":"Kyrgyzstan","Laos":"Lao People\'s Democratic Republic","Latvia":"Latvia","Lebanon":"Lebanon","Lesotho":"Lesotho","Liberia":"Liberia","Libya":"Libyan Arab Jamahiriya","Liechtenstein":"Liechtenstein","Lithuania":"Lithuania","Luxembourg":"Luxembourg","Macau SAR China":"Macao","Macedonia":"Macedonia, Republic Of","Madagascar":"Madagascar","Malawi":"Malawi","Malaysia":"Malaysia","Maldives":"Maldives","Mali":"Mali","Malta":"Malta","Martinique":"Martinique","Mauritania":"Mauritania","Mauritius":"Mauritius","Mayotte":"Mayotte","Mexico":"Mexico","Moldova":"Moldova, Republic of","Monaco":"Monaco","Mongolia":"Mongolia","Montenegro":"Montenegro","Montserrat":"Montserrat","Morocco":"Morocco","Mozambique":"Mozambique","Myanmar (Burma)":"Myanmar","Namibia":"Namibia","Nauru":"Nauru","Nepal":"Nepal","Netherlands":"Netherlands","Netherlands Antilles":"Netherlands Antilles","New Caledonia":"New Caledonia","New Zealand":"New Zealand","Nicaragua":"Nicaragua","Niger":"Niger","Nigeria":"Nigeria","Niue":"Niue","Norfolk Island":"Norfolk Island","North Korea":"Korea, Democratic People\'s Republic Of","Norway":"Norway","Oman":"Oman","Pakistan":"Pakistan","Palestinian Territories":"Palestinian Territory, Occupied","Panama":"Panama","Papua New Guinea":"Papua New Guinea","Paraguay":"Paraguay","Peru":"Peru","Philippines":"Philippines","Pitcairn Islands":"Pitcairn","Poland":"Poland","Portugal":"Portugal","Qatar":"Qatar","Réunion":"Reunion","Romania":"Romania","Russia":"Russia","Rwanda":"Rwanda","Samoa":"Samoa","San Marino":"San Marino","São Tomé &amp; Príncipe":"Sao Tome And Principe","Saudi Arabia":"Saudi Arabia","Senegal":"Senegal","Serbia":"Serbia","Seychelles":"Seychelles","Sierra Leone":"Sierra Leone","Singapore":"Singapore","Sint Maarten":"Sint Maarten","Slovakia":"Slovakia","Slovenia":"Slovenia","Solomon Islands":"Solomon Islands","Somalia":"Somalia","South Africa":"South Africa","South Georgia &amp; South Sandwich Islands":"South Georgia And The South Sandwich Islands","South Korea":"South Korea","Spain":"Spain","Sri Lanka":"Sri Lanka","St. Barthélemy":"Saint Barthélemy","St. Helena":"Saint Helena","St. Kitts &amp; Nevis":"Saint Kitts And Nevis","St. Lucia":"Saint Lucia","St. Martin":"Saint Martin","St. Pierre &amp; Miquelon":"Saint Pierre And Miquelon","St. Vincent &amp; Grenadines":"St. Vincent","Sudan":"Sudan","Suriname":"Suriname","Svalbard &amp; Jan Mayen":"Svalbard And Jan Mayen","Swaziland":"Swaziland","Sweden":"Sweden","Switzerland":"Switzerland","Syria":"Syria","Taiwan":"Taiwan","Tajikistan":"Tajikistan","Tanzania":"Tanzania, United Republic Of","Thailand":"Thailand","Timor-Leste":"Timor Leste","Togo":"Togo","Tokelau":"Tokelau","Tonga":"Tonga","Trinidad &amp; Tobago":"Trinidad and Tobago","Tunisia":"Tunisia","Turkey":"Turkey","Turkmenistan":"Turkmenistan","Turks &amp; Caicos Islands":"Turks and Caicos Islands","Tuvalu":"Tuvalu","U.S. Outlying Islands":"United States Minor Outlying Islands","Uganda":"Uganda","Ukraine":"Ukraine","United Arab Emirates":"United Arab Emirates","United Kingdom":"United Kingdom","United States":"United States","Uruguay":"Uruguay","Uzbekistan":"Uzbekistan","Vanuatu":"Vanuatu","Vatican City":"Holy See (Vatican City State)","Venezuela":"Venezuela","Vietnam":"Vietnam","Wallis &amp; Futuna":"Wallis And Futuna","Western Sahara":"Western Sahara","Yemen":"Yemen","Zambia":"Zambia","Zimbabwe":"Zimbabwe"}{% endcapture %}
{% assign countries = countries | json %}
{% assign country_keys = countries | keys | sort %}
{% for country in country_keys %}
	dfasfsd
	<option {% if (!contact_country and country == shop.country) or countries[country] == contact_country %}selected{% endif %} value="{{ countries[country] }}">{{ country }}</option>
{% endfor %}
CCCC');
$initial = time;
$ast = $liquid->optimizer->optimize({ contact_country => undef, shop => { country => "Algeria" } }, $ast);
$initial = time;
#print STDERR Dumper($ast);
my $text = $liquid->renderer->render({ }, $ast);
use Data::Dumper;
#print STDERR Dumper($ast);
#print STDERR "Took: " . (time - $initial) . "\n";
#print STDERR "TEXT: $text\n";

done_testing();