# Generated by default/object.tt
package Paws::AppMesh::GrpcGatewayRouteAction;
  use Moose;
  has Rewrite => (is => 'ro', isa => 'Paws::AppMesh::GrpcGatewayRouteRewrite', request_name => 'rewrite', traits => ['NameInRequest']);
  has Target => (is => 'ro', isa => 'Paws::AppMesh::GatewayRouteTarget', request_name => 'target', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::GrpcGatewayRouteAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::GrpcGatewayRouteAction object:

  $service_obj->Method(Att1 => { Rewrite => $value, ..., Target => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::GrpcGatewayRouteAction object:

  $result = $service_obj->Method(...);
  $result->Att1->Rewrite

=head1 DESCRIPTION

An object that represents the action to take if a match is determined.

=head1 ATTRIBUTES


=head2 Rewrite => L<Paws::AppMesh::GrpcGatewayRouteRewrite>

The gateway route action to rewrite.


=head2 B<REQUIRED> Target => L<Paws::AppMesh::GatewayRouteTarget>

An object that represents the target that traffic is routed to when a
request matches the gateway route.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

