#============================================================= -*-Perl-*-
#
# Template::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Andy Wardley   <abw@wardley.org>
#
# COPYRIGHT
#   Copyright (C) 1996-2014 Andy Wardley.  All Rights Reserved.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
# IMPORTANT NOTE
#   This module is constructed from the parser/Grammar.pm.skel file by
#   running the parser/yc script.  You only need to do this if # you
#   have modified the grammar in the parser/Parser.yp file and need #
#   to-recompile it.  See the README in the 'parser' directory for
#   more information (sub-directory of the Template distribution).
#
#========================================================================

package Template::Grammar;

use strict;
use warnings;

our $VERSION  = '3.003';

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================

# Reserved words, comparison and binary operators
#========================================================================

BEGIN {
@RESERVED = qw(
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE PLUGIN FILTER MACRO PERL RAWPERL TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform
# stringwise comparison (mainly because it doesn't generate "non-numerical
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al,
# briefly for v2.04d and then took them out again in 2.04e.


%CMPOP = qw(
    != ne
    == eq
    <  <
    >  >
    >= >=
    <= <=
);

#    eq eq  # add these lines to the above to
#    lt lt  # enable the eq, lt and gt operators
#    gt gt

#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case,
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens }
			= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}

} # --- END BEGIN

#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
		LEXTABLE => $LEXTABLE,
		STATES   => $STATES,
		RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


BEGIN {
#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 46,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'template' => 68,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 1
		DEFAULT => -176,
		GOTOS => {
			'quoted' => 74
		}
	},
	{#State 2
		ACTIONS => {
			'IDENT' => 75
		}
	},
	{#State 3
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'ident' => 77,
			'item' => 57,
			'node' => 61,
			'sterm' => 78
		}
	},
	{#State 4
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 20,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'assign' => 79,
			'expr' => 80,
			'ident' => 81,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 5
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"[" => 5,
			"]" => 82,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'ident' => 77,
			'item' => 57,
			'list' => 83,
			'lterm' => 59,
			'node' => 61,
			'range' => 84,
			'sterm' => 85,
			'term' => 86
		}
	},
	{#State 6
		ACTIONS => {
			"\$" => 2,
			"\${" => 3,
			'IDENT' => 15,
			'LITERAL' => 87
		},
		DEFAULT => -119,
		GOTOS => {
			'hash' => 88,
			'item' => 89,
			'param' => 90,
			'params' => 91
		}
	},
	{#State 7
		ACTIONS => {
			'FILENAME' => 92,
			'IDENT' => 93,
			'LITERAL' => 94,
			'NUMBER' => 95
		},
		DEFAULT => -87,
		GOTOS => {
			'blockargs' => 96,
			'blockname' => 97,
			'filename' => 98,
			'filepart' => 99,
			'meta' => 100,
			'metadata' => 101
		}
	},
	{#State 8
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 102,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 9
		DEFAULT => -38
	},
	{#State 10
		ACTIONS => {
			"\"" => 103,
			"\$" => 104,
			'FILENAME' => 92,
			'IDENT' => 105,
			'LITERAL' => 106,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'name' => 108,
			'nameargs' => 109,
			'names' => 110
		}
	},
	{#State 11
		ACTIONS => {
			"\$" => 2,
			"\${" => 3,
			'IDENT' => 15,
			'LITERAL' => 111
		},
		GOTOS => {
			'assign' => 43,
			'ident' => 112,
			'item' => 57,
			'node' => 61,
			'setlist' => 113
		}
	},
	{#State 12
		ACTIONS => {
			"\"" => 114,
			"\$" => 115,
			"\${" => 3,
			'FILENAME' => 92,
			'IDENT' => 116,
			'LITERAL' => 117,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'item' => 118,
			'lnameargs' => 119,
			'lvalue' => 120,
			'name' => 108,
			'nameargs' => 121,
			'names' => 110
		}
	},
	{#State 13
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"[" => 5,
			"{" => 6,
			'IDENT' => 122,
			'LITERAL' => 76,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'ident' => 77,
			'item' => 57,
			'loopvar' => 123,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 124
		}
	},
	{#State 14
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 125,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 15
		DEFAULT => -130
	},
	{#State 16
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 126,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 17
		ACTIONS => {
			"\"" => 103,
			"\$" => 104,
			'FILENAME' => 92,
			'IDENT' => 105,
			'LITERAL' => 106,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'name' => 108,
			'nameargs' => 127,
			'names' => 110
		}
	},
	{#State 18
		ACTIONS => {
			"\"" => 103,
			"\$" => 104,
			'FILENAME' => 92,
			'IDENT' => 105,
			'LITERAL' => 106,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'name' => 108,
			'nameargs' => 128,
			'names' => 110
		}
	},
	{#State 19
		DEFAULT => -39
	},
	{#State 20
		ACTIONS => {
			'ASSIGN' => 129
		},
		DEFAULT => -112
	},
	{#State 21
		ACTIONS => {
			'IDENT' => 130
		}
	},
	{#State 22
		ACTIONS => {
			'IDENT' => 131
		},
		GOTOS => {
			'meta' => 100,
			'metadata' => 132
		}
	},
	{#State 23
		DEFAULT => -40
	},
	{#State 24
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 133,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 25
		DEFAULT => -113
	},
	{#State 26
		ACTIONS => {
			";" => 134
		}
	},
	{#State 27
		ACTIONS => {
			"\"" => 103,
			"\$" => 104,
			'FILENAME' => 92,
			'IDENT' => 105,
			'LITERAL' => 106,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'name' => 108,
			'nameargs' => 135,
			'names' => 110
		}
	},
	{#State 28
		DEFAULT => -78,
		GOTOS => {
			'@5-1' => 136
		}
	},
	{#State 29
		ACTIONS => {
			"\$" => 2,
			"\${" => 3,
			'IDENT' => 15
		},
		GOTOS => {
			'ident' => 137,
			'item' => 57,
			'node' => 61
		}
	},
	{#State 30
		DEFAULT => -36
	},
	{#State 31
		ACTIONS => {
			"\$" => 2,
			"\${" => 3,
			'IDENT' => 15,
			'LITERAL' => 111
		},
		GOTOS => {
			'assign' => 43,
			'ident' => 112,
			'item' => 57,
			'node' => 61,
			'setlist' => 138
		}
	},
	{#State 32
		DEFAULT => -37
	},
	{#State 33
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 139,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 34
		DEFAULT => -6
	},
	{#State 35
		ACTIONS => {
			"\"" => 103,
			"\$" => 104,
			'FILENAME' => 92,
			'IDENT' => 105,
			'LITERAL' => 106,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'name' => 108,
			'nameargs' => 140,
			'names' => 110
		}
	},
	{#State 36
		ACTIONS => {
			";" => 141
		}
	},
	{#State 37
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 142,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 38
		ACTIONS => {
			"\"" => 114,
			"\$" => 115,
			"\${" => 3,
			'FILENAME' => 92,
			'IDENT' => 116,
			'LITERAL' => 117,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'item' => 118,
			'lnameargs' => 143,
			'lvalue' => 120,
			'name' => 108,
			'nameargs' => 121,
			'names' => 110
		}
	},
	{#State 39
		ACTIONS => {
			"\"" => 103,
			"\$" => 104,
			'FILENAME' => 92,
			'IDENT' => 105,
			'LITERAL' => 106,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'name' => 108,
			'nameargs' => 144,
			'names' => 110
		}
	},
	{#State 40
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 145,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 41
		ACTIONS => {
			"\"" => 103,
			"\$" => 104,
			'FILENAME' => 92,
			'IDENT' => 105,
			'LITERAL' => 106,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'name' => 108,
			'nameargs' => 146,
			'names' => 110
		}
	},
	{#State 42
		DEFAULT => -10
	},
	{#State 43
		DEFAULT => -149
	},
	{#State 44
		ACTIONS => {
			";" => -20
		},
		DEFAULT => -27
	},
	{#State 45
		ACTIONS => {
			'FILTER' => 147,
			'FOR' => 148,
			'IF' => 149,
			'UNLESS' => 150,
			'WHILE' => 151,
			'WRAPPER' => 152
		}
	},
	{#State 46
		DEFAULT => -1
	},
	{#State 47
		DEFAULT => -11
	},
	{#State 48
		DEFAULT => -5
	},
	{#State 49
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -2,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'capture' => 47,
			'chunk' => 153,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 50
		DEFAULT => -21
	},
	{#State 51
		DEFAULT => -9
	},
	{#State 52
		ACTIONS => {
			'IDENT' => 131
		},
		DEFAULT => -87,
		GOTOS => {
			'blockargs' => 154,
			'meta' => 100,
			'metadata' => 101
		}
	},
	{#State 53
		DEFAULT => -8
	},
	{#State 54
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			";" => -16,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -26
	},
	{#State 55
		DEFAULT => -43
	},
	{#State 56
		ACTIONS => {
			'ASSIGN' => 165,
			'DOT' => 166
		},
		DEFAULT => -109
	},
	{#State 57
		ACTIONS => {
			"(" => 167
		},
		DEFAULT => -128
	},
	{#State 58
		DEFAULT => -23
	},
	{#State 59
		DEFAULT => -103
	},
	{#State 60
		DEFAULT => -12
	},
	{#State 61
		DEFAULT => -127
	},
	{#State 62
		DEFAULT => -25
	},
	{#State 63
		DEFAULT => -15
	},
	{#State 64
		ACTIONS => {
			"\$" => 2,
			"\${" => 3,
			'COMMA' => 168,
			'IDENT' => 15,
			'LITERAL' => 111
		},
		DEFAULT => -19,
		GOTOS => {
			'assign' => 169,
			'ident' => 112,
			'item' => 57,
			'node' => 61
		}
	},
	{#State 65
		ACTIONS => {
			";" => 170
		}
	},
	{#State 66
		DEFAULT => -104
	},
	{#State 67
		DEFAULT => -22
	},
	{#State 68
		ACTIONS => {
			'' => 171
		}
	},
	{#State 69
		DEFAULT => -146
	},
	{#State 70
		DEFAULT => -24
	},
	{#State 71
		DEFAULT => -13
	},
	{#State 72
		DEFAULT => -14
	},
	{#State 73
		DEFAULT => -42
	},
	{#State 74
		ACTIONS => {
			"\"" => 172,
			"\$" => 2,
			"\${" => 3,
			";" => 173,
			'IDENT' => 15,
			'TEXT' => 174
		},
		GOTOS => {
			'ident' => 175,
			'item' => 57,
			'node' => 61,
			'quotable' => 176
		}
	},
	{#State 75
		DEFAULT => -132
	},
	{#State 76
		DEFAULT => -112
	},
	{#State 77
		ACTIONS => {
			'DOT' => 166
		},
		DEFAULT => -109
	},
	{#State 78
		ACTIONS => {
			"}" => 177
		}
	},
	{#State 79
		ACTIONS => {
			")" => 178
		}
	},
	{#State 80
		ACTIONS => {
			")" => 179,
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		}
	},
	{#State 81
		ACTIONS => {
			'ASSIGN' => 180,
			'DOT' => 166
		},
		DEFAULT => -109
	},
	{#State 82
		DEFAULT => -107
	},
	{#State 83
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"[" => 5,
			"]" => 181,
			"{" => 6,
			'COMMA' => 182,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 183
		}
	},
	{#State 84
		ACTIONS => {
			"]" => 184
		}
	},
	{#State 85
		ACTIONS => {
			'TO' => 185
		},
		DEFAULT => -104
	},
	{#State 86
		DEFAULT => -116
	},
	{#State 87
		ACTIONS => {
			'ASSIGN' => 186
		}
	},
	{#State 88
		ACTIONS => {
			"}" => 187
		}
	},
	{#State 89
		ACTIONS => {
			'ASSIGN' => 188
		}
	},
	{#State 90
		DEFAULT => -122
	},
	{#State 91
		ACTIONS => {
			"\$" => 2,
			"\${" => 3,
			'COMMA' => 189,
			'IDENT' => 15,
			'LITERAL' => 87
		},
		DEFAULT => -118,
		GOTOS => {
			'item' => 89,
			'param' => 190
		}
	},
	{#State 92
		DEFAULT => -172
	},
	{#State 93
		ACTIONS => {
			'ASSIGN' => 191
		},
		DEFAULT => -173
	},
	{#State 94
		DEFAULT => -85
	},
	{#State 95
		DEFAULT => -174
	},
	{#State 96
		ACTIONS => {
			";" => 192
		}
	},
	{#State 97
		DEFAULT => -83
	},
	{#State 98
		ACTIONS => {
			'DOT' => 193
		},
		DEFAULT => -84
	},
	{#State 99
		DEFAULT => -171
	},
	{#State 100
		DEFAULT => -99
	},
	{#State 101
		ACTIONS => {
			'COMMA' => 194,
			'IDENT' => 131
		},
		DEFAULT => -86,
		GOTOS => {
			'meta' => 195
		}
	},
	{#State 102
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -29
	},
	{#State 103
		DEFAULT => -176,
		GOTOS => {
			'quoted' => 196
		}
	},
	{#State 104
		ACTIONS => {
			"\$" => 2,
			"\${" => 3,
			'IDENT' => 15
		},
		GOTOS => {
			'ident' => 197,
			'item' => 57,
			'node' => 61
		}
	},
	{#State 105
		DEFAULT => -173
	},
	{#State 106
		DEFAULT => -169
	},
	{#State 107
		ACTIONS => {
			'DOT' => 193
		},
		DEFAULT => -168
	},
	{#State 108
		DEFAULT => -166
	},
	{#State 109
		DEFAULT => -41
	},
	{#State 110
		ACTIONS => {
			"(" => 198,
			"+" => 199
		},
		DEFAULT => -156,
		GOTOS => {
			'args' => 200
		}
	},
	{#State 111
		ACTIONS => {
			'ASSIGN' => 129
		}
	},
	{#State 112
		ACTIONS => {
			'ASSIGN' => 180,
			'DOT' => 166
		}
	},
	{#State 113
		ACTIONS => {
			"\$" => 2,
			"\${" => 3,
			'COMMA' => 168,
			'IDENT' => 15,
			'LITERAL' => 111
		},
		DEFAULT => -31,
		GOTOS => {
			'assign' => 169,
			'ident' => 112,
			'item' => 57,
			'node' => 61
		}
	},
	{#State 114
		DEFAULT => -176,
		GOTOS => {
			'quoted' => 201
		}
	},
	{#State 115
		ACTIONS => {
			"\$" => 2,
			"\${" => 3,
			'IDENT' => 202
		},
		GOTOS => {
			'ident' => 197,
			'item' => 57,
			'node' => 61
		}
	},
	{#State 116
		ACTIONS => {
			'ASSIGN' => -130
		},
		DEFAULT => -173
	},
	{#State 117
		ACTIONS => {
			'ASSIGN' => -161
		},
		DEFAULT => -169
	},
	{#State 118
		DEFAULT => -159
	},
	{#State 119
		ACTIONS => {
			";" => 203
		}
	},
	{#State 120
		ACTIONS => {
			'ASSIGN' => 204
		}
	},
	{#State 121
		DEFAULT => -158
	},
	{#State 122
		ACTIONS => {
			'ASSIGN' => 205,
			'IN' => 206
		},
		DEFAULT => -130
	},
	{#State 123
		ACTIONS => {
			";" => 207
		}
	},
	{#State 124
		DEFAULT => -156,
		GOTOS => {
			'args' => 208
		}
	},
	{#State 125
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -28
	},
	{#State 126
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			";" => 209,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		}
	},
	{#State 127
		DEFAULT => -33
	},
	{#State 128
		DEFAULT => -32
	},
	{#State 129
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 210,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 130
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 211,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 212,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		GOTOS => {
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'condition' => 50,
			'directive' => 213,
			'expr' => 214,
			'filter' => 55,
			'ident' => 81,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'mdir' => 215,
			'node' => 61,
			'perl' => 62,
			'setlist' => 64,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'wrapper' => 73
		}
	},
	{#State 131
		ACTIONS => {
			'ASSIGN' => 191
		}
	},
	{#State 132
		ACTIONS => {
			'COMMA' => 194,
			'IDENT' => 131
		},
		DEFAULT => -17,
		GOTOS => {
			'meta' => 195
		}
	},
	{#State 133
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163
		},
		DEFAULT => -142
	},
	{#State 134
		DEFAULT => -76,
		GOTOS => {
			'@4-2' => 216
		}
	},
	{#State 135
		DEFAULT => -34
	},
	{#State 136
		ACTIONS => {
			";" => 217
		}
	},
	{#State 137
		ACTIONS => {
			'DOT' => 166
		},
		DEFAULT => -110
	},
	{#State 138
		ACTIONS => {
			"\$" => 2,
			"\${" => 3,
			'COMMA' => 168,
			'IDENT' => 15,
			'LITERAL' => 111
		},
		DEFAULT => -30,
		GOTOS => {
			'assign' => 169,
			'ident' => 112,
			'item' => 57,
			'node' => 61
		}
	},
	{#State 139
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			";" => 218,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		}
	},
	{#State 140
		DEFAULT => -35
	},
	{#State 141
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 219,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 142
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			";" => 220,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		}
	},
	{#State 143
		DEFAULT => -73
	},
	{#State 144
		ACTIONS => {
			";" => 221
		}
	},
	{#State 145
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			";" => 222,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		}
	},
	{#State 146
		ACTIONS => {
			";" => 223
		}
	},
	{#State 147
		ACTIONS => {
			"\"" => 114,
			"\$" => 115,
			"\${" => 3,
			'FILENAME' => 92,
			'IDENT' => 116,
			'LITERAL' => 117,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'item' => 118,
			'lnameargs' => 224,
			'lvalue' => 120,
			'name' => 108,
			'nameargs' => 121,
			'names' => 110
		}
	},
	{#State 148
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"[" => 5,
			"{" => 6,
			'IDENT' => 122,
			'LITERAL' => 76,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'ident' => 77,
			'item' => 57,
			'loopvar' => 225,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 124
		}
	},
	{#State 149
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 226,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 150
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 227,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 151
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 228,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 152
		ACTIONS => {
			"\"" => 103,
			"\$" => 104,
			'FILENAME' => 92,
			'IDENT' => 105,
			'LITERAL' => 106,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'name' => 108,
			'nameargs' => 229,
			'names' => 110
		}
	},
	{#State 153
		DEFAULT => -4
	},
	{#State 154
		ACTIONS => {
			";" => 230
		}
	},
	{#State 155
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 231,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 156
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 232,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 157
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 233,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 158
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 234,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 159
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 235,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 160
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 236,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 161
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 237,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 162
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 238,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 163
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 239,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 164
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 240,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 165
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 212,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		GOTOS => {
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'condition' => 50,
			'directive' => 213,
			'expr' => 241,
			'filter' => 55,
			'ident' => 81,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'mdir' => 242,
			'node' => 61,
			'perl' => 62,
			'setlist' => 64,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'wrapper' => 73
		}
	},
	{#State 166
		ACTIONS => {
			"\$" => 2,
			"\${" => 3,
			'IDENT' => 15,
			'NUMBER' => 243
		},
		GOTOS => {
			'item' => 57,
			'node' => 244
		}
	},
	{#State 167
		DEFAULT => -156,
		GOTOS => {
			'args' => 245
		}
	},
	{#State 168
		DEFAULT => -148
	},
	{#State 169
		DEFAULT => -147
	},
	{#State 170
		DEFAULT => -7
	},
	{#State 171
		DEFAULT => 0
	},
	{#State 172
		DEFAULT => -111
	},
	{#State 173
		DEFAULT => -179
	},
	{#State 174
		DEFAULT => -178
	},
	{#State 175
		ACTIONS => {
			'DOT' => 166
		},
		DEFAULT => -177
	},
	{#State 176
		DEFAULT => -175
	},
	{#State 177
		DEFAULT => -131
	},
	{#State 178
		DEFAULT => -144
	},
	{#State 179
		DEFAULT => -145
	},
	{#State 180
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 246,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 181
		DEFAULT => -105
	},
	{#State 182
		DEFAULT => -115
	},
	{#State 183
		DEFAULT => -114
	},
	{#State 184
		DEFAULT => -106
	},
	{#State 185
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'ident' => 77,
			'item' => 57,
			'node' => 61,
			'sterm' => 247
		}
	},
	{#State 186
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 248,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 187
		DEFAULT => -108
	},
	{#State 188
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 249,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 189
		DEFAULT => -121
	},
	{#State 190
		DEFAULT => -120
	},
	{#State 191
		ACTIONS => {
			"\"" => 250,
			'LITERAL' => 251,
			'NUMBER' => 252
		}
	},
	{#State 192
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 253,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 193
		ACTIONS => {
			'FILENAME' => 92,
			'IDENT' => 105,
			'NUMBER' => 95
		},
		GOTOS => {
			'filepart' => 254
		}
	},
	{#State 194
		DEFAULT => -98
	},
	{#State 195
		DEFAULT => -97
	},
	{#State 196
		ACTIONS => {
			"\"" => 255,
			"\$" => 2,
			"\${" => 3,
			";" => 173,
			'IDENT' => 15,
			'TEXT' => 174
		},
		GOTOS => {
			'ident' => 175,
			'item' => 57,
			'node' => 61,
			'quotable' => 176
		}
	},
	{#State 197
		ACTIONS => {
			'DOT' => 166
		},
		DEFAULT => -156,
		GOTOS => {
			'args' => 256
		}
	},
	{#State 198
		DEFAULT => -156,
		GOTOS => {
			'args' => 257
		}
	},
	{#State 199
		ACTIONS => {
			"\"" => 103,
			'FILENAME' => 92,
			'IDENT' => 105,
			'LITERAL' => 106,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'name' => 258
		}
	},
	{#State 200
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'COMMA' => 259,
			'IDENT' => 15,
			'LITERAL' => 260,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		DEFAULT => -163,
		GOTOS => {
			'expr' => 261,
			'ident' => 262,
			'item' => 263,
			'lterm' => 59,
			'node' => 61,
			'param' => 264,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 201
		ACTIONS => {
			"\"" => 265,
			"\$" => 2,
			"\${" => 3,
			";" => 173,
			'IDENT' => 15,
			'TEXT' => 174
		},
		GOTOS => {
			'ident' => 175,
			'item' => 57,
			'node' => 61,
			'quotable' => 176
		}
	},
	{#State 202
		ACTIONS => {
			'ASSIGN' => -132
		},
		DEFAULT => -130
	},
	{#State 203
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 266,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 204
		ACTIONS => {
			"\"" => 103,
			"\$" => 104,
			'FILENAME' => 92,
			'IDENT' => 105,
			'LITERAL' => 106,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 107,
			'filepart' => 99,
			'name' => 108,
			'nameargs' => 267,
			'names' => 110
		}
	},
	{#State 205
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 268
		}
	},
	{#State 206
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 269
		}
	},
	{#State 207
		DEFAULT => -56,
		GOTOS => {
			'@1-3' => 270
		}
	},
	{#State 208
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'COMMA' => 259,
			'IDENT' => 15,
			'LITERAL' => 260,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		DEFAULT => -64,
		GOTOS => {
			'expr' => 261,
			'ident' => 262,
			'item' => 263,
			'lterm' => 59,
			'node' => 61,
			'param' => 264,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 209
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 271,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 210
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -151
	},
	{#State 211
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 272,
			'LITERAL' => 20,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'assign' => 79,
			'expr' => 80,
			'ident' => 81,
			'item' => 57,
			'lterm' => 59,
			'margs' => 273,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 212
		ACTIONS => {
			";" => 274
		}
	},
	{#State 213
		DEFAULT => -92
	},
	{#State 214
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -26
	},
	{#State 215
		DEFAULT => -91
	},
	{#State 216
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 275,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 217
		ACTIONS => {
			'TEXT' => 276
		}
	},
	{#State 218
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 277,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 219
		ACTIONS => {
			'CATCH' => 278,
			'FINAL' => 279
		},
		DEFAULT => -72,
		GOTOS => {
			'final' => 280
		}
	},
	{#State 220
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 281,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 221
		DEFAULT => -74,
		GOTOS => {
			'@3-3' => 282
		}
	},
	{#State 222
		DEFAULT => -59,
		GOTOS => {
			'@2-3' => 283
		}
	},
	{#State 223
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 284,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 224
		DEFAULT => -81
	},
	{#State 225
		DEFAULT => -58
	},
	{#State 226
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -45
	},
	{#State 227
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -47
	},
	{#State 228
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -61
	},
	{#State 229
		DEFAULT => -66
	},
	{#State 230
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 46,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'template' => 285,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 231
		ACTIONS => {
			"/" => 156,
			'DIV' => 162,
			'MOD' => 163
		},
		DEFAULT => -135
	},
	{#State 232
		ACTIONS => {
			'DIV' => 162,
			'MOD' => 163
		},
		DEFAULT => -134
	},
	{#State 233
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			":" => 286,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		}
	},
	{#State 234
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163
		},
		DEFAULT => -140
	},
	{#State 235
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			'DIV' => 162,
			'MOD' => 163
		},
		DEFAULT => -133
	},
	{#State 236
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			'BINOP' => 159,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163
		},
		DEFAULT => -139
	},
	{#State 237
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			'BINOP' => 159,
			'DIV' => 162,
			'MOD' => 163
		},
		DEFAULT => -138
	},
	{#State 238
		ACTIONS => {
			'MOD' => 163
		},
		DEFAULT => -136
	},
	{#State 239
		DEFAULT => -137
	},
	{#State 240
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163
		},
		DEFAULT => -141
	},
	{#State 241
		ACTIONS => {
			"\$" => -150,
			"\${" => -150,
			"+" => 155,
			"/" => 156,
			";" => -150,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'COMMA' => -150,
			'DIV' => 162,
			'IDENT' => -150,
			'LITERAL' => -150,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -26
	},
	{#State 242
		DEFAULT => -89
	},
	{#State 243
		DEFAULT => -126
	},
	{#State 244
		DEFAULT => -125
	},
	{#State 245
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			")" => 287,
			"[" => 5,
			"{" => 6,
			'COMMA' => 259,
			'IDENT' => 15,
			'LITERAL' => 260,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 261,
			'ident' => 262,
			'item' => 263,
			'lterm' => 59,
			'node' => 61,
			'param' => 264,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 246
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -150
	},
	{#State 247
		DEFAULT => -117
	},
	{#State 248
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -123
	},
	{#State 249
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -124
	},
	{#State 250
		ACTIONS => {
			'TEXT' => 288
		}
	},
	{#State 251
		DEFAULT => -100
	},
	{#State 252
		DEFAULT => -102
	},
	{#State 253
		ACTIONS => {
			'END' => 289
		}
	},
	{#State 254
		DEFAULT => -170
	},
	{#State 255
		DEFAULT => -167
	},
	{#State 256
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'COMMA' => 259,
			'IDENT' => 15,
			'LITERAL' => 260,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		DEFAULT => -162,
		GOTOS => {
			'expr' => 261,
			'ident' => 262,
			'item' => 263,
			'lterm' => 59,
			'node' => 61,
			'param' => 264,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 257
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			")" => 290,
			"[" => 5,
			"{" => 6,
			'COMMA' => 259,
			'IDENT' => 15,
			'LITERAL' => 260,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 261,
			'ident' => 262,
			'item' => 263,
			'lterm' => 59,
			'node' => 61,
			'param' => 264,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 258
		DEFAULT => -165
	},
	{#State 259
		DEFAULT => -155
	},
	{#State 260
		ACTIONS => {
			'ASSIGN' => 186
		},
		DEFAULT => -112
	},
	{#State 261
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -152
	},
	{#State 262
		ACTIONS => {
			'ASSIGN' => 291,
			'DOT' => 166
		},
		DEFAULT => -109
	},
	{#State 263
		ACTIONS => {
			"(" => 167,
			'ASSIGN' => 188
		},
		DEFAULT => -128
	},
	{#State 264
		DEFAULT => -153
	},
	{#State 265
		ACTIONS => {
			'ASSIGN' => -160
		},
		DEFAULT => -167
	},
	{#State 266
		ACTIONS => {
			'END' => 292
		}
	},
	{#State 267
		DEFAULT => -157
	},
	{#State 268
		DEFAULT => -156,
		GOTOS => {
			'args' => 293
		}
	},
	{#State 269
		DEFAULT => -156,
		GOTOS => {
			'args' => 294
		}
	},
	{#State 270
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 295,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 271
		ACTIONS => {
			'ELSE' => 296,
			'ELSIF' => 297
		},
		DEFAULT => -50,
		GOTOS => {
			'else' => 298
		}
	},
	{#State 272
		ACTIONS => {
			")" => -96,
			'COMMA' => -96,
			'IDENT' => -96
		},
		DEFAULT => -130
	},
	{#State 273
		ACTIONS => {
			")" => 299,
			'COMMA' => 300,
			'IDENT' => 301
		}
	},
	{#State 274
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 302,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 275
		ACTIONS => {
			'END' => 303
		}
	},
	{#State 276
		ACTIONS => {
			'END' => 304
		}
	},
	{#State 277
		ACTIONS => {
			'CASE' => 305
		},
		DEFAULT => -55,
		GOTOS => {
			'case' => 306
		}
	},
	{#State 278
		ACTIONS => {
			";" => 307,
			'DEFAULT' => 308,
			'FILENAME' => 92,
			'IDENT' => 105,
			'NUMBER' => 95
		},
		GOTOS => {
			'filename' => 309,
			'filepart' => 99
		}
	},
	{#State 279
		ACTIONS => {
			";" => 310
		}
	},
	{#State 280
		ACTIONS => {
			'END' => 311
		}
	},
	{#State 281
		ACTIONS => {
			'ELSE' => 296,
			'ELSIF' => 297
		},
		DEFAULT => -50,
		GOTOS => {
			'else' => 312
		}
	},
	{#State 282
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 313,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 283
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 314,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 284
		ACTIONS => {
			'END' => 315
		}
	},
	{#State 285
		ACTIONS => {
			'END' => 316
		}
	},
	{#State 286
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 317,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 287
		DEFAULT => -129
	},
	{#State 288
		ACTIONS => {
			"\"" => 318
		}
	},
	{#State 289
		DEFAULT => -88
	},
	{#State 290
		DEFAULT => -164
	},
	{#State 291
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 319,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 292
		DEFAULT => -80
	},
	{#State 293
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'COMMA' => 259,
			'IDENT' => 15,
			'LITERAL' => 260,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		DEFAULT => -62,
		GOTOS => {
			'expr' => 261,
			'ident' => 262,
			'item' => 263,
			'lterm' => 59,
			'node' => 61,
			'param' => 264,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 294
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'COMMA' => 259,
			'IDENT' => 15,
			'LITERAL' => 260,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		DEFAULT => -63,
		GOTOS => {
			'expr' => 261,
			'ident' => 262,
			'item' => 263,
			'lterm' => 59,
			'node' => 61,
			'param' => 264,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 295
		ACTIONS => {
			'END' => 320
		}
	},
	{#State 296
		ACTIONS => {
			";" => 321
		}
	},
	{#State 297
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NOT' => 24,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'expr' => 322,
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 69
		}
	},
	{#State 298
		ACTIONS => {
			'END' => 323
		}
	},
	{#State 299
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 212,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		GOTOS => {
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'condition' => 50,
			'directive' => 213,
			'expr' => 214,
			'filter' => 55,
			'ident' => 81,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'mdir' => 324,
			'node' => 61,
			'perl' => 62,
			'setlist' => 64,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'wrapper' => 73
		}
	},
	{#State 300
		DEFAULT => -95
	},
	{#State 301
		DEFAULT => -94
	},
	{#State 302
		ACTIONS => {
			'END' => 325
		}
	},
	{#State 303
		DEFAULT => -77
	},
	{#State 304
		DEFAULT => -79
	},
	{#State 305
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			";" => 326,
			"[" => 5,
			"{" => 6,
			'DEFAULT' => 327,
			'IDENT' => 15,
			'LITERAL' => 76,
			'NUMBER' => 25,
			'REF' => 29
		},
		GOTOS => {
			'ident' => 77,
			'item' => 57,
			'lterm' => 59,
			'node' => 61,
			'sterm' => 66,
			'term' => 328
		}
	},
	{#State 306
		ACTIONS => {
			'END' => 329
		}
	},
	{#State 307
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 330,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 308
		ACTIONS => {
			";" => 331
		}
	},
	{#State 309
		ACTIONS => {
			";" => 332,
			'DOT' => 193
		}
	},
	{#State 310
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 333,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 311
		DEFAULT => -67
	},
	{#State 312
		ACTIONS => {
			'END' => 334
		}
	},
	{#State 313
		ACTIONS => {
			'END' => 335
		}
	},
	{#State 314
		ACTIONS => {
			'END' => 336
		}
	},
	{#State 315
		DEFAULT => -65
	},
	{#State 316
		DEFAULT => -82
	},
	{#State 317
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -143
	},
	{#State 318
		DEFAULT => -101
	},
	{#State 319
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		},
		DEFAULT => -154
	},
	{#State 320
		DEFAULT => -57
	},
	{#State 321
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 337,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 322
		ACTIONS => {
			"+" => 155,
			"/" => 156,
			";" => 338,
			"?" => 157,
			'AND' => 158,
			'BINOP' => 159,
			'CAT' => 160,
			'CMPOP' => 161,
			'DIV' => 162,
			'MOD' => 163,
			'OR' => 164
		}
	},
	{#State 323
		DEFAULT => -44
	},
	{#State 324
		DEFAULT => -90
	},
	{#State 325
		DEFAULT => -93
	},
	{#State 326
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 339,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 327
		ACTIONS => {
			";" => 340
		}
	},
	{#State 328
		ACTIONS => {
			";" => 341
		}
	},
	{#State 329
		DEFAULT => -51
	},
	{#State 330
		ACTIONS => {
			'CATCH' => 278,
			'FINAL' => 279
		},
		DEFAULT => -72,
		GOTOS => {
			'final' => 342
		}
	},
	{#State 331
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 343,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 332
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 344,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 333
		DEFAULT => -71
	},
	{#State 334
		DEFAULT => -46
	},
	{#State 335
		DEFAULT => -75
	},
	{#State 336
		DEFAULT => -60
	},
	{#State 337
		DEFAULT => -49
	},
	{#State 338
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 345,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 339
		DEFAULT => -54
	},
	{#State 340
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 346,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 341
		ACTIONS => {
			"\"" => 1,
			"\$" => 2,
			"\${" => 3,
			"(" => 4,
			";" => -18,
			"[" => 5,
			"{" => 6,
			'BLOCK' => 7,
			'CALL' => 8,
			'CLEAR' => 9,
			'DEBUG' => 10,
			'DEFAULT' => 11,
			'FILTER' => 12,
			'FOR' => 13,
			'GET' => 14,
			'IDENT' => 15,
			'IF' => 16,
			'INCLUDE' => 17,
			'INSERT' => 18,
			'LAST' => 19,
			'LITERAL' => 20,
			'MACRO' => 21,
			'META' => 22,
			'NEXT' => 23,
			'NOT' => 24,
			'NUMBER' => 25,
			'PERL' => 26,
			'PROCESS' => 27,
			'RAWPERL' => 28,
			'REF' => 29,
			'RETURN' => 30,
			'SET' => 31,
			'STOP' => 32,
			'SWITCH' => 33,
			'TEXT' => 34,
			'THROW' => 35,
			'TRY' => 36,
			'UNLESS' => 37,
			'USE' => 38,
			'VIEW' => 39,
			'WHILE' => 40,
			'WRAPPER' => 41
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 42,
			'assign' => 43,
			'atomdir' => 44,
			'atomexpr' => 45,
			'block' => 347,
			'capture' => 47,
			'chunk' => 48,
			'chunks' => 49,
			'condition' => 50,
			'defblock' => 51,
			'defblockname' => 52,
			'directive' => 53,
			'expr' => 54,
			'filter' => 55,
			'ident' => 56,
			'item' => 57,
			'loop' => 58,
			'lterm' => 59,
			'macro' => 60,
			'node' => 61,
			'perl' => 62,
			'rawperl' => 63,
			'setlist' => 64,
			'statement' => 65,
			'sterm' => 66,
			'switch' => 67,
			'term' => 69,
			'try' => 70,
			'use' => 71,
			'view' => 72,
			'wrapper' => 73
		}
	},
	{#State 342
		DEFAULT => -70
	},
	{#State 343
		ACTIONS => {
			'CATCH' => 278,
			'FINAL' => 279
		},
		DEFAULT => -72,
		GOTOS => {
			'final' => 348
		}
	},
	{#State 344
		ACTIONS => {
			'CATCH' => 278,
			'FINAL' => 279
		},
		DEFAULT => -72,
		GOTOS => {
			'final' => 349
		}
	},
	{#State 345
		ACTIONS => {
			'ELSE' => 296,
			'ELSIF' => 297
		},
		DEFAULT => -50,
		GOTOS => {
			'else' => 350
		}
	},
	{#State 346
		DEFAULT => -53
	},
	{#State 347
		ACTIONS => {
			'CASE' => 305
		},
		DEFAULT => -55,
		GOTOS => {
			'case' => 351
		}
	},
	{#State 348
		DEFAULT => -69
	},
	{#State 349
		DEFAULT => -68
	},
	{#State 350
		DEFAULT => -48
	},
	{#State 351
		DEFAULT => -52
	}
];


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 64 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 67 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 68 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 71 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
                                        if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 73 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 76 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 77 "Parser.yp"
{ return '' unless $_[1];
                                      $_[0]->location() . $_[1];
                                    }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1,
sub
#line 90 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 17
		 'statement', 2,
sub
#line 91 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 18
		 'statement', 0, undef
	],
	[#Rule 19
		 'directive', 1,
sub
#line 95 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 20
		 'directive', 1, undef
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'atomexpr', 1,
sub
#line 109 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 27
		 'atomexpr', 1, undef
	],
	[#Rule 28
		 'atomdir', 2,
sub
#line 113 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 29
		 'atomdir', 2,
sub
#line 114 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 115 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 116 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 117 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 118 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 36
		 'atomdir', 1,
sub
#line 121 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 37
		 'atomdir', 1,
sub
#line 122 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 123 "Parser.yp"
{ "\$output = '';";                   }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 124 "Parser.yp"
{ $_[0]->block_label('last ', ';')    }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 125 "Parser.yp"
{ $_[0]->in_block('FOR')
                                        ? $factory->next($_[0]->block_label)
                                        : $_[0]->block_label('next ', ';') }
	],
	[#Rule 41
		 'atomdir', 2,
sub
#line 128 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
                                          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
                                          $factory->debug($_[2]);
                                      }
                                      else {
                                          $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
                                      }
                                    }
	],
	[#Rule 42
		 'atomdir', 1, undef
	],
	[#Rule 43
		 'atomdir', 1, undef
	],
	[#Rule 44
		 'condition', 6,
sub
#line 141 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 45
		 'condition', 3,
sub
#line 142 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 46
		 'condition', 6,
sub
#line 144 "Parser.yp"
{ $factory->if("!($_[2])", @_[4, 5])  }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 145 "Parser.yp"
{ $factory->if("!($_[3])", $_[1])     }
	],
	[#Rule 48
		 'else', 5,
sub
#line 149 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
                                      $_[5];                              }
	],
	[#Rule 49
		 'else', 3,
sub
#line 151 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 50
		 'else', 0,
sub
#line 152 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 51
		 'switch', 6,
sub
#line 156 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 52
		 'case', 5,
sub
#line 160 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
                                      $_[5];                              }
	],
	[#Rule 53
		 'case', 4,
sub
#line 162 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 54
		 'case', 3,
sub
#line 163 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 55
		 'case', 0,
sub
#line 164 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 56
		 '@1-3', 0,
sub
#line 167 "Parser.yp"
{ $_[0]->enter_block('FOR')           }
	],
	[#Rule 57
		 'loop', 6,
sub
#line 168 "Parser.yp"
{ $factory->foreach(@{$_[2]}, $_[5], $_[0]->leave_block)  }
	],
	[#Rule 58
		 'loop', 3,
sub
#line 169 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 59
		 '@2-3', 0,
sub
#line 170 "Parser.yp"
{ $_[0]->enter_block('WHILE')         }
	],
	[#Rule 60
		 'loop', 6,
sub
#line 171 "Parser.yp"
{ $factory->while(@_[2, 5], $_[0]->leave_block) }
	],
	[#Rule 61
		 'loop', 3,
sub
#line 172 "Parser.yp"
{ $factory->while(@_[3, 1]) }
	],
	[#Rule 62
		 'loopvar', 4,
sub
#line 175 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 63
		 'loopvar', 4,
sub
#line 176 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 64
		 'loopvar', 2,
sub
#line 177 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 65
		 'wrapper', 5,
sub
#line 181 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 66
		 'wrapper', 3,
sub
#line 183 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 67
		 'try', 5,
sub
#line 187 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 68
		 'final', 5,
sub
#line 191 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
                                      $_[5];                              }
	],
	[#Rule 69
		 'final', 5,
sub
#line 194 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
                                      $_[5];                              }
	],
	[#Rule 70
		 'final', 4,
sub
#line 197 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
                                      $_[4];                              }
	],
	[#Rule 71
		 'final', 3,
sub
#line 199 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 72
		 'final', 0,
sub
#line 200 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 73
		 'use', 2,
sub
#line 203 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 74
		 '@3-3', 0,
sub
#line 206 "Parser.yp"
{ $_[0]->push_defblock();             }
	],
	[#Rule 75
		 'view', 6,
sub
#line 207 "Parser.yp"
{ $factory->view(@_[2,5], 
                                                     $_[0]->pop_defblock) }
	],
	[#Rule 76
		 '@4-2', 0,
sub
#line 211 "Parser.yp"
{ ${$_[0]->{ INPERL }}++;             }
	],
	[#Rule 77
		 'perl', 5,
sub
#line 212 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
                                      $_[0]->{ EVAL_PERL } 
                                      ? $factory->perl($_[4])             
                                      : $factory->no_perl();              }
	],
	[#Rule 78
		 '@5-1', 0,
sub
#line 218 "Parser.yp"
{ ${$_[0]->{ INPERL }}++; 
                                      $rawstart = ${$_[0]->{'LINE'}};     }
	],
	[#Rule 79
		 'rawperl', 5,
sub
#line 220 "Parser.yp"
{ ${$_[0]->{ INPERL }}--;
                                      $_[0]->{ EVAL_PERL } 
                                      ? $factory->rawperl($_[4], $rawstart)
                                      : $factory->no_perl();              }
	],
	[#Rule 80
		 'filter', 5,
sub
#line 227 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 81
		 'filter', 3,
sub
#line 229 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 82
		 'defblock', 5,
sub
#line 234 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
                                      pop(@{ $_[0]->{ DEFBLOCKS } });
                                      $_[0]->define_block($name, $_[4]); 
                                      undef
                                    }
	],
	[#Rule 83
		 'defblockname', 2,
sub
#line 241 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
                                      $_[2];
                                    }
	],
	[#Rule 84
		 'blockname', 1, undef
	],
	[#Rule 85
		 'blockname', 1,
sub
#line 247 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 86
		 'blockargs', 1, undef
	],
	[#Rule 87
		 'blockargs', 0, undef
	],
	[#Rule 88
		 'anonblock', 5,
sub
#line 255 "Parser.yp"
{ local $" = ', ';
                                      print STDERR "experimental block args: [@{ $_[2] }]\n"
                                          if $_[2];
                                      $factory->anon_block($_[4])         }
	],
	[#Rule 89
		 'capture', 3,
sub
#line 261 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 90
		 'macro', 6,
sub
#line 265 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 91
		 'macro', 3,
sub
#line 266 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 92
		 'mdir', 1, undef
	],
	[#Rule 93
		 'mdir', 4,
sub
#line 270 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 94
		 'margs', 2,
sub
#line 273 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 95
		 'margs', 2,
sub
#line 274 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 96
		 'margs', 1,
sub
#line 275 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 97
		 'metadata', 2,
sub
#line 278 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 98
		 'metadata', 2, undef
	],
	[#Rule 99
		 'metadata', 1, undef
	],
	[#Rule 100
		 'meta', 3,
sub
#line 283 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
                                                       s/\\'/'/g  }; 
                                         [ @_[1,3] ] }
	],
	[#Rule 101
		 'meta', 5,
sub
#line 286 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 102
		 'meta', 3,
sub
#line 287 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 103
		 'term', 1, undef
	],
	[#Rule 104
		 'term', 1, undef
	],
	[#Rule 105
		 'lterm', 3,
sub
#line 299 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 106
		 'lterm', 3,
sub
#line 300 "Parser.yp"
{ "[ $_[2] ]"                         }
	],
	[#Rule 107
		 'lterm', 2,
sub
#line 301 "Parser.yp"
{ "[ ]"                               }
	],
	[#Rule 108
		 'lterm', 3,
sub
#line 302 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 109
		 'sterm', 1,
sub
#line 305 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 110
		 'sterm', 2,
sub
#line 306 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 111
		 'sterm', 3,
sub
#line 307 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 112
		 'sterm', 1, undef
	],
	[#Rule 113
		 'sterm', 1, undef
	],
	[#Rule 114
		 'list', 2,
sub
#line 312 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 115
		 'list', 2, undef
	],
	[#Rule 116
		 'list', 1, undef
	],
	[#Rule 117
		 'range', 3,
sub
#line 317 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 118
		 'hash', 1, undef
	],
	[#Rule 119
		 'hash', 0,
sub
#line 322 "Parser.yp"
{ "" }
	],
	[#Rule 120
		 'params', 2,
sub
#line 325 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 121
		 'params', 2, undef
	],
	[#Rule 122
		 'params', 1, undef
	],
	[#Rule 123
		 'param', 3,
sub
#line 330 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 124
		 'param', 3,
sub
#line 331 "Parser.yp"
{ "$_[1] => $_[3]"                    }
	],
	[#Rule 125
		 'ident', 3,
sub
#line 334 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 126
		 'ident', 3,
sub
#line 335 "Parser.yp"
{ push(@{$_[1]}, 
                                           map {($_, 0)} split(/\./, $_[3]));
                                      $_[1];                              }
	],
	[#Rule 127
		 'ident', 1, undef
	],
	[#Rule 128
		 'node', 1,
sub
#line 341 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 129
		 'node', 4,
sub
#line 342 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 130
		 'item', 1,
sub
#line 345 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 131
		 'item', 3,
sub
#line 346 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 132
		 'item', 2,
sub
#line 347 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
                                       ? "'$_[2]'" 
                                       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 133
		 'expr', 3,
sub
#line 352 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 353 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 354 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "int($_[1] / $_[3])"                }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "$_[1]  . $_[3]"                    }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1] && $_[3]"                    }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] || $_[3]"                    }
	],
	[#Rule 142
		 'expr', 2,
sub
#line 361 "Parser.yp"
{ "! $_[2]"                           }
	],
	[#Rule 143
		 'expr', 5,
sub
#line 362 "Parser.yp"
{ "$_[1] ? $_[3] : $_[5]"             }
	],
	[#Rule 144
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 145
		 'expr', 3,
sub
#line 364 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 146
		 'expr', 1, undef
	],
	[#Rule 147
		 'setlist', 2,
sub
#line 368 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 148
		 'setlist', 2, undef
	],
	[#Rule 149
		 'setlist', 1, undef
	],
	[#Rule 150
		 'assign', 3,
sub
#line 374 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 151
		 'assign', 3,
sub
#line 375 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 152
		 'args', 2,
sub
#line 382 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 153
		 'args', 2,
sub
#line 383 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 154
		 'args', 4,
sub
#line 384 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
                                      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 155
		 'args', 2,
sub
#line 386 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 156
		 'args', 0,
sub
#line 387 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 157
		 'lnameargs', 3,
sub
#line 397 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 158
		 'lnameargs', 1, undef
	],
	[#Rule 159
		 'lvalue', 1, undef
	],
	[#Rule 160
		 'lvalue', 3,
sub
#line 402 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 161
		 'lvalue', 1, undef
	],
	[#Rule 162
		 'nameargs', 3,
sub
#line 406 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 163
		 'nameargs', 2,
sub
#line 407 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 164
		 'nameargs', 4,
sub
#line 408 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 165
		 'names', 3,
sub
#line 411 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 166
		 'names', 1,
sub
#line 412 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 167
		 'name', 3,
sub
#line 415 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 168
		 'name', 1,
sub
#line 416 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 169
		 'name', 1, undef
	],
	[#Rule 170
		 'filename', 3,
sub
#line 420 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 171
		 'filename', 1, undef
	],
	[#Rule 172
		 'filepart', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'filepart', 1, undef
	],
	[#Rule 175
		 'quoted', 2,
sub
#line 434 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
                                          if defined $_[2]; $_[1]         }
	],
	[#Rule 176
		 'quoted', 0,
sub
#line 436 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 177
		 'quotable', 1,
sub
#line 439 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 440 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 179
		 'quotable', 1,
sub
#line 441 "Parser.yp"
{ undef                               }
	]
];

} #--- END BEGIN


1;

__END__

=head1 NAME

Template::Grammar - Parser state/rule tables for the TT grammar

=head1 SYNOPSIS

    # no user serviceable parts inside

=head1 DESCRIPTION

This module defines the state and rule tables that the L<Template::Parser>
module uses to parse templates.  It is generated from a YACC-like grammar
using the C<Parse::Yapp> module.  The F<parser> sub-directory of the
Template Toolkit source distribution contains the grammar and other
files required to generate this module.

But you don't need to worry about any of that unless you're planning to
modify the Template Toolkit language.

=head1 AUTHOR

Andy Wardley E<lt>abw@wardley.orgE<gt>

L<http://wardley.org/>

=head1 COPYRIGHT

Copyright (C) 1996-2014 Andy Wardley.  All Rights Reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

L<Template::Parser>

=cut

# Local Variables:
# mode: perl
# perl-indent-level: 4
# indent-tabs-mode: nil
# End:
#
# vim: expandtab shiftwidth=4:
