#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 570_Slurm-SAUser-parse.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::User;

my $testDir = dirname(abs_path($0));
my $num_tests_run = 0; 

#Set up expected results
my @fakedata =
(	
	{ user=>'aaa', defacct=>'test' },
	{ user=>'bbb', defacct=>'test', admin=>'Administrator' },
	{ user=>'ccc', defacct=>'abc114', admin=>'Administrator' },
	{ user=>'ddd', defacct=>'test' },
);
my @fake_data = ();
foreach my $fakedatum (@fakedata)
{	my $uname = $fakedatum->{user};
	my $defacct = $fakedatum->{defacct};
	my $admin = $fakedatum->{admin} || 'None';

	my $uobj = new_ok('Slurm::Sacctmgr::User' => 
		[ user=>$uname, defaultaccount=>$defacct, adminlevel=>$admin ],
		"$uname" );
	$num_tests_run++;

	push @fake_data, $uobj;
}
#Make sure @fake_data is alphabetically by username
@fake_data = sort { $a->user cmp $b->user } @fake_data;

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/fake_sacctmgr_user");
my $sauser = 'Slurm::Sacctmgr::User';

my $results;
my $args;
my $temp;
my $val;
my @temp;

#Test various commands with echo sacctmgr
#$sa->verbose(1);

$results = $sauser->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all users');
$num_tests_run++;

$val = 'bbb';
@temp = ( name => $val );
$temp = [ grep { $_->user eq $val } @fake_data ];
$results = $sauser->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list user by name');
$num_tests_run++;

$val = 'abc114';
@temp = ( defaultaccount => $val );
$temp = [ grep { $_->defaultaccount eq $val } @fake_data ];
$results = $sauser->sacctmgr_list($sa, @temp);
is_deeply($results, $temp, 'list user by acct (single user)');
$num_tests_run++;

$val = 'test';
@temp = ( defaultaccount => $val );
$temp = [ grep { $_->defaultaccount eq $val } @fake_data ];
$results = $sauser->sacctmgr_list($sa, @temp);
is_deeply($results, $temp, 'list user by acct (multiple users)');
$num_tests_run++;

$val = 'test';
@temp = ( defaultaccount => $val );
$temp = [ grep { $_->defaultaccount eq $val } @fake_data ];
$val = 'Administrator';
push @temp, ( adminlevel => $val );
$temp = [ grep { $_->adminlevel eq $val } @$temp ];
$results = $sauser->sacctmgr_list($sa, @temp);
is_deeply($results, $temp, 'list user by acct and admin');
$num_tests_run++;

#Test for match failing
$val = 'zzz';
@temp = ( name => $val );
$temp = [ grep { $_->user eq $val } @fake_data ];
$results = $sauser->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list user by name (no match)');
$num_tests_run++;

#Test that still works when in dryrun mode
$sa->dryrun(1);
$results = $sauser->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all users (dryrun)');
$num_tests_run++;

done_testing($num_tests_run);

