/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ErasureUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionFactory<T>
implements Serializable {
    private static final long serialVersionUID = 3711321773145894069L;
    public static final CollectionFactory ARRAY_LIST_FACTORY = new ArrayListFactory();
    public static final CollectionFactory LINKED_LIST_FACTORY = new LinkedListFactory();
    public static final CollectionFactory HASH_SET_FACTORY = new HashSetFactory();

    public abstract Collection<T> newCollection();

    public abstract Collection<T> newEmptyCollection();

    public static <E> CollectionFactory<E> arrayListFactory() {
        return (CollectionFactory)ErasureUtils.uncheckedCast(ARRAY_LIST_FACTORY);
    }

    public static <E> CollectionFactory<E> linkedListFactory() {
        return (CollectionFactory)ErasureUtils.uncheckedCast(LINKED_LIST_FACTORY);
    }

    public static <E> CollectionFactory<E> hashSetFactory() {
        return (CollectionFactory)ErasureUtils.uncheckedCast(HASH_SET_FACTORY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HashSetFactory<T>
    extends CollectionFactory<T> {
        private static final long serialVersionUID = -6268401669449458602L;

        @Override
        public Collection<T> newCollection() {
            return new HashSet();
        }

        @Override
        public Collection<T> newEmptyCollection() {
            return Collections.emptySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedListFactory<T>
    extends CollectionFactory<T> {
        private static final long serialVersionUID = -4236184979948498000L;

        @Override
        public Collection<T> newCollection() {
            return new LinkedList();
        }

        @Override
        public Collection<T> newEmptyCollection() {
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayListFactory<T>
    extends CollectionFactory<T> {
        private static final long serialVersionUID = 1L;

        @Override
        public Collection<T> newCollection() {
            return new ArrayList();
        }

        @Override
        public Collection<T> newEmptyCollection() {
            return Collections.emptyList();
        }
    }
}

