#!perl
use strict;
use warnings;
use Test::More tests => 3;

use Weather::MOSMIX;
use Weather::MOSMIX::Reader;
use Weather::MOSMIX::Writer;

my $w = Weather::MOSMIX::Writer->new;

my $dbh = $w->create_db(
        dsn => 'dbi:SQLite:dbname=:memory:'
);

my $r = Weather::MOSMIX::Reader->new(
    writer => $w,
);

open my $xml,'<', \<<XML;
<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<kml:kml xmlns:dwd="https://opendata.dwd.de/weather/lib/pointforecast_dwd_extension_V1_0.xsd" xmlns:gx="http://www.google.com/kml/ext/2.2" xmlns:xal="urn:oasis:names:tc:ciq:xsdschema:xAL:2.0" xmlns:kml="http://www.opengis.net/kml/2.2" xmlns:atom="http://www.w3.org/2005/Atom">
    <kml:Document>
        <kml:ExtendedData>
            <dwd:ProductDefinition>
                <dwd:Issuer>Deutscher Wetterdienst</dwd:Issuer>
                <dwd:ProductID>MOSMIX</dwd:ProductID>
                <dwd:GeneratingProcess>DWD MOSMIX hourly, Version 1.0</dwd:GeneratingProcess>
                <dwd:IssueTime>2019-06-22T08:00:00.000Z</dwd:IssueTime>
                <dwd:ReferencedModel>
                    <dwd:Model dwd:name="ICON" dwd:referenceTime="2019-06-22T00:00:00Z"/>
                    <dwd:Model dwd:name="ECMWF/IFS" dwd:referenceTime="2019-06-21T12:00:00Z"/>
                </dwd:ReferencedModel>
            </dwd:ProductDefinition>
        </kml:ExtendedData>
        <kml:Placemark>
            <kml:name>01028</kml:name>
            <kml:description>BJORNOYA</kml:description>
            <kml:ExtendedData>
                <dwd:Forecast dwd:elementName="PPPP">
                    <dwd:value>   97660.00   97580.00   97550.00   97430.00   97380.00   97310.00   97230.00   97160.00   97070.00   96950.00   96870.00   96790.00   96660.00   96570.00   96460.00   96380.00   96330.00   96280.00   96190.00   96130.00   96020.00   96000.00   95950.00   95900.00   95860.00   95830.00   95830.00   95800.00   95810.00   95870.00   95840.00   95790.00   95740.00   95760.00   95700.00   95700.00   95650.00   95650.00   95690.00   95640.00   95700.00   95700.00   95710.00   95780.00   95780.00   95730.00   95790.00   95790.00   95840.00   95910.00   95990.00   95990.00   95990.00   96060.00   96080.00   96090.00   96220.00   96210.00   96170.00   96120.00   96140.00   96170.00   96310.00   96320.00   96400.00   96510.00   96610.00   96680.00   96890.00   96810.00   96900.00   96870.00   96950.00   96970.00   97230.00   97300.00   97360.00   97560.00   97620.00   97770.00   97750.00   97820.00   97910.00   97980.00   98040.00   98100.00   98140.00   98210.00   98260.00   98410.00   98490.00   98520.00   98480.00   98610.00   98680.00   98760.00   98900.00   98920.00   98970.00   99110.00   99130.00   99180.00   99220.00   99270.00   99290.00   99360.00   99410.00   99450.00   99490.00   99470.00   99540.00   99610.00   99670.00   99710.00   99750.00   99780.00   99760.00   99820.00   99890.00   99980.00  100120.00  100160.00  100180.00  100180.00  100190.00  100230.00  100270.00  100270.00  100250.00  100290.00  100320.00  100320.00  100370.00  100360.00  100360.00  100350.00  100320.00  100310.00  100320.00  100320.00  100310.00  100240.00  100240.00  100220.00  100210.00  100190.00  100210.00  100190.00  100200.00  100200.00  100130.00  100150.00  100100.00  100080.00  100070.00  100000.00   99960.00   99960.00   99920.00   99870.00   99870.00   99860.00   99830.00   99800.00   99770.00   99850.00   99820.00   99810.00   99790.00   99720.00   99710.00   99700.00   99680.00   99640.00   99790.00   99700.00   99710.00   99680.00   99640.00   99590.00   99570.00   99490.00   99480.00   99480.00   99480.00   99390.00   99380.00   99390.00   99380.00   99410.00   99370.00   99200.00   99190.00   99200.00   99160.00   99160.00   99170.00   99160.00   99150.00   99170.00   99160.00   99150.00   99190.00   99140.00   99140.00   99140.00   99140.00   99150.00   99160.00   99180.00   99190.00   99200.00   99210.00   99220.00   99180.00   99200.00   99210.00   99220.00   99240.00   99250.00   99280.00   99300.00   99320.00   99330.00   99360.00   99370.00   99370.00   99370.00   99370.00   99530.00   99530.00   99540.00   99560.00   99580.00   99590.00   99600.00   99600.00   99610.00   99640.00   99650.00   99660.00  100350.00  100350.00  100350.00  100360.00  100360.00  100360.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="E_PPP">
                    <dwd:value>     30.00      50.00      60.00      70.00      50.00      80.00      90.00      90.00      80.00      90.00     100.00     100.00     100.00     110.00     110.00     140.00     150.00     170.00     170.00     180.00     180.00     170.00     180.00     190.00     200.00     200.00     200.00     210.00     230.00     210.00     240.00     240.00     240.00     280.00     280.00     280.00     300.00     270.00     260.00     280.00     270.00     280.00     310.00     320.00     300.00     320.00     330.00     340.00     350.00     350.00     280.00     300.00     310.00     350.00     350.00     360.00     320.00     290.00     360.00     390.00     410.00     460.00     450.00     450.00     420.00     470.00     440.00     430.00     480.00     490.00     430.00     500.00     490.00     490.00     510.00     520.00     510.00     550.00     550.00     550.00     540.00     520.00     560.00     530.00     530.00     540.00     550.00     460.00     530.00     570.00     580.00     580.00     580.00     590.00     520.00     500.00     490.00     480.00     440.00     460.00     460.00     500.00     500.00     500.00     500.00     440.00     490.00     480.00     450.00     470.00     470.00     480.00     490.00     500.00     350.00     510.00     420.00     470.00     470.00     480.00     480.00     530.00     500.00     510.00     530.00     500.00     500.00     430.00     400.00     400.00     360.00     400.00     390.00     420.00     450.00     460.00     470.00     500.00     470.00     480.00     480.00     490.00     530.00     530.00     520.00     530.00     540.00     500.00     520.00     520.00     520.00     520.00     580.00     560.00     650.00     690.00     700.00     710.00     710.00     720.00     770.00     760.00     750.00     750.00     760.00     770.00     750.00     710.00     770.00     780.00     760.00     760.00     720.00     740.00     820.00     830.00     840.00     850.00     850.00     860.00     870.00     870.00     890.00     910.00     950.00     880.00     990.00    1000.00     940.00    1000.00     960.00     970.00    1000.00    1000.00     980.00    1000.00    1000.00    1000.00     960.00    1000.00     990.00     990.00     960.00     940.00     940.00     940.00     910.00     980.00     990.00     950.00     980.00     970.00     960.00     960.00     940.00     950.00     950.00     950.00     930.00     920.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00    1000.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="TX">
                    <dwd:value>            -          -     270.35          -          -          -          -          -          -          -          -          -          -          -     270.95          -          -          -          -          -          -          -          -          -          -          -     272.95          -          -          -          -          -          -          -          -          -          -          -     271.55          -          -          -          -          -          -          -          -          -          -          -     271.35          -          -          -          -          -          -          -          -          -          -          -     268.75          -          -          -          -          -          -          -          -          -          -          -     266.65          -          -          -          -          -          -          -          -          -          -          -     265.25          -          -          -          -          -          -          -          -          -          -          -     264.55          -          -          -          -          -          -          -          -          -          -          -     264.35          -          -          -          -          -          -          -          -          -          -          -     264.55          -          -          -          -          -          -          -          -          -          -          -     266.05          -          -          -          -          -          -          -          -          -          -          -     267.45          -          -          -          -          -          -          -          -          -          -          -     268.15          -          -          -          -          -          -          -          -          -          -          -     271.55          -          -          -          -          -          -          -          -          -          -          -     271.25          -          -          -          -          -          -          -          -          -          -          -     271.85          -          -          -          -          -          -          -          -          -          -          -     272.75          -          -          -          -          -          -          -          -          -          -          -     272.65          -          -          -          -          -          -          -          -          -          -          -     272.95          -          -          -          -          -          -          -          -          -          -          -     271.35          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="TTT">
                    <dwd:value>      269.95     270.05     269.95     270.35     270.25     270.25     270.15     269.95     270.05     270.05     270.25     270.55     270.75     270.85     270.95     271.75     271.95     272.05     272.15     272.35     272.45     272.35     272.05     272.05     272.35     272.35     271.55     271.45     271.45     271.45     271.45     271.25     271.45     271.35     271.35     271.45     271.45     271.45     271.35     271.05     271.05     270.55     270.75     270.75     270.65     270.55     270.55     270.35     270.35     270.55     268.75     268.75     268.45     268.25     268.05     267.95     267.45     267.55     266.95     266.85     266.65     266.45     266.25     266.25     266.05     265.45     265.45     265.55     264.95     265.45     265.45     265.55     265.45     265.45     264.85     264.65     264.65     264.35     264.35     264.35     263.85     264.15     264.05     264.05     264.15     263.85     264.05     264.05     264.05     263.75     263.35     263.55     263.25     263.15     263.05     263.45     262.85     262.65     262.35     262.35     262.55     262.55     262.55     262.55     262.55     262.65     262.65     262.85     263.15     263.25     263.05     263.25     263.45     263.35     263.25     263.25     263.05     263.15     263.15     263.25     263.25     263.45     263.45     263.65     263.65     263.35     263.45     263.45     263.45     263.45     263.55     263.75     263.95     264.05     263.95     264.45     264.65     264.55     264.55     264.65     264.75     264.65     264.75     265.15     264.95     265.25     265.65     266.45     266.75     266.95     266.25     266.35     267.05     267.35     267.55     267.65     267.85     267.95     268.15     268.95     269.05     269.15     269.25     269.75     269.95     269.75     269.75     269.85     269.95     270.35     270.45     270.05     270.25     270.35     270.55     270.65     270.75     271.15     271.25     271.25     271.25     271.25     271.25     271.25     270.85     271.05     271.35     271.45     271.45     271.45     271.45     271.45     271.55     271.55     271.75     271.75     272.15     272.15     271.95     271.85     271.95     272.05     272.05     271.95     271.95     271.85     271.95     271.95     271.85     271.85     271.85     271.55     271.55     271.55     271.55     271.45     271.55     271.65     271.65     271.55     271.85     271.85     271.75     271.75     271.55     271.65     271.65     271.65     271.55     271.75     271.35     271.35     271.35     271.35     271.25     271.25     271.25     271.25     271.25     271.25     271.15     270.55     270.55     270.55     270.45     270.45     270.45</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="E_TTT">
                    <dwd:value>      0.50       0.60       0.50       0.70       0.80       1.20       1.10       0.90       0.90       0.80       1.00       0.80       0.70       0.90       0.90       0.90       0.80       1.00       1.30       1.30       1.30       1.10       1.20       1.20       1.30       1.40       1.40       1.30       1.60       1.60       1.80       2.00       1.80       2.20       2.30       1.80       1.90       1.90       1.50       1.60       1.60       1.80       1.90       1.80       1.60       1.50       1.90       1.70       1.80       1.60       1.80       1.70       1.70       2.10       2.40       2.40       2.30       2.60       2.30       2.70       2.80       2.90       2.60       2.30       3.10       3.10       3.10       3.40       3.40       3.90       3.50       3.80       3.60       3.50       3.50       3.20       3.10       3.70       3.20       3.20       3.30       3.30       3.60       3.30       3.30       3.30       3.40       4.10       3.50       3.70       3.90       4.10       3.90       4.20       4.30       4.20       4.40       4.40       4.20       4.00       4.20       4.40       4.30       4.30       4.80       4.90       5.30       4.80       4.80       5.00       4.90       5.30       5.10       4.90       5.10       5.20       5.20       5.40       5.60       4.70       5.60       5.50       4.60       5.00       4.80       4.90       5.00       5.10       5.20       5.10       4.80       4.90       4.60       4.60       4.60       4.30       4.40       4.40       4.90       4.30       4.90       4.70       4.70       4.60       4.70       4.60       4.80       4.60       4.50       4.70       4.70       4.90       4.90       4.80       4.60       4.70       4.50       4.60       4.60       4.40       4.20       4.20       4.20       4.30       4.20       4.30       4.30       4.10       4.10       4.00       4.10       4.00       3.90       3.90       3.80       3.80       3.80       3.70       3.70       3.70       3.50       3.50       3.50       3.50       3.50       3.50       3.50       3.50       3.50       3.50       3.50       3.40       3.50       3.50       3.60       3.60       3.50       3.50       3.60       3.60       3.50       3.40       3.40       3.40       3.30       3.20       3.20       3.30       3.30       3.30       3.30       3.30       3.30       3.30       3.20       3.20       3.20       3.20       3.30       3.20       3.20       3.20       3.20       3.30       3.30       3.20       3.30       3.30       3.30       3.50       3.60       3.40       3.50       3.50       3.40       3.40       3.40       3.40       3.10       3.00       3.00       3.60       3.80       3.60       3.40       3.50       3.50</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Td">
                    <dwd:value>       268.95     269.05     269.05     269.35     269.45     269.35     269.25     268.95     268.75     269.25     269.45     269.75     269.85     270.05     270.25     270.65     271.15     271.25     271.35     271.55     271.65     271.95     271.85     271.75     271.75     271.55     271.35     271.25     271.35     270.95     270.75     270.55     270.45     270.55     270.45     270.55     270.55     270.35     270.25     270.25     270.15     270.25     269.95     269.65     269.55     269.65     269.45     269.15     269.05     268.75     267.85     267.65     267.25     266.55     266.65     266.85     266.15     266.15     266.05     265.75     265.25     264.75     264.15     264.75     264.85     264.85     265.05     265.55     264.65     264.95     264.95     264.95     264.45     264.35     263.05     262.85     262.85     262.65     262.45     262.45     262.45     262.25     262.65     261.85     261.65     261.25     261.45     261.55     261.55     261.45     261.55     261.35     261.05     261.15     261.25     261.35     261.25     261.05     261.05     261.05     260.95     260.95     260.95     260.65     260.65     260.65     260.65     260.45     260.75     260.95     261.05     261.05     261.05     261.15     261.05     261.05     260.75     260.85     260.65     260.35     260.45     260.35     261.35     261.35     261.65     261.75     261.85     261.75     261.85     261.85     261.95     261.95     261.95     261.85     262.05     262.25     262.35     263.05     263.05     263.05     263.35     262.95     262.85     263.65     263.35     264.35     264.85     264.95     265.15     265.05     264.45     264.95     265.55     265.75     265.85     265.95     266.25     266.55     266.65     266.95     267.15     267.25     267.55     267.45     267.55     267.45     267.55     267.55     267.85     268.05     268.25     268.35     268.55     268.35     268.95     268.35     269.05     268.75     268.85     268.75     268.95     268.85     268.95     268.75     268.85     268.95     269.35     269.45     269.25     269.65     269.65     269.65     269.75     269.95     270.15     270.15     270.25     270.35     270.25     270.25     270.55     270.65     270.65     270.65     270.55     270.55     270.55     270.45     270.45     270.35     270.35     270.15     270.15     270.15     270.25     270.25     270.25     270.05     270.25     270.25     270.45     270.35     270.25     270.15     270.35     270.55     270.55     270.45     270.35     270.55     270.55     270.45     270.55     270.55     270.45     270.25     270.15     270.15     270.05     270.05     270.15     268.65     268.55     268.45     268.45     268.35     268.45</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="E_Td">
                    <dwd:value>       0.50       0.50       0.50       0.70       0.80       0.80       1.00       1.10       0.90       1.00       0.90       1.30       0.70       0.90       1.20       0.90       1.10       1.10       0.90       1.00       1.10       1.00       0.90       0.90       1.00       1.00       1.10       1.40       1.40       1.10       1.40       1.30       1.30       1.60       1.70       1.40       1.40       1.40       1.60       1.60       1.60       1.90       1.90       2.00       1.90       1.90       2.10       2.00       2.00       2.10       1.80       2.10       2.10       2.10       2.90       2.70       2.60       2.70       2.80       2.80       2.80       2.90       3.00       3.00       3.00       3.60       3.40       3.50       3.90       4.20       4.40       4.10       3.70       3.60       3.10       3.30       3.50       3.20       3.60       3.70       3.90       3.90       4.00       4.00       4.10       3.90       4.00       4.10       4.40       4.80       4.70       4.70       4.20       4.40       4.40       4.40       4.10       4.00       4.20       3.80       3.90       3.90       4.10       4.40       4.40       4.60       4.80       5.60       5.40       5.30       5.50       5.10       5.10       5.50       5.00       5.00       5.00       4.60       4.90       4.70       4.00       4.60       4.90       4.80       4.30       4.90       5.00       5.20       5.30       5.40       5.30       5.20       5.20       5.20       5.40       5.20       5.20       5.10       5.00       4.90       4.70       5.10       4.70       4.90       4.60       5.40       5.30       5.20       5.20       5.40       5.50       5.60       5.50       5.60       5.60       5.10       5.20       5.50       5.30       5.20       4.70       5.00       4.70       5.00       4.50       4.80       4.80       4.60       4.40       4.40       4.30       4.40       4.30       4.40       4.10       4.10       4.00       4.10       4.20       4.10       4.00       4.00       3.80       3.80       3.70       3.80       3.80       3.90       3.90       3.90       3.90       3.90       3.70       3.70       3.80       3.80       3.70       3.60       3.60       3.60       3.40       3.40       3.40       3.40       3.50       3.30       3.30       3.30       3.30       3.30       3.30       3.40       3.30       3.30       3.30       3.40       3.30       3.30       3.30       3.30       3.30       3.30       3.40       3.40       3.30       3.40       3.40       3.40       3.30       3.40       3.40       3.10       3.00       2.80       2.90       3.00       3.00       2.70       2.80       2.80       2.70       3.00       3.00       3.00       3.00       3.00       3.10</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="TN">
                    <dwd:value>            -          -     268.85          -          -          -          -          -          -          -          -          -          -          -     269.05          -          -          -          -          -          -          -          -          -          -          -     270.95          -          -          -          -          -          -          -          -          -          -          -     271.15          -          -          -          -          -          -          -          -          -          -          -     268.75          -          -          -          -          -          -          -          -          -          -          -     266.25          -          -          -          -          -          -          -          -          -          -          -     264.85          -          -          -          -          -          -          -          -          -          -          -     263.55          -          -          -          -          -          -          -          -          -          -          -     262.35          -          -          -          -          -          -          -          -          -          -          -     261.35          -          -          -          -          -          -          -          -          -          -          -     262.05          -          -          -          -          -          -          -          -          -          -          -     262.45          -          -          -          -          -          -          -          -          -          -          -     262.95          -          -          -          -          -          -          -          -          -          -          -     264.95          -          -          -          -          -          -          -          -          -          -          -     268.15          -          -          -          -          -          -          -          -          -          -          -     269.55          -          -          -          -          -          -          -          -          -          -          -     270.55          -          -          -          -          -          -          -          -          -          -          -     270.75          -          -          -          -          -          -          -          -          -          -          -     270.45          -          -          -          -          -          -          -          -          -          -          -     270.35          -          -          -          -          -          -          -          -          -          -          -     269.55          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="TG">
                    <dwd:value>            -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="TM">
                    <dwd:value>            -          -          -          -          -          -          -          -          -          -          -          -          -          -     270.75          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -     271.95          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -     270.35          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -     265.65          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -     263.05          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -     263.35          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -     265.25          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -     269.15          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -     270.25          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -     270.85          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="T5cm">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="DD">
                    <dwd:value>        53.00      48.00      50.00      46.00      43.00      45.00      38.00      39.00      37.00      35.00      36.00      37.00      37.00      39.00      38.00      37.00      39.00      38.00      40.00      40.00      40.00      44.00      43.00      44.00      41.00      38.00      39.00      33.00      33.00      32.00      32.00      31.00      30.00      30.00      27.00      24.00      25.00      29.00      26.00      29.00      28.00      27.00      26.00      25.00      25.00      20.00      24.00      21.00      15.00      10.00      15.00      14.00      12.00      12.00      14.00       8.00       5.00       5.00       3.00     360.00     355.00     357.00     360.00     358.00     359.00     360.00       3.00       5.00       7.00      15.00       6.00       6.00       4.00     358.00      10.00       5.00       4.00      10.00      10.00      12.00      16.00      15.00      17.00      15.00      14.00      14.00      16.00      17.00      17.00      17.00      15.00      15.00      12.00      13.00      12.00      11.00      13.00      13.00      16.00      15.00      15.00      16.00      14.00      16.00      14.00      15.00      15.00      16.00      19.00      22.00      25.00      30.00      30.00      26.00      27.00      24.00      19.00      19.00      30.00      33.00      35.00      40.00      43.00      50.00      54.00      52.00      31.00      33.00      32.00      36.00      39.00      56.00      58.00      58.00      63.00      71.00      71.00      78.00      79.00      71.00      78.00      84.00      93.00     100.00     116.00     114.00     115.00     118.00     111.00     109.00      97.00      93.00     105.00     108.00     110.00     112.00     132.00     124.00     135.00     132.00     127.00     123.00     134.00     123.00     126.00     125.00     130.00     127.00     136.00     129.00     126.00     126.00     121.00     119.00     122.00     117.00     116.00     112.00     110.00     111.00     111.00     112.00     116.00     116.00     127.00     127.00     129.00     133.00     133.00     132.00     136.00     133.00     138.00     138.00     141.00     140.00     140.00     134.00     127.00     125.00     118.00     121.00     134.00     131.00     135.00     136.00     135.00     148.00     146.00     143.00     145.00     143.00     140.00     139.00     143.00     139.00     145.00     125.00     125.00     121.00     120.00     122.00     118.00     112.00     108.00     105.00     103.00     103.00     107.00     111.00     111.00     108.00     106.00     103.00     103.00     103.00     105.00     105.00     107.00     113.00     110.00      85.00      83.00      83.00      83.00      84.00      84.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="E_DD">
                    <dwd:value>      10.00      13.00       6.00       7.00       6.00       5.00       6.00       7.00      10.00       7.00      10.00       9.00      15.00      12.00       6.00       5.00       5.00       8.00      11.00       8.00       5.00      12.00       6.00      11.00      11.00      10.00       8.00       9.00       9.00      11.00      11.00      14.00       6.00      12.00      15.00      13.00      13.00      17.00      14.00      17.00      12.00       6.00       9.00      11.00       9.00      10.00      16.00      23.00      17.00      16.00      15.00      14.00      13.00      16.00      23.00      22.00      24.00      27.00      28.00      30.00      33.00      39.00      33.00      41.00      35.00      26.00      24.00      23.00      27.00      25.00      26.00      29.00      27.00      23.00      29.00      23.00      29.00      32.00      31.00      24.00      25.00      23.00      25.00      24.00      29.00      24.00      29.00      29.00      20.00      22.00      22.00      20.00      23.00      25.00      24.00      29.00      37.00      31.00      28.00      24.00      25.00      27.00      20.00      28.00      32.00      34.00      35.00      42.00      41.00      40.00      45.00      47.00      47.00      47.00      48.00      49.00      50.00      45.00      51.00      51.00      51.00      57.00      53.00      46.00      48.00      52.00      56.00      53.00      62.00      58.00      59.00      63.00      60.00      61.00      64.00      63.00      63.00      66.00      70.00      74.00      70.00      63.00      61.00      62.00      59.00      58.00      50.00      54.00      54.00      54.00      35.00      44.00      46.00      45.00      42.00      51.00      50.00      50.00      63.00      60.00      56.00      48.00      43.00      47.00      46.00      45.00      41.00      42.00      42.00      45.00      42.00      44.00      46.00      46.00      43.00      45.00      48.00      48.00      49.00      50.00      49.00      42.00      41.00      37.00      46.00      40.00      41.00      45.00      45.00      46.00      48.00      52.00      38.00      61.00      63.00      49.00      70.00      69.00      67.00      72.00      77.00      65.00      61.00      55.00      59.00      70.00      56.00      62.00      62.00      57.00      58.00      58.00      59.00      55.00      61.00      60.00      58.00      59.00      59.00      60.00      60.00      53.00      55.00      55.00      58.00      60.00      61.00      61.00      60.00      48.00      49.00      56.00      56.00      51.00      52.00      54.00      53.00      53.00      55.00      57.00      57.00      73.00      73.00      73.00      73.00      73.00      72.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="FF">
                    <dwd:value>        10.29       8.75       9.77       9.26       8.75       9.26       9.26       9.26       9.26       9.77       9.77       9.77      10.80      10.29      11.32      11.83      12.86      13.38      13.38      13.89      14.40      14.40      14.92      15.43      15.95      16.46      16.46      16.46      15.95      15.43      15.95      15.95      15.95      16.98      16.98      15.95      16.46      15.95      15.95      16.98      15.95      16.98      15.43      14.92      15.43      14.92      14.40      14.40      14.92      14.40      14.40      13.89      13.89      13.89      13.89      13.89      13.38      13.38      12.35      12.35      11.83      12.35      11.83      12.35      12.86      12.86      12.86      12.86      12.35      12.35      12.35      13.38      13.89      13.89      13.38      12.86      12.35      12.86      12.35      12.35      12.86      12.35      12.35      12.35      11.83      11.83      11.83      11.32      11.32      10.80      10.80      11.32      11.32      10.80      10.80      10.80      10.80      10.80      10.29       9.77       9.77       9.26       9.26       8.75       8.75       8.75       8.23       8.23       8.23       7.72       7.20       7.20       6.69       6.17       6.17       5.66       5.66       7.20       7.20       7.20       7.20       6.69       6.17       6.17       6.17       6.17       5.66       6.17       5.66       5.14       5.66       5.66       5.14       5.14       4.12       4.12       4.12       4.12       4.63       4.63       5.14       6.17       6.17       6.17       7.20       7.20       6.69       6.69       7.20       7.20       8.23       8.23       7.20       7.20       7.72       7.72       7.72       7.72       7.72       7.20       7.20       6.69       7.20       7.20       7.20       7.72       7.72       7.72       7.72       7.20       7.72       7.20       6.17       6.17       6.69       6.69       7.72       8.23       8.23       8.23       7.72       7.72       8.23       8.75       8.75       8.75       9.26      10.29       9.77       8.75       9.26       8.75       8.75       7.72       7.72       7.72       7.72       7.20       7.20       7.72       7.72       6.69       6.69       6.17       6.17       6.69       6.69       6.69       7.20       7.72       7.72       7.72       7.20       6.69       6.17       5.66       6.17       6.69       7.20       7.20       7.20       7.20       6.69       6.69       6.69       6.17       6.17       6.17       6.17       6.69       6.69       7.20       7.20       7.20       7.20       7.20       7.20       7.20       7.20       7.20       7.20       7.72       7.72       7.72       7.72       7.72       8.23</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="E_FF">
                    <dwd:value>       1.03       1.54       1.03       1.03       1.03       1.03       1.03       1.03       1.03       1.03       1.03       1.03       1.54       1.54       1.54       1.03       1.54       1.54       2.06       2.06       2.06       2.06       2.06       2.06       2.06       2.06       2.06       2.06       2.06       2.06       2.06       2.06       2.06       2.57       2.57       2.57       2.06       2.06       2.06       2.06       2.57       2.57       2.57       2.57       2.57       3.09       3.09       3.09       3.09       3.60       3.09       2.57       3.09       3.09       2.57       2.57       2.57       2.06       2.57       3.09       2.57       2.57       2.57       2.57       3.09       3.09       3.09       3.09       3.09       3.60       3.09       3.60       3.60       3.60       3.60       3.09       3.09       3.60       3.09       3.09       3.09       3.09       2.57       2.57       2.57       3.09       2.57       3.09       3.09       3.60       3.09       2.57       2.57       3.09       2.57       2.57       2.57       3.09       2.57       3.09       3.09       2.57       2.57       2.57       2.57       2.57       3.09       3.09       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       3.09       2.57       2.57       3.09       3.09       3.09       3.09       3.09       2.57       3.09       3.09       2.57       3.09       2.57       2.57       3.09       3.09       2.57       2.57       2.57       3.09       2.57       2.06       2.06       2.06       2.57       2.06       2.57       2.57       2.06       2.57       2.57       2.57       2.57       2.06       2.57       2.57       2.57       3.09       3.09       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       3.09       3.09       2.57       3.09       3.09       3.09       2.57       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       2.57       2.57       2.57       2.57       2.57       3.09       3.09       3.09       3.09       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       2.57       3.09       3.09       3.09       3.09       2.57       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09       3.09</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="FX1">
                    <dwd:value>           -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="FX3">
                    <dwd:value>           -          -      11.83          -          -      14.40          -          -      14.92          -          -      13.89          -          -      16.98          -          -      20.06          -          -      20.06          -          -      20.06          -          -      20.06          -          -      22.64          -          -      22.12          -          -      21.09          -          -      25.72          -          -      26.24          -          -      24.18          -          -      22.64          -          -      20.06          -          -      19.55          -          -      19.55          -          -      19.03          -          -      16.46          -          -      15.43          -          -      15.43          -          -      15.95          -          -      16.46          -          -      16.46          -          -      15.43          -          -      15.95          -          -      15.95          -          -      15.95          -          -      15.95          -          -      14.92          -          -      13.89          -          -      12.86          -          -      11.83          -          -      10.29          -          -       8.23          -          -       7.20          -          -       6.17          -          -       7.72          -          -       7.72          -          -       6.17          -          -       6.17          -          -       5.66          -          -       5.66          -          -       4.12          -          -       5.14          -          -       6.17          -          -       7.20          -          -       7.72          -          -       8.23          -          -       7.72          -          -       7.72          -          -       7.72          -          -       9.26          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="FX625">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="FX640">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="FX655">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="FXh">
                    <dwd:value>           -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="FXh25">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="FXh40">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="FXh55">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="N">
                    <dwd:value>        100.00     100.00      91.00      91.00      90.00      88.00      91.00      93.00      97.00      96.00      97.00      97.00      97.00      99.00      99.00      99.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00      99.00      99.00      98.00      96.00      93.00      93.00      90.00      86.00      87.00      90.00      88.00      88.00      89.00      89.00      89.00      84.00      85.00      85.00      85.00      87.00      85.00      83.00      82.00      78.00      74.00      73.00      71.00      70.00      69.00      68.00      70.00      68.00      69.00      69.00      69.00      68.00      69.00      68.00      69.00      71.00      71.00      72.00      70.00      70.00      70.00      70.00      70.00      70.00      69.00      68.00      68.00      70.00      69.00      68.00      70.00      81.00      76.00      75.00      80.00      82.00      82.00      82.00      77.00      72.00      69.00      69.00      70.00      71.00      71.00      71.00      71.00      77.00      78.00      76.00      75.00      74.00      73.00      74.00      72.00      72.00      71.00      71.00      72.00      74.00      74.00      75.00      75.00      75.00      75.00      74.00      75.00      75.00      76.00      76.00      78.00      78.00      78.00      78.00      77.00      76.00      75.00      74.00      75.00      76.00      75.00      74.00      76.00      77.00      77.00      78.00      76.00      76.00      76.00      76.00      77.00      77.00      78.00      78.00      78.00      78.00      77.00      78.00      78.00      77.00      76.00      75.00      75.00      75.00      75.00      74.00      74.00      74.00      74.00      75.00      76.00      75.00      75.00      75.00      76.00      76.00      76.00      77.00      77.00      77.00      76.00      76.00      75.00      77.00      76.00      74.00      76.00      75.00      75.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Neff">
                    <dwd:value>      98.00      97.00      91.00      91.00      90.00      88.00      91.00      93.00      94.00      92.00      93.00      93.00      93.00      96.00      97.00      99.00      97.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00      99.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00      97.00      96.00      96.00      93.00      94.00      97.00      92.00      92.00      90.00      92.00      91.00      90.00      89.00      90.00      88.00      86.00      87.00      90.00      88.00      88.00      89.00      89.00      88.00      84.00      84.00      83.00      82.00      80.00      78.00      78.00      80.00      78.00      73.00      73.00      70.00      70.00      69.00      68.00      69.00      68.00      69.00      69.00      69.00      67.00      69.00      68.00      69.00      71.00      71.00      72.00      70.00      69.00      70.00      69.00      70.00      70.00      69.00      66.00      68.00      69.00      66.00      66.00      66.00      70.00      68.00      66.00      67.00      65.00      66.00      66.00      69.00      69.00      69.00      69.00      70.00      71.00      71.00      71.00      70.00      71.00      72.00      72.00      71.00      70.00      69.00      69.00      69.00      69.00      67.00      68.00      69.00      70.00      71.00      72.00      73.00      73.00      75.00      72.00      72.00      73.00      71.00      72.00      73.00      73.00      74.00      73.00      73.00      72.00      72.00      71.00      72.00      73.00      72.00      74.00      73.00      73.00      74.00      74.00      73.00      73.00      73.00      73.00      73.00      73.00      73.00      74.00      73.00      75.00      73.00      74.00      74.00      73.00      71.00      71.00      73.00      73.00      72.00      70.00      70.00      70.00      71.00      71.00      72.00      72.00      72.00      72.00      73.00      73.00      73.00      74.00      74.00      74.00      74.00      74.00      73.00      71.00      71.00      71.00      72.00      72.00      71.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Nlm">
                    <dwd:value>       90.00      89.00      90.00      91.00      89.00      88.00      91.00      93.00      94.00      92.00      93.00      93.00      93.00      96.00      97.00      99.00      97.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00      99.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00      97.00      96.00      96.00      93.00      94.00      97.00      92.00      92.00      90.00      92.00      91.00      90.00      89.00      90.00      88.00      85.00      86.00      90.00      88.00      88.00      89.00      88.00      88.00      83.00      84.00      83.00      82.00      80.00      78.00      78.00      80.00      78.00      72.00      71.00      68.00      66.00      65.00      66.00      69.00      68.00      68.00      68.00      69.00      67.00      67.00      67.00      66.00      69.00      67.00      67.00      65.00      64.00      64.00      61.00      64.00      66.00      64.00      64.00      66.00      63.00      62.00      60.00      66.00      70.00      68.00      66.00      67.00      65.00      66.00      66.00      69.00      69.00      66.00      65.00      66.00      68.00      68.00      66.00      66.00      66.00      68.00      68.00      67.00      65.00      68.00      67.00      68.00      65.00      65.00      66.00      69.00      70.00      70.00      72.00      73.00      73.00      75.00      71.00      70.00      70.00      70.00      69.00      70.00      70.00      69.00      70.00      71.00      71.00      69.00      70.00      70.00      70.00      70.00      71.00      71.00      71.00      71.00      71.00      73.00      72.00      72.00      72.00      71.00      68.00      68.00      68.00      68.00      69.00      68.00      67.00      68.00      66.00      65.00      66.00      65.00      66.00      66.00      66.00      67.00      67.00      68.00      69.00      71.00      69.00      67.00      67.00      67.00      66.00      66.00      66.00      66.00      66.00      67.00      67.00      67.00      70.00      68.00      68.00      68.00      68.00      68.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Nh">
                    <dwd:value>       100.00     100.00       4.00       3.00       4.00       3.00       2.00       0.00       0.00       0.00       0.00       0.00       8.00      16.00      24.00      22.00      21.00      19.00      13.00       7.00       1.00      31.00      60.00      90.00      91.00      92.00      93.00      95.00      98.00     100.00      99.00      99.00      98.00      93.00      87.00      82.00      84.00      86.00      88.00      87.00      85.00      84.00      67.00      50.00      33.00      27.00      20.00      14.00      13.00      12.00      11.00      11.00      10.00      10.00      11.00      12.00      13.00      10.00       8.00       5.00       7.00       9.00      11.00      10.00       8.00       7.00      26.00      46.00      65.00      57.00      48.00      40.00      42.00      45.00      47.00      52.00      56.00      61.00      53.00      45.00      37.00      37.00      38.00      38.00      51.00      64.00      77.00      68.00      58.00      49.00      44.00      38.00      33.00      30.00      28.00      25.00      25.00      25.00      25.00      18.00      10.00       3.00       5.00       1.00       2.00       3.00       3.00       3.00       3.00       6.00       4.00       3.00       2.00       0.00       0.00       0.00       0.00       3.00       6.00       8.00       9.00      10.00      10.00       7.00       2.00       1.00       4.00       5.00       3.00       4.00       4.00       4.00       8.00       7.00      11.00      14.00      16.00      16.00      17.00      21.00      16.00      12.00      14.00      11.00       7.00      19.00      18.00      20.00       5.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00      10.00      11.00      11.00      10.00      11.00      13.00      15.00      31.00      30.00      24.00      26.00      25.00      17.00      20.00      11.00      18.00      18.00      17.00       8.00      14.00      14.00      12.00      10.00       6.00       0.00      11.00      15.00      17.00      19.00      23.00      27.00      26.00      31.00      27.00      23.00      15.00      17.00      13.00      17.00      19.00      18.00      12.00      17.00      20.00      22.00      23.00      14.00      14.00      15.00      16.00      19.00      29.00      31.00      33.00      33.00      30.00      28.00      34.00      32.00      32.00      31.00      25.00      30.00      28.00      26.00      22.00      21.00      21.00      19.00      20.00      18.00      20.00      23.00      24.00      26.00      31.00      31.00      32.00      33.00      32.00      29.00      27.00      26.00      24.00      26.00      19.00      24.00      23.00      23.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Nm">
                    <dwd:value>         3.00      10.00      42.00      36.00      30.00      23.00      39.00      56.00      74.00      70.00      70.00      67.00      67.00      70.00      72.00      81.00      90.00     100.00      97.00      97.00      96.00      97.00      97.00      98.00      99.00      99.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00      92.00      85.00      77.00      73.00      70.00      66.00      65.00      64.00      63.00      43.00      22.00       2.00      12.00      22.00      32.00      27.00      21.00      16.00      18.00      19.00      21.00      14.00       7.00       0.00       6.00      13.00      19.00      36.00      53.00      70.00      77.00      83.00      90.00      93.00      97.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00      97.00      96.00      96.00      93.00      94.00      97.00      92.00      92.00      89.00      88.00      68.00      48.00      29.00      21.00      11.00       3.00       2.00       1.00       0.00       0.00       0.00       0.00       1.00       1.00       2.00      14.00      28.00      38.00      40.00      43.00      42.00      30.00      21.00      13.00       8.00      10.00       1.00       0.00       0.00       2.00       2.00       6.00       5.00       1.00       2.00       5.00       5.00       8.00       8.00       8.00       2.00       5.00       3.00       0.00       4.00       0.00       5.00       1.00       8.00       7.00      12.00       7.00      19.00      37.00      38.00      36.00      46.00      49.00      49.00      48.00      34.00      22.00       4.00       5.00       2.00       2.00       3.00       2.00       0.00       2.00       0.00       0.00       0.00       0.00       7.00       7.00       8.00       5.00       2.00       0.00       6.00       2.00       3.00       8.00       8.00      10.00      16.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00       3.00       3.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       5.00       1.00       1.00       1.00       0.00       0.00       0.00       0.00       0.00       1.00       1.00       0.00       5.00       1.00       1.00       1.00       1.00       1.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Nl">
                    <dwd:value>        90.00      87.00      83.00      86.00      84.00      84.00      86.00      85.00      90.00      87.00      89.00      90.00      90.00      94.00      94.00      95.00      96.00      91.00      90.00      95.00      99.00      98.00      98.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00      99.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00      99.00      95.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00     100.00      97.00      96.00      95.00      92.00      93.00      93.00      92.00      92.00      90.00      92.00      91.00      90.00      86.00      89.00      88.00      85.00      86.00      90.00      88.00      88.00      89.00      88.00      88.00      83.00      84.00      82.00      78.00      80.00      75.00      70.00      69.00      68.00      65.00      66.00      65.00      63.00      65.00      66.00      69.00      67.00      67.00      66.00      67.00      67.00      67.00      65.00      65.00      66.00      64.00      64.00      64.00      62.00      62.00      61.00      63.00      66.00      62.00      64.00      63.00      60.00      57.00      57.00      61.00      70.00      60.00      61.00      63.00      64.00      64.00      65.00      66.00      64.00      64.00      64.00      66.00      67.00      67.00      66.00      66.00      65.00      68.00      68.00      67.00      65.00      65.00      65.00      65.00      64.00      64.00      66.00      67.00      69.00      69.00      69.00      70.00      70.00      70.00      71.00      70.00      70.00      70.00      69.00      70.00      70.00      69.00      70.00      71.00      71.00      69.00      70.00      70.00      70.00      70.00      71.00      71.00      71.00      71.00      71.00      73.00      72.00      72.00      71.00      71.00      68.00      68.00      68.00      68.00      69.00      68.00      67.00      68.00      66.00      65.00      66.00      65.00      66.00      66.00      66.00      67.00      67.00      68.00      69.00      71.00      67.00      67.00      67.00      67.00      66.00      66.00      66.00      66.00      66.00      66.00      67.00      67.00      68.00      68.00      68.00      68.00      68.00      67.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="N05">
                    <dwd:value>       19.00      19.00      21.00      31.00      22.00      18.00      27.00      13.00      14.00      13.00      21.00      19.00      13.00      16.00      16.00      20.00      26.00      34.00      34.00      29.00      27.00      29.00      30.00      27.00      26.00      24.00      25.00      31.00      17.00      18.00      18.00      17.00      33.00      26.00      23.00      28.00      22.00      19.00      23.00      18.00      18.00      15.00      18.00      26.00      22.00      28.00      24.00      21.00      18.00      14.00      12.00      10.00      12.00      18.00      14.00      15.00      18.00      13.00      15.00      14.00      17.00      18.00      15.00      14.00      15.00      23.00      23.00      33.00      33.00      33.00      43.00      35.00      28.00      22.00      23.00      18.00      19.00      20.00      20.00      17.00      16.00      21.00      18.00      17.00      20.00      12.00      11.00      14.00      16.00      18.00      17.00      19.00      25.00      24.00      16.00      16.00      15.00      12.00      12.00      11.00       9.00      10.00      11.00      10.00      10.00       9.00       8.00      10.00      10.00       7.00       9.00       9.00       8.00       8.00      14.00       8.00      10.00       9.00       9.00       9.00       7.00       6.00       5.00       6.00       6.00       6.00       5.00       5.00       4.00       5.00       5.00       5.00       9.00       5.00       5.00       6.00       9.00       9.00       8.00       8.00      10.00      10.00      12.00      10.00      10.00       8.00       5.00       4.00       1.00       3.00       4.00       7.00       9.00       8.00       7.00       5.00       5.00       6.00       7.00       8.00       6.00       9.00       9.00       6.00       6.00       6.00      10.00       7.00       6.00       5.00       5.00       5.00       8.00       6.00       9.00       9.00       9.00       9.00       9.00       6.00       8.00       6.00       8.00       9.00       9.00      11.00      11.00       9.00       9.00      10.00      10.00       9.00       7.00       7.00       9.00       9.00       9.00       6.00       6.00       6.00       6.00       6.00       6.00       6.00       7.00       8.00       8.00      10.00       8.00      10.00       8.00       6.00       8.00      10.00       9.00       8.00       7.00       6.00       6.00       6.00       6.00       5.00       5.00       4.00       4.00       4.00       5.00       5.00       4.00       5.00       4.00       5.00       5.00       7.00       7.00       6.00       8.00       8.00       8.00       7.00       7.00       6.00       6.00       6.00       6.00       6.00       6.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="VV">
                    <dwd:value>      2100.00    4700.00    3000.00    3800.00    5200.00    5500.00    4600.00    4500.00    6400.00    8800.00    6800.00    5700.00    6800.00    5700.00    5600.00    4700.00    3700.00    3800.00    2500.00    1800.00    1700.00    1100.00    1200.00    1200.00    1300.00    1400.00    1200.00    1500.00    1200.00    1800.00    1700.00    1300.00     900.00    1200.00    1200.00    1100.00    1500.00    1400.00    1700.00    1500.00    2400.00    1800.00    2100.00    1600.00    2200.00    2500.00    2200.00    1800.00    2900.00    3500.00    4000.00    3900.00    2700.00    2100.00    2900.00    2600.00    3100.00    2800.00    2600.00    2900.00    2800.00    3100.00    3000.00    2800.00    2600.00    2100.00    1600.00    1400.00    1300.00    1400.00    1300.00    1300.00    1400.00    2600.00    2900.00    3300.00    2300.00    2600.00    2900.00    3900.00    2800.00    3000.00    3200.00    2700.00    3600.00    4000.00    4500.00    4200.00    4400.00    3500.00    4000.00    3700.00    4100.00    4700.00    4800.00    4300.00    5100.00    6300.00    6400.00    6200.00    5400.00    4900.00    5500.00    5600.00    6200.00    7000.00    7400.00    8100.00    8000.00    8300.00    8500.00    6500.00    6200.00    5900.00    4900.00    6300.00    7400.00   10700.00   10900.00    9800.00   11100.00    9100.00   11800.00   11800.00   12600.00   10600.00   11300.00   11600.00    9400.00   12000.00   11100.00   12400.00   13000.00   13400.00   13300.00   11100.00   11600.00   10700.00   10400.00   12900.00   13500.00   11400.00   12200.00   11800.00   12600.00   10400.00   10700.00   10500.00   11100.00   11600.00   10000.00    8500.00    8500.00    8300.00    8200.00    8200.00    8600.00   10700.00   10900.00    9900.00   11100.00   10600.00   10300.00   10500.00   11400.00   11900.00   10900.00   10700.00   11000.00   12400.00   13200.00   12900.00   12900.00   12800.00   11600.00   10200.00    9200.00    9700.00    9400.00    9300.00    9100.00    9300.00    9700.00    9700.00    9700.00    9300.00    8400.00    8500.00    9000.00    8900.00    8600.00    8200.00   10200.00   11300.00   12500.00   12500.00   11900.00   12000.00   11800.00   10200.00   12900.00   13100.00   13000.00   12700.00   11100.00   11200.00   11000.00   11500.00   11000.00    9600.00    8300.00    8400.00    8200.00    7700.00    8600.00    7900.00    8300.00    9300.00    9900.00   10700.00   10900.00    9700.00   10400.00   11200.00   13100.00   12700.00   12300.00   12700.00   12600.00   12800.00   13500.00   13600.00   12100.00   11900.00   11700.00   11900.00   11600.00   11700.00   11400.00   11400.00   11600.00   10300.00   10600.00   11000.00   12400.00   12500.00   12400.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="VV10">
                    <dwd:value>      19.00      22.00      13.00      23.00      25.00      26.00      13.00      12.00      14.00      14.00      14.00      17.00       4.00       4.00       7.00      14.00      15.00      17.00      23.00      37.00      36.00      53.00      40.00      24.00      31.00      31.00      52.00      24.00      24.00      23.00      37.00      57.00      46.00      39.00      31.00      31.00      43.00      45.00      44.00      49.00      21.00      26.00      36.00      45.00      23.00      28.00      32.00      37.00      35.00      25.00      37.00      14.00      28.00      29.00      27.00      34.00      13.00      19.00      17.00      38.00      24.00      24.00      21.00      20.00      36.00      29.00      42.00      56.00      37.00      33.00      29.00      20.00      18.00      14.00      14.00      25.00      18.00      16.00      34.00      37.00      29.00      22.00      52.00      28.00      27.00      17.00      14.00      31.00      27.00      26.00      39.00      46.00      41.00      38.00      39.00      32.00      34.00      28.00      18.00      11.00      11.00       4.00      20.00      17.00      19.00      17.00      15.00      11.00       8.00       6.00      22.00       7.00      10.00      11.00      12.00      10.00       7.00       5.00       9.00       6.00       7.00       7.00       8.00       7.00       8.00       8.00       6.00       4.00       5.00      10.00       6.00       7.00       3.00       4.00       8.00       8.00       8.00       8.00       9.00       6.00       5.00       8.00       5.00       4.00       6.00       6.00       5.00       4.00       6.00       5.00       5.00       7.00       7.00       8.00       9.00       9.00       7.00       5.00       6.00       4.00       3.00       3.00       4.00       4.00       8.00       8.00       6.00       4.00       3.00       4.00       6.00       2.00       8.00       8.00       7.00       6.00       7.00       7.00       7.00       7.00       7.00       7.00       6.00       6.00       6.00       7.00       5.00       5.00       5.00       5.00       7.00       7.00       8.00       7.00       7.00       7.00       6.00       7.00       7.00       7.00       7.00       7.00       5.00       4.00       5.00       4.00       5.00       4.00       6.00       7.00       6.00       6.00       5.00       6.00       6.00       8.00       7.00       7.00       7.00       6.00       3.00       3.00       3.00       6.00       7.00       7.00       6.00       4.00       4.00       4.00       4.00       4.00       5.00       5.00       5.00       6.00       6.00       5.00       6.00       7.00       5.00       5.00       5.00       5.00       5.00       5.00       5.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwM">
                    <dwd:value>        2.00      14.00       5.00      13.00      14.00      17.00      14.00      14.00       6.00       7.00       4.00       4.00       6.00       7.00       6.00       8.00       9.00      10.00      11.00      12.00      14.00      14.00      15.00      20.00      13.00      12.00      10.00      10.00      11.00      11.00       9.00      11.00      19.00      12.00      45.00      39.00      36.00      15.00      15.00      21.00      21.00      23.00      19.00       8.00       7.00       6.00       8.00       9.00       8.00       6.00       7.00       7.00       7.00      11.00      16.00      17.00      11.00      11.00      14.00      14.00      14.00      11.00      13.00      14.00      33.00      46.00      42.00      28.00      25.00      23.00      23.00      14.00      20.00       4.00       4.00      10.00       6.00       9.00       8.00       8.00       5.00      34.00      34.00      43.00      40.00      33.00      32.00      24.00      23.00      30.00      29.00      16.00      10.00      12.00      10.00      10.00       3.00       9.00      22.00      14.00      19.00      19.00       4.00       6.00       7.00       7.00       7.00       5.00       5.00       4.00       4.00       6.00       4.00       5.00      12.00      25.00       0.00       3.00       0.00       0.00       7.00       1.00       1.00       3.00       3.00       2.00       3.00       1.00       2.00       3.00       2.00       5.00       6.00       3.00       7.00       6.00       6.00       5.00       6.00       5.00       5.00       4.00       6.00       6.00       5.00       5.00       3.00       3.00       4.00       4.00       4.00       3.00       5.00       5.00       5.00       5.00       5.00       4.00       5.00       5.00       7.00       4.00       4.00       4.00       4.00       4.00       3.00       3.00       4.00       4.00       3.00       4.00       4.00       4.00       4.00       5.00       5.00       5.00       5.00       5.00       7.00       4.00       5.00       5.00       7.00       8.00       7.00       6.00       4.00       4.00       5.00       5.00       5.00       4.00       5.00       4.00       4.00       4.00       4.00       4.00       5.00       5.00       5.00       5.00       5.00       5.00       4.00       5.00       6.00       6.00       5.00       5.00       5.00       5.00       5.00       5.00       5.00       4.00       4.00       4.00       4.00       4.00       4.00       4.00       5.00       5.00       5.00       5.00       5.00       5.00       4.00       5.00       6.00       6.00       5.00       5.00       5.00       5.00       5.00       5.00       5.00       4.00       4.00       4.00       4.00       4.00       4.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwM6">
                    <dwd:value>      69.00      38.00       4.00      13.00      20.00      26.00      31.00      36.00      30.00      30.00      20.00      14.00      12.00      15.00      11.00      18.00      19.00      19.00      23.00      26.00      31.00      37.00      44.00      50.00          -          -      46.00      38.00      31.00      23.00      30.00      36.00      37.00      44.00      45.00      47.00      47.00      48.00      46.00      50.00      52.00      57.00      55.00      55.00      56.00      49.00      42.00      35.00      31.00      27.00      20.00      21.00      20.00      19.00      23.00      27.00      31.00      33.00      34.00      36.00      37.00      39.00      39.00      51.00      61.00      72.00      59.00      47.00      59.00      38.00      40.00      43.00      43.00      43.00      35.00      37.00      31.00      25.00      26.00      26.00      25.00      37.00      46.00      55.00      46.00      37.00      43.00      31.00      36.00      42.00      37.00      33.00      35.00      36.00      42.00      49.00      46.00      43.00      40.00      31.00      21.00      22.00      22.00      33.00      32.00      36.00      29.00      21.00      18.00      14.00       9.00      12.00      13.00      11.00      16.00      19.00      25.00      17.00      13.00      25.00       9.00       8.00       8.00       7.00       7.00       7.00       7.00       7.00       7.00       7.00       6.00       9.00       8.00      11.00      13.00      12.00      11.00      11.00      11.00      11.00      12.00      12.00      13.00      14.00      14.00      13.00      13.00      11.00       8.00       7.00       7.00       8.00       9.00      10.00      12.00      13.00      13.00      12.00      12.00      12.00      12.00      12.00      12.00      12.00      12.00      12.00      12.00      13.00      12.00      11.00      11.00      10.00      10.00      10.00      10.00      11.00      11.00      12.00      12.00      12.00      13.00      15.00      16.00      15.00      15.00      14.00      16.00      17.00      19.00      19.00      19.00      17.00      18.00      17.00      15.00      15.00      14.00      13.00      13.00      12.00      11.00      12.00      12.00      12.00      12.00      12.00      11.00      14.00      16.00      18.00      19.00      18.00      18.00      18.00      17.00      17.00      16.00      15.00      15.00      13.00      12.00      12.00      12.00      12.00      12.00      12.00      12.00      12.00      13.00      13.00      14.00      15.00      16.00      17.00      16.00      15.00      14.00      14.00      14.00      14.00      13.00      13.00      12.00      12.00      12.00      11.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwMh">
                    <dwd:value>          -          -      99.00          -          -          -          -          -      32.00          -          -          -          -          -      30.00          -          -          -          -          -      42.00          -          -          -          -          -      63.00          -          -          -          -          -      51.00          -          -          -          -          -      58.00          -          -          -          -          -      56.00          -          -          -          -          -      56.00          -          -          -          -          -      37.00          -          -          -          -          -      45.00          -          -          -          -          -      59.00          -          -          -          -          -      59.00          -          -          -          -          -      51.00          -          -          -          -          -      59.00          -          -          -          -          -      60.00          -          -          -          -          -      47.00          -          -          -          -          -      40.00          -          -          -          -          -      41.00          -          -          -          -          -      24.00          -          -          -          -          -      25.00          -          -          -          -          -      15.00          -          -          -          -          -      17.00          -          -          -          -          -      19.00          -          -          -          -          -      22.00          -          -          -          -          -      21.00          -          -          -          -          -      19.00          -          -          -          -          -      19.00          -          -          -          -          -      23.00          -          -          -          -          -      22.00          -          -          -          -          -      17.00          -          -          -          -          -      25.00          -          -          -          -          -      28.00          -          -          -          -          -      26.00          -          -          -          -          -      22.00          -          -          -          -          -      27.00          -          -          -          -          -      25.00          -          -          -          -          -      26.00          -          -          -          -          -      17.00          -          -          -          -          -      16.00          -          -          -          -          -      20.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwMd">
                    <dwd:value>          -          -          -          -          -          -          -          -      99.00          -          -          -          -          -          -          -          -          -          -          -      43.00          -          -          -          -          -          -          -          -          -          -          -      67.00          -          -          -          -          -          -          -          -          -          -          -      67.00          -          -          -          -          -          -          -          -          -          -          -      58.00          -          -          -          -          -          -          -          -          -          -          -      73.00          -          -          -          -          -          -          -          -          -          -          -      73.00          -          -          -          -          -          -          -          -          -          -          -      70.00          -          -          -          -          -          -          -          -          -          -          -      60.00          -          -          -          -          -          -          -          -          -          -          -      56.00          -          -          -          -          -          -          -          -          -          -          -      26.00          -          -          -          -          -          -          -          -          -          -          -      23.00          -          -          -          -          -          -          -          -          -          -          -      40.00          -          -          -          -          -          -          -          -          -          -          -      40.00          -          -          -          -          -          -          -          -          -          -          -      35.00          -          -          -          -          -          -          -          -          -          -          -      45.00          -          -          -          -          -          -          -          -          -          -          -      47.00          -          -          -          -          -          -          -          -          -          -          -      43.00          -          -          -          -          -          -          -          -          -          -          -      42.00          -          -          -          -          -          -          -          -          -          -          -      31.00          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="ww">
                    <dwd:value>         3.00      71.00      71.00      71.00      71.00      71.00       3.00       3.00      71.00      71.00      71.00      71.00       3.00       3.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      85.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      85.00      71.00      71.00      71.00      71.00      71.00      71.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00       3.00      85.00       2.00       2.00      85.00       2.00       2.00       2.00       2.00       2.00       2.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00       3.00       3.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00      85.00      85.00      85.00       3.00       3.00       3.00       3.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00      85.00       2.00       2.00       2.00       2.00       3.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="ww3">
                    <dwd:value>           -          -      71.00          -          -      71.00          -          -       3.00          -          -       3.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      85.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -       3.00          -          -      71.00          -          -      71.00          -          -       2.00          -          -      71.00          -          -       2.00          -          -      85.00          -          -      85.00          -          -       3.00          -          -       2.00          -          -      71.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -      71.00          -          -      85.00          -          -      71.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -      71.00          -          -      71.00          -          -       2.00          -          -      71.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -       2.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="W1W2">
                    <dwd:value>          -          -      70.00          -          -          -          -          -      70.00          -          -          -          -          -      30.00          -          -          -          -          -      77.00          -          -          -          -          -      74.00          -          -          -          -          -      77.00          -          -          -          -          -      77.00          -          -          -          -          -      77.00          -          -          -          -          -      87.00          -          -          -          -          -      87.00          -          -          -          -          -      87.00          -          -          -          -          -      77.00          -          -          -          -          -      77.00          -          -          -          -          -      77.00          -          -          -          -          -      87.00          -          -          -          -          -      77.00          -          -          -          -          -      70.00          -          -          -          -          -      87.00          -          -          -          -          -      88.00          -          -          -          -          -      87.00          -          -          -          -          -      87.00          -          -          -          -          -      80.00          -          -          -          -          -      80.00          -          -          -          -          -      20.00          -          -          -          -          -      84.00          -          -          -          -          -      87.00          -          -          -          -          -      87.00          -          -          -          -          -      20.00          -          -          -          -          -      87.00          -          -          -          -          -      87.00          -          -          -          -          -      70.00          -          -          -          -          -      20.00          -          -          -          -          -      70.00          -          -          -          -          -      70.00          -          -          -          -          -      70.00          -          -          -          -          -      20.00          -          -          -          -          -      87.00          -          -          -          -          -      70.00          -          -          -          -          -      20.00          -          -          -          -          -      20.00          -          -          -          -          -      80.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwP">
                    <dwd:value>       26.00      52.00      48.00      51.00      44.00      42.00      36.00      36.00      49.00      53.00      44.00      45.00      34.00      38.00      43.00      51.00      51.00      53.00      57.00      55.00      67.00      72.00      69.00      75.00      78.00      79.00      77.00      75.00      71.00      70.00      73.00      75.00      78.00      79.00      81.00      85.00      81.00      79.00      61.00      62.00      58.00      60.00      62.00      61.00      59.00      64.00      55.00      57.00      54.00      52.00      52.00      57.00      53.00      50.00      52.00      64.00      67.00      70.00      71.00      63.00      70.00      64.00      53.00      55.00      53.00      56.00      60.00      55.00      60.00      63.00      64.00      64.00      66.00      70.00      63.00      56.00      61.00      55.00      56.00      63.00      65.00      70.00      65.00      66.00      64.00      48.00      52.00      56.00      44.00      42.00      45.00      40.00      42.00      44.00      50.00      44.00      46.00      44.00      45.00      47.00      48.00      50.00      51.00      54.00      50.00      56.00      53.00      50.00      51.00      43.00      47.00      45.00      42.00      40.00      43.00      35.00      35.00      40.00      32.00      36.00      38.00      37.00      40.00      38.00      41.00      42.00      47.00      49.00      50.00      53.00      47.00      47.00      41.00      37.00      37.00      36.00      32.00      32.00      30.00      28.00      28.00      26.00      23.00      21.00      24.00      22.00      25.00      24.00      21.00      25.00      24.00      30.00      38.00      41.00      43.00      47.00      38.00      37.00      34.00      32.00      27.00      21.00      21.00      23.00      24.00      28.00      26.00      27.00      24.00      24.00      31.00      30.00      37.00      34.00      32.00      34.00      34.00      42.00      40.00      36.00      34.00      37.00      30.00      35.00      33.00      32.00      33.00      34.00      32.00      32.00      29.00      31.00      33.00      33.00      33.00      32.00      32.00      32.00      28.00      34.00      31.00      31.00      28.00      31.00      34.00      32.00      32.00      29.00      29.00      28.00      31.00      27.00      30.00      34.00      34.00      33.00      31.00      30.00      30.00      31.00      28.00      28.00      25.00      28.00      26.00      28.00      30.00      29.00      29.00      29.00      29.00      29.00      28.00      28.00      28.00      26.00      26.00      27.00      27.00      27.00      27.00      34.00      33.00      32.00      32.00      32.00      34.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwP6">
                    <dwd:value>     100.00     100.00      97.00      94.00      88.00      83.00      85.00      87.00      83.00      90.00      91.00      84.00      89.00      88.00      87.00      89.00      91.00      93.00      92.00      91.00      91.00      91.00      92.00      93.00          -          -      92.00      93.00      94.00      95.00      94.00      92.00      91.00      92.00      93.00      94.00      92.00      91.00      89.00      90.00      91.00      92.00      91.00      90.00      88.00      89.00      90.00      91.00      89.00      87.00      79.00      84.00      83.00      81.00      84.00      87.00      87.00      91.00      92.00      91.00      91.00      90.00      88.00      87.00      85.00      84.00      83.00      82.00      81.00      83.00      86.00      88.00      88.00      88.00      88.00      87.00      86.00      85.00      85.00      86.00      82.00      88.00      89.00      90.00      90.00      89.00      87.00      88.00      87.00      82.00      84.00      82.00      78.00      78.00      77.00      74.00      76.00      77.00      76.00      80.00      81.00      75.00      84.00      85.00      77.00      87.00      88.00      88.00      88.00      87.00      84.00      85.00      84.00      79.00      81.00      80.00      75.00      76.00      73.00      73.00      70.00      69.00      75.00      71.00      75.00      80.00      79.00      80.00      81.00      81.00      82.00      82.00      80.00      78.00      73.00      75.00      74.00      66.00      71.00      68.00      64.00      63.00      60.00      58.00      55.00      53.00      53.00      52.00      53.00      52.00      61.00      67.00      58.00      75.00      78.00      69.00      81.00      81.00      78.00      73.00      66.00      56.00      55.00      51.00      48.00      46.00      43.00      49.00      43.00      46.00      52.00      53.00      57.00      62.00      63.00      64.00      63.00      65.00      66.00      60.00      67.00      68.00      63.00      63.00      58.00      53.00      55.00      56.00      58.00      59.00      60.00      62.00      61.00      60.00      59.00      62.00      65.00      69.00      66.00      63.00      60.00      61.00      62.00      63.00      65.00      68.00      70.00      70.00      70.00      60.00      68.00      66.00      62.00      65.00      66.00      68.00      65.00      62.00      59.00      61.00      64.00      65.00      65.00      63.00      60.00      60.00      59.00      58.00      58.00      59.00      59.00      59.00      59.00      58.00      58.00      58.00      58.00      59.00      60.00      60.00      62.00      64.00      66.00      66.00      65.00      65.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwPh">
                    <dwd:value>          -          -     100.00          -          -          -          -          -      98.00          -          -          -          -          -      95.00          -          -          -          -          -      98.00          -          -          -          -          -      97.00          -          -          -          -          -      97.00          -          -          -          -          -      94.00          -          -          -          -          -      96.00          -          -          -          -          -      96.00          -          -          -          -          -      96.00          -          -          -          -          -      96.00          -          -          -          -          -      96.00          -          -          -          -          -      96.00          -          -          -          -          -      94.00          -          -          -          -          -      94.00          -          -          -          -          -      94.00          -          -          -          -          -      87.00          -          -          -          -          -      92.00          -          -          -          -          -      91.00          -          -          -          -          -      94.00          -          -          -          -          -      87.00          -          -          -          -          -      91.00          -          -          -          -          -      91.00          -          -          -          -          -      84.00          -          -          -          -          -      82.00          -          -          -          -          -      71.00          -          -          -          -          -      86.00          -          -          -          -          -      86.00          -          -          -          -          -      71.00          -          -          -          -          -      85.00          -          -          -          -          -      77.00          -          -          -          -          -      77.00          -          -          -          -          -      78.00          -          -          -          -          -      72.00          -          -          -          -          -      78.00          -          -          -          -          -      86.00          -          -          -          -          -      74.00          -          -          -          -          -      71.00          -          -          -          -          -      72.00          -          -          -          -          -      74.00          -          -          -          -          -      80.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwPd">
                    <dwd:value>          -          -          -          -          -          -          -          -     100.00          -          -          -          -          -          -          -          -          -          -          -     100.00          -          -          -          -          -          -          -          -          -          -          -      99.00          -          -          -          -          -          -          -          -          -          -          -     100.00          -          -          -          -          -          -          -          -          -          -          -      99.00          -          -          -          -          -          -          -          -          -          -          -     100.00          -          -          -          -          -          -          -          -          -          -          -      99.00          -          -          -          -          -          -          -          -          -          -          -      99.00          -          -          -          -          -          -          -          -          -          -          -      97.00          -          -          -          -          -          -          -          -          -          -          -      98.00          -          -          -          -          -          -          -          -          -          -          -      99.00          -          -          -          -          -          -          -          -          -          -          -      98.00          -          -          -          -          -          -          -          -          -          -          -      94.00          -          -          -          -          -          -          -          -          -          -          -      96.00          -          -          -          -          -          -          -          -          -          -          -      97.00          -          -          -          -          -          -          -          -          -          -          -      92.00          -          -          -          -          -          -          -          -          -          -          -      94.00          -          -          -          -          -          -          -          -          -          -          -      90.00          -          -          -          -          -          -          -          -          -          -          -      94.00          -          -          -          -          -          -          -          -          -          -          -      87.00          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwZ">
                    <dwd:value>        2.00       2.00       3.00       3.00       3.00       3.00       2.00       1.00       2.00       4.00       3.00       3.00       2.00       3.00       2.00       3.00       3.00       3.00       3.00       3.00       4.00       6.00       5.00       5.00       3.00       4.00       6.00       6.00       5.00       7.00       8.00       6.00       8.00       5.00       5.00       4.00       4.00       5.00       2.00       2.00       4.00       3.00       3.00       4.00       2.00       1.00       1.00       2.00       2.00       1.00       2.00       3.00       3.00       3.00       2.00       3.00       1.00       3.00       2.00       1.00       2.00       3.00       0.00       0.00       0.00       2.00       0.00       1.00       3.00       2.00       2.00       1.00       0.00       0.00       0.00       2.00       2.00       1.00       1.00       2.00       1.00       1.00       1.00       0.00       0.00       0.00       1.00       1.00       1.00       1.00       0.00       0.00       1.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00       2.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00       0.00       1.00       0.00       1.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00       0.00       1.00       0.00       0.00       0.00       0.00       1.00       1.00       1.00       1.00       0.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       0.00       1.00       0.00       0.00       1.00       0.00       0.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwZ6">
                    <dwd:value>       5.00      11.00      16.00      14.00      12.00      10.00       9.00       8.00       7.00       6.00       6.00       8.00       6.00       6.00       8.00       9.00      11.00      12.00      17.00      22.00      19.00      26.00      25.00      25.00          -          -      28.00      28.00      28.00      28.00      29.00      30.00      31.00      28.00      25.00      23.00      22.00      22.00      22.00      20.00      18.00      15.00      16.00      18.00      16.00      17.00      14.00      12.00      12.00      11.00       9.00      13.00      15.00      13.00      15.00      13.00      11.00       8.00       5.00       4.00       4.00       7.00       5.00       6.00       3.00       3.00       2.00       3.00       3.00       3.00       2.00       3.00       1.00       2.00       2.00       3.00       3.00       4.00       5.00       6.00       5.00       7.00       7.00       6.00       4.00       2.00       2.00       1.00       1.00       1.00       1.00       1.00       2.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       2.00       1.00       2.00       1.00       1.00       2.00       3.00       1.00       2.00       2.00       0.00       2.00       3.00       3.00       4.00       2.00       2.00       1.00       1.00       0.00       1.00       1.00       0.00       1.00       1.00       1.00       1.00       1.00       1.00       2.00       2.00       1.00       1.00       1.00       1.00       1.00       1.00       2.00       1.00       1.00       1.00       0.00       0.00       1.00       0.00       1.00       1.00       1.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       1.00       1.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       3.00       3.00       4.00       4.00       3.00       5.00       5.00       4.00       4.00       2.00       2.00       3.00       4.00       4.00       5.00       4.00       3.00       4.00       4.00       5.00       5.00       5.00       5.00       5.00       4.00       4.00       4.00       4.00       5.00       5.00       5.00       5.00       5.00       6.00       6.00       6.00       6.00       5.00       6.00       5.00       5.00       5.00       5.00       5.00       5.00       5.00       5.00       5.00       5.00       5.00       4.00       4.00       4.00       5.00       5.00       5.00       5.00       5.00       5.00       5.00       5.00       4.00       4.00       4.00       4.00       3.00       3.00       3.00       3.00       4.00       4.00       4.00       3.00       3.00       3.00       4.00       5.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwZh">
                    <dwd:value>          -          -      19.00          -          -          -          -          -      21.00          -          -          -          -          -      12.00          -          -          -          -          -      23.00          -          -          -          -          -      35.00          -          -          -          -          -      45.00          -          -          -          -          -      31.00          -          -          -          -          -      32.00          -          -          -          -          -      25.00          -          -          -          -          -      20.00          -          -          -          -          -      11.00          -          -          -          -          -       5.00          -          -          -          -          -       4.00          -          -          -          -          -       5.00          -          -          -          -          -       6.00          -          -          -          -          -       2.00          -          -          -          -          -       3.00          -          -          -          -          -       2.00          -          -          -          -          -       1.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       1.00          -          -          -          -          -       1.00          -          -          -          -          -       1.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       3.00          -          -          -          -          -       5.00          -          -          -          -          -       7.00          -          -          -          -          -       8.00          -          -          -          -          -       6.00          -          -          -          -          -       6.00          -          -          -          -          -       8.00          -          -          -          -          -       9.00          -          -          -          -          -       9.00          -          -          -          -          -       9.00          -          -          -          -          -       9.00          -          -          -          -          -       8.00          -          -          -          -          -       4.00          -          -          -          -          -       4.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwD">
                    <dwd:value>       22.00      45.00      40.00      48.00      37.00      35.00      27.00      27.00      39.00      36.00      35.00      33.00      24.00      23.00      25.00      30.00      33.00      45.00      47.00      46.00      52.00      55.00      53.00      58.00      60.00      64.00      64.00      65.00      63.00      63.00      61.00      61.00      60.00      56.00      55.00      65.00      54.00      53.00      44.00      50.00      45.00      44.00      47.00      45.00      41.00      44.00      35.00      40.00      40.00      39.00      40.00      40.00      34.00      32.00      34.00      32.00      37.00      41.00      43.00      46.00      39.00      40.00      41.00      39.00      39.00      42.00      45.00      43.00      47.00      48.00      50.00      47.00      47.00      50.00      46.00      42.00      39.00      35.00      39.00      44.00      47.00      45.00      43.00      46.00      45.00      33.00      28.00      40.00      33.00      33.00      32.00      28.00      26.00      28.00      36.00      33.00      21.00      31.00      27.00      27.00      25.00      25.00      26.00      24.00      11.00      10.00      10.00      13.00      13.00      15.00      14.00      12.00      17.00      18.00      18.00      13.00      12.00      13.00      17.00      17.00      16.00      16.00      11.00      10.00      13.00      11.00      12.00      16.00      12.00      12.00       7.00      11.00      12.00       6.00       5.00       7.00      12.00      10.00      11.00      12.00      11.00      10.00      10.00       8.00       7.00       5.00      13.00      13.00       7.00       8.00       5.00       8.00       8.00       7.00      11.00      16.00       9.00       9.00       8.00      12.00       9.00       6.00       6.00      10.00       9.00      10.00      10.00       9.00       9.00      10.00      14.00      14.00      16.00      14.00      12.00      13.00      12.00      14.00      16.00      15.00      14.00      15.00      10.00      13.00      13.00      13.00      14.00      13.00      12.00      14.00      15.00      17.00      19.00      20.00      18.00      15.00      16.00      13.00      16.00      15.00      16.00      14.00      18.00      18.00      19.00      13.00      15.00      13.00      15.00      15.00      19.00      15.00      15.00      15.00      14.00      14.00      14.00      13.00      14.00      16.00      14.00      14.00       9.00      11.00       9.00      12.00      11.00      11.00      11.00      11.00      10.00       8.00       9.00       9.00       8.00       8.00       8.00       8.00       9.00      11.00      12.00      14.00      13.00      13.00      13.00      12.00      13.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwD6">
                    <dwd:value>      99.00      98.00      96.00      86.00      76.00      68.00      67.00      68.00      70.00      63.00      57.00      58.00      53.00      54.00      56.00      56.00      57.00      57.00      60.00      62.00      65.00      68.00      72.00      75.00          -          -      80.00      79.00      78.00      78.00      77.00      77.00      77.00      77.00      78.00      79.00      78.00      77.00      77.00      75.00      74.00      73.00      72.00      70.00      69.00      66.00      63.00      60.00      64.00      68.00      71.00      68.00      64.00      63.00      58.00      56.00      55.00      56.00      57.00      58.00      62.00      66.00      66.00      66.00      61.00      60.00      60.00      63.00      63.00      67.00      66.00      66.00      68.00      69.00      70.00      70.00      70.00      69.00      61.00      54.00      50.00      50.00      53.00      57.00      58.00      59.00      59.00      54.00      48.00      45.00      45.00      48.00      46.00      50.00      49.00      48.00      50.00      53.00      51.00      57.00      59.00      60.00      57.00      54.00      49.00      48.00      44.00      41.00      37.00      34.00      27.00      29.00      28.00      28.00      27.00      27.00      28.00      28.00      28.00      29.00      28.00      27.00      27.00      27.00      28.00      30.00      28.00      26.00      23.00      24.00      25.00      26.00      20.00      14.00      13.00      12.00      16.00      22.00      21.00      22.00      24.00      26.00      29.00      32.00      29.00      27.00      24.00      20.00      15.00      15.00      14.00      17.00      20.00      22.00      24.00      27.00      25.00      24.00      23.00      22.00      21.00      20.00      21.00      22.00      23.00      24.00      26.00      27.00      26.00      25.00      22.00      27.00      30.00      33.00      33.00      32.00      30.00      31.00      31.00      31.00      30.00      29.00      28.00      28.00      29.00      30.00      33.00      36.00      39.00      38.00      37.00      36.00      35.00      35.00      34.00      35.00      35.00      35.00      32.00      28.00      25.00      29.00      33.00      37.00      36.00      35.00      34.00      33.00      32.00      32.00      33.00      35.00      36.00      38.00      39.00      41.00      38.00      36.00      34.00      35.00      36.00      37.00      35.00      34.00      32.00      32.00      32.00      32.00      28.00      24.00      20.00      21.00      22.00      23.00      22.00      20.00      19.00      19.00      18.00      18.00      21.00      23.00      26.00      26.00      26.00      26.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwDh">
                    <dwd:value>          -          -     100.00          -          -          -          -          -      96.00          -          -          -          -          -      81.00          -          -          -          -          -      71.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      78.00          -          -          -          -          -      78.00          -          -          -          -          -      74.00          -          -          -          -          -      71.00          -          -          -          -          -      68.00          -          -          -          -          -      66.00          -          -          -          -          -      70.00          -          -          -          -          -      70.00          -          -          -          -          -      71.00          -          -          -          -          -      65.00          -          -          -          -          -      51.00          -          -          -          -          -      67.00          -          -          -          -          -      49.00          -          -          -          -          -      40.00          -          -          -          -          -      41.00          -          -          -          -          -      39.00          -          -          -          -          -      23.00          -          -          -          -          -      36.00          -          -          -          -          -      38.00          -          -          -          -          -      37.00          -          -          -          -          -      35.00          -          -          -          -          -      36.00          -          -          -          -          -      26.00          -          -          -          -          -      30.00          -          -          -          -          -      41.00          -          -          -          -          -      45.00          -          -          -          -          -      40.00          -          -          -          -          -      44.00          -          -          -          -          -      41.00          -          -          -          -          -      49.00          -          -          -          -          -      46.00          -          -          -          -          -      48.00          -          -          -          -          -      39.00          -          -          -          -          -      28.00          -          -          -          -          -      35.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwC">
                    <dwd:value>        4.00       7.00       8.00       3.00       7.00       7.00       9.00       9.00      10.00      16.00       9.00      12.00      10.00      15.00      18.00      21.00      18.00       8.00      10.00       9.00      15.00      16.00      16.00      18.00      18.00      15.00      12.00      10.00       8.00       6.00      12.00      14.00      17.00      23.00      26.00      20.00      27.00      26.00      17.00      12.00      13.00      16.00      15.00      16.00      19.00      20.00      20.00      17.00      13.00      13.00      12.00      17.00      19.00      18.00      19.00      32.00      30.00      29.00      28.00      16.00      31.00      24.00      12.00      16.00      14.00      14.00      15.00      12.00      13.00      14.00      14.00      18.00      19.00      19.00      17.00      14.00      22.00      19.00      17.00      18.00      17.00      26.00      22.00      20.00      18.00      15.00      24.00      17.00      11.00       9.00      12.00      12.00      16.00      16.00      13.00      12.00      25.00      13.00      18.00      19.00      23.00      25.00      24.00      29.00      39.00      45.00      42.00      37.00      38.00      28.00      34.00      33.00      25.00      22.00      25.00      22.00      23.00      27.00      16.00      19.00      22.00      21.00      29.00      27.00      27.00      32.00      34.00      34.00      39.00      41.00      41.00      36.00      29.00      31.00      32.00      29.00      20.00      22.00      19.00      16.00      17.00      16.00      13.00      13.00      17.00      17.00      12.00      11.00      14.00      18.00      18.00      22.00      30.00      34.00      32.00      30.00      30.00      27.00      25.00      19.00      18.00      15.00      14.00      13.00      14.00      18.00      17.00      18.00      15.00      15.00      17.00      16.00      21.00      19.00      19.00      21.00      23.00      28.00      24.00      21.00      20.00      22.00      19.00      22.00      20.00      18.00      19.00      22.00      20.00      19.00      14.00      13.00      14.00      13.00      15.00      17.00      16.00      19.00      12.00      19.00      15.00      17.00      11.00      13.00      14.00      19.00      17.00      16.00      14.00      12.00      13.00      12.00      15.00      20.00      20.00      19.00      18.00      17.00      17.00      16.00      14.00      14.00      15.00      17.00      17.00      15.00      20.00      19.00      18.00      19.00      19.00      21.00      19.00      19.00      20.00      18.00      18.00      20.00      18.00      16.00      15.00      21.00      20.00      20.00      20.00      20.00      21.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwC6">
                    <dwd:value>       3.00       6.00       9.00      11.00      13.00      15.00      15.00      15.00      15.00      18.00      21.00      26.00      29.00      33.00      37.00      37.00      38.00      38.00      36.00      35.00      33.00      41.00      48.00      52.00          -          -      39.00      43.00      48.00      47.00      42.00      33.00      28.00      32.00      40.00      49.00      45.00      42.00      41.00      41.00      42.00      44.00      42.00      40.00      38.00      41.00      44.00      47.00      47.00      47.00      46.00      53.00      59.00      60.00      60.00      54.00      47.00      52.00      57.00      62.00      59.00      57.00      52.00      56.00      56.00      57.00      44.00      31.00      24.00      26.00      35.00      42.00      37.00      31.00      30.00      29.00      35.00      40.00      37.00      34.00      32.00      39.00      47.00      55.00      53.00      51.00      50.00      46.00      43.00      47.00      39.00      38.00      37.00      39.00      42.00      45.00      41.00      37.00      32.00      38.00      42.00      46.00      54.00      62.00      68.00      72.00      75.00      78.00      73.00      68.00      64.00      58.00      54.00      51.00      48.00      47.00      47.00      46.00      45.00      45.00      48.00      50.00      53.00      54.00      55.00      56.00      61.00      67.00      72.00      75.00      77.00      80.00      71.00      62.00      60.00      49.00      44.00      44.00      42.00      43.00      41.00      45.00      45.00      46.00      46.00      46.00      46.00      43.00      39.00      37.00      40.00      45.00      50.00      49.00      48.00      48.00      50.00      52.00      55.00      48.00      42.00      39.00      36.00      37.00      36.00      39.00      40.00      41.00      43.00      46.00      48.00      46.00      44.00      41.00      46.00      50.00      53.00      54.00      53.00      52.00      47.00      42.00      38.00      39.00      41.00      44.00      47.00      51.00      55.00      52.00      50.00      48.00      44.00      41.00      38.00      38.00      38.00      38.00      38.00      38.00      37.00      40.00      44.00      47.00      44.00      41.00      38.00      34.00      31.00      29.00      29.00      31.00      33.00      40.00      47.00      53.00      53.00      53.00      52.00      49.00      44.00      41.00      41.00      42.00      43.00      42.00      42.00      41.00      42.00      43.00      43.00      45.00      46.00      48.00      48.00      49.00      49.00      47.00      44.00      42.00      44.00      46.00      48.00      48.00      48.00      47.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwCh">
                    <dwd:value>          -          -      11.00          -          -          -          -          -      19.00          -          -          -          -          -      37.00          -          -          -          -          -      64.00          -          -          -          -          -      53.00          -          -          -          -          -      45.00          -          -          -          -          -      62.00          -          -          -          -          -      52.00          -          -          -          -          -      55.00          -          -          -          -          -      70.00          -          -          -          -          -      67.00          -          -          -          -          -      52.00          -          -          -          -          -      53.00          -          -          -          -          -      53.00          -          -          -          -          -      66.00          -          -          -          -          -      59.00          -          -          -          -          -      49.00          -          -          -          -          -      68.00          -          -          -          -          -      84.00          -          -          -          -          -      66.00          -          -          -          -          -      53.00          -          -          -          -          -      76.00          -          -          -          -          -      83.00          -          -          -          -          -      60.00          -          -          -          -          -      57.00          -          -          -          -          -      60.00          -          -          -          -          -      65.00          -          -          -          -          -      55.00          -          -          -          -          -      52.00          -          -          -          -          -      57.00          -          -          -          -          -      53.00          -          -          -          -          -      62.00          -          -          -          -          -      57.00          -          -          -          -          -      48.00          -          -          -          -          -      49.00          -          -          -          -          -      43.00          -          -          -          -          -      52.00          -          -          -          -          -      59.00          -          -          -          -          -      54.00          -          -          -          -          -      62.00          -          -          -          -          -      63.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwT">
                    <dwd:value>        0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwT6">
                    <dwd:value>       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00          -          -       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwTh">
                    <dwd:value>          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwTd">
                    <dwd:value>          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       1.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwS">
                    <dwd:value>       25.00      51.00      48.00      51.00      44.00      42.00      36.00      36.00      49.00      53.00      44.00      45.00      34.00      35.00      43.00      50.00      48.00      38.00      47.00      45.00      52.00      58.00      55.00      52.00      57.00      58.00      55.00      57.00      52.00      53.00      62.00      67.00      69.00      70.00      69.00      67.00      66.00      66.00      58.00      57.00      47.00      53.00      62.00      58.00      55.00      55.00      49.00      50.00      54.00      49.00      52.00      56.00      53.00      49.00      50.00      63.00      63.00      66.00      68.00      62.00      70.00      64.00      53.00      55.00      50.00      52.00      54.00      50.00      56.00      60.00      58.00      58.00      63.00      70.00      63.00      56.00      61.00      55.00      54.00      59.00      64.00      69.00      64.00      65.00      63.00      48.00      52.00      56.00      43.00      41.00      44.00      40.00      42.00      44.00      50.00      44.00      45.00      43.00      44.00      46.00      47.00      50.00      50.00      54.00      50.00      56.00      52.00      50.00      51.00      43.00      47.00      45.00      42.00      40.00      42.00      35.00      35.00      40.00      32.00      35.00      38.00      37.00      39.00      38.00      41.00      42.00      46.00      49.00      50.00      53.00      47.00      47.00      41.00      37.00      36.00      36.00      32.00      31.00      29.00      27.00      27.00      25.00      22.00      20.00      23.00      21.00      23.00      23.00      20.00      21.00      24.00      30.00      34.00      35.00      34.00      40.00      35.00      35.00      30.00      27.00      23.00      14.00      17.00      20.00      20.00      24.00      23.00      25.00      20.00      20.00      26.00      24.00      32.00      29.00      27.00      29.00      30.00      35.00      32.00      28.00      29.00      32.00      24.00      25.00      21.00      21.00      21.00      24.00      21.00      25.00      22.00      24.00      26.00      22.00      21.00      21.00      26.00      25.00      23.00      29.00      26.00      25.00      24.00      28.00      25.00      29.00      28.00      18.00      20.00      18.00      21.00      19.00      22.00      23.00      24.00      23.00      23.00      22.00      24.00      25.00      23.00      23.00      17.00      21.00      18.00      19.00      21.00      20.00      19.00      21.00      22.00      21.00      20.00      19.00      19.00      21.00      21.00      18.00      19.00      19.00      20.00      27.00      26.00      27.00      27.00      27.00      27.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwS6">
                    <dwd:value>      99.00      97.00      97.00      93.00      90.00      83.00      85.00      83.00      83.00      82.00      84.00      84.00      86.00      86.00      86.00      85.00      84.00      83.00      83.00      83.00      83.00      83.00      84.00      85.00          -          -      85.00      85.00      86.00      86.00      85.00      85.00      84.00      85.00      86.00      88.00      87.00      87.00      86.00      86.00      85.00      85.00      84.00      82.00      81.00      81.00      81.00      81.00      78.00      74.00      73.00      74.00      77.00      80.00      81.00      81.00      82.00      83.00      85.00      87.00      87.00      86.00      86.00      85.00      84.00      82.00      82.00      81.00      81.00      81.00      80.00      80.00      81.00      83.00      84.00      84.00      85.00      85.00      85.00      83.00      82.00      84.00      86.00      87.00      87.00      86.00      86.00      83.00      81.00      81.00      78.00      76.00      76.00      74.00      74.00      74.00      73.00      73.00      74.00      72.00      71.00      74.00      68.00      66.00      76.00      72.00      80.00      88.00      86.00      85.00      84.00      82.00      81.00      79.00      78.00      77.00      75.00      75.00      74.00      73.00      76.00      78.00      75.00      80.00      81.00      80.00      81.00      81.00      81.00      82.00      82.00      82.00      82.00      82.00      73.00      77.00      72.00      66.00      65.00      63.00      61.00      60.00      59.00      58.00      57.00      57.00      53.00      55.00      53.00      52.00      50.00      49.00      54.00      51.00      53.00      61.00      60.00      64.00      68.00      61.00      54.00      49.00      45.00      43.00      40.00      46.00      51.00      49.00      56.00      56.00      52.00      55.00      56.00      56.00      55.00      54.00      53.00      50.00      47.00      48.00      44.00      45.00      48.00      47.00      50.00      52.00      47.00      42.00      37.00      41.00      45.00      49.00      48.00      48.00      48.00      49.00      50.00      51.00      52.00      53.00      55.00      54.00      53.00      52.00      53.00      53.00      54.00      48.00      42.00      38.00      35.00      35.00      35.00      40.00      45.00      51.00      50.00      49.00      48.00      48.00      48.00      49.00      48.00      47.00      46.00      45.00      44.00      44.00      43.00      41.00      41.00      43.00      46.00      49.00      47.00      45.00      42.00      42.00      42.00      42.00      46.00      49.00      53.00      53.00      53.00      53.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwSh">
                    <dwd:value>          -          -     100.00          -          -          -          -          -      97.00          -          -          -          -          -      94.00          -          -          -          -          -      95.00          -          -          -          -          -      94.00          -          -          -          -          -      94.00          -          -          -          -          -      94.00          -          -          -          -          -      93.00          -          -          -          -          -      93.00          -          -          -          -          -      91.00          -          -          -          -          -      95.00          -          -          -          -          -      92.00          -          -          -          -          -      92.00          -          -          -          -          -      94.00          -          -          -          -          -      94.00          -          -          -          -          -      93.00          -          -          -          -          -      85.00          -          -          -          -          -      90.00          -          -          -          -          -      91.00          -          -          -          -          -      92.00          -          -          -          -          -      87.00          -          -          -          -          -      89.00          -          -          -          -          -      90.00          -          -          -          -          -      81.00          -          -          -          -          -      80.00          -          -          -          -          -      63.00          -          -          -          -          -      75.00          -          -          -          -          -      71.00          -          -          -          -          -      71.00          -          -          -          -          -      76.00          -          -          -          -          -      61.00          -          -          -          -          -      54.00          -          -          -          -          -      71.00          -          -          -          -          -      66.00          -          -          -          -          -      73.00          -          -          -          -          -      56.00          -          -          -          -          -      58.00          -          -          -          -          -      59.00          -          -          -          -          -      55.00          -          -          -          -          -      52.00          -          -          -          -          -      71.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwL">
                    <dwd:value>        1.00       1.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       3.00       0.00       1.00       3.00      15.00      10.00      11.00      15.00      14.00      14.00      23.00      21.00      21.00      21.00      18.00      19.00      17.00      11.00       8.00       9.00       9.00      12.00      18.00      15.00      13.00       4.00       5.00      11.00       7.00       0.00       4.00       4.00       9.00       6.00       7.00       0.00       3.00       0.00       0.00       0.00       1.00       2.00       2.00       4.00       4.00       3.00       1.00       1.00       0.00       0.00       0.00       2.00       3.00       6.00       5.00       4.00       3.00       6.00       6.00       3.00       0.00       0.00       0.00       0.00       0.00       2.00       4.00       1.00       1.00       0.00       1.00       0.00       0.00       0.00       1.00       1.00       1.00       1.00       0.00       0.00       0.00       0.00       0.00       1.00       1.00       1.00       1.00       1.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00       0.00       1.00       0.00       1.00       1.00       0.00       0.00       1.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00       1.00       1.00       2.00       0.00       2.00       1.00       1.00       1.00       1.00       1.00       1.00       4.00       0.00       0.00       4.00       7.00       9.00       7.00       3.00       1.00       4.00       5.00       4.00       7.00       4.00       3.00       4.00       4.00       3.00       2.00       4.00       5.00       5.00       6.00       5.00       5.00       5.00       6.00       4.00       7.00       8.00       8.00       5.00       5.00       6.00      10.00      13.00      11.00      12.00      10.00      11.00       7.00       7.00       7.00       7.00      10.00      12.00      11.00       7.00       7.00       5.00       5.00       5.00       5.00       4.00       3.00       9.00       3.00       4.00      11.00       9.00      10.00      10.00       8.00       8.00      11.00      10.00      10.00       9.00       8.00       7.00       6.00       6.00       5.00       7.00       7.00       8.00       8.00      10.00       9.00       9.00       9.00       7.00       8.00       8.00       9.00       8.00       5.00       5.00       9.00       9.00       8.00       8.00       8.00       7.00       6.00       6.00       5.00       5.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwL6">
                    <dwd:value>       1.00       1.00       0.00       1.00       1.00       1.00       1.00       1.00       0.00       2.00       3.00       0.00       3.00       2.00       3.00       4.00       8.00      17.00      15.00      19.00      17.00      24.00      25.00      33.00          -          -      37.00      39.00      41.00      44.00      38.00      31.00      30.00      29.00      33.00      38.00      37.00      37.00      36.00      36.00      36.00      36.00      30.00      24.00      21.00      15.00      12.00      10.00       7.00       5.00       9.00       2.00       1.00       3.00       3.00       5.00       5.00       6.00       5.00       4.00       3.00       3.00       4.00       3.00       2.00       3.00       4.00       6.00       7.00       9.00      10.00      10.00       9.00       8.00       7.00       5.00       3.00       3.00       1.00       2.00       4.00       3.00       3.00       5.00       3.00       2.00       1.00       1.00       0.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       1.00       2.00       1.00       1.00       1.00       0.00       1.00       0.00       0.00       0.00       0.00       1.00       0.00       1.00       1.00       0.00       1.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       1.00       2.00       1.00       1.00       1.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00       1.00       1.00       1.00       2.00       3.00       3.00       3.00       3.00       4.00       4.00       5.00       5.00       5.00       6.00       5.00       5.00       4.00       4.00       3.00       9.00       7.00      10.00      11.00      11.00       8.00       7.00       6.00       7.00       7.00       7.00       7.00       6.00       8.00      10.00      11.00      12.00      13.00      13.00      12.00      11.00      11.00      11.00      11.00      12.00      12.00      13.00      15.00      16.00      19.00      21.00      21.00      21.00      22.00      22.00      22.00      23.00      24.00      25.00      27.00      26.00      25.00      24.00      21.00      18.00      14.00      13.00      12.00      11.00      13.00      15.00      16.00      18.00      19.00      22.00      23.00      25.00      27.00      24.00      21.00      19.00      19.00      18.00      18.00      17.00      16.00      16.00      15.00      14.00      13.00      15.00      16.00      17.00      18.00      18.00      19.00      18.00      18.00      18.00      19.00      20.00      20.00      21.00      22.00      22.00      20.00      17.00      16.00      14.00      14.00      14.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwLh">
                    <dwd:value>          -          -       2.00          -          -          -          -          -       0.00          -          -          -          -          -       3.00          -          -          -          -          -      17.00          -          -          -          -          -      23.00          -          -          -          -          -      51.00          -          -          -          -          -      46.00          -          -          -          -          -      36.00          -          -          -          -          -      21.00          -          -          -          -          -       9.00          -          -          -          -          -       5.00          -          -          -          -          -       7.00          -          -          -          -          -       7.00          -          -          -          -          -       7.00          -          -          -          -          -       4.00          -          -          -          -          -       1.00          -          -          -          -          -       3.00          -          -          -          -          -       1.00          -          -          -          -          -       1.00          -          -          -          -          -       2.00          -          -          -          -          -       3.00          -          -          -          -          -       1.00          -          -          -          -          -       1.00          -          -          -          -          -       3.00          -          -          -          -          -       7.00          -          -          -          -          -       8.00          -          -          -          -          -      11.00          -          -          -          -          -      18.00          -          -          -          -          -      11.00          -          -          -          -          -      14.00          -          -          -          -          -      16.00          -          -          -          -          -      23.00          -          -          -          -          -      33.00          -          -          -          -          -      36.00          -          -          -          -          -      22.00          -          -          -          -          -      30.00          -          -          -          -          -      30.00          -          -          -          -          -      25.00          -          -          -          -          -      20.00          -          -          -          -          -      23.00          -          -          -          -          -      20.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwF">
                    <dwd:value>        1.00       1.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       3.00       0.00       1.00       2.00      12.00      10.00       9.00      14.00      12.00      11.00      19.00      10.00      14.00      17.00      15.00      17.00      15.00      10.00       7.00       7.00       7.00       9.00      16.00      12.00      11.00       3.00       3.00       7.00       4.00       0.00       4.00       4.00       8.00       6.00       7.00       0.00       3.00       0.00       0.00       0.00       1.00       2.00       1.00       4.00       4.00       3.00       1.00       0.00       0.00       0.00       0.00       2.00       3.00       5.00       5.00       4.00       2.00       6.00       6.00       3.00       0.00       0.00       0.00       0.00       0.00       2.00       4.00       1.00       1.00       0.00       1.00       0.00       0.00       0.00       1.00       1.00       1.00       1.00       0.00       0.00       0.00       0.00       0.00       1.00       1.00       1.00       1.00       1.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00       0.00       1.00       0.00       1.00       1.00       0.00       0.00       1.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00       1.00       1.00       2.00       0.00       2.00       1.00       1.00       1.00       1.00       1.00       1.00       4.00       0.00       0.00       4.00       7.00       9.00       7.00       3.00       1.00       3.00       4.00       4.00       6.00       3.00       3.00       3.00       3.00       3.00       2.00       3.00       4.00       3.00       4.00       4.00       4.00       4.00       4.00       3.00       6.00       6.00       6.00       4.00       3.00       4.00       8.00       9.00       8.00       8.00       7.00       7.00       6.00       5.00       5.00       5.00       8.00       8.00       8.00       5.00       5.00       3.00       4.00       4.00       3.00       3.00       2.00       6.00       2.00       3.00       6.00       6.00       6.00       6.00       4.00       5.00       6.00       6.00       5.00       5.00       5.00       4.00       4.00       3.00       3.00       5.00       4.00       5.00       6.00       6.00       6.00       6.00       5.00       4.00       5.00       5.00       6.00       5.00       3.00       3.00       6.00       6.00       6.00       6.00       5.00       5.00       4.00       4.00       4.00       4.00</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwF6">
                    <dwd:value>       1.00       1.00       0.00       1.00       1.00       1.00       1.00       1.00       0.00       1.00       1.00       0.00       1.00       2.00       0.00       4.00       7.00      10.00      14.00      17.00      15.00      21.00      22.00      23.00          -          -      30.00      32.00      34.00      34.00      29.00      25.00      21.00      24.00      28.00      32.00      32.00      31.00      23.00      31.00      31.00      31.00      26.00      21.00       7.00      14.00      11.00       9.00       6.00       4.00       0.00       1.00       1.00       1.00       3.00       5.00       1.00       6.00       5.00       3.00       3.00       3.00       0.00       3.00       2.00       2.00       4.00       6.00       6.00       9.00      10.00      10.00       9.00       8.00       3.00       5.00       3.00       1.00       1.00       2.00       0.00       3.00       3.00       4.00       3.00       2.00       0.00       1.00       0.00       0.00       1.00       1.00       1.00       1.00       1.00       0.00       1.00       1.00       1.00       2.00       1.00       1.00       1.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00       0.00       1.00       1.00       0.00       1.00       2.00       2.00       2.00       2.00       1.00       2.00       2.00       1.00       2.00       1.00       1.00       1.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       1.00       1.00       0.00       1.00       2.00       2.00       3.00       3.00       3.00       4.00       4.00       5.00       5.00       5.00       6.00       5.00       5.00       2.00       4.00       3.00       3.00       6.00      10.00      11.00      11.00       8.00       5.00       5.00       6.00       7.00       7.00       7.00       6.00       8.00       9.00      10.00      11.00      11.00      12.00      10.00      10.00       9.00       9.00       9.00       9.00      10.00      11.00      12.00      13.00      15.00      16.00      17.00      17.00      17.00      17.00      17.00      17.00      18.00      18.00      19.00      18.00      18.00      17.00      15.00      13.00      10.00       9.00       9.00       8.00       9.00      10.00      10.00      12.00      13.00      14.00      15.00      17.00      17.00      16.00      14.00      12.00      13.00      12.00      12.00      12.00      11.00      11.00      10.00      10.00       9.00      10.00      11.00      12.00      12.00      12.00      13.00      13.00      13.00      13.00      13.00      14.00      14.00      15.00      15.00      16.00      14.00      12.00       9.00      10.00      10.00      10.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="wwFh">
                    <dwd:value>          -          -       1.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -      15.00          -          -          -          -          -      19.00          -          -          -          -          -      35.00          -          -          -          -          -      36.00          -          -          -          -          -      23.00          -          -          -          -          -       7.00          -          -          -          -          -       1.00          -          -          -          -          -       2.00          -          -          -          -          -       6.00          -          -          -          -          -       7.00          -          -          -          -          -       2.00          -          -          -          -          -       0.00          -          -          -          -          -       1.00          -          -          -          -          -       2.00          -          -          -          -          -       1.00          -          -          -          -          -       0.00          -          -          -          -          -       2.00          -          -          -          -          -       3.00          -          -          -          -          -       1.00          -          -          -          -          -       0.00          -          -          -          -          -       3.00          -          -          -          -          -       7.00          -          -          -          -          -       7.00          -          -          -          -          -      11.00          -          -          -          -          -      16.00          -          -          -          -          -      10.00          -          -          -          -          -      11.00          -          -          -          -          -      13.00          -          -          -          -          -      18.00          -          -          -          -          -      24.00          -          -          -          -          -      24.00          -          -          -          -          -      16.00          -          -          -          -          -      17.00          -          -          -          -          -      20.00          -          -          -          -          -      14.00          -          -          -          -          -      14.00          -          -          -          -          -      16.00          -          -          -          -          -      14.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="DRR1">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RR6c">
                    <dwd:value>          -          -       1.50          -          -          -          -          -       0.10          -          -          -          -          -       0.00          -          -          -          -          -       0.90          -          -          -          -          -       3.80          -          -          -          -          -       1.20          -          -          -          -          -       0.80          -          -          -          -          -       0.70          -          -          -          -          -       0.30          -          -          -          -          -       0.50          -          -          -          -          -       0.70          -          -          -          -          -       1.50          -          -          -          -          -       0.30          -          -          -          -          -       0.90          -          -          -          -          -       0.70          -          -          -          -          -       0.70          -          -          -          -          -       0.20          -          -          -          -          -       0.30          -          -          -          -          -       0.30          -          -          -          -          -       0.50          -          -          -          -          -       0.20          -          -          -          -          -       0.30          -          -          -          -          -       0.30          -          -          -          -          -       0.00          -          -          -          -          -       0.60          -          -          -          -          -       0.30          -          -          -          -          -       0.30          -          -          -          -          -       0.00          -          -          -          -          -       0.90          -          -          -          -          -       0.60          -          -          -          -          -       0.60          -          -          -          -          -       0.00          -          -          -          -          -       0.80          -          -          -          -          -       0.40          -          -          -          -          -       0.60          -          -          -          -          -       0.00          -          -          -          -          -       0.80          -          -          -          -          -       0.50          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       0.90          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RRhc">
                    <dwd:value>          -          -       2.90          -          -          -          -          -          -          -          -          -          -          -       0.10          -          -          -          -          -          -          -          -          -          -          -       4.70          -          -          -          -          -          -          -          -          -          -          -       2.10          -          -          -          -          -          -          -          -          -          -          -       1.00          -          -          -          -          -          -          -          -          -          -          -       1.20          -          -          -          -          -          -          -          -          -          -          -       1.80          -          -          -          -          -          -          -          -          -          -          -       1.60          -          -          -          -          -          -          -          -          -          -          -       0.90          -          -          -          -          -          -          -          -          -          -          -       0.60          -          -          -          -          -          -          -          -          -          -          -       0.70          -          -          -          -          -          -          -          -          -          -          -       0.60          -          -          -          -          -          -          -          -          -          -          -       0.60          -          -          -          -          -          -          -          -          -          -          -       0.60          -          -          -          -          -          -          -          -          -          -          -       0.90          -          -          -          -          -          -          -          -          -          -          -       1.30          -          -          -          -          -          -          -          -          -          -          -       0.80          -          -          -          -          -          -          -          -          -          -          -       1.00          -          -          -          -          -          -          -          -          -          -          -       0.80          -          -          -          -          -          -          -          -          -          -          -       0.50          -          -          -          -          -          -          -          -          -          -          -       0.90          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RRdc">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -       2.80          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       4.90          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       2.30          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       3.40          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       1.40          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       1.30          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       1.20          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       2.20          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       1.80          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       1.30          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RR1c">
                    <dwd:value>       0.20       0.20       0.20       0.00       0.00       0.10       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.30       0.10       0.10       0.20       0.60       0.60       0.70       0.60       0.60       0.60       0.20       0.20       0.20       0.20       0.20       0.20       0.20       0.20       0.20       0.10       0.10       0.10       0.20       0.20       0.20       0.10       0.10       0.10       0.00       0.00       0.00       0.10       0.10       0.10       0.10       0.10       0.10       0.10       0.10       0.10       0.10       0.10       0.10       0.20       0.10       0.10       0.20       0.20       0.20       0.30       0.30       0.30       0.00       0.00       0.00       0.00       0.00       0.00       0.20       0.20       0.20       0.10       0.20       0.20       0.10       0.10       0.10       0.10       0.10       0.10       0.20       0.10       0.10       0.10       0.10       0.10       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.10       0.10       0.10       0.10       0.10       0.00       0.30       0.00       0.00       0.20       0.00       0.00       0.00       0.00       0.00       0.00       0.10       0.10       0.00       0.00       0.00       0.10       0.10       0.10       0.10       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.60       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RRS1c">
                    <dwd:value>      0.20       0.20       0.20       0.00       0.00       0.10       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.20       0.10       0.10       0.20       0.50       0.50       0.50       0.50       0.50       0.50       0.20       0.20       0.20       0.20       0.20       0.20       0.10       0.10       0.10       0.10       0.10       0.10       0.20       0.10       0.20       0.10       0.10       0.10       0.00       0.00       0.00       0.10       0.10       0.10       0.10       0.10       0.10       0.10       0.10       0.10       0.10       0.10       0.10       0.20       0.10       0.10       0.20       0.20       0.20       0.30       0.30       0.30       0.00       0.00       0.00       0.00       0.00       0.00       0.20       0.20       0.20       0.10       0.20       0.20       0.10       0.10       0.10       0.10       0.10       0.10       0.20       0.10       0.10       0.10       0.10       0.10       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.10       0.10       0.10       0.10       0.10       0.00       0.30       0.00       0.00       0.20       0.00       0.00       0.00       0.00       0.00       0.00       0.10       0.10       0.00       0.00       0.00       0.10       0.10       0.10       0.10       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.50       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RRL1c">
                    <dwd:value>      0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.10       0.00       0.00       0.00       0.10       0.10       0.20       0.20       0.20       0.20       0.10       0.10       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.10       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00       0.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RR3c">
                    <dwd:value>          -          -       0.60          -          -       0.10          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.40          -          -       0.40          -          -       1.80          -          -       1.90          -          -       0.60          -          -       0.60          -          -       0.50          -          -       0.40          -          -       0.50          -          -       0.20          -          -       0.10          -          -       0.20          -          -       0.30          -          -       0.20          -          -       0.30          -          -       0.40          -          -       0.70          -          -       0.80          -          -       0.10          -          -       0.10          -          -       0.50          -          -       0.40          -          -       0.40          -          -       0.30          -          -       0.40          -          -       0.30          -          -       0.10          -          -       0.10          -          -       0.10          -          -       0.10          -          -       0.10          -          -       0.20          -          -       0.20          -          -       0.30          -          -       0.20          -          -       0.00          -          -       0.20          -          -       0.10          -          -       0.20          -          -       0.10          -          -       0.00          -          -       0.00          -          -       0.30          -          -       0.30          -          -       0.20          -          -       0.10          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.90          -          -       0.60          -          -       0.00          -          -       0.60          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RRS3c">
                    <dwd:value>         -          -       0.60          -          -       0.10          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.30          -          -       0.30          -          -       1.20          -          -       1.40          -          -       0.50          -          -       0.50          -          -       0.40          -          -       0.30          -          -       0.50          -          -       0.20          -          -       0.10          -          -       0.20          -          -       0.30          -          -       0.20          -          -       0.30          -          -       0.40          -          -       0.70          -          -       0.80          -          -       0.10          -          -       0.10          -          -       0.50          -          -       0.40          -          -       0.40          -          -       0.30          -          -       0.40          -          -       0.30          -          -       0.10          -          -       0.10          -          -       0.10          -          -       0.10          -          -       0.10          -          -       0.20          -          -       0.20          -          -       0.30          -          -       0.20          -          -       0.00          -          -       0.20          -          -       0.10          -          -       0.20          -          -       0.10          -          -       0.00          -          -       0.00          -          -       0.30          -          -       0.30          -          -       0.20          -          -       0.10          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.70          -          -       0.60          -          -       0.00          -          -       0.50          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -       0.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R101">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R102">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R103">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R105">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R107">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R110">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R120">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R130">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R150">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RR1o1">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RR1w1">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RR1u1">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R600">
                    <dwd:value>          -          -      61.00          -          -          -          -          -      70.00          -          -          -          -          -      23.00          -          -          -          -          -      85.00          -          -          -          -          -      81.00          -          -          -          -          -      89.00          -          -          -          -          -      60.00          -          -          -          -          -      80.00          -          -          -          -          -      57.00          -          -          -          -          -      82.00          -          -          -          -          -      59.00          -          -          -          -          -      86.00          -          -          -          -          -      60.00          -          -          -          -          -      86.00          -          -          -          -          -      61.00          -          -          -          -          -      83.00          -          -          -          -          -      45.00          -          -          -          -          -      87.00          -          -          -          -          -      44.00          -          -          -          -          -      78.00          -          -          -          -          -      43.00          -          -          -          -          -      83.00          -          -          -          -          -      48.00          -          -          -          -          -      81.00          -          -          -          -          -      33.00          -          -          -          -          -      68.00          -          -          -          -          -      46.00          -          -          -          -          -      67.00          -          -          -          -          -      52.00          -          -          -          -          -      70.00          -          -          -          -          -      49.00          -          -          -          -          -      59.00          -          -          -          -          -      50.00          -          -          -          -          -      63.00          -          -          -          -          -      48.00          -          -          -          -          -      64.00          -          -          -          -          -      47.00          -          -          -          -          -      61.00          -          -          -          -          -      48.00          -          -          -          -          -      65.00          -          -          -          -          -      49.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R602">
                    <dwd:value>          -          -      41.00          -          -          -          -          -      25.00          -          -          -          -          -      11.00          -          -          -          -          -      57.00          -          -          -          -          -      74.00          -          -          -          -          -      64.00          -          -          -          -          -      50.00          -          -          -          -          -      52.00          -          -          -          -          -      38.00          -          -          -          -          -      51.00          -          -          -          -          -      45.00          -          -          -          -          -      56.00          -          -          -          -          -      34.00          -          -          -          -          -      57.00          -          -          -          -          -      54.00          -          -          -          -          -      45.00          -          -          -          -          -      31.00          -          -          -          -          -      36.00          -          -          -          -          -      23.00          -          -          -          -          -      43.00          -          -          -          -          -      32.00          -          -          -          -          -      39.00          -          -          -          -          -      26.00          -          -          -          -          -      36.00          -          -          -          -          -      30.00          -          -          -          -          -      21.00          -          -          -          -          -      33.00          -          -          -          -          -      37.00          -          -          -          -          -      38.00          -          -          -          -          -      42.00          -          -          -          -          -      37.00          -          -          -          -          -      27.00          -          -          -          -          -      29.00          -          -          -          -          -      32.00          -          -          -          -          -      37.00          -          -          -          -          -      25.00          -          -          -          -          -      38.00          -          -          -          -          -      27.00          -          -          -          -          -      29.00          -          -          -          -          -      25.00          -          -          -          -          -      34.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R610">
                    <dwd:value>          -          -      15.00          -          -          -          -          -       1.00          -          -          -          -          -       2.00          -          -          -          -          -      35.00          -          -          -          -          -      40.00          -          -          -          -          -      37.00          -          -          -          -          -      31.00          -          -          -          -          -      32.00          -          -          -          -          -      15.00          -          -          -          -          -      21.00          -          -          -          -          -      19.00          -          -          -          -          -      35.00          -          -          -          -          -      17.00          -          -          -          -          -      31.00          -          -          -          -          -      13.00          -          -          -          -          -      16.00          -          -          -          -          -       9.00          -          -          -          -          -      10.00          -          -          -          -          -       6.00          -          -          -          -          -      12.00          -          -          -          -          -      10.00          -          -          -          -          -       9.00          -          -          -          -          -      11.00          -          -          -          -          -      15.00          -          -          -          -          -      10.00          -          -          -          -          -       9.00          -          -          -          -          -      17.00          -          -          -          -          -      16.00          -          -          -          -          -      15.00          -          -          -          -          -      16.00          -          -          -          -          -      20.00          -          -          -          -          -       9.00          -          -          -          -          -      13.00          -          -          -          -          -      12.00          -          -          -          -          -      18.00          -          -          -          -          -      10.00          -          -          -          -          -      17.00          -          -          -          -          -       8.00          -          -          -          -          -      12.00          -          -          -          -          -      12.00          -          -          -          -          -      16.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="R650">
                    <dwd:value>          -          -       1.00          -          -          -          -          -       0.00          -          -          -          -          -       0.00          -          -          -          -          -       1.00          -          -          -          -          -       5.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       3.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       3.00          -          -          -          -          -       5.00          -          -          -          -          -       1.00          -          -          -          -          -       2.00          -          -          -          -          -       1.00          -          -          -          -          -       0.00          -          -          -          -          -       1.00          -          -          -          -          -       1.00          -          -          -          -          -       0.00          -          -          -          -          -       1.00          -          -          -          -          -       1.00          -          -          -          -          -       0.00          -          -          -          -          -       1.00          -          -          -          -          -       0.00          -          -          -          -          -       1.00          -          -          -          -          -       0.00          -          -          -          -          -       1.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       1.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       1.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -          -       2.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Rh00">
                    <dwd:value>          -          -     100.00          -          -          -          -          -          -          -          -          -          -          -      70.00          -          -          -          -          -          -          -          -          -          -          -      94.00          -          -          -          -          -          -          -          -          -          -          -      95.00          -          -          -          -          -          -          -          -          -          -          -      80.00          -          -          -          -          -          -          -          -          -          -          -      91.00          -          -          -          -          -          -          -          -          -          -          -      92.00          -          -          -          -          -          -          -          -          -          -          -      91.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      87.00          -          -          -          -          -          -          -          -          -          -          -      84.00          -          -          -          -          -          -          -          -          -          -          -      89.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      83.00          -          -          -          -          -          -          -          -          -          -          -      83.00          -          -          -          -          -          -          -          -          -          -          -      82.00          -          -          -          -          -          -          -          -          -          -          -      79.00          -          -          -          -          -          -          -          -          -          -          -      76.00          -          -          -          -          -          -          -          -          -          -          -      68.00          -          -          -          -          -          -          -          -          -          -          -      68.00          -          -          -          -          -          -          -          -          -          -          -      71.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Rh02">
                    <dwd:value>          -          -     100.00          -          -          -          -          -          -          -          -          -          -          -      32.00          -          -          -          -          -          -          -          -          -          -          -      86.00          -          -          -          -          -          -          -          -          -          -          -      80.00          -          -          -          -          -          -          -          -          -          -          -      53.00          -          -          -          -          -          -          -          -          -          -          -      71.00          -          -          -          -          -          -          -          -          -          -          -      61.00          -          -          -          -          -          -          -          -          -          -          -      69.00          -          -          -          -          -          -          -          -          -          -          -      52.00          -          -          -          -          -          -          -          -          -          -          -      52.00          -          -          -          -          -          -          -          -          -          -          -      51.00          -          -          -          -          -          -          -          -          -          -          -      52.00          -          -          -          -          -          -          -          -          -          -          -      47.00          -          -          -          -          -          -          -          -          -          -          -      40.00          -          -          -          -          -          -          -          -          -          -          -      50.00          -          -          -          -          -          -          -          -          -          -          -      58.00          -          -          -          -          -          -          -          -          -          -          -      49.00          -          -          -          -          -          -          -          -          -          -          -      56.00          -          -          -          -          -          -          -          -          -          -          -      51.00          -          -          -          -          -          -          -          -          -          -          -      42.00          -          -          -          -          -          -          -          -          -          -          -      48.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Rh10">
                    <dwd:value>          -          -     100.00          -          -          -          -          -          -          -          -          -          -          -       4.00          -          -          -          -          -          -          -          -          -          -          -      74.00          -          -          -          -          -          -          -          -          -          -          -      57.00          -          -          -          -          -          -          -          -          -          -          -      35.00          -          -          -          -          -          -          -          -          -          -          -      37.00          -          -          -          -          -          -          -          -          -          -          -      49.00          -          -          -          -          -          -          -          -          -          -          -      37.00          -          -          -          -          -          -          -          -          -          -          -      23.00          -          -          -          -          -          -          -          -          -          -          -      14.00          -          -          -          -          -          -          -          -          -          -          -      24.00          -          -          -          -          -          -          -          -          -          -          -      24.00          -          -          -          -          -          -          -          -          -          -          -      15.00          -          -          -          -          -          -          -          -          -          -          -      23.00          -          -          -          -          -          -          -          -          -          -          -      19.00          -          -          -          -          -          -          -          -          -          -          -      31.00          -          -          -          -          -          -          -          -          -          -          -      30.00          -          -          -          -          -          -          -          -          -          -          -      22.00          -          -          -          -          -          -          -          -          -          -          -      21.00          -          -          -          -          -          -          -          -          -          -          -      18.00          -          -          -          -          -          -          -          -          -          -          -      25.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Rh50">
                    <dwd:value>          -          -       4.00          -          -          -          -          -          -          -          -          -          -          -       0.00          -          -          -          -          -          -          -          -          -          -          -      16.00          -          -          -          -          -          -          -          -          -          -          -       3.00          -          -          -          -          -          -          -          -          -          -          -       4.00          -          -          -          -          -          -          -          -          -          -          -       5.00          -          -          -          -          -          -          -          -          -          -          -      12.00          -          -          -          -          -          -          -          -          -          -          -       7.00          -          -          -          -          -          -          -          -          -          -          -       3.00          -          -          -          -          -          -          -          -          -          -          -       1.00          -          -          -          -          -          -          -          -          -          -          -       3.00          -          -          -          -          -          -          -          -          -          -          -       1.00          -          -          -          -          -          -          -          -          -          -          -       2.00          -          -          -          -          -          -          -          -          -          -          -       2.00          -          -          -          -          -          -          -          -          -          -          -       2.00          -          -          -          -          -          -          -          -          -          -          -       5.00          -          -          -          -          -          -          -          -          -          -          -       6.00          -          -          -          -          -          -          -          -          -          -          -       4.00          -          -          -          -          -          -          -          -          -          -          -       3.00          -          -          -          -          -          -          -          -          -          -          -       4.00          -          -          -          -          -          -          -          -          -          -          -       5.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Rd00">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -     100.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      99.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      98.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      93.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      92.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      97.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      92.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      87.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      89.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      86.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Rd02">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -     100.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      93.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      86.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      88.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      74.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      74.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      60.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      76.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      73.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      61.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Rd10">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -     100.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      84.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      64.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      74.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      42.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      37.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      27.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      48.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      45.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      32.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Rd50">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -      11.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      31.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      13.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      27.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       4.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       6.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       7.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       9.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      12.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       6.00          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="SunD">
                    <dwd:value>          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RSunD">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="PSd00">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="PSd30">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="PSd60">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="RRad1">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="Rad1h">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="SunD1">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="SunD3">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="PEvap">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       0.20          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       0.50          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       0.50          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       0.40          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       0.30          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -       0.30          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="WPc11">
                    <dwd:value>      3.00      71.00      71.00      71.00      71.00      71.00       3.00       3.00      71.00      71.00      71.00      71.00       3.00       3.00      71.00      85.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      85.00      85.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      85.00      71.00      85.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      85.00      71.00      71.00      71.00      85.00      71.00      71.00      71.00      71.00      71.00      71.00      85.00      71.00      71.00      71.00      71.00      85.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      85.00      71.00      85.00      71.00      71.00      71.00      71.00      71.00      71.00      71.00      85.00      71.00      71.00      71.00      71.00      85.00      71.00      71.00      71.00      71.00      71.00      85.00      71.00      71.00      71.00      85.00      71.00      71.00      71.00      71.00      71.00      71.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00       3.00      85.00       2.00       2.00      85.00       2.00       2.00       2.00       2.00      71.00       2.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00      85.00       3.00       3.00       2.00       2.00       2.00      71.00       2.00       2.00      85.00      45.00       2.00      85.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00      85.00      85.00      85.00      85.00      71.00       3.00       3.00       3.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00      71.00       2.00       2.00      85.00       2.00      71.00       2.00       2.00       2.00      85.00      85.00       2.00       2.00       2.00      71.00       3.00       2.00       2.00      45.00       2.00      85.00       2.00       2.00       2.00       2.00      71.00       2.00       2.00       2.00       2.00       2.00       2.00      71.00       2.00      85.00       2.00      71.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00      85.00       2.00      85.00       2.00      71.00       2.00       2.00       2.00       2.00      71.00       2.00       2.00       2.00       2.00       2.00       2.00      85.00      85.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00       2.00      85.00       2.00       2.00       2.00       2.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="WPc31">
                    <dwd:value>         -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      71.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -       2.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -       2.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -       2.00          -          -       2.00          -          -      71.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      45.00          -          -      85.00          -          -       2.00          -          -      71.00          -          -       2.00          -          -      71.00          -          -      85.00          -          -       2.00          -          -       2.00          -          -       2.00          -          -      85.00          -          -      85.00          -          -       2.00          -          -      71.00          -          -       2.00          -          -      85.00          -          -      85.00          -          -       2.00          -          -       2.00          -          -      85.00          -          -       2.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="WPc61">
                    <dwd:value>         -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -       2.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      71.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -       2.00          -          -       2.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -      71.00          -          -      71.00          -          -      85.00          -          -      85.00          -          -      85.00          -          -       2.00          -          -      85.00          -          -      85.00          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="WPch1">
                    <dwd:value>         -          -          -          -          -          -          -          -      71.00          -          -          -          -          -      71.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      71.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -          -      85.00          -          -          -          -</dwd:value>
                </dwd:Forecast>
                <dwd:Forecast dwd:elementName="WPcd1">
                    <dwd:value>         -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -          -      85.00          -          -          -          -          -          -          -          -          -          -</dwd:value>
                </dwd:Forecast>
            </kml:ExtendedData>
            <kml:Point>
                <kml:coordinates>19.02,74.52,16.0</kml:coordinates>
            </kml:Point>
        </kml:Placemark>
    </kml:Document>
</kml:kml>
XML

$r->parse_fh($xml);
is $r->expiry, '2019-06-23T08:00:00Z', "We parse the expiry from the XML";

seek $xml, 0,0;

$r->parse_fh($xml, 'foo');
is $r->expiry, '2019-06-23T08:00:00Z', "We parse the expiry from the XML even if it's given elsewhere";

$w = Weather::MOSMIX->new(
    dbh => $dbh,
);

my $f = $w->forecast(
    latitude => 19,
    longitude => 74,
);

isn't $f, undef;

done_testing;
