/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;
import ucar.nc2.util.URLnaming;
import ucar.unidata.util.StringUtil;

public class NCdumpW {
    private static String usage = "usage: NCdumpW <filename> [-cdl | -ncml] [-c | -vall] [-v varName1;varName2;..] [-v varName(0:1,:,12)]\n";
    private static int totalWidth = 80;
    private static char[] org = new char[]{'\b', '\f', '\n', '\r', '\t', '\\', '\'', '\"'};
    private static String[] replace = new String[]{"\\b", "\\f", "\\n", "\\r", "\\t", "\\\\", "\\'", "\\\""};

    public static boolean printHeader(String fileName, Writer out) throws IOException {
        return NCdumpW.print(fileName, out, false, false, false, false, null, null);
    }

    public static boolean printNcML(String fileName, Writer out) throws IOException {
        return NCdumpW.print(fileName, out, false, true, true, false, null, null);
    }

    public static boolean print(String command, Writer out) throws IOException {
        return NCdumpW.print(command, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean print(String command, Writer out, CancelTask ct) throws IOException {
        boolean bl;
        block6: {
            StringTokenizer stoke = new StringTokenizer(command);
            if (!stoke.hasMoreTokens()) {
                out.write(usage);
                return false;
            }
            String filename = stoke.nextToken();
            NetcdfFile nc = null;
            try {
                nc = NetcdfFile.open(filename, ct);
                int pos = command.indexOf(filename);
                command = command.substring(pos + filename.length());
                bl = NCdumpW.print(nc, command, out, ct);
                Object var9_10 = null;
                if (nc == null) break block6;
            }
            catch (FileNotFoundException e) {
                boolean bl2;
                block7: {
                    try {
                        out.write("file not found= ");
                        out.write(filename);
                        bl2 = false;
                        Object var9_11 = null;
                        if (nc == null) break block7;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        if (nc != null) {
                            nc.close();
                        }
                        out.flush();
                        throw throwable;
                    }
                    nc.close();
                }
                out.flush();
                return bl2;
            }
            nc.close();
        }
        out.flush();
        return bl;
    }

    public static boolean print(NetcdfFile nc, String command, Writer out, CancelTask ct) throws IOException {
        WantValues showValues = WantValues.none;
        boolean ncml = false;
        boolean strict = false;
        String varNames = null;
        if (command != null) {
            StringTokenizer stoke = new StringTokenizer(command);
            while (stoke.hasMoreTokens()) {
                String toke = stoke.nextToken();
                if (toke.equalsIgnoreCase("-help")) {
                    out.write(usage);
                    out.write(10);
                    return true;
                }
                if (toke.equalsIgnoreCase("-vall")) {
                    showValues = WantValues.all;
                }
                if (toke.equalsIgnoreCase("-c") && showValues == WantValues.none) {
                    showValues = WantValues.coordsOnly;
                }
                if (toke.equalsIgnoreCase("-ncml")) {
                    ncml = true;
                }
                if (toke.equalsIgnoreCase("-cdl")) {
                    strict = true;
                }
                if (!toke.equalsIgnoreCase("-v") || !stoke.hasMoreTokens()) continue;
                varNames = stoke.nextToken();
            }
        }
        return NCdumpW.print(nc, out, showValues, ncml, strict, varNames, ct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean print(String filename, Writer out, boolean showAll, boolean showCoords, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        boolean bl;
        block4: {
            NetcdfFile nc = null;
            try {
                nc = NetcdfFile.open(filename, ct);
                bl = NCdumpW.print(nc, out, showAll, showCoords, ncml, strict, varNames, ct);
                Object var12_11 = null;
                if (nc == null) break block4;
            }
            catch (FileNotFoundException e) {
                boolean bl2;
                block5: {
                    try {
                        out.write("file not found= ");
                        out.write(filename);
                        out.flush();
                        bl2 = false;
                        Object var12_12 = null;
                        if (nc == null) break block5;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var12_13 = null;
                            if (nc == null) break block6;
                            nc.close();
                        }
                        throw throwable;
                    }
                    nc.close();
                }
                return bl2;
            }
            nc.close();
        }
        return bl;
    }

    public static boolean print(NetcdfFile nc, Writer out, boolean showAll, boolean showCoords, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        WantValues showValues = WantValues.none;
        if (showAll) {
            showValues = WantValues.all;
        } else if (showCoords) {
            showValues = WantValues.coordsOnly;
        }
        return NCdumpW.print(nc, out, showValues, ncml, strict, varNames, ct);
    }

    public static boolean print(NetcdfFile nc, Writer out, WantValues showValues, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        block16: {
            boolean headerOnly = showValues == WantValues.none && varNames == null;
            try {
                if (ncml) {
                    NCdumpW.writeNcML(nc, out, showValues, null);
                    break block16;
                }
                if (headerOnly) {
                    nc.writeCDL(new PrintWriter(out), strict);
                    break block16;
                }
                PrintWriter ps = new PrintWriter(out);
                nc.toStringStart(ps, strict);
                ps.print(" data:\n");
                if (showValues == WantValues.all) {
                    for (Variable v : nc.getVariables()) {
                        NCdumpW.printArray(v.read(), v.getName(), ps, ct);
                        if (ct == null || !ct.isCancel()) continue;
                        return false;
                    }
                } else if (showValues == WantValues.coordsOnly) {
                    for (Variable v : nc.getVariables()) {
                        if (v.isCoordinateVariable()) {
                            NCdumpW.printArray(v.read(), v.getName(), ps, ct);
                        }
                        if (ct == null || !ct.isCancel()) continue;
                        return false;
                    }
                }
                if (showValues != WantValues.all && varNames != null) {
                    StringTokenizer stoke = new StringTokenizer(varNames, ";");
                    while (stoke.hasMoreTokens()) {
                        String varSubset = stoke.nextToken();
                        if (varSubset.indexOf(40) >= 0) {
                            Array data = nc.readSection(varSubset);
                            NCdumpW.printArray(data, varSubset, ps, ct);
                        } else {
                            Variable v = nc.findVariable(varSubset);
                            if (v == null) {
                                ps.print(" cant find variable: " + varSubset + "\n   " + usage);
                                continue;
                            }
                            if (showValues != WantValues.coordsOnly || v.isCoordinateVariable()) {
                                NCdumpW.printArray(v.read(), v.getName(), ps, ct);
                            }
                        }
                        if (ct == null || !ct.isCancel()) continue;
                        return false;
                    }
                }
                nc.toStringEnd(ps);
            }
            catch (Exception e) {
                e.printStackTrace();
                out.write(e.getMessage());
                out.flush();
                return false;
            }
        }
        out.flush();
        return true;
    }

    public static String printVariableData(VariableIF v, CancelTask ct) throws IOException {
        Array data = v.read();
        StringWriter writer = new StringWriter(10000);
        NCdumpW.printArray(data, v.getName(), new PrintWriter(writer), ct);
        return writer.toString();
    }

    public static String printVariableDataSection(Variable v, String sectionSpec, CancelTask ct) throws IOException, InvalidRangeException {
        Array data = v.read(sectionSpec);
        StringWriter writer = new StringWriter(20000);
        NCdumpW.printArray(data, v.getName(), new PrintWriter(writer), ct);
        return writer.toString();
    }

    public static void printArray(Array array, String name, PrintWriter out, CancelTask ct) throws IOException {
        NCdumpW.printArray(array, name, null, out, new Indent(2), ct);
        out.flush();
    }

    public static String printArray(Array array, String name, CancelTask ct) throws IOException {
        CharArrayWriter carray = new CharArrayWriter(100000);
        PrintWriter pw = new PrintWriter(carray);
        NCdumpW.printArray(array, name, null, pw, new Indent(2), ct);
        return carray.toString();
    }

    private static void printArray(Array array, String name, String units, PrintWriter out, Indent ilev, CancelTask ct) throws IOException {
        if (ct != null && ct.isCancel()) {
            return;
        }
        if (name != null) {
            out.print(ilev + name + " =");
        }
        ilev.incr();
        if (array == null) {
            throw new IllegalArgumentException("null array for " + name);
        }
        if (array instanceof ArrayChar && array.getRank() > 0) {
            NCdumpW.printStringArray(out, (ArrayChar)array, ilev, ct);
        } else if (array.getElementType() == String.class) {
            NCdumpW.printStringArray(out, (ArrayObject)array, ilev, ct);
        } else if (array instanceof ArrayStructure) {
            if (array.getSize() == 1L) {
                NCdumpW.printStructureData(out, (StructureData)array.getObject(array.getIndex()), ilev, ct);
            } else {
                NCdumpW.printStructureDataArray(out, (ArrayStructure)array, ilev, ct);
            }
        } else if (array instanceof ArraySequence) {
            NCdumpW.printSequence(out, (ArraySequence)array, ilev, ct);
        } else if (array.getElementType() == ByteBuffer.class) {
            array.resetLocalIterator();
            while (array.hasNext()) {
                NCdumpW.printByteBuffer(out, (ByteBuffer)array.next(), ilev);
                out.println(",");
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
        } else {
            NCdumpW.printArray(array, out, ilev, ct);
        }
        if (units != null) {
            out.print(" " + units);
        }
        out.print("\n");
        ilev.decr();
        out.flush();
    }

    private static void printArray(Array ma, PrintWriter out, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            out.print(ma.getObject(ima).toString());
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        if (rank == 1 && ma.getElementType() != StructureData.class) {
            for (int ii = 0; ii < last; ++ii) {
                out.print(ma.getObject(ima.set(ii)).toString());
                if (ii != last - 1) {
                    out.print(", ");
                }
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
            out.print("}");
            return;
        }
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            Array slice = ma.slice(0, ii);
            NCdumpW.printArray(slice, out, indent, ct);
            if (ii != last - 1) {
                out.print(",");
            }
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    static void printStringArray(PrintWriter out, ArrayChar ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        if (rank == 1) {
            out.print("  \"" + ma.getString() + "\"");
            return;
        }
        if (rank == 2) {
            boolean first = true;
            ArrayChar.StringIterator iter = ma.getStringIterator();
            while (iter.hasNext()) {
                if (!first) {
                    out.print(", ");
                }
                out.print("\"" + iter.next() + "\"");
                first = false;
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            ArrayChar slice = (ArrayChar)ma.slice(0, ii);
            NCdumpW.printStringArray(out, slice, indent, ct);
            if (ii != last - 1) {
                out.print(",");
            }
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    private static void printByteBuffer(PrintWriter out, ByteBuffer bb, Indent indent) {
        out.print(indent + "0x");
        int last = bb.limit() - 1;
        for (int i = 0; i <= last; ++i) {
            out.printf("%02x", bb.get(i));
        }
    }

    static void printStringArray(PrintWriter out, ArrayObject ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            out.print("  \"" + ma.getObject(ima) + "\"");
            return;
        }
        if (rank == 1) {
            boolean first = true;
            int i = 0;
            while ((long)i < ma.getSize()) {
                if (!first) {
                    out.print(", ");
                }
                out.print("  \"" + ma.getObject(ima.set(i)) + "\"");
                first = false;
                ++i;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            ArrayObject slice = (ArrayObject)ma.slice(0, ii);
            NCdumpW.printStringArray(out, slice, indent, ct);
            if (ii == last - 1) continue;
            out.print(",");
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    private static void printStructureDataArray(PrintWriter out, ArrayStructure array, Indent indent, CancelTask ct) throws IOException {
        StructureDataIterator sdataIter = array.getStructureDataIterator();
        int count = 0;
        while (sdataIter.hasNext()) {
            StructureData sdata = sdataIter.next();
            out.println("\n" + indent + "{");
            NCdumpW.printStructureData(out, sdata, indent, ct);
            out.print(indent + "} " + sdata.getName() + "(" + count + ")");
            if (ct != null && ct.isCancel()) {
                return;
            }
            ++count;
        }
    }

    private static void printVariableArray(PrintWriter out, ArrayObject array, Indent indent, CancelTask ct) throws IOException {
        out.println("\n" + indent + "{");
        indent.incr();
        IndexIterator iter = array.getIndexIterator();
        while (iter.hasNext()) {
            Array data = (Array)iter.next();
            NCdumpW.printArray(data, out, indent, ct);
        }
        indent.decr();
        out.print(indent + "}");
    }

    private static void printSequence(PrintWriter out, ArraySequence seq, Indent indent, CancelTask ct) throws IOException {
        StructureDataIterator iter = seq.getStructureDataIterator();
        while (iter.hasNext()) {
            StructureData sdata = iter.next();
            out.println("\n" + indent + "{");
            NCdumpW.printStructureData(out, sdata, indent, ct);
            out.print(indent + "} " + sdata.getName());
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
    }

    public static void printStructureData(PrintWriter out, StructureData sdata) throws IOException {
        NCdumpW.printStructureData(out, sdata, new Indent(2), null);
        out.flush();
    }

    private static void printStructureData(PrintWriter out, StructureData sdata, Indent indent, CancelTask ct) throws IOException {
        indent.incr();
        for (StructureMembers.Member m : sdata.getMembers()) {
            Array sdataArray = sdata.getArray(m);
            NCdumpW.printArray(sdataArray, m.getName(), m.getUnitsString(), out, indent, ct);
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
    }

    public static void printArray(Array ma, PrintWriter out) {
        ma.resetLocalIterator();
        while (ma.hasNext()) {
            out.print(ma.next());
            out.print(' ');
        }
    }

    public static void printArray(Array ma) {
        PrintWriter out = new PrintWriter(System.out);
        NCdumpW.printArray(ma, out);
        out.flush();
    }

    public static void writeNcML(NetcdfFile ncfile, Writer os, boolean showCoords, String uri) throws IOException {
        NCdumpW.writeNcML(ncfile, os, showCoords ? WantValues.coordsOnly : WantValues.none, uri);
    }

    public static void writeNcML(NetcdfFile ncfile, Writer os, WantValues showValues, String uri) throws IOException {
        NCdumpW.writeNcML(ncfile, new Formatter(os), showValues, uri);
    }

    public static void writeNcML(NetcdfFile ncfile, Formatter out, WantValues showValues, String uri) throws IOException {
        out.format("<?xml version='1.0' encoding='UTF-8'?>%n", new Object[0]);
        out.format("<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'%n", new Object[0]);
        if (uri != null) {
            out.format("    location='%s' >%n%n", StringUtil.quoteXmlAttribute(uri));
        } else {
            out.format("    location='%s' >%n%n", StringUtil.quoteXmlAttribute(URLnaming.canonicalizeWrite(ncfile.getLocation())));
        }
        if (ncfile.getId() != null) {
            out.format("    id='%s'%n", StringUtil.quoteXmlAttribute(ncfile.getId()));
        }
        if (ncfile.getTitle() != null) {
            out.format("    title='%s'%n", StringUtil.quoteXmlAttribute(ncfile.getTitle()));
        }
        NCdumpW.writeNcMLGroup(ncfile, ncfile.getRootGroup(), out, new Indent(2), showValues);
        out.format("</netcdf>%n", new Object[0]);
        out.flush();
    }

    public static void writeNcMLVariable(Variable v, Formatter out) throws IOException {
        if (v instanceof Structure) {
            NCdumpW.writeNcMLStructure((Structure)v, out, new Indent(2), WantValues.none);
        } else {
            NCdumpW.writeNcMLVariable(v, out, new Indent(2), WantValues.none);
        }
    }

    private static void writeNcMLGroup(NetcdfFile ncfile, Group g, Formatter out, Indent indent, WantValues showValues) throws IOException {
        if (g != ncfile.getRootGroup()) {
            out.format("%s<group name='%s' >%n", indent, StringUtil.quoteXmlAttribute(g.getShortName()));
        }
        indent.incr();
        List<Dimension> dimList = g.getDimensions();
        for (Dimension dim : dimList) {
            out.format("%s<dimension name='%s' length='%s'", indent, StringUtil.quoteXmlAttribute(dim.getName()), dim.getLength());
            if (dim.isUnlimited()) {
                out.format(" isUnlimited='true'", new Object[0]);
            }
            out.format(" />%n", new Object[0]);
        }
        if (dimList.size() > 0) {
            out.format("%n", new Object[0]);
        }
        List<Attribute> attList = g.getAttributes();
        for (Attribute att : attList) {
            NCdumpW.writeNcMLAtt(att, out, indent);
        }
        if (attList.size() > 0) {
            out.format("%n", new Object[0]);
        }
        for (Variable v : g.getVariables()) {
            if (v instanceof Structure) {
                NCdumpW.writeNcMLStructure((Structure)v, out, indent, showValues);
                continue;
            }
            NCdumpW.writeNcMLVariable(v, out, indent, showValues);
        }
        List<Group> groupList = g.getGroups();
        for (int i = 0; i < groupList.size(); ++i) {
            if (i > 0) {
                out.format("%n", new Object[0]);
            }
            Group nested = groupList.get(i);
            NCdumpW.writeNcMLGroup(ncfile, nested, out, indent, showValues);
        }
        indent.decr();
        if (g != ncfile.getRootGroup()) {
            out.format("%s</group>%n", indent);
        }
    }

    private static void writeNcMLStructure(Structure s, Formatter out, Indent indent, WantValues showValues) throws IOException {
        out.format("%s<structure name='%s", indent, StringUtil.quoteXmlAttribute(s.getShortName()));
        if (s.getRank() > 0) {
            NCdumpW.writeNcMLDimension(s, out);
        }
        out.format(">%n", new Object[0]);
        indent.incr();
        List<Attribute> attList = s.getAttributes();
        for (Attribute att : attList) {
            NCdumpW.writeNcMLAtt(att, out, indent);
        }
        if (attList.size() > 0) {
            out.format("%n", new Object[0]);
        }
        List<Variable> varList = s.getVariables();
        for (Variable v : varList) {
            NCdumpW.writeNcMLVariable(v, out, indent, showValues);
        }
        indent.decr();
        out.format("%s</structure>%n", indent);
    }

    private static void writeNcMLVariable(Variable v, Formatter out, Indent indent, WantValues showValues) throws IOException {
        out.format("%s<variable name='%s' type='%s'", new Object[]{indent, StringUtil.quoteXmlAttribute(v.getShortName()), v.getDataType()});
        if (v.getRank() > 0) {
            NCdumpW.writeNcMLDimension(v, out);
        }
        indent.incr();
        boolean closed = false;
        List<Attribute> atts = v.getAttributes();
        if (atts.size() > 0) {
            out.format(" >\n", new Object[0]);
            closed = true;
            for (Attribute att : atts) {
                NCdumpW.writeNcMLAtt(att, out, indent);
            }
        }
        if (showValues == WantValues.all || showValues == WantValues.coordsOnly && v.isCoordinateVariable()) {
            if (!closed) {
                out.format(" >\n", new Object[0]);
                closed = true;
            }
            NCdumpW.writeNcMLValues(v, out, indent);
        }
        indent.decr();
        if (!closed) {
            out.format(" />\n", new Object[0]);
        } else {
            out.format("%s</variable>%n", indent);
        }
    }

    private static void writeNcMLDimension(Variable v, Formatter out) {
        out.format(" shape='", new Object[0]);
        List<Dimension> dims = v.getDimensions();
        for (int j = 0; j < dims.size(); ++j) {
            Dimension dim = dims.get(j);
            if (j != 0) {
                out.format(" ", new Object[0]);
            }
            if (dim.isShared()) {
                out.format("%s", StringUtil.quoteXmlAttribute(dim.getName()));
                continue;
            }
            out.format("%d", dim.getLength());
        }
        out.format("'", new Object[0]);
    }

    private static void writeNcMLAtt(Attribute att, Formatter out, Indent indent) {
        out.format("%s<attribute name='%s' value='", indent, StringUtil.quoteXmlAttribute(att.getName()));
        if (att.isString()) {
            for (int i = 0; i < att.getLength(); ++i) {
                if (i > 0) {
                    out.format("\\, ", new Object[0]);
                }
                out.format("%s", StringUtil.quoteXmlAttribute(att.getStringValue(i)));
            }
        } else {
            for (int i = 0; i < att.getLength(); ++i) {
                if (i > 0) {
                    out.format(" ", new Object[0]);
                }
                out.format("%s ", att.getNumericValue(i));
            }
            out.format("' type='%s", new Object[]{att.getDataType()});
        }
        out.format("' />\n", new Object[0]);
    }

    private static void writeNcMLValues(Variable v, Formatter out, Indent indent) throws IOException {
        Array data = v.read();
        int width = NCdumpW.formatValues(indent + "<values>", out, 0, indent);
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            width = NCdumpW.formatValues(ii.next() + " ", out, width, indent);
        }
        NCdumpW.formatValues("</values>\n", out, width, indent);
    }

    private static int formatValues(String s, Formatter out, int width, Indent indent) {
        int len = s.length();
        if (len + width > totalWidth) {
            out.format("%n%s", indent);
            width = indent.toString().length();
        }
        out.format("%s", s);
        return width += len;
    }

    public static String encodeString(String s) {
        return StringUtil.replace(s, org, replace);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(usage);
            return;
        }
        StringBuilder sbuff = new StringBuilder();
        for (String arg : args) {
            sbuff.append(arg);
            sbuff.append(" ");
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, Charset.forName("UTF-8")));
            NCdumpW.print(sbuff.toString(), writer, null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WantValues {
        none,
        coordsOnly,
        all;

    }
}

