/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.gui.handwritingRecognizer;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.sourceforge.javaocr.gui.GUIController;

public class ConfigPanel
extends JPanel {
    public static final long serialVersionUID = 0L;
    private final GUIController guiController;
    private JRadioButton mseRec;
    private JRadioButton ratioAnz;
    private static final Logger LOG = Logger.getLogger(ConfigPanel.class.getName());

    public ConfigPanel(GUIController guiController) {
        this.guiController = guiController;
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getProcessingOptionsPanel());
    }

    public boolean isMSEEnabled() {
        return this.mseRec.isSelected();
    }

    public boolean isRatioAnzEnabled() {
        return this.ratioAnz.isSelected();
    }

    private JPanel getProcessingOptionsPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(new TitledBorder("Recognition Options"));
        panel.add(this.getPanelDescription());
        panel.add(this.getRecognizerCheckboxes());
        return panel;
    }

    private JTextArea getPanelDescription() {
        JTextArea area = new JTextArea();
        area.setBackground(this.getBackground());
        area.setEditable(false);
        String desc = "Select the desired Optical Character Recognition recognition option below:";
        area.setText(desc);
        return area;
    }

    private JPanel getRecognizerCheckboxes() {
        int rows = 3;
        int cols = 1;
        JPanel panel = new JPanel(new GridLayout(rows, cols));
        this.mseRec = new JRadioButton("Mean Square Recognizer");
        panel.add(this.mseRec);
        this.ratioAnz = new JRadioButton("Character Aspect Ratio Analyzer");
        panel.add(this.ratioAnz);
        ButtonGroup group = new ButtonGroup();
        group.add(this.mseRec);
        group.add(this.ratioAnz);
        return panel;
    }
}

