/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchRules;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.time.EnglishTimeExpressionPatterns;
import edu.stanford.nlp.time.SUTime;
import edu.stanford.nlp.time.TimeExpression;
import edu.stanford.nlp.time.TimeExpressionExtractorImpl;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Interval;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public class TimeExpressionExtractors {
    private static final Logger logger = TimeExpressionExtractorImpl.logger;

    protected static SequenceMatchRules.SequencePatternExtractRule<CoreMap, TimeExpression> getSequencePatternExtractRule(Env env, String pattern, TemporalExtractor temporalFunc) {
        return new SequenceMatchRules.SequencePatternExtractRule<CoreMap, TimeExpression>(env, pattern, new SequenceMatchExtractor(temporalFunc, false, 0));
    }

    protected static SequenceMatchRules.SequencePatternExtractRule<CoreMap, TimeExpression> getSequencePatternExtractRule(TokenSequencePattern pattern, TemporalExtractor temporalFunc) {
        return new SequenceMatchRules.SequencePatternExtractRule<CoreMap, TimeExpression>(pattern, new SequenceMatchExtractor(temporalFunc, false, 0));
    }

    protected static SequenceMatchRules.StringPatternExtractRule<TimeExpression> getStringPatternExtractRule(Env env, String pattern, TemporalExtractor temporalFunc) {
        return new SequenceMatchRules.StringPatternExtractRule<TimeExpression>(env, pattern, new StringMatchExtractor(temporalFunc, false, 0));
    }

    protected static SequenceMatchRules.StringPatternExtractRule<TimeExpression> getStringPatternExtractRuleWithWordBoundary(Env env, String pattern, TemporalExtractor temporalFunc) {
        return new SequenceMatchRules.StringPatternExtractRule<TimeExpression>(env, pattern, new StringMatchExtractor(temporalFunc, false, 0), true);
    }

    protected static SequenceMatchRules.StringPatternExtractRule<TimeExpression> getStringPatternExtractRule(Pattern pattern, TemporalExtractor temporalFunc) {
        return new SequenceMatchRules.StringPatternExtractRule<TimeExpression>(pattern, new StringMatchExtractor(temporalFunc, false, 0));
    }

    private static TimeExpression getTimeExpression(List<? extends CoreMap> list, int index) {
        return (TimeExpression)list.get(index).get(TimeExpression.Annotation.class);
    }

    private static String getText(List<? extends CoreMap> list, int index) {
        return (String)list.get(index).get(CoreAnnotations.TextAnnotation.class);
    }

    static TimePatternExtractor getTimeExtractor(SUTime.Temporal t) {
        return new GenericTimePatternExtractor(new TemporalConstFunc(t));
    }

    static TimePatternExtractor getTimeLookupExtractor(EnglishTimeExpressionPatterns patterns, Pattern pattern, int group) {
        return new GenericTimePatternExtractor(new TemporalLookupFunc(patterns, group));
    }

    static TimePatternExtractor getTimeLookupExtractor(EnglishTimeExpressionPatterns patterns, TokenSequencePattern pattern, int group) {
        return new GenericTimePatternExtractor(pattern, (Function<MatchResult, SUTime.Temporal>)new TemporalLookupFunc(patterns, group));
    }

    static TimePatternExtractor getRelativeTimeExtractor(Pattern pattern, Function<MatchResult, SUTime.Temporal> refFunc, Function<MatchResult, SUTime.TemporalOp> relOpFunc, Function<MatchResult, SUTime.Temporal> relArgFunc) {
        return new GenericTimePatternExtractor(pattern, (Function<MatchResult, SUTime.Temporal>)new TemporalComposeFunc(relOpFunc, refFunc, relArgFunc));
    }

    static TimePatternExtractor getRelativeTimeExtractor(TokenSequencePattern pattern, Function<MatchResult, SUTime.Temporal> refFunc, Function<MatchResult, SUTime.TemporalOp> relOpFunc, Function<MatchResult, SUTime.Temporal> relArgFunc) {
        return new GenericTimePatternExtractor(pattern, (Function<MatchResult, SUTime.Temporal>)new TemporalComposeFunc(relOpFunc, refFunc, relArgFunc));
    }

    static TimePatternExtractor getRelativeTimeLookupExtractor(EnglishTimeExpressionPatterns patterns, Pattern pattern, SUTime.Temporal ref, SUTime.TemporalOp relOp, int relArgGroup) {
        return new GenericTimePatternExtractor(pattern, (Function<MatchResult, SUTime.Temporal>)new TemporalComposeFunc(new TemporalOpConstFunc(relOp), new TemporalConstFunc(ref), new TemporalLookupFunc(patterns, relArgGroup)));
    }

    static TimePatternExtractor getRelativeTimeLookupExtractor(EnglishTimeExpressionPatterns patterns, TokenSequencePattern pattern, SUTime.Temporal ref, SUTime.TemporalOp relOp, int relArgGroup) {
        return new GenericTimePatternExtractor(pattern, (Function<MatchResult, SUTime.Temporal>)new TemporalComposeFunc(new TemporalOpConstFunc(relOp), new TemporalConstFunc(ref), new TemporalLookupFunc(patterns, relArgGroup)));
    }

    public static TimePatternExtractor getIsoDateExtractor(TokenSequencePattern p, int yearGroup, int monthGroup, int dayGroup, boolean yearPartial) {
        return new GenericTimePatternExtractor(p, (Function<MatchResult, SUTime.Temporal>)new IsoDateTimePatternFunc(yearGroup, monthGroup, dayGroup, -1, -1, -1, yearPartial));
    }

    public static TimePatternExtractor getIsoDateExtractor(Pattern p, int yearGroup, int monthGroup, int dayGroup, boolean yearPartial) {
        return new GenericTimePatternExtractor(p, (Function<MatchResult, SUTime.Temporal>)new IsoDateTimePatternFunc(yearGroup, monthGroup, dayGroup, -1, -1, -1, yearPartial));
    }

    public static TimePatternExtractor getIsoTimeExtractor(TokenSequencePattern p, int hourGroup, int minuteGroup, int secGroup) {
        return new GenericTimePatternExtractor(p, (Function<MatchResult, SUTime.Temporal>)new IsoDateTimePatternFunc(-1, -1, -1, hourGroup, minuteGroup, secGroup, false));
    }

    public static TimePatternExtractor getIsoTimeExtractor(Pattern p, int hourGroup, int minuteGroup, int secGroup) {
        return new GenericTimePatternExtractor(p, (Function<MatchResult, SUTime.Temporal>)new IsoDateTimePatternFunc(-1, -1, -1, hourGroup, minuteGroup, secGroup, false));
    }

    public static TimePatternExtractor getIsoDateTimeExtractor(Pattern p, int yearGroup, int monthGroup, int dayGroup, int hourGroup, int minuteGroup, int secGroup, boolean yearPartial) {
        return new GenericTimePatternExtractor(p, (Function<MatchResult, SUTime.Temporal>)new IsoDateTimePatternFunc(yearGroup, monthGroup, dayGroup, hourGroup, minuteGroup, secGroup, yearPartial));
    }

    public static TimePatternExtractor getIsoDateTimeExtractor(TokenSequencePattern p, int yearGroup, int monthGroup, int dayGroup, int hourGroup, int minuteGroup, int secGroup, boolean yearPartial) {
        return new GenericTimePatternExtractor(p, (Function<MatchResult, SUTime.Temporal>)new IsoDateTimePatternFunc(yearGroup, monthGroup, dayGroup, hourGroup, minuteGroup, secGroup, yearPartial));
    }

    static class IsoDateTimeExtractor
    implements TemporalExtractor {
        DateTimeFormatter formatter;
        boolean hasDate;
        boolean hasTime;

        public IsoDateTimeExtractor(DateTimeFormatter formatter, boolean hasDate, boolean hasTime) {
            this.formatter = formatter;
            this.hasDate = hasDate;
            this.hasTime = hasTime;
        }

        @Override
        public SUTime.Temporal apply(CoreMap chunk) {
            return this.apply((String)chunk.get(CoreAnnotations.TextAnnotation.class));
        }

        @Override
        public SUTime.Temporal apply(String text) {
            DateTime dateTime = null;
            try {
                dateTime = this.formatter.parseDateTime(text);
            }
            catch (IllegalFieldValueException e) {
                logger.warning("WARNING: Invalid temporal \"" + text + "\" (" + e.getMessage() + "). Skipping and continuing...");
                return null;
            }
            assert (dateTime != null);
            if (this.hasDate && this.hasTime) {
                if (dateTime.getZone() != null) {
                    return new SUTime.GroundedTime((ReadableInstant)dateTime);
                }
                return new SUTime.IsoDateTime(new SUTime.IsoDate(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth()), new SUTime.IsoTime(dateTime.getHourOfDay(), dateTime.getMinuteOfHour(), dateTime.getSecondOfMinute()));
            }
            if (this.hasTime) {
                return new SUTime.IsoTime(dateTime.getHourOfDay(), dateTime.getMinuteOfHour(), dateTime.getSecondOfMinute());
            }
            if (this.hasDate) {
                return new SUTime.IsoDate(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth());
            }
            return null;
        }
    }

    static class IsoDateTimePatternFunc
    implements Function<MatchResult, SUTime.Temporal> {
        boolean partialYear = false;
        int yearGroup = -1;
        int monthGroup = -1;
        int dayGroup = -1;
        int hourGroup = -1;
        int minuteGroup = -1;
        int secGroup = -1;

        public IsoDateTimePatternFunc(int yearGroup, int monthGroup, int dayGroup, int hourGroup, int minuteGroup, int secGroup, boolean partialYear) {
            this.yearGroup = yearGroup;
            this.monthGroup = monthGroup;
            this.dayGroup = dayGroup;
            this.hourGroup = hourGroup;
            this.minuteGroup = minuteGroup;
            this.secGroup = secGroup;
            this.partialYear = partialYear;
        }

        public void setPartialYear(boolean partialYear) {
            this.partialYear = partialYear;
        }

        @Override
        public SUTime.Temporal apply(MatchResult results) {
            String m;
            boolean hasTime;
            SUTime.IsoTime isoTime = null;
            SUTime.IsoDate isoDate = null;
            boolean hasDate = this.yearGroup >= 0 || this.monthGroup >= 0 || this.dayGroup >= 0;
            boolean bl = hasTime = this.hourGroup >= 0 || this.minuteGroup >= 0 || this.secGroup >= 0;
            if (hasTime) {
                String s;
                String h = this.hourGroup >= 0 ? results.group(this.hourGroup) : null;
                m = this.minuteGroup >= 0 ? results.group(this.minuteGroup) : null;
                String string = s = this.secGroup >= 0 ? results.group(this.secGroup) : null;
                if (h != null || m != null || s != null) {
                    isoTime = new SUTime.IsoTime(h, m, s);
                }
            }
            if (hasDate) {
                String d;
                String yearStr;
                String string = yearStr = this.yearGroup >= 0 ? results.group(this.yearGroup) : null;
                if (yearStr != null && yearStr.length() == 2 && this.partialYear) {
                    yearStr = "XX" + yearStr;
                }
                m = this.monthGroup >= 0 ? results.group(this.monthGroup) : null;
                String string2 = d = this.dayGroup >= 0 ? results.group(this.dayGroup) : null;
                if (yearStr != null || m != null || d != null) {
                    isoDate = EnglishTimeExpressionPatterns.createIsoDate(yearStr, m, d);
                }
            }
            if (isoTime != null && isoDate != null) {
                return new SUTime.IsoDateTime(isoDate, isoTime);
            }
            if (isoTime != null) {
                return isoTime;
            }
            if (isoDate != null) {
                return isoDate;
            }
            return null;
        }
    }

    static class TemporalComposeObjFunc
    implements Function<MatchResult, SUTime.Temporal> {
        Function<MatchResult, SUTime.TemporalOp> opFunc;
        Function<MatchResult, ?>[] argFuncs;

        TemporalComposeObjFunc(Function<MatchResult, SUTime.TemporalOp> opFunc, Function<MatchResult, ? extends Object> ... argFuncs) {
            this.opFunc = opFunc;
            this.argFuncs = argFuncs;
        }

        @Override
        public SUTime.Temporal apply(MatchResult in) {
            SUTime.TemporalOp relOp = this.opFunc != null ? this.opFunc.apply(in) : null;
            Object[] args = new Object[this.argFuncs.length];
            for (int i = 0; i < this.argFuncs.length; ++i) {
                args[i] = this.argFuncs[i] != null ? this.argFuncs[i].apply(in) : null;
            }
            return relOp.apply(args);
        }
    }

    static class TemporalComposeFunc
    implements Function<MatchResult, SUTime.Temporal> {
        Function<MatchResult, SUTime.TemporalOp> opFunc;
        Function<MatchResult, ? extends SUTime.Temporal>[] argFuncs;

        TemporalComposeFunc(Function<MatchResult, SUTime.TemporalOp> opFunc, Function<MatchResult, ? extends SUTime.Temporal> ... argFuncs) {
            this.opFunc = opFunc;
            this.argFuncs = argFuncs;
        }

        @Override
        public SUTime.Temporal apply(MatchResult in) {
            SUTime.TemporalOp relOp = this.opFunc != null ? this.opFunc.apply(in) : null;
            SUTime.Temporal[] args = new SUTime.Temporal[this.argFuncs.length];
            for (int i = 0; i < this.argFuncs.length; ++i) {
                args[i] = this.argFuncs[i] != null ? this.argFuncs[i].apply(in) : null;
            }
            return relOp.apply(args);
        }
    }

    static class TemporalOpLookupFunc
    implements Function<MatchResult, SUTime.TemporalOp> {
        EnglishTimeExpressionPatterns patterns;
        int group;

        TemporalOpLookupFunc(EnglishTimeExpressionPatterns patterns, int group) {
            this.patterns = patterns;
            this.group = group;
        }

        @Override
        public SUTime.TemporalOp apply(MatchResult in) {
            String expr;
            if (this.group >= 0 && (expr = in.group(this.group)) != null) {
                return this.patterns.lookupTemporalOp(expr);
            }
            return null;
        }
    }

    static class TemporalOpConstFunc
    implements Function<MatchResult, SUTime.TemporalOp> {
        SUTime.TemporalOp temporalOp;

        TemporalOpConstFunc(SUTime.TemporalOp temporalOp) {
            this.temporalOp = temporalOp;
        }

        @Override
        public SUTime.TemporalOp apply(MatchResult in) {
            return this.temporalOp;
        }
    }

    static class TemporalGetTEFunc
    implements Function<MatchResult, SUTime.Temporal> {
        int group = 0;
        int nodeIndex = 0;

        TemporalGetTEFunc(int group, int nodeIndex) {
            this.group = group;
            this.nodeIndex = nodeIndex;
        }

        @Override
        public SUTime.Temporal apply(MatchResult in) {
            if (in instanceof SequenceMatchResult) {
                int i;
                TimeExpression te;
                List matched;
                SequenceMatchResult mr = (SequenceMatchResult)in;
                if (this.group >= 0 && (matched = mr.groupNodes(this.group)) != null && (te = TimeExpressionExtractors.getTimeExpression(matched, i = this.nodeIndex >= 0 ? 0 : matched.size() + this.nodeIndex)) != null) {
                    return te.getTemporal();
                }
            }
            return null;
        }
    }

    static class TemporalLookupFunc
    implements Function<MatchResult, SUTime.Temporal> {
        EnglishTimeExpressionPatterns patterns;
        int group;

        TemporalLookupFunc(EnglishTimeExpressionPatterns patterns, int group) {
            this.patterns = patterns;
            this.group = group;
        }

        @Override
        public SUTime.Temporal apply(MatchResult in) {
            String expr;
            if (this.group >= 0 && (expr = in.group(this.group)) != null) {
                return this.patterns.lookupTemporal(expr);
            }
            return null;
        }
    }

    static class TemporalConstFunc
    implements Function<MatchResult, SUTime.Temporal> {
        SUTime.Temporal temporal;

        TemporalConstFunc(SUTime.Temporal temporal) {
            this.temporal = temporal;
        }

        @Override
        public SUTime.Temporal apply(MatchResult in) {
            return this.temporal;
        }
    }

    static class GenericTimePatternExtractor
    extends TimePatternExtractor {
        Function<MatchResult, SUTime.Temporal> tempFunc;

        protected GenericTimePatternExtractor(Function<MatchResult, SUTime.Temporal> tempFunc) {
            this.tempFunc = tempFunc;
        }

        protected GenericTimePatternExtractor(TokenSequencePattern tokenPattern, Function<MatchResult, SUTime.Temporal> tempFunc) {
            this.tokenPattern = tokenPattern;
            this.tempFunc = tempFunc;
        }

        protected GenericTimePatternExtractor(Pattern stringPattern, Function<MatchResult, SUTime.Temporal> tempFunc) {
            this.stringPattern = stringPattern;
            this.tempFunc = tempFunc;
        }

        @Override
        protected SUTime.Temporal extract(MatchResult results) {
            try {
                return this.tempFunc.apply(results);
            }
            catch (IllegalFieldValueException e) {
                logger.warning("WARNING: found invalid temporal expression: \"" + e.getMessage() + "\". Will discard it...");
                return null;
            }
        }
    }

    static abstract class TimePatternExtractor
    implements TemporalExtractor {
        Pattern stringPattern;
        TokenSequencePattern tokenPattern;

        TimePatternExtractor() {
        }

        @Override
        public SUTime.Temporal apply(CoreMap chunk) {
            if (this.tokenPattern != null) {
                if (chunk.containsKey(TimeExpression.ChildrenAnnotation.class)) {
                    return this.apply((List)chunk.get(TimeExpression.ChildrenAnnotation.class));
                }
                return this.apply((List)chunk.get(CoreAnnotations.NumerizedTokensAnnotation.class));
            }
            if (this.stringPattern != null) {
                return this.apply((String)chunk.get(CoreAnnotations.TextAnnotation.class));
            }
            return this.extract(null);
        }

        @Override
        public SUTime.Temporal apply(String expression) {
            Matcher matcher = this.stringPattern.matcher(expression);
            if (matcher.find()) {
                return this.extract(matcher);
            }
            return null;
        }

        @Override
        public SUTime.Temporal apply(List<? extends CoreMap> tokens) {
            SequenceMatcher matcher = this.tokenPattern.getMatcher((List)tokens);
            if (matcher.find()) {
                return this.extract(matcher);
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            if (this.stringPattern != null) {
                sb.append(" with string pattern=" + this.stringPattern.pattern());
            } else {
                sb.append(" with token pattern=" + this.tokenPattern.pattern());
            }
            return sb.toString();
        }

        protected abstract SUTime.Temporal extract(MatchResult var1);
    }

    static class DurationRule
    implements TemporalExtractor {
        EnglishTimeExpressionPatterns patterns;
        Pattern stringPattern;
        TokenSequencePattern tokenPattern;
        int exprGroup = 0;
        int valMatchGroup = -1;
        int valMatchGroup2 = -1;
        int unitMatchGroup = -1;
        int underspecifiedValMatchGroup = -1;
        String defaultUnderspecifiedValue;
        SUTime.Time beginTime;
        SUTime.Time endTime;

        private DurationRule(EnglishTimeExpressionPatterns patterns, int valMatchGroup, int unitMatchGroup, SUTime.Time beginTime, SUTime.Time endTime) {
            this.patterns = patterns;
            this.valMatchGroup = valMatchGroup;
            this.unitMatchGroup = unitMatchGroup;
            this.beginTime = beginTime;
            this.endTime = endTime;
        }

        public DurationRule(EnglishTimeExpressionPatterns patterns, Pattern p, int valMatchGroup, int unitMatchGroup) {
            this(patterns, p, valMatchGroup, unitMatchGroup, SUTime.TIME_NONE, SUTime.TIME_NONE);
        }

        public DurationRule(EnglishTimeExpressionPatterns patterns, Pattern p, int valMatchGroup, int unitMatchGroup, SUTime.Time beginTime, SUTime.Time endTime) {
            this(patterns, valMatchGroup, unitMatchGroup, beginTime, endTime);
            this.stringPattern = p;
        }

        public DurationRule(EnglishTimeExpressionPatterns patterns, Pattern p, int valMatchGroup, int valMatchGroup2, int unitMatchGroup, SUTime.Time beginTime, SUTime.Time endTime) {
            this(patterns, valMatchGroup, unitMatchGroup, beginTime, endTime);
            this.valMatchGroup2 = valMatchGroup2;
            this.stringPattern = p;
        }

        public DurationRule(EnglishTimeExpressionPatterns patterns, TokenSequencePattern p, int valMatchGroup, int unitMatchGroup) {
            this(patterns, p, valMatchGroup, unitMatchGroup, SUTime.TIME_NONE, SUTime.TIME_NONE);
        }

        public DurationRule(EnglishTimeExpressionPatterns patterns, TokenSequencePattern p, int valMatchGroup, int unitMatchGroup, SUTime.Time beginTime, SUTime.Time endTime) {
            this(patterns, valMatchGroup, unitMatchGroup, beginTime, endTime);
            this.tokenPattern = p;
        }

        public DurationRule(EnglishTimeExpressionPatterns patterns, TokenSequencePattern p, int valMatchGroup, int valMatchGroup2, int unitMatchGroup, SUTime.Time beginTime, SUTime.Time endTime) {
            this(patterns, valMatchGroup, unitMatchGroup, beginTime, endTime);
            this.valMatchGroup2 = valMatchGroup2;
            this.tokenPattern = p;
        }

        public boolean useTokens() {
            return this.tokenPattern != null;
        }

        public void setUnderspecifiedValueMatchGroup(int matchGroup, String defaultValue) {
            this.underspecifiedValMatchGroup = matchGroup;
            this.defaultUnderspecifiedValue = defaultValue;
        }

        @Override
        public SUTime.Temporal apply(CoreMap chunk) {
            if (this.tokenPattern != null) {
                return this.apply((List)chunk.get(CoreAnnotations.NumerizedTokensAnnotation.class));
            }
            return this.apply((String)chunk.get(CoreAnnotations.TextAnnotation.class));
        }

        @Override
        public SUTime.Temporal apply(String expression) {
            Matcher matcher = this.stringPattern.matcher(expression);
            if (matcher.find()) {
                return this.extract(matcher);
            }
            return null;
        }

        @Override
        public SUTime.Temporal apply(List<? extends CoreMap> tokens) {
            SequenceMatcher matcher = this.tokenPattern.getMatcher((List)tokens);
            if (matcher.find()) {
                return this.extract(matcher);
            }
            return null;
        }

        private SUTime.Temporal extract(MatchResult m) {
            String val2;
            String val = null;
            if (this.valMatchGroup >= 0) {
                val = m.group(this.valMatchGroup);
            }
            SUTime.Duration d = this.extractDuration(m, val);
            if (this.valMatchGroup2 >= 0 && (val2 = m.group(this.valMatchGroup2)) != null) {
                SUTime.Duration d2 = this.extractDuration(m, val2);
                d = val != null && d != null ? new SUTime.DurationRange(d, d2) : d2;
            }
            return this.addEndPoints(d);
        }

        private SUTime.Temporal addEndPoints(SUTime.Duration d) {
            SUTime.Temporal t = d;
            if (d != null && (this.beginTime != null || this.endTime != null)) {
                SUTime.Time b = this.beginTime;
                SUTime.Time e = this.endTime;
                if (b == SUTime.TIME_REF_UNKNOWN) {
                    b = new SUTime.RefTime("UNKNOWN");
                } else if (b == SUTime.TIME_UNKNOWN) {
                    b = new SUTime.SimpleTime("UNKNOWN");
                }
                if (e == SUTime.TIME_REF_UNKNOWN) {
                    e = new SUTime.RefTime("UNKNOWN");
                } else if (e == SUTime.TIME_UNKNOWN) {
                    e = new SUTime.SimpleTime("UNKNOWN");
                }
                t = new SUTime.Range(b, e, d);
            }
            return t;
        }

        private SUTime.Duration extractDuration(MatchResult results, String val) {
            SUTime.Duration d;
            String unit = null;
            if (this.unitMatchGroup >= 0) {
                unit = results.group(this.unitMatchGroup);
            }
            if (val == null) {
                String string = val = unit.endsWith("s") ? "X" : "1";
            }
            if (this.underspecifiedValMatchGroup >= 0) {
                val = this.defaultUnderspecifiedValue;
                if (results.groupCount() >= this.underspecifiedValMatchGroup && results.group(this.underspecifiedValMatchGroup) != null) {
                    val = "X";
                }
            }
            if ((d = this.patterns.getDuration(val, unit)) == null) {
                logger.warning("Unable to get duration with: val=" + val + ", unit=" + unit + ", matched=" + results.group());
            }
            return d;
        }
    }

    static class StringMatchExtractor
    implements Function<MatchResult, TimeExpression> {
        Function<CoreMap, SUTime.Temporal> extractor;
        boolean includeNested;
        int group = 0;

        public StringMatchExtractor(TemporalExtractor extractor, boolean includeNested, int group) {
            this.extractor = extractor;
            this.includeNested = includeNested;
            this.group = group;
        }

        @Override
        public TimeExpression apply(MatchResult matched) {
            TimeExpression te = new TimeExpression(Interval.toInterval(matched.start(this.group), matched.end(this.group), Interval.INTERVAL_OPEN_END), null, this.extractor, 0.0, 0.0);
            te.setIncludeNested(this.includeNested);
            return te;
        }
    }

    static class SequenceMatchExtractor
    implements Function<SequenceMatchResult<CoreMap>, TimeExpression> {
        Function<CoreMap, SUTime.Temporal> extractor;
        boolean includeNested;
        int group = 0;

        public SequenceMatchExtractor(TemporalExtractor extractor, boolean includeNested, int group) {
            this.extractor = extractor;
            this.includeNested = includeNested;
            this.group = group;
        }

        @Override
        public TimeExpression apply(SequenceMatchResult<CoreMap> matched) {
            TimeExpression te = new TimeExpression(null, Interval.toInterval(matched.start(this.group), matched.end(this.group), Interval.INTERVAL_OPEN_END), this.extractor, 0.0, 0.0);
            te.setIncludeNested(this.includeNested);
            return te;
        }
    }

    static interface TemporalExtractor
    extends Function<CoreMap, SUTime.Temporal> {
        @Override
        public SUTime.Temporal apply(CoreMap var1);
    }
}

