/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.sequences.SequenceModel;

public class FactoredSequenceModel
implements SequenceModel {
    SequenceModel model1;
    SequenceModel model2;
    double model1Wt = 1.0;
    double model2Wt = 1.0;
    SequenceModel[] models = null;
    double[] wts = null;

    @Override
    public double[] scoresOf(int[] sequence, int pos) {
        if (this.models != null) {
            double[] dist = ArrayMath.multiply(this.models[0].scoresOf(sequence, pos), this.wts[0]);
            for (int i = 1; i < this.models.length; ++i) {
                double[] dist_i = this.models[i].scoresOf(sequence, pos);
                ArrayMath.addMultInPlace(dist, dist_i, this.wts[i]);
            }
            return dist;
        }
        double[] dist1 = this.model1.scoresOf(sequence, pos);
        double[] dist2 = this.model2.scoresOf(sequence, pos);
        double[] dist = new double[dist1.length];
        for (int i = 0; i < dist1.length; ++i) {
            dist[i] = this.model1Wt * dist1[i] + this.model2Wt * dist2[i];
        }
        return dist;
    }

    @Override
    public double scoreOf(int[] sequence, int pos) {
        return this.scoresOf(sequence, pos)[sequence[pos]];
    }

    @Override
    public double scoreOf(int[] sequence) {
        if (this.models != null) {
            double score = 0.0;
            for (int i = 0; i < this.models.length; ++i) {
                score += this.wts[i] * this.models[i].scoreOf(sequence);
            }
            return score;
        }
        return this.model1Wt * this.model1.scoreOf(sequence) + this.model2Wt * this.model2.scoreOf(sequence);
    }

    @Override
    public int length() {
        if (this.models != null) {
            return this.models[0].length();
        }
        return this.model1.length();
    }

    @Override
    public int leftWindow() {
        if (this.models != null) {
            return this.models[0].leftWindow();
        }
        return this.model1.leftWindow();
    }

    @Override
    public int rightWindow() {
        return 0;
    }

    @Override
    public int[] getPossibleValues(int position) {
        if (this.models != null) {
            return this.models[0].getPossibleValues(position);
        }
        return this.model1.getPossibleValues(position);
    }

    public FactoredSequenceModel(SequenceModel model1, SequenceModel model2, double wt1, double wt2) {
        this(model1, model2);
        this.model1Wt = wt1;
        this.model2Wt = wt2;
    }

    public FactoredSequenceModel(SequenceModel model1, SequenceModel model2) {
        if (model1.getPossibleValues(0).length != model2.getPossibleValues(0).length) {
            throw new RuntimeException("Two models must have the same number of classes");
        }
        if (model1.length() != model2.length()) {
            throw new RuntimeException("Two models must have the same sequence length");
        }
        this.model1 = model1;
        this.model2 = model2;
    }

    public FactoredSequenceModel(SequenceModel[] models, double[] weights) {
        this.models = models;
        this.wts = weights;
    }
}

