/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.french;

import java.util.regex.Pattern;

public class FrenchUnknownWordSignatures {
    private static final Pattern pNounSuffix = Pattern.compile("(ier|i\u00e8re|it\u00e9|ion|ison|isme|ysme|iste|esse|eur|euse|ence|eau|erie|ng|ette|age|ade|ance|ude|ogue|aphe|ate|duc|anthe|archie|coque|\u00e9r\u00e8se|ergie|ogie|lithe|m\u00e8tre|m\u00e9trie|odie|pathie|phie|phone|phore|onyme|th\u00e8que|scope|some|pole|\u00f4me|chromie|pie)s?$");
    private static final Pattern pAdjSuffix = Pattern.compile("(iste|i\u00e8me|uple|issime|aire|esque|atoire|ale|al|able|ible|atif|ique|if|ive|eux|aise|ent|ois|oise|ante|el|elle|ente|oire|ain|aine)s?$");
    private static final Pattern pHasDigit = Pattern.compile("\\d+");
    private static final Pattern pIsDigit = Pattern.compile("^\\d+$");
    private static final Pattern pPosPlural = Pattern.compile("(s|ux)$");
    private static final Pattern pVerbSuffix = Pattern.compile("(ir|er|re|ez|ont|ent|ant|ais|ait|ra|era|eras|\u00e9|\u00e9s|\u00e9es|isse|it)$");
    private static final Pattern pAdvSuffix = Pattern.compile("(iment|ement|emment|amment)$");
    private static final Pattern pHasPunc = Pattern.compile("([!-/:-@\\u005B\\]^-`{-~\u00a1-\u00bf\u2010-\u2027\u2030-\u205e\u20a0-\u20b5])+");
    private static final Pattern pIsPunc = Pattern.compile("([!-/:-@\\u005B\\]^-`{-~\u00a1-\u00bf\u2010-\u2027\u2030-\u205e\u20a0-\u20b5])+$");
    private static final Pattern pAllCaps = Pattern.compile("^[A-Z\\u00C0-\\u00DD]+$");

    public static boolean hasNounSuffix(String s) {
        return pNounSuffix.matcher(s).find();
    }

    public static String nounSuffix(String s) {
        return FrenchUnknownWordSignatures.hasNounSuffix(s) ? "-noun" : "";
    }

    public static boolean hasAdjSuffix(String s) {
        return pAdjSuffix.matcher(s).find();
    }

    public static String adjSuffix(String s) {
        return FrenchUnknownWordSignatures.hasAdjSuffix(s) ? "-adj" : "";
    }

    public static String hasDigit(String s) {
        return pHasDigit.matcher(s).find() ? "-num" : "";
    }

    public static String isDigit(String s) {
        return pIsDigit.matcher(s).find() ? "-isNum" : "";
    }

    public static boolean hasVerbSuffix(String s) {
        return pVerbSuffix.matcher(s).find();
    }

    public static String verbSuffix(String s) {
        return FrenchUnknownWordSignatures.hasVerbSuffix(s) ? "-verb" : "";
    }

    public static boolean hasPossiblePlural(String s) {
        return pPosPlural.matcher(s).find();
    }

    public static String possiblePlural(String s) {
        return FrenchUnknownWordSignatures.hasPossiblePlural(s) ? "-plural" : "";
    }

    public static boolean hasAdvSuffix(String s) {
        return pAdvSuffix.matcher(s).find();
    }

    public static String advSuffix(String s) {
        return FrenchUnknownWordSignatures.hasAdvSuffix(s) ? "-adv" : "";
    }

    public static String hasPunc(String s) {
        return pHasPunc.matcher(s).find() ? "-hpunc" : "";
    }

    public static String isPunc(String s) {
        return pIsPunc.matcher(s).matches() ? "-ipunc" : "";
    }

    public static String isAllCaps(String s) {
        return pAllCaps.matcher(s).matches() ? "-allcap" : "";
    }

    public static String isCapitalized(String s) {
        if (s.length() > 0) {
            Character ch = Character.valueOf(s.charAt(0));
            return Character.isUpperCase(ch.charValue()) ? "-upper" : "";
        }
        return "";
    }
}

