use strict;
use warnings;
use utf8;

use FindBin;
use lib ("lib", "$FindBin::Bin/../blib/lib", "$FindBin::Bin/../blib/arch");

use Lingua::RU::Money::XS qw(rur2words);
use Test::Spec;

describe "Convert rubles to word, amount: " => sub {
	it "1000000.00" => sub { is rur2words(1000000.00), "один миллион рублей 00 копеек"; };
	it "2000000.00" => sub { is rur2words(2000000.00), "два миллиона рублей 00 копеек"; };
	it "3000000.00" => sub { is rur2words(3000000.00), "три миллиона рублей 00 копеек"; };
	it "4000000.00" => sub { is rur2words(4000000.00), "четыре миллиона рублей 00 копеек"; };
	it "5000000.00" => sub { is rur2words(5000000.00), "пять миллионов рублей 00 копеек"; };
	it "6000000.00" => sub { is rur2words(6000000.00), "шесть миллионов рублей 00 копеек"; };
	it "7000000.00" => sub { is rur2words(7000000.00), "семь миллионов рублей 00 копеек"; };
	it "8000000.00" => sub { is rur2words(8000000.00), "восемь миллионов рублей 00 копеек"; };
	it "9000000.00" => sub { is rur2words(9000000.00), "девять миллионов рублей 00 копеек"; };
	it "10000000.00" => sub { is rur2words(10000000.00), "десять миллионов рублей 00 копеек"; };
	it "11000000.00" => sub { is rur2words(11000000.00), "одиннадцать миллионов рублей 00 копеек"; };
	it "12000000.00" => sub { is rur2words(12000000.00), "двенадцать миллионов рублей 00 копеек"; };
	it "13000000.00" => sub { is rur2words(13000000.00), "тринадцать миллионов рублей 00 копеек"; };
	it "14000000.00" => sub { is rur2words(14000000.00), "четырнадцать миллионов рублей 00 копеек"; };
	it "15000000.00" => sub { is rur2words(15000000.00), "пятнадцать миллионов рублей 00 копеек"; };
	it "16000000.00" => sub { is rur2words(16000000.00), "шестнадцать миллионов рублей 00 копеек"; };
	it "17000000.00" => sub { is rur2words(17000000.00), "семнадцать миллионов рублей 00 копеек"; };
	it "18000000.00" => sub { is rur2words(18000000.00), "восемнадцать миллионов рублей 00 копеек"; };
	it "19000000.00" => sub { is rur2words(19000000.00), "девятнадцать миллионов рублей 00 копеек"; };
	it "20000000.00" => sub { is rur2words(20000000.00), "двадцать миллионов рублей 00 копеек"; };
	it "21000000.00" => sub { is rur2words(21000000.00), "двадцать один миллион рублей 00 копеек"; };
	it "22000000.00" => sub { is rur2words(22000000.00), "двадцать два миллиона рублей 00 копеек"; };
	it "23000000.00" => sub { is rur2words(23000000.00), "двадцать три миллиона рублей 00 копеек"; };
	it "24000000.00" => sub { is rur2words(24000000.00), "двадцать четыре миллиона рублей 00 копеек"; };
	it "25000000.00" => sub { is rur2words(25000000.00), "двадцать пять миллионов рублей 00 копеек"; };
	it "26000000.00" => sub { is rur2words(26000000.00), "двадцать шесть миллионов рублей 00 копеек"; };
	it "27000000.00" => sub { is rur2words(27000000.00), "двадцать семь миллионов рублей 00 копеек"; };
	it "28000000.00" => sub { is rur2words(28000000.00), "двадцать восемь миллионов рублей 00 копеек"; };
	it "29000000.00" => sub { is rur2words(29000000.00), "двадцать девять миллионов рублей 00 копеек"; };
	it "30000000.00" => sub { is rur2words(30000000.00), "тридцать миллионов рублей 00 копеек"; };
	it "31000000.00" => sub { is rur2words(31000000.00), "тридцать один миллион рублей 00 копеек"; };
	it "32000000.00" => sub { is rur2words(32000000.00), "тридцать два миллиона рублей 00 копеек"; };
	it "33000000.00" => sub { is rur2words(33000000.00), "тридцать три миллиона рублей 00 копеек"; };
	it "34000000.00" => sub { is rur2words(34000000.00), "тридцать четыре миллиона рублей 00 копеек"; };
	it "35000000.00" => sub { is rur2words(35000000.00), "тридцать пять миллионов рублей 00 копеек"; };
	it "36000000.00" => sub { is rur2words(36000000.00), "тридцать шесть миллионов рублей 00 копеек"; };
	it "37000000.00" => sub { is rur2words(37000000.00), "тридцать семь миллионов рублей 00 копеек"; };
	it "38000000.00" => sub { is rur2words(38000000.00), "тридцать восемь миллионов рублей 00 копеек"; };
	it "39000000.00" => sub { is rur2words(39000000.00), "тридцать девять миллионов рублей 00 копеек"; };
	it "40000000.00" => sub { is rur2words(40000000.00), "сорок миллионов рублей 00 копеек"; };
	it "41000000.00" => sub { is rur2words(41000000.00), "сорок один миллион рублей 00 копеек"; };
	it "42000000.00" => sub { is rur2words(42000000.00), "сорок два миллиона рублей 00 копеек"; };
	it "43000000.00" => sub { is rur2words(43000000.00), "сорок три миллиона рублей 00 копеек"; };
	it "44000000.00" => sub { is rur2words(44000000.00), "сорок четыре миллиона рублей 00 копеек"; };
	it "45000000.00" => sub { is rur2words(45000000.00), "сорок пять миллионов рублей 00 копеек"; };
	it "46000000.00" => sub { is rur2words(46000000.00), "сорок шесть миллионов рублей 00 копеек"; };
	it "47000000.00" => sub { is rur2words(47000000.00), "сорок семь миллионов рублей 00 копеек"; };
	it "48000000.00" => sub { is rur2words(48000000.00), "сорок восемь миллионов рублей 00 копеек"; };
	it "49000000.00" => sub { is rur2words(49000000.00), "сорок девять миллионов рублей 00 копеек"; };
	it "50000000.00" => sub { is rur2words(50000000.00), "пятьдесят миллионов рублей 00 копеек"; };
	it "51000000.00" => sub { is rur2words(51000000.00), "пятьдесят один миллион рублей 00 копеек"; };
	it "52000000.00" => sub { is rur2words(52000000.00), "пятьдесят два миллиона рублей 00 копеек"; };
	it "53000000.00" => sub { is rur2words(53000000.00), "пятьдесят три миллиона рублей 00 копеек"; };
	it "54000000.00" => sub { is rur2words(54000000.00), "пятьдесят четыре миллиона рублей 00 копеек"; };
	it "55000000.00" => sub { is rur2words(55000000.00), "пятьдесят пять миллионов рублей 00 копеек"; };
	it "56000000.00" => sub { is rur2words(56000000.00), "пятьдесят шесть миллионов рублей 00 копеек"; };
	it "57000000.00" => sub { is rur2words(57000000.00), "пятьдесят семь миллионов рублей 00 копеек"; };
	it "58000000.00" => sub { is rur2words(58000000.00), "пятьдесят восемь миллионов рублей 00 копеек"; };
	it "59000000.00" => sub { is rur2words(59000000.00), "пятьдесят девять миллионов рублей 00 копеек"; };
	it "60000000.00" => sub { is rur2words(60000000.00), "шестьдесят миллионов рублей 00 копеек"; };
	it "61000000.00" => sub { is rur2words(61000000.00), "шестьдесят один миллион рублей 00 копеек"; };
	it "62000000.00" => sub { is rur2words(62000000.00), "шестьдесят два миллиона рублей 00 копеек"; };
	it "63000000.00" => sub { is rur2words(63000000.00), "шестьдесят три миллиона рублей 00 копеек"; };
	it "64000000.00" => sub { is rur2words(64000000.00), "шестьдесят четыре миллиона рублей 00 копеек"; };
	it "65000000.00" => sub { is rur2words(65000000.00), "шестьдесят пять миллионов рублей 00 копеек"; };
	it "66000000.00" => sub { is rur2words(66000000.00), "шестьдесят шесть миллионов рублей 00 копеек"; };
	it "67000000.00" => sub { is rur2words(67000000.00), "шестьдесят семь миллионов рублей 00 копеек"; };
	it "68000000.00" => sub { is rur2words(68000000.00), "шестьдесят восемь миллионов рублей 00 копеек"; };
	it "69000000.00" => sub { is rur2words(69000000.00), "шестьдесят девять миллионов рублей 00 копеек"; };
	it "70000000.00" => sub { is rur2words(70000000.00), "семьдесят миллионов рублей 00 копеек"; };
	it "71000000.00" => sub { is rur2words(71000000.00), "семьдесят один миллион рублей 00 копеек"; };
	it "72000000.00" => sub { is rur2words(72000000.00), "семьдесят два миллиона рублей 00 копеек"; };
	it "73000000.00" => sub { is rur2words(73000000.00), "семьдесят три миллиона рублей 00 копеек"; };
	it "74000000.00" => sub { is rur2words(74000000.00), "семьдесят четыре миллиона рублей 00 копеек"; };
	it "75000000.00" => sub { is rur2words(75000000.00), "семьдесят пять миллионов рублей 00 копеек"; };
	it "76000000.00" => sub { is rur2words(76000000.00), "семьдесят шесть миллионов рублей 00 копеек"; };
	it "77000000.00" => sub { is rur2words(77000000.00), "семьдесят семь миллионов рублей 00 копеек"; };
	it "78000000.00" => sub { is rur2words(78000000.00), "семьдесят восемь миллионов рублей 00 копеек"; };
	it "79000000.00" => sub { is rur2words(79000000.00), "семьдесят девять миллионов рублей 00 копеек"; };
	it "80000000.00" => sub { is rur2words(80000000.00), "восемьдесят миллионов рублей 00 копеек"; };
	it "81000000.00" => sub { is rur2words(81000000.00), "восемьдесят один миллион рублей 00 копеек"; };
	it "82000000.00" => sub { is rur2words(82000000.00), "восемьдесят два миллиона рублей 00 копеек"; };
	it "83000000.00" => sub { is rur2words(83000000.00), "восемьдесят три миллиона рублей 00 копеек"; };
	it "84000000.00" => sub { is rur2words(84000000.00), "восемьдесят четыре миллиона рублей 00 копеек"; };
	it "85000000.00" => sub { is rur2words(85000000.00), "восемьдесят пять миллионов рублей 00 копеек"; };
	it "86000000.00" => sub { is rur2words(86000000.00), "восемьдесят шесть миллионов рублей 00 копеек"; };
	it "87000000.00" => sub { is rur2words(87000000.00), "восемьдесят семь миллионов рублей 00 копеек"; };
	it "88000000.00" => sub { is rur2words(88000000.00), "восемьдесят восемь миллионов рублей 00 копеек"; };
	it "89000000.00" => sub { is rur2words(89000000.00), "восемьдесят девять миллионов рублей 00 копеек"; };
	it "90000000.00" => sub { is rur2words(90000000.00), "девяносто миллионов рублей 00 копеек"; };
	it "91000000.00" => sub { is rur2words(91000000.00), "девяносто один миллион рублей 00 копеек"; };
	it "92000000.00" => sub { is rur2words(92000000.00), "девяносто два миллиона рублей 00 копеек"; };
	it "93000000.00" => sub { is rur2words(93000000.00), "девяносто три миллиона рублей 00 копеек"; };
	it "94000000.00" => sub { is rur2words(94000000.00), "девяносто четыре миллиона рублей 00 копеек"; };
	it "95000000.00" => sub { is rur2words(95000000.00), "девяносто пять миллионов рублей 00 копеек"; };
	it "96000000.00" => sub { is rur2words(96000000.00), "девяносто шесть миллионов рублей 00 копеек"; };
	it "97000000.00" => sub { is rur2words(97000000.00), "девяносто семь миллионов рублей 00 копеек"; };
	it "98000000.00" => sub { is rur2words(98000000.00), "девяносто восемь миллионов рублей 00 копеек"; };
	it "99000000.00" => sub { is rur2words(99000000.00), "девяносто девять миллионов рублей 00 копеек"; };
	it "100000000.00" => sub { is rur2words(100000000.00), "сто миллионов рублей 00 копеек"; };
	it "101000000.00" => sub { is rur2words(101000000.00), "сто один миллион рублей 00 копеек"; };
	it "102000000.00" => sub { is rur2words(102000000.00), "сто два миллиона рублей 00 копеек"; };
	it "103000000.00" => sub { is rur2words(103000000.00), "сто три миллиона рублей 00 копеек"; };
	it "104000000.00" => sub { is rur2words(104000000.00), "сто четыре миллиона рублей 00 копеек"; };
	it "105000000.00" => sub { is rur2words(105000000.00), "сто пять миллионов рублей 00 копеек"; };
	it "106000000.00" => sub { is rur2words(106000000.00), "сто шесть миллионов рублей 00 копеек"; };
	it "107000000.00" => sub { is rur2words(107000000.00), "сто семь миллионов рублей 00 копеек"; };
	it "108000000.00" => sub { is rur2words(108000000.00), "сто восемь миллионов рублей 00 копеек"; };
	it "109000000.00" => sub { is rur2words(109000000.00), "сто девять миллионов рублей 00 копеек"; };
	it "110000000.00" => sub { is rur2words(110000000.00), "сто десять миллионов рублей 00 копеек"; };
	it "111000000.00" => sub { is rur2words(111000000.00), "сто одиннадцать миллионов рублей 00 копеек"; };
	it "112000000.00" => sub { is rur2words(112000000.00), "сто двенадцать миллионов рублей 00 копеек"; };
	it "113000000.00" => sub { is rur2words(113000000.00), "сто тринадцать миллионов рублей 00 копеек"; };
	it "114000000.00" => sub { is rur2words(114000000.00), "сто четырнадцать миллионов рублей 00 копеек"; };
	it "115000000.00" => sub { is rur2words(115000000.00), "сто пятнадцать миллионов рублей 00 копеек"; };
	it "116000000.00" => sub { is rur2words(116000000.00), "сто шестнадцать миллионов рублей 00 копеек"; };
	it "117000000.00" => sub { is rur2words(117000000.00), "сто семнадцать миллионов рублей 00 копеек"; };
	it "118000000.00" => sub { is rur2words(118000000.00), "сто восемнадцать миллионов рублей 00 копеек"; };
	it "119000000.00" => sub { is rur2words(119000000.00), "сто девятнадцать миллионов рублей 00 копеек"; };
	it "120000000.00" => sub { is rur2words(120000000.00), "сто двадцать миллионов рублей 00 копеек"; };
	it "121000000.00" => sub { is rur2words(121000000.00), "сто двадцать один миллион рублей 00 копеек"; };
	it "122000000.00" => sub { is rur2words(122000000.00), "сто двадцать два миллиона рублей 00 копеек"; };
	it "123000000.00" => sub { is rur2words(123000000.00), "сто двадцать три миллиона рублей 00 копеек"; };
	it "124000000.00" => sub { is rur2words(124000000.00), "сто двадцать четыре миллиона рублей 00 копеек"; };
	it "125000000.00" => sub { is rur2words(125000000.00), "сто двадцать пять миллионов рублей 00 копеек"; };
	it "126000000.00" => sub { is rur2words(126000000.00), "сто двадцать шесть миллионов рублей 00 копеек"; };
	it "127000000.00" => sub { is rur2words(127000000.00), "сто двадцать семь миллионов рублей 00 копеек"; };
	it "128000000.00" => sub { is rur2words(128000000.00), "сто двадцать восемь миллионов рублей 00 копеек"; };
	it "129000000.00" => sub { is rur2words(129000000.00), "сто двадцать девять миллионов рублей 00 копеек"; };
	it "130000000.00" => sub { is rur2words(130000000.00), "сто тридцать миллионов рублей 00 копеек"; };
	it "131000000.00" => sub { is rur2words(131000000.00), "сто тридцать один миллион рублей 00 копеек"; };
	it "132000000.00" => sub { is rur2words(132000000.00), "сто тридцать два миллиона рублей 00 копеек"; };
	it "133000000.00" => sub { is rur2words(133000000.00), "сто тридцать три миллиона рублей 00 копеек"; };
	it "134000000.00" => sub { is rur2words(134000000.00), "сто тридцать четыре миллиона рублей 00 копеек"; };
	it "135000000.00" => sub { is rur2words(135000000.00), "сто тридцать пять миллионов рублей 00 копеек"; };
	it "136000000.00" => sub { is rur2words(136000000.00), "сто тридцать шесть миллионов рублей 00 копеек"; };
	it "137000000.00" => sub { is rur2words(137000000.00), "сто тридцать семь миллионов рублей 00 копеек"; };
	it "138000000.00" => sub { is rur2words(138000000.00), "сто тридцать восемь миллионов рублей 00 копеек"; };
	it "139000000.00" => sub { is rur2words(139000000.00), "сто тридцать девять миллионов рублей 00 копеек"; };
	it "140000000.00" => sub { is rur2words(140000000.00), "сто сорок миллионов рублей 00 копеек"; };
	it "141000000.00" => sub { is rur2words(141000000.00), "сто сорок один миллион рублей 00 копеек"; };
	it "142000000.00" => sub { is rur2words(142000000.00), "сто сорок два миллиона рублей 00 копеек"; };
	it "143000000.00" => sub { is rur2words(143000000.00), "сто сорок три миллиона рублей 00 копеек"; };
	it "144000000.00" => sub { is rur2words(144000000.00), "сто сорок четыре миллиона рублей 00 копеек"; };
	it "145000000.00" => sub { is rur2words(145000000.00), "сто сорок пять миллионов рублей 00 копеек"; };
	it "146000000.00" => sub { is rur2words(146000000.00), "сто сорок шесть миллионов рублей 00 копеек"; };
	it "147000000.00" => sub { is rur2words(147000000.00), "сто сорок семь миллионов рублей 00 копеек"; };
	it "148000000.00" => sub { is rur2words(148000000.00), "сто сорок восемь миллионов рублей 00 копеек"; };
	it "149000000.00" => sub { is rur2words(149000000.00), "сто сорок девять миллионов рублей 00 копеек"; };
	it "150000000.00" => sub { is rur2words(150000000.00), "сто пятьдесят миллионов рублей 00 копеек"; };
	it "151000000.00" => sub { is rur2words(151000000.00), "сто пятьдесят один миллион рублей 00 копеек"; };
	it "152000000.00" => sub { is rur2words(152000000.00), "сто пятьдесят два миллиона рублей 00 копеек"; };
	it "153000000.00" => sub { is rur2words(153000000.00), "сто пятьдесят три миллиона рублей 00 копеек"; };
	it "154000000.00" => sub { is rur2words(154000000.00), "сто пятьдесят четыре миллиона рублей 00 копеек"; };
	it "155000000.00" => sub { is rur2words(155000000.00), "сто пятьдесят пять миллионов рублей 00 копеек"; };
	it "156000000.00" => sub { is rur2words(156000000.00), "сто пятьдесят шесть миллионов рублей 00 копеек"; };
	it "157000000.00" => sub { is rur2words(157000000.00), "сто пятьдесят семь миллионов рублей 00 копеек"; };
	it "158000000.00" => sub { is rur2words(158000000.00), "сто пятьдесят восемь миллионов рублей 00 копеек"; };
	it "159000000.00" => sub { is rur2words(159000000.00), "сто пятьдесят девять миллионов рублей 00 копеек"; };
	it "160000000.00" => sub { is rur2words(160000000.00), "сто шестьдесят миллионов рублей 00 копеек"; };
	it "161000000.00" => sub { is rur2words(161000000.00), "сто шестьдесят один миллион рублей 00 копеек"; };
	it "162000000.00" => sub { is rur2words(162000000.00), "сто шестьдесят два миллиона рублей 00 копеек"; };
	it "163000000.00" => sub { is rur2words(163000000.00), "сто шестьдесят три миллиона рублей 00 копеек"; };
	it "164000000.00" => sub { is rur2words(164000000.00), "сто шестьдесят четыре миллиона рублей 00 копеек"; };
	it "165000000.00" => sub { is rur2words(165000000.00), "сто шестьдесят пять миллионов рублей 00 копеек"; };
	it "166000000.00" => sub { is rur2words(166000000.00), "сто шестьдесят шесть миллионов рублей 00 копеек"; };
	it "167000000.00" => sub { is rur2words(167000000.00), "сто шестьдесят семь миллионов рублей 00 копеек"; };
	it "168000000.00" => sub { is rur2words(168000000.00), "сто шестьдесят восемь миллионов рублей 00 копеек"; };
	it "169000000.00" => sub { is rur2words(169000000.00), "сто шестьдесят девять миллионов рублей 00 копеек"; };
	it "170000000.00" => sub { is rur2words(170000000.00), "сто семьдесят миллионов рублей 00 копеек"; };
	it "171000000.00" => sub { is rur2words(171000000.00), "сто семьдесят один миллион рублей 00 копеек"; };
	it "172000000.00" => sub { is rur2words(172000000.00), "сто семьдесят два миллиона рублей 00 копеек"; };
	it "173000000.00" => sub { is rur2words(173000000.00), "сто семьдесят три миллиона рублей 00 копеек"; };
	it "174000000.00" => sub { is rur2words(174000000.00), "сто семьдесят четыре миллиона рублей 00 копеек"; };
	it "175000000.00" => sub { is rur2words(175000000.00), "сто семьдесят пять миллионов рублей 00 копеек"; };
	it "176000000.00" => sub { is rur2words(176000000.00), "сто семьдесят шесть миллионов рублей 00 копеек"; };
	it "177000000.00" => sub { is rur2words(177000000.00), "сто семьдесят семь миллионов рублей 00 копеек"; };
	it "178000000.00" => sub { is rur2words(178000000.00), "сто семьдесят восемь миллионов рублей 00 копеек"; };
	it "179000000.00" => sub { is rur2words(179000000.00), "сто семьдесят девять миллионов рублей 00 копеек"; };
	it "180000000.00" => sub { is rur2words(180000000.00), "сто восемьдесят миллионов рублей 00 копеек"; };
	it "181000000.00" => sub { is rur2words(181000000.00), "сто восемьдесят один миллион рублей 00 копеек"; };
	it "182000000.00" => sub { is rur2words(182000000.00), "сто восемьдесят два миллиона рублей 00 копеек"; };
	it "183000000.00" => sub { is rur2words(183000000.00), "сто восемьдесят три миллиона рублей 00 копеек"; };
	it "184000000.00" => sub { is rur2words(184000000.00), "сто восемьдесят четыре миллиона рублей 00 копеек"; };
	it "185000000.00" => sub { is rur2words(185000000.00), "сто восемьдесят пять миллионов рублей 00 копеек"; };
	it "186000000.00" => sub { is rur2words(186000000.00), "сто восемьдесят шесть миллионов рублей 00 копеек"; };
	it "187000000.00" => sub { is rur2words(187000000.00), "сто восемьдесят семь миллионов рублей 00 копеек"; };
	it "188000000.00" => sub { is rur2words(188000000.00), "сто восемьдесят восемь миллионов рублей 00 копеек"; };
	it "189000000.00" => sub { is rur2words(189000000.00), "сто восемьдесят девять миллионов рублей 00 копеек"; };
	it "190000000.00" => sub { is rur2words(190000000.00), "сто девяносто миллионов рублей 00 копеек"; };
	it "191000000.00" => sub { is rur2words(191000000.00), "сто девяносто один миллион рублей 00 копеек"; };
	it "192000000.00" => sub { is rur2words(192000000.00), "сто девяносто два миллиона рублей 00 копеек"; };
	it "193000000.00" => sub { is rur2words(193000000.00), "сто девяносто три миллиона рублей 00 копеек"; };
	it "194000000.00" => sub { is rur2words(194000000.00), "сто девяносто четыре миллиона рублей 00 копеек"; };
	it "195000000.00" => sub { is rur2words(195000000.00), "сто девяносто пять миллионов рублей 00 копеек"; };
	it "196000000.00" => sub { is rur2words(196000000.00), "сто девяносто шесть миллионов рублей 00 копеек"; };
	it "197000000.00" => sub { is rur2words(197000000.00), "сто девяносто семь миллионов рублей 00 копеек"; };
	it "198000000.00" => sub { is rur2words(198000000.00), "сто девяносто восемь миллионов рублей 00 копеек"; };
	it "199000000.00" => sub { is rur2words(199000000.00), "сто девяносто девять миллионов рублей 00 копеек"; };
	it "200000000.00" => sub { is rur2words(200000000.00), "двести миллионов рублей 00 копеек"; };
	it "201000000.00" => sub { is rur2words(201000000.00), "двести один миллион рублей 00 копеек"; };
	it "202000000.00" => sub { is rur2words(202000000.00), "двести два миллиона рублей 00 копеек"; };
	it "203000000.00" => sub { is rur2words(203000000.00), "двести три миллиона рублей 00 копеек"; };
	it "204000000.00" => sub { is rur2words(204000000.00), "двести четыре миллиона рублей 00 копеек"; };
	it "205000000.00" => sub { is rur2words(205000000.00), "двести пять миллионов рублей 00 копеек"; };
	it "206000000.00" => sub { is rur2words(206000000.00), "двести шесть миллионов рублей 00 копеек"; };
	it "207000000.00" => sub { is rur2words(207000000.00), "двести семь миллионов рублей 00 копеек"; };
	it "208000000.00" => sub { is rur2words(208000000.00), "двести восемь миллионов рублей 00 копеек"; };
	it "209000000.00" => sub { is rur2words(209000000.00), "двести девять миллионов рублей 00 копеек"; };
	it "210000000.00" => sub { is rur2words(210000000.00), "двести десять миллионов рублей 00 копеек"; };
	it "211000000.00" => sub { is rur2words(211000000.00), "двести одиннадцать миллионов рублей 00 копеек"; };
	it "212000000.00" => sub { is rur2words(212000000.00), "двести двенадцать миллионов рублей 00 копеек"; };
	it "213000000.00" => sub { is rur2words(213000000.00), "двести тринадцать миллионов рублей 00 копеек"; };
	it "214000000.00" => sub { is rur2words(214000000.00), "двести четырнадцать миллионов рублей 00 копеек"; };
	it "215000000.00" => sub { is rur2words(215000000.00), "двести пятнадцать миллионов рублей 00 копеек"; };
	it "216000000.00" => sub { is rur2words(216000000.00), "двести шестнадцать миллионов рублей 00 копеек"; };
	it "217000000.00" => sub { is rur2words(217000000.00), "двести семнадцать миллионов рублей 00 копеек"; };
	it "218000000.00" => sub { is rur2words(218000000.00), "двести восемнадцать миллионов рублей 00 копеек"; };
	it "219000000.00" => sub { is rur2words(219000000.00), "двести девятнадцать миллионов рублей 00 копеек"; };
	it "220000000.00" => sub { is rur2words(220000000.00), "двести двадцать миллионов рублей 00 копеек"; };
	it "221000000.00" => sub { is rur2words(221000000.00), "двести двадцать один миллион рублей 00 копеек"; };
	it "222000000.00" => sub { is rur2words(222000000.00), "двести двадцать два миллиона рублей 00 копеек"; };
	it "223000000.00" => sub { is rur2words(223000000.00), "двести двадцать три миллиона рублей 00 копеек"; };
	it "224000000.00" => sub { is rur2words(224000000.00), "двести двадцать четыре миллиона рублей 00 копеек"; };
	it "225000000.00" => sub { is rur2words(225000000.00), "двести двадцать пять миллионов рублей 00 копеек"; };
	it "226000000.00" => sub { is rur2words(226000000.00), "двести двадцать шесть миллионов рублей 00 копеек"; };
	it "227000000.00" => sub { is rur2words(227000000.00), "двести двадцать семь миллионов рублей 00 копеек"; };
	it "228000000.00" => sub { is rur2words(228000000.00), "двести двадцать восемь миллионов рублей 00 копеек"; };
	it "229000000.00" => sub { is rur2words(229000000.00), "двести двадцать девять миллионов рублей 00 копеек"; };
	it "230000000.00" => sub { is rur2words(230000000.00), "двести тридцать миллионов рублей 00 копеек"; };
	it "231000000.00" => sub { is rur2words(231000000.00), "двести тридцать один миллион рублей 00 копеек"; };
	it "232000000.00" => sub { is rur2words(232000000.00), "двести тридцать два миллиона рублей 00 копеек"; };
	it "233000000.00" => sub { is rur2words(233000000.00), "двести тридцать три миллиона рублей 00 копеек"; };
	it "234000000.00" => sub { is rur2words(234000000.00), "двести тридцать четыре миллиона рублей 00 копеек"; };
	it "235000000.00" => sub { is rur2words(235000000.00), "двести тридцать пять миллионов рублей 00 копеек"; };
	it "236000000.00" => sub { is rur2words(236000000.00), "двести тридцать шесть миллионов рублей 00 копеек"; };
	it "237000000.00" => sub { is rur2words(237000000.00), "двести тридцать семь миллионов рублей 00 копеек"; };
	it "238000000.00" => sub { is rur2words(238000000.00), "двести тридцать восемь миллионов рублей 00 копеек"; };
	it "239000000.00" => sub { is rur2words(239000000.00), "двести тридцать девять миллионов рублей 00 копеек"; };
	it "240000000.00" => sub { is rur2words(240000000.00), "двести сорок миллионов рублей 00 копеек"; };
	it "241000000.00" => sub { is rur2words(241000000.00), "двести сорок один миллион рублей 00 копеек"; };
	it "242000000.00" => sub { is rur2words(242000000.00), "двести сорок два миллиона рублей 00 копеек"; };
	it "243000000.00" => sub { is rur2words(243000000.00), "двести сорок три миллиона рублей 00 копеек"; };
	it "244000000.00" => sub { is rur2words(244000000.00), "двести сорок четыре миллиона рублей 00 копеек"; };
	it "245000000.00" => sub { is rur2words(245000000.00), "двести сорок пять миллионов рублей 00 копеек"; };
	it "246000000.00" => sub { is rur2words(246000000.00), "двести сорок шесть миллионов рублей 00 копеек"; };
	it "247000000.00" => sub { is rur2words(247000000.00), "двести сорок семь миллионов рублей 00 копеек"; };
	it "248000000.00" => sub { is rur2words(248000000.00), "двести сорок восемь миллионов рублей 00 копеек"; };
	it "249000000.00" => sub { is rur2words(249000000.00), "двести сорок девять миллионов рублей 00 копеек"; };
	it "250000000.00" => sub { is rur2words(250000000.00), "двести пятьдесят миллионов рублей 00 копеек"; };
	it "251000000.00" => sub { is rur2words(251000000.00), "двести пятьдесят один миллион рублей 00 копеек"; };
	it "252000000.00" => sub { is rur2words(252000000.00), "двести пятьдесят два миллиона рублей 00 копеек"; };
	it "253000000.00" => sub { is rur2words(253000000.00), "двести пятьдесят три миллиона рублей 00 копеек"; };
	it "254000000.00" => sub { is rur2words(254000000.00), "двести пятьдесят четыре миллиона рублей 00 копеек"; };
	it "255000000.00" => sub { is rur2words(255000000.00), "двести пятьдесят пять миллионов рублей 00 копеек"; };
	it "256000000.00" => sub { is rur2words(256000000.00), "двести пятьдесят шесть миллионов рублей 00 копеек"; };
	it "257000000.00" => sub { is rur2words(257000000.00), "двести пятьдесят семь миллионов рублей 00 копеек"; };
	it "258000000.00" => sub { is rur2words(258000000.00), "двести пятьдесят восемь миллионов рублей 00 копеек"; };
	it "259000000.00" => sub { is rur2words(259000000.00), "двести пятьдесят девять миллионов рублей 00 копеек"; };
	it "260000000.00" => sub { is rur2words(260000000.00), "двести шестьдесят миллионов рублей 00 копеек"; };
	it "261000000.00" => sub { is rur2words(261000000.00), "двести шестьдесят один миллион рублей 00 копеек"; };
	it "262000000.00" => sub { is rur2words(262000000.00), "двести шестьдесят два миллиона рублей 00 копеек"; };
	it "263000000.00" => sub { is rur2words(263000000.00), "двести шестьдесят три миллиона рублей 00 копеек"; };
	it "264000000.00" => sub { is rur2words(264000000.00), "двести шестьдесят четыре миллиона рублей 00 копеек"; };
	it "265000000.00" => sub { is rur2words(265000000.00), "двести шестьдесят пять миллионов рублей 00 копеек"; };
	it "266000000.00" => sub { is rur2words(266000000.00), "двести шестьдесят шесть миллионов рублей 00 копеек"; };
	it "267000000.00" => sub { is rur2words(267000000.00), "двести шестьдесят семь миллионов рублей 00 копеек"; };
	it "268000000.00" => sub { is rur2words(268000000.00), "двести шестьдесят восемь миллионов рублей 00 копеек"; };
	it "269000000.00" => sub { is rur2words(269000000.00), "двести шестьдесят девять миллионов рублей 00 копеек"; };
	it "270000000.00" => sub { is rur2words(270000000.00), "двести семьдесят миллионов рублей 00 копеек"; };
	it "271000000.00" => sub { is rur2words(271000000.00), "двести семьдесят один миллион рублей 00 копеек"; };
	it "272000000.00" => sub { is rur2words(272000000.00), "двести семьдесят два миллиона рублей 00 копеек"; };
	it "273000000.00" => sub { is rur2words(273000000.00), "двести семьдесят три миллиона рублей 00 копеек"; };
	it "274000000.00" => sub { is rur2words(274000000.00), "двести семьдесят четыре миллиона рублей 00 копеек"; };
	it "275000000.00" => sub { is rur2words(275000000.00), "двести семьдесят пять миллионов рублей 00 копеек"; };
	it "276000000.00" => sub { is rur2words(276000000.00), "двести семьдесят шесть миллионов рублей 00 копеек"; };
	it "277000000.00" => sub { is rur2words(277000000.00), "двести семьдесят семь миллионов рублей 00 копеек"; };
	it "278000000.00" => sub { is rur2words(278000000.00), "двести семьдесят восемь миллионов рублей 00 копеек"; };
	it "279000000.00" => sub { is rur2words(279000000.00), "двести семьдесят девять миллионов рублей 00 копеек"; };
	it "280000000.00" => sub { is rur2words(280000000.00), "двести восемьдесят миллионов рублей 00 копеек"; };
	it "281000000.00" => sub { is rur2words(281000000.00), "двести восемьдесят один миллион рублей 00 копеек"; };
	it "282000000.00" => sub { is rur2words(282000000.00), "двести восемьдесят два миллиона рублей 00 копеек"; };
	it "283000000.00" => sub { is rur2words(283000000.00), "двести восемьдесят три миллиона рублей 00 копеек"; };
	it "284000000.00" => sub { is rur2words(284000000.00), "двести восемьдесят четыре миллиона рублей 00 копеек"; };
	it "285000000.00" => sub { is rur2words(285000000.00), "двести восемьдесят пять миллионов рублей 00 копеек"; };
	it "286000000.00" => sub { is rur2words(286000000.00), "двести восемьдесят шесть миллионов рублей 00 копеек"; };
	it "287000000.00" => sub { is rur2words(287000000.00), "двести восемьдесят семь миллионов рублей 00 копеек"; };
	it "288000000.00" => sub { is rur2words(288000000.00), "двести восемьдесят восемь миллионов рублей 00 копеек"; };
	it "289000000.00" => sub { is rur2words(289000000.00), "двести восемьдесят девять миллионов рублей 00 копеек"; };
	it "290000000.00" => sub { is rur2words(290000000.00), "двести девяносто миллионов рублей 00 копеек"; };
	it "291000000.00" => sub { is rur2words(291000000.00), "двести девяносто один миллион рублей 00 копеек"; };
	it "292000000.00" => sub { is rur2words(292000000.00), "двести девяносто два миллиона рублей 00 копеек"; };
	it "293000000.00" => sub { is rur2words(293000000.00), "двести девяносто три миллиона рублей 00 копеек"; };
	it "294000000.00" => sub { is rur2words(294000000.00), "двести девяносто четыре миллиона рублей 00 копеек"; };
	it "295000000.00" => sub { is rur2words(295000000.00), "двести девяносто пять миллионов рублей 00 копеек"; };
	it "296000000.00" => sub { is rur2words(296000000.00), "двести девяносто шесть миллионов рублей 00 копеек"; };
	it "297000000.00" => sub { is rur2words(297000000.00), "двести девяносто семь миллионов рублей 00 копеек"; };
	it "298000000.00" => sub { is rur2words(298000000.00), "двести девяносто восемь миллионов рублей 00 копеек"; };
	it "299000000.00" => sub { is rur2words(299000000.00), "двести девяносто девять миллионов рублей 00 копеек"; };
	it "300000000.00" => sub { is rur2words(300000000.00), "триста миллионов рублей 00 копеек"; };
	it "301000000.00" => sub { is rur2words(301000000.00), "триста один миллион рублей 00 копеек"; };
	it "302000000.00" => sub { is rur2words(302000000.00), "триста два миллиона рублей 00 копеек"; };
	it "303000000.00" => sub { is rur2words(303000000.00), "триста три миллиона рублей 00 копеек"; };
	it "304000000.00" => sub { is rur2words(304000000.00), "триста четыре миллиона рублей 00 копеек"; };
	it "305000000.00" => sub { is rur2words(305000000.00), "триста пять миллионов рублей 00 копеек"; };
	it "306000000.00" => sub { is rur2words(306000000.00), "триста шесть миллионов рублей 00 копеек"; };
	it "307000000.00" => sub { is rur2words(307000000.00), "триста семь миллионов рублей 00 копеек"; };
	it "308000000.00" => sub { is rur2words(308000000.00), "триста восемь миллионов рублей 00 копеек"; };
	it "309000000.00" => sub { is rur2words(309000000.00), "триста девять миллионов рублей 00 копеек"; };
	it "310000000.00" => sub { is rur2words(310000000.00), "триста десять миллионов рублей 00 копеек"; };
	it "311000000.00" => sub { is rur2words(311000000.00), "триста одиннадцать миллионов рублей 00 копеек"; };
	it "312000000.00" => sub { is rur2words(312000000.00), "триста двенадцать миллионов рублей 00 копеек"; };
	it "313000000.00" => sub { is rur2words(313000000.00), "триста тринадцать миллионов рублей 00 копеек"; };
	it "314000000.00" => sub { is rur2words(314000000.00), "триста четырнадцать миллионов рублей 00 копеек"; };
	it "315000000.00" => sub { is rur2words(315000000.00), "триста пятнадцать миллионов рублей 00 копеек"; };
	it "316000000.00" => sub { is rur2words(316000000.00), "триста шестнадцать миллионов рублей 00 копеек"; };
	it "317000000.00" => sub { is rur2words(317000000.00), "триста семнадцать миллионов рублей 00 копеек"; };
	it "318000000.00" => sub { is rur2words(318000000.00), "триста восемнадцать миллионов рублей 00 копеек"; };
	it "319000000.00" => sub { is rur2words(319000000.00), "триста девятнадцать миллионов рублей 00 копеек"; };
	it "320000000.00" => sub { is rur2words(320000000.00), "триста двадцать миллионов рублей 00 копеек"; };
	it "321000000.00" => sub { is rur2words(321000000.00), "триста двадцать один миллион рублей 00 копеек"; };
	it "322000000.00" => sub { is rur2words(322000000.00), "триста двадцать два миллиона рублей 00 копеек"; };
	it "323000000.00" => sub { is rur2words(323000000.00), "триста двадцать три миллиона рублей 00 копеек"; };
	it "324000000.00" => sub { is rur2words(324000000.00), "триста двадцать четыре миллиона рублей 00 копеек"; };
	it "325000000.00" => sub { is rur2words(325000000.00), "триста двадцать пять миллионов рублей 00 копеек"; };
	it "326000000.00" => sub { is rur2words(326000000.00), "триста двадцать шесть миллионов рублей 00 копеек"; };
	it "327000000.00" => sub { is rur2words(327000000.00), "триста двадцать семь миллионов рублей 00 копеек"; };
	it "328000000.00" => sub { is rur2words(328000000.00), "триста двадцать восемь миллионов рублей 00 копеек"; };
	it "329000000.00" => sub { is rur2words(329000000.00), "триста двадцать девять миллионов рублей 00 копеек"; };
	it "330000000.00" => sub { is rur2words(330000000.00), "триста тридцать миллионов рублей 00 копеек"; };
	it "331000000.00" => sub { is rur2words(331000000.00), "триста тридцать один миллион рублей 00 копеек"; };
	it "332000000.00" => sub { is rur2words(332000000.00), "триста тридцать два миллиона рублей 00 копеек"; };
	it "333000000.00" => sub { is rur2words(333000000.00), "триста тридцать три миллиона рублей 00 копеек"; };
	it "334000000.00" => sub { is rur2words(334000000.00), "триста тридцать четыре миллиона рублей 00 копеек"; };
	it "335000000.00" => sub { is rur2words(335000000.00), "триста тридцать пять миллионов рублей 00 копеек"; };
	it "336000000.00" => sub { is rur2words(336000000.00), "триста тридцать шесть миллионов рублей 00 копеек"; };
	it "337000000.00" => sub { is rur2words(337000000.00), "триста тридцать семь миллионов рублей 00 копеек"; };
	it "338000000.00" => sub { is rur2words(338000000.00), "триста тридцать восемь миллионов рублей 00 копеек"; };
	it "339000000.00" => sub { is rur2words(339000000.00), "триста тридцать девять миллионов рублей 00 копеек"; };
	it "340000000.00" => sub { is rur2words(340000000.00), "триста сорок миллионов рублей 00 копеек"; };
	it "341000000.00" => sub { is rur2words(341000000.00), "триста сорок один миллион рублей 00 копеек"; };
	it "342000000.00" => sub { is rur2words(342000000.00), "триста сорок два миллиона рублей 00 копеек"; };
	it "343000000.00" => sub { is rur2words(343000000.00), "триста сорок три миллиона рублей 00 копеек"; };
	it "344000000.00" => sub { is rur2words(344000000.00), "триста сорок четыре миллиона рублей 00 копеек"; };
	it "345000000.00" => sub { is rur2words(345000000.00), "триста сорок пять миллионов рублей 00 копеек"; };
	it "346000000.00" => sub { is rur2words(346000000.00), "триста сорок шесть миллионов рублей 00 копеек"; };
	it "347000000.00" => sub { is rur2words(347000000.00), "триста сорок семь миллионов рублей 00 копеек"; };
	it "348000000.00" => sub { is rur2words(348000000.00), "триста сорок восемь миллионов рублей 00 копеек"; };
	it "349000000.00" => sub { is rur2words(349000000.00), "триста сорок девять миллионов рублей 00 копеек"; };
	it "350000000.00" => sub { is rur2words(350000000.00), "триста пятьдесят миллионов рублей 00 копеек"; };
	it "351000000.00" => sub { is rur2words(351000000.00), "триста пятьдесят один миллион рублей 00 копеек"; };
	it "352000000.00" => sub { is rur2words(352000000.00), "триста пятьдесят два миллиона рублей 00 копеек"; };
	it "353000000.00" => sub { is rur2words(353000000.00), "триста пятьдесят три миллиона рублей 00 копеек"; };
	it "354000000.00" => sub { is rur2words(354000000.00), "триста пятьдесят четыре миллиона рублей 00 копеек"; };
	it "355000000.00" => sub { is rur2words(355000000.00), "триста пятьдесят пять миллионов рублей 00 копеек"; };
	it "356000000.00" => sub { is rur2words(356000000.00), "триста пятьдесят шесть миллионов рублей 00 копеек"; };
	it "357000000.00" => sub { is rur2words(357000000.00), "триста пятьдесят семь миллионов рублей 00 копеек"; };
	it "358000000.00" => sub { is rur2words(358000000.00), "триста пятьдесят восемь миллионов рублей 00 копеек"; };
	it "359000000.00" => sub { is rur2words(359000000.00), "триста пятьдесят девять миллионов рублей 00 копеек"; };
	it "360000000.00" => sub { is rur2words(360000000.00), "триста шестьдесят миллионов рублей 00 копеек"; };
	it "361000000.00" => sub { is rur2words(361000000.00), "триста шестьдесят один миллион рублей 00 копеек"; };
	it "362000000.00" => sub { is rur2words(362000000.00), "триста шестьдесят два миллиона рублей 00 копеек"; };
	it "363000000.00" => sub { is rur2words(363000000.00), "триста шестьдесят три миллиона рублей 00 копеек"; };
	it "364000000.00" => sub { is rur2words(364000000.00), "триста шестьдесят четыре миллиона рублей 00 копеек"; };
	it "365000000.00" => sub { is rur2words(365000000.00), "триста шестьдесят пять миллионов рублей 00 копеек"; };
	it "366000000.00" => sub { is rur2words(366000000.00), "триста шестьдесят шесть миллионов рублей 00 копеек"; };
	it "367000000.00" => sub { is rur2words(367000000.00), "триста шестьдесят семь миллионов рублей 00 копеек"; };
	it "368000000.00" => sub { is rur2words(368000000.00), "триста шестьдесят восемь миллионов рублей 00 копеек"; };
	it "369000000.00" => sub { is rur2words(369000000.00), "триста шестьдесят девять миллионов рублей 00 копеек"; };
	it "370000000.00" => sub { is rur2words(370000000.00), "триста семьдесят миллионов рублей 00 копеек"; };
	it "371000000.00" => sub { is rur2words(371000000.00), "триста семьдесят один миллион рублей 00 копеек"; };
	it "372000000.00" => sub { is rur2words(372000000.00), "триста семьдесят два миллиона рублей 00 копеек"; };
	it "373000000.00" => sub { is rur2words(373000000.00), "триста семьдесят три миллиона рублей 00 копеек"; };
	it "374000000.00" => sub { is rur2words(374000000.00), "триста семьдесят четыре миллиона рублей 00 копеек"; };
	it "375000000.00" => sub { is rur2words(375000000.00), "триста семьдесят пять миллионов рублей 00 копеек"; };
	it "376000000.00" => sub { is rur2words(376000000.00), "триста семьдесят шесть миллионов рублей 00 копеек"; };
	it "377000000.00" => sub { is rur2words(377000000.00), "триста семьдесят семь миллионов рублей 00 копеек"; };
	it "378000000.00" => sub { is rur2words(378000000.00), "триста семьдесят восемь миллионов рублей 00 копеек"; };
	it "379000000.00" => sub { is rur2words(379000000.00), "триста семьдесят девять миллионов рублей 00 копеек"; };
	it "380000000.00" => sub { is rur2words(380000000.00), "триста восемьдесят миллионов рублей 00 копеек"; };
	it "381000000.00" => sub { is rur2words(381000000.00), "триста восемьдесят один миллион рублей 00 копеек"; };
	it "382000000.00" => sub { is rur2words(382000000.00), "триста восемьдесят два миллиона рублей 00 копеек"; };
	it "383000000.00" => sub { is rur2words(383000000.00), "триста восемьдесят три миллиона рублей 00 копеек"; };
	it "384000000.00" => sub { is rur2words(384000000.00), "триста восемьдесят четыре миллиона рублей 00 копеек"; };
	it "385000000.00" => sub { is rur2words(385000000.00), "триста восемьдесят пять миллионов рублей 00 копеек"; };
	it "386000000.00" => sub { is rur2words(386000000.00), "триста восемьдесят шесть миллионов рублей 00 копеек"; };
	it "387000000.00" => sub { is rur2words(387000000.00), "триста восемьдесят семь миллионов рублей 00 копеек"; };
	it "388000000.00" => sub { is rur2words(388000000.00), "триста восемьдесят восемь миллионов рублей 00 копеек"; };
	it "389000000.00" => sub { is rur2words(389000000.00), "триста восемьдесят девять миллионов рублей 00 копеек"; };
	it "390000000.00" => sub { is rur2words(390000000.00), "триста девяносто миллионов рублей 00 копеек"; };
	it "391000000.00" => sub { is rur2words(391000000.00), "триста девяносто один миллион рублей 00 копеек"; };
	it "392000000.00" => sub { is rur2words(392000000.00), "триста девяносто два миллиона рублей 00 копеек"; };
	it "393000000.00" => sub { is rur2words(393000000.00), "триста девяносто три миллиона рублей 00 копеек"; };
	it "394000000.00" => sub { is rur2words(394000000.00), "триста девяносто четыре миллиона рублей 00 копеек"; };
	it "395000000.00" => sub { is rur2words(395000000.00), "триста девяносто пять миллионов рублей 00 копеек"; };
	it "396000000.00" => sub { is rur2words(396000000.00), "триста девяносто шесть миллионов рублей 00 копеек"; };
	it "397000000.00" => sub { is rur2words(397000000.00), "триста девяносто семь миллионов рублей 00 копеек"; };
	it "398000000.00" => sub { is rur2words(398000000.00), "триста девяносто восемь миллионов рублей 00 копеек"; };
	it "399000000.00" => sub { is rur2words(399000000.00), "триста девяносто девять миллионов рублей 00 копеек"; };
	it "400000000.00" => sub { is rur2words(400000000.00), "четыреста миллионов рублей 00 копеек"; };
	it "401000000.00" => sub { is rur2words(401000000.00), "четыреста один миллион рублей 00 копеек"; };
	it "402000000.00" => sub { is rur2words(402000000.00), "четыреста два миллиона рублей 00 копеек"; };
	it "403000000.00" => sub { is rur2words(403000000.00), "четыреста три миллиона рублей 00 копеек"; };
	it "404000000.00" => sub { is rur2words(404000000.00), "четыреста четыре миллиона рублей 00 копеек"; };
	it "405000000.00" => sub { is rur2words(405000000.00), "четыреста пять миллионов рублей 00 копеек"; };
	it "406000000.00" => sub { is rur2words(406000000.00), "четыреста шесть миллионов рублей 00 копеек"; };
	it "407000000.00" => sub { is rur2words(407000000.00), "четыреста семь миллионов рублей 00 копеек"; };
	it "408000000.00" => sub { is rur2words(408000000.00), "четыреста восемь миллионов рублей 00 копеек"; };
	it "409000000.00" => sub { is rur2words(409000000.00), "четыреста девять миллионов рублей 00 копеек"; };
	it "410000000.00" => sub { is rur2words(410000000.00), "четыреста десять миллионов рублей 00 копеек"; };
	it "411000000.00" => sub { is rur2words(411000000.00), "четыреста одиннадцать миллионов рублей 00 копеек"; };
	it "412000000.00" => sub { is rur2words(412000000.00), "четыреста двенадцать миллионов рублей 00 копеек"; };
	it "413000000.00" => sub { is rur2words(413000000.00), "четыреста тринадцать миллионов рублей 00 копеек"; };
	it "414000000.00" => sub { is rur2words(414000000.00), "четыреста четырнадцать миллионов рублей 00 копеек"; };
	it "415000000.00" => sub { is rur2words(415000000.00), "четыреста пятнадцать миллионов рублей 00 копеек"; };
	it "416000000.00" => sub { is rur2words(416000000.00), "четыреста шестнадцать миллионов рублей 00 копеек"; };
	it "417000000.00" => sub { is rur2words(417000000.00), "четыреста семнадцать миллионов рублей 00 копеек"; };
	it "418000000.00" => sub { is rur2words(418000000.00), "четыреста восемнадцать миллионов рублей 00 копеек"; };
	it "419000000.00" => sub { is rur2words(419000000.00), "четыреста девятнадцать миллионов рублей 00 копеек"; };
	it "420000000.00" => sub { is rur2words(420000000.00), "четыреста двадцать миллионов рублей 00 копеек"; };
	it "421000000.00" => sub { is rur2words(421000000.00), "четыреста двадцать один миллион рублей 00 копеек"; };
	it "422000000.00" => sub { is rur2words(422000000.00), "четыреста двадцать два миллиона рублей 00 копеек"; };
	it "423000000.00" => sub { is rur2words(423000000.00), "четыреста двадцать три миллиона рублей 00 копеек"; };
	it "424000000.00" => sub { is rur2words(424000000.00), "четыреста двадцать четыре миллиона рублей 00 копеек"; };
	it "425000000.00" => sub { is rur2words(425000000.00), "четыреста двадцать пять миллионов рублей 00 копеек"; };
	it "426000000.00" => sub { is rur2words(426000000.00), "четыреста двадцать шесть миллионов рублей 00 копеек"; };
	it "427000000.00" => sub { is rur2words(427000000.00), "четыреста двадцать семь миллионов рублей 00 копеек"; };
	it "428000000.00" => sub { is rur2words(428000000.00), "четыреста двадцать восемь миллионов рублей 00 копеек"; };
	it "429000000.00" => sub { is rur2words(429000000.00), "четыреста двадцать девять миллионов рублей 00 копеек"; };
	it "430000000.00" => sub { is rur2words(430000000.00), "четыреста тридцать миллионов рублей 00 копеек"; };
	it "431000000.00" => sub { is rur2words(431000000.00), "четыреста тридцать один миллион рублей 00 копеек"; };
	it "432000000.00" => sub { is rur2words(432000000.00), "четыреста тридцать два миллиона рублей 00 копеек"; };
	it "433000000.00" => sub { is rur2words(433000000.00), "четыреста тридцать три миллиона рублей 00 копеек"; };
	it "434000000.00" => sub { is rur2words(434000000.00), "четыреста тридцать четыре миллиона рублей 00 копеек"; };
	it "435000000.00" => sub { is rur2words(435000000.00), "четыреста тридцать пять миллионов рублей 00 копеек"; };
	it "436000000.00" => sub { is rur2words(436000000.00), "четыреста тридцать шесть миллионов рублей 00 копеек"; };
	it "437000000.00" => sub { is rur2words(437000000.00), "четыреста тридцать семь миллионов рублей 00 копеек"; };
	it "438000000.00" => sub { is rur2words(438000000.00), "четыреста тридцать восемь миллионов рублей 00 копеек"; };
	it "439000000.00" => sub { is rur2words(439000000.00), "четыреста тридцать девять миллионов рублей 00 копеек"; };
	it "440000000.00" => sub { is rur2words(440000000.00), "четыреста сорок миллионов рублей 00 копеек"; };
	it "441000000.00" => sub { is rur2words(441000000.00), "четыреста сорок один миллион рублей 00 копеек"; };
	it "442000000.00" => sub { is rur2words(442000000.00), "четыреста сорок два миллиона рублей 00 копеек"; };
	it "443000000.00" => sub { is rur2words(443000000.00), "четыреста сорок три миллиона рублей 00 копеек"; };
	it "444000000.00" => sub { is rur2words(444000000.00), "четыреста сорок четыре миллиона рублей 00 копеек"; };
	it "445000000.00" => sub { is rur2words(445000000.00), "четыреста сорок пять миллионов рублей 00 копеек"; };
	it "446000000.00" => sub { is rur2words(446000000.00), "четыреста сорок шесть миллионов рублей 00 копеек"; };
	it "447000000.00" => sub { is rur2words(447000000.00), "четыреста сорок семь миллионов рублей 00 копеек"; };
	it "448000000.00" => sub { is rur2words(448000000.00), "четыреста сорок восемь миллионов рублей 00 копеек"; };
	it "449000000.00" => sub { is rur2words(449000000.00), "четыреста сорок девять миллионов рублей 00 копеек"; };
	it "450000000.00" => sub { is rur2words(450000000.00), "четыреста пятьдесят миллионов рублей 00 копеек"; };
	it "451000000.00" => sub { is rur2words(451000000.00), "четыреста пятьдесят один миллион рублей 00 копеек"; };
	it "452000000.00" => sub { is rur2words(452000000.00), "четыреста пятьдесят два миллиона рублей 00 копеек"; };
	it "453000000.00" => sub { is rur2words(453000000.00), "четыреста пятьдесят три миллиона рублей 00 копеек"; };
	it "454000000.00" => sub { is rur2words(454000000.00), "четыреста пятьдесят четыре миллиона рублей 00 копеек"; };
	it "455000000.00" => sub { is rur2words(455000000.00), "четыреста пятьдесят пять миллионов рублей 00 копеек"; };
	it "456000000.00" => sub { is rur2words(456000000.00), "четыреста пятьдесят шесть миллионов рублей 00 копеек"; };
	it "457000000.00" => sub { is rur2words(457000000.00), "четыреста пятьдесят семь миллионов рублей 00 копеек"; };
	it "458000000.00" => sub { is rur2words(458000000.00), "четыреста пятьдесят восемь миллионов рублей 00 копеек"; };
	it "459000000.00" => sub { is rur2words(459000000.00), "четыреста пятьдесят девять миллионов рублей 00 копеек"; };
	it "460000000.00" => sub { is rur2words(460000000.00), "четыреста шестьдесят миллионов рублей 00 копеек"; };
	it "461000000.00" => sub { is rur2words(461000000.00), "четыреста шестьдесят один миллион рублей 00 копеек"; };
	it "462000000.00" => sub { is rur2words(462000000.00), "четыреста шестьдесят два миллиона рублей 00 копеек"; };
	it "463000000.00" => sub { is rur2words(463000000.00), "четыреста шестьдесят три миллиона рублей 00 копеек"; };
	it "464000000.00" => sub { is rur2words(464000000.00), "четыреста шестьдесят четыре миллиона рублей 00 копеек"; };
	it "465000000.00" => sub { is rur2words(465000000.00), "четыреста шестьдесят пять миллионов рублей 00 копеек"; };
	it "466000000.00" => sub { is rur2words(466000000.00), "четыреста шестьдесят шесть миллионов рублей 00 копеек"; };
	it "467000000.00" => sub { is rur2words(467000000.00), "четыреста шестьдесят семь миллионов рублей 00 копеек"; };
	it "468000000.00" => sub { is rur2words(468000000.00), "четыреста шестьдесят восемь миллионов рублей 00 копеек"; };
	it "469000000.00" => sub { is rur2words(469000000.00), "четыреста шестьдесят девять миллионов рублей 00 копеек"; };
	it "470000000.00" => sub { is rur2words(470000000.00), "четыреста семьдесят миллионов рублей 00 копеек"; };
	it "471000000.00" => sub { is rur2words(471000000.00), "четыреста семьдесят один миллион рублей 00 копеек"; };
	it "472000000.00" => sub { is rur2words(472000000.00), "четыреста семьдесят два миллиона рублей 00 копеек"; };
	it "473000000.00" => sub { is rur2words(473000000.00), "четыреста семьдесят три миллиона рублей 00 копеек"; };
	it "474000000.00" => sub { is rur2words(474000000.00), "четыреста семьдесят четыре миллиона рублей 00 копеек"; };
	it "475000000.00" => sub { is rur2words(475000000.00), "четыреста семьдесят пять миллионов рублей 00 копеек"; };
	it "476000000.00" => sub { is rur2words(476000000.00), "четыреста семьдесят шесть миллионов рублей 00 копеек"; };
	it "477000000.00" => sub { is rur2words(477000000.00), "четыреста семьдесят семь миллионов рублей 00 копеек"; };
	it "478000000.00" => sub { is rur2words(478000000.00), "четыреста семьдесят восемь миллионов рублей 00 копеек"; };
	it "479000000.00" => sub { is rur2words(479000000.00), "четыреста семьдесят девять миллионов рублей 00 копеек"; };
	it "480000000.00" => sub { is rur2words(480000000.00), "четыреста восемьдесят миллионов рублей 00 копеек"; };
	it "481000000.00" => sub { is rur2words(481000000.00), "четыреста восемьдесят один миллион рублей 00 копеек"; };
	it "482000000.00" => sub { is rur2words(482000000.00), "четыреста восемьдесят два миллиона рублей 00 копеек"; };
	it "483000000.00" => sub { is rur2words(483000000.00), "четыреста восемьдесят три миллиона рублей 00 копеек"; };
	it "484000000.00" => sub { is rur2words(484000000.00), "четыреста восемьдесят четыре миллиона рублей 00 копеек"; };
	it "485000000.00" => sub { is rur2words(485000000.00), "четыреста восемьдесят пять миллионов рублей 00 копеек"; };
	it "486000000.00" => sub { is rur2words(486000000.00), "четыреста восемьдесят шесть миллионов рублей 00 копеек"; };
	it "487000000.00" => sub { is rur2words(487000000.00), "четыреста восемьдесят семь миллионов рублей 00 копеек"; };
	it "488000000.00" => sub { is rur2words(488000000.00), "четыреста восемьдесят восемь миллионов рублей 00 копеек"; };
	it "489000000.00" => sub { is rur2words(489000000.00), "четыреста восемьдесят девять миллионов рублей 00 копеек"; };
	it "490000000.00" => sub { is rur2words(490000000.00), "четыреста девяносто миллионов рублей 00 копеек"; };
	it "491000000.00" => sub { is rur2words(491000000.00), "четыреста девяносто один миллион рублей 00 копеек"; };
	it "492000000.00" => sub { is rur2words(492000000.00), "четыреста девяносто два миллиона рублей 00 копеек"; };
	it "493000000.00" => sub { is rur2words(493000000.00), "четыреста девяносто три миллиона рублей 00 копеек"; };
	it "494000000.00" => sub { is rur2words(494000000.00), "четыреста девяносто четыре миллиона рублей 00 копеек"; };
	it "495000000.00" => sub { is rur2words(495000000.00), "четыреста девяносто пять миллионов рублей 00 копеек"; };
	it "496000000.00" => sub { is rur2words(496000000.00), "четыреста девяносто шесть миллионов рублей 00 копеек"; };
	it "497000000.00" => sub { is rur2words(497000000.00), "четыреста девяносто семь миллионов рублей 00 копеек"; };
	it "498000000.00" => sub { is rur2words(498000000.00), "четыреста девяносто восемь миллионов рублей 00 копеек"; };
	it "499000000.00" => sub { is rur2words(499000000.00), "четыреста девяносто девять миллионов рублей 00 копеек"; };
	it "500000000.00" => sub { is rur2words(500000000.00), "пятьсот миллионов рублей 00 копеек"; };
	it "501000000.00" => sub { is rur2words(501000000.00), "пятьсот один миллион рублей 00 копеек"; };
	it "502000000.00" => sub { is rur2words(502000000.00), "пятьсот два миллиона рублей 00 копеек"; };
	it "503000000.00" => sub { is rur2words(503000000.00), "пятьсот три миллиона рублей 00 копеек"; };
	it "504000000.00" => sub { is rur2words(504000000.00), "пятьсот четыре миллиона рублей 00 копеек"; };
	it "505000000.00" => sub { is rur2words(505000000.00), "пятьсот пять миллионов рублей 00 копеек"; };
	it "506000000.00" => sub { is rur2words(506000000.00), "пятьсот шесть миллионов рублей 00 копеек"; };
	it "507000000.00" => sub { is rur2words(507000000.00), "пятьсот семь миллионов рублей 00 копеек"; };
	it "508000000.00" => sub { is rur2words(508000000.00), "пятьсот восемь миллионов рублей 00 копеек"; };
	it "509000000.00" => sub { is rur2words(509000000.00), "пятьсот девять миллионов рублей 00 копеек"; };
	it "510000000.00" => sub { is rur2words(510000000.00), "пятьсот десять миллионов рублей 00 копеек"; };
	it "511000000.00" => sub { is rur2words(511000000.00), "пятьсот одиннадцать миллионов рублей 00 копеек"; };
	it "512000000.00" => sub { is rur2words(512000000.00), "пятьсот двенадцать миллионов рублей 00 копеек"; };
	it "513000000.00" => sub { is rur2words(513000000.00), "пятьсот тринадцать миллионов рублей 00 копеек"; };
	it "514000000.00" => sub { is rur2words(514000000.00), "пятьсот четырнадцать миллионов рублей 00 копеек"; };
	it "515000000.00" => sub { is rur2words(515000000.00), "пятьсот пятнадцать миллионов рублей 00 копеек"; };
	it "516000000.00" => sub { is rur2words(516000000.00), "пятьсот шестнадцать миллионов рублей 00 копеек"; };
	it "517000000.00" => sub { is rur2words(517000000.00), "пятьсот семнадцать миллионов рублей 00 копеек"; };
	it "518000000.00" => sub { is rur2words(518000000.00), "пятьсот восемнадцать миллионов рублей 00 копеек"; };
	it "519000000.00" => sub { is rur2words(519000000.00), "пятьсот девятнадцать миллионов рублей 00 копеек"; };
	it "520000000.00" => sub { is rur2words(520000000.00), "пятьсот двадцать миллионов рублей 00 копеек"; };
	it "521000000.00" => sub { is rur2words(521000000.00), "пятьсот двадцать один миллион рублей 00 копеек"; };
	it "522000000.00" => sub { is rur2words(522000000.00), "пятьсот двадцать два миллиона рублей 00 копеек"; };
	it "523000000.00" => sub { is rur2words(523000000.00), "пятьсот двадцать три миллиона рублей 00 копеек"; };
	it "524000000.00" => sub { is rur2words(524000000.00), "пятьсот двадцать четыре миллиона рублей 00 копеек"; };
	it "525000000.00" => sub { is rur2words(525000000.00), "пятьсот двадцать пять миллионов рублей 00 копеек"; };
	it "526000000.00" => sub { is rur2words(526000000.00), "пятьсот двадцать шесть миллионов рублей 00 копеек"; };
	it "527000000.00" => sub { is rur2words(527000000.00), "пятьсот двадцать семь миллионов рублей 00 копеек"; };
	it "528000000.00" => sub { is rur2words(528000000.00), "пятьсот двадцать восемь миллионов рублей 00 копеек"; };
	it "529000000.00" => sub { is rur2words(529000000.00), "пятьсот двадцать девять миллионов рублей 00 копеек"; };
	it "530000000.00" => sub { is rur2words(530000000.00), "пятьсот тридцать миллионов рублей 00 копеек"; };
	it "531000000.00" => sub { is rur2words(531000000.00), "пятьсот тридцать один миллион рублей 00 копеек"; };
	it "532000000.00" => sub { is rur2words(532000000.00), "пятьсот тридцать два миллиона рублей 00 копеек"; };
	it "533000000.00" => sub { is rur2words(533000000.00), "пятьсот тридцать три миллиона рублей 00 копеек"; };
	it "534000000.00" => sub { is rur2words(534000000.00), "пятьсот тридцать четыре миллиона рублей 00 копеек"; };
	it "535000000.00" => sub { is rur2words(535000000.00), "пятьсот тридцать пять миллионов рублей 00 копеек"; };
	it "536000000.00" => sub { is rur2words(536000000.00), "пятьсот тридцать шесть миллионов рублей 00 копеек"; };
	it "537000000.00" => sub { is rur2words(537000000.00), "пятьсот тридцать семь миллионов рублей 00 копеек"; };
	it "538000000.00" => sub { is rur2words(538000000.00), "пятьсот тридцать восемь миллионов рублей 00 копеек"; };
	it "539000000.00" => sub { is rur2words(539000000.00), "пятьсот тридцать девять миллионов рублей 00 копеек"; };
	it "540000000.00" => sub { is rur2words(540000000.00), "пятьсот сорок миллионов рублей 00 копеек"; };
	it "541000000.00" => sub { is rur2words(541000000.00), "пятьсот сорок один миллион рублей 00 копеек"; };
	it "542000000.00" => sub { is rur2words(542000000.00), "пятьсот сорок два миллиона рублей 00 копеек"; };
	it "543000000.00" => sub { is rur2words(543000000.00), "пятьсот сорок три миллиона рублей 00 копеек"; };
	it "544000000.00" => sub { is rur2words(544000000.00), "пятьсот сорок четыре миллиона рублей 00 копеек"; };
	it "545000000.00" => sub { is rur2words(545000000.00), "пятьсот сорок пять миллионов рублей 00 копеек"; };
	it "546000000.00" => sub { is rur2words(546000000.00), "пятьсот сорок шесть миллионов рублей 00 копеек"; };
	it "547000000.00" => sub { is rur2words(547000000.00), "пятьсот сорок семь миллионов рублей 00 копеек"; };
	it "548000000.00" => sub { is rur2words(548000000.00), "пятьсот сорок восемь миллионов рублей 00 копеек"; };
	it "549000000.00" => sub { is rur2words(549000000.00), "пятьсот сорок девять миллионов рублей 00 копеек"; };
	it "550000000.00" => sub { is rur2words(550000000.00), "пятьсот пятьдесят миллионов рублей 00 копеек"; };
	it "551000000.00" => sub { is rur2words(551000000.00), "пятьсот пятьдесят один миллион рублей 00 копеек"; };
	it "552000000.00" => sub { is rur2words(552000000.00), "пятьсот пятьдесят два миллиона рублей 00 копеек"; };
	it "553000000.00" => sub { is rur2words(553000000.00), "пятьсот пятьдесят три миллиона рублей 00 копеек"; };
	it "554000000.00" => sub { is rur2words(554000000.00), "пятьсот пятьдесят четыре миллиона рублей 00 копеек"; };
	it "555000000.00" => sub { is rur2words(555000000.00), "пятьсот пятьдесят пять миллионов рублей 00 копеек"; };
	it "556000000.00" => sub { is rur2words(556000000.00), "пятьсот пятьдесят шесть миллионов рублей 00 копеек"; };
	it "557000000.00" => sub { is rur2words(557000000.00), "пятьсот пятьдесят семь миллионов рублей 00 копеек"; };
	it "558000000.00" => sub { is rur2words(558000000.00), "пятьсот пятьдесят восемь миллионов рублей 00 копеек"; };
	it "559000000.00" => sub { is rur2words(559000000.00), "пятьсот пятьдесят девять миллионов рублей 00 копеек"; };
	it "560000000.00" => sub { is rur2words(560000000.00), "пятьсот шестьдесят миллионов рублей 00 копеек"; };
	it "561000000.00" => sub { is rur2words(561000000.00), "пятьсот шестьдесят один миллион рублей 00 копеек"; };
	it "562000000.00" => sub { is rur2words(562000000.00), "пятьсот шестьдесят два миллиона рублей 00 копеек"; };
	it "563000000.00" => sub { is rur2words(563000000.00), "пятьсот шестьдесят три миллиона рублей 00 копеек"; };
	it "564000000.00" => sub { is rur2words(564000000.00), "пятьсот шестьдесят четыре миллиона рублей 00 копеек"; };
	it "565000000.00" => sub { is rur2words(565000000.00), "пятьсот шестьдесят пять миллионов рублей 00 копеек"; };
	it "566000000.00" => sub { is rur2words(566000000.00), "пятьсот шестьдесят шесть миллионов рублей 00 копеек"; };
	it "567000000.00" => sub { is rur2words(567000000.00), "пятьсот шестьдесят семь миллионов рублей 00 копеек"; };
	it "568000000.00" => sub { is rur2words(568000000.00), "пятьсот шестьдесят восемь миллионов рублей 00 копеек"; };
	it "569000000.00" => sub { is rur2words(569000000.00), "пятьсот шестьдесят девять миллионов рублей 00 копеек"; };
	it "570000000.00" => sub { is rur2words(570000000.00), "пятьсот семьдесят миллионов рублей 00 копеек"; };
	it "571000000.00" => sub { is rur2words(571000000.00), "пятьсот семьдесят один миллион рублей 00 копеек"; };
	it "572000000.00" => sub { is rur2words(572000000.00), "пятьсот семьдесят два миллиона рублей 00 копеек"; };
	it "573000000.00" => sub { is rur2words(573000000.00), "пятьсот семьдесят три миллиона рублей 00 копеек"; };
	it "574000000.00" => sub { is rur2words(574000000.00), "пятьсот семьдесят четыре миллиона рублей 00 копеек"; };
	it "575000000.00" => sub { is rur2words(575000000.00), "пятьсот семьдесят пять миллионов рублей 00 копеек"; };
	it "576000000.00" => sub { is rur2words(576000000.00), "пятьсот семьдесят шесть миллионов рублей 00 копеек"; };
	it "577000000.00" => sub { is rur2words(577000000.00), "пятьсот семьдесят семь миллионов рублей 00 копеек"; };
	it "578000000.00" => sub { is rur2words(578000000.00), "пятьсот семьдесят восемь миллионов рублей 00 копеек"; };
	it "579000000.00" => sub { is rur2words(579000000.00), "пятьсот семьдесят девять миллионов рублей 00 копеек"; };
	it "580000000.00" => sub { is rur2words(580000000.00), "пятьсот восемьдесят миллионов рублей 00 копеек"; };
	it "581000000.00" => sub { is rur2words(581000000.00), "пятьсот восемьдесят один миллион рублей 00 копеек"; };
	it "582000000.00" => sub { is rur2words(582000000.00), "пятьсот восемьдесят два миллиона рублей 00 копеек"; };
	it "583000000.00" => sub { is rur2words(583000000.00), "пятьсот восемьдесят три миллиона рублей 00 копеек"; };
	it "584000000.00" => sub { is rur2words(584000000.00), "пятьсот восемьдесят четыре миллиона рублей 00 копеек"; };
	it "585000000.00" => sub { is rur2words(585000000.00), "пятьсот восемьдесят пять миллионов рублей 00 копеек"; };
	it "586000000.00" => sub { is rur2words(586000000.00), "пятьсот восемьдесят шесть миллионов рублей 00 копеек"; };
	it "587000000.00" => sub { is rur2words(587000000.00), "пятьсот восемьдесят семь миллионов рублей 00 копеек"; };
	it "588000000.00" => sub { is rur2words(588000000.00), "пятьсот восемьдесят восемь миллионов рублей 00 копеек"; };
	it "589000000.00" => sub { is rur2words(589000000.00), "пятьсот восемьдесят девять миллионов рублей 00 копеек"; };
	it "590000000.00" => sub { is rur2words(590000000.00), "пятьсот девяносто миллионов рублей 00 копеек"; };
	it "591000000.00" => sub { is rur2words(591000000.00), "пятьсот девяносто один миллион рублей 00 копеек"; };
	it "592000000.00" => sub { is rur2words(592000000.00), "пятьсот девяносто два миллиона рублей 00 копеек"; };
	it "593000000.00" => sub { is rur2words(593000000.00), "пятьсот девяносто три миллиона рублей 00 копеек"; };
	it "594000000.00" => sub { is rur2words(594000000.00), "пятьсот девяносто четыре миллиона рублей 00 копеек"; };
	it "595000000.00" => sub { is rur2words(595000000.00), "пятьсот девяносто пять миллионов рублей 00 копеек"; };
	it "596000000.00" => sub { is rur2words(596000000.00), "пятьсот девяносто шесть миллионов рублей 00 копеек"; };
	it "597000000.00" => sub { is rur2words(597000000.00), "пятьсот девяносто семь миллионов рублей 00 копеек"; };
	it "598000000.00" => sub { is rur2words(598000000.00), "пятьсот девяносто восемь миллионов рублей 00 копеек"; };
	it "599000000.00" => sub { is rur2words(599000000.00), "пятьсот девяносто девять миллионов рублей 00 копеек"; };
	it "600000000.00" => sub { is rur2words(600000000.00), "шестьсот миллионов рублей 00 копеек"; };
	it "601000000.00" => sub { is rur2words(601000000.00), "шестьсот один миллион рублей 00 копеек"; };
	it "602000000.00" => sub { is rur2words(602000000.00), "шестьсот два миллиона рублей 00 копеек"; };
	it "603000000.00" => sub { is rur2words(603000000.00), "шестьсот три миллиона рублей 00 копеек"; };
	it "604000000.00" => sub { is rur2words(604000000.00), "шестьсот четыре миллиона рублей 00 копеек"; };
	it "605000000.00" => sub { is rur2words(605000000.00), "шестьсот пять миллионов рублей 00 копеек"; };
	it "606000000.00" => sub { is rur2words(606000000.00), "шестьсот шесть миллионов рублей 00 копеек"; };
	it "607000000.00" => sub { is rur2words(607000000.00), "шестьсот семь миллионов рублей 00 копеек"; };
	it "608000000.00" => sub { is rur2words(608000000.00), "шестьсот восемь миллионов рублей 00 копеек"; };
	it "609000000.00" => sub { is rur2words(609000000.00), "шестьсот девять миллионов рублей 00 копеек"; };
	it "610000000.00" => sub { is rur2words(610000000.00), "шестьсот десять миллионов рублей 00 копеек"; };
	it "611000000.00" => sub { is rur2words(611000000.00), "шестьсот одиннадцать миллионов рублей 00 копеек"; };
	it "612000000.00" => sub { is rur2words(612000000.00), "шестьсот двенадцать миллионов рублей 00 копеек"; };
	it "613000000.00" => sub { is rur2words(613000000.00), "шестьсот тринадцать миллионов рублей 00 копеек"; };
	it "614000000.00" => sub { is rur2words(614000000.00), "шестьсот четырнадцать миллионов рублей 00 копеек"; };
	it "615000000.00" => sub { is rur2words(615000000.00), "шестьсот пятнадцать миллионов рублей 00 копеек"; };
	it "616000000.00" => sub { is rur2words(616000000.00), "шестьсот шестнадцать миллионов рублей 00 копеек"; };
	it "617000000.00" => sub { is rur2words(617000000.00), "шестьсот семнадцать миллионов рублей 00 копеек"; };
	it "618000000.00" => sub { is rur2words(618000000.00), "шестьсот восемнадцать миллионов рублей 00 копеек"; };
	it "619000000.00" => sub { is rur2words(619000000.00), "шестьсот девятнадцать миллионов рублей 00 копеек"; };
	it "620000000.00" => sub { is rur2words(620000000.00), "шестьсот двадцать миллионов рублей 00 копеек"; };
	it "621000000.00" => sub { is rur2words(621000000.00), "шестьсот двадцать один миллион рублей 00 копеек"; };
	it "622000000.00" => sub { is rur2words(622000000.00), "шестьсот двадцать два миллиона рублей 00 копеек"; };
	it "623000000.00" => sub { is rur2words(623000000.00), "шестьсот двадцать три миллиона рублей 00 копеек"; };
	it "624000000.00" => sub { is rur2words(624000000.00), "шестьсот двадцать четыре миллиона рублей 00 копеек"; };
	it "625000000.00" => sub { is rur2words(625000000.00), "шестьсот двадцать пять миллионов рублей 00 копеек"; };
	it "626000000.00" => sub { is rur2words(626000000.00), "шестьсот двадцать шесть миллионов рублей 00 копеек"; };
	it "627000000.00" => sub { is rur2words(627000000.00), "шестьсот двадцать семь миллионов рублей 00 копеек"; };
	it "628000000.00" => sub { is rur2words(628000000.00), "шестьсот двадцать восемь миллионов рублей 00 копеек"; };
	it "629000000.00" => sub { is rur2words(629000000.00), "шестьсот двадцать девять миллионов рублей 00 копеек"; };
	it "630000000.00" => sub { is rur2words(630000000.00), "шестьсот тридцать миллионов рублей 00 копеек"; };
	it "631000000.00" => sub { is rur2words(631000000.00), "шестьсот тридцать один миллион рублей 00 копеек"; };
	it "632000000.00" => sub { is rur2words(632000000.00), "шестьсот тридцать два миллиона рублей 00 копеек"; };
	it "633000000.00" => sub { is rur2words(633000000.00), "шестьсот тридцать три миллиона рублей 00 копеек"; };
	it "634000000.00" => sub { is rur2words(634000000.00), "шестьсот тридцать четыре миллиона рублей 00 копеек"; };
	it "635000000.00" => sub { is rur2words(635000000.00), "шестьсот тридцать пять миллионов рублей 00 копеек"; };
	it "636000000.00" => sub { is rur2words(636000000.00), "шестьсот тридцать шесть миллионов рублей 00 копеек"; };
	it "637000000.00" => sub { is rur2words(637000000.00), "шестьсот тридцать семь миллионов рублей 00 копеек"; };
	it "638000000.00" => sub { is rur2words(638000000.00), "шестьсот тридцать восемь миллионов рублей 00 копеек"; };
	it "639000000.00" => sub { is rur2words(639000000.00), "шестьсот тридцать девять миллионов рублей 00 копеек"; };
	it "640000000.00" => sub { is rur2words(640000000.00), "шестьсот сорок миллионов рублей 00 копеек"; };
	it "641000000.00" => sub { is rur2words(641000000.00), "шестьсот сорок один миллион рублей 00 копеек"; };
	it "642000000.00" => sub { is rur2words(642000000.00), "шестьсот сорок два миллиона рублей 00 копеек"; };
	it "643000000.00" => sub { is rur2words(643000000.00), "шестьсот сорок три миллиона рублей 00 копеек"; };
	it "644000000.00" => sub { is rur2words(644000000.00), "шестьсот сорок четыре миллиона рублей 00 копеек"; };
	it "645000000.00" => sub { is rur2words(645000000.00), "шестьсот сорок пять миллионов рублей 00 копеек"; };
	it "646000000.00" => sub { is rur2words(646000000.00), "шестьсот сорок шесть миллионов рублей 00 копеек"; };
	it "647000000.00" => sub { is rur2words(647000000.00), "шестьсот сорок семь миллионов рублей 00 копеек"; };
	it "648000000.00" => sub { is rur2words(648000000.00), "шестьсот сорок восемь миллионов рублей 00 копеек"; };
	it "649000000.00" => sub { is rur2words(649000000.00), "шестьсот сорок девять миллионов рублей 00 копеек"; };
	it "650000000.00" => sub { is rur2words(650000000.00), "шестьсот пятьдесят миллионов рублей 00 копеек"; };
	it "651000000.00" => sub { is rur2words(651000000.00), "шестьсот пятьдесят один миллион рублей 00 копеек"; };
	it "652000000.00" => sub { is rur2words(652000000.00), "шестьсот пятьдесят два миллиона рублей 00 копеек"; };
	it "653000000.00" => sub { is rur2words(653000000.00), "шестьсот пятьдесят три миллиона рублей 00 копеек"; };
	it "654000000.00" => sub { is rur2words(654000000.00), "шестьсот пятьдесят четыре миллиона рублей 00 копеек"; };
	it "655000000.00" => sub { is rur2words(655000000.00), "шестьсот пятьдесят пять миллионов рублей 00 копеек"; };
	it "656000000.00" => sub { is rur2words(656000000.00), "шестьсот пятьдесят шесть миллионов рублей 00 копеек"; };
	it "657000000.00" => sub { is rur2words(657000000.00), "шестьсот пятьдесят семь миллионов рублей 00 копеек"; };
	it "658000000.00" => sub { is rur2words(658000000.00), "шестьсот пятьдесят восемь миллионов рублей 00 копеек"; };
	it "659000000.00" => sub { is rur2words(659000000.00), "шестьсот пятьдесят девять миллионов рублей 00 копеек"; };
	it "660000000.00" => sub { is rur2words(660000000.00), "шестьсот шестьдесят миллионов рублей 00 копеек"; };
	it "661000000.00" => sub { is rur2words(661000000.00), "шестьсот шестьдесят один миллион рублей 00 копеек"; };
	it "662000000.00" => sub { is rur2words(662000000.00), "шестьсот шестьдесят два миллиона рублей 00 копеек"; };
	it "663000000.00" => sub { is rur2words(663000000.00), "шестьсот шестьдесят три миллиона рублей 00 копеек"; };
	it "664000000.00" => sub { is rur2words(664000000.00), "шестьсот шестьдесят четыре миллиона рублей 00 копеек"; };
	it "665000000.00" => sub { is rur2words(665000000.00), "шестьсот шестьдесят пять миллионов рублей 00 копеек"; };
	it "666000000.00" => sub { is rur2words(666000000.00), "шестьсот шестьдесят шесть миллионов рублей 00 копеек"; };
	it "667000000.00" => sub { is rur2words(667000000.00), "шестьсот шестьдесят семь миллионов рублей 00 копеек"; };
	it "668000000.00" => sub { is rur2words(668000000.00), "шестьсот шестьдесят восемь миллионов рублей 00 копеек"; };
	it "669000000.00" => sub { is rur2words(669000000.00), "шестьсот шестьдесят девять миллионов рублей 00 копеек"; };
	it "670000000.00" => sub { is rur2words(670000000.00), "шестьсот семьдесят миллионов рублей 00 копеек"; };
	it "671000000.00" => sub { is rur2words(671000000.00), "шестьсот семьдесят один миллион рублей 00 копеек"; };
	it "672000000.00" => sub { is rur2words(672000000.00), "шестьсот семьдесят два миллиона рублей 00 копеек"; };
	it "673000000.00" => sub { is rur2words(673000000.00), "шестьсот семьдесят три миллиона рублей 00 копеек"; };
	it "674000000.00" => sub { is rur2words(674000000.00), "шестьсот семьдесят четыре миллиона рублей 00 копеек"; };
	it "675000000.00" => sub { is rur2words(675000000.00), "шестьсот семьдесят пять миллионов рублей 00 копеек"; };
	it "676000000.00" => sub { is rur2words(676000000.00), "шестьсот семьдесят шесть миллионов рублей 00 копеек"; };
	it "677000000.00" => sub { is rur2words(677000000.00), "шестьсот семьдесят семь миллионов рублей 00 копеек"; };
	it "678000000.00" => sub { is rur2words(678000000.00), "шестьсот семьдесят восемь миллионов рублей 00 копеек"; };
	it "679000000.00" => sub { is rur2words(679000000.00), "шестьсот семьдесят девять миллионов рублей 00 копеек"; };
	it "680000000.00" => sub { is rur2words(680000000.00), "шестьсот восемьдесят миллионов рублей 00 копеек"; };
	it "681000000.00" => sub { is rur2words(681000000.00), "шестьсот восемьдесят один миллион рублей 00 копеек"; };
	it "682000000.00" => sub { is rur2words(682000000.00), "шестьсот восемьдесят два миллиона рублей 00 копеек"; };
	it "683000000.00" => sub { is rur2words(683000000.00), "шестьсот восемьдесят три миллиона рублей 00 копеек"; };
	it "684000000.00" => sub { is rur2words(684000000.00), "шестьсот восемьдесят четыре миллиона рублей 00 копеек"; };
	it "685000000.00" => sub { is rur2words(685000000.00), "шестьсот восемьдесят пять миллионов рублей 00 копеек"; };
	it "686000000.00" => sub { is rur2words(686000000.00), "шестьсот восемьдесят шесть миллионов рублей 00 копеек"; };
	it "687000000.00" => sub { is rur2words(687000000.00), "шестьсот восемьдесят семь миллионов рублей 00 копеек"; };
	it "688000000.00" => sub { is rur2words(688000000.00), "шестьсот восемьдесят восемь миллионов рублей 00 копеек"; };
	it "689000000.00" => sub { is rur2words(689000000.00), "шестьсот восемьдесят девять миллионов рублей 00 копеек"; };
	it "690000000.00" => sub { is rur2words(690000000.00), "шестьсот девяносто миллионов рублей 00 копеек"; };
	it "691000000.00" => sub { is rur2words(691000000.00), "шестьсот девяносто один миллион рублей 00 копеек"; };
	it "692000000.00" => sub { is rur2words(692000000.00), "шестьсот девяносто два миллиона рублей 00 копеек"; };
	it "693000000.00" => sub { is rur2words(693000000.00), "шестьсот девяносто три миллиона рублей 00 копеек"; };
	it "694000000.00" => sub { is rur2words(694000000.00), "шестьсот девяносто четыре миллиона рублей 00 копеек"; };
	it "695000000.00" => sub { is rur2words(695000000.00), "шестьсот девяносто пять миллионов рублей 00 копеек"; };
	it "696000000.00" => sub { is rur2words(696000000.00), "шестьсот девяносто шесть миллионов рублей 00 копеек"; };
	it "697000000.00" => sub { is rur2words(697000000.00), "шестьсот девяносто семь миллионов рублей 00 копеек"; };
	it "698000000.00" => sub { is rur2words(698000000.00), "шестьсот девяносто восемь миллионов рублей 00 копеек"; };
	it "699000000.00" => sub { is rur2words(699000000.00), "шестьсот девяносто девять миллионов рублей 00 копеек"; };
	it "700000000.00" => sub { is rur2words(700000000.00), "семьсот миллионов рублей 00 копеек"; };
	it "701000000.00" => sub { is rur2words(701000000.00), "семьсот один миллион рублей 00 копеек"; };
	it "702000000.00" => sub { is rur2words(702000000.00), "семьсот два миллиона рублей 00 копеек"; };
	it "703000000.00" => sub { is rur2words(703000000.00), "семьсот три миллиона рублей 00 копеек"; };
	it "704000000.00" => sub { is rur2words(704000000.00), "семьсот четыре миллиона рублей 00 копеек"; };
	it "705000000.00" => sub { is rur2words(705000000.00), "семьсот пять миллионов рублей 00 копеек"; };
	it "706000000.00" => sub { is rur2words(706000000.00), "семьсот шесть миллионов рублей 00 копеек"; };
	it "707000000.00" => sub { is rur2words(707000000.00), "семьсот семь миллионов рублей 00 копеек"; };
	it "708000000.00" => sub { is rur2words(708000000.00), "семьсот восемь миллионов рублей 00 копеек"; };
	it "709000000.00" => sub { is rur2words(709000000.00), "семьсот девять миллионов рублей 00 копеек"; };
	it "710000000.00" => sub { is rur2words(710000000.00), "семьсот десять миллионов рублей 00 копеек"; };
	it "711000000.00" => sub { is rur2words(711000000.00), "семьсот одиннадцать миллионов рублей 00 копеек"; };
	it "712000000.00" => sub { is rur2words(712000000.00), "семьсот двенадцать миллионов рублей 00 копеек"; };
	it "713000000.00" => sub { is rur2words(713000000.00), "семьсот тринадцать миллионов рублей 00 копеек"; };
	it "714000000.00" => sub { is rur2words(714000000.00), "семьсот четырнадцать миллионов рублей 00 копеек"; };
	it "715000000.00" => sub { is rur2words(715000000.00), "семьсот пятнадцать миллионов рублей 00 копеек"; };
	it "716000000.00" => sub { is rur2words(716000000.00), "семьсот шестнадцать миллионов рублей 00 копеек"; };
	it "717000000.00" => sub { is rur2words(717000000.00), "семьсот семнадцать миллионов рублей 00 копеек"; };
	it "718000000.00" => sub { is rur2words(718000000.00), "семьсот восемнадцать миллионов рублей 00 копеек"; };
	it "719000000.00" => sub { is rur2words(719000000.00), "семьсот девятнадцать миллионов рублей 00 копеек"; };
	it "720000000.00" => sub { is rur2words(720000000.00), "семьсот двадцать миллионов рублей 00 копеек"; };
	it "721000000.00" => sub { is rur2words(721000000.00), "семьсот двадцать один миллион рублей 00 копеек"; };
	it "722000000.00" => sub { is rur2words(722000000.00), "семьсот двадцать два миллиона рублей 00 копеек"; };
	it "723000000.00" => sub { is rur2words(723000000.00), "семьсот двадцать три миллиона рублей 00 копеек"; };
	it "724000000.00" => sub { is rur2words(724000000.00), "семьсот двадцать четыре миллиона рублей 00 копеек"; };
	it "725000000.00" => sub { is rur2words(725000000.00), "семьсот двадцать пять миллионов рублей 00 копеек"; };
	it "726000000.00" => sub { is rur2words(726000000.00), "семьсот двадцать шесть миллионов рублей 00 копеек"; };
	it "727000000.00" => sub { is rur2words(727000000.00), "семьсот двадцать семь миллионов рублей 00 копеек"; };
	it "728000000.00" => sub { is rur2words(728000000.00), "семьсот двадцать восемь миллионов рублей 00 копеек"; };
	it "729000000.00" => sub { is rur2words(729000000.00), "семьсот двадцать девять миллионов рублей 00 копеек"; };
	it "730000000.00" => sub { is rur2words(730000000.00), "семьсот тридцать миллионов рублей 00 копеек"; };
	it "731000000.00" => sub { is rur2words(731000000.00), "семьсот тридцать один миллион рублей 00 копеек"; };
	it "732000000.00" => sub { is rur2words(732000000.00), "семьсот тридцать два миллиона рублей 00 копеек"; };
	it "733000000.00" => sub { is rur2words(733000000.00), "семьсот тридцать три миллиона рублей 00 копеек"; };
	it "734000000.00" => sub { is rur2words(734000000.00), "семьсот тридцать четыре миллиона рублей 00 копеек"; };
	it "735000000.00" => sub { is rur2words(735000000.00), "семьсот тридцать пять миллионов рублей 00 копеек"; };
	it "736000000.00" => sub { is rur2words(736000000.00), "семьсот тридцать шесть миллионов рублей 00 копеек"; };
	it "737000000.00" => sub { is rur2words(737000000.00), "семьсот тридцать семь миллионов рублей 00 копеек"; };
	it "738000000.00" => sub { is rur2words(738000000.00), "семьсот тридцать восемь миллионов рублей 00 копеек"; };
	it "739000000.00" => sub { is rur2words(739000000.00), "семьсот тридцать девять миллионов рублей 00 копеек"; };
	it "740000000.00" => sub { is rur2words(740000000.00), "семьсот сорок миллионов рублей 00 копеек"; };
	it "741000000.00" => sub { is rur2words(741000000.00), "семьсот сорок один миллион рублей 00 копеек"; };
	it "742000000.00" => sub { is rur2words(742000000.00), "семьсот сорок два миллиона рублей 00 копеек"; };
	it "743000000.00" => sub { is rur2words(743000000.00), "семьсот сорок три миллиона рублей 00 копеек"; };
	it "744000000.00" => sub { is rur2words(744000000.00), "семьсот сорок четыре миллиона рублей 00 копеек"; };
	it "745000000.00" => sub { is rur2words(745000000.00), "семьсот сорок пять миллионов рублей 00 копеек"; };
	it "746000000.00" => sub { is rur2words(746000000.00), "семьсот сорок шесть миллионов рублей 00 копеек"; };
	it "747000000.00" => sub { is rur2words(747000000.00), "семьсот сорок семь миллионов рублей 00 копеек"; };
	it "748000000.00" => sub { is rur2words(748000000.00), "семьсот сорок восемь миллионов рублей 00 копеек"; };
	it "749000000.00" => sub { is rur2words(749000000.00), "семьсот сорок девять миллионов рублей 00 копеек"; };
	it "750000000.00" => sub { is rur2words(750000000.00), "семьсот пятьдесят миллионов рублей 00 копеек"; };
	it "751000000.00" => sub { is rur2words(751000000.00), "семьсот пятьдесят один миллион рублей 00 копеек"; };
	it "752000000.00" => sub { is rur2words(752000000.00), "семьсот пятьдесят два миллиона рублей 00 копеек"; };
	it "753000000.00" => sub { is rur2words(753000000.00), "семьсот пятьдесят три миллиона рублей 00 копеек"; };
	it "754000000.00" => sub { is rur2words(754000000.00), "семьсот пятьдесят четыре миллиона рублей 00 копеек"; };
	it "755000000.00" => sub { is rur2words(755000000.00), "семьсот пятьдесят пять миллионов рублей 00 копеек"; };
	it "756000000.00" => sub { is rur2words(756000000.00), "семьсот пятьдесят шесть миллионов рублей 00 копеек"; };
	it "757000000.00" => sub { is rur2words(757000000.00), "семьсот пятьдесят семь миллионов рублей 00 копеек"; };
	it "758000000.00" => sub { is rur2words(758000000.00), "семьсот пятьдесят восемь миллионов рублей 00 копеек"; };
	it "759000000.00" => sub { is rur2words(759000000.00), "семьсот пятьдесят девять миллионов рублей 00 копеек"; };
	it "760000000.00" => sub { is rur2words(760000000.00), "семьсот шестьдесят миллионов рублей 00 копеек"; };
	it "761000000.00" => sub { is rur2words(761000000.00), "семьсот шестьдесят один миллион рублей 00 копеек"; };
	it "762000000.00" => sub { is rur2words(762000000.00), "семьсот шестьдесят два миллиона рублей 00 копеек"; };
	it "763000000.00" => sub { is rur2words(763000000.00), "семьсот шестьдесят три миллиона рублей 00 копеек"; };
	it "764000000.00" => sub { is rur2words(764000000.00), "семьсот шестьдесят четыре миллиона рублей 00 копеек"; };
	it "765000000.00" => sub { is rur2words(765000000.00), "семьсот шестьдесят пять миллионов рублей 00 копеек"; };
	it "766000000.00" => sub { is rur2words(766000000.00), "семьсот шестьдесят шесть миллионов рублей 00 копеек"; };
	it "767000000.00" => sub { is rur2words(767000000.00), "семьсот шестьдесят семь миллионов рублей 00 копеек"; };
	it "768000000.00" => sub { is rur2words(768000000.00), "семьсот шестьдесят восемь миллионов рублей 00 копеек"; };
	it "769000000.00" => sub { is rur2words(769000000.00), "семьсот шестьдесят девять миллионов рублей 00 копеек"; };
	it "770000000.00" => sub { is rur2words(770000000.00), "семьсот семьдесят миллионов рублей 00 копеек"; };
	it "771000000.00" => sub { is rur2words(771000000.00), "семьсот семьдесят один миллион рублей 00 копеек"; };
	it "772000000.00" => sub { is rur2words(772000000.00), "семьсот семьдесят два миллиона рублей 00 копеек"; };
	it "773000000.00" => sub { is rur2words(773000000.00), "семьсот семьдесят три миллиона рублей 00 копеек"; };
	it "774000000.00" => sub { is rur2words(774000000.00), "семьсот семьдесят четыре миллиона рублей 00 копеек"; };
	it "775000000.00" => sub { is rur2words(775000000.00), "семьсот семьдесят пять миллионов рублей 00 копеек"; };
	it "776000000.00" => sub { is rur2words(776000000.00), "семьсот семьдесят шесть миллионов рублей 00 копеек"; };
	it "777000000.00" => sub { is rur2words(777000000.00), "семьсот семьдесят семь миллионов рублей 00 копеек"; };
	it "778000000.00" => sub { is rur2words(778000000.00), "семьсот семьдесят восемь миллионов рублей 00 копеек"; };
	it "779000000.00" => sub { is rur2words(779000000.00), "семьсот семьдесят девять миллионов рублей 00 копеек"; };
	it "780000000.00" => sub { is rur2words(780000000.00), "семьсот восемьдесят миллионов рублей 00 копеек"; };
	it "781000000.00" => sub { is rur2words(781000000.00), "семьсот восемьдесят один миллион рублей 00 копеек"; };
	it "782000000.00" => sub { is rur2words(782000000.00), "семьсот восемьдесят два миллиона рублей 00 копеек"; };
	it "783000000.00" => sub { is rur2words(783000000.00), "семьсот восемьдесят три миллиона рублей 00 копеек"; };
	it "784000000.00" => sub { is rur2words(784000000.00), "семьсот восемьдесят четыре миллиона рублей 00 копеек"; };
	it "785000000.00" => sub { is rur2words(785000000.00), "семьсот восемьдесят пять миллионов рублей 00 копеек"; };
	it "786000000.00" => sub { is rur2words(786000000.00), "семьсот восемьдесят шесть миллионов рублей 00 копеек"; };
	it "787000000.00" => sub { is rur2words(787000000.00), "семьсот восемьдесят семь миллионов рублей 00 копеек"; };
	it "788000000.00" => sub { is rur2words(788000000.00), "семьсот восемьдесят восемь миллионов рублей 00 копеек"; };
	it "789000000.00" => sub { is rur2words(789000000.00), "семьсот восемьдесят девять миллионов рублей 00 копеек"; };
	it "790000000.00" => sub { is rur2words(790000000.00), "семьсот девяносто миллионов рублей 00 копеек"; };
	it "791000000.00" => sub { is rur2words(791000000.00), "семьсот девяносто один миллион рублей 00 копеек"; };
	it "792000000.00" => sub { is rur2words(792000000.00), "семьсот девяносто два миллиона рублей 00 копеек"; };
	it "793000000.00" => sub { is rur2words(793000000.00), "семьсот девяносто три миллиона рублей 00 копеек"; };
	it "794000000.00" => sub { is rur2words(794000000.00), "семьсот девяносто четыре миллиона рублей 00 копеек"; };
	it "795000000.00" => sub { is rur2words(795000000.00), "семьсот девяносто пять миллионов рублей 00 копеек"; };
	it "796000000.00" => sub { is rur2words(796000000.00), "семьсот девяносто шесть миллионов рублей 00 копеек"; };
	it "797000000.00" => sub { is rur2words(797000000.00), "семьсот девяносто семь миллионов рублей 00 копеек"; };
	it "798000000.00" => sub { is rur2words(798000000.00), "семьсот девяносто восемь миллионов рублей 00 копеек"; };
	it "799000000.00" => sub { is rur2words(799000000.00), "семьсот девяносто девять миллионов рублей 00 копеек"; };
	it "800000000.00" => sub { is rur2words(800000000.00), "восемьсот миллионов рублей 00 копеек"; };
	it "801000000.00" => sub { is rur2words(801000000.00), "восемьсот один миллион рублей 00 копеек"; };
	it "802000000.00" => sub { is rur2words(802000000.00), "восемьсот два миллиона рублей 00 копеек"; };
	it "803000000.00" => sub { is rur2words(803000000.00), "восемьсот три миллиона рублей 00 копеек"; };
	it "804000000.00" => sub { is rur2words(804000000.00), "восемьсот четыре миллиона рублей 00 копеек"; };
	it "805000000.00" => sub { is rur2words(805000000.00), "восемьсот пять миллионов рублей 00 копеек"; };
	it "806000000.00" => sub { is rur2words(806000000.00), "восемьсот шесть миллионов рублей 00 копеек"; };
	it "807000000.00" => sub { is rur2words(807000000.00), "восемьсот семь миллионов рублей 00 копеек"; };
	it "808000000.00" => sub { is rur2words(808000000.00), "восемьсот восемь миллионов рублей 00 копеек"; };
	it "809000000.00" => sub { is rur2words(809000000.00), "восемьсот девять миллионов рублей 00 копеек"; };
	it "810000000.00" => sub { is rur2words(810000000.00), "восемьсот десять миллионов рублей 00 копеек"; };
	it "811000000.00" => sub { is rur2words(811000000.00), "восемьсот одиннадцать миллионов рублей 00 копеек"; };
	it "812000000.00" => sub { is rur2words(812000000.00), "восемьсот двенадцать миллионов рублей 00 копеек"; };
	it "813000000.00" => sub { is rur2words(813000000.00), "восемьсот тринадцать миллионов рублей 00 копеек"; };
	it "814000000.00" => sub { is rur2words(814000000.00), "восемьсот четырнадцать миллионов рублей 00 копеек"; };
	it "815000000.00" => sub { is rur2words(815000000.00), "восемьсот пятнадцать миллионов рублей 00 копеек"; };
	it "816000000.00" => sub { is rur2words(816000000.00), "восемьсот шестнадцать миллионов рублей 00 копеек"; };
	it "817000000.00" => sub { is rur2words(817000000.00), "восемьсот семнадцать миллионов рублей 00 копеек"; };
	it "818000000.00" => sub { is rur2words(818000000.00), "восемьсот восемнадцать миллионов рублей 00 копеек"; };
	it "819000000.00" => sub { is rur2words(819000000.00), "восемьсот девятнадцать миллионов рублей 00 копеек"; };
	it "820000000.00" => sub { is rur2words(820000000.00), "восемьсот двадцать миллионов рублей 00 копеек"; };
	it "821000000.00" => sub { is rur2words(821000000.00), "восемьсот двадцать один миллион рублей 00 копеек"; };
	it "822000000.00" => sub { is rur2words(822000000.00), "восемьсот двадцать два миллиона рублей 00 копеек"; };
	it "823000000.00" => sub { is rur2words(823000000.00), "восемьсот двадцать три миллиона рублей 00 копеек"; };
	it "824000000.00" => sub { is rur2words(824000000.00), "восемьсот двадцать четыре миллиона рублей 00 копеек"; };
	it "825000000.00" => sub { is rur2words(825000000.00), "восемьсот двадцать пять миллионов рублей 00 копеек"; };
	it "826000000.00" => sub { is rur2words(826000000.00), "восемьсот двадцать шесть миллионов рублей 00 копеек"; };
	it "827000000.00" => sub { is rur2words(827000000.00), "восемьсот двадцать семь миллионов рублей 00 копеек"; };
	it "828000000.00" => sub { is rur2words(828000000.00), "восемьсот двадцать восемь миллионов рублей 00 копеек"; };
	it "829000000.00" => sub { is rur2words(829000000.00), "восемьсот двадцать девять миллионов рублей 00 копеек"; };
	it "830000000.00" => sub { is rur2words(830000000.00), "восемьсот тридцать миллионов рублей 00 копеек"; };
	it "831000000.00" => sub { is rur2words(831000000.00), "восемьсот тридцать один миллион рублей 00 копеек"; };
	it "832000000.00" => sub { is rur2words(832000000.00), "восемьсот тридцать два миллиона рублей 00 копеек"; };
	it "833000000.00" => sub { is rur2words(833000000.00), "восемьсот тридцать три миллиона рублей 00 копеек"; };
	it "834000000.00" => sub { is rur2words(834000000.00), "восемьсот тридцать четыре миллиона рублей 00 копеек"; };
	it "835000000.00" => sub { is rur2words(835000000.00), "восемьсот тридцать пять миллионов рублей 00 копеек"; };
	it "836000000.00" => sub { is rur2words(836000000.00), "восемьсот тридцать шесть миллионов рублей 00 копеек"; };
	it "837000000.00" => sub { is rur2words(837000000.00), "восемьсот тридцать семь миллионов рублей 00 копеек"; };
	it "838000000.00" => sub { is rur2words(838000000.00), "восемьсот тридцать восемь миллионов рублей 00 копеек"; };
	it "839000000.00" => sub { is rur2words(839000000.00), "восемьсот тридцать девять миллионов рублей 00 копеек"; };
	it "840000000.00" => sub { is rur2words(840000000.00), "восемьсот сорок миллионов рублей 00 копеек"; };
	it "841000000.00" => sub { is rur2words(841000000.00), "восемьсот сорок один миллион рублей 00 копеек"; };
	it "842000000.00" => sub { is rur2words(842000000.00), "восемьсот сорок два миллиона рублей 00 копеек"; };
	it "843000000.00" => sub { is rur2words(843000000.00), "восемьсот сорок три миллиона рублей 00 копеек"; };
	it "844000000.00" => sub { is rur2words(844000000.00), "восемьсот сорок четыре миллиона рублей 00 копеек"; };
	it "845000000.00" => sub { is rur2words(845000000.00), "восемьсот сорок пять миллионов рублей 00 копеек"; };
	it "846000000.00" => sub { is rur2words(846000000.00), "восемьсот сорок шесть миллионов рублей 00 копеек"; };
	it "847000000.00" => sub { is rur2words(847000000.00), "восемьсот сорок семь миллионов рублей 00 копеек"; };
	it "848000000.00" => sub { is rur2words(848000000.00), "восемьсот сорок восемь миллионов рублей 00 копеек"; };
	it "849000000.00" => sub { is rur2words(849000000.00), "восемьсот сорок девять миллионов рублей 00 копеек"; };
	it "850000000.00" => sub { is rur2words(850000000.00), "восемьсот пятьдесят миллионов рублей 00 копеек"; };
	it "851000000.00" => sub { is rur2words(851000000.00), "восемьсот пятьдесят один миллион рублей 00 копеек"; };
	it "852000000.00" => sub { is rur2words(852000000.00), "восемьсот пятьдесят два миллиона рублей 00 копеек"; };
	it "853000000.00" => sub { is rur2words(853000000.00), "восемьсот пятьдесят три миллиона рублей 00 копеек"; };
	it "854000000.00" => sub { is rur2words(854000000.00), "восемьсот пятьдесят четыре миллиона рублей 00 копеек"; };
	it "855000000.00" => sub { is rur2words(855000000.00), "восемьсот пятьдесят пять миллионов рублей 00 копеек"; };
	it "856000000.00" => sub { is rur2words(856000000.00), "восемьсот пятьдесят шесть миллионов рублей 00 копеек"; };
	it "857000000.00" => sub { is rur2words(857000000.00), "восемьсот пятьдесят семь миллионов рублей 00 копеек"; };
	it "858000000.00" => sub { is rur2words(858000000.00), "восемьсот пятьдесят восемь миллионов рублей 00 копеек"; };
	it "859000000.00" => sub { is rur2words(859000000.00), "восемьсот пятьдесят девять миллионов рублей 00 копеек"; };
	it "860000000.00" => sub { is rur2words(860000000.00), "восемьсот шестьдесят миллионов рублей 00 копеек"; };
	it "861000000.00" => sub { is rur2words(861000000.00), "восемьсот шестьдесят один миллион рублей 00 копеек"; };
	it "862000000.00" => sub { is rur2words(862000000.00), "восемьсот шестьдесят два миллиона рублей 00 копеек"; };
	it "863000000.00" => sub { is rur2words(863000000.00), "восемьсот шестьдесят три миллиона рублей 00 копеек"; };
	it "864000000.00" => sub { is rur2words(864000000.00), "восемьсот шестьдесят четыре миллиона рублей 00 копеек"; };
	it "865000000.00" => sub { is rur2words(865000000.00), "восемьсот шестьдесят пять миллионов рублей 00 копеек"; };
	it "866000000.00" => sub { is rur2words(866000000.00), "восемьсот шестьдесят шесть миллионов рублей 00 копеек"; };
	it "867000000.00" => sub { is rur2words(867000000.00), "восемьсот шестьдесят семь миллионов рублей 00 копеек"; };
	it "868000000.00" => sub { is rur2words(868000000.00), "восемьсот шестьдесят восемь миллионов рублей 00 копеек"; };
	it "869000000.00" => sub { is rur2words(869000000.00), "восемьсот шестьдесят девять миллионов рублей 00 копеек"; };
	it "870000000.00" => sub { is rur2words(870000000.00), "восемьсот семьдесят миллионов рублей 00 копеек"; };
	it "871000000.00" => sub { is rur2words(871000000.00), "восемьсот семьдесят один миллион рублей 00 копеек"; };
	it "872000000.00" => sub { is rur2words(872000000.00), "восемьсот семьдесят два миллиона рублей 00 копеек"; };
	it "873000000.00" => sub { is rur2words(873000000.00), "восемьсот семьдесят три миллиона рублей 00 копеек"; };
	it "874000000.00" => sub { is rur2words(874000000.00), "восемьсот семьдесят четыре миллиона рублей 00 копеек"; };
	it "875000000.00" => sub { is rur2words(875000000.00), "восемьсот семьдесят пять миллионов рублей 00 копеек"; };
	it "876000000.00" => sub { is rur2words(876000000.00), "восемьсот семьдесят шесть миллионов рублей 00 копеек"; };
	it "877000000.00" => sub { is rur2words(877000000.00), "восемьсот семьдесят семь миллионов рублей 00 копеек"; };
	it "878000000.00" => sub { is rur2words(878000000.00), "восемьсот семьдесят восемь миллионов рублей 00 копеек"; };
	it "879000000.00" => sub { is rur2words(879000000.00), "восемьсот семьдесят девять миллионов рублей 00 копеек"; };
	it "880000000.00" => sub { is rur2words(880000000.00), "восемьсот восемьдесят миллионов рублей 00 копеек"; };
	it "881000000.00" => sub { is rur2words(881000000.00), "восемьсот восемьдесят один миллион рублей 00 копеек"; };
	it "882000000.00" => sub { is rur2words(882000000.00), "восемьсот восемьдесят два миллиона рублей 00 копеек"; };
	it "883000000.00" => sub { is rur2words(883000000.00), "восемьсот восемьдесят три миллиона рублей 00 копеек"; };
	it "884000000.00" => sub { is rur2words(884000000.00), "восемьсот восемьдесят четыре миллиона рублей 00 копеек"; };
	it "885000000.00" => sub { is rur2words(885000000.00), "восемьсот восемьдесят пять миллионов рублей 00 копеек"; };
	it "886000000.00" => sub { is rur2words(886000000.00), "восемьсот восемьдесят шесть миллионов рублей 00 копеек"; };
	it "887000000.00" => sub { is rur2words(887000000.00), "восемьсот восемьдесят семь миллионов рублей 00 копеек"; };
	it "888000000.00" => sub { is rur2words(888000000.00), "восемьсот восемьдесят восемь миллионов рублей 00 копеек"; };
	it "889000000.00" => sub { is rur2words(889000000.00), "восемьсот восемьдесят девять миллионов рублей 00 копеек"; };
	it "890000000.00" => sub { is rur2words(890000000.00), "восемьсот девяносто миллионов рублей 00 копеек"; };
	it "891000000.00" => sub { is rur2words(891000000.00), "восемьсот девяносто один миллион рублей 00 копеек"; };
	it "892000000.00" => sub { is rur2words(892000000.00), "восемьсот девяносто два миллиона рублей 00 копеек"; };
	it "893000000.00" => sub { is rur2words(893000000.00), "восемьсот девяносто три миллиона рублей 00 копеек"; };
	it "894000000.00" => sub { is rur2words(894000000.00), "восемьсот девяносто четыре миллиона рублей 00 копеек"; };
	it "895000000.00" => sub { is rur2words(895000000.00), "восемьсот девяносто пять миллионов рублей 00 копеек"; };
	it "896000000.00" => sub { is rur2words(896000000.00), "восемьсот девяносто шесть миллионов рублей 00 копеек"; };
	it "897000000.00" => sub { is rur2words(897000000.00), "восемьсот девяносто семь миллионов рублей 00 копеек"; };
	it "898000000.00" => sub { is rur2words(898000000.00), "восемьсот девяносто восемь миллионов рублей 00 копеек"; };
	it "899000000.00" => sub { is rur2words(899000000.00), "восемьсот девяносто девять миллионов рублей 00 копеек"; };
	it "900000000.00" => sub { is rur2words(900000000.00), "девятьсот миллионов рублей 00 копеек"; };
	it "901000000.00" => sub { is rur2words(901000000.00), "девятьсот один миллион рублей 00 копеек"; };
	it "902000000.00" => sub { is rur2words(902000000.00), "девятьсот два миллиона рублей 00 копеек"; };
	it "903000000.00" => sub { is rur2words(903000000.00), "девятьсот три миллиона рублей 00 копеек"; };
	it "904000000.00" => sub { is rur2words(904000000.00), "девятьсот четыре миллиона рублей 00 копеек"; };
	it "905000000.00" => sub { is rur2words(905000000.00), "девятьсот пять миллионов рублей 00 копеек"; };
	it "906000000.00" => sub { is rur2words(906000000.00), "девятьсот шесть миллионов рублей 00 копеек"; };
	it "907000000.00" => sub { is rur2words(907000000.00), "девятьсот семь миллионов рублей 00 копеек"; };
	it "908000000.00" => sub { is rur2words(908000000.00), "девятьсот восемь миллионов рублей 00 копеек"; };
	it "909000000.00" => sub { is rur2words(909000000.00), "девятьсот девять миллионов рублей 00 копеек"; };
	it "910000000.00" => sub { is rur2words(910000000.00), "девятьсот десять миллионов рублей 00 копеек"; };
	it "911000000.00" => sub { is rur2words(911000000.00), "девятьсот одиннадцать миллионов рублей 00 копеек"; };
	it "912000000.00" => sub { is rur2words(912000000.00), "девятьсот двенадцать миллионов рублей 00 копеек"; };
	it "913000000.00" => sub { is rur2words(913000000.00), "девятьсот тринадцать миллионов рублей 00 копеек"; };
	it "914000000.00" => sub { is rur2words(914000000.00), "девятьсот четырнадцать миллионов рублей 00 копеек"; };
	it "915000000.00" => sub { is rur2words(915000000.00), "девятьсот пятнадцать миллионов рублей 00 копеек"; };
	it "916000000.00" => sub { is rur2words(916000000.00), "девятьсот шестнадцать миллионов рублей 00 копеек"; };
	it "917000000.00" => sub { is rur2words(917000000.00), "девятьсот семнадцать миллионов рублей 00 копеек"; };
	it "918000000.00" => sub { is rur2words(918000000.00), "девятьсот восемнадцать миллионов рублей 00 копеек"; };
	it "919000000.00" => sub { is rur2words(919000000.00), "девятьсот девятнадцать миллионов рублей 00 копеек"; };
	it "920000000.00" => sub { is rur2words(920000000.00), "девятьсот двадцать миллионов рублей 00 копеек"; };
	it "921000000.00" => sub { is rur2words(921000000.00), "девятьсот двадцать один миллион рублей 00 копеек"; };
	it "922000000.00" => sub { is rur2words(922000000.00), "девятьсот двадцать два миллиона рублей 00 копеек"; };
	it "923000000.00" => sub { is rur2words(923000000.00), "девятьсот двадцать три миллиона рублей 00 копеек"; };
	it "924000000.00" => sub { is rur2words(924000000.00), "девятьсот двадцать четыре миллиона рублей 00 копеек"; };
	it "925000000.00" => sub { is rur2words(925000000.00), "девятьсот двадцать пять миллионов рублей 00 копеек"; };
	it "926000000.00" => sub { is rur2words(926000000.00), "девятьсот двадцать шесть миллионов рублей 00 копеек"; };
	it "927000000.00" => sub { is rur2words(927000000.00), "девятьсот двадцать семь миллионов рублей 00 копеек"; };
	it "928000000.00" => sub { is rur2words(928000000.00), "девятьсот двадцать восемь миллионов рублей 00 копеек"; };
	it "929000000.00" => sub { is rur2words(929000000.00), "девятьсот двадцать девять миллионов рублей 00 копеек"; };
	it "930000000.00" => sub { is rur2words(930000000.00), "девятьсот тридцать миллионов рублей 00 копеек"; };
	it "931000000.00" => sub { is rur2words(931000000.00), "девятьсот тридцать один миллион рублей 00 копеек"; };
	it "932000000.00" => sub { is rur2words(932000000.00), "девятьсот тридцать два миллиона рублей 00 копеек"; };
	it "933000000.00" => sub { is rur2words(933000000.00), "девятьсот тридцать три миллиона рублей 00 копеек"; };
	it "934000000.00" => sub { is rur2words(934000000.00), "девятьсот тридцать четыре миллиона рублей 00 копеек"; };
	it "935000000.00" => sub { is rur2words(935000000.00), "девятьсот тридцать пять миллионов рублей 00 копеек"; };
	it "936000000.00" => sub { is rur2words(936000000.00), "девятьсот тридцать шесть миллионов рублей 00 копеек"; };
	it "937000000.00" => sub { is rur2words(937000000.00), "девятьсот тридцать семь миллионов рублей 00 копеек"; };
	it "938000000.00" => sub { is rur2words(938000000.00), "девятьсот тридцать восемь миллионов рублей 00 копеек"; };
	it "939000000.00" => sub { is rur2words(939000000.00), "девятьсот тридцать девять миллионов рублей 00 копеек"; };
	it "940000000.00" => sub { is rur2words(940000000.00), "девятьсот сорок миллионов рублей 00 копеек"; };
	it "941000000.00" => sub { is rur2words(941000000.00), "девятьсот сорок один миллион рублей 00 копеек"; };
	it "942000000.00" => sub { is rur2words(942000000.00), "девятьсот сорок два миллиона рублей 00 копеек"; };
	it "943000000.00" => sub { is rur2words(943000000.00), "девятьсот сорок три миллиона рублей 00 копеек"; };
	it "944000000.00" => sub { is rur2words(944000000.00), "девятьсот сорок четыре миллиона рублей 00 копеек"; };
	it "945000000.00" => sub { is rur2words(945000000.00), "девятьсот сорок пять миллионов рублей 00 копеек"; };
	it "946000000.00" => sub { is rur2words(946000000.00), "девятьсот сорок шесть миллионов рублей 00 копеек"; };
	it "947000000.00" => sub { is rur2words(947000000.00), "девятьсот сорок семь миллионов рублей 00 копеек"; };
	it "948000000.00" => sub { is rur2words(948000000.00), "девятьсот сорок восемь миллионов рублей 00 копеек"; };
	it "949000000.00" => sub { is rur2words(949000000.00), "девятьсот сорок девять миллионов рублей 00 копеек"; };
	it "950000000.00" => sub { is rur2words(950000000.00), "девятьсот пятьдесят миллионов рублей 00 копеек"; };
	it "951000000.00" => sub { is rur2words(951000000.00), "девятьсот пятьдесят один миллион рублей 00 копеек"; };
	it "952000000.00" => sub { is rur2words(952000000.00), "девятьсот пятьдесят два миллиона рублей 00 копеек"; };
	it "953000000.00" => sub { is rur2words(953000000.00), "девятьсот пятьдесят три миллиона рублей 00 копеек"; };
	it "954000000.00" => sub { is rur2words(954000000.00), "девятьсот пятьдесят четыре миллиона рублей 00 копеек"; };
	it "955000000.00" => sub { is rur2words(955000000.00), "девятьсот пятьдесят пять миллионов рублей 00 копеек"; };
	it "956000000.00" => sub { is rur2words(956000000.00), "девятьсот пятьдесят шесть миллионов рублей 00 копеек"; };
	it "957000000.00" => sub { is rur2words(957000000.00), "девятьсот пятьдесят семь миллионов рублей 00 копеек"; };
	it "958000000.00" => sub { is rur2words(958000000.00), "девятьсот пятьдесят восемь миллионов рублей 00 копеек"; };
	it "959000000.00" => sub { is rur2words(959000000.00), "девятьсот пятьдесят девять миллионов рублей 00 копеек"; };
	it "960000000.00" => sub { is rur2words(960000000.00), "девятьсот шестьдесят миллионов рублей 00 копеек"; };
	it "961000000.00" => sub { is rur2words(961000000.00), "девятьсот шестьдесят один миллион рублей 00 копеек"; };
	it "962000000.00" => sub { is rur2words(962000000.00), "девятьсот шестьдесят два миллиона рублей 00 копеек"; };
	it "963000000.00" => sub { is rur2words(963000000.00), "девятьсот шестьдесят три миллиона рублей 00 копеек"; };
	it "964000000.00" => sub { is rur2words(964000000.00), "девятьсот шестьдесят четыре миллиона рублей 00 копеек"; };
	it "965000000.00" => sub { is rur2words(965000000.00), "девятьсот шестьдесят пять миллионов рублей 00 копеек"; };
	it "966000000.00" => sub { is rur2words(966000000.00), "девятьсот шестьдесят шесть миллионов рублей 00 копеек"; };
	it "967000000.00" => sub { is rur2words(967000000.00), "девятьсот шестьдесят семь миллионов рублей 00 копеек"; };
	it "968000000.00" => sub { is rur2words(968000000.00), "девятьсот шестьдесят восемь миллионов рублей 00 копеек"; };
	it "969000000.00" => sub { is rur2words(969000000.00), "девятьсот шестьдесят девять миллионов рублей 00 копеек"; };
	it "970000000.00" => sub { is rur2words(970000000.00), "девятьсот семьдесят миллионов рублей 00 копеек"; };
	it "971000000.00" => sub { is rur2words(971000000.00), "девятьсот семьдесят один миллион рублей 00 копеек"; };
	it "972000000.00" => sub { is rur2words(972000000.00), "девятьсот семьдесят два миллиона рублей 00 копеек"; };
	it "973000000.00" => sub { is rur2words(973000000.00), "девятьсот семьдесят три миллиона рублей 00 копеек"; };
	it "974000000.00" => sub { is rur2words(974000000.00), "девятьсот семьдесят четыре миллиона рублей 00 копеек"; };
	it "975000000.00" => sub { is rur2words(975000000.00), "девятьсот семьдесят пять миллионов рублей 00 копеек"; };
	it "976000000.00" => sub { is rur2words(976000000.00), "девятьсот семьдесят шесть миллионов рублей 00 копеек"; };
	it "977000000.00" => sub { is rur2words(977000000.00), "девятьсот семьдесят семь миллионов рублей 00 копеек"; };
	it "978000000.00" => sub { is rur2words(978000000.00), "девятьсот семьдесят восемь миллионов рублей 00 копеек"; };
	it "979000000.00" => sub { is rur2words(979000000.00), "девятьсот семьдесят девять миллионов рублей 00 копеек"; };
	it "980000000.00" => sub { is rur2words(980000000.00), "девятьсот восемьдесят миллионов рублей 00 копеек"; };
	it "981000000.00" => sub { is rur2words(981000000.00), "девятьсот восемьдесят один миллион рублей 00 копеек"; };
	it "982000000.00" => sub { is rur2words(982000000.00), "девятьсот восемьдесят два миллиона рублей 00 копеек"; };
	it "983000000.00" => sub { is rur2words(983000000.00), "девятьсот восемьдесят три миллиона рублей 00 копеек"; };
	it "984000000.00" => sub { is rur2words(984000000.00), "девятьсот восемьдесят четыре миллиона рублей 00 копеек"; };
	it "985000000.00" => sub { is rur2words(985000000.00), "девятьсот восемьдесят пять миллионов рублей 00 копеек"; };
	it "986000000.00" => sub { is rur2words(986000000.00), "девятьсот восемьдесят шесть миллионов рублей 00 копеек"; };
	it "987000000.00" => sub { is rur2words(987000000.00), "девятьсот восемьдесят семь миллионов рублей 00 копеек"; };
	it "988000000.00" => sub { is rur2words(988000000.00), "девятьсот восемьдесят восемь миллионов рублей 00 копеек"; };
	it "989000000.00" => sub { is rur2words(989000000.00), "девятьсот восемьдесят девять миллионов рублей 00 копеек"; };
	it "990000000.00" => sub { is rur2words(990000000.00), "девятьсот девяносто миллионов рублей 00 копеек"; };
	it "991000000.00" => sub { is rur2words(991000000.00), "девятьсот девяносто один миллион рублей 00 копеек"; };
	it "992000000.00" => sub { is rur2words(992000000.00), "девятьсот девяносто два миллиона рублей 00 копеек"; };
	it "993000000.00" => sub { is rur2words(993000000.00), "девятьсот девяносто три миллиона рублей 00 копеек"; };
	it "994000000.00" => sub { is rur2words(994000000.00), "девятьсот девяносто четыре миллиона рублей 00 копеек"; };
	it "995000000.00" => sub { is rur2words(995000000.00), "девятьсот девяносто пять миллионов рублей 00 копеек"; };
	it "996000000.00" => sub { is rur2words(996000000.00), "девятьсот девяносто шесть миллионов рублей 00 копеек"; };
	it "997000000.00" => sub { is rur2words(997000000.00), "девятьсот девяносто семь миллионов рублей 00 копеек"; };
	it "998000000.00" => sub { is rur2words(998000000.00), "девятьсот девяносто восемь миллионов рублей 00 копеек"; };
	it "999000000.00" => sub { is rur2words(999000000.00), "девятьсот девяносто девять миллионов рублей 00 копеек"; };
};

runtests unless caller;
