# Generated by default/object.tt
package Paws::HealthLake::ExportJobProperties;
  use Moose;
  has DataAccessRoleArn => (is => 'ro', isa => 'Str');
  has DatastoreId => (is => 'ro', isa => 'Str', required => 1);
  has EndTime => (is => 'ro', isa => 'Str');
  has JobId => (is => 'ro', isa => 'Str', required => 1);
  has JobName => (is => 'ro', isa => 'Str');
  has JobStatus => (is => 'ro', isa => 'Str', required => 1);
  has Message => (is => 'ro', isa => 'Str');
  has OutputDataConfig => (is => 'ro', isa => 'Paws::HealthLake::OutputDataConfig', required => 1);
  has SubmitTime => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::HealthLake::ExportJobProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::HealthLake::ExportJobProperties object:

  $service_obj->Method(Att1 => { DataAccessRoleArn => $value, ..., SubmitTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::HealthLake::ExportJobProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->DataAccessRoleArn

=head1 DESCRIPTION

The properties of a FHIR export job, including the ID, ARN, name, and
the status of the job.

=head1 ATTRIBUTES


=head2 DataAccessRoleArn => Str

The Amazon Resource Name used during the initiation of the job.


=head2 B<REQUIRED> DatastoreId => Str

The AWS generated ID for the Data Store from which files are being
exported for an export job.


=head2 EndTime => Str

The time an export job completed.


=head2 B<REQUIRED> JobId => Str

The AWS generated ID for an export job.


=head2 JobName => Str

The user generated name for an export job.


=head2 B<REQUIRED> JobStatus => Str

The status of a FHIR export job. Possible statuses are SUBMITTED,
IN_PROGRESS, COMPLETED, or FAILED.


=head2 Message => Str

An explanation of any errors that may have occurred during the export
job.


=head2 B<REQUIRED> OutputDataConfig => L<Paws::HealthLake::OutputDataConfig>

The output data configuration that was supplied when the export job was
created.


=head2 B<REQUIRED> SubmitTime => Str

The time an export job was initiated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::HealthLake>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

