# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#
# This file was automatically built from t/io-compress.ttmpl
#
# Do not edit this file, instead edit the template and rebuild by running
# t/build-test-scripts
#
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# Check that IO::Callback inter-operates with IO::Compress::Gzip

use strict;
use warnings;

use Test::More;
BEGIN {
    eval 'use IO::Compress::Gzip qw/gzip/';
    plan skip_all => 'IO::Compress::Gzip required' if $@;

    eval 'use IO::Uncompress::Gunzip qw/gunzip/';
    plan skip_all => 'IO::Uncompress::Gunzip required' if $@;

    plan tests => 6;
}
use Test::NoWarnings;

use Fatal qw/close/;
use IO::Callback;

sub is_zipped ($$;$) {
    my ($zgot, $want, $comment) = @_;

    my $got;
    gunzip(\$zgot, \$got) or die "gunzip failed";
    is( $got, $want, $comment );
}

my $test_data = "foo\n" x 100;

my $lines = 0;
my $coderef_read_fh = IO::Callback->new('<', sub {
    return if $lines++ >= 100;
    return "foo\n";
});

my $compressed;
ok gzip($coderef_read_fh, \$compressed), "gzip from read coderef succeeded";
is_zipped $compressed, $test_data, "gzip from read coderef correct";

my $got_close = 0;
my $got_data = '';
my $coderef_write_fh = IO::Callback->new('>', sub {
    my $buf = shift;
    if (length $buf) {
        $got_close and die "write after close";
        $got_data .= $buf;
    } else {
        ++$got_close;
    }
});

ok gzip(\$test_data, $coderef_write_fh), "gzip to write coderef succeeded";
close $coderef_write_fh;
is $got_close, 1, "write fh got close";
is_zipped $got_data, $test_data, "gzip to write coderef correct";

