
package Google::Ads::AdWords::v201809::CustomAffinityService::mutateToken;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'https://adwords.google.com/api/adwords/rm/v201809' }

__PACKAGE__->__set_name('mutateToken');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    Google::Ads::SOAP::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %operations_of :ATTR(:get<operations>);

__PACKAGE__->_factory(
    [ qw(        operations

    ) ],
    {
        'operations' => \%operations_of,
    },
    {
        'operations' => 'Google::Ads::AdWords::v201809::CustomAffinityTokenOperation',
    },
    {

        'operations' => 'operations',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

Google::Ads::AdWords::v201809::CustomAffinityService::mutateToken

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
mutateToken from the namespace https://adwords.google.com/api/adwords/rm/v201809.

Applies a list of mutate operations (i.e. add, remove) to custom affinity tokens: <p> Add - creates a custom affinity token Set - set operation for custom affinity token is not supported Remove - deletes a custom affinity token @param operations the operations to apply @return a list of CustomAffinityToken objects 





=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * operations

 $element->set_operations($data);
 $element->get_operations();





=back


=head1 METHODS

=head2 new

 my $element = Google::Ads::AdWords::v201809::CustomAffinityService::mutateToken->new($data);

Constructor. The following data structure may be passed to new():

 {
   operations =>  $a_reference_to, # see Google::Ads::AdWords::v201809::CustomAffinityTokenOperation
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

