package Google::Ads::AdWords::v201806::CustomAffinity;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/rm/v201806' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %id_of :ATTR(:get<id>);
my %status_of :ATTR(:get<status>);
my %name_of :ATTR(:get<name>);
my %type_of :ATTR(:get<type>);
my %description_of :ATTR(:get<description>);
my %tokens_of :ATTR(:get<tokens>);

__PACKAGE__->_factory(
    [ qw(        id
        status
        name
        type
        description
        tokens

    ) ],
    {
        'id' => \%id_of,
        'status' => \%status_of,
        'name' => \%name_of,
        'type' => \%type_of,
        'description' => \%description_of,
        'tokens' => \%tokens_of,
    },
    {
        'id' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'status' => 'Google::Ads::AdWords::v201806::CustomAffinityStatus',
        'name' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'type' => 'Google::Ads::AdWords::v201806::CustomAffinityType',
        'description' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'tokens' => 'Google::Ads::AdWords::v201806::CustomAffinityToken',
    },
    {

        'id' => 'id',
        'status' => 'status',
        'name' => 'name',
        'type' => 'type',
        'description' => 'description',
        'tokens' => 'tokens',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201806::CustomAffinity

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CustomAffinity from the namespace https://adwords.google.com/api/adwords/rm/v201806.

Custom affinity audience defined by a collection of examples/hints. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * id


=item * status


=item * name


=item * type


=item * description


=item * tokens




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

