/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionWhile
implements Instruction {
    private final InstructionList repeatList = new InstructionList();
    private final Instruction parent;
    private final LinkRendering nextLinkRenderer;
    private final HtmlColor color;
    private final Display test;
    private final Display yes;
    private Display out;
    private LinkRendering endInlinkRendering;
    private LinkRendering afterEndwhile;
    private final Swimlane swimlane;

    public InstructionWhile(Swimlane swimlane, Instruction instruction, Display display, LinkRendering linkRendering, Display display2, HtmlColor htmlColor) {
        this.parent = instruction;
        this.test = display;
        this.nextLinkRenderer = linkRendering;
        this.yes = display2;
        this.swimlane = swimlane;
        this.color = htmlColor;
    }

    @Override
    public void add(Instruction instruction) {
        this.repeatList.add(instruction);
    }

    @Override
    public Ftile createFtile(FtileFactory ftileFactory) {
        Ftile ftile = ftileFactory.decorateOut(this.repeatList.createFtile(ftileFactory), this.endInlinkRendering);
        ftile = ftileFactory.createWhile(this.swimlane, ftile, this.test, this.yes, this.out, this.afterEndwhile, this.color);
        return ftile;
    }

    public Instruction getParent() {
        return this.parent;
    }

    @Override
    public final boolean kill() {
        return this.repeatList.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.nextLinkRenderer;
    }

    public void endwhile(LinkRendering linkRendering, Display display) {
        this.endInlinkRendering = linkRendering;
        this.out = display;
    }

    public void afterEndwhile(LinkRendering linkRendering) {
        this.afterEndwhile = linkRendering;
    }

    @Override
    public void addNote(Display display, NotePosition notePosition) {
        this.repeatList.addNote(display, notePosition);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.repeatList.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }
}

