use DateTime::Calendar::FrenchRevolutionary;
use DateTime;

my $n = 1;

sub g2r {
  my ($n, $date_r, $format, $y, $m, $d) = @_;
  my $date_g = DateTime->new(year => $y, month => $m, day => $d);
  my $date_resul = DateTime::Calendar::FrenchRevolutionary->from_object(object => $date_g)->strftime($format);
  if ($date_r eq $date_resul)
    { print "ok $n\n" }
  else
    { print "not ok $n : expected $date_r, got $date_resul\n" }
}


@tests = ([" 1 Vendmiaire I",            "%e %B %EY", 1792,  9, 22],
	  ["Jour des Rcompenses I",        "%EJ %EY", 1793,  9, 21],
	  [" 1 Vendmiaire II",           "%e %B %EY", 1793,  9, 22],
	  ["Jour des Rcompenses II",       "%EJ %EY", 1794,  9, 21],
	  [" 1 Vendmiaire III",          "%e %B %EY", 1794,  9, 22],
	  ["Jour de la Rvolution III",     "%EJ %EY", 1795,  9, 22],
	  [" 1 Vendmiaire IV",           "%e %B %EY", 1795,  9, 23],
	  ["Jour des Rcompenses IV",       "%EJ %EY", 1796,  9, 21],
	  [" 1 Vendmiaire V",            "%e %B %EY", 1796,  9, 22],
	  ["Jour des Rcompenses V",        "%EJ %EY", 1797,  9, 21],
	  [" 1 Vendmiaire VI",           "%e %B %EY", 1797,  9, 22],
	  ["Jour des Rcompenses VI",       "%EJ %EY", 1798,  9, 21],
	  [" 1 Vendmiaire VII",          "%e %B %EY", 1798,  9, 22],
	  ["Jour de la Rvolution VII",     "%EJ %EY", 1799,  9, 22],
	  [" 1 Vendmiaire VIII",         "%e %B %EY", 1799,  9, 23],
	  ["Jour des Rcompenses VIII",     "%EJ %EY", 1800,  9, 22],
	  [" 1 Vendmiaire IX",           "%e %B %EY", 1800,  9, 23],
	  ["Jour des Rcompenses IX",       "%EJ %EY", 1801,  9, 22],
	  [" 1 Vendmiaire X",            "%e %B %EY", 1801,  9, 23],
	  ["Jour des Rcompenses X",        "%EJ %EY", 1802,  9, 22],
	  [" 1 Vendmiaire LVI",          "%e %B %EY", 1847,  9, 23],
	  ["Jour de la Rvolution LVI",     "%EJ %EY", 1848,  9, 22],
	  [" 1 Vendmiaire LVII",         "%e %B %EY", 1848,  9, 23],
	  ["Jour des Rcompenses LVII",     "%EJ %EY", 1849,  9, 22],
	  [" 1 Vendmiaire LVIII",        "%e %B %EY", 1849,  9, 23],
	  ["Jour des Rcompenses LVIII",    "%EJ %EY", 1850,  9, 22],
	  [" 1 Vendmiaire C",            "%e %B %EY", 1891,  9, 23],
	  ["Jour des Rcompenses C",        "%EJ %EY", 1892,  9, 21],
	  [" 1 Vendmiaire CI",           "%e %B %EY", 1892,  9, 22],
	  ["Jour des Rcompenses CI",       "%EJ %EY", 1893,  9, 21],
	  [" 1 Vendmiaire CVIII",        "%e %B %EY", 1899,  9, 22],
	  ["Jour de la Rvolution CVIII",   "%EJ %EY", 1900,  9, 22],
	  [" 1 Vendmiaire CC",           "%e %B %EY", 1991,  9, 23],
	  ["Jour des Rcompenses CC",       "%EJ %EY", 1992,  9, 21],
	  [" 1 Vendmiaire CCI",          "%e %B %EY", 1992,  9, 22],
	  ["Jour des Rcompenses CCI",      "%EJ %EY", 1993,  9, 21],
	  [" 1 Vendmiaire CCVIII",       "%e %B %EY", 1999,  9, 22],
	  ["Jour de la Rvolution CCVIII",  "%EJ %EY", 2000,  9, 21],
	  [" 1 Vendmiaire CCC",          "%e %B %EY", 2091,  9, 22],
	  ["Jour des Rcompenses CCC",      "%EJ %EY", 2092,  9, 20],
	  [" 1 Vendmiaire CCCI",         "%e %B %EY", 2092,  9, 21],
	  ["Jour des Rcompenses CCCI",     "%EJ %EY", 2093,  9, 20],
	  [" 1 Vendmiaire CCCVIII",      "%e %B %EY", 2099,  9, 21],
	  ["Jour de la Rvolution CCCVIII", "%EJ %EY", 2100,  9, 21],
	  [" 1 Vendmiaire CD",           "%e %B %EY", 2191,  9, 22],
	  ["Jour de la Rvolution CD",      "%EJ %EY", 2192,  9, 21],
	  [" 1 Vendmiaire CDI",          "%e %B %EY", 2192,  9, 22],
	  ["Jour des Rcompenses CDI",      "%EJ %EY", 2193,  9, 21],
	  [" 1 Vendmiaire CDVIII",       "%e %B %EY", 2199,  9, 22],
	  ["Jour de la Rvolution CDVIII",  "%EJ %EY", 2200,  9, 22],
	  );

printf "1..%d\n", scalar @tests;

foreach (@tests) { g2r $n++, @$_ }
