# -*- mode: perl; -*-

use strict;
use warnings;

use Test::More tests => 1840;

use Math::BigFloat;

while (<DATA>) {
    s/#.*$//;                   # remove comments
    s/\s+$//;                   # remove trailing whitespace
    next unless length;         # skip empty lines

    my ($x_str, $mant_str, $expo_str) = split /:/;

    note(qq|\n\$x = Math::BigFloat -> new("$x_str");|,
         qq| (\$m, \$e) = \$x -> nparts();\n\n|);

    {
        my $x = Math::BigFloat -> new($x_str);
        my ($mant_got, $expo_got) = $x -> nparts();

        isa_ok($mant_got, "Math::BigFloat");
        isa_ok($expo_got, "Math::BigFloat");

        is($mant_got, $mant_str, "value of mantissa");
        is($expo_got, $expo_str, "value of exponent");
        is($x,        $x_str,    "input is unmodified");
    }

    note(qq|\n\$x = Math::BigFloat -> new("$x_str");|,
         qq| \$m = \$x -> nparts();\n\n|);

    {
        my $x = Math::BigFloat -> new($x_str);
        my $mant_got = $x -> nparts();

        isa_ok($mant_got, "Math::BigFloat");

        is($mant_got, $mant_str, "value of mantissa");
        is($x,        $x_str,    "input is unmodified");
    }

}

__DATA__

NaN:NaN:NaN

inf:inf:inf
-inf:-inf:inf

0:0:0

# positive numbers

0.000000000001:1:-12
0.00000000001:1:-11
0.0000000001:1:-10
0.000000001:1:-9
0.00000001:1:-8
0.0000001:1:-7
0.000001:1:-6
0.00001:1:-5
0.0001:1:-4
0.001:1:-3
0.01:1:-2
0.1:1:-1
1:1:0
10:1:1
100:1:2
1000:1:3
10000:1:4
100000:1:5
1000000:1:6
10000000:1:7
100000000:1:8
1000000000:1:9
10000000000:1:10
100000000000:1:11
1000000000000:1:12

0.0000000000012:1.2:-12
0.000000000012:1.2:-11
0.00000000012:1.2:-10
0.0000000012:1.2:-9
0.000000012:1.2:-8
0.00000012:1.2:-7
0.0000012:1.2:-6
0.000012:1.2:-5
0.00012:1.2:-4
0.0012:1.2:-3
0.012:1.2:-2
0.12:1.2:-1
1.2:1.2:0
12:1.2:1
120:1.2:2
1200:1.2:3
12000:1.2:4
120000:1.2:5
1200000:1.2:6
12000000:1.2:7
120000000:1.2:8
1200000000:1.2:9
12000000000:1.2:10
120000000000:1.2:11
1200000000000:1.2:12

0.00000000000123:1.23:-12
0.0000000000123:1.23:-11
0.000000000123:1.23:-10
0.00000000123:1.23:-9
0.0000000123:1.23:-8
0.000000123:1.23:-7
0.00000123:1.23:-6
0.0000123:1.23:-5
0.000123:1.23:-4
0.00123:1.23:-3
0.0123:1.23:-2
0.123:1.23:-1
1.23:1.23:0
12.3:1.23:1
123:1.23:2
1230:1.23:3
12300:1.23:4
123000:1.23:5
1230000:1.23:6
12300000:1.23:7
123000000:1.23:8
1230000000:1.23:9
12300000000:1.23:10
123000000000:1.23:11
1230000000000:1.23:12

0.000000000001234:1.234:-12
0.00000000001234:1.234:-11
0.0000000001234:1.234:-10
0.000000001234:1.234:-9
0.00000001234:1.234:-8
0.0000001234:1.234:-7
0.000001234:1.234:-6
0.00001234:1.234:-5
0.0001234:1.234:-4
0.001234:1.234:-3
0.01234:1.234:-2
0.1234:1.234:-1
1.234:1.234:0
12.34:1.234:1
123.4:1.234:2
1234:1.234:3
12340:1.234:4
123400:1.234:5
1234000:1.234:6
12340000:1.234:7
123400000:1.234:8
1234000000:1.234:9
12340000000:1.234:10
123400000000:1.234:11
1234000000000:1.234:12

0.000003141592:3.141592:-6
0.00003141592:3.141592:-5
0.0003141592:3.141592:-4
0.003141592:3.141592:-3
0.03141592:3.141592:-2
0.3141592:3.141592:-1
3.141592:3.141592:0
31.41592:3.141592:1
314.1592:3.141592:2
3141.592:3.141592:3
31415.92:3.141592:4
314159.2:3.141592:5
3141592:3.141592:6

# negativ: numbers

-0.000000000001:-1:-12
-0.00000000001:-1:-11
-0.0000000001:-1:-10
-0.000000001:-1:-9
-0.00000001:-1:-8
-0.0000001:-1:-7
-0.000001:-1:-6
-0.00001:-1:-5
-0.0001:-1:-4
-0.001:-1:-3
-0.01:-1:-2
-0.1:-1:-1
-1:-1:0
-10:-1:1
-100:-1:2
-1000:-1:3
-10000:-1:4
-100000:-1:5
-1000000:-1:6
-10000000:-1:7
-100000000:-1:8
-1000000000:-1:9
-10000000000:-1:10
-100000000000:-1:11
-1000000000000:-1:12

-0.0000000000012:-1.2:-12
-0.000000000012:-1.2:-11
-0.00000000012:-1.2:-10
-0.0000000012:-1.2:-9
-0.000000012:-1.2:-8
-0.00000012:-1.2:-7
-0.0000012:-1.2:-6
-0.000012:-1.2:-5
-0.00012:-1.2:-4
-0.0012:-1.2:-3
-0.012:-1.2:-2
-0.12:-1.2:-1
-1.2:-1.2:0
-12:-1.2:1
-120:-1.2:2
-1200:-1.2:3
-12000:-1.2:4
-120000:-1.2:5
-1200000:-1.2:6
-12000000:-1.2:7
-120000000:-1.2:8
-1200000000:-1.2:9
-12000000000:-1.2:10
-120000000000:-1.2:11
-1200000000000:-1.2:12

-0.00000000000123:-1.23:-12
-0.0000000000123:-1.23:-11
-0.000000000123:-1.23:-10
-0.00000000123:-1.23:-9
-0.0000000123:-1.23:-8
-0.000000123:-1.23:-7
-0.00000123:-1.23:-6
-0.0000123:-1.23:-5
-0.000123:-1.23:-4
-0.00123:-1.23:-3
-0.0123:-1.23:-2
-0.123:-1.23:-1
-1.23:-1.23:0
-12.3:-1.23:1
-123:-1.23:2
-1230:-1.23:3
-12300:-1.23:4
-123000:-1.23:5
-1230000:-1.23:6
-12300000:-1.23:7
-123000000:-1.23:8
-1230000000:-1.23:9
-12300000000:-1.23:10
-123000000000:-1.23:11
-1230000000000:-1.23:12

-0.000000000001234:-1.234:-12
-0.00000000001234:-1.234:-11
-0.0000000001234:-1.234:-10
-0.000000001234:-1.234:-9
-0.00000001234:-1.234:-8
-0.0000001234:-1.234:-7
-0.000001234:-1.234:-6
-0.00001234:-1.234:-5
-0.0001234:-1.234:-4
-0.001234:-1.234:-3
-0.01234:-1.234:-2
-0.1234:-1.234:-1
-1.234:-1.234:0
-12.34:-1.234:1
-123.4:-1.234:2
-1234:-1.234:3
-12340:-1.234:4
-123400:-1.234:5
-1234000:-1.234:6
-12340000:-1.234:7
-123400000:-1.234:8
-1234000000:-1.234:9
-12340000000:-1.234:10
-123400000000:-1.234:11
-1234000000000:-1.234:12

-0.000003141592:-3.141592:-6
-0.00003141592:-3.141592:-5
-0.0003141592:-3.141592:-4
-0.003141592:-3.141592:-3
-0.03141592:-3.141592:-2
-0.3141592:-3.141592:-1
-3.141592:-3.141592:0
-31.41592:-3.141592:1
-314.1592:-3.141592:2
-3141.592:-3.141592:3
-31415.92:-3.141592:4
-314159.2:-3.141592:5
-3141592:-3.141592:6
