use lib 't/lib';

use Test::More;

use Data::Object::Signatures qw(MyApp::Types);
use Data::Object qw(deduce);

fun greeting (AllCaps $name) {
    return "hello, $name";
}

fun meeting (Int :$epoch = deduce time) {
    return "our meeting is at $epoch";
}

is greeting(deduce('MARTIAN')), 'hello, MARTIAN';
ok ! eval { greeting(deduce('martian')) };
ok $@;

is meeting(epoch => deduce time), 'our meeting is at ' . time;
is meeting(epocj => deduce time), 'our meeting is at ' . time;

ok 1 and done_testing;
