# Generated by default/object.tt
package Paws::CloudFormation::TypeConfigurationDetails;
  use Moose;
  has Alias => (is => 'ro', isa => 'Str');
  has Arn => (is => 'ro', isa => 'Str');
  has Configuration => (is => 'ro', isa => 'Str');
  has IsDefaultConfiguration => (is => 'ro', isa => 'Bool');
  has LastUpdated => (is => 'ro', isa => 'Str');
  has TypeArn => (is => 'ro', isa => 'Str');
  has TypeName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFormation::TypeConfigurationDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFormation::TypeConfigurationDetails object:

  $service_obj->Method(Att1 => { Alias => $value, ..., TypeName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFormation::TypeConfigurationDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->Alias

=head1 DESCRIPTION

Detailed information concerning the specification of a CloudFormation
extension in a given account and region.

For more information, see Configuring extensions at the account level
(https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration)
in the I<CloudFormation User Guide>.

=head1 ATTRIBUTES


=head2 Alias => Str

The alias specified for this configuration, if one was specified when
the configuration was set.


=head2 Arn => Str

The Amazon Resource Name (ARN) for the configuration data, in this
account and region.


=head2 Configuration => Str

A JSON string specifying the configuration data for the extension, in
this account and region.

If a configuration has not been set for a specified extension,
CloudFormation returns C<{}>.


=head2 IsDefaultConfiguration => Bool

Whether or not this configuration data is the default configuration for
the extension.


=head2 LastUpdated => Str

When the configuration data was last updated for this extension.

If a configuration has not been set for a specified extension,
CloudFormation returns C<null>.


=head2 TypeArn => Str

The Amazon Resource Name (ARN) for the extension, in this account and
region.

For public extensions, this will be the ARN assigned when you activate
the type
(https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html)
in this account and region. For private extensions, this will be the
ARN assigned when you register the type
(https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html)
in this account and region.


=head2 TypeName => Str

The name of the extension.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFormation>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

