# Generated by default/object.tt
package Paws::DevOpsGuru::SearchInsightsFilters;
  use Moose;
  has ResourceCollection => (is => 'ro', isa => 'Paws::DevOpsGuru::ResourceCollection');
  has ServiceCollection => (is => 'ro', isa => 'Paws::DevOpsGuru::ServiceCollection');
  has Severities => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Statuses => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::SearchInsightsFilters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::SearchInsightsFilters object:

  $service_obj->Method(Att1 => { ResourceCollection => $value, ..., Statuses => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::SearchInsightsFilters object:

  $result = $service_obj->Method(...);
  $result->Att1->ResourceCollection

=head1 DESCRIPTION

Specifies one or more severity values and one or more status values
that are used to search for insights.

=head1 ATTRIBUTES


=head2 ResourceCollection => L<Paws::DevOpsGuru::ResourceCollection>




=head2 ServiceCollection => L<Paws::DevOpsGuru::ServiceCollection>

A collection of the names of AWS services.


=head2 Severities => ArrayRef[Str|Undef]

An array of severity values used to search for insights.


=head2 Statuses => ArrayRef[Str|Undef]

An array of status values used to search for insights.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

