# Generated by default/object.tt
package Paws::SESv2::Topic;
  use Moose;
  has DefaultSubscriptionStatus => (is => 'ro', isa => 'Str', required => 1);
  has Description => (is => 'ro', isa => 'Str');
  has DisplayName => (is => 'ro', isa => 'Str', required => 1);
  has TopicName => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SESv2::Topic

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SESv2::Topic object:

  $service_obj->Method(Att1 => { DefaultSubscriptionStatus => $value, ..., TopicName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SESv2::Topic object:

  $result = $service_obj->Method(...);
  $result->Att1->DefaultSubscriptionStatus

=head1 DESCRIPTION

An interest group, theme, or label within a list. Lists can have
multiple topics.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DefaultSubscriptionStatus => Str

The default subscription status to be applied to a contact if the
contact has not noted their preference for subscribing to a topic.


=head2 Description => Str

A description of what the topic is about, which the contact will see.


=head2 B<REQUIRED> DisplayName => Str

The name of the topic the contact will see.


=head2 B<REQUIRED> TopicName => Str

The name of the topic.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SESv2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

