# Generated by default/object.tt
package Paws::QLDB::KinesisConfiguration;
  use Moose;
  has AggregationEnabled => (is => 'ro', isa => 'Bool');
  has StreamArn => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::QLDB::KinesisConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::QLDB::KinesisConfiguration object:

  $service_obj->Method(Att1 => { AggregationEnabled => $value, ..., StreamArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::QLDB::KinesisConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AggregationEnabled

=head1 DESCRIPTION

The configuration settings of the Amazon Kinesis Data Streams
destination for an Amazon QLDB journal stream.

=head1 ATTRIBUTES


=head2 AggregationEnabled => Bool

Enables QLDB to publish multiple data records in a single Kinesis Data
Streams record, increasing the number of records sent per API call.

I<This option is enabled by default.> Record aggregation has important
implications for processing records and requires de-aggregation in your
stream consumer. To learn more, see KPL Key Concepts
(https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html)
and Consumer De-aggregation
(https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html)
in the I<Amazon Kinesis Data Streams Developer Guide>.


=head2 B<REQUIRED> StreamArn => Str

The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::QLDB>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

