/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.24
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifndef SWIG_TEMPLATE_DISAMBIGUATOR
#  if defined(__SUNPRO_CC) 
#    define SWIG_TEMPLATE_DISAMBIGUATOR template
#  else
#    define SWIG_TEMPLATE_DISAMBIGUATOR 
#  endif
#endif

/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "1"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
#define SWIG_QUOTE_STRING(x) #x
#define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
#define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
#define SWIG_TYPE_TABLE_NAME
#endif

#include <string.h>

#ifndef SWIGINLINE
#if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#  define SWIGINLINE inline
#else
#  define SWIGINLINE
#endif
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/
#ifndef SWIGRUNTIME
#define SWIGRUNTIME static
#endif
#ifndef SWIGRUNTIMEINLINE
#define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Register a type mapping with the type-checking
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeRegisterTL(swig_type_info **tl, swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *tl;
  while (tc) {
    /* check simple type equivalence */
    int typeequiv = (strcmp(tc->name, ti->name) == 0);   
    /* check full type equivalence, resolving typedefs */
    if (!typeequiv) {
      /* only if tc is not a typedef (no '|' on it) */
      if (tc->str && ti->str && !strstr(tc->str,"|")) {
	typeequiv = SWIG_TypeEquiv(ti->str,tc->str);
      }
    }
    if (typeequiv) {
      /* Already exists in the table.  Just add additional types to the list */
      if (ti->clientdata) tc->clientdata = ti->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *tl;
  *tl = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;

  return ret;
}

/*
  Check the typename
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/*
  Search for a swig_type_info structure
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryTL(swig_type_info *tl, const char *name) {
  swig_type_info *ty = tl;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientDataTL(swig_type_info *tl, swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata) return;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = tl;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientDataTL(tl,tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register int d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/*
  This function will propagate the clientdata field of type to any new
  swig_type_info structures that have been added into the list of
  equivalent types.  It is like calling SWIG_TypeClientData(type,
  clientdata) a second time.
*/
SWIGRUNTIME void
SWIG_PropagateClientDataTL(swig_type_info *tl, swig_type_info *type) {
  swig_type_info *equiv = type->next;
  swig_type_info *tc;
  if (!type->clientdata) return;
  while (equiv) {
    if (!equiv->converter) {
      tc = tl;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0) && !tc->clientdata)
          SWIG_TypeClientDataTL(tl,tc, type->clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/


#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if !defined(STATIC_LINKED)
#    define SWIGEXPORT(a) __declspec(dllexport) a
#  else
#    define SWIGEXPORT(a) a
#  endif
#else
#  define SWIGEXPORT(a) a
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*************************************************************************/


/* The static type info list */

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;
  

/* Register a type mapping with the type-checking */
static swig_type_info *
SWIG_TypeRegister(swig_type_info *ti) {
  return SWIG_TypeRegisterTL(swig_type_list_handle, ti);
}

/* Search for a swig_type_info structure */
static swig_type_info *
SWIG_TypeQuery(const char *name) {
  return SWIG_TypeQueryTL(*swig_type_list_handle, name);
}

/* Set the clientdata field for a type */
static void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  SWIG_TypeClientDataTL(*swig_type_list_handle, ti, clientdata);
}

/* This function will propagate the clientdata field of type to
* any new swig_type_info structures that have been added into the list
* of equivalent types.  It is like calling
* SWIG_TypeClientData(type, clientdata) a second time.
*/
static void
SWIG_PropagateClientData(swig_type_info *type) {
  SWIG_PropagateClientDataTL(*swig_type_list_handle, type);
}

#ifdef __cplusplus
}
#endif

/* ---------------------------------------------------------------------- -*- c -*-
 * perl5.swg
 *
 * Perl5 runtime library
 * $Header: /cvsroot/swig/SWIG/Lib/perl5/perlrun.swg,v 1.20 2004/11/29 23:13:57 wuzzeb Exp $
 * ----------------------------------------------------------------------------- */

#define SWIGPERL
#define SWIGPERL5
#ifdef __cplusplus
/* Needed on some windows machines---since MS plays funny games with the header files under C++ */
#include <math.h>
#include <stdlib.h>
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Get rid of free and malloc defined by perl */
#undef free
#undef malloc

#ifndef pTHX_
#define pTHX_
#endif

#include <string.h>
#ifdef __cplusplus
}
#endif

/* Macro to call an XS function */

#ifdef PERL_OBJECT 
#  define SWIG_CALLXS(_name) _name(cv,pPerl) 
#else 
#  ifndef MULTIPLICITY 
#    define SWIG_CALLXS(_name) _name(cv) 
#  else 
#    define SWIG_CALLXS(_name) _name(PERL_GET_THX, cv) 
#  endif 
#endif 

/* Contract support */

#define SWIG_contract_assert(expr,msg) if (!(expr)) { SWIG_croak(msg); } else

/* Note: SwigMagicFuncHack is a typedef used to get the C++ compiler to just shut up already */

#ifdef PERL_OBJECT
#define MAGIC_PPERL  CPerlObj *pPerl = (CPerlObj *) this;
typedef int (CPerlObj::*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (CPerlObj::*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
#define SWIGCLASS_STATIC
#else
#define MAGIC_PPERL
#define SWIGCLASS_STATIC static
#ifndef MULTIPLICITY
#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif


#else
#define SWIG_MAGIC(a,b) (struct interpreter *interp, SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#endif
#endif

#if defined(WIN32) && defined(PERL_OBJECT) && !defined(PerlIO_exportFILE)
#define PerlIO_exportFILE(fh,fl) (FILE*)(fh)
#endif

/* Modifications for newer Perl 5.005 releases */

#if !defined(PERL_REVISION) || ((PERL_REVISION >= 5) && ((PERL_VERSION < 5) || ((PERL_VERSION == 5) && (PERL_SUBVERSION < 50))))
#  ifndef PL_sv_yes
#    define PL_sv_yes sv_yes
#  endif
#  ifndef PL_sv_undef
#    define PL_sv_undef sv_undef
#  endif
#  ifndef PL_na
#    define PL_na na
#  endif
#endif

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_OWNER 1
#define SWIG_SHADOW 2

/* Common SWIG API */

#ifdef PERL_OBJECT
#  define SWIG_ConvertPtr(obj, pp, type, flags) \
     SWIG_Perl_ConvertPtr(pPerl, obj, pp, type, flags)
#  define SWIG_NewPointerObj(p, type, flags) \
     SWIG_Perl_NewPointerObj(pPerl, p, type, flags)
#  define SWIG_MakePackedObj(sv, p, s, type)	\
     SWIG_Perl_MakePackedObj(pPerl, sv, p, s, type)
#  define SWIG_ConvertPacked(obj, p, s, type, flags) \
     SWIG_Perl_ConvertPacked(pPerl, obj, p, s, type, flags)

#else
#  define SWIG_ConvertPtr(obj, pp, type, flags) \
     SWIG_Perl_ConvertPtr(obj, pp, type, flags)
#  define SWIG_NewPointerObj(p, type, flags) \
     SWIG_Perl_NewPointerObj(p, type, flags)
#  define SWIG_MakePackedObj(sv, p, s, type)	\
     SWIG_Perl_MakePackedObj(sv, p, s, type )
#  define SWIG_ConvertPacked(obj, p, s, type, flags) \
     SWIG_Perl_ConvertPacked(obj, p, s, type, flags)
#endif

/* Perl-specific API */
#ifdef PERL_OBJECT
#  define SWIG_MakePtr(sv, ptr, type, flags) \
     SWIG_Perl_MakePtr(pPerl, sv, ptr, type, flags)
#  define SWIG_SetError(str) \
     SWIG_Perl_SetError(pPerl, str)
#else
#  define SWIG_MakePtr(sv, ptr, type, flags) \
     SWIG_Perl_MakePtr(sv, ptr, type, flags)
#  define SWIG_SetError(str) \
     SWIG_Perl_SetError(str)
#  define SWIG_SetErrorSV(str) \
     SWIG_Perl_SetErrorSV(str)
#endif

#define SWIG_SetErrorf SWIG_Perl_SetErrorf


#ifdef PERL_OBJECT
#  define SWIG_MAYBE_PERL_OBJECT CPerlObj *pPerl,
#else
#  define SWIG_MAYBE_PERL_OBJECT
#endif

static swig_type_info **
SWIG_Perl_GetTypeListHandle() {
  static void *type_pointer = (void *)0;
  SV *pointer;

  /* first check if pointer already created */
  if (!type_pointer) {
    pointer = get_sv("swig_runtime_data::type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, FALSE);
    if (pointer && SvOK(pointer)) {
      type_pointer = INT2PTR(swig_type_info **, SvIV(pointer));
    }
  }

  return (swig_type_info **) type_pointer;
}

/*
  Search for a swig_type_info structure
 */
SWIGRUNTIMEINLINE swig_type_info *
SWIG_Perl_GetTypeList() {
  swig_type_info **tlh = SWIG_Perl_GetTypeListHandle();
  return tlh ? *tlh : (swig_type_info*)0;
}

#define SWIG_Runtime_GetTypeList SWIG_Perl_GetTypeList 

static swig_type_info *
SWIG_Perl_TypeCheckRV(SWIG_MAYBE_PERL_OBJECT SV *rv, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (sv_derived_from(rv, (char *) s->name)) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Function for getting a pointer value */

static int
SWIG_Perl_ConvertPtr(SWIG_MAYBE_PERL_OBJECT SV *sv, void **ptr, swig_type_info *_t, int flags) {
  swig_type_info *tc;
  void *voidptr = (void *)0;

  /* If magical, apply more magic */
  if (SvGMAGICAL(sv))
    mg_get(sv);

  /* Check to see if this is an object */
  if (sv_isobject(sv)) {
    SV *tsv = (SV*) SvRV(sv);
    IV tmp = 0;
    if ((SvTYPE(tsv) == SVt_PVHV)) {
      MAGIC *mg;
      if (SvMAGICAL(tsv)) {
        mg = mg_find(tsv,'P');
        if (mg) {
          sv = mg->mg_obj;
          if (sv_isobject(sv)) {
            tmp = SvIV((SV*)SvRV(sv));
          }
        }
      } else {
        return -1;
      }
    } else {
      tmp = SvIV((SV*)SvRV(sv));
    }
    voidptr = (void *)tmp;
    if (!_t) {
      *(ptr) = voidptr;
      return 0;
    }
  } else if (! SvOK(sv)) {            /* Check for undef */
    *(ptr) = (void *) 0;
    return 0;
  } else if (SvTYPE(sv) == SVt_RV) {  /* Check for NULL pointer */
    *(ptr) = (void *) 0;
    if (!SvROK(sv))
      return 0;
    else
      return -1;
  } else {                            /* Don't know what it is */
    *(ptr) = (void *) 0;
    return -1;
  }
  if (_t) {
    /* Now see if the types match */
    char *_c = HvNAME(SvSTASH(SvRV(sv)));
    tc = SWIG_TypeCheck(_c,_t);
    if (!tc) {
      *ptr = voidptr;
      return -1;
    }
    *ptr = SWIG_TypeCast(tc,voidptr);
    return 0;
  }
  *ptr = voidptr;
  return 0;
}

static void
SWIG_Perl_MakePtr(SWIG_MAYBE_PERL_OBJECT SV *sv, void *ptr, swig_type_info *t, int flags) {
  if (ptr && (flags & SWIG_SHADOW)) {
    SV *self;
    SV *obj=newSV(0);
    HV *hash=newHV();
    HV *stash;
    sv_setref_pv(obj, (char *) t->name, ptr);
    stash=SvSTASH(SvRV(obj));
    if (flags & SWIG_OWNER) {
      HV *hv;
      GV *gv=*(GV**)hv_fetch(stash, "OWNER", 5, TRUE);
      if (!isGV(gv))
        gv_init(gv, stash, "OWNER", 5, FALSE);
      hv=GvHVn(gv);
      hv_store_ent(hv, obj, newSViv(1), 0);
    }
    sv_magic((SV *)hash, (SV *)obj, 'P', Nullch, 0);
    SvREFCNT_dec(obj);
    self=newRV_noinc((SV *)hash);
    sv_setsv(sv, self);
    SvREFCNT_dec((SV *)self);
    sv_bless(sv, stash);
  }
  else {
    sv_setref_pv(sv, (char *) t->name, ptr);
  }
}

static SWIGINLINE SV *
SWIG_Perl_NewPointerObj(SWIG_MAYBE_PERL_OBJECT void *ptr, swig_type_info *t, int flags) {
  SV *result = sv_newmortal();
  SWIG_MakePtr(result, ptr, t, flags);
  return result;
}

static void
  SWIG_Perl_MakePackedObj(SWIG_MAYBE_PERL_OBJECT SV *sv, void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  sv_setpv(sv, result);
}

/* Convert a packed value value */
static int
SWIG_Perl_ConvertPacked(SWIG_MAYBE_PERL_OBJECT SV *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  const char  *c = 0;

  if ((!obj) || (!SvOK(obj))) return -1;
  c = SvPV(obj, PL_na);
  /* Pointer values must start with leading underscore */
  if (*c != '_') return -1;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) return -1;
  }
  return 0;
}

static SWIGINLINE void
SWIG_Perl_SetError(SWIG_MAYBE_PERL_OBJECT const char *error) {
  if (error) sv_setpv(perl_get_sv("@", TRUE), error);
}

static SWIGINLINE void
SWIG_Perl_SetErrorSV(SWIG_MAYBE_PERL_OBJECT SV *error) {
  if (error) sv_setsv(perl_get_sv("@", TRUE), error);
}

static void
SWIG_Perl_SetErrorf(const char *fmt, ...) {
  va_list args;
  va_start(args, fmt);
  sv_vsetpvfn(perl_get_sv("@", TRUE), fmt, strlen(fmt), &args, Null(SV**), 0, Null(bool*));
  va_end(args);
}

/* Macros for low-level exception handling */
#define SWIG_fail       goto fail
#define SWIG_croak(x)   { SWIG_SetError(x); goto fail; }
#define SWIG_croakSV(x) { SWIG_SetErrorSV(x); goto fail; }
/* most preprocessors do not support vararg macros :-( */
/* #define SWIG_croakf(x...) { SWIG_SetErrorf(x); goto fail; } */


typedef XS(SwigPerlWrapper);
typedef SwigPerlWrapper *SwigPerlWrapperPtr;

/* Structure for command table */
typedef struct {
  const char         *name;
  SwigPerlWrapperPtr  wrapper;
} swig_command_info;

/* Information for constant table */

#define SWIG_INT     1
#define SWIG_FLOAT   2
#define SWIG_STRING  3
#define SWIG_POINTER 4
#define SWIG_BINARY  5

/* Constant information structure */
typedef struct swig_constant_info {
    int              type;
    const char      *name;
    long             lvalue;
    double           dvalue;
    void            *pvalue;
    swig_type_info **ptype;
} swig_constant_info;

#ifdef __cplusplus
}
#endif

/* Structure for variable table */
typedef struct {
  const char   *name;
  SwigMagicFunc   set;
  SwigMagicFunc   get;
  swig_type_info  **type;
} swig_variable_info;

/* Magic variable code */
#ifndef PERL_OBJECT
#define swig_create_magic(s,a,b,c) _swig_create_magic(s,a,b,c)
  #ifndef MULTIPLICITY
     static void _swig_create_magic(SV *sv, char *name, int (*set)(SV *, MAGIC *), int (*get)(SV *,MAGIC *)) {
  #else
     static void _swig_create_magic(SV *sv, char *name, int (*set)(struct interpreter*, SV *, MAGIC *), int (*get)(struct interpreter*, SV *,MAGIC *)) {
  #endif
#else
#  define swig_create_magic(s,a,b,c) _swig_create_magic(pPerl,s,a,b,c)
static void _swig_create_magic(CPerlObj *pPerl, SV *sv, const char *name, int (CPerlObj::*set)(SV *, MAGIC *), int (CPerlObj::*get)(SV *, MAGIC *)) {
#endif
  MAGIC *mg;
  sv_magic(sv,sv,'U',(char *) name,strlen(name));
  mg = mg_find(sv,'U');
  mg->mg_virtual = (MGVTBL *) malloc(sizeof(MGVTBL));
  mg->mg_virtual->svt_get = (SwigMagicFuncHack) get;
  mg->mg_virtual->svt_set = (SwigMagicFuncHack) set;
  mg->mg_virtual->svt_len = 0;
  mg->mg_virtual->svt_clear = 0;
  mg->mg_virtual->svt_free = 0;
}






#ifdef do_open
  #undef do_open
#endif
#ifdef do_close
  #undef do_close
#endif
#ifdef scalar
  #undef scalar
#endif
#ifdef list
  #undef list
#endif
#ifdef apply
  #undef apply
#endif
#ifdef convert
  #undef convert
#endif
#ifdef Error
  #undef Error
#endif
#ifdef form
  #undef form
#endif
#ifdef vform
  #undef vform
#endif
#ifdef LABEL
  #undef LABEL
#endif
#ifdef METHOD
  #undef METHOD
#endif
#ifdef Move
  #undef Move
#endif
#ifdef yylex
  #undef yylex
#endif
#ifdef yyparse
  #undef yyparse
#endif
#ifdef yyerror
  #undef yyerror
#endif
#ifdef invert
  #undef invert
#endif
#ifdef ref
  #undef ref
#endif
#ifdef ENTER
  #undef ENTER
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_cdio_read_mode_t swig_types[0] 
#define  SWIGTYPE_p_CdIo_t swig_types[1] 
#define  SWIGTYPE_p_unsigned_long swig_types[2] 
#define  SWIGTYPE_p_char swig_types[3] 
#define  SWIGTYPE_p_long swig_types[4] 
#define  SWIGTYPE_p_cdio_hwinfo_t swig_types[5] 
#define  SWIGTYPE_p_unsigned_int swig_types[6] 
#define  SWIGTYPE_p_int swig_types[7] 
#define  SWIGTYPE_p_off_t swig_types[8] 
static swig_type_info *swig_types[10];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    boot_perlcdio

#define SWIG_name   "perlcdioc::boot_perlcdio"
#define SWIG_prefix "perlcdioc::"

#ifdef __cplusplus
extern "C"
#endif
#ifndef PERL_OBJECT
#ifndef MULTIPLICITY
SWIGEXPORT(void) SWIG_init (CV* cv);
#else
SWIGEXPORT(void) SWIG_init (pTHXo_ CV* cv);
#endif
#else
SWIGEXPORT(void) SWIG_init (CV *cv, CPerlObj *);
#endif


/* Includes the header in the wrapper code */
#include <cdio/cdio.h>
#include <cdio/audio.h>
#include <cdio/cd_types.h>


/* When libcdio version > 0.76 comes out this won't be needed. */
#include <cdio/version.h>
#if LIBCDIO_VERSION_NUM <= 76

/**< Masks derived from above... */
#undef CDIO_DRIVE_CAP_WRITE_DVD
#define CDIO_DRIVE_CAP_WRITE_DVD (               \
      CDIO_DRIVE_CAP_WRITE_DVD_R                 \
    | CDIO_DRIVE_CAP_WRITE_DVD_PR                \
    | CDIO_DRIVE_CAP_WRITE_DVD_RAM               \
    | CDIO_DRIVE_CAP_WRITE_DVD_RW                \
    | CDIO_DRIVE_CAP_WRITE_DVD_RPW               \
    ) 

/** All the different ways a block/sector can be read. */
typedef enum {
  CDIO_READ_MODE_AUDIO,  /**< CD-DA, audio, Red Book */
  CDIO_READ_MODE_M1F1,   /**< Mode 1 Form 1 */
  CDIO_READ_MODE_M1F2,   /**< Mode 1 Form 2 */
  CDIO_READ_MODE_M2F1,   /**< Mode 2 Form 1 */
  CDIO_READ_MODE_M2F2,   /**< Mode 2 Form 2 */
} cdio_read_mode_t;

/*!
  Reads a number of sectors (AKA blocks).
  
  @param p_buf place to read data into. The caller should make sure
  this location is large enough. See below for size information.
  @param read_mode the kind of "mode" to use in reading.
  @param i_lsn sector to read
  @param i_blocks number of sectors to read
  @return DRIVER_OP_SUCCESS (0) if no error, other (negative) enumerations
  are returned on error.
  
  If read_mode is CDIO_MODE_AUDIO,
    *p_buf should hold at least CDIO_FRAMESIZE_RAW * i_blocks bytes.

  If read_mode is CDIO_MODE_DATA,
    *p_buf should hold at least i_blocks times either ISO_BLOCKSIZE, 
    M1RAW_SECTOR_SIZE or M2F2_SECTOR_SIZE depending on the kind of 
    sector getting read. If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is M2RAW_SECTOR_SIZE.

  If read_mode is CDIO_MODE_M2F1,
    *p_buf should hold at least M2RAW_SECTOR_SIZE * i_blocks bytes.

  If read_mode is CDIO_MODE_M2F2,
    *p_buf should hold at least CDIO_CD_FRAMESIZE * i_blocks bytes.


*/
driver_return_code_t 
cdio_read_sectors(const CdIo_t *p_cdio, void *p_buf, lsn_t i_lsn, 
                  cdio_read_mode_t read_mode, uint32_t i_blocks)
{
  switch(read_mode) {
  case CDIO_READ_MODE_AUDIO:
    return cdio_read_audio_sectors (p_cdio, p_buf, i_lsn, i_blocks);
  case CDIO_READ_MODE_M1F1:
    return cdio_read_mode1_sectors (p_cdio, p_buf, i_lsn, false, i_blocks);
  case CDIO_READ_MODE_M1F2:
    return cdio_read_mode1_sectors (p_cdio, p_buf, i_lsn, true,  i_blocks);
  case CDIO_READ_MODE_M2F1:
    return cdio_read_mode2_sectors (p_cdio, p_buf, i_lsn, false, i_blocks);
  case CDIO_READ_MODE_M2F2:
    return cdio_read_mode2_sectors (p_cdio, p_buf, i_lsn, true,  i_blocks);
  }
  /* Can't happen. Just to shut up gcc. */
  return DRIVER_OP_ERROR; 
}

driver_return_code_t
cdio_eject_media_drive (const char *psz_drive)
{
  CdIo_t *p_cdio = cdio_open (psz_drive, DRIVER_DEVICE);
  if (p_cdio) {
    return cdio_eject_media(&p_cdio);
  } else {
    return DRIVER_OP_UNINIT;
  }
}
#endif /* LIBCDIO_VERSION_NUM <= 76 */


driver_return_code_t audio_play_lsn (CdIo_t *p_cdio, lsn_t start_lsn,
				     lsn_t end_lsn)
{
  msf_t start_msf;
  msf_t end_msf;
  cdio_lsn_to_msf (start_lsn, &start_msf);
  cdio_lsn_to_msf (end_lsn, &end_msf);
  return cdio_audio_play_msf(p_cdio, &start_msf, &end_msf);
}


  typedef long int my_ssize_t;


char *
read_cd(const CdIo_t *p_cdio, my_ssize_t i_size, 
	/*out*/ my_ssize_t *pi_size) {
  char *p_buf = calloc(1, i_size);
  *pi_size = cdio_read(p_cdio, p_buf, i_size);
  return p_buf;
}


typedef char *buf_t;
/* NOTE: arg 4 *must* be the size of the buf for the buf_t typemap. */
buf_t
read_sectors(const CdIo_t *p_cdio, lsn_t i_lsn, 
	     cdio_read_mode_t read_mode,  my_ssize_t i_size, 
	     /*out*/ my_ssize_t *pi_size, 
	     /*out*/ long unsigned int *drc)
{

  char *p_buf;
  uint32_t i_blocks;
  uint16_t i_blocksize;
  switch (read_mode) {
  case CDIO_READ_MODE_AUDIO: 
    i_blocksize = CDIO_CD_FRAMESIZE_RAW;
    break;
  case CDIO_READ_MODE_M1F1: 
    i_blocksize = M2RAW_SECTOR_SIZE;
    break;
  case CDIO_READ_MODE_M1F2: 
    i_blocksize = M2RAW_SECTOR_SIZE;
    break;
  case CDIO_READ_MODE_M2F1: 
    i_blocksize = CDIO_CD_FRAMESIZE;
    break;
  case CDIO_READ_MODE_M2F2: 
    i_blocksize = M2F2_SECTOR_SIZE;
    break;
  default: 
    pi_size = NULL;
    *drc = DRIVER_OP_BAD_PARAMETER;
    return NULL;
  }
  p_buf = calloc(1, i_size);
  
  i_blocks = i_size / i_blocksize;
  *drc = cdio_read_sectors(p_cdio, p_buf, i_lsn, read_mode, i_blocks);
  if (*drc < 0) {
    pi_size = NULL;
    return NULL;
  }
  *pi_size = i_size;
  return p_buf;
}
 

/* NOTE: arg 4 *must* be the size of the buf for the buf_t typemap. */
buf_t
read_data_bytes(const CdIo_t *p_cdio, lsn_t i_lsn, 
		int16_t i_blocksize, my_ssize_t i_size, 
		/*out*/ my_ssize_t *pi_size,
		/*out*/ long unsigned int *drc) {
  uint32_t i_blocks = i_size / i_blocksize;
  char *p_buf;

  switch (i_blocksize) {
  case CDIO_CD_FRAMESIZE:
  case CDIO_CD_FRAMESIZE_RAW:
  case M2F2_SECTOR_SIZE:
  case M2RAW_SECTOR_SIZE:
    break;
  default:
    /* Don't know about these block sizes */
    pi_size = NULL;
    *drc = DRIVER_OP_BAD_PARAMETER;
    return NULL;
  }
  p_buf = calloc(1, i_size);

#if DEBUGGING  
  printf("p_cdio: %x, i_size: %d, lsn: %d, blocksize %d, blocks %d\n",
	 p_cdio, i_size, i_lsn, i_blocksize, i_blocks);
#endif
  *drc = cdio_read_data_sectors (p_cdio, p_buf, i_lsn, 
				 i_blocksize, i_blocks);
#if DEBUGGING  
  printf("drc: %d\n", drc);
#endif
  if (*drc < 0) {
    pi_size = NULL;
    return NULL;
  }
  *pi_size = i_size;
  return p_buf;
}


const char *get_track_msf(const CdIo_t *p_cdio, track_t i_track)
{
	msf_t msf;
	char *psz_msf;

	if (!cdio_get_track_msf( p_cdio, i_track, &msf )) {
		return "error";
	}
	psz_msf = cdio_msf_to_str( &msf );
	return psz_msf;
}


const char 
*get_track_format(const CdIo_t *p_cdio, track_t i_track) 
{
  track_format_t track_format = cdio_get_track_format(p_cdio, i_track);
  return track_format2str[track_format];
}


typedef char ** DeviceList_t;


driver_return_code_t 
close_tray(const char *psz_drive, driver_id_t p_driver_id,
	     driver_id_t *p_out_driver_id)  
{
  *p_out_driver_id = p_driver_id;
  return cdio_close_tray(psz_drive, p_out_driver_id);
}


const char *
driver_errmsg(driver_return_code_t drc)
{
  switch(drc) {
  case DRIVER_OP_SUCCESS: 
    return "driver operation was successful";
  case DRIVER_OP_ERROR:
    return "driver I/O error";
  case DRIVER_OP_UNSUPPORTED:
    return "driver operatation not supported";
  case DRIVER_OP_UNINIT:
    return "driver not initialized";
  case DRIVER_OP_NOT_PERMITTED:
    return "driver operatation not permitted";
  case DRIVER_OP_BAD_PARAMETER:
    return "bad parameter passed";
  case DRIVER_OP_BAD_POINTER:
    return "bad pointer to memory area";
  case DRIVER_OP_NO_DRIVER:
    return "driver not available";
  default:
    return "unknown or bad driver return status";
  }
}


driver_return_code_t 

eject_media (CdIo_t *p_cdio) 
{
  /* libcdio routines uses a Cdio_t **p_cdio, so we have to pass in
     something it can clobber.
   */
  CdIo_t **pp_cdio = &p_cdio;
  return cdio_eject_media (pp_cdio);
}


char *
get_default_device_driver(driver_id_t driver_id, driver_id_t *p_out_driver_id)
{
  *p_out_driver_id = driver_id;
  return cdio_get_default_device_driver(p_out_driver_id);
}


DeviceList_t get_devices_ret (driver_id_t driver_id, 
			      driver_id_t *p_out_driver_id) {
  *p_out_driver_id = driver_id;
  return cdio_get_devices_ret (p_out_driver_id);
 }


DeviceList_t 
get_devices_with_cap (unsigned int capabilities, bool b_any) {
  /* FIXME: ? libcdio allows one to specify a list (char **) of devices
     to search. Don't know how to do that via SWIG though. */
  return cdio_get_devices_with_cap (NULL, (cdio_fs_anal_t) capabilities,
				    b_any);
 }


DeviceList_t
get_devices_with_cap_ret (unsigned int capabilities, bool b_any,
			  driver_id_t *p_out_driver_id) {
  /* FIXME: ? libcdio allows one to specify a list (char **) of devices
     to search. Don't know how to do that via SWIG though. */
  return cdio_get_devices_with_cap_ret (NULL, 
					(cdio_fs_anal_t) capabilities, b_any, 
					p_out_driver_id);
 }


int
have_driver (unsigned int driver_id)
{
  if (driver_id < CDIO_MIN_DRIVER || driver_id > CDIO_MAX_DRIVER)
    return -1;
  if (cdio_have_driver(driver_id)) return 1;
  return 0;
}


/*! True if CD-ROM understand ATAPI commands. */
bool 
have_ATAPI (CdIo_t *p_cdio)
{
  return cdio_have_atapi(p_cdio) == yep;
}


bool 
is_device(const char *psz_source, driver_id_t driver_id)
{
  if (DRIVER_UNKNOWN == driver_id || DRIVER_DEVICE == driver_id) {
    char *psz_drive = cdio_get_default_device_driver(&driver_id);
    /* We don't need the psz_drive, just the driver_id */
    free(psz_drive); 
  }
  return cdio_is_device(psz_source, driver_id);
}


typedef char ** HWInfo_t;


static cdio_hwinfo_t hw_info;
const 
HWInfo_t get_hwinfo ( const CdIo_t *p_cdio, int *drc)
{
  static const char *hwinfo[4] = {
    hw_info.psz_vendor,
    hw_info.psz_model,
    hw_info.psz_revision,
    NULL
    };
  bool b_got_hwinfo = cdio_get_hwinfo(p_cdio, &hw_info);

  *drc = b_got_hwinfo;
  return (const HWInfo_t) hwinfo;
}


const char *
get_disc_mode (CdIo_t *p_cdio) 
{
  discmode_t discmode = cdio_get_discmode(p_cdio);
  if (CDIO_DISC_MODE_ERROR == discmode) return NULL;
  return discmode2str[discmode];
}


#ifdef PERL_OBJECT
#define MAGIC_CLASS _wrap_perlcdio_var::
class _wrap_perlcdio_var : public CPerlObj {
public:
#else
#define MAGIC_CLASS
#endif
SWIGCLASS_STATIC int swig_magic_readonly(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    sv = sv; mg = mg;
    croak("Value is read-only.");
    return 0;
}
SWIGCLASS_STATIC int _wrap_set_hw_info(pTHX_ SV* sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    {
        cdio_hwinfo_t * argp;
        if (SWIG_ConvertPtr(sv,(void **) &argp, SWIGTYPE_p_cdio_hwinfo_t,0) < 0) {
            croak("Type error in argument $argnum of hw_info. Expected _p_cdio_hwinfo_t");
        }
        hw_info = *argp;
    }
    return 1;
}


SWIGCLASS_STATIC int _wrap_val_hw_info(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    mg = mg;
    sv_setiv(SvRV(sv), (IV) &hw_info);
    return 1;
}




#ifdef PERL_OBJECT
};
#endif

#ifdef __cplusplus
extern "C" {
#endif
XS(_wrap_cdio_read_sectors) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        void *arg2 = (void *) 0 ;
        lsn_t arg3 ;
        cdio_read_mode_t arg4 ;
        unsigned int arg5 ;
        driver_return_code_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: cdio_read_sectors(p_cdio,p_buf,i_lsn,read_mode,i_blocks);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of cdio_read_sectors. Expected _p_CdIo_t");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, 0,0) < 0) {
                SWIG_croak("Type error in argument 2 of cdio_read_sectors. Expected _p_void");
            }
        }
        arg3 = (lsn_t) SvIV(ST(2));
        arg4 = (cdio_read_mode_t) SvIV(ST(3));
        arg5 = (unsigned int) SvUV(ST(4));
        result = (driver_return_code_t)cdio_read_sectors((CdIo_t const *)arg1,arg2,arg3,(cdio_read_mode_t )arg4,arg5);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_cdio_eject_media_drive) {
    {
        char *arg1 = (char *) 0 ;
        driver_return_code_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: cdio_eject_media_drive(psz_drive);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (driver_return_code_t)cdio_eject_media_drive((char const *)arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_audio_pause) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        driver_return_code_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: audio_pause(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of audio_pause. Expected _p_CdIo_t");
            }
        }
        result = (driver_return_code_t)cdio_audio_pause(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_audio_play_lsn) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        lsn_t arg2 ;
        lsn_t arg3 ;
        driver_return_code_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: audio_play_lsn(p_cdio,start_lsn,end_lsn);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of audio_play_lsn. Expected _p_CdIo_t");
            }
        }
        arg2 = (lsn_t) SvIV(ST(1));
        arg3 = (lsn_t) SvIV(ST(2));
        result = (driver_return_code_t)audio_play_lsn(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_audio_resume) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        driver_return_code_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: audio_resume(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of audio_resume. Expected _p_CdIo_t");
            }
        }
        result = (driver_return_code_t)cdio_audio_resume(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_audio_stop) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        driver_return_code_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: audio_stop(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of audio_stop. Expected _p_CdIo_t");
            }
        }
        result = (driver_return_code_t)cdio_audio_stop(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_lseek) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        off_t arg2 ;
        int arg3 = (int) SEEK_SET ;
        off_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: lseek(p_cdio,offset,whence);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of lseek. Expected _p_CdIo_t");
            }
        }
        {
            off_t * argp;
            if (SWIG_ConvertPtr(ST(1),(void **) &argp, SWIGTYPE_p_off_t,0) < 0) {
                SWIG_croak("Type error in argument 2 of lseek. Expected _p_off_t");
            }
            arg2 = *argp;
        }
        if (items > 2) {
            arg3 = (int) SvIV(ST(2));
        }
        result = cdio_lseek((CdIo_t const *)arg1,arg2,arg3);
        
        {
            off_t * resultobj = (off_t *) malloc(sizeof(off_t));
            memmove(resultobj, &result, sizeof(off_t));
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_off_t, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_read_cd) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        my_ssize_t arg2 ;
        my_ssize_t *arg3 = (my_ssize_t *) 0 ;
        char *result;
        long temp3 ;
        int argvi = 0;
        dXSARGS;
        
        arg3 = &temp3;
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: read_cd(p_cdio,i_size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of read_cd. Expected _p_CdIo_t");
            }
        }
        arg2 = (my_ssize_t) SvIV(ST(1));
        result = (char *)read_cd((CdIo_t const *)arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi),(IV) *(arg3));
            argvi++;
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_read_sectors) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        lsn_t arg2 ;
        cdio_read_mode_t arg3 ;
        my_ssize_t arg4 ;
        my_ssize_t *arg5 = (my_ssize_t *) 0 ;
        unsigned long *arg6 = (unsigned long *) 0 ;
        buf_t result;
        long temp5 ;
        unsigned long temp6 ;
        int argvi = 0;
        dXSARGS;
        
        arg5 = &temp5;
        arg6 = &temp6;
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: read_sectors(p_cdio,i_lsn,read_mode,i_size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of read_sectors. Expected _p_CdIo_t");
            }
        }
        arg2 = (lsn_t) SvIV(ST(1));
        arg3 = (cdio_read_mode_t) SvIV(ST(2));
        arg4 = (my_ssize_t) SvIV(ST(3));
        result = (buf_t)read_sectors((CdIo_t const *)arg1,arg2,(cdio_read_mode_t )arg3,arg4,arg5,arg6);
        
        {
            /* result is of type buf_t */
            ST(argvi) = sv_newmortal();
            if (result) {
                /* I don't yet know how to pick up arg4 another way.
                       THIS MEANS ARG4 MUST ALWAYS BE THE SIZE.  */
                sv_setpvn((SV*)ST(argvi++), (char *) result, arg4);
                /* Don't leak memory. return value was malloc'd by libcdio. */
                free(result);  
            } else {
                sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
            }
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi),(IV) *(arg5));
            argvi++;
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setuv(ST(argvi),(UV) *(arg6));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_read_data_bytes) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        lsn_t arg2 ;
        int16_t arg3 ;
        my_ssize_t arg4 ;
        my_ssize_t *arg5 = (my_ssize_t *) 0 ;
        unsigned long *arg6 = (unsigned long *) 0 ;
        buf_t result;
        long temp5 ;
        unsigned long temp6 ;
        int argvi = 0;
        dXSARGS;
        
        arg5 = &temp5;
        arg6 = &temp6;
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: read_data_bytes(p_cdio,i_lsn,i_blocksize,i_size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of read_data_bytes. Expected _p_CdIo_t");
            }
        }
        arg2 = (lsn_t) SvIV(ST(1));
        arg3 = (int16_t) SvIV(ST(2));
        arg4 = (my_ssize_t) SvIV(ST(3));
        result = (buf_t)read_data_bytes((CdIo_t const *)arg1,arg2,arg3,arg4,arg5,arg6);
        
        {
            /* result is of type buf_t */
            ST(argvi) = sv_newmortal();
            if (result) {
                /* I don't yet know how to pick up arg4 another way.
                       THIS MEANS ARG4 MUST ALWAYS BE THE SIZE.  */
                sv_setpvn((SV*)ST(argvi++), (char *) result, arg4);
                /* Don't leak memory. return value was malloc'd by libcdio. */
                free(result);  
            } else {
                sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
            }
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi),(IV) *(arg5));
            argvi++;
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setuv(ST(argvi),(UV) *(arg6));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_first_track_num) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_first_track_num(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_first_track_num. Expected _p_CdIo_t");
            }
        }
        result = (track_t)cdio_get_first_track_num((CdIo_t const *)arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_last_track_num) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_last_track_num(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_last_track_num. Expected _p_CdIo_t");
            }
        }
        result = (track_t)cdio_get_last_track_num((CdIo_t const *)arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_track) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        lsn_t arg2 ;
        track_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_track(p_cdio,lsn);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_track. Expected _p_CdIo_t");
            }
        }
        arg2 = (lsn_t) SvIV(ST(1));
        result = (track_t)cdio_get_track((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_track_channels) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_track_channels(p_cdio,i_track);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_track_channels. Expected _p_CdIo_t");
            }
        }
        arg2 = (track_t) SvUV(ST(1));
        result = (int)cdio_get_track_channels((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_track_copy_permit) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t arg2 ;
        track_flag_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_track_copy_permit(p_cdio,i_track);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_track_copy_permit. Expected _p_CdIo_t");
            }
        }
        arg2 = (track_t) SvUV(ST(1));
        result = (track_flag_t)cdio_get_track_copy_permit((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_track_format) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_track_format(p_cdio,i_track);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_track_format. Expected _p_CdIo_t");
            }
        }
        arg2 = (track_t) SvUV(ST(1));
        result = (char *)get_track_format((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_is_track_green) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t arg2 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: is_track_green(p_cdio,i_track);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of is_track_green. Expected _p_CdIo_t");
            }
        }
        arg2 = (track_t) SvUV(ST(1));
        result = (bool)cdio_get_track_green((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_track_last_lsn) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t arg2 ;
        lsn_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_track_last_lsn(p_cdio,i_track);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_track_last_lsn. Expected _p_CdIo_t");
            }
        }
        arg2 = (track_t) SvUV(ST(1));
        result = (lsn_t)cdio_get_track_last_lsn((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_track_lba) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t arg2 ;
        lba_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_track_lba(p_cdio,i_track);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_track_lba. Expected _p_CdIo_t");
            }
        }
        arg2 = (track_t) SvUV(ST(1));
        result = (lba_t)cdio_get_track_lba((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_track_lsn) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t arg2 ;
        lsn_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_track_lsn(p_cdio,i_track);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_track_lsn. Expected _p_CdIo_t");
            }
        }
        arg2 = (track_t) SvUV(ST(1));
        result = (lsn_t)cdio_get_track_lsn((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_track_msf) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_track_msf(p_cdio,i_track);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_track_msf. Expected _p_CdIo_t");
            }
        }
        arg2 = (track_t) SvUV(ST(1));
        result = (char *)get_track_msf((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_track_preemphasis) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t arg2 ;
        track_flag_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_track_preemphasis(p_cdio,i_track);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_track_preemphasis. Expected _p_CdIo_t");
            }
        }
        arg2 = (track_t) SvUV(ST(1));
        result = (track_flag_t)cdio_get_track_preemphasis((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_track_sec_count) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t arg2 ;
        unsigned int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_track_sec_count(p_cdio,i_track);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_track_sec_count. Expected _p_CdIo_t");
            }
        }
        arg2 = (track_t) SvUV(ST(1));
        result = (unsigned int)cdio_get_track_sec_count((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_close_tray) {
    {
        char *arg1 = (char *) 0 ;
        driver_id_t arg2 ;
        driver_id_t *arg3 = (driver_id_t *) 0 ;
        driver_return_code_t result;
        unsigned int temp3 ;
        int argvi = 0;
        dXSARGS;
        
        arg3 = &temp3;
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: close_tray(psz_drive,p_driver_id);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        arg2 = (driver_id_t) SvUV(ST(1));
        result = (driver_return_code_t)close_tray((char const *)arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setuv(ST(argvi),(UV) *(arg3));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_close) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: close(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of close. Expected _p_CdIo_t");
            }
        }
        cdio_destroy(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_driver_errmsg) {
    {
        driver_return_code_t arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: driver_errmsg(drc);");
        }
        arg1 = (driver_return_code_t) SvIV(ST(0));
        result = (char *)driver_errmsg(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_eject_media) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        driver_return_code_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: eject_media(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of eject_media. Expected _p_CdIo_t");
            }
        }
        result = (driver_return_code_t)eject_media(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_eject_media_drive) {
    {
        char *arg1 = (char *) NULL ;
        driver_return_code_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 1)) {
            SWIG_croak("Usage: eject_media_drive(psz_drive);");
        }
        if (items > 0) {
            if (!SvOK((SV*) ST(0))) arg1 = 0;
            else arg1 = (char *) SvPV(ST(0), PL_na);
        }
        result = (driver_return_code_t)cdio_eject_media_drive((char const *)arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_arg) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        char *arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_arg(p_cdio,key);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_arg. Expected _p_CdIo_t");
            }
        }
        arg2 = SvPV(ST(1),PL_na);
        
        result = (char *)cdio_get_arg((CdIo_t const *)arg1,(char const (*))arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_device) {
    {
        CdIo_t *arg1 = (CdIo_t *) NULL ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 1)) {
            SWIG_croak("Usage: get_device(p_cdio);");
        }
        if (items > 0) {
            {
                if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                    SWIG_croak("Type error in argument 1 of get_device. Expected _p_CdIo_t");
                }
            }
        }
        result = (char *)cdio_get_default_device((CdIo_t const *)arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_default_device_driver) {
    {
        driver_id_t arg1 ;
        driver_id_t *arg2 = (driver_id_t *) 0 ;
        char *result;
        unsigned int temp2 ;
        int argvi = 0;
        dXSARGS;
        
        arg2 = &temp2;
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_default_device_driver(p_driver_id);");
        }
        arg1 = (driver_id_t) SvUV(ST(0));
        result = (char *)get_default_device_driver(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setuv(ST(argvi),(UV) *(arg2));
            argvi++;
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_devices) {
    {
        driver_id_t arg1 ;
        DeviceList_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_devices(driver_id);");
        }
        arg1 = (driver_id_t) SvUV(ST(0));
        result = (DeviceList_t)cdio_get_devices(arg1);
        
        {
            // result is of type DeviceList_t
            char **p   = result;
            unsigned int num = 0;
            
            if (!result) goto out;
            
            /* Figure out how many items in the array */
            for (p = result; *p; p++) {
                num++;
            }
            
            /* For each element in the array of strings, create a new
                 * mortalscalar, and stuff it into the above array. */
            for (p = result; *p; p++) {
                /* Have perl compute the length of the string using strlen() */
                XPUSHs(sv_2mortal(newSVpv(*p, 0)));
            }
            argvi += num;
            cdio_free_device_list(result);
            out: ;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_devices_ret) {
    {
        driver_id_t arg1 ;
        driver_id_t *arg2 = (driver_id_t *) 0 ;
        DeviceList_t result;
        unsigned int temp2 ;
        int argvi = 0;
        dXSARGS;
        
        arg2 = &temp2;
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_devices_ret(driver_id);");
        }
        arg1 = (driver_id_t) SvUV(ST(0));
        result = (DeviceList_t)get_devices_ret(arg1,arg2);
        
        {
            // result is of type DeviceList_t
            char **p   = result;
            unsigned int num = 0;
            
            if (!result) goto out;
            
            /* Figure out how many items in the array */
            for (p = result; *p; p++) {
                num++;
            }
            
            /* For each element in the array of strings, create a new
                 * mortalscalar, and stuff it into the above array. */
            for (p = result; *p; p++) {
                /* Have perl compute the length of the string using strlen() */
                XPUSHs(sv_2mortal(newSVpv(*p, 0)));
            }
            argvi += num;
            cdio_free_device_list(result);
            out: ;
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setuv(ST(argvi),(UV) *(arg2));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_devices_with_cap) {
    {
        unsigned int arg1 ;
        bool arg2 ;
        DeviceList_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_devices_with_cap(capabilities,b_any);");
        }
        arg1 = (unsigned int) SvUV(ST(0));
        arg2 = (bool) SvIV(ST(1));
        result = (DeviceList_t)get_devices_with_cap(arg1,arg2);
        
        {
            // result is of type DeviceList_t
            char **p   = result;
            unsigned int num = 0;
            
            if (!result) goto out;
            
            /* Figure out how many items in the array */
            for (p = result; *p; p++) {
                num++;
            }
            
            /* For each element in the array of strings, create a new
                 * mortalscalar, and stuff it into the above array. */
            for (p = result; *p; p++) {
                /* Have perl compute the length of the string using strlen() */
                XPUSHs(sv_2mortal(newSVpv(*p, 0)));
            }
            argvi += num;
            cdio_free_device_list(result);
            out: ;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_devices_with_cap_ret) {
    {
        unsigned int arg1 ;
        bool arg2 ;
        driver_id_t *arg3 = (driver_id_t *) 0 ;
        DeviceList_t result;
        unsigned int temp3 ;
        int argvi = 0;
        dXSARGS;
        
        arg3 = &temp3;
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: get_devices_with_cap_ret(capabilities,b_any);");
        }
        arg1 = (unsigned int) SvUV(ST(0));
        arg2 = (bool) SvIV(ST(1));
        result = (DeviceList_t)get_devices_with_cap_ret(arg1,arg2,arg3);
        
        {
            // result is of type DeviceList_t
            char **p   = result;
            unsigned int num = 0;
            
            if (!result) goto out;
            
            /* Figure out how many items in the array */
            for (p = result; *p; p++) {
                num++;
            }
            
            /* For each element in the array of strings, create a new
                 * mortalscalar, and stuff it into the above array. */
            for (p = result; *p; p++) {
                /* Have perl compute the length of the string using strlen() */
                XPUSHs(sv_2mortal(newSVpv(*p, 0)));
            }
            argvi += num;
            cdio_free_device_list(result);
            out: ;
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setuv(ST(argvi),(UV) *(arg3));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_drive_cap__SWIG_0) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        unsigned int *arg2 = (unsigned int *) 0 ;
        unsigned int *arg3 = (unsigned int *) 0 ;
        unsigned int *arg4 = (unsigned int *) 0 ;
        unsigned int temp2 ;
        unsigned int temp3 ;
        unsigned int temp4 ;
        int argvi = 0;
        dXSARGS;
        
        arg2 = &temp2;
        arg3 = &temp3;
        arg4 = &temp4;
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_drive_cap(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_drive_cap. Expected _p_CdIo_t");
            }
        }
        cdio_get_drive_cap((CdIo_t const *)arg1,arg2,arg3,arg4);
        
        
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setuv(ST(argvi),(UV) *(arg2));
            argvi++;
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setuv(ST(argvi),(UV) *(arg3));
            argvi++;
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setuv(ST(argvi),(UV) *(arg4));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_drive_cap__SWIG_1) {
    {
        char *arg1 = (char *) NULL ;
        unsigned int *arg2 = (unsigned int *) 0 ;
        unsigned int *arg3 = (unsigned int *) 0 ;
        unsigned int *arg4 = (unsigned int *) 0 ;
        unsigned int temp2 ;
        unsigned int temp3 ;
        unsigned int temp4 ;
        int argvi = 0;
        dXSARGS;
        
        arg2 = &temp2;
        arg3 = &temp3;
        arg4 = &temp4;
        if ((items < 0) || (items > 1)) {
            SWIG_croak("Usage: get_drive_cap(device);");
        }
        if (items > 0) {
            if (!SvOK((SV*) ST(0))) arg1 = 0;
            else arg1 = (char *) SvPV(ST(0), PL_na);
        }
        cdio_get_drive_cap_dev((char const *)arg1,arg2,arg3,arg4);
        
        
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setuv(ST(argvi),(UV) *(arg2));
            argvi++;
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setuv(ST(argvi),(UV) *(arg3));
            argvi++;
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setuv(ST(argvi),(UV) *(arg4));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_drive_cap) {
    dXSARGS;
    
    if ((items >= 0) && (items <= 1)) {
        int _v;
        if (items <= 0) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_get_drive_cap__SWIG_1); return;
        }
        {
            _v = SvPOK(ST(0)) ? 1 : 0;
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_get_drive_cap__SWIG_1); return;
        }
    }
    if (items == 1) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_CdIo_t, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_get_drive_cap__SWIG_0); return;
        }
    }
    
    croak("No matching function for overloaded 'get_drive_cap'");
    XSRETURN(0);
}


XS(_wrap_get_driver_name) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_driver_name(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_driver_name. Expected _p_CdIo_t");
            }
        }
        result = (char *)cdio_get_driver_name((CdIo_t const *)arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_driver_id) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        driver_id_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_driver_id(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_driver_id. Expected _p_CdIo_t");
            }
        }
        result = (driver_id_t)cdio_get_driver_id((CdIo_t const *)arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_last_session) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        lsn_t *arg2 = (lsn_t *) 0 ;
        driver_return_code_t result;
        int temp2 ;
        int argvi = 0;
        dXSARGS;
        
        arg2 = &temp2;
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_last_session(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_last_session. Expected _p_CdIo_t");
            }
        }
        result = (driver_return_code_t)cdio_get_last_session(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi),(IV) *(arg2));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_have_driver) {
    {
        unsigned int arg1 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: have_driver(driver_id);");
        }
        arg1 = (unsigned int) SvUV(ST(0));
        result = (int)have_driver(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_have_ATAPI) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: have_ATAPI(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of have_ATAPI. Expected _p_CdIo_t");
            }
        }
        result = (bool)have_ATAPI(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_is_binfile) {
    {
        char *arg1 = (char *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: is_binfile(bin_name);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)cdio_is_binfile((char const *)arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_is_cuefile) {
    {
        char *arg1 = (char *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: is_cuefile(cue_name);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)cdio_is_cuefile((char const *)arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_is_device) {
    {
        char *arg1 = (char *) 0 ;
        driver_id_t arg2 = (driver_id_t) DRIVER_UNKNOWN ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: is_device(psz_source,driver_id);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (items > 1) {
            arg2 = (driver_id_t) SvUV(ST(1));
        }
        result = (bool)is_device((char const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_is_nrg) {
    {
        char *arg1 = (char *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: is_nrg(nrg_name);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (bool)cdio_is_nrg((char const *)arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_is_tocfile) {
    {
        char *arg1 = (char *) 0 ;
        bool result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: is_tocfile(tocfile_name);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (bool)cdio_is_tocfile((char const *)arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_media_changed) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_media_changed(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_media_changed. Expected _p_CdIo_t");
            }
        }
        result = (int)cdio_get_media_changed(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_hwinfo) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        int *arg2 = (int *) 0 ;
        HWInfo_t result;
        int temp2 ;
        int argvi = 0;
        dXSARGS;
        
        arg2 = &temp2;
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_hwinfo(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_hwinfo. Expected _p_CdIo_t");
            }
        }
        result = (HWInfo_t)get_hwinfo((CdIo_t const *)arg1,arg2);
        
        {
            // All functions returning char ** 
            // get this typemap
            // result is of type char **
            char **p   = result;
            unsigned int num = 0;
            
            /* Figure out how many items in the array */
            for (p = result; *p; p++) {
                num++;
            }
            
            if (argvi >= items) {
                /* Extend the stack by num objects */
                EXTEND(sp, num);
            }
            /* For each element in the array of strings, create a new
                 * mortalscalar, and stuff it into the above array. */
            for (p = result; *p; p++) {
                /* Have perl compute the length of the string using strlen() */
                PUSHs(sv_2mortal(newSVpv(*p, 0)));
            }
            /* FIXME: the + 1 is because p_cdio is still on the stack. */
            argvi += num + 1;
        }
        {
            if (argvi >= items) {
                EXTEND(sp,1);
            }
            ST(argvi) = sv_newmortal();
            sv_setiv(ST(argvi),(IV) *(arg2));
            argvi++;
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_set_blocksize) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        int arg2 ;
        driver_return_code_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: set_blocksize(p_cdio,i_blocksize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of set_blocksize. Expected _p_CdIo_t");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (driver_return_code_t)cdio_set_blocksize((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_set_speed) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        int arg2 ;
        driver_return_code_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: set_speed(p_cdio,i_speed);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of set_speed. Expected _p_CdIo_t");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (driver_return_code_t)cdio_set_speed((CdIo_t const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_open_cd) {
    {
        char *arg1 = (char *) NULL ;
        driver_id_t arg2 = (driver_id_t) DRIVER_UNKNOWN ;
        char *arg3 = (char *) NULL ;
        CdIo_t *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 3)) {
            SWIG_croak("Usage: open_cd(psz_source,driver_id,psz_access_mode);");
        }
        if (items > 0) {
            if (!SvOK((SV*) ST(0))) arg1 = 0;
            else arg1 = (char *) SvPV(ST(0), PL_na);
        }
        if (items > 1) {
            arg2 = (driver_id_t) SvUV(ST(1));
        }
        if (items > 2) {
            if (!SvOK((SV*) ST(2))) arg3 = 0;
            else arg3 = (char *) SvPV(ST(2), PL_na);
        }
        result = (CdIo_t *)cdio_open_am((char const *)arg1,arg2,(char const *)arg3);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_CdIo_t, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_disc_last_lsn) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        lsn_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_disc_last_lsn(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_disc_last_lsn. Expected _p_CdIo_t");
            }
        }
        result = (lsn_t)cdio_get_disc_last_lsn((CdIo_t const *)arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_disc_mode) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_disc_mode(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_disc_mode. Expected _p_CdIo_t");
            }
        }
        result = (char *)get_disc_mode(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_joliet_level) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_joliet_level(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_joliet_level. Expected _p_CdIo_t");
            }
        }
        result = (int)cdio_get_joliet_level((CdIo_t const *)arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_mcn) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_mcn(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_mcn. Expected _p_CdIo_t");
            }
        }
        result = (char *)cdio_get_mcn((CdIo_t const *)arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_get_num_tracks) {
    {
        CdIo_t *arg1 = (CdIo_t *) 0 ;
        track_t result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: get_num_tracks(p_cdio);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_CdIo_t,0) < 0) {
                SWIG_croak("Type error in argument 1 of get_num_tracks. Expected _p_CdIo_t");
            }
        }
        result = (track_t)cdio_get_num_tracks((CdIo_t const *)arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setuv(ST(argvi++), (UV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_cdio_read_mode_t[] = {{"_p_cdio_read_mode_t", 0, "enum cdio_read_mode_t *|cdio_read_mode_t *", 0, 0, 0, 0},{"_p_cdio_read_mode_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_CdIo_t[] = {{"_p_CdIo_t", 0, "CdIo_t *", 0, 0, 0, 0},{"_p_CdIo_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_unsigned_long[] = {{"_p_unsigned_long", 0, "unsigned long *", 0, 0, 0, 0},{"_p_unsigned_long", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_char[] = {{"_p_char", 0, "char *", 0, 0, 0, 0},{"_p_char", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_long[] = {{"_p_long", 0, "long *|my_ssize_t *", 0, 0, 0, 0},{"_p_long", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_cdio_hwinfo_t[] = {{"_p_cdio_hwinfo_t", 0, "cdio_hwinfo_t *", 0, 0, 0, 0},{"_p_cdio_hwinfo_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_unsigned_int[] = {{"_p_unsigned_int", 0, "unsigned int *", 0, 0, 0, 0},{"_p_unsigned_int", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_int[] = {{"_p_int", 0, "int *", 0, 0, 0, 0},{"_p_int", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_off_t[] = {{"_p_off_t", 0, "off_t *", 0, 0, 0, 0},{"_p_off_t", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_cdio_read_mode_t, 
_swigt__p_CdIo_t, 
_swigt__p_unsigned_long, 
_swigt__p_char, 
_swigt__p_long, 
_swigt__p_cdio_hwinfo_t, 
_swigt__p_unsigned_int, 
_swigt__p_int, 
_swigt__p_off_t, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_constant_info swig_constants[] = {
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_READ_MODE_AUDIO", (long) CDIO_READ_MODE_AUDIO, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_READ_MODE_M1F1", (long) CDIO_READ_MODE_M1F1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_READ_MODE_M1F2", (long) CDIO_READ_MODE_M1F2, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_READ_MODE_M2F1", (long) CDIO_READ_MODE_M2F1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_READ_MODE_M2F2", (long) CDIO_READ_MODE_M2F2, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "VERSION_NUM", (long) LIBCDIO_VERSION_NUM, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "INVALID_LBA", (long) CDIO_INVALID_LBA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "INVALID_LSN", (long) CDIO_INVALID_LSN, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CD_FRAMESIZE", (long) CDIO_CD_FRAMESIZE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CD_FRAMESIZE_RAW", (long) CDIO_CD_FRAMESIZE_RAW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "ISO_BLOCKSIZE", (long) CDIO_CD_FRAMESIZE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "M2F2_SECTOR_SIZE", (long) M2F2_SECTOR_SIZE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "M2RAW_SECTOR_SIZE", (long) M2RAW_SECTOR_SIZE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "READ_MODE_AUDIO", (long) CDIO_READ_MODE_AUDIO, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "READ_MODE_M1F1", (long) CDIO_READ_MODE_M1F1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "READ_MODE_M1F2", (long) CDIO_READ_MODE_M1F2, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "READ_MODE_M2F1", (long) CDIO_READ_MODE_M2F1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "READ_MODE_M2F2", (long) CDIO_READ_MODE_M2F2, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "TRACK_FORMAT_AUDIO", (long) TRACK_FORMAT_AUDIO, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "TRACK_FORMAT_CDI", (long) TRACK_FORMAT_CDI, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "TRACK_FORMAT_XA", (long) TRACK_FORMAT_XA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "TRACK_FORMAT_DATA", (long) TRACK_FORMAT_DATA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "TRACK_FORMAT_PSX", (long) TRACK_FORMAT_PSX, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_TRACK_FLAG_FALSE", (long) CDIO_TRACK_FLAG_FALSE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_TRACK_FLAG_TRUE", (long) CDIO_TRACK_FLAG_TRUE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_TRACK_FLAG_ERROR", (long) CDIO_TRACK_FLAG_ERROR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_TRACK_FLAG_UNKNOWN", (long) CDIO_TRACK_FLAG_UNKNOWN, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_CDROM_LBA", (long) CDIO_CDROM_LBA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_CDROM_MSF", (long) CDIO_CDROM_MSF, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_CDROM_DATA_TRACK", (long) CDIO_CDROM_DATA_TRACK, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_CDROM_CDI_TRACK", (long) CDIO_CDROM_CDI_TRACK, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDIO_CDROM_XA_TRACK", (long) CDIO_CDROM_XA_TRACK, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "AUDIO", (long) AUDIO, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MODE1", (long) MODE1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MODE1_RAW", (long) MODE1_RAW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MODE2", (long) MODE2, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MODE2_FORM1", (long) MODE2_FORM1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MODE2_FORM2", (long) MODE2_FORM2, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MODE2_FORM_MIX", (long) MODE2_FORM_MIX, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MODE2_RAW", (long) MODE2_RAW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "INVALID_TRACK", (long) CDIO_INVALID_TRACK, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "CDROM_LEADOUT_TRACK", (long) 0xAA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_ERROR", (long) CDIO_DRIVE_CAP_ERROR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_UNKNOWN", (long) CDIO_DRIVE_CAP_UNKNOWN, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_MISC_CLOSE_TRAY", (long) CDIO_DRIVE_CAP_MISC_CLOSE_TRAY, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_MISC_EJECT", (long) CDIO_DRIVE_CAP_MISC_EJECT, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_MISC_LOCK", (long) CDIO_DRIVE_CAP_MISC_LOCK, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_MISC_SELECT_SPEED", (long) CDIO_DRIVE_CAP_MISC_SELECT_SPEED, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_MISC_SELECT_DISC", (long) CDIO_DRIVE_CAP_MISC_SELECT_DISC, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_MISC_MULTI_SESSION", (long) CDIO_DRIVE_CAP_MISC_MULTI_SESSION, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_MISC_MEDIA_CHANGED", (long) CDIO_DRIVE_CAP_MISC_MEDIA_CHANGED, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_MISC_RESET", (long) CDIO_DRIVE_CAP_MISC_RESET, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_MISC_FILE", (long) CDIO_DRIVE_CAP_MISC_FILE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_AUDIO", (long) CDIO_DRIVE_CAP_READ_AUDIO, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_CD_DA", (long) CDIO_DRIVE_CAP_READ_CD_DA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_CD_G", (long) CDIO_DRIVE_CAP_READ_CD_G, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_CD_R", (long) CDIO_DRIVE_CAP_READ_CD_R, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_CD_RW", (long) CDIO_DRIVE_CAP_READ_CD_RW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_DVD_R", (long) CDIO_DRIVE_CAP_READ_DVD_R, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_DVD_PR", (long) CDIO_DRIVE_CAP_READ_DVD_PR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_DVD_RAM", (long) CDIO_DRIVE_CAP_READ_DVD_RAM, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_DVD_ROM", (long) CDIO_DRIVE_CAP_READ_DVD_ROM, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_DVD_RW", (long) CDIO_DRIVE_CAP_READ_DVD_RW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_DVD_RPW", (long) CDIO_DRIVE_CAP_READ_DVD_RPW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_C2_ERRS", (long) CDIO_DRIVE_CAP_READ_C2_ERRS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_MODE2_FORM1", (long) CDIO_DRIVE_CAP_READ_MODE2_FORM1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_MODE2_FORM2", (long) CDIO_DRIVE_CAP_READ_MODE2_FORM2, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_MCN", (long) CDIO_DRIVE_CAP_READ_MCN, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_READ_ISRC", (long) CDIO_DRIVE_CAP_READ_ISRC, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_WRITE_CD_R", (long) CDIO_DRIVE_CAP_WRITE_CD_R, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_WRITE_CD_RW", (long) CDIO_DRIVE_CAP_WRITE_CD_RW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_WRITE_DVD_R", (long) CDIO_DRIVE_CAP_WRITE_DVD_R, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_WRITE_DVD_PR", (long) CDIO_DRIVE_CAP_WRITE_DVD_PR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_WRITE_DVD_RAM", (long) CDIO_DRIVE_CAP_WRITE_DVD_RAM, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_WRITE_DVD_RW", (long) CDIO_DRIVE_CAP_WRITE_DVD_RW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_WRITE_DVD_RPW", (long) CDIO_DRIVE_CAP_WRITE_DVD_RPW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_WRITE_MT_RAINIER", (long) CDIO_DRIVE_CAP_WRITE_MT_RAINIER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_WRITE_BURN_PROOF", (long) CDIO_DRIVE_CAP_WRITE_BURN_PROOF, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_WRITE_CD", (long) CDIO_DRIVE_CAP_WRITE_CD, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_WRITE_DVD", (long) CDIO_DRIVE_CAP_WRITE_DVD, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVE_CAP_WRITE", (long) CDIO_DRIVE_CAP_WRITE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MMC_HW_VENDOR_LEN", (long) CDIO_MMC_HW_VENDOR_LEN, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MMC_HW_MODEL_LEN", (long) CDIO_MMC_HW_MODEL_LEN, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MMC_HW_REVISION_LEN", (long) CDIO_MMC_HW_REVISION_LEN, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "SRC_IS_DISK_IMAGE_MASK", (long) CDIO_SRC_IS_DISK_IMAGE_MASK, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "SRC_IS_DEVICE_MASK", (long) CDIO_SRC_IS_DEVICE_MASK, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "SRC_IS_SCSI_MASK", (long) CDIO_SRC_IS_SCSI_MASK, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "SRC_IS_NATIVE_MASK", (long) CDIO_SRC_IS_NATIVE_MASK, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_UNKNOWN", (long) DRIVER_UNKNOWN, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_AIX", (long) DRIVER_AIX, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_BSDI", (long) DRIVER_BSDI, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_FREEBSD", (long) DRIVER_FREEBSD, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_LINUX", (long) DRIVER_LINUX, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_SOLARIS", (long) DRIVER_SOLARIS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_OSX", (long) DRIVER_OSX, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_WIN32", (long) DRIVER_WIN32, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_CDRDAO", (long) DRIVER_CDRDAO, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_BINCUE", (long) DRIVER_BINCUE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_NRG", (long) DRIVER_NRG, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_DEVICE", (long) DRIVER_DEVICE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MIN_DRIVER", (long) CDIO_MIN_DRIVER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MIN_DEVICE_DRIVER", (long) CDIO_MIN_DEVICE_DRIVER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MAX_DRIVER", (long) CDIO_MAX_DRIVER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MAX_DEVICE_DRIVER", (long) CDIO_MAX_DEVICE_DRIVER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_OP_SUCCESS", (long) DRIVER_OP_SUCCESS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_OP_ERROR", (long) DRIVER_OP_ERROR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_OP_UNSUPPORTED", (long) DRIVER_OP_UNSUPPORTED, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_OP_UNINIT", (long) DRIVER_OP_UNINIT, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_OP_NOT_PERMITTED", (long) DRIVER_OP_NOT_PERMITTED, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_OP_BAD_PARAMETER", (long) DRIVER_OP_BAD_PARAMETER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_OP_BAD_POINTER", (long) DRIVER_OP_BAD_POINTER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DRIVER_OP_NO_DRIVER", (long) DRIVER_OP_NO_DRIVER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_AUDIO", (long) CDIO_FS_AUDIO, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_HIGH_SIERRA", (long) CDIO_FS_HIGH_SIERRA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ISO_9660", (long) CDIO_FS_ISO_9660, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_INTERACTIVE", (long) CDIO_FS_INTERACTIVE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_HFS", (long) CDIO_FS_HFS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_UFS", (long) CDIO_FS_UFS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_EXT2", (long) CDIO_FS_EXT2, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ISO_HFS", (long) CDIO_FS_ISO_HFS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ISO_9660_INTERACTIVE", (long) CDIO_FS_ISO_9660_INTERACTIVE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_3DO", (long) CDIO_FS_3DO, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_XISO", (long) CDIO_FS_XISO, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_UDFX", (long) CDIO_FS_UDFX, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_UDF", (long) CDIO_FS_UDF, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ISO_UDF", (long) CDIO_FS_ISO_UDF, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ANAL_XA", (long) CDIO_FS_ANAL_XA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ANAL_MULTISESSION", (long) CDIO_FS_ANAL_MULTISESSION, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ANAL_PHOTO_CD", (long) CDIO_FS_ANAL_PHOTO_CD, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ANAL_HIDDEN_TRACK", (long) CDIO_FS_ANAL_HIDDEN_TRACK, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ANAL_CDTV", (long) CDIO_FS_ANAL_CDTV, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ANAL_BOOTABLE", (long) CDIO_FS_ANAL_BOOTABLE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ANAL_VIDEOCD", (long) CDIO_FS_ANAL_VIDEOCD, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ANAL_ROCKRIDGE", (long) CDIO_FS_ANAL_ROCKRIDGE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ANAL_JOLIET", (long) CDIO_FS_ANAL_JOLIET, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ANAL_SVCD", (long) CDIO_FS_ANAL_SVCD, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ANAL_CVD", (long) CDIO_FS_ANAL_CVD, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_ANAL_XISO", (long) CDIO_FS_ANAL_XISO, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_MATCH_ALL", (long) CDIO_FS_MATCH_ALL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FS_UNKNOWN", (long) CDIO_FS_UNKNOWN, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_CD_DA", (long) CDIO_DISC_MODE_CD_DA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_CD_DATA", (long) CDIO_DISC_MODE_CD_DATA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_CD_XA", (long) CDIO_DISC_MODE_CD_XA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_CD_MIXED", (long) CDIO_DISC_MODE_CD_MIXED, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_DVD_ROM", (long) CDIO_DISC_MODE_DVD_ROM, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_DVD_RAM", (long) CDIO_DISC_MODE_DVD_RAM, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_DVD_R", (long) CDIO_DISC_MODE_DVD_R, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_DVD_RW", (long) CDIO_DISC_MODE_DVD_RW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_DVD_PR", (long) CDIO_DISC_MODE_DVD_PR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_DVD_PRW", (long) CDIO_DISC_MODE_DVD_PRW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_DVD_OTHER", (long) CDIO_DISC_MODE_DVD_OTHER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_NO_INFO", (long) CDIO_DISC_MODE_NO_INFO, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_ERROR", (long) CDIO_DISC_MODE_ERROR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "DISC_MODE_CD_I", (long) CDIO_DISC_MODE_CD_I, 0, 0, 0},
{0,0,0,0,0,0}
};
#ifdef __cplusplus
}
#endif
static swig_variable_info swig_variables[] = {
    { "perlcdioc::hw_info", MAGIC_CLASS _wrap_set_hw_info, MAGIC_CLASS _wrap_val_hw_info,&SWIGTYPE_p_cdio_hwinfo_t },
{0,0,0,0}
};
static swig_command_info swig_commands[] = {
{"perlcdioc::cdio_read_sectors", _wrap_cdio_read_sectors},
{"perlcdioc::cdio_eject_media_drive", _wrap_cdio_eject_media_drive},
{"perlcdioc::audio_pause", _wrap_audio_pause},
{"perlcdioc::audio_play_lsn", _wrap_audio_play_lsn},
{"perlcdioc::audio_resume", _wrap_audio_resume},
{"perlcdioc::audio_stop", _wrap_audio_stop},
{"perlcdioc::lseek", _wrap_lseek},
{"perlcdioc::read_cd", _wrap_read_cd},
{"perlcdioc::read_sectors", _wrap_read_sectors},
{"perlcdioc::read_data_bytes", _wrap_read_data_bytes},
{"perlcdioc::get_first_track_num", _wrap_get_first_track_num},
{"perlcdioc::get_last_track_num", _wrap_get_last_track_num},
{"perlcdioc::get_track", _wrap_get_track},
{"perlcdioc::get_track_channels", _wrap_get_track_channels},
{"perlcdioc::get_track_copy_permit", _wrap_get_track_copy_permit},
{"perlcdioc::get_track_format", _wrap_get_track_format},
{"perlcdioc::is_track_green", _wrap_is_track_green},
{"perlcdioc::get_track_last_lsn", _wrap_get_track_last_lsn},
{"perlcdioc::get_track_lba", _wrap_get_track_lba},
{"perlcdioc::get_track_lsn", _wrap_get_track_lsn},
{"perlcdioc::get_track_msf", _wrap_get_track_msf},
{"perlcdioc::get_track_preemphasis", _wrap_get_track_preemphasis},
{"perlcdioc::get_track_sec_count", _wrap_get_track_sec_count},
{"perlcdioc::close_tray", _wrap_close_tray},
{"perlcdioc::close", _wrap_close},
{"perlcdioc::driver_errmsg", _wrap_driver_errmsg},
{"perlcdioc::eject_media", _wrap_eject_media},
{"perlcdioc::eject_media_drive", _wrap_eject_media_drive},
{"perlcdioc::get_arg", _wrap_get_arg},
{"perlcdioc::get_device", _wrap_get_device},
{"perlcdioc::get_default_device_driver", _wrap_get_default_device_driver},
{"perlcdioc::get_devices", _wrap_get_devices},
{"perlcdioc::get_devices_ret", _wrap_get_devices_ret},
{"perlcdioc::get_devices_with_cap", _wrap_get_devices_with_cap},
{"perlcdioc::get_devices_with_cap_ret", _wrap_get_devices_with_cap_ret},
{"perlcdioc::get_drive_cap", _wrap_get_drive_cap},
{"perlcdioc::get_driver_name", _wrap_get_driver_name},
{"perlcdioc::get_driver_id", _wrap_get_driver_id},
{"perlcdioc::get_last_session", _wrap_get_last_session},
{"perlcdioc::have_driver", _wrap_have_driver},
{"perlcdioc::have_ATAPI", _wrap_have_ATAPI},
{"perlcdioc::is_binfile", _wrap_is_binfile},
{"perlcdioc::is_cuefile", _wrap_is_cuefile},
{"perlcdioc::is_device", _wrap_is_device},
{"perlcdioc::is_nrg", _wrap_is_nrg},
{"perlcdioc::is_tocfile", _wrap_is_tocfile},
{"perlcdioc::get_media_changed", _wrap_get_media_changed},
{"perlcdioc::get_hwinfo", _wrap_get_hwinfo},
{"perlcdioc::set_blocksize", _wrap_set_blocksize},
{"perlcdioc::set_speed", _wrap_set_speed},
{"perlcdioc::open_cd", _wrap_open_cd},
{"perlcdioc::get_disc_last_lsn", _wrap_get_disc_last_lsn},
{"perlcdioc::get_disc_mode", _wrap_get_disc_mode},
{"perlcdioc::get_joliet_level", _wrap_get_joliet_level},
{"perlcdioc::get_mcn", _wrap_get_mcn},
{"perlcdioc::get_num_tracks", _wrap_get_num_tracks},
{0,0}
};


static void SWIG_Perl_SetTypeListHandle(swig_type_info **handle) {
    SV *pointer;
    
    /* create a new pointer */
    pointer = get_sv("swig_runtime_data::type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, TRUE);
    sv_setiv(pointer, PTR2IV(swig_type_list_handle));
}

static swig_type_info **
SWIG_Perl_LookupTypePointer(swig_type_info **type_list_handle) {
    swig_type_info **type_pointer;
    
    /* first check if module already created */
    type_pointer = SWIG_Perl_GetTypeListHandle();
    if (type_pointer) {
        return type_pointer;
    } else {
        /* create a new module and variable */
        SWIG_Perl_SetTypeListHandle(type_list_handle);
        return type_list_handle;
    }
}


#ifdef __cplusplus
extern "C"
#endif

XS(SWIG_init) {
    dXSARGS;
    int i;
    static int _init = 0;
    if (!_init) {
        swig_type_list_handle = SWIG_Perl_LookupTypePointer(swig_type_list_handle);
        for (i = 0; swig_types_initial[i]; i++) {
            swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        }	
        _init = 1;
    }
    
    /* Install commands */
    for (i = 0; swig_commands[i].name; i++) {
        newXS((char*) swig_commands[i].name,swig_commands[i].wrapper, (char*)__FILE__);
    }
    
    /* Install variables */
    for (i = 0; swig_variables[i].name; i++) {
        SV *sv;
        sv = perl_get_sv((char*) swig_variables[i].name, TRUE | 0x2);
        if (swig_variables[i].type) {
            SWIG_MakePtr(sv,(void *)1, *swig_variables[i].type,0);
        } else {
            sv_setiv(sv,(IV) 0);
        }
        swig_create_magic(sv, (char *) swig_variables[i].name, swig_variables[i].set, swig_variables[i].get); 
    }
    
    /* Install constant */
    for (i = 0; swig_constants[i].type; i++) {
        SV *sv;
        sv = perl_get_sv((char*)swig_constants[i].name, TRUE | 0x2);
        switch(swig_constants[i].type) {
            case SWIG_INT:
            sv_setiv(sv, (IV) swig_constants[i].lvalue);
            break;
            case SWIG_FLOAT:
            sv_setnv(sv, (double) swig_constants[i].dvalue);
            break;
            case SWIG_STRING:
            sv_setpv(sv, (char *) swig_constants[i].pvalue);
            break;
            case SWIG_POINTER:
            SWIG_MakePtr(sv, swig_constants[i].pvalue, *(swig_constants[i].ptype),0);
            break;
            case SWIG_BINARY:
            SWIG_MakePackedObj(sv, swig_constants[i].pvalue, swig_constants[i].lvalue, *(swig_constants[i].ptype));
            break;
            default:
            break;
        }
        SvREADONLY_on(sv);
    }
    
    ST(0) = &PL_sv_yes;
    XSRETURN(1);
}

