/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionFactory;
import edu.stanford.nlp.util.MapFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    private CollectionUtils() {
    }

    public static List<Integer> asList(int[] a) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < a.length; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static List<Double> asList(double[] a) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < a.length; ++i) {
            result.add(new Double(a[i]));
        }
        return result;
    }

    public static List<Object> asList(Object ... args) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < args.length; ++i) {
            result.add(args[i]);
        }
        return result;
    }

    public static <T> List<T> makeList(T e) {
        ArrayList<T> s = new ArrayList<T>();
        s.add(e);
        return s;
    }

    public static <T> List<T> makeList(T e1, T e2) {
        ArrayList<T> s = new ArrayList<T>();
        s.add(e1);
        s.add(e2);
        return s;
    }

    public static <T> List<T> makeList(T e1, T e2, T e3) {
        ArrayList<T> s = new ArrayList<T>();
        s.add(e1);
        s.add(e2);
        s.add(e3);
        return s;
    }

    public static <T> Set<T> asSet(T[] o) {
        return new HashSet<T>(Arrays.asList(o));
    }

    public static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        HashSet<T> intersect = new HashSet<T>();
        for (T t : set1) {
            if (!set2.contains(t)) continue;
            intersect.add(t);
        }
        return intersect;
    }

    public static <T> Collection<T> union(Collection<T> set1, Collection<T> set2) {
        ArrayList<T> union = new ArrayList<T>();
        for (T t : set1) {
            union.add(t);
        }
        for (T t : set2) {
            union.add(t);
        }
        return union;
    }

    public static <T> Collection<T> diff(Collection<T> list1, Collection<T> list2) {
        ArrayList<T> diff = new ArrayList<T>();
        for (T t : list1) {
            if (list2.contains(t)) continue;
            diff.add(t);
        }
        return diff;
    }

    public static <T> Collection<T> loadCollection(String filename, Class<T> c, CollectionFactory<T> cf) throws Exception {
        return CollectionUtils.loadCollection(new File(filename), c, cf);
    }

    public static <T> Collection<T> loadCollection(File file, Class<T> c, CollectionFactory<T> cf) throws Exception {
        Constructor<T> m = c.getConstructor(Class.forName("java.lang.String"));
        Collection<T> result = cf.newCollection();
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = in.readLine();
        while (line != null && line.length() > 0) {
            try {
                T o = m.newInstance(line);
                result.add(o);
            }
            catch (Exception e) {
                System.err.println("Couldn't build object from line: " + line);
                e.printStackTrace();
            }
            line = in.readLine();
        }
        in.close();
        return result;
    }

    public static <T> void loadCollection(String fileName, Class<T> itemClass, Collection<T> collection) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        CollectionUtils.loadCollection(new File(fileName), itemClass, collection);
    }

    public static <T> void loadCollection(File file, Class<T> itemClass, Collection<T> collection) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        Constructor<T> itemConstructor = itemClass.getConstructor(String.class);
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = in.readLine();
        while (line != null && line.length() > 0) {
            T t = itemConstructor.newInstance(line);
            collection.add(t);
            line = in.readLine();
        }
        in.close();
    }

    public static <K, V> Map<K, V> getMapFromString(String s, Class<K> keyClass, Class<V> valueClass, MapFactory<K, V> mapFactory) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<K> keyC = keyClass.getConstructor(Class.forName("java.lang.String"));
        Constructor<V> valueC = valueClass.getConstructor(Class.forName("java.lang.String"));
        if (s.charAt(0) != '{') {
            throw new RuntimeException("");
        }
        s = s.substring(1);
        String[] fields = s.split("\\s+");
        Map<K, V> m = mapFactory.newMap();
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = fields[i].substring(0, fields[i].length() - 1);
            String[] a = fields[i].split("=");
            K key = keyC.newInstance(a[0]);
            V value = a.length > 1 ? valueC.newInstance(a[1]) : valueC.newInstance("");
            m.put(key, value);
        }
        return m;
    }

    public static <T> boolean containsObject(Collection<T> c, T o) {
        for (T o1 : c) {
            if (o != o1) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean removeObject(List<T> l, T o) {
        int i = 0;
        for (T o1 : l) {
            if (o == o1) {
                l.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <T> int getIndex(List<T> l, T o) {
        int i = 0;
        for (T o1 : l) {
            if (o == o1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int getIndex(List<T> l, T o, int fromIndex) {
        int i = -1;
        for (T o1 : l) {
            if (++i < fromIndex || !o.equals(o1)) continue;
            return i;
        }
        return -1;
    }

    public static <E> Collection<E> sampleWithoutReplacement(Collection<E> c, int n) {
        return CollectionUtils.sampleWithoutReplacement(c, n, new Random());
    }

    public static <E> Collection<E> sampleWithoutReplacement(Collection<E> c, int n, Random r) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0: " + n);
        }
        if (n > c.size()) {
            throw new IllegalArgumentException("n > size of collection: " + n + ", " + c.size());
        }
        ArrayList<E> copy = new ArrayList<E>(c.size());
        copy.addAll(c);
        ArrayList result = new ArrayList(n);
        for (int k = 0; k < n; ++k) {
            double d = r.nextDouble();
            int x = (int)(d * (double)copy.size());
            result.add(copy.remove(x));
        }
        return result;
    }

    public static <E> E sample(List<E> l, Random r) {
        int i = r.nextInt(l.size());
        return l.get(i);
    }

    public static <E> Collection<E> sampleWithReplacement(Collection<E> c, int n) {
        return CollectionUtils.sampleWithReplacement(c, n, new Random());
    }

    public static <E> Collection<E> sampleWithReplacement(Collection<E> c, int n, Random r) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0: " + n);
        }
        ArrayList<E> copy = new ArrayList<E>(c.size());
        copy.addAll(c);
        ArrayList result = new ArrayList(n);
        for (int k = 0; k < n; ++k) {
            double d = r.nextDouble();
            int x = (int)(d * (double)copy.size());
            result.add(copy.get(x));
        }
        return result;
    }

    public static <T> boolean isSubList(List<T> l1, List<? super T> l) {
        Iterator<T> it = l.iterator();
        for (T o1 : l1) {
            if (!it.hasNext()) {
                return false;
            }
            T o = it.next();
            while (o == null && o1 != null || o != null && !o.equals(o1)) {
                if (!it.hasNext()) {
                    return false;
                }
                o = it.next();
            }
        }
        return true;
    }

    public static <K, V> String toVerticalString(Map<K, V> m) {
        StringBuilder b = new StringBuilder();
        Set<Map.Entry<K, V>> entries = m.entrySet();
        for (Map.Entry<K, V> e : entries) {
            b.append(e.getKey() + "=" + e.getValue() + "\n");
        }
        return b.toString();
    }

    public static <T extends Comparable<T>> int compareLists(List<T> list1, List<T> list2) {
        if (list1 == null && list2 == null) {
            return 0;
        }
        if (list1 == null || list2 == null) {
            throw new IllegalArgumentException();
        }
        int size1 = list1.size();
        int size2 = list2.size();
        int size = Math.min(size1, size2);
        for (int i = 0; i < size; ++i) {
            int c = ((Comparable)list1.get(i)).compareTo(list2.get(i));
            if (c == 0) continue;
            return c;
        }
        if (size1 < size2) {
            return -1;
        }
        if (size1 > size2) {
            return 1;
        }
        return 0;
    }

    public static <C extends Comparable<C>> Comparator<List<C>> getListComparator() {
        return new Comparator<List<C>>(){

            @Override
            public int compare(List<C> list1, List<C> list2) {
                return CollectionUtils.compareLists(list1, list2);
            }
        };
    }

    public static <T extends Comparable<T>> List<T> sorted(Iterable<T> items) {
        List<T> result = CollectionUtils.toList(items);
        Collections.sort(result);
        return result;
    }

    public static <T> List<T> toList(Iterable<T> items) {
        ArrayList list = new ArrayList();
        CollectionUtils.addAll(list, items);
        return list;
    }

    public static <T> Set<T> toSet(Iterable<T> items) {
        HashSet set = new HashSet();
        CollectionUtils.addAll(set, items);
        return set;
    }

    public static <T> void addAll(Collection<T> collection, Iterable<? extends T> items) {
        for (T item : items) {
            collection.add(item);
        }
    }

    public static <T> List<List<T>> getNGrams(List<T> items, int minSize, int maxSize) {
        ArrayList<List<T>> ngrams = new ArrayList<List<T>>();
        int listSize = items.size();
        for (int i = 0; i < listSize; ++i) {
            for (int ngramSize = minSize; ngramSize <= maxSize; ++ngramSize) {
                if (i + ngramSize > listSize) continue;
                ArrayList<T> ngram = new ArrayList<T>();
                for (int j = i; j < i + ngramSize; ++j) {
                    ngram.add(items.get(j));
                }
                ngrams.add(ngram);
            }
        }
        return ngrams;
    }

    public static <T> List<List<T>> getPrefixesAndSuffixes(List<T> items, int minSize, int maxSize, T paddingSymbol, boolean includePrefixes, boolean includeSuffixes) {
        assert (minSize > 0);
        assert (maxSize >= minSize);
        assert (includePrefixes || includeSuffixes);
        ArrayList<List<T>> prefixesAndSuffixes = new ArrayList<List<T>>();
        for (int span = minSize - 1; span < maxSize; ++span) {
            int i;
            ArrayList<Integer> indices = new ArrayList<Integer>();
            ArrayList<T> seq = new ArrayList<T>();
            if (includePrefixes) {
                for (int i2 = 0; i2 <= span; ++i2) {
                    indices.add(i2);
                }
            }
            if (includeSuffixes) {
                int maxIndex = items.size() - 1;
                for (i = span; i >= 0; --i) {
                    indices.add(maxIndex - i);
                }
            }
            Iterator i$ = indices.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                try {
                    seq.add(items.get(i));
                }
                catch (IndexOutOfBoundsException ioobe) {
                    seq.add(paddingSymbol);
                }
            }
            prefixesAndSuffixes.add(seq);
        }
        return prefixesAndSuffixes;
    }
}

