#!../miniperl

open (OUT, ">perlmodlib.tmp") or die $!;
my (@pragma, @mod);
open (MANIFEST, "../MANIFEST") or die $!;

while (<MANIFEST>) {
     my $filename;
     next unless s|^lib/|| or m|^ext/|;
     ($filename) = /(\S+)/;
     $filename =~ s|^[^/]+/|| if $filename =~ s|^ext/||;
     next unless $filename =~ /\.pm$/;
     next unless open (MOD, "../lib/$filename");
     my ($name, $thing);
     my $foundit=0;
     {local $/="";
     while (<MOD>) {
          next unless /^=head1 NAME/;
          $foundit++;
          last;
     }
     }
     next unless $foundit;
     my $title = <MOD>;
     chomp($title);
     close MOD;

     my $perlname = $filename;
     $perlname =~ s|\.pm$||;
     $perlname =~ s|/|::|g;

     ($name, $thing) = split / - /, $title,2;
     next unless $name and $thing;
     $thing=~s/^perl pragma to //i;
     $thing=ucfirst($thing);
     $title = "=item $perlname\n\n$thing\n\n";

     if ($filename=~/[A-Z]/) {
          push @mod, $title;
     } else {
          push @pragma, $title;
     }
}

print OUT <<'EOF';
=head1 NAME

perlmodlib - constructing new Perl modules and finding existing ones

=head1 DESCRIPTION

=head1 THE PERL MODULE LIBRARY

Many modules are included the Perl distribution.  These are described
below, and all end in F<.pm>.  You may discover compiled library
file (usually ending in F<.so>) or small pieces of modules to be
autoloaded (ending in F<.al>); these were automatically generated
by the installation process.  You may also discover files in the
library directory that end in either F<.pl> or F<.ph>.  These are
old libraries supplied so that old programs that use them still
run.  The F<.pl> files will all eventually be converted into standard
modules, and the F<.ph> files made by B<h2ph> will probably end up
as extension modules made by B<h2xs>.  (Some F<.ph> values may
already be available through the POSIX, Errno, or Fcntl modules.)
The B<pl2pm> file in the distribution may help in your conversion,
but it's just a mechanical process and therefore far from bulletproof.

=head2 Pragmatic Modules

They work somewhat like compiler directives (pragmata) in that they
tend to affect the compilation of your program, and thus will usually
work well only when used within a C<use>, or C<no>.  Most of these
are lexically scoped, so an inner BLOCK may countermand them
by saying:

    no integer;
    no strict 'refs';
    no warnings;

which lasts until the end of that BLOCK.

Some pragmas are lexically scoped--typically those that affect the
C<$^H> hints variable.  Others affect the current package instead,
like C<use vars> and C<use subs>, which allow you to predeclare a
variables or subroutines within a particular I<file> rather than
just a block.  Such declarations are effective for the entire file
for which they were declared.  You cannot rescind them with C<no
vars> or C<no subs>.

The following pragmas are defined (and have their own documentation).

=over 12

EOF

print OUT $_ for (sort @pragma);

print OUT <<EOF;
=back

=head2 Standard Modules

Standard, bundled modules are all expected to behave in a well-defined
manner with respect to namespace pollution because they use the
Exporter module.  See their own documentation for details.

=over 12

EOF

print OUT $_ for (sort @mod);

print OUT <<'EOF';
=back

To find out I<all> modules installed on your system, including
those without documentation or outside the standard release,
just do this:

    % find `perl -e 'print "@INC"'` -name '*.pm' -print

They should all have their own documentation installed and accessible
via your system man(1) command.  If you do not have a B<find>
program, you can use the Perl B<find2perl> program instead, which
generates Perl code as output you can run through perl.  If you
have a B<man> program but it doesn't find your modules, you'll have
to fix your manpath.  See L<perl> for details.  If you have no
system B<man> command, you might try the B<perldoc> program.

=head2 Extension Modules

Extension modules are written in C (or a mix of Perl and C).  They
are usually dynamically loaded into Perl if and when you need them,
but may also be be linked in statically.  Supported extension modules
include Socket, Fcntl, and POSIX.

Many popular C extension modules do not come bundled (at least, not
completely) due to their sizes, volatility, or simply lack of time
for adequate testing and configuration across the multitude of
platforms on which Perl was beta-tested.  You are encouraged to
look for them on CPAN (described below), or using web search engines
like Alta Vista or Deja News.

=head1 CPAN

CPAN stands for Comprehensive Perl Archive Network; it's a globally
replicated trove of Perl materials, including documentation, style
guides, tricks and traps, alternate ports to non-Unix systems and
occasional binary distributions for these.   Search engines for
CPAN can be found at http://cpan.perl.com/ and at
http://theory.uwinnipeg.ca/mod_perl/cpan-search.pl .

Most importantly, CPAN includes around a thousand unbundled modules,
some of which require a C compiler to build.  Major categories of
modules are:

=over

=item *
Language Extensions and Documentation Tools

=item *
Development Support

=item *
Operating System Interfaces

=item *
Networking, Device Control (modems) and InterProcess Communication

=item *
Data Types and Data Type Utilities

=item *
Database Interfaces

=item *
User Interfaces

=item *
Interfaces to / Emulations of Other Programming Languages

=item *
File Names, File Systems and File Locking (see also File Handles)

=item *
String Processing, Language Text Processing, Parsing, and Searching

=item *
Option, Argument, Parameter, and Configuration File Processing

=item *
Internationalization and Locale

=item *
Authentication, Security, and Encryption

=item *
World Wide Web, HTML, HTTP, CGI, MIME

=item *
Server and Daemon Utilities

=item *
Archiving and Compression

=item *
Images, Pixmap and Bitmap Manipulation, Drawing, and Graphing

=item *
Mail and Usenet News

=item *
Control Flow Utilities (callbacks and exceptions etc)

=item *
File Handle and Input/Output Stream Utilities

=item *
Miscellaneous Modules

=back

Registered CPAN sites as of this writing include the following.
You should try to choose one close to you:

=over

=item Africa

    South Africa   ftp://ftp.is.co.za/programming/perl/CPAN/
                   ftp://ftp.saix.net/pub/CPAN/
                   ftp://ftp.sun.ac.za/CPAN/
                   ftp://ftpza.co.za/pub/mirrors/cpan/


=item Asia

    China          ftp://freesoft.cei.gov.cn/pub/languages/perl/CPAN/
    Hong Kong      ftp://ftp.pacific.net.hk/pub/mirror/CPAN/
    Indonesia      ftp://malone.piksi.itb.ac.id/pub/CPAN/
    Israel         ftp://bioinfo.weizmann.ac.il/pub/software/perl/CPAN/
    Japan          ftp://ftp.dti.ad.jp/pub/lang/CPAN/
                   ftp://ftp.jaist.ac.jp/pub/lang/perl/CPAN/
                   ftp://ftp.lab.kdd.co.jp/lang/perl/CPAN/
                   ftp://ftp.meisei-u.ac.jp/pub/CPAN/
                   ftp://ftp.ring.gr.jp/pub/lang/perl/CPAN/
                   ftp://mirror.nucba.ac.jp/mirror/Perl/
    Saudi-Arabia   ftp://ftp.isu.net.sa/pub/CPAN/
    Singapore      ftp://ftp.nus.edu.sg/pub/unix/perl/CPAN/
    South Korea    ftp://ftp.bora.net/pub/CPAN/
                   ftp://ftp.kornet.net/pub/CPAN/
                   ftp://ftp.nuri.net/pub/CPAN/
    Taiwan         ftp://coda.nctu.edu.tw/computer-languages/perl/CPAN/
                   ftp://ftp.ee.ncku.edu.tw/pub3/perl/CPAN/
                   ftp://ftp1.sinica.edu.tw/pub1/perl/CPAN/
    Thailand       ftp://ftp.nectec.or.th/pub/mirrors/CPAN/


=item Australasia

    Australia      ftp://cpan.topend.com.au/pub/CPAN/
                   ftp://ftp.labyrinth.net.au/pub/perl-CPAN/
                   ftp://ftp.sage-au.org.au/pub/compilers/perl/CPAN/
                   ftp://mirror.aarnet.edu.au/pub/perl/CPAN/
    New Zealand    ftp://ftp.auckland.ac.nz/pub/perl/CPAN/
                   ftp://sunsite.net.nz/pub/languages/perl/CPAN/


=item Central America

    Costa Rica     ftp://ftp.ucr.ac.cr/pub/Unix/CPAN/


=item Europe

    Austria        ftp://ftp.tuwien.ac.at/pub/languages/perl/CPAN/
    Belgium        ftp://ftp.kulnet.kuleuven.ac.be/pub/mirror/CPAN/
    Bulgaria       ftp://ftp.ntrl.net/pub/mirrors/CPAN/
    Croatia        ftp://ftp.linux.hr/pub/CPAN/
    Czech Republic ftp://ftp.fi.muni.cz/pub/perl/
                   ftp://sunsite.mff.cuni.cz/Languages/Perl/CPAN/
    Denmark        ftp://sunsite.auc.dk/pub/languages/perl/CPAN/
    Estonia        ftp://ftp.ut.ee/pub/languages/perl/CPAN/
    Finland        ftp://ftp.funet.fi/pub/languages/perl/CPAN/
    France         ftp://ftp.grolier.fr/pub/perl/CPAN/
                   ftp://ftp.lip6.fr/pub/perl/CPAN/
                   ftp://ftp.oleane.net/pub/mirrors/CPAN/
                   ftp://ftp.pasteur.fr/pub/computing/CPAN/
                   ftp://ftp.uvsq.fr/pub/perl/CPAN/
    German         ftp://ftp.gigabell.net/pub/CPAN/
    Germany        ftp://ftp.archive.de.uu.net/pub/CPAN/
                   ftp://ftp.freenet.de/pub/ftp.cpan.org/pub/
                   ftp://ftp.gmd.de/packages/CPAN/
                   ftp://ftp.gwdg.de/pub/languages/perl/CPAN/

ftp://ftp.leo.org/pub/comp/general/programming/languages/script/perl/CPAN/
                   ftp://ftp.mpi-sb.mpg.de/pub/perl/CPAN/
                   ftp://ftp.rz.ruhr-uni-bochum.de/pub/CPAN/
                   ftp://ftp.uni-erlangen.de/pub/source/CPAN/
                   ftp://ftp.uni-hamburg.de/pub/soft/lang/perl/CPAN/
    Germany        ftp://ftp.archive.de.uu.net/pub/CPAN/
                   ftp://ftp.freenet.de/pub/ftp.cpan.org/pub/
                   ftp://ftp.gmd.de/packages/CPAN/
                   ftp://ftp.gwdg.de/pub/languages/perl/CPAN/

ftp://ftp.leo.org/pub/comp/general/programming/languages/script/perl/CPAN/
                   ftp://ftp.mpi-sb.mpg.de/pub/perl/CPAN/
                   ftp://ftp.rz.ruhr-uni-bochum.de/pub/CPAN/
                   ftp://ftp.uni-erlangen.de/pub/source/CPAN/
                   ftp://ftp.uni-hamburg.de/pub/soft/lang/perl/CPAN/
    Greece         ftp://ftp.ntua.gr/pub/lang/perl/
    Hungary        ftp://ftp.kfki.hu/pub/packages/perl/CPAN/
    Iceland        ftp://ftp.gm.is/pub/CPAN/
    Ireland        ftp://cpan.indigo.ie/pub/CPAN/
                   ftp://sunsite.compapp.dcu.ie/pub/perl/
    Italy          ftp://cis.uniRoma2.it/CPAN/
                   ftp://ftp.flashnet.it/pub/CPAN/
                   ftp://ftp.unina.it/pub/Other/CPAN/
                   ftp://ftp.unipi.it/pub/mirror/perl/CPAN/
    Netherlands    ftp://ftp.cs.uu.nl/mirror/CPAN/
                   ftp://ftp.nluug.nl/pub/languages/perl/CPAN/
    Norway         ftp://ftp.uit.no/pub/languages/perl/cpan/
                   ftp://sunsite.uio.no/pub/languages/perl/CPAN/
    Poland         ftp://ftp.man.torun.pl/pub/CPAN/
                   ftp://ftp.pk.edu.pl/pub/lang/perl/CPAN/
                   ftp://sunsite.icm.edu.pl/pub/CPAN/
    Portugal       ftp://ftp.ci.uminho.pt/pub/mirrors/cpan/
                   ftp://ftp.ist.utl.pt/pub/CPAN/
                   ftp://ftp.ua.pt/pub/CPAN/
    Romania        ftp://ftp.dnttm.ro/pub/CPAN/
    Russia         ftp://ftp.chg.ru/pub/lang/perl/CPAN/
                   ftp://ftp.sai.msu.su/pub/lang/perl/CPAN/
    Slovakia       ftp://ftp.entry.sk/pub/languages/perl/CPAN/
    Slovenia       ftp://ftp.arnes.si/software/perl/CPAN/
    Spain          ftp://ftp.etse.urv.es/pub/perl/
                   ftp://ftp.rediris.es/mirror/CPAN/
    Sweden         ftp://ftp.sunet.se/pub/lang/perl/CPAN/
    Switzerland    ftp://sunsite.cnlab-switch.ch/mirror/CPAN/
    Turkey         ftp://sunsite.bilkent.edu.tr/pub/languages/CPAN/
    United Kingdom ftp://ftp.demon.co.uk/pub/mirrors/perl/CPAN/
                   ftp://ftp.flirble.org/pub/languages/perl/CPAN/

ftp://ftp.mirror.ac.uk/sites/ftp.funet.fi/pub/languages/perl/CPAN/
                   ftp://ftp.plig.org/pub/CPAN/
                   ftp://sunsite.doc.ic.ac.uk/packages/CPAN/


=item North America

    Alberta        ftp://sunsite.ualberta.ca/pub/Mirror/CPAN/
    California     ftp://cpan.nas.nasa.gov/pub/perl/CPAN/
                   ftp://cpan.valueclick.com/CPAN/
                   ftp://ftp.cdrom.com/pub/perl/CPAN/
                   http://download.sourceforge.net/mirrors/CPAN/
    Colorado       ftp://ftp.cs.colorado.edu/pub/perl/CPAN/
    Florida        ftp://ftp.cise.ufl.edu/pub/perl/CPAN/
    Georgia        ftp://ftp.twoguys.org/CPAN/
    Illinois       ftp://uiarchive.uiuc.edu/pub/lang/perl/CPAN/
    Indiana        ftp://csociety-ftp.ecn.purdue.edu/pub/CPAN/
                   ftp://ftp.uwsg.indiana.edu/pub/perl/CPAN/
    Kentucky       ftp://ftp.uky.edu/CPAN/
    Manitoba       ftp://theoryx5.uwinnipeg.ca/pub/CPAN/
    Massachusetts
ftp://ftp.ccs.neu.edu/net/mirrors/ftp.funet.fi/pub/languages/perl/CPAN/
                   ftp://ftp.iguide.com/pub/mirrors/packages/perl/CPAN/
    Mexico         ftp://ftp.msg.com.mx/pub/CPAN/
    New York       ftp://ftp.deao.net/pub/CPAN/
                   ftp://ftp.rge.com/pub/languages/perl/
    North Carolina ftp://ftp.duke.edu/pub/perl/
    Nova Scotia    ftp://cpan.chebucto.ns.ca/pub/CPAN/
    Oklahoma       ftp://ftp.ou.edu/mirrors/CPAN/
    Ontario        ftp://ftp.crc.ca/pub/packages/lang/perl/CPAN/
    Oregon         ftp://ftp.orst.edu/pub/packages/CPAN/
    Pennsylvania   ftp://ftp.epix.net/pub/languages/perl/
    Tennessee      ftp://ftp.sunsite.utk.edu/pub/CPAN/
    Texas          ftp://ftp.sedl.org/pub/mirrors/CPAN/
                   ftp://jhcloos.com/pub/mirror/CPAN/
    Utah           ftp://mirror.xmission.com/CPAN/
    Virginia       ftp://ftp.perl.org/pub/perl/CPAN/
                   ftp://ruff.cs.jmu.edu/pub/CPAN/
    Washington     ftp://ftp-mirror.internap.com/pub/CPAN/
                   ftp://ftp.llarian.net/pub/CPAN/
                   ftp://ftp.spu.edu/pub/CPAN/


=item South America

    Brazil         ftp://cpan.if.usp.br/pub/mirror/CPAN/
                   ftp://ftp.matrix.com.br/pub/perl/
    Chile          ftp://sunsite.dcc.uchile.cl/pub/Lang/PERL/

=back

For an up-to-date listing of CPAN sites,
see http://www.perl.com/perl/CPAN/SITES or ftp://www.perl.com/CPAN/SITES .

=head1 Modules: Creation, Use, and Abuse

(The following section is borrowed directly from Tim Bunce's modules
file, available at your nearest CPAN site.)

Perl implements a class using a package, but the presence of a
package doesn't imply the presence of a class.  A package is just a
namespace.  A class is a package that provides subroutines that can be
used as methods.  A method is just a subroutine that expects, as its
first argument, either the name of a package (for "static" methods),
or a reference to something (for "virtual" methods).

A module is a file that (by convention) provides a class of the same
name (sans the .pm), plus an import method in that class that can be
called to fetch exported symbols.  This module may implement some of
its methods by loading dynamic C or C++ objects, but that should be
totally transparent to the user of the module.  Likewise, the module
might set up an AUTOLOAD function to slurp in subroutine definitions on
demand, but this is also transparent.  Only the F<.pm> file is required to
exist.  See L<perlsub>, L<perltoot>, and L<AutoLoader> for details about
the AUTOLOAD mechanism.

=head2 Guidelines for Module Creation

=over 4

=item Do similar modules already exist in some form?

If so, please try to reuse the existing modules either in whole or
by inheriting useful features into a new class.  If this is not
practical try to get together with the module authors to work on
extending or enhancing the functionality of the existing modules.
A perfect example is the plethora of packages in perl4 for dealing
with command line options.

If you are writing a module to expand an already existing set of
modules, please coordinate with the author of the package.  It
helps if you follow the same naming scheme and module interaction
scheme as the original author.

=item Try to design the new module to be easy to extend and reuse.

Try to C<use warnings;> (or C<use warnings qw(...);>).
Remember that you can add C<no warnings qw(...);> to individual blocks
of code that need less warnings.

Use blessed references.  Use the two argument form of bless to bless
into the class name given as the first parameter of the constructor,
e.g.,:

 sub new {
     my $class = shift;
     return bless {}, $class;
 }

or even this if you'd like it to be used as either a static
or a virtual method.

 sub new {
     my $self  = shift;
     my $class = ref($self) || $self;
     return bless {}, $class;
 }

Pass arrays as references so more parameters can be added later
(it's also faster).  Convert functions into methods where
appropriate.  Split large methods into smaller more flexible ones.
Inherit methods from other modules if appropriate.

Avoid class name tests like: C<die "Invalid" unless ref $ref eq 'FOO'>.
Generally you can delete the C<eq 'FOO'> part with no harm at all.
Let the objects look after themselves! Generally, avoid hard-wired
class names as far as possible.

Avoid C<< $r->Class::func() >> where using C<@ISA=qw(... Class ...)> and
C<< $r->func() >> would work (see L<perlbot> for more details).

Use autosplit so little used or newly added functions won't be a
burden to programs that don't use them. Add test functions to
the module after __END__ either using AutoSplit or by saying:

 eval join('',<main::DATA>) || die $@ unless caller();

Does your module pass the 'empty subclass' test? If you say
C<@SUBCLASS::ISA = qw(YOURCLASS);> your applications should be able
to use SUBCLASS in exactly the same way as YOURCLASS.  For example,
does your application still work if you change:  C<$obj = new YOURCLASS;>
into: C<$obj = new SUBCLASS;> ?

Avoid keeping any state information in your packages. It makes it
difficult for multiple other packages to use yours. Keep state
information in objects.

Always use B<-w>.

Try to C<use strict;> (or C<use strict qw(...);>).
Remember that you can add C<no strict qw(...);> to individual blocks
of code that need less strictness.

Always use B<-w>.

Follow the guidelines in the perlstyle(1) manual.

Always use B<-w>.

=item Some simple style guidelines

The perlstyle manual supplied with Perl has many helpful points.

Coding style is a matter of personal taste. Many people evolve their
style over several years as they learn what helps them write and
maintain good code.  Here's one set of assorted suggestions that
seem to be widely used by experienced developers:

Use underscores to separate words.  It is generally easier to read
$var_names_like_this than $VarNamesLikeThis, especially for
non-native speakers of English. It's also a simple rule that works
consistently with VAR_NAMES_LIKE_THIS.

Package/Module names are an exception to this rule. Perl informally
reserves lowercase module names for 'pragma' modules like integer
and strict. Other modules normally begin with a capital letter and
use mixed case with no underscores (need to be short and portable).

You may find it helpful to use letter case to indicate the scope
or nature of a variable. For example:

 $ALL_CAPS_HERE   constants only (beware clashes with Perl vars)
 $Some_Caps_Here  package-wide global/static
 $no_caps_here    function scope my() or local() variables

Function and method names seem to work best as all lowercase.
e.g., C<< $obj->as_string() >>.

You can use a leading underscore to indicate that a variable or
function should not be used outside the package that defined it.

=item Select what to export.

Do NOT export method names!

Do NOT export anything else by default without a good reason!

Exports pollute the namespace of the module user.  If you must
export try to use @EXPORT_OK in preference to @EXPORT and avoid
short or common names to reduce the risk of name clashes.

Generally anything not exported is still accessible from outside the
module using the ModuleName::item_name (or C<< $blessed_ref->method >>)
syntax.  By convention you can use a leading underscore on names to
indicate informally that they are 'internal' and not for public use.

(It is actually possible to get private functions by saying:
C<my $subref = sub { ... };  &$subref;>.  But there's no way to call that
directly as a method, because a method must have a name in the symbol
table.)

As a general rule, if the module is trying to be object oriented
then export nothing. If it's just a collection of functions then
@EXPORT_OK anything but use @EXPORT with caution.

=item Select a name for the module.

This name should be as descriptive, accurate, and complete as
possible.  Avoid any risk of ambiguity. Always try to use two or
more whole words.  Generally the name should reflect what is special
about what the module does rather than how it does it.  Please use
nested module names to group informally or categorize a module.
There should be a very good reason for a module not to have a nested name.
Module names should begin with a capital letter.

Having 57 modules all called Sort will not make life easy for anyone
(though having 23 called Sort::Quick is only marginally better :-).
Imagine someone trying to install your module alongside many others.
If in any doubt ask for suggestions in comp.lang.perl.misc.

If you are developing a suite of related modules/classes it's good
practice to use nested classes with a common prefix as this will
avoid namespace clashes. For example: Xyz::Control, Xyz::View,
Xyz::Model etc. Use the modules in this list as a naming guide.

If adding a new module to a set, follow the original author's
standards for naming modules and the interface to methods in
those modules.

If developing modules for private internal or project specific use,
that will never be released to the public, then you should ensure
that their names will not clash with any future public module. You
can do this either by using the reserved Local::* category or by
using a category name that includes an underscore like Foo_Corp::*.

To be portable each component of a module name should be limited to
11 characters. If it might be used on MS-DOS then try to ensure each is
unique in the first 8 characters. Nested modules make this easier.

=item Have you got it right?

How do you know that you've made the right decisions? Have you
picked an interface design that will cause problems later? Have
you picked the most appropriate name? Do you have any questions?

The best way to know for sure, and pick up many helpful suggestions,
is to ask someone who knows. Comp.lang.perl.misc is read by just about
all the people who develop modules and it's the best place to ask.

All you need to do is post a short summary of the module, its
purpose and interfaces. A few lines on each of the main methods is
probably enough. (If you post the whole module it might be ignored
by busy people - generally the very people you want to read it!)

Don't worry about posting if you can't say when the module will be
ready - just say so in the message. It might be worth inviting
others to help you, they may be able to complete it for you!

=item README and other Additional Files.

It's well known that software developers usually fully document the
software they write. If, however, the world is in urgent need of
your software and there is not enough time to write the full
documentation please at least provide a README file containing:

=over 10

=item *
A description of the module/package/extension etc.

=item *
A copyright notice - see below.

=item *
Prerequisites - what else you may need to have.

=item *
How to build it - possible changes to Makefile.PL etc.

=item *
How to install it.

=item *
Recent changes in this release, especially incompatibilities

=item *
Changes / enhancements you plan to make in the future.

=back

If the README file seems to be getting too large you may wish to
split out some of the sections into separate files: INSTALL,
Copying, ToDo etc.

=over 4

=item Adding a Copyright Notice.

How you choose to license your work is a personal decision.
The general mechanism is to assert your Copyright and then make
a declaration of how others may copy/use/modify your work.

Perl, for example, is supplied with two types of licence: The GNU
GPL and The Artistic Licence (see the files README, Copying, and
Artistic).  Larry has good reasons for NOT just using the GNU GPL.

My personal recommendation, out of respect for Larry, Perl, and the
Perl community at large is to state something simply like:

 Copyright (c) 1995 Your Name. All rights reserved.
 This program is free software; you can redistribute it and/or
 modify it under the same terms as Perl itself.

This statement should at least appear in the README file. You may
also wish to include it in a Copying file and your source files.
Remember to include the other words in addition to the Copyright.

=item Give the module a version/issue/release number.

To be fully compatible with the Exporter and MakeMaker modules you
should store your module's version number in a non-my package
variable called $VERSION.  This should be a floating point
number with at least two digits after the decimal (i.e., hundredths,
e.g, C<$VERSION = "0.01">).  Don't use a "1.3.2" style version.
See L<Exporter> for details.

It may be handy to add a function or method to retrieve the number.
Use the number in announcements and archive file names when
releasing the module (ModuleName-1.02.tar.Z).
See perldoc ExtUtils::MakeMaker.pm for details.

=item How to release and distribute a module.

It's good idea to post an announcement of the availability of your
module (or the module itself if small) to the comp.lang.perl.announce
Usenet newsgroup.  This will at least ensure very wide once-off
distribution.

If possible, register the module with CPAN.  You should
include details of its location in your announcement.

Some notes about ftp archives: Please use a long descriptive file
name that includes the version number. Most incoming directories
will not be readable/listable, i.e., you won't be able to see your
file after uploading it. Remember to send your email notification
message as soon as possible after uploading else your file may get
deleted automatically. Allow time for the file to be processed
and/or check the file has been processed before announcing its
location.

FTP Archives for Perl Modules:

Follow the instructions and links on:

   http://www.perl.com/CPAN/modules/00modlist.long.html
   http://www.perl.com/CPAN/modules/04pause.html

or upload to one of these sites:

   https://pause.kbx.de/pause/
   http://pause.perl.org/pause/

and notify <modules@perl.org>.

By using the WWW interface you can ask the Upload Server to mirror
your modules from your ftp or WWW site into your own directory on
CPAN!

Please remember to send me an updated entry for the Module list!

=item Take care when changing a released module.

Always strive to remain compatible with previous released versions.
Otherwise try to add a mechanism to revert to the
old behavior if people rely on it.  Document incompatible changes.

=back

=back

=head2 Guidelines for Converting Perl 4 Library Scripts into Modules

=over 4

=item There is no requirement to convert anything.

If it ain't broke, don't fix it! Perl 4 library scripts should
continue to work with no problems. You may need to make some minor
changes (like escaping non-array @'s in double quoted strings) but
there is no need to convert a .pl file into a Module for just that.

=item Consider the implications.

All Perl applications that make use of the script will need to
be changed (slightly) if the script is converted into a module.  Is
it worth it unless you plan to make other changes at the same time?

=item Make the most of the opportunity.

If you are going to convert the script to a module you can use the
opportunity to redesign the interface.  The guidelines for module
creation above include many of the issues you should consider.

=item The pl2pm utility will get you started.

This utility will read *.pl files (given as parameters) and write
corresponding *.pm files. The pl2pm utilities does the following:

=over 10

=item *
Adds the standard Module prologue lines

=item *
Converts package specifiers from ' to ::

=item *
Converts die(...) to croak(...)

=item *
Several other minor changes

=back

Being a mechanical process pl2pm is not bullet proof. The converted
code will need careful checking, especially any package statements.
Don't delete the original .pl file till the new .pm one works!

=back

=head2 Guidelines for Reusing Application Code

=over 4

=item Complete applications rarely belong in the Perl Module Library.

=item Many applications contain some Perl code that could be reused.

Help save the world! Share your code in a form that makes it easy
to reuse.

=item Break-out the reusable code into one or more separate module files.

=item Take the opportunity to reconsider and redesign the interfaces.

=item In some cases the 'application' can then be reduced to a small

fragment of code built on top of the reusable modules. In these cases
the application could invoked as:

     % perl -e 'use Module::Name; method(@ARGV)' ...
or
     % perl -mModule::Name ...    (in perl5.002 or higher)

=back

=head1 NOTE

Perl does not enforce private and public parts of its modules as you may
have been used to in other languages like C++, Ada, or Modula-17.  Perl
doesn't have an infatuation with enforced privacy.  It would prefer
that you stayed out of its living room because you weren't invited, not
because it has a shotgun.

The module and its user have a contract, part of which is common law,
and part of which is "written".  Part of the common law contract is
that a module doesn't pollute any namespace it wasn't asked to.  The
written contract for the module (A.K.A. documentation) may make other
provisions.  But then you know when you C<use RedefineTheWorld> that
you're redefining the world and willing to take the consequences.
EOF

close MANIFEST or warn "$0: failed to close MANIFEST (../MANIFEST): $!";
close OUT      or warn "$0: failed to close OUT (perlmodlib.tmp): $!";

