/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;

public class PatternWithPredicate
extends Pattern {
    private Pattern basePattern;
    private Expression predicate;

    public PatternWithPredicate(Pattern basePattern, Expression predicate) {
        this.basePattern = basePattern;
        this.predicate = predicate;
    }

    public boolean matches(Item item, XPathContext context) throws XPathException {
        if (!this.basePattern.matches(item, context)) {
            return false;
        }
        XPathContextMinor c2 = context.newMinorContext();
        SingletonIterator si = (SingletonIterator)SingletonIterator.makeIterator(item);
        si.next();
        c2.setCurrentIterator(si);
        return this.predicate.effectiveBooleanValue(context);
    }

    public ItemType getItemType() {
        return this.basePattern.getItemType();
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator<Expression>(new PatternSponsor(this.basePattern), this.predicate);
    }

    public Pattern analyze(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(this.getItemType(), false);
        this.predicate = visitor.typeCheck(this.predicate, cit);
        return this;
    }

    public double getDefaultPriority() {
        return this.basePattern.getDefaultPriority() + 0.5;
    }
}

