#!/usr/bin/perl -w

use strict;

my $n;
use Test::More tests => ($n = 40) * 6 + 4;
use lib "t/lib";
use Test::FloatNear;

BEGIN { use_ok("MPEG::Audio::Frame") };

my $s = 0;
for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg2, "MPEG 2");
	ok($frame->layer3, "layer III");
	ok(!$frame->broken, "frame is not broken");
	is($frame->sample, 22050, "sample rate");
	is($frame->length, length("$frame"), "actual length eq calculated length");
	$s += $frame->seconds;
}

is_near($s, 1.04489795918367, "total length");

is(MPEG::Audio::Frame->read(*DATA), undef, "nothing more on __DATA__");
ok(eof(DATA), "eof(DATA)");

__DATA__
@ JJh  	OQǠ4.ௐ7<94˅A=c	JܸJ`r\ܸ\@>ᄪ2B  uPE"B
h f~Gs6MKR `0≋]MunԂLW6"SMW̃ Bs
շh hʠp		uJ7ͺ@I7Lh\QR]ṅbւTlu*I&]*-.߯Iŗ"2O(n6*  " XLMy3::a8B"* A:(Q I9Ej]g]@\LJFh8EK"
2xO@/
R"]ĘkR  E$@"2ص壸dP0e41F4TQ8(̀4MjZI]%3&SudI!q67IOCuZZ  B	.7h hyc)D;RHlbI96:,N5jJMj3u麒KZc3ŒtTq18ѬZ?oԻ~/T@K|$i@
R
h o1)쌵tb0FȗTNp{ފ5$QFIlUKYK1 Y6t\u-Bcڔj1=(2sj Nz 4S[%]5 :UScz* GpRy4	tZ.^I!WMH@) |1|""ƴUkguRINUD}$^е Nu5]FK2~
l./"~wo;č}PA54B-KwUn~W>ũuڪ,(E4PF xc4YBvݭ>1cUi
,MI%&)v]H/_ZhdE@:1 Cڔ썔VL* xaAsԾOdq&I`
	_^Z0@Ѻ0TRһvW@4BHIKZ.3&U&pp̢eQ_WZ׫5JJx Z[u$^/$nIBJPs([ 1"ŕ@R{ڔ #tVy@4ifNAM̂3`z2*Su:kڙiWSU^X9(U(B4 `6`Uab"gc8B\1KZY}Z55 g($JZJz$t}ZWD
dQ<˷+֥L
T;Wn*Ɋ_ZG@=@k!K% ]3$PwRҢ[>b 8fH+Uz򱩈@@-$BA(#{+ZrhVSK`+|,t."Bu±@dɶ[_M%fp!B&EaZtn6rxJйS뙥lM&ZA9%H QAJt/~ZuR@~`d蘪2@@
ujjV/uTj 8 '(^&
jR޵bRU@7vKo,OVݕBĎbd>숵$I$+!MF Jse<1Q=]ve$y-`L"hEL@gu#dYm0dfmjzF@Ęi²L.0+.SoE8$+$W}*MI
4▁Tڞ?O#:3L|YQ#
d*5:=?jBĩzdUԛ1ZkMZ<X~ZKL֭^p"E9($\Ql
5\cI=-BqoMO*-ײ@ķ
 dzb 	ikLMJJ'e)4ysJ{sB*ND4#EfQ}H-%b# 4H%JǚB
}(]ɃA!u-T$E PS%
:jj:|
_=YV[MTLYmE`bp5V2dfn<Gz[P":@
e(ֶuT0h4(mزjS|3fԐ]}J[-#K-K	jJzg-_u6>@scAif# 6H!	2?B
e((UR*Z}3LH8qkmUY:znǡ*kl(6^bRH&Y3ìɡo42YPKRN,@
@e(*CtfY!bVg_nGLLQZ
e2`?UʋGu~,2@Xb@+ `R13u_j'ڲARB
e(e+} c]EU
J.&QN\eǢZѰqeR$%[eo3e:TPVZ	+j4H1pc$KdRәk@j@e(hbʋ4zjw5-/5jdӋisy9O]-HDQl
 b( VC.L nDKKSVܪB@e(n5M#0M[nL[X$0
!1S%+Au
1^ai;HQ5<]I$UU @ 9Gbnp.+ޣ3ײ@

@}(~(,1((MdVLZǣSvd( 斐 KuIvZH:E'm Ej %%c:}mHVbzBb@e(^i ОbAֆMM\?01$uҤEkQ.hZ9՘: :)0ri<"S*AH=0O`@|h#-!e$2+Z1@
`M(=tjBE;WF
@$ȭ$)fƀ<Ow<*6`  &Wlwϗ9tt)&-og u(RQ}LL[dBB
De$kvUOZ$Cj褪w$)$VGӢQ]ѫ[9_ 
{>U63jjH?q%os5(uJ}_@ʙD\ֵwRJE% C)u:m[5)T2->ԥ)4TlČCϗ 
960;\x~+ ]!tPmmBR{`Ґ1e2eL0"21zRaIn$,͒BH @p	2R#l2QCBVBDZlnD@R{ڸ'66D6Ec1dJY(%]	1dE8Hh$jh$*LAME3.89 (beta)BijaLAME3.89 (beta)@2\ 2LLAME3.89 (beta)B  H    LAME3.89 (beta)@  H    B  H    
