######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT 6
package Geo::Location::TimeZone::F;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude 82.5 to 97.5
	"6" => {
		# Grid 6:-6 ; 2 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"581" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,3",
				"p" => [[82.5082835342964,-82.5],[82.5084838867188,-90],[82.5,-90],[82.5,-82.5],[82.5082835342964,-82.5],],
			},
		},
		# Grid 6:-5 ; 1 records
		"-5" => {
			"582" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,3",
				"p" => [[82.5078956217433,-67.5],[82.507926940918,-68.6888275146484],[82.5082778930664,-82.2888259887695],[82.5082835342964,-82.5],[82.5,-82.5],[82.5,-67.5],[82.5078956217433,-67.5],],
			},
		},
		# Grid 6:-4 ; 1 records
		"-4" => {
			"583" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,3",
				"p" => [[82.5084838867188,-67.5],[82.5,-67.5],[82.5,-52.5],[82.5075004528776,-52.5],[82.5078956217433,-67.5],[82.5084838867188,-67.5],],
			},
		},
		# Grid 6:-3 ; 1 records
		"-3" => {
			"584" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,3",
				"p" => [[82.5084838867188,-52.5],[82.5,-52.5],[82.5,-37.5],[82.5071052840119,-37.5],[82.5075004528776,-52.5],[82.5084838867188,-52.5],],
			},
		},
		# Grid 6:-2 ; 1 records
		"-2" => {
			"585" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,3",
				"p" => [[82.5084838867188,-37.5],[82.5,-37.5],[82.5,-22.5],[82.506711445388,-22.5],[82.5069732666016,-32.4888229370117],[82.5071052840119,-37.5],[82.5084838867188,-37.5],],
			},
		},
		# Grid 6:-1 ; 2 records
		"-1" => {
			"def_z" => "Indian/Cocos",
			"586" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,3",
				"p" => [[82.5062880954176,-7.5],[82.5065460205078,-16.1888236999512],[82.506711445388,-22.5],[82.5,-22.5],[82.5,-7.5],[82.5062880954176,-7.5],],
			},
		},
		# Grid 6:0 ; 3 records
		"0" => {
			"def_z" => "Etc/GMT+7",
			"587" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,3",
				"p" => [[82.5,5.91833209991455],[82.5,7.5],[82.5058428249775,7.5],[82.5062880954176,-7.5],[82.5,-7.5],[82.5,7.19222068786621],[82.5,5.91833209991455],],
			},
			"594" => {
				"z" => "Asia/Calcutta",
				"c" => "ESRI",
				"s" => "38,2",
				"p" => [[94.5922912567023,7.5],[94.5928039550781,5.88067579269409],[92.9024963378906,5.88067579269409],[90.3406448364258,5.88448143005371],[90.3388314603974,7.5],[90.3301544189453,7.5],[94.5922912567023,7.5],],
			},
		},
		# Grid 6:1 ; 5 records
		"1" => {
			"def_z" => "Etc/GMT+7",
			"404" => {
				"z" => "Asia/Rangoon",
				"c" => "ESRI",
				"s" => "25,1",
				"p" => [[97.5,12.1338882446289],[97.5,11.751980820613],[97.4811706542969,11.7487964630127],[97.4228286743164,11.8107824325562],[97.5,11.9115874010405],[97.5,16.2546271734531],[97.4556503295898,16.3175773620605],[97.419189453125,16.4379043579102],[97.3499069213867,16.4707221984863],[97.3170928955078,16.6019878387451],[97.2186431884766,16.7660694122314],[97.1603012084961,16.8098258972168],[96.9232940673828,16.8134708404541],[96.8321380615234,16.7697162628174],[96.7774429321289,16.678560256958],[96.6024169921875,16.5290622711182],[96.0664215087891,16.2811145782471],[95.9789047241211,16.1936054229736],[95.8695220947266,16.1826667785645],[95.7346038818359,16.0696315765381],[95.701789855957,15.9529504776001],[95.4356155395508,15.7104730606079],[95.3262252807617,15.6849498748779],[94.7100067138672,15.7906913757324],[94.5313339233398,15.9401884078979],[94.494873046875,15.9365425109863],[94.4110107421875,15.8089227676392],[94.3709030151367,15.9365425109863],[94.3380813598633,15.9584197998047],[94.243278503418,15.9292497634888],[94.1740036010742,16.0276985168457],[94.239631652832,16.5418243408203],[94.3271484375,16.6512126922607],[94.3599624633789,16.8991584777832],[94.4365310668945,16.9976081848145],[94.4328842163086,17.194507598877],[94.5422744750977,17.3677043914795],[94.5204010009766,17.7104549407959],[94.4766387939453,17.7615032196045],[94.4183044433594,17.958402633667],[94.4511184692383,18.0750827789307],[94.3964233398438,18.2063484191895],[94.3016204833984,18.2245788574219],[94.3307952880859,18.3594913482666],[94.1557693481445,18.6894798278809],[94.0864944458008,18.7295894622803],[93.9916915893555,18.7077102661133],[93.7692642211914,18.5910301208496],[93.6307067871094,18.6639556884766],[93.4629821777344,18.8754405975342],[93.6161193847656,18.933780670166],[93.6598739624023,19.0212898254395],[93.4666213989258,19.3348712921143],[93.4702682495117,19.4223804473877],[93.5213165283203,19.4734287261963],[93.3936996459961,19.7250213623047],[93.4228668212891,19.8088855743408],[93.3827590942383,19.9018669128418],[93.3353576660156,19.9383296966553],[93.2733688354492,19.9346828460693],[93.2587890625,19.8143558502197],[93.1639862060547,19.7815399169922],[93.0874099731445,19.8143558502197],[93.007194519043,19.8070621490479],[92.8540496826172,20.1097030639648],[92.7665405273438,20.1789836883545],[92.6279830932617,20.4014053344727],[92.3738708496094,20.7008285522461],[92.2619323730469,21.0543098449707],[92.1985931396484,21.1541633605957],[92.1921997070312,21.3244400024414],[92.2530517578125,21.3724975585938],[92.2655487060547,21.4233283996582],[92.3166656494141,21.4213829040527],[92.3769226074219,21.4741630554199],[92.4274749755859,21.3747177124023],[92.5535888671875,21.373607635498],[92.5955352783203,21.2519416809082],[92.6693420410156,21.2969818115234],[92.6002655029297,21.634162902832],[92.6216430664062,21.8758277893066],[92.6008148193359,21.9822158813477],[92.6797027587891,22.0269432067871],[92.7119293212891,22.1597175598145],[92.8655395507812,22.048885345459],[92.8963775634766,21.9547157287598],[92.9430389404297,22.0283317565918],[92.9963684082031,21.9927711486816],[93.0097198486328,22.1074981689453],[93.0527648925781,22.1188850402832],[93.0441436767578,22.2019386291504],[93.1538696289062,22.1866607666016],[93.1424865722656,22.2369384765625],[93.1966400146484,22.2563858032227],[93.1805419921875,22.4405517578125],[93.140847910569,22.5],[97.5,22.5],[97.5,18.4917303290363],[97.4424743652344,18.4972152709961],[97.3622894287109,18.5796546936035],[97.3474884033203,18.5388870239258],[97.4944305419922,18.2824974060059],[97.5,18.2806280847848],[97.5,14.5313873291016],[97.5,12.1338882446289],],
			},
			"588" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,3",
				"p" => [[82.5,17.21792104076],[82.5055541992188,17.2230491638184],[82.5058428249775,7.5],[82.5,7.5],[82.5,7.5],[82.5,17.21792104076],],
			},
			"592" => {
				"z" => "Asia/Calcutta",
				"c" => "ESRI",
				"s" => "38,1",
				"p" => [[96.6158142089844,22.5],[93.140847910569,22.5],[93.1805419921875,22.4405517578125],[93.1966400146484,22.2563858032227],[93.1424865722656,22.2369384765625],[93.1538696289062,22.1866607666016],[93.0441436767578,22.2019386291504],[93.0527648925781,22.1188850402832],[93.0097198486328,22.1074981689453],[92.9963684082031,21.9927711486816],[92.9430389404297,22.0283317565918],[92.8963775634766,21.9547157287598],[92.8655395507812,22.048885345459],[92.7119293212891,22.1597175598145],[92.6797027587891,22.0269432067871],[92.6008148193359,21.9822158813477],[92.5621948242188,22.1333312988281],[92.6060943603516,22.1627731323242],[92.5513955948648,22.5],[88.9689828349305,22.5],[88.9977569580078,22.4655494689941],[89.0072174072266,22.2763862609863],[89.0963745117188,22.1486053466797],[89.0630035400391,22.1154747009277],[89.0438690185547,22.1363830566406],[89.0366516113281,22.0980529785156],[89.0574798583984,21.9283294677734],[89.0086059570312,21.9302749633789],[88.9997100830078,21.902774810791],[88.9427490234375,21.9366607666016],[88.9313659667969,21.9863815307617],[88.9055480957031,21.9591598510742],[89.0163879394531,21.8658294677734],[89.0211029052734,21.7822189331055],[89.0897064208984,21.6502723693848],[89.0741577148438,21.6141624450684],[89.0274810791016,21.6269416809082],[89.0002670288086,21.6020927429199],[88.8808517456055,21.5155162811279],[88.785514831543,21.5583209991455],[88.7063903808594,21.5705051422119],[88.5388641357422,21.5271587371826],[88.4980316162109,21.5205535888672],[88.4830474853516,21.556941986084],[88.5255432128906,21.6558303833008],[88.5008239746094,21.752498626709],[88.5374908447266,21.8138847351074],[88.4980316162109,21.8702735900879],[88.49609375,21.9502716064453],[88.4538726806641,21.6149978637695],[88.3908233642578,21.5883293151855],[88.3869323730469,21.6969413757324],[88.3460998535156,21.6838836669922],[88.3333282470703,21.7138824462891],[88.3441467285156,21.6222190856934],[88.30859375,21.6030502319336],[88.2972106933594,21.7727737426758],[88.2619323730469,21.7999992370605],[88.3083190917969,21.5705528259277],[88.2522506713867,21.5505218505859],[88.2050247192383,21.5184726715088],[88.1724853515625,21.539176940918],[88.1222076416016,21.6131191253662],[88.0512237548828,21.6308650970459],[87.9491806030273,21.8009338378906],[87.911018371582,21.8009338378906],[87.8294372558594,21.7191619873047],[87.6849822998047,21.6477737426758],[87.4808959960938,21.6117858886719],[87.1169281005859,21.5113868713379],[86.8755340576172,21.2744407653809],[86.8344268798828,21.1894378662109],[86.8352661132812,21.1061058044434],[86.9674835205078,20.7952766418457],[86.8788604736328,20.7677764892578],[86.9855346679688,20.7527770996094],[86.9949798583984,20.7066612243652],[86.9371948242188,20.6999969482422],[86.9888763427734,20.6716613769531],[87.0416564941406,20.6933288574219],[86.7558288574219,20.491382598877],[86.7208251953125,20.3724975585938],[86.7852630615234,20.3852729797363],[86.8044281005859,20.436107635498],[86.800537109375,20.381664276123],[86.6927490234375,20.2941627502441],[86.7480316162109,20.3061065673828],[86.5744323730469,20.2124938964844],[86.4888763427734,20.1072196960449],[86.3936004638672,20.0138854980469],[86.4238739013672,19.9861068725586],[86.2802734375,19.9141616821289],[85.6238708496094,19.7136077880859],[85.2341461181641,19.5119438171387],[84.8663787841797,19.220272064209],[84.7861022949219,19.1144409179688],[84.7419281005859,19.1488838195801],[84.7265853881836,19.1240005493164],[84.7352600097656,19.0747184753418],[84.7808227539062,19.0941619873047],[84.6763763427734,18.9419403076172],[84.4355316162109,18.6463851928711],[84.2755432128906,18.5183296203613],[84.2449798583984,18.5249977111816],[84.2416534423828,18.4961051940918],[84.2766571044922,18.499439239502],[84.3494262695312,18.548885345459],[84.1416625976562,18.3711090087891],[84.0802764892578,18.2686080932617],[83.7758178710938,18.1427726745605],[83.582763671875,18.0174980163574],[83.4705352783203,17.8999977111816],[83.4433135986328,17.915828704834],[83.4566497802734,17.8813858032227],[83.3422088623047,17.7144393920898],[83.2949829101562,17.686939239502],[83.2369232177734,17.7116622924805],[83.2969360351562,17.6655502319336],[83.2130432128906,17.6313858032227],[83.2385864257812,17.600830078125],[83.2163848876953,17.5805511474609],[82.5055541992188,17.2230491638184],[82.5,17.21792104076],[82.5,22.5],[96.6158142089844,22.5],],
			},
			"595" => {
				"z" => "Asia/Calcutta",
				"c" => "ESRI",
				"s" => "38,2",
				"p" => [[90.3388314603974,7.5],[90.3301544189453,15.2302894592285],[94.58984375,15.2302894592285],[94.5922912567023,7.5],[94.5928039550781,7.5],[90.3388314603974,7.5],],
			},
		},
		# Grid 6:2 ; 5 records
		"2" => {
			"def_z" => "Etc/GMT+8",
			"12" => {
				"z" => "Asia/Katmandu",
				"c" => "ESRI",
				"s" => "3,1",
				"p" => [[82.5,30.2111053466797],[82.5,29.9661989381317],[82.5577545166016,29.9427719116211],[82.6558227539062,29.8352737426758],[82.7155456542969,29.8319396972656],[82.7105407714844,29.7897186279297],[82.8552551269531,29.6688842773438],[82.9085998535156,29.6944389343262],[82.9922027587891,29.6724967956543],[83.0927581787109,29.5830535888672],[83.1174774169922,29.6205520629883],[83.1952514648438,29.6308288574219],[83.2830505371094,29.5511093139648],[83.284423828125,29.474437713623],[83.3460998535156,29.4966621398926],[83.379150390625,29.4661064147949],[83.3805389404297,29.4163856506348],[83.5274810791016,29.2691650390625],[83.5527648925781,29.1858291625977],[83.6719207763672,29.1602745056152],[83.7205352783203,29.2288818359375],[83.9124908447266,29.2897186279297],[84.1138763427734,29.2619438171387],[84.1366577148438,29.2144393920898],[84.1855316162109,29.2055511474609],[84.1583251953125,29.1347198486328],[84.2024841308594,29.056941986084],[84.256103515625,29.0422210693359],[84.2369232177734,28.9188842773438],[84.3955383300781,28.8591613769531],[84.4810943603516,28.7366600036621],[84.6363830566406,28.7027740478516],[84.7066497802734,28.6605529785156],[84.7061004638672,28.6013870239258],[84.7747039794922,28.5988845825195],[84.8466491699219,28.5444412231445],[84.9547119140625,28.5441627502441],[85.0599822998047,28.6411056518555],[85.1899719238281,28.603328704834],[85.1819305419922,28.5299987792969],[85.1019287109375,28.446662902832],[85.1033172607422,28.3163890838623],[85.3766479492188,28.2636108398438],[85.4588775634766,28.3016624450684],[85.6199798583984,28.2511100769043],[85.7183227539062,28.3394393920898],[85.7472076416016,28.2369384765625],[85.8861083984375,28.1516609191895],[85.9188690185547,28.033332824707],[85.9780426025391,27.9897155761719],[85.9730377197266,27.915828704834],[86.0144348144531,27.8827743530273],[86.0894317626953,27.8908309936523],[86.13720703125,27.9319381713867],[86.0935974121094,28.086109161377],[86.18359375,28.1638832092285],[86.2263793945312,28.006664276123],[86.4449768066406,27.9080505371094],[86.5349884033203,27.9549942016602],[86.5719299316406,28.1058311462402],[86.6366577148438,28.0855522155762],[86.6863708496094,28.1122169494629],[86.7580413818359,28.0802764892578],[86.76416015625,28.0266647338867],[86.8741455078125,28.0177764892578],[86.9330444335938,27.9505500793457],[87.0394287109375,27.9608268737793],[87.1927490234375,27.8230514526367],[87.3060913085938,27.8163871765137],[87.4041595458984,27.8605537414551],[87.3936004638672,27.8091621398926],[87.5460968017578,27.8458290100098],[87.5977630615234,27.8102760314941],[87.6605377197266,27.8288841247559],[87.7205352783203,27.8049964904785],[87.7972106933594,27.8372192382812],[87.8688659667969,27.9188842773438],[88.1427917480469,27.8660545349121],[88.1938629150391,27.8474960327148],[88.1888732910156,27.7877769470215],[88.119140625,27.6083297729492],[88.0569305419922,27.533332824707],[88.0666656494141,27.436939239502],[88.0388793945312,27.376106262207],[88.0597076416016,27.3277740478516],[87.9930419921875,27.1144409179688],[88.1185913085938,26.9844398498535],[88.1949768066406,26.7541656494141],[88.1019287109375,26.5302791595459],[88.0958251953125,26.4388847351074],[88.0263824462891,26.3691635131836],[87.9494171142578,26.4005508422852],[87.8905487060547,26.4733276367188],[87.8430480957031,26.4388847351074],[87.7855377197266,26.4563827514648],[87.7663879394531,26.4086074829102],[87.6974792480469,26.4294395446777],[87.5999908447266,26.3797187805176],[87.4474792480469,26.4324951171875],[87.3708190917969,26.4033279418945],[87.3280487060547,26.3477745056152],[87.2452545166016,26.4122161865234],[87.1374969482422,26.4097175598145],[87.0941467285156,26.4563827514648],[87.0613708496094,26.5883293151855],[86.885986328125,26.4686508178711],[86.7316589355469,26.419994354248],[86.5349884033203,26.5280532836914],[86.3324890136719,26.5849952697754],[86.3316650390625,26.6127738952637],[86.2066497802734,26.5855522155762],[86.1838607788086,26.6080513000488],[86.0294342041016,26.6630516052246],[85.8502655029297,26.5722198486328],[85.7305450439453,26.6672172546387],[85.7260894775391,26.8016624450684],[85.6302642822266,26.8674964904785],[85.4530487060547,26.7869415283203],[85.4124908447266,26.7947196960449],[85.3344268798828,26.7358283996582],[85.2116546630859,26.7669410705566],[85.1838684082031,26.8666648864746],[85.0408172607422,26.8477745056152],[85.0410919189453,26.886661529541],[84.9733123779297,26.9030494689941],[84.9527740478516,26.9580497741699],[84.8435974121094,27.0152740478516],[84.7502746582031,27.0074996948242],[84.6474914550781,27.0452766418457],[84.6841430664062,27.2155494689941],[84.6099853515625,27.3355522155762],[84.2977600097656,27.3883285522461],[84.1433258056641,27.5241661071777],[84.098876953125,27.5161094665527],[84.0402679443359,27.4447174072266],[83.8352661132812,27.4380493164062],[83.8755340576172,27.3808288574219],[83.8583221435547,27.3522186279297],[83.6077575683594,27.4691619873047],[83.3961029052734,27.4786071777344],[83.3766479492188,27.3752746582031],[83.2913665771484,27.337776184082],[83.1763763427734,27.4488830566406],[82.7686004638672,27.5016632080078],[82.7010955810547,27.7111053466797],[82.5,27.6842664932109],[82.5,27.6755523681641],[82.5,30.2111053466797],],
			},
			"363" => {
				"z" => "Asia/Thimphu",
				"c" => "ESRI",
				"s" => "21,3",
				"p" => [[88.9169311523438,27.3208312988281],[88.9710998535156,27.4736061096191],[89.1258087158203,27.567497253418],[89.1280364990234,27.6233291625977],[89.2255401611328,27.7949981689453],[89.3599853515625,27.8716621398926],[89.4874877929688,28.0577735900879],[89.6235961914062,28.1583290100098],[89.7927551269531,28.1941604614258],[89.8938751220703,28.3061065673828],[89.9502716064453,28.2922210693359],[90.0000152587891,28.3240547180176],[90.3816528320312,28.2513885498047],[90.3955383300781,28.1988830566406],[90.3502655029297,28.1122169494629],[90.3705291748047,28.0802764892578],[90.6080322265625,28.0644416809082],[90.6994171142578,28.0958290100098],[90.9099884033203,28.0494422912598],[91.0108184814453,27.9799957275391],[91.0869293212891,27.9699935913086],[91.2144317626953,28.0730514526367],[91.3149871826172,28.0966644287109],[91.41943359375,28.010555267334],[91.6672058105469,27.9419403076172],[91.6577606201172,27.764720916748],[91.6527709960938,27.7116622924805],[91.5949859619141,27.6455497741699],[91.6208190917969,27.5486068725586],[91.6735992431641,27.4886054992676],[91.7655487060547,27.4569396972656],[91.7683258056641,27.4161071777344],[91.9988708496094,27.4780502319336],[92.0891571044922,27.3494415283203],[92.1144256591797,27.285831451416],[92.0177612304688,27.1724967956543],[92.0099945068359,27.1047172546387],[92.1119232177734,26.9441604614258],[92.0815124511719,26.8690452575684],[91.9972076416016,26.8519401550293],[91.9152679443359,26.8938865661621],[91.9049835205078,26.8055534362793],[91.8435974121094,26.8641624450684],[91.7124938964844,26.7999992370605],[91.5422058105469,26.804443359375],[91.4972076416016,26.8724975585938],[91.4246978759766,26.8755531311035],[91.3796997070312,26.8074989318848],[91.3144226074219,26.7780532836914],[91.0910949707031,26.8163871765137],[91.0319366455078,26.7827758789062],[90.6947021484375,26.7722206115723],[90.5591430664062,26.8072204589844],[90.3852691650391,26.9033279418945],[90.2169342041016,26.850830078125],[90.1774749755859,26.7730522155762],[90.1235961914062,26.7480506896973],[89.8594207763672,26.7366600036621],[89.848876953125,26.70166015625],[89.6855316162109,26.7336044311523],[89.6430511474609,26.7152709960938],[89.6183166503906,26.7269401550293],[89.6361083984375,26.771110534668],[89.5335998535156,26.8122177124023],[89.4683227539062,26.7994422912598],[89.3608093261719,26.8599967956543],[89.2208251953125,26.8147201538086],[89.1260833740234,26.8236083984375],[89.0305480957031,26.9274940490723],[88.9519348144531,26.9266624450684],[88.9333190917969,26.984992980957],[88.8763732910156,26.9505500793457],[88.8636016845703,27.0919418334961],[88.7519378662109,27.1486053466797],[88.7980346679688,27.2463836669922],[88.9013824462891,27.2822189331055],[88.9169311523438,27.3208312988281],],
			},
			"405" => {
				"z" => "Indian/Cocos",
				"c" => "ESRI",
				"s" => "25,1",
				"p" => [[97.5,23.8517036437988],[97.5,22.5],[93.140847910569,22.5],[93.1185913085938,22.533332824707],[93.1363830566406,22.5944404602051],[93.0972137451172,22.6652717590332],[93.0982208251953,22.7903671264648],[93.161376953125,22.9194412231445],[93.1380462646484,23.0480537414551],[93.2013854980469,23.0588874816895],[93.2291564941406,23.0133323669434],[93.2935943603516,23.0088882446289],[93.3866577148438,23.1402740478516],[93.3660888671875,23.3494415283203],[93.4033203125,23.3780517578125],[93.4334564208984,23.6788864135742],[93.4013824462891,23.7358283996582],[93.3844299316406,23.9213829040527],[93.3280487060547,23.9816627502441],[93.3278961181641,24.0359630584717],[93.3420715332031,24.0818023681641],[93.3829498291016,24.08935546875],[93.4935913085938,23.9627723693848],[93.5963745117188,23.9722175598145],[93.6213531494141,24.0161056518555],[93.7533111572266,24.007495880127],[93.8191528320312,23.9352722167969],[93.9266510009766,23.9558296203613],[94.1444396972656,23.8477745056152],[94.38916015625,24.4799957275391],[94.5147094726562,24.619441986084],[94.5385894775391,24.7088851928711],[94.5977630615234,24.7252731323242],[94.7344207763672,25.0247192382812],[94.7285919189453,25.1363830566406],[94.5994262695312,25.1783294677734],[94.5763854980469,25.2144393920898],[94.6255340576172,25.3977737426758],[94.6616516113281,25.4280490875244],[94.8852691650391,25.5722198486328],[94.9919281005859,25.7291603088379],[95.0338745117188,25.7422180175781],[95.022216796875,25.9286079406738],[95.0866546630859,25.9555511474609],[95.1780395507812,26.0588874816895],[95.1133117675781,26.1091613769531],[95.1208190917969,26.20166015625],[95.0838775634766,26.222770690918],[95.0652618408203,26.325553894043],[95.0952606201172,26.4099960327148],[95.0663757324219,26.4797172546387],[95.1477661132812,26.5658302307129],[95.1524810791016,26.6233291625977],[95.2463684082031,26.6797180175781],[95.2711029052734,26.644718170166],[95.4410858154297,26.7091598510742],[95.5194396972656,26.8230514526367],[95.6108093261719,26.8213844299316],[95.6580352783203,26.8952751159668],[95.7177581787109,26.8913841247559],[95.8038635253906,27.0011100769043],[95.9308166503906,27.0461082458496],[96.0358123779297,27.1924934387207],[96.1941375732422,27.2708320617676],[96.5241546630859,27.2941627502441],[96.6099853515625,27.3669395446777],[96.6602630615234,27.3391647338867],[96.7291564941406,27.365550994873],[96.8841552734375,27.2547187805176],[96.8613739013672,27.2102737426758],[96.8883209228516,27.178050994873],[97.0597229003906,27.0930023193359],[97.1444396972656,27.0924949645996],[97.1588745117188,27.1386070251465],[97.1263732910156,27.1908302307129],[96.8999938964844,27.4686050415039],[96.9180450439453,27.5052757263184],[96.8888854980469,27.6174964904785],[97.0466461181641,27.7497177124023],[97.0838775634766,27.7486038208008],[97.2494201660156,27.9074974060059],[97.2991485595703,27.9166641235352],[97.3172149658203,27.8783302307129],[97.3677520751953,27.8966636657715],[97.3941497802734,28.0186080932617],[97.3160858154297,28.0891647338867],[97.348876953125,28.222770690918],[97.4105377197266,28.2924957275391],[97.4688720703125,28.2961082458496],[97.4708251953125,28.3911056518555],[97.5,28.4377828565855],[97.5,25.259162902832],[97.5,23.8517036437988],],
			},
			"593" => {
				"z" => "Asia/Calcutta",
				"c" => "ESRI",
				"s" => "38,1",
				"p" => [[82.5,34.7819366455078],[82.5,27.6842664932109],[82.7010955810547,27.7111053466797],[82.7686004638672,27.5016632080078],[83.1763763427734,27.4488830566406],[83.2913665771484,27.337776184082],[83.3766479492188,27.3752746582031],[83.3961029052734,27.4786071777344],[83.6077575683594,27.4691619873047],[83.8583221435547,27.3522186279297],[83.8755340576172,27.3808288574219],[83.8352661132812,27.4380493164062],[84.0402679443359,27.4447174072266],[84.098876953125,27.5161094665527],[84.1433258056641,27.5241661071777],[84.2977600097656,27.3883285522461],[84.6099853515625,27.3355522155762],[84.6841430664062,27.2155494689941],[84.6474914550781,27.0452766418457],[84.7502746582031,27.0074996948242],[84.8435974121094,27.0152740478516],[84.9527740478516,26.9580497741699],[84.9733123779297,26.9030494689941],[85.0410919189453,26.886661529541],[85.0408172607422,26.8477745056152],[85.1838684082031,26.8666648864746],[85.2116546630859,26.7669410705566],[85.3344268798828,26.7358283996582],[85.4124908447266,26.7947196960449],[85.4530487060547,26.7869415283203],[85.6302642822266,26.8674964904785],[85.7260894775391,26.8016624450684],[85.7305450439453,26.6672172546387],[85.8502655029297,26.5722198486328],[86.0294342041016,26.6630516052246],[86.1838607788086,26.6080513000488],[86.2066497802734,26.5855522155762],[86.3316650390625,26.6127738952637],[86.3324890136719,26.5849952697754],[86.5349884033203,26.5280532836914],[86.7316589355469,26.419994354248],[86.885986328125,26.4686508178711],[87.0613708496094,26.5883293151855],[87.0941467285156,26.4563827514648],[87.1374969482422,26.4097175598145],[87.2452545166016,26.4122161865234],[87.3280487060547,26.3477745056152],[87.3708190917969,26.4033279418945],[87.4474792480469,26.4324951171875],[87.5999908447266,26.3797187805176],[87.6974792480469,26.4294395446777],[87.7663879394531,26.4086074829102],[87.7855377197266,26.4563827514648],[87.8430480957031,26.4388847351074],[87.8905487060547,26.4733276367188],[87.9494171142578,26.4005508422852],[88.0263824462891,26.3691635131836],[88.0958251953125,26.4388847351074],[88.1019287109375,26.5302791595459],[88.1949768066406,26.7541656494141],[88.1185913085938,26.9844398498535],[87.9930419921875,27.1144409179688],[88.0597076416016,27.3277740478516],[88.0388793945312,27.376106262207],[88.0666656494141,27.436939239502],[88.0569305419922,27.533332824707],[88.119140625,27.6083297729492],[88.1888732910156,27.7877769470215],[88.1938629150391,27.8474960327148],[88.1427917480469,27.8660545349121],[88.1205291748047,27.9047164916992],[88.1455383300781,27.9552726745605],[88.5341491699219,28.0291633605957],[88.6227569580078,28.1180534362793],[88.8316650390625,28.0133323669434],[88.8808135986328,27.8366622924805],[88.8344268798828,27.6611061096191],[88.7633209228516,27.5433311462402],[88.7833251953125,27.4380493164062],[88.9169311523438,27.3208312988281],[88.9013824462891,27.2822189331055],[88.7980346679688,27.2463836669922],[88.7519378662109,27.1486053466797],[88.8636016845703,27.0919418334961],[88.8763732910156,26.9505500793457],[88.9333190917969,26.984992980957],[88.9519348144531,26.9266624450684],[89.0305480957031,26.9274940490723],[89.1260833740234,26.8236083984375],[89.2208251953125,26.8147201538086],[89.3608093261719,26.8599967956543],[89.4683227539062,26.7994422912598],[89.5335998535156,26.8122177124023],[89.6361083984375,26.771110534668],[89.6183166503906,26.7269401550293],[89.6430511474609,26.7152709960938],[89.6855316162109,26.7336044311523],[89.848876953125,26.70166015625],[89.8594207763672,26.7366600036621],[90.1235961914062,26.7480506896973],[90.1774749755859,26.7730522155762],[90.2169342041016,26.850830078125],[90.3852691650391,26.9033279418945],[90.5591430664062,26.8072204589844],[90.6947021484375,26.7722206115723],[91.0319366455078,26.7827758789062],[91.0910949707031,26.8163871765137],[91.3144226074219,26.7780532836914],[91.3796997070312,26.8074989318848],[91.4246978759766,26.8755531311035],[91.4972076416016,26.8724975585938],[91.5422058105469,26.804443359375],[91.7124938964844,26.7999992370605],[91.8435974121094,26.8641624450684],[91.9049835205078,26.8055534362793],[91.9152679443359,26.8938865661621],[91.9972076416016,26.8519401550293],[92.0815124511719,26.8690452575684],[92.1119232177734,26.9441604614258],[92.0099945068359,27.1047172546387],[92.0177612304688,27.1724967956543],[92.1144256591797,27.285831451416],[92.0891571044922,27.3494415283203],[91.9988708496094,27.4780502319336],[91.7683258056641,27.4161071777344],[91.7655487060547,27.4569396972656],[91.6735992431641,27.4886054992676],[91.6208190917969,27.5486068725586],[91.5949859619141,27.6455497741699],[91.6527709960938,27.7116622924805],[91.6577606201172,27.764720916748],[92.0144271850586,27.7347202301025],[92.1183166503906,27.8125],[92.2538833618164,27.8158302307129],[92.2680435180664,27.874719619751],[92.3311004638672,27.7947196960449],[92.3583068847656,27.8444404602051],[92.3866577148438,27.8047199249268],[92.4147033691406,27.860279083252],[92.4524765014648,27.8263893127441],[92.6994171142578,27.9555492401123],[92.7283782958984,28.0359802246094],[92.6752471923828,28.0807094573975],[92.7528991699219,28.1689205169678],[92.8300323486328,28.212760925293],[92.8412475585938,28.1888008117676],[92.887336730957,28.1987209320068],[92.9915237426758,28.2628593444824],[93.0104370117188,28.2422504425049],[93.0457077026367,28.3102607727051],[93.222053527832,28.319299697876],[93.238166809082,28.3874492645264],[93.1927032470703,28.4321308135986],[93.2815170288086,28.4929599761963],[93.351936340332,28.6187591552734],[93.4940795898438,28.6519203186035],[93.5020599365234,28.6791591644287],[93.6472930908203,28.6474609375],[93.858512878418,28.6903800964355],[93.9805908203125,28.6451797485352],[93.9617233276367,28.6692008972168],[94.0124206542969,28.747350692749],[94.0211029052734,28.8360290527344],[94.152458190918,28.930700302124],[94.2345581054688,29.0734806060791],[94.4277572631836,29.2155094146729],[94.5811996459961,29.2315292358398],[94.6475067138672,29.333459854126],[94.6973571777344,29.3365306854248],[94.7922668457031,29.260799407959],[94.8333511352539,29.1683692932129],[95.0091552734375,29.1238861083984],[94.9847106933594,29.1736068725586],[95.3877716064453,29.0352745056152],[95.4605407714844,29.0516624450684],[95.49609375,29.1408309936523],[95.5466461181641,29.1386070251465],[95.534423828125,29.2116622924805],[95.5910949707031,29.254997253418],[96.0838775634766,29.4677734375],[96.2352600097656,29.2544441223145],[96.2894287109375,29.241382598877],[96.3624877929688,29.2905540466309],[96.395263671875,29.2552757263184],[96.3486022949219,29.1799964904785],[96.2566528320312,29.1644401550293],[96.119140625,29.0791625976562],[96.1822052001953,28.9952735900879],[96.1486053466797,28.9433288574219],[96.1691436767578,28.9036064147949],[96.3438720703125,29.0324974060059],[96.5119323730469,29.069995880127],[96.4758148193359,28.9747161865234],[96.5102691650391,28.9644393920898],[96.6158142089844,28.7902755737305],[96.6060943603516,28.7394371032715],[96.4708251953125,28.6883277893066],[96.4783172607422,28.6386070251465],[96.3452606201172,28.556941986084],[96.3663787841797,28.480827331543],[96.2647094726562,28.4152717590332],[96.3616485595703,28.3927726745605],[96.3969421386719,28.353328704834],[96.4019317626953,28.3511085510254],[96.4605407714844,28.4219398498535],[96.6538696289062,28.4674949645996],[96.7841491699219,28.3730506896973],[96.8897094726562,28.3786087036133],[96.9847106933594,28.3324966430664],[97.1349945068359,28.3813858032227],[97.348876953125,28.222770690918],[97.3160858154297,28.0891647338867],[97.3941497802734,28.0186080932617],[97.3677520751953,27.8966636657715],[97.3172149658203,27.8783302307129],[97.2991485595703,27.9166641235352],[97.2494201660156,27.9074974060059],[97.0838775634766,27.7486038208008],[97.0466461181641,27.7497177124023],[96.8888854980469,27.6174964904785],[96.9180450439453,27.5052757263184],[96.8999938964844,27.4686050415039],[97.1263732910156,27.1908302307129],[97.1588745117188,27.1386070251465],[97.1444396972656,27.0924949645996],[97.0597229003906,27.0930023193359],[96.8883209228516,27.178050994873],[96.8613739013672,27.2102737426758],[96.8841552734375,27.2547187805176],[96.7291564941406,27.365550994873],[96.6602630615234,27.3391647338867],[96.6099853515625,27.3669395446777],[96.5241546630859,27.2941627502441],[96.1941375732422,27.2708320617676],[96.0358123779297,27.1924934387207],[95.9308166503906,27.0461082458496],[95.8038635253906,27.0011100769043],[95.7177581787109,26.8913841247559],[95.6580352783203,26.8952751159668],[95.6108093261719,26.8213844299316],[95.5194396972656,26.8230514526367],[95.4410858154297,26.7091598510742],[95.2711029052734,26.644718170166],[95.2463684082031,26.6797180175781],[95.1524810791016,26.6233291625977],[95.1477661132812,26.5658302307129],[95.0663757324219,26.4797172546387],[95.0952606201172,26.4099960327148],[95.0652618408203,26.325553894043],[95.0838775634766,26.222770690918],[95.1208190917969,26.20166015625],[95.1133117675781,26.1091613769531],[95.1780395507812,26.0588874816895],[95.0866546630859,25.9555511474609],[95.022216796875,25.9286079406738],[95.0338745117188,25.7422180175781],[94.9919281005859,25.7291603088379],[94.8852691650391,25.5722198486328],[94.6616516113281,25.4280490875244],[94.6255340576172,25.3977737426758],[94.5763854980469,25.2144393920898],[94.5994262695312,25.1783294677734],[94.7285919189453,25.1363830566406],[94.7344207763672,25.0247192382812],[94.5977630615234,24.7252731323242],[94.5385894775391,24.7088851928711],[94.5147094726562,24.619441986084],[94.38916015625,24.4799957275391],[94.1444396972656,23.8477745056152],[93.9266510009766,23.9558296203613],[93.8191528320312,23.9352722167969],[93.7533111572266,24.007495880127],[93.6213531494141,24.0161056518555],[93.5963745117188,23.9722175598145],[93.4935913085938,23.9627723693848],[93.3829498291016,24.08935546875],[93.3420715332031,24.0818023681641],[93.3278961181641,24.0359630584717],[93.3280487060547,23.9816627502441],[93.3844299316406,23.9213829040527],[93.4013824462891,23.7358283996582],[93.4334564208984,23.6788864135742],[93.4033203125,23.3780517578125],[93.3660888671875,23.3494415283203],[93.3866577148438,23.1402740478516],[93.2935943603516,23.0088882446289],[93.2291564941406,23.0133323669434],[93.2013854980469,23.0588874816895],[93.1380462646484,23.0480537414551],[93.161376953125,22.9194412231445],[93.0982208251953,22.7903671264648],[93.0972137451172,22.6652717590332],[93.1363830566406,22.5944404602051],[93.1185913085938,22.533332824707],[93.140847910569,22.5],[92.5513955948648,22.5],[92.5163879394531,22.7158279418945],[92.4705352783203,22.7563858032227],[92.4438629150391,22.8894386291504],[92.3746948242188,22.9419403076172],[92.3486022949219,23.2236061096191],[92.3869781494141,23.2799263000488],[92.3735809326172,23.359245300293],[92.2783203125,23.6049957275391],[92.2888793945312,23.6961059570312],[92.2522125244141,23.7224960327148],[92.2116546630859,23.6522178649902],[92.1748504638672,23.7368202209473],[92.0372009277344,23.6452751159668],[91.9499969482422,23.7322158813477],[91.9660949707031,23.5016632080078],[91.9330444335938,23.4444389343262],[91.8449859619141,23.4102745056152],[91.7835998535156,23.3124961853027],[91.7680511474609,23.25],[91.8205413818359,23.0977745056152],[91.7249908447266,22.9947166442871],[91.647216796875,22.9863815307617],[91.6136016845703,22.9430503845215],[91.5635986328125,22.9836044311523],[91.4933166503906,23.1866607666016],[91.4166564941406,23.2661094665527],[91.3774719238281,23.2069396972656],[91.4022064208984,23.0694427490234],[91.3355407714844,23.115550994873],[91.2885894775391,23.3283309936523],[91.314697265625,23.3641624450684],[91.2822113037109,23.3733291625977],[91.159423828125,23.640552520752],[91.2002716064453,23.678050994873],[91.1591491699219,23.7008285522461],[91.1585998535156,23.7366600036621],[91.2163848876953,23.7561073303223],[91.2505493164062,23.8302764892578],[91.2377624511719,23.907772064209],[91.2983245849609,23.9938850402832],[91.3610992431641,23.9952735900879],[91.373291015625,24.1019401550293],[91.5463256835938,24.0869407653809],[91.6274566650391,24.1097183227539],[91.6571960449219,24.2241630554199],[91.703857421875,24.1516609191895],[91.7552490234375,24.1583290100098],[91.7577514648438,24.2391624450684],[91.8319244384766,24.2261047363281],[91.8924865722656,24.149715423584],[91.9324798583984,24.2755508422852],[91.9177551269531,24.32666015625],[91.9466400146484,24.3494415283203],[91.9894256591797,24.3194389343262],[91.9747009277344,24.3788833618164],[92.0863800048828,24.3747177124023],[92.1352691650391,24.4141616821289],[92.1324768066406,24.5138854980469],[92.1910858154297,24.5652732849121],[92.2566528320312,24.7738876342773],[92.2552642822266,24.9036064147949],[92.4017333984375,24.8404197692871],[92.4938354492188,24.8787879943848],[92.4830474853516,24.9299964904785],[92.4166564941406,24.9724960327148],[92.4063720703125,25.0305519104004],[92.0408172607422,25.1877746582031],[91.7574920654297,25.173885345459],[91.6488800048828,25.1266632080078],[91.5902709960938,25.1727714538574],[91.4822082519531,25.1386070251465],[91.2577667236328,25.2077713012695],[90.8480377197266,25.1486053466797],[90.6530456542969,25.1811065673828],[90.4383087158203,25.147216796875],[90.1105346679688,25.2247161865234],[89.9172058105469,25.3099975585938],[89.8452606201172,25.2886085510254],[89.8155364990234,25.3669395446777],[89.8644256591797,25.640552520752],[89.8072052001953,25.8230514526367],[89.8654479980469,25.9368629455566],[89.8167114257812,25.9541664123535],[89.8563690185547,25.9811058044434],[89.7780456542969,26.0419425964355],[89.7391510009766,26.1563835144043],[89.649299621582,26.1894607543945],[89.6386032104492,26.2278003692627],[89.6017227172852,26.2274703979492],[89.6089630126953,26.1779003143311],[89.5598678588867,26.1614608764648],[89.6024169921875,26.0689601898193],[89.5255126953125,25.9882106781006],[89.3935470581055,26.0478992462158],[89.3199081420898,26.024829864502],[89.1296768188477,26.1592693328857],[89.0672073364258,26.3876991271973],[88.9387817382812,26.4458198547363],[88.9091567993164,26.3927097320557],[88.9815826416016,26.2956695556641],[89.0413436889648,26.2817897796631],[89.0204772949219,26.2351703643799],[88.88330078125,26.2852001190186],[88.8238220214844,26.2334308624268],[88.7673416137695,26.2985897064209],[88.6691818237305,26.2609004974365],[88.6795120239258,26.3074207305908],[88.7303771972656,26.3206806182861],[88.6916427612305,26.3427600860596],[88.6808166503906,26.4202709197998],[88.4330444335938,26.5513877868652],[88.4010925292969,26.6252746582031],[88.3377685546875,26.4738845825195],[88.3535919189453,26.45166015625],[88.37109375,26.4891624450684],[88.4833221435547,26.4611053466797],[88.5255432128906,26.3597183227539],[88.4574890136719,26.3691635131836],[88.3560943603516,26.2844429016113],[88.3552551269531,26.2233276367188],[88.1844177246094,26.1524963378906],[88.1563720703125,26.0924949645996],[88.1833190917969,26.0338859558105],[88.0955352783203,25.9152717590332],[88.1105346679688,25.8355522155762],[88.1519317626953,25.7786102294922],[88.2799835205078,25.8016624450684],[88.4469299316406,25.6661071777344],[88.4505462646484,25.5938873291016],[88.5469360351562,25.5041656494141],[88.6941375732422,25.4677734375],[88.7997131347656,25.510555267334],[88.8344268798828,25.4791603088379],[88.8216552734375,25.4016609191895],[88.8699798583984,25.3358306884766],[89.0088806152344,25.3008308410645],[88.9330444335938,25.1644401550293],[88.8377685546875,25.2036056518555],[88.8058166503906,25.1655502319336],[88.7049865722656,25.1952743530273],[88.6202545166016,25.1980514526367],[88.5813751220703,25.1694412231445],[88.4555511474609,25.1905517578125],[88.4599914550781,25.0694427490234],[88.3424835205078,24.8702735900879],[88.2674865722656,24.8847198486328],[88.2213439941406,24.9543228149414],[88.1377716064453,24.9213829040527],[88.1710968017578,24.8516616821289],[88.0438690185547,24.6897163391113],[88.1255340576172,24.5086097717285],[88.3238830566406,24.434440612793],[88.4977569580078,24.3208312988281],[88.7063751220703,24.3027763366699],[88.7529144287109,24.2141227722168],[88.7083282470703,24.1713829040527],[88.7073364257812,24.1217060089111],[88.7013854980469,24.0791625976562],[88.7591857910156,24.0360336303711],[88.7227172851562,23.9979667663574],[88.7366485595703,23.9197959899902],[88.6694946289062,23.8685417175293],[88.6028442382812,23.8623962402344],[88.5638732910156,23.6522178649902],[88.7494201660156,23.4669380187988],[88.7933197021484,23.4941596984863],[88.7113800048828,23.3086090087891],[88.7210998535156,23.2516632080078],[88.9860992431641,23.2083282470703],[88.8702545166016,23.087776184082],[88.8627624511719,22.9666633605957],[88.9710998535156,22.8469429016113],[88.9302673339844,22.7483291625977],[88.9586029052734,22.5913848876953],[88.9291687011719,22.5476684570312],[88.9689828349305,22.5],[82.5,22.5],[82.5,24.1697158813477],[82.5,34.7819366455078],],
			},
		},
		# Grid 6:3 ; 2 records
		"3" => {
			"def_z1" => "91.6333333,48.0166667,Asia/Hovd",
			"def_z0" => "90.9,49.2666667,Asia/Hovd",
			"def_z2" => "87.5833333,43.8,Asia/Urumqi",
			"def_z3" => "90.5166667,49.3,Asia/Hovd",
			"378" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,1",
				"p" => [[97.5,49.9327697753906],[97.5,49.8080529718377],[97.3130340576172,49.7311019897461],[97.16943359375,49.7616653442383],[96.9969329833984,49.894157409668],[96.7224884033203,49.9211044311523],[96.5924835205078,49.8649978637695],[96.5474853515625,49.9258270263672],[96.379150390625,49.8936080932617],[96.29443359375,49.9466552734375],[96.0744323730469,50.0069427490234],[95.9602661132812,49.9441528320312],[95.9072113037109,50.01416015625],[95.834716796875,50.0249938964844],[95.7352600097656,49.9547119140625],[95.5919342041016,49.9408264160156],[95.5385894775391,49.8947143554688],[95.491569519043,49.9076957702637],[95.4224853515625,49.9561004638672],[95.0660858154297,49.9619369506836],[94.9760894775391,50.0560989379883],[94.6227569580078,50.0299911499023],[94.5158233642578,50.1611022949219],[94.3899841308594,50.2144393920898],[94.3522033691406,50.4149932861328],[94.2749938964844,50.5694427490234],[93.5583190917969,50.589714050293],[93.4488677978516,50.6224899291992],[93.0333251953125,50.6086044311523],[92.9710235595703,50.6664886474609],[92.9991455078125,50.7513885498047],[92.9749908447266,50.7911071777344],[92.8027648925781,50.7936096191406],[92.7602691650391,50.7124938964844],[92.6608123779297,50.6816635131836],[92.5736083984375,50.7577743530273],[92.4727630615234,50.785270690918],[92.3836059570312,50.8747100830078],[92.3269348144531,50.8549957275391],[92.2949829101562,50.7536087036133],[92.2213745117188,50.7055511474609],[91.9055480957031,50.714714050293],[91.772216796875,50.6899871826172],[91.6588745117188,50.6372146606445],[91.60693359375,50.5730514526367],[91.4677581787109,50.5269393920898],[91.4474792480469,50.4710998535156],[91.0297088623047,50.4330520629883],[90.8702545166016,50.3263854980469],[90.7485961914062,50.297492980957],[90.6985931396484,50.2194366455078],[90.5097198486328,50.2244338989258],[90.3785858154297,50.1858215332031],[90.2444305419922,50.1202697753906],[90.0513763427734,50.0824966430664],[89.9852600097656,49.9722137451172],[89.6427001953125,49.9048309326172],[89.6374969482422,49.8549957275391],[89.6713714599609,49.8208312988281],[89.6510925292969,49.7952728271484],[89.7360992431641,49.7488784790039],[89.7113800048828,49.714714050293],[89.459716796875,49.6499938964844],[89.3722076416016,49.579719543457],[89.2266540527344,49.6383285522461],[89.1974792480469,49.6111068725586],[89.2305450439453,49.5366592407227],[89.0133209228516,49.4636077880859],[88.9288635253906,49.54638671875],[88.8874969482422,49.5436096191406],[88.8999938964844,49.4433212280273],[88.7308197021484,49.4508285522461],[88.6508178710938,49.5005493164062],[88.2208251953125,49.4616622924805],[88.1319274902344,49.3683242797852],[88.1622009277344,49.272216796875],[87.9885864257812,49.1772155761719],[87.8406982421875,49.1729507446289],[87.5252685546875,49.1291580200195],[87.4669342041016,49.079719543457],[87.3482055664062,49.0926208496094],[87.2997131347656,49.2105484008789],[87.2188720703125,49.2461013793945],[87.0524749755859,49.2541656494141],[86.9266510009766,49.3530502319336],[86.9644317626953,49.3919372558594],[86.8397064208984,49.4522171020508],[86.8469390869141,49.5216598510742],[86.6166534423828,49.5872116088867],[86.6822052001953,49.6699905395508],[86.8002624511719,49.7022171020508],[86.7627716064453,49.7344360351562],[86.7749938964844,49.7888870239258],[86.6163787841797,49.7972183227539],[86.6110992431641,49.7611083984375],[86.4970855712891,49.7155075073242],[86.5058288574219,49.676383972168],[86.2874908447266,49.585823059082],[86.2458190917969,49.5013885498047],[86.1910858154297,49.4724884033203],[86.1327514648438,49.5327682495117],[85.9694366455078,49.4886016845703],[85.9691467285156,49.5663833618164],[85.8372039794922,49.5438842773438],[85.7708282470703,49.5799942016602],[85.6905364990234,49.5644378662109],[85.6308135986328,49.6274871826172],[85.5244293212891,49.5905456542969],[85.4038696289062,49.6233215332031],[85.2586059570312,49.5913772583008],[85.2111053466797,49.647216796875],[85.2105407714844,49.7155456542969],[85.0919342041016,49.8197174072266],[85.0836029052734,49.8813781738281],[84.9777679443359,49.9127655029297],[84.9791564941406,49.9977722167969],[85.0583190917969,50.0136108398438],[85.0144348144531,50.0758285522461],[84.8519287109375,50.0916595458984],[84.8105316162109,50.144157409668],[84.7363739013672,50.1461029052734],[84.6744232177734,50.1969375610352],[84.5599822998047,50.1955413818359],[84.473876953125,50.2566604614258],[84.3730316162109,50.209716796875],[84.2669372558594,50.2705459594727],[84.2627716064453,50.3544387817383],[84.1969299316406,50.4530487060547],[84.2230377197266,50.5147171020508],[84.1062164306641,50.6429595947266],[83.9699859619141,50.7155456542969],[83.9769287109375,50.797492980957],[83.9016571044922,50.8138809204102],[83.8433227539062,50.8774871826172],[83.5136108398438,50.9555511474609],[83.4563751220703,51.0024948120117],[83.1385955810547,51.0019378662109],[83.0872039794922,50.9236068725586],[83.0099945068359,50.8894348144531],[82.7611083984375,50.9108200073242],[82.7274780273438,50.8988800048828],[82.7202606201172,50.8108215332031],[82.5,50.7215574594359],[82.5,52.5],[97.5,52.5],[97.5,51.4669342041016],[97.5,49.9327697753906],],
			},
		},
		# Grid 6:4 ; 3 records
		"4" => {
			"def_z1" => "82.9344444,55.0411111,Asia/Novosibirsk",
			"def_z0" => "90.8627778,55.1202778,Asia/Kamchatka",
			"127" => {
				"z" => "Etc/GMT+8",
				"c" => "ESRI",
				"s" => "11,2",
				"p" => [[97.5,59.0616607666016],[97.5,52.5],[97.5,53.4516653334243],[97.4410858154297,53.4602737426758],[97.3322143554688,53.5999984741211],[97.1227569580078,53.6094360351562],[96.8866577148438,53.728874206543],[96.7277679443359,53.706657409668],[96.6841430664062,53.6386032104492],[96.6085968017578,53.6758270263672],[96.5716552734375,53.6455459594727],[96.5,53.6849899291992],[96.2072143554688,53.926383972168],[96.0494232177734,53.9955444335938],[96.0816650390625,54.0574951171875],[96.0533142089844,54.093879699707],[95.988037109375,54.0872116088867],[95.9180450439453,54.1599884033203],[95.6585998535156,54.2594375610352],[95.6630401611328,54.3399887084961],[95.7052612304688,54.3799896240234],[95.7908172607422,54.4208297729492],[95.915771484375,54.3955917358398],[95.9866485595703,54.4483261108398],[95.9763793945312,54.4772109985352],[96.0558166503906,54.5761032104492],[96.2172088623047,54.5408325195312],[96.3158264160156,54.5713882446289],[96.5708312988281,54.5124969482422],[96.550537109375,54.5808258056641],[96.5888824462891,54.6597137451172],[96.5619201660156,54.6969375610352],[96.6735992431641,54.8022155761719],[96.7152709960938,54.9213790893555],[96.5777740478516,55.0202713012695],[96.6869201660156,55.0808258056641],[96.6519317626953,55.0986022949219],[96.6972045898438,55.1727676391602],[96.7005462646484,55.2552719116211],[96.9202575683594,55.3247146606445],[96.8413696289062,55.4374923706055],[96.8552551269531,55.4777679443359],[96.8172149658203,55.5591583251953],[96.8558197021484,55.5944366455078],[96.7463684082031,55.6513824462891],[96.82470703125,55.6974868774414],[96.7552642822266,55.7472152709961],[96.8211059570312,55.7916641235352],[96.9697113037109,55.855827331543],[96.9805450439453,56.022216796875],[97.0610961914062,56.0255508422852],[97.1235961914062,56.1163864135742],[97.3522033691406,56.0486068725586],[97.4324798583984,56.0958251953125],[97.4285888671875,56.1466598510742],[97.5,56.1659491837593],[97.5,56.8088191347628],[97.4858093261719,56.8102722167969],[97.4805450439453,56.8911056518555],[97.5,56.8998664239919],[97.5,56.9629912620923],[97.4769287109375,56.9644393920898],[97.340087890625,57.0431747436523],[97.5,57.2548039732715],[97.5,61.1811065673828],[97.5,59.0616607666016],],
			},
			"575" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,2",
				"p" => [[82.5,67.5],[82.5,67.0957327793736],[83.0410919189453,66.8922119140625],[83.0619201660156,66.8808135986328],[83.0274810791016,66.8597106933594],[83.1724853515625,66.8091430664062],[83.18359375,66.7474822998047],[83.3058166503906,66.6616516113281],[83.0866546630859,66.6105346679688],[83.0869293212891,66.4697113037109],[83.1246948242188,66.4216461181641],[83.3441467285156,66.3419342041016],[83.5397033691406,66.1952514648438],[83.37109375,66.1366577148438],[83.2894287109375,66.0669403076172],[83.3727569580078,65.9835968017578],[83.5280456542969,65.9044342041016],[83.5063781738281,65.8294372558594],[83.5910949707031,65.7736053466797],[84.0111083984375,65.7983245849609],[84.1766510009766,65.6999969482422],[84.3224945068359,65.6760864257812],[84.3191528320312,65.66943359375],[84.2927551269531,65.6121978759766],[84.1905364990234,65.5944366455078],[84.4502716064453,65.5455322265625],[84.5546417236328,65.4351501464844],[84.5019378662109,65.3966522216797],[84.5883178710938,65.3130340576172],[84.5244293212891,65.2127685546875],[84.4099884033203,65.1908111572266],[84.3110961914062,65.0986022949219],[84.3138732910156,65.0572052001953],[84.3810882568359,65.0327606201172],[84.3966522216797,64.9938659667969],[84.2780456542969,64.9405364990234],[84.2913665771484,64.9010925292969],[84.9066467285156,64.9302673339844],[84.9774780273438,64.8866577148438],[84.9322052001953,64.8263854980469],[85.0944366455078,64.8121948242188],[85.1469421386719,64.7516632080078],[85.5469360351562,64.8302764892578],[85.8608093261719,64.7552642822266],[85.80859375,64.6474914550781],[85.9180450439453,64.5836029052734],[85.8452606201172,64.5074920654297],[85.8408203125,64.4588775634766],[85.9235992431641,64.4172058105469],[85.94970703125,64.3283233642578],[86.0310974121094,64.2752685546875],[85.9324798583984,64.1277618408203],[85.9677581787109,64.0977630615234],[85.9580383300781,64.0544281005859],[85.5163879394531,63.9299926757812],[85.3669281005859,63.8133239746094],[85.3399810791016,63.7069396972656],[85.2672119140625,63.6463851928711],[85.1769256591797,63.5913772583008],[85.0899810791016,63.6086044311523],[85.0320281982422,63.5864868164062],[85.0819396972656,63.5363845825195],[85.2119293212891,63.5030517578125],[85.2960968017578,63.5158309936523],[85.3741455078125,63.4622116088867],[85.3897094726562,63.4233245849609],[85.3527679443359,63.4027709960938],[85.4077606201172,63.3499984741211],[85.5594177246094,63.3749923706055],[85.6738739013672,63.3544387817383],[85.5366516113281,63.2608261108398],[85.4783172607422,63.1705474853516],[85.4663848876953,63.1380462646484],[85.587158203125,63.069953918457],[85.4933166503906,62.9902725219727],[85.5208282470703,62.9327697753906],[85.4510955810547,62.8827667236328],[85.3324890136719,62.8733215332031],[85.2371978759766,62.8144378662109],[85.0777740478516,62.6713790893555],[85.0986022949219,62.6386032104492],[84.9480285644531,62.5913772583008],[84.8905487060547,62.5422210693359],[84.9138793945312,62.4994354248047],[84.8591461181641,62.4477691650391],[84.7263793945312,62.4069366455078],[84.4369201660156,62.1891555786133],[84.5544281005859,61.996940612793],[84.5166625976562,61.9391555786133],[84.5574798583984,61.8947143554688],[84.6338806152344,61.8797149658203],[84.6874847412109,61.8060989379883],[85.0080413818359,61.7841644287109],[85.2483215332031,61.6852645874023],[85.3858184814453,61.70166015625],[85.4677581787109,61.6286010742188],[85.7227630615234,61.5736083984375],[85.8519287109375,61.597770690918],[85.9691467285156,61.5430526733398],[85.9663848876953,61.4691543579102],[85.7524871826172,61.4399871826172],[85.6436004638672,61.3880462646484],[85.7105407714844,61.297492980957],[84.6141510009766,61],[84.2596435546875,60.8554153442383],[83.9938659667969,60.8247146606445],[83.5094299316406,61.0491638183594],[83.1449890136719,61.0327682495117],[82.5,60.7620889270868],[82.5,53.9674911499023],[82.5,67.5],],
			},
		},
		# Grid 6:5 ; 2 records
		"5" => {
			"380" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,1",
				"p" => [[97.5,72.3169403076172],[97.5,67.5],[82.5,67.5],[82.5,68.1741227469784],[82.5435943603516,68.1727600097656],[82.5233154296875,68.2069396972656],[82.5736083984375,68.2558288574219],[82.7066497802734,68.2933197021484],[82.6844177246094,68.3463745117188],[82.7124938964844,68.4044342041016],[82.6805419921875,68.4913635253906],[82.5,68.5613144951015],[82.5,68.5953562115012],[82.5491485595703,68.6144256591797],[82.55859375,68.6110992431641],[82.5899810791016,68.6027679443359],[82.6930389404297,68.6327514648438],[82.9010925292969,68.6252593994141],[83.0427551269531,68.6677551269531],[82.8016510009766,68.7408142089844],[82.7828826904297,68.7988128662109],[82.5522003173828,68.8183288574219],[82.5,68.9791591360619],[82.5,69.1069588029557],[82.5047149658203,69.1083221435547],[82.5,69.110073653745],[82.5,74.9676941451173],[82.9028625488281,74.9878387451172],[83.3724899291992,75.3009262084961],[83.4977264404297,75.8331680297852],[83.278564453125,76.1775665283203],[82.8402481079102,76.3654174804688],[82.5,76.4254615511158],[82.5,82.5],[97.5,82.5],[97.5,72.3169403076172],],
			},
			"576" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,2",
				"p" => [[82.5,69.3460998535156],[82.5,69.110073653745],[82.5047149658203,69.1083221435547],[82.5,69.1069588029557],[82.5,68.9791591360619],[82.5522003173828,68.8183288574219],[82.7828826904297,68.7988128662109],[82.8016510009766,68.7408142089844],[83.0427551269531,68.6677551269531],[82.9010925292969,68.6252593994141],[82.6930389404297,68.6327514648438],[82.5899810791016,68.6027679443359],[82.55859375,68.6110992431641],[82.5491485595703,68.6144256591797],[82.5,68.5953562115012],[82.5,68.5613144951015],[82.6805419921875,68.4913635253906],[82.7124938964844,68.4044342041016],[82.6844177246094,68.3463745117188],[82.7066497802734,68.2933197021484],[82.5736083984375,68.2558288574219],[82.5233154296875,68.2069396972656],[82.5435943603516,68.1727600097656],[82.5,68.1741227469784],[82.5,67.5],[82.5,69.8816528320312],[82.5,69.3460998535156],],
			},
		},
		# Grid 6:6 ; 2 records
		"6" => {
			"381" => {
				"z" => "Etc/GMT+7",
				"c" => "ESRI",
				"s" => "22,1",
				"p" => [[84.9777679443359,82.5],[82.5,82.5],[82.5,83.3787299497128],[97.5,83.3941632710458],[97.5,82.5],[86.5058288574219,82.5],[84.9777679443359,82.5],],
			},
			"567" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,1",
				"p" => [[82.5271606445312,90],[82.5271606445312,87.886962890625],[82.5,87.8756886595155],[82.5,90],[82.5271606445312,90],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
