package File::Format::CRD;

use warnings;
use strict;

use 5.008;

=head1 NAME

File::Format::CRD - Distribution for reading the Windows CRD format.

=head1 VERSION

Version 0.0.3

=cut

use vars qw($VERSION);

$VERSION = '0.0.3';


=head1 SYNOPSIS

See L<File::Format::CRD::Reader> .

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc File::Format::CRD


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=File-Format-CRD>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/File-Format-CRD>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/File-Format-CRD>

=item * Search CPAN

L<http://search.cpan.org/dist/File-Format-CRD/>

=back


=head1 ACKNOWLEDGEMENTS

This module is based on L<http://ihaa.com/english/crd2html.html> by
ihaa.com.

=head1 COPYRIGHT & LICENSE

Copyright 2010 Shlomi Fish.

This program is distributed under the MIT (X11) License:
L<http://www.opensource.org/licenses/mit-license.php>

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.


=cut

1; # End of File::Format::CRD
