# Generated by default/object.tt
package Paws::LexModelsV2::ImageResponseCard;
  use Moose;
  has Buttons => (is => 'ro', isa => 'ArrayRef[Paws::LexModelsV2::Button]', request_name => 'buttons', traits => ['NameInRequest']);
  has ImageUrl => (is => 'ro', isa => 'Str', request_name => 'imageUrl', traits => ['NameInRequest']);
  has Subtitle => (is => 'ro', isa => 'Str', request_name => 'subtitle', traits => ['NameInRequest']);
  has Title => (is => 'ro', isa => 'Str', request_name => 'title', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::ImageResponseCard

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::ImageResponseCard object:

  $service_obj->Method(Att1 => { Buttons => $value, ..., Title => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::ImageResponseCard object:

  $result = $service_obj->Method(...);
  $result->Att1->Buttons

=head1 DESCRIPTION

A card that is shown to the user by a messaging platform. You define
the contents of the card, the card is displayed by the platform.

When you use a response card, the response from the user is constrained
to the text associated with a button on the card.

=head1 ATTRIBUTES


=head2 Buttons => ArrayRef[L<Paws::LexModelsV2::Button>]

A list of buttons that should be displayed on the response card. The
arrangement of the buttons is determined by the platform that displays
the button.


=head2 ImageUrl => Str

The URL of an image to display on the response card. The image URL must
be publicly available so that the platform displaying the response card
has access to the image.


=head2 Subtitle => Str

The subtitle to display on the response card. The format of the
subtitle is determined by the platform displaying the response card.


=head2 B<REQUIRED> Title => Str

The title to display on the response card. The format of the title is
determined by the platform displaying the response card.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

