package Bio::FastParsers::Blast::Xml::Hit;
# ABSTRACT: NCBI BLAST DTD-derived internal class
$Bio::FastParsers::Blast::Xml::Hit::VERSION = '0.213510';
use Moose;
use namespace::autoclean;

# AUTOGENERATED CODE! DO NOT MODIFY THIS FILE!

use XML::Bare qw(forcearray);

use aliased 'Bio::FastParsers::Blast::Xml::Hsp';


# private attributes

has '_root' => (
    is       => 'ro',
    isa      => 'HashRef',
    required => 1,
);

has '_parent' => (
    is       => 'ro',
    isa      => 'Maybe[Object]',
    required => 1,
);


# public array(s) of composed objects


has 'hsps' => (
    traits   => ['Array'],
    is       => 'ro',
    isa      => 'ArrayRef[Bio::FastParsers::Blast::Xml::Hsp]',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_hsps',
    handles  => {
        count_hsps => 'count',
          all_hsps => 'elements',
          get_hsp  => 'get',
         next_hsp  => 'shift',
    },
);

## no critic (ProhibitUnusedPrivateSubroutines)

sub _build_hsps {
    my $self = shift;
    return [ map { Hsp->new( _root => $_, _parent => $self ) } @{
        forcearray $self->_root->{'Hit_hsps'}->{'Hsp'}
    } ];
}

## use critic



# public composed object(s)


# public methods


sub accession {
    return shift->_root->{'Hit_accession'}->{'value'}
}


sub def {
    return shift->_root->{'Hit_def'}->{'value'}
}


sub id {
    return shift->_root->{'Hit_id'}->{'value'}
}


sub len {
    return shift->_root->{'Hit_len'}->{'value'}
}


sub num {
    return shift->_root->{'Hit_num'}->{'value'}
}


# public aliases



sub query_len {
    return shift->_parent->query_len
}


__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=head1 NAME

Bio::FastParsers::Blast::Xml::Hit - NCBI BLAST DTD-derived internal class

=head1 VERSION

version 0.213510

=head1 SYNOPSIS

    # see Bio::FastParsers::Blast::Xml

=head1 DESCRIPTION

This class implements the C<Hit> level of the XML BLAST parser.

=head1 ATTRIBUTES

=head2 hsps

ArrayRef of L<Bio::FastParsers::Blast::Xml::Hsp>

=head1 METHODS

=head2 count_hsps

Returns the number of Hsps of the Hit.

    # $hit is a Bio::FastParsers::Blast::Xml::Hit
    my $count = $hit->count_hsps;

This method does not accept any arguments.

=head2 all_hsps

Returns all the Hsps of the Hit (not an array reference).

    # $hit is a Bio::FastParsers::Blast::Xml::Hit
    my @hsps = $hit->all_hsps;

This method does not accept any arguments.

=head2 get_hsp

Returns one Hsp of the Hit by its index. You can also use
negative index numbers, just as with Perl's core array handling. If the
specified Hsp does not exist, this method will return C<undef>.

    # $hit is a Bio::FastParsers::Blast::Xml::Hit
    my $hsp = $hit->get_hsp($index);
    croak "Hsp $index not found!" unless defined $hsp;

This method accepts just one argument (and not an array slice).

=head2 next_hsp

Shifts the first Hsp of the array off and returns it, shortening the
array by 1 and moving everything down. If there are no more Hsps in
the array, returns C<undef>.

    # $hit is a Bio::FastParsers::Blast::Xml::Hit
    while (my $hsp = $hit->next_hsp) {
        # process $hsp
        # ...
    }

This method does not accept any arguments.

=head2 accession

Returns the value of the element C<<Hit_accession>>.

    # $hit is a Bio::FastParsers::Blast::Xml::Hit
    my $accession = $hit->accession;

This method does not accept any arguments.

=head2 def

Returns the value of the element C<<Hit_def>>.

    # $hit is a Bio::FastParsers::Blast::Xml::Hit
    my $def = $hit->def;

This method does not accept any arguments.

=head2 id

Returns the value of the element C<<Hit_id>>.

    # $hit is a Bio::FastParsers::Blast::Xml::Hit
    my $id = $hit->id;

This method does not accept any arguments.

=head2 len

Returns the value of the element C<<Hit_len>>.

    # $hit is a Bio::FastParsers::Blast::Xml::Hit
    my $len = $hit->len;

This method does not accept any arguments.

=head2 num

Returns the value of the element C<<Hit_num>>.

    # $hit is a Bio::FastParsers::Blast::Xml::Hit
    my $num = $hit->num;

This method does not accept any arguments.

=head1 ALIASES

=head2 query_len

Alias for C<query_len> method in Iteration object. For API completeness.

=head1 AUTHOR

Denis BAURAIN <denis.baurain@uliege.be>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by University of Liege / Unit of Eukaryotic Phylogenomics / Denis BAURAIN.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
