#!/usr/bin/perl
package Geo::CountryFlags::URLs;

################################################################
# WARNING! this module is automatically generated DO NOT EDIT! #
#            see Geo::CountryFlags::Util instead               #
#                                                              #
# creation date:  Sat Sep 16 02:32:24 2006 GMT	               #
################################################################

use strict;
use vars qw($VERSION);
$VERSION = '2006258.001';

my $URLs = {
    'CIA' => q|https://www.cia.gov/cia/publications/factbook/docs/flagsoftheworld.html|,
    'CIAFLAGS' => q|https://www.cia.gov/cia/publications/factbook/flags/|,
    'ISO' => q|http://www.iso.org/iso/en/prods-services/iso3166ma/02iso-3166-code-lists/list-en1-semic.txt|,
};

sub AUTOLOAD {
  no strict;
  $AUTOLOAD =~ /[^:]+$/;
  value($&);
}

sub new {
  my $proto = shift;
  my $class = ref $proto || $proto || __PACKAGE__;
  my $self = {};
  bless $self, $class;
}

sub hashptr {
  my($proto,$class) = @_;
  $proto = $class if $class;
  $class = ref $proto || $proto;
  my $rv = {};
  %$rv = %$URLs;
  bless $rv, $class;
}

sub value {
  return (exists $URLs->{$_[0]}) ? $URLs->{$_[0]} : undef;
}

sub subref {
  return \&value;
}

1;
__END__

=pod

Geo::CountryFlags::URLs is autogenerated by Makefile.PL

Last updated Sat Sep 16 02:32:24 2006 GMT

=head1 NAME

Geo::CountryFlags::URLs::URLs - hash to map values

=head1 SYNOPSIS

Geo::CountryFlags::URLs provides a variety of methods and functions to lookup values
either as hash-like constants (recommended) or directly from a hash array.

    require $Geo::CountryFlags::URLs;
    my $gcu = new Geo::CountryFlags::URLs;
    $value = $gcu->KEY;

  Perl 5.6 or greater can use syntax
    $value = $gcu->$key;

  or
    $subref = subref Geo::CountryFlags::URLs;
    $value = $subref->($key);
    $value = &$subref($key);

  or
    $value = value Geo::CountryFlags::URLs($key);
    Geo::CountryFlags::URLs->value($key);

  to return a reference to the map directly

  $hashref = hashptr Geo::CountryFlags::URLs($class);
  $value = $hashref->{$key};

=head1 DESCRIPTION

Geo::CountryFlags::URLs maps URLs values.

Values may be returned directly by designating the KEY as a method or
subroutine of the form:

    $value = Geo::CountryFlags::URLs::KEY;
    $value = Geo::CountryFlags::URLs->KEY;
  or in Perl 5.6 and above
    $value = Geo::CountryFlags::URLs->$key;
  or
    $gcu = new Geo::CountryFlags::URLs;
    $value = $gcu->KEY;
  or in Perl 5.6 and above
    $value= =  $gcu->$key;

=over 4

=item * $gcu = new Geo::CountryFlags::URLs;

Return a reference to the modules in this package.

=item * $hashptr = hashptr Geo::CountryFlags::URLs($class);

Return a blessed reference to a copy of the hash in this package.

  input:	[optional] class or class ref
  returns:	a reference blessed into $class
		if $class is present otherwise
		blessed into Geo::CountryFlags::URLs

=item * $value = value Geo::CountryFlags::URLs($key);

=item * $value = $gcu->value($key);

Return the value in the map hash or undef if it does not exist.

=item * $subref = subref Geo::CountryFlags::URLs;

=item * $subref = $gcu->subref;

Return a subroutine reference that will return the value of a key or undef
if the key is not present.

  $value = $subref->($key);
  $value = &$subref($key);

=back

=head1 EXPORTs

Nothing

=head1 AUTHOR 

Michael Robinton michael@bizsystems.com

=head1 COPYRIGHT and LICENSE

  Copyright 2006 Michael Robinton, michael@bizsystems.com

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free Software 
Foundation; either version 1, or (at your option) any later version,

This program is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of  
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See either
the GNU General Public License or the Artistic License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

=head1 SEE ALSO

L<Geo::CountryFlags::Util>

=cut

1;
