# Generated by default/object.tt
package Paws::RedShift::AquaConfiguration;
  use Moose;
  has AquaConfigurationStatus => (is => 'ro', isa => 'Str');
  has AquaStatus => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::RedShift::AquaConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::RedShift::AquaConfiguration object:

  $service_obj->Method(Att1 => { AquaConfigurationStatus => $value, ..., AquaStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::RedShift::AquaConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AquaConfigurationStatus

=head1 DESCRIPTION

The AQUA (Advanced Query Accelerator) configuration of the cluster.

=head1 ATTRIBUTES


=head2 AquaConfigurationStatus => Str

The value represents how the cluster is configured to use AQUA.
Possible values include the following.

=over

=item *

enabled - Use AQUA if it is available for the current AWS Region and
Amazon Redshift node type.

=item *

disabled - Don't use AQUA.

=item *

auto - Amazon Redshift determines whether to use AQUA.

=back



=head2 AquaStatus => Str

The value indicates the status of AQUA on the cluster. Possible values
include the following.

=over

=item *

enabled - AQUA is enabled.

=item *

disabled - AQUA is not enabled.

=item *

applying - AQUA status is being applied.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::RedShift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

