# Generated by default/object.tt
package Paws::ApplicationMigration::JobLogEventData;
  use Moose;
  has ConversionServerID => (is => 'ro', isa => 'Str', request_name => 'conversionServerID', traits => ['NameInRequest']);
  has RawError => (is => 'ro', isa => 'Str', request_name => 'rawError', traits => ['NameInRequest']);
  has SourceServerID => (is => 'ro', isa => 'Str', request_name => 'sourceServerID', traits => ['NameInRequest']);
  has TargetInstanceID => (is => 'ro', isa => 'Str', request_name => 'targetInstanceID', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationMigration::JobLogEventData

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationMigration::JobLogEventData object:

  $service_obj->Method(Att1 => { ConversionServerID => $value, ..., TargetInstanceID => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationMigration::JobLogEventData object:

  $result = $service_obj->Method(...);
  $result->Att1->ConversionServerID

=head1 DESCRIPTION

Job log data

=head1 ATTRIBUTES


=head2 ConversionServerID => Str

Job Event conversion Server ID.


=head2 RawError => Str

Job error.


=head2 SourceServerID => Str

Job Event Source Server ID.


=head2 TargetInstanceID => Str

Job Event Target instance ID.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationMigration>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

